An [`async`] function used recursion without boxing.

Erroneous code example:

```edition2018,compile_fail,E0733
async fn foo(n: usize) {
    if n > 0 {
        foo(n - 1).await;
    }
}
```

The recursive invocation can be boxed:

```edition2018
async fn foo(n: usize) {
    if n > 0 {
        Box::pin(foo(n - 1)).await;
    }
}
```

The `Box<...>` ensures that the result is of known size, and the pin is
required to keep it in the same place in memory.

Alternatively, the body can be boxed:

```edition2018
use std::future::Future;
use std::pin::Pin;
fn foo(n: usize) -> Pin<Box<dyn Future<Output = ()>>> {
    Box::pin(async move {
        if n > 0 {
            foo(n - 1).await;
        }
    })
}
```

[`async`]: https://doc.rust-lang.org/std/keyword.async.html
