A cast between a thin and a fat pointer was attempted.

Erroneous code example:

```compile_fail,E0607
let v = core::ptr::null::<u8>();
v as *const [u8];
```

First: what are thin and fat pointers?

Thin pointers are "simple" pointers: they are purely a reference to a memory
address.

Fat pointers are pointers referencing Dynamically Sized Types (also called
DSTs). DSTs don't have a statically known size, therefore they can only exist
behind some kind of pointer that contains additional information. For example,
slices and trait objects are DSTs. In the case of slices, the additional
information the fat pointer holds is their size.

To fix this error, don't try to cast directly between thin and fat pointers.

For more information about type casts, take a look at the section of the
[The Rust Reference][1] on type cast expressions.

[1]: https://doc.rust-lang.org/reference/expressions/operator-expr.html#type-cast-expressions
