#!/bin/sh -e
# Repackaging script to be called by Uscan

echo "Repackaging ..."
TMP="../"
PKG="`dpkg-parsechangelog|sed 's/^Source: //p;d'`_$2+repack.orig"


echo "Extracting tarball ..."
tar xzf "$3" -C "$TMP"
cd "$TMP"

echo "Rename source dir"
#ls -l
mv scons-src-$2 scons-doc-$2

echo "Removing unwanted stuff ..."
cd scons-doc-$2
#mv scons-src-$2 scons-doc-$2
#cd scons-doc-$2
ls -l
rm -rf HOWTO
rm -rf debian
rm -rf bench
rm -rf examples
rm -rf gentoo
rm -rf rpm
rm -rf template
rm -rf test
rm -rf testing
rm -rf timings
rm -rf .hgtags
rm -rf *-local
rm -rf ReleaseConfig
rm -rf runtest.py
ls -l
#cd ..

echo "Creating repack tarball ..."
tar -caf "../scons-doc_$2+repack.orig.tar.xz" *

cd ..
echo "Clean tmp dir ..."
rm -rf scons-doc-$2

echo "Clean uscan files ..."
rm -rf scons-src-2.3.5.tar.gz
rm -rf scons-doc_2.3.5.orig.tar.gz

echo "Repackaged tarball created"
