/* Copyright 2004,2007 ENSEIRB, INRIA & CNRS
**
** This file is part of the Scotch software package for static mapping,
** graph partitioning and sparse matrix ordering.
**
** This software is governed by the CeCILL-C license under French law
** and abiding by the rules of distribution of free software. You can
** use, modify and/or redistribute the software under the terms of the
** CeCILL-C license as circulated by CEA, CNRS and INRIA at the following
** URL: "http://www.cecill.info".
**
** As a counterpart to the access to the source code and rights to copy,
** modify and redistribute granted by the license, users are provided
** only with a limited warranty and the software's author, the holder of
** the economic rights, and the successive licensors have only limited
** liability.
**
** In this respect, the user's attention is drawn to the risks associated
** with loading, using, modifying and/or developing or reproducing the
** software by the user in light of its specific status of free software,
** that may mean that it is complicated to manipulate, and that also
** therefore means that it is reserved for developers and experienced
** professionals having in-depth computer knowledge. Users are therefore
** encouraged to load and test the software's suitability as regards
** their requirements in conditions enabling the security of their
** systems and/or data to be ensured and, more generally, to use and
** operate it in the same conditions as regards security.
**
** The fact that you are presently reading this means that you have had
** knowledge of the CeCILL-C license and that you accept its terms.
*/
/************************************************************/
/**                                                        **/
/**   NAME       : library_errcom.c                        **/
/**                                                        **/
/**   AUTHOR     : Francois PELLEGRINI                     **/
/**                                                        **/
/**   FUNCTION   : This module redirects the errors        **/
/**                generated by the routines of the        **/
/**                libSCOTCH library to the standard       **/
/**                error processing routines.              **/
/**                                                        **/
/**   DATES      : # Version 3.3  : from : 06 oct 1998     **/
/**                                 to   : 13 oct 1998     **/
/**                # Version 3.4  : from : 01 nov 2001     **/
/**                                 to   : 01 nov 2001     **/
/**                                                        **/
/************************************************************/

/*
**  The defines and includes.
*/

#define LIBRARY_ERRCOM
#ifndef SCOTCH_COMMON_EXTERNAL
#define SCOTCH_COMMON_EXTERNAL                    /* Do not redefine errorPrint */
#endif /* SCOTCH_COMMON_EXTERNAL */

#include "module.h"
#include "common.h"
#include "scotch.h"

/********************************/
/*                              */
/* The error handling routines. */
/*                              */
/********************************/

/* This routine prints an error message with
** a variable number of arguments, as printf ()
** does, and exits.
** It returns:
** - EXIT  : in all cases.
*/

void
SCOTCH_errorPrint (
const char * const          errstr,               /*+ printf-like variable argument list */
...)
{
  va_list             errlist;                    /* Argument list of the call */
  char                errbuf[1024];               /* Error buffer              */

  va_start   (errlist, errstr);                   /* Open variable-argument list  */
#if ((defined X_ARCHi586_pc_linux2) || (defined X_ARCHi686_pc_linux2))
  vsnprintf  (errbuf, 1023, errstr, errlist);     /* Write result to buffer       */
#else
  vsprintf   (errbuf, errstr, errlist);           /* Write result to buffer       */
#endif /* X_ARCHi586_pc_linux2 */
  va_end     (errlist);                           /* Close variable-argument list */
  errbuf[1023] = '\0';                            /* Set end of string            */
  errorPrint (errbuf);                            /* Print arguments              */

  exit       (1);
}

/* This routine prints a warning message with
** a variable number of arguments, as printf ()
** does.
** It returns:
** - VOID  : in all cases.
*/

void
SCOTCH_errorPrintW (
const char * const          errstr,               /*+ printf-like variable argument list */
...)
{
  va_list             errlist;                    /* Argument list of the call */
  char                errbuf[1024];               /* Error buffer              */

  va_start    (errlist, errstr);                  /* Open variable-argument list  */
#if ((defined X_ARCHi586_pc_linux2) || (defined X_ARCHi686_pc_linux2))
  vsnprintf   (errbuf, 1023, errstr, errlist);    /* Write result to buffer       */
#else
  vsprintf    (errbuf, errstr, errlist);          /* Write result to buffer       */
#endif /* X_ARCHi586_pc_linux2 */
  va_end      (errlist);                          /* Close variable-argument list */
  errbuf[1023] = '\0';                            /* Set end of string            */
  errorPrintW (errbuf);                           /* Print arguments              */
}
