/* ScummVM Tools
 *
 * ScummVM Tools is the legal property of its developers, whose
 * names are too numerous to list here. Please refer to the
 * COPYRIGHT file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef GUI_CONFIGURATION_H
#define GUI_CONFIGURATION_H

#include <wx/filename.h>

#include "compress.h"	// for AudioFormat

class ToolGUI;

/**
 * Current state of the wizard
 */
struct Configuration {
	Configuration();
	~Configuration();

	/**
	 * Fills this config object with values loaded from the permanent storage method
	 */
	void load();

	/**
	 * Saves configuration to a more permanent storage
	 * (registry under unix, .ini like file under other OSes)
	 *
	 * @param all True if all parameters should be saved, including audio parameters.
	 */
	void save(bool all = true);

	/**
	 * Returns a list of all supported (as in, we have some defaults for it) platforms
	 */
	static wxArrayString getTargetPlatforms();

	/**
	 * Sets all the compression members to default values based on the 'selectedPlatform' member
	 */
	void setPlatformDefaults();

	/**
	 * Utility functions that test the given lame path.
	 *
	 * @return false indicate that the given lame path does not point to a valid lame executable.
	 */
	static bool isLamePathValid(const wxString& mp3LamePath);

	// While prepending with _ would be in line with the coding conventions
	// this class is just a glorified map with different types, so it seems
	// unnecessary.

	/** If the user chose the advanced route from the start */
	bool advanced;
	/** true if the user chose to compress, false if extract, undefined if advanced */
	bool compressing;

	/** The platform the output files are going to be used on (compression only) */
	wxString selectedPlatform;
	/** The tool the user chose to use, NULL if none has been chosen yet */
	const ToolGUI *selectedTool;

	/** Input files selected */
	wxArrayString inputFilePaths;
	/** Path to output to */
	wxString outputPath;
	/** run on all files with the same extension **/
	bool multipleRuns;

	/** Audio format selected */
	AudioFormat selectedAudioFormat;
	/** true if the user wants to see the advanced audio options */
	bool advancedAudioSettings;

	// mp3 settings
	wxString mp3LamePath;
	wxString mp3CompressionType;
	wxString mp3MpegQuality;
	wxString mp3ABRBitrate;
	wxString mp3VBRMinBitrate;
	wxString mp3VBRMaxBitrate;
	wxString mp3VBRQuality;

	// flac
	wxString flacCompressionLevel;
	wxString flacBlockSize;

	// flac
	bool useOggQuality;
	wxString oggQuality;
	wxString oggMinBitrate;
	wxString oggAvgBitrate;
	wxString oggMaxBitrate;
};

#endif
