# Generated by Django 4.2.13 on 2024-07-26 06:40

import datetime
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    replaces = [
        ("gestion", "0001_initial"),
        ("gestion", "0002_livresupplement"),
        ("gestion", "0003_livresupplement_commentaire_livre_a_lire"),
        ("gestion", "0004_alter_livre_a_lire_options"),
        ("gestion", "0005_bibliotheque_localisation"),
        ("gestion", "0006_remove_localisation_bib_courriers_memoire_and_more"),
    ]

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Caution",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "numero",
                    models.IntegerField(unique=True, verbose_name="numéro de caution"),
                ),
                ("nom", models.CharField(max_length=50, verbose_name="Nom de l'élève")),
                ("prenom", models.CharField(max_length=25, verbose_name="Prénom")),
                ("date", models.DateField(verbose_name="Date d'inscription à la coop")),
                (
                    "classe",
                    models.CharField(max_length=25, verbose_name="Classe initiale"),
                ),
                (
                    "rendue_le",
                    models.DateField(
                        blank=True,
                        default=datetime.date(1, 1, 1),
                        verbose_name="Rendue le",
                    ),
                ),
                (
                    "somme_payee",
                    models.FloatField(
                        blank=True, default=70, verbose_name="Somme payée"
                    ),
                ),
                (
                    "somme_rendue",
                    models.FloatField(
                        blank=True, default=0, verbose_name="Somme rendue"
                    ),
                ),
                (
                    "commentaire",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=140,
                        verbose_name="Commentaire",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Classes",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                (
                    "code",
                    models.CharField(max_length=25, verbose_name="Code de la Classe"),
                ),
                (
                    "libelle",
                    models.CharField(
                        max_length=25, verbose_name="Libellé de la Classe"
                    ),
                ),
                (
                    "compte",
                    models.IntegerField(
                        blank=True, default=0, null=True, verbose_name="Compte De Noms"
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Classes",
            },
        ),
        migrations.CreateModel(
            name="Commandes",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                ("date", models.CharField(max_length=25, verbose_name="Date")),
                (
                    "commentaire",
                    models.CharField(max_length=25, verbose_name="Commentaire"),
                ),
            ],
            options={
                "verbose_name_plural": "Commandes",
            },
        ),
        migrations.CreateModel(
            name="Disciplines",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                (
                    "libelle",
                    models.CharField(
                        max_length=25, verbose_name="Libellé de la Discipline"
                    ),
                ),
                (
                    "abrege",
                    models.CharField(
                        max_length=25, verbose_name="Abrégé de la Discipline"
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Disciplines",
            },
        ),
        migrations.CreateModel(
            name="Eleves",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                (
                    "sexe",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Sexe"
                    ),
                ),
                (
                    "Eleve_No_Etab",
                    models.IntegerField(
                        blank=True, null=True, unique=True, verbose_name="N° d'Élève"
                    ),
                ),
                (
                    "Num_Eleve_Etab",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        unique=True,
                        verbose_name="N° d'Élève+Étab.",
                    ),
                ),
                (
                    "Nom",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Nom"
                    ),
                ),
                (
                    "Nom_de_famille",
                    models.CharField(max_length=50, verbose_name="Nom de famille"),
                ),
                (
                    "Nom_d_usage",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Nom d'usage"
                    ),
                ),
                ("Prenom", models.CharField(max_length=25, verbose_name="Prénom")),
                (
                    "Prenom_2",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Prénom 2"
                    ),
                ),
                (
                    "Prenom_3",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Prénom 3"
                    ),
                ),
                (
                    "NomPrenomEleve",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="Concaténation du Nom et du Prénom",
                    ),
                ),
                (
                    "sans_accent",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="Nom sans accents",
                    ),
                ),
                (
                    "Date_Naissance",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date de Naissance"
                    ),
                ),
                (
                    "Doublement",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Doublement"
                    ),
                ),
                (
                    "Id_National",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Id National"
                    ),
                ),
                (
                    "Date_Entree",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date d' Entrée"
                    ),
                ),
                (
                    "Date_Sortie",
                    models.DateField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Date de Sortie",
                    ),
                ),
                (
                    "Code_Regime",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Code Régime"
                    ),
                ),
                (
                    "Lib_Regime",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Libellé Régime",
                    ),
                ),
                (
                    "Code_MEF",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Code MEF"
                    ),
                ),
                (
                    "Lib_MEF",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Libellé MEF"
                    ),
                ),
                (
                    "Code_Structure",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Code de Structure",
                    ),
                ),
                (
                    "Type_Structure",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Type Structure",
                    ),
                ),
                (
                    "Lib_Structure",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Libellé Structure",
                    ),
                ),
                (
                    "Cle_Gestion_Mat_Enseignee_1",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Clé Matière Enseignée 1",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_1",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 1",
                    ),
                ),
                (
                    "Cle_Gestion_Mat_Enseignee_2",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Clé Matière Enseignée 2",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_2",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 2",
                    ),
                ),
                (
                    "Cle_Gestion_Mat_Enseignee_3",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Clé Matière Enseignée 3",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_3",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 3",
                    ),
                ),
                (
                    "Cle_Gestion_Mat_Enseignee_4",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Clé Matière Enseignée 4",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_4",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 4",
                    ),
                ),
                (
                    "Cle_Gestion_Mat_Enseignee_5",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Clé Matière Enseignée 5",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_5",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 5",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_6",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 6",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_7",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 7",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_8",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 8",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_9",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 9",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_10",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 10",
                    ),
                ),
                (
                    "Tel_Personnel",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Téléphone Personnel",
                    ),
                ),
                (
                    "Tel_Professionnel",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Téléphone Professionnel",
                    ),
                ),
                (
                    "Tel_Portable",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Téléphone Portable",
                    ),
                ),
                (
                    "Email",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Email"
                    ),
                ),
                (
                    "Adresse",
                    models.TextField(blank=True, null=True, verbose_name="Adresse"),
                ),
                (
                    "Civilite_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Civilité du Représentant Légal",
                    ),
                ),
                (
                    "Nom_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom du Représentant Légal",
                    ),
                ),
                (
                    "Nom_de_famille_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom de famille du Représentant Légal",
                    ),
                ),
                (
                    "Nom_d_usage_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom d'usage du Représentant Légal",
                    ),
                ),
                (
                    "Prenom_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Prénom Représentantant Légal",
                    ),
                ),
                (
                    "ConcaReprLeg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="ConcaReprLég",
                    ),
                ),
                (
                    "Tel_Personnel_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Personnel Repr Lég",
                    ),
                ),
                (
                    "Lien_Parente_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Lien Parenté Repr Lég",
                    ),
                ),
                (
                    "Tel_Portable_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Portable Repr Lég",
                    ),
                ),
                (
                    "Tel_Professionnel_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Professionnel Repr Lég",
                    ),
                ),
                (
                    "Email_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Email Repr Lég",
                    ),
                ),
                (
                    "Communication_Adresse_postale_et_courriel_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Communication Adresse postale et courriel Repr Lég",
                    ),
                ),
                (
                    "Adresse_Repr_Leg",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Adresse du représentant légal",
                    ),
                ),
                (
                    "Civilite_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Civilité Autre Repr Lég",
                    ),
                ),
                (
                    "Nom_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom Autre Repr Lég",
                    ),
                ),
                (
                    "Nom_de_famille_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom de famille Autre Repr Lég",
                    ),
                ),
                (
                    "Nom_d_usage_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom d'usage Autre Repr Lég",
                    ),
                ),
                (
                    "Prenom_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Prénom Autre Repr Lég",
                    ),
                ),
                (
                    "ConcaAutreReprLeg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="ConcaAutreReprLég",
                    ),
                ),
                (
                    "Tel_Personnel_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Personnel Autre Repr Lég",
                    ),
                ),
                (
                    "Lien_Parente_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Lien Parenté Autre Repr Lég",
                    ),
                ),
                (
                    "Tel_Portable_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Portable Autre Repr Lég",
                    ),
                ),
                (
                    "Tel_Professionnel_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Professionnel Autre Repr Lég",
                    ),
                ),
                (
                    "Email_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Email Autre Repr Lég",
                    ),
                ),
                (
                    "Communication_Adresse_postale_et_courriel_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Communication Adresse postale et courriel Autre Repr Lég",
                    ),
                ),
                (
                    "Adresse_Autre_Repr_Leg",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Adresse d'un autre représentant légal",
                    ),
                ),
                (
                    "date_inscription_coop",
                    models.DateField(
                        blank=True,
                        null=True,
                        verbose_name="Date d'inscription à la coop",
                    ),
                ),
                (
                    "no_caution",
                    models.IntegerField(default=15000, verbose_name="N° de la caution"),
                ),
                (
                    "a_verifier",
                    models.BooleanField(
                        default=True, verbose_name="À vérifier manuellement"
                    ),
                ),
                (
                    "autorisation_provisoire_inscription",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        verbose_name="Autorisation provisoire de s'inscrire",
                    ),
                ),
                (
                    "classes_passees",
                    models.CharField(
                        default="", max_length=50, verbose_name="Classes passées"
                    ),
                ),
                (
                    "classe",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.classes",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Élèves",
            },
        ),
        migrations.CreateModel(
            name="Eleves_de_siecle",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                (
                    "sexe",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Sexe"
                    ),
                ),
                (
                    "Eleve_No_Etab",
                    models.IntegerField(
                        blank=True, null=True, unique=True, verbose_name="N° d'Élève"
                    ),
                ),
                (
                    "Num_Eleve_Etab",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        unique=True,
                        verbose_name="N° d'Élève+Étab.",
                    ),
                ),
                (
                    "Nom",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Nom"
                    ),
                ),
                (
                    "Nom_de_famille",
                    models.CharField(max_length=50, verbose_name="Nom de famille"),
                ),
                (
                    "Nom_d_usage",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Nom d'usage"
                    ),
                ),
                ("Prenom", models.CharField(max_length=25, verbose_name="Prénom")),
                (
                    "Prenom_2",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Prénom 2"
                    ),
                ),
                (
                    "Prenom_3",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Prénom 3"
                    ),
                ),
                (
                    "NomPrenomEleve",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="Concaténation du Nom et du Prénom",
                    ),
                ),
                (
                    "sans_accent",
                    models.CharField(
                        blank=True,
                        max_length=50,
                        null=True,
                        verbose_name="Nom sans accents",
                    ),
                ),
                (
                    "Date_Naissance",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date de Naissance"
                    ),
                ),
                (
                    "Doublement",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Doublement"
                    ),
                ),
                (
                    "Id_National",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Id National"
                    ),
                ),
                (
                    "Date_Entree",
                    models.DateField(
                        blank=True, null=True, verbose_name="Date d' Entrée"
                    ),
                ),
                (
                    "Date_Sortie",
                    models.DateField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Date de Sortie",
                    ),
                ),
                (
                    "Code_Regime",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Code Régime"
                    ),
                ),
                (
                    "Lib_Regime",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Libellé Régime",
                    ),
                ),
                (
                    "Code_MEF",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Code MEF"
                    ),
                ),
                (
                    "Lib_MEF",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Libellé MEF"
                    ),
                ),
                (
                    "Code_Structure",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Code de Structure",
                    ),
                ),
                (
                    "Type_Structure",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Type Structure",
                    ),
                ),
                (
                    "Lib_Structure",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Libellé Structure",
                    ),
                ),
                (
                    "Cle_Gestion_Mat_Enseignee_1",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Clé Matière Enseignée 1",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_1",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 1",
                    ),
                ),
                (
                    "Cle_Gestion_Mat_Enseignee_2",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Clé Matière Enseignée 2",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_2",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 2",
                    ),
                ),
                (
                    "Cle_Gestion_Mat_Enseignee_3",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Clé Matière Enseignée 3",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_3",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 3",
                    ),
                ),
                (
                    "Cle_Gestion_Mat_Enseignee_4",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Clé Matière Enseignée 4",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_4",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 4",
                    ),
                ),
                (
                    "Cle_Gestion_Mat_Enseignee_5",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Clé Matière Enseignée 5",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_5",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 5",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_6",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 6",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_7",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 7",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_8",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 8",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_9",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 9",
                    ),
                ),
                (
                    "Lib_Mat_Enseignee_10",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Matière Enseignée 10",
                    ),
                ),
                (
                    "Tel_Personnel",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Téléphone Personnel",
                    ),
                ),
                (
                    "Tel_Professionnel",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Téléphone Professionnel",
                    ),
                ),
                (
                    "Tel_Portable",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Téléphone Portable",
                    ),
                ),
                (
                    "Email",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Email"
                    ),
                ),
                (
                    "Adresse",
                    models.TextField(blank=True, null=True, verbose_name="Adresse"),
                ),
                (
                    "Civilite_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Civilité du Représentant Légal",
                    ),
                ),
                (
                    "Nom_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom du Représentant Légal",
                    ),
                ),
                (
                    "Nom_de_famille_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom de famille du Représentant Légal",
                    ),
                ),
                (
                    "Nom_d_usage_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom d'usage du Représentant Légal",
                    ),
                ),
                (
                    "Prenom_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Prénom Représentantant Légal",
                    ),
                ),
                (
                    "ConcaReprLeg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="ConcaReprLég",
                    ),
                ),
                (
                    "Tel_Personnel_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Personnel Repr Lég",
                    ),
                ),
                (
                    "Lien_Parente_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Lien Parenté Repr Lég",
                    ),
                ),
                (
                    "Tel_Portable_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Portable Repr Lég",
                    ),
                ),
                (
                    "Tel_Professionnel_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Professionnel Repr Lég",
                    ),
                ),
                (
                    "Email_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Email Repr Lég",
                    ),
                ),
                (
                    "Communication_Adresse_postale_et_courriel_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Communication Adresse postale et courriel Repr Lég",
                    ),
                ),
                (
                    "Adresse_Repr_Leg",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Adresse du représentant légal",
                    ),
                ),
                (
                    "Civilite_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Civilité Autre Repr Lég",
                    ),
                ),
                (
                    "Nom_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom Autre Repr Lég",
                    ),
                ),
                (
                    "Nom_de_famille_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom de famille Autre Repr Lég",
                    ),
                ),
                (
                    "Nom_d_usage_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom d'usage Autre Repr Lég",
                    ),
                ),
                (
                    "Prenom_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Prénom Autre Repr Lég",
                    ),
                ),
                (
                    "ConcaAutreReprLeg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="ConcaAutreReprLég",
                    ),
                ),
                (
                    "Tel_Personnel_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Personnel Autre Repr Lég",
                    ),
                ),
                (
                    "Lien_Parente_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Lien Parenté Autre Repr Lég",
                    ),
                ),
                (
                    "Tel_Portable_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Portable Autre Repr Lég",
                    ),
                ),
                (
                    "Tel_Professionnel_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Tél Professionnel Autre Repr Lég",
                    ),
                ),
                (
                    "Email_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Email Autre Repr Lég",
                    ),
                ),
                (
                    "Communication_Adresse_postale_et_courriel_Autre_Repr_Leg",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Communication Adresse postale et courriel Autre Repr Lég",
                    ),
                ),
                (
                    "Adresse_Autre_Repr_Leg",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Adresse d'un autre représentant légal",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Élèves_de_siecle",
            },
        ),
        migrations.CreateModel(
            name="Filieres",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                (
                    "nom",
                    models.CharField(max_length=25, verbose_name="Nom de la Filière"),
                ),
            ],
            options={
                "verbose_name_plural": "Filières",
            },
        ),
        migrations.CreateModel(
            name="Inventaire",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                (
                    "Date_Achat_Materiel",
                    models.DateField(verbose_name="Date d'Achat du Materiel"),
                ),
                (
                    "NumeroDeSerie",
                    models.CharField(max_length=25, verbose_name="Numero de Série"),
                ),
                ("Perdu", models.BooleanField(default=False, verbose_name="Perdu")),
                (
                    "pilon",
                    models.DateField(
                        default=datetime.date(1, 1, 1), verbose_name="Mis au pilon, le"
                    ),
                ),
                (
                    "Etat_Materiel",
                    models.IntegerField(
                        choices=[
                            (1, "Neuf"),
                            (2, "Bon"),
                            (3, "Passable"),
                            (4, "Mauvais"),
                            (5, "Très Mauvais"),
                            (6, "Incomplet"),
                            (0, "Autre"),
                        ],
                        default=0,
                        verbose_name="État du matériel",
                    ),
                ),
                (
                    "a_imprimer",
                    models.BooleanField(default=True, verbose_name="à imprimer"),
                ),
            ],
            options={
                "verbose_name_plural": "Inventaire",
            },
        ),
        migrations.CreateModel(
            name="Jeton",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("duree", models.IntegerField(verbose_name="Durée en secondes")),
                (
                    "perime",
                    models.DateTimeField(
                        default=datetime.datetime(
                            2000, 12, 31, 23, 0, tzinfo=datetime.timezone.utc
                        ),
                        verbose_name="Périmé après",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Niveaux",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                (
                    "libelle",
                    models.CharField(max_length=25, verbose_name="Libellé du Niveau"),
                ),
                (
                    "abrege",
                    models.CharField(max_length=25, verbose_name="Abrégé du Niveau"),
                ),
                (
                    "rang",
                    models.CharField(max_length=25, verbose_name="Rang du Niveau"),
                ),
            ],
            options={
                "verbose_name_plural": "Niveaux",
            },
        ),
        migrations.CreateModel(
            name="Personnels",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("civilite", models.CharField(max_length=25, verbose_name="Civilité")),
                (
                    "nom",
                    models.CharField(
                        max_length=25, verbose_name="Nom de l'Accompagnateur"
                    ),
                ),
                (
                    "prenom",
                    models.CharField(
                        max_length=25, verbose_name="Prénom de l'Accompagnateur"
                    ),
                ),
                (
                    "nomprenom",
                    models.CharField(
                        max_length=25,
                        verbose_name="Concaténation du Nom et du Prénom de l'Accompagnateur",
                    ),
                ),
                (
                    "tel",
                    models.CharField(
                        max_length=25, verbose_name="Téléphone du Domicile"
                    ),
                ),
                (
                    "mobile",
                    models.CharField(
                        max_length=25, verbose_name="Mobile de l'Accompagnateur"
                    ),
                ),
                (
                    "courriel_pro",
                    models.CharField(
                        max_length=25,
                        verbose_name="Courriel professionnel de l'accompagnateur",
                    ),
                ),
                (
                    "courriel_perso",
                    models.CharField(
                        max_length=25,
                        verbose_name="Courriel personnel de l'accompagnateur",
                    ),
                ),
                (
                    "discipline",
                    models.CharField(max_length=25, verbose_name="Discipline"),
                ),
            ],
            options={
                "verbose_name_plural": "Accompagnateurs",
            },
        ),
        migrations.CreateModel(
            name="Series",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                (
                    "libelle_court",
                    models.CharField(
                        max_length=25, verbose_name="Libellé Court de la Série"
                    ),
                ),
                (
                    "libelle_long",
                    models.CharField(
                        max_length=25, verbose_name="Libellé Long de la Série"
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Séries",
            },
        ),
        migrations.CreateModel(
            name="TypeMateriel",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                (
                    "libelle_long",
                    models.CharField(
                        max_length=25, verbose_name="Libellé Long du Type de Matériel"
                    ),
                ),
                (
                    "libelle_court",
                    models.CharField(
                        max_length=25, verbose_name="Libellé Court du Type de Matériel"
                    ),
                ),
                (
                    "Tarif_Perdu",
                    models.CharField(
                        max_length=25, verbose_name="Tarif pour une perte"
                    ),
                ),
                (
                    "Tarif_Degradation",
                    models.CharField(
                        max_length=25, verbose_name="Tarif pour une dégradation"
                    ),
                ),
                (
                    "Choix_Tarif_Degradation",
                    models.BooleanField(
                        verbose_name="Appliquer le tarif de dégradation"
                    ),
                ),
                (
                    "Appliquer_Demi_Tarif",
                    models.BooleanField(verbose_name="Appliquer un demi-tarif"),
                ),
            ],
            options={
                "verbose_name_plural": "Types de matériel",
            },
        ),
        migrations.CreateModel(
            name="Prets",
            fields=[
                (
                    "id",
                    models.IntegerField(
                        primary_key=True, serialize=False, verbose_name="index"
                    ),
                ),
                ("date_pret", models.DateField(verbose_name="Date de prêt")),
                (
                    "date_retour",
                    models.DateField(
                        blank=True,
                        default=datetime.date(1, 1, 1),
                        max_length=25,
                        verbose_name="Date de retour",
                    ),
                ),
                (
                    "Date_Declaration_Perte",
                    models.DateField(
                        blank=True,
                        default=datetime.date(1, 1, 1),
                        max_length=25,
                        verbose_name="Date de déclaration de la perte",
                    ),
                ),
                (
                    "Etat_Initial",
                    models.IntegerField(
                        choices=[
                            (1, "Neuf"),
                            (2, "Bon"),
                            (3, "Passable"),
                            (4, "Mauvais"),
                            (5, "Très Mauvais"),
                            (6, "Incomplet"),
                            (0, "Autre"),
                        ],
                        default=0,
                        null=True,
                        verbose_name="État Initial",
                    ),
                ),
                (
                    "Etat_Final",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (1, "Neuf"),
                            (2, "Bon"),
                            (3, "Passable"),
                            (4, "Mauvais"),
                            (5, "Très Mauvais"),
                            (6, "Incomplet"),
                            (0, "Autre"),
                        ],
                        default=0,
                        verbose_name="État Final",
                    ),
                ),
                ("Remise", models.FloatField(default=0, verbose_name="Remise")),
                (
                    "accompagnateur",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.personnels",
                    ),
                ),
                (
                    "eleve",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.eleves",
                    ),
                ),
                (
                    "inventaire",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.inventaire",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Prêts",
            },
        ),
        migrations.CreateModel(
            name="Parametres",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "NomAcademie",
                    models.CharField(max_length=25, verbose_name="Nom de l'Académie"),
                ),
                (
                    "NomEts",
                    models.CharField(
                        max_length=25, verbose_name="Nom de l'Établissement"
                    ),
                ),
                ("CodeRNE", models.CharField(max_length=25, verbose_name="Code RNE")),
                ("Commune", models.CharField(max_length=25, verbose_name="Commune")),
                (
                    "Titre_ChefEts",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Titre du Chef d'Établissement",
                    ),
                ),
                (
                    "Civilite_ChefEts",
                    models.CharField(
                        max_length=25, verbose_name="Civilité du Chef d'Établissement"
                    ),
                ),
                (
                    "NomChefEts",
                    models.CharField(
                        max_length=25, verbose_name="Nom du Chef d'Établissement"
                    ),
                ),
                (
                    "Civilite_AgentComptable",
                    models.CharField(
                        max_length=25, verbose_name="Civilité de l'Agent Comptable"
                    ),
                ),
                (
                    "NomAgentComptable",
                    models.CharField(
                        max_length=25, verbose_name="Nom de l'Agent Comptable"
                    ),
                ),
                (
                    "EtsSupportAgence",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Agence de support de l'établissement",
                    ),
                ),
                (
                    "IBAN",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="IBAN"
                    ),
                ),
                (
                    "BIC",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="BIC"
                    ),
                ),
                (
                    "Titre_Gestionnaire",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Titre  du Gestionnaire",
                    ),
                ),
                (
                    "Civilite_Gestionnaire",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Civilité du Gestionnaire",
                    ),
                ),
                (
                    "NomGestionnaire",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom du Gestionnaire",
                    ),
                ),
                (
                    "CoordoneesIntendance",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Coordonnées de l'Intendance",
                    ),
                ),
                (
                    "Version_Application",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Version de l'Application",
                    ),
                ),
                (
                    "AnneeScolaire",
                    models.CharField(max_length=25, verbose_name="Année Scolaire"),
                ),
                (
                    "AnneeScolaireEnPreparation",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Année Scolaire En Préparation",
                    ),
                ),
                ("Adresse", models.CharField(max_length=25, verbose_name="Adresse")),
                (
                    "CodePostal",
                    models.CharField(max_length=25, verbose_name="Code Postal"),
                ),
                (
                    "Telephone",
                    models.CharField(max_length=25, verbose_name="Téléphone"),
                ),
                (
                    "Fax",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Fax"
                    ),
                ),
                (
                    "SiteWeb",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Site Web"
                    ),
                ),
                (
                    "Nom_Assistant_social",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Nom de l'Assistant social",
                    ),
                ),
                (
                    "Civilite_Assistant_social",
                    models.CharField(
                        blank=True,
                        max_length=25,
                        null=True,
                        verbose_name="Civilité de l'Assistant social",
                    ),
                ),
                (
                    "Logo",
                    models.ImageField(
                        blank=True, null=True, upload_to="./media", verbose_name="Logo"
                    ),
                ),
                (
                    "signature",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="signature"
                    ),
                ),
            ],
            options={
                "verbose_name": "Paramètres",
                "verbose_name_plural": "Paramètres",
                "unique_together": {("CodeRNE", "AnneeScolaire")},
            },
        ),
        migrations.CreateModel(
            name="Materiel",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                (
                    "titre",
                    models.CharField(max_length=50, verbose_name="Titre (ou nom)"),
                ),
                (
                    "editeur",
                    models.CharField(max_length=25, verbose_name="Editeur ou Marque"),
                ),
                (
                    "Prix",
                    models.CharField(
                        blank=True,
                        max_length=15,
                        null=True,
                        verbose_name="Prix du Materiel",
                    ),
                ),
                (
                    "Annee_Depot_Legal",
                    models.CharField(
                        blank=True,
                        max_length=5,
                        null=True,
                        verbose_name="Année du Dépôt Légal",
                    ),
                ),
                ("ISBN", models.CharField(max_length=25, verbose_name="ISBN")),
                (
                    "Collection",
                    models.CharField(
                        blank=True, max_length=25, null=True, verbose_name="Collection"
                    ),
                ),
                (
                    "Auteurs",
                    models.TextField(blank=True, null=True, verbose_name="Auteurs"),
                ),
                (
                    "Serie_loc",
                    models.CharField(
                        blank=True,
                        max_length=10,
                        null=True,
                        verbose_name="Série (locale)",
                    ),
                ),
                (
                    "Option",
                    models.CharField(
                        blank=True, max_length=10, null=True, verbose_name="Option"
                    ),
                ),
                (
                    "Pretes",
                    models.IntegerField(
                        blank=True, null=True, verbose_name="nombre de manuels prêtés"
                    ),
                ),
                (
                    "Achetes",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        verbose_name="nombre de manuels total achetés",
                    ),
                ),
                (
                    "Perdus",
                    models.IntegerField(
                        blank=True, null=True, verbose_name="nombre de manuels perdus"
                    ),
                ),
                (
                    "epaisseur_mm",
                    models.IntegerField(default=15, verbose_name="épaisseur en mm"),
                ),
                (
                    "largeur_cm",
                    models.IntegerField(default=20, verbose_name="largeur en cm"),
                ),
                (
                    "hauteur_cm",
                    models.IntegerField(default=30, verbose_name="hauteur en cm"),
                ),
                (
                    "categories",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=25,
                        verbose_name="Pour les categories",
                    ),
                ),
                (
                    "tronc",
                    models.BooleanField(default=False, verbose_name="Tronc commun"),
                ),
                (
                    "abrege",
                    models.CharField(
                        blank=True, default="", max_length=20, verbose_name="Abrégé"
                    ),
                ),
                (
                    "lib_option",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=20,
                        verbose_name="Option dans SIECLE",
                    ),
                ),
                (
                    "discipline",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.disciplines",
                        verbose_name="Discipline",
                    ),
                ),
                (
                    "filiere",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.filieres",
                        verbose_name="Filière",
                    ),
                ),
                (
                    "niveau",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.niveaux",
                        verbose_name="Niveau",
                    ),
                ),
                (
                    "serie",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.series",
                        verbose_name="Série",
                    ),
                ),
                (
                    "type_materiel",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.typemateriel",
                        verbose_name="Type de Matériel",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="inventaire",
            name="materiel",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="gestion.materiel",
            ),
        ),
        migrations.CreateModel(
            name="Details",
            fields=[
                ("id", models.IntegerField(primary_key=True, serialize=False)),
                ("Quantite", models.CharField(max_length=25, verbose_name="Quantité")),
                ("Remise", models.CharField(max_length=25, verbose_name="Remise")),
                (
                    "commande",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.commandes",
                    ),
                ),
                (
                    "materiel",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.materiel",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Details",
            },
        ),
        migrations.CreateModel(
            name="RevueStock",
            fields=[
                (
                    "code",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to="gestion.inventaire",
                        verbose_name="N° de livre",
                    ),
                ),
                (
                    "date",
                    models.DateTimeField(
                        default=datetime.date(1, 1, 1),
                        verbose_name="Date de la dernière vérification",
                    ),
                ),
                ("prete", models.BooleanField(default=False, verbose_name="Est prêté")),
                (
                    "dernier_pret",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.prets",
                        verbose_name="Dernier prêt",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Revue du stock",
            },
        ),
        migrations.CreateModel(
            name="LivreSupplement",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "data",
                    models.TextField(verbose_name="Demande de prêt supplémentaire"),
                ),
                ("date", models.DateTimeField(auto_now_add=True)),
                (
                    "commentaire",
                    models.TextField(blank=True, null=True, verbose_name="Motivation"),
                ),
            ],
            options={
                "verbose_name_plural": "Demandes de livres supplémentaires",
            },
        ),
        migrations.CreateModel(
            name="Livre_a_lire",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("date", models.DateTimeField(auto_now_add=True)),
                (
                    "eleve",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.eleves",
                        verbose_name="À prêter à",
                    ),
                ),
                (
                    "livre",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="gestion.materiel",
                        verbose_name="Livre",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Demandes de livres validées",
            },
        ),
        migrations.CreateModel(
            name="Courriers",
            fields=[
                (
                    "N",
                    models.IntegerField(
                        primary_key=True, serialize=False, verbose_name="N°"
                    ),
                ),
                (
                    "Pret_Recommandation",
                    models.TextField(verbose_name="Recommandation pour le prêt"),
                ),
                (
                    "Retour_Recommandation",
                    models.TextField(verbose_name="Recommandation pour le retour"),
                ),
                (
                    "Pret_Recom_Prof",
                    models.TextField(
                        verbose_name="Recommandation pour le prêt professeur"
                    ),
                ),
                (
                    "Retour_Recom_Prof",
                    models.TextField(
                        verbose_name="Recommandation pour le retour professeur"
                    ),
                ),
                (
                    "Memoire",
                    models.TextField(
                        default="",
                        verbose_name="Explications pour le «\xa0mémoire pour pertes\xa0»",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Textes prédéfinis des courriers",
            },
        ),
    ]
