/**
 * pes_per_node  -  Compute number of PEs per node from reservation parameters
 * @cores_per_node:	number of cores per (of this) node
 * @mem_per_node:	total memory available per node in MB
 * @req_nppn:		requested PEs per node (0 for default)
 * @req_depth:		requested thread depth (CPUs per PE); > 1
 * @req_mem:		requested per-PE required Resident Set Size in MB
 * 			(set to 0 to indicate using default_mem_per_pe).
 */
static uint32_t pes_per_node(uint32_t cores_per_node, uint32_t mem_per_node,
		      uint32_t req_nppn, uint32_t req_depth, uint32_t req_mem)
{
	uint32_t pes_per_node = cores_per_node;	/* maximum possible value */
	uint32_t default_mem_per_pe = mem_per_node / cores_per_node;

//printf("result for: -d %d -N %d -m %d,  mppe=%d", req_depth,req_nppn, req_mem, default_mem_per_pe);

	/* 1. constraint: no more than floor(ncores/depth) PEs per node */
	if (req_depth > 1)
		pes_per_node = cores_per_node / req_depth;

	/* 2. constraint: no more than the requested PEs per node */
	if (0 < req_nppn && req_nppn < pes_per_node)
		pes_per_node = req_nppn;

	/* 3. constraint: share of PEs per node depends on requested memory */
	if (req_mem > default_mem_per_pe) {
		uint32_t mem_pes_per_node = mem_per_node / req_mem;

		if (mem_pes_per_node < pes_per_node)
			pes_per_node = mem_pes_per_node;
		//printf(", mem_pes_per_node=%d",mem_pes_per_node);
	}
//	printf(": %d\t", pes_per_node);
	return pes_per_node;
}


