-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

with SPARK_IO;
with SparkMakeCommandLine;

package body SparkMakeDebug is
   ---------------------------------------------------------------------------
   -- This package body is NOT SPARK
   ---------------------------------------------------------------------------

   procedure Start_Debug_Line is
   begin
      SPARK_IO.Put_String (File => SPARK_IO.Standard_Output,
                           Item => ">>> Debug: ",
                           Stop => 0);
   end Start_Debug_Line;

   -----------------------------------------------------------------------------------

   procedure Report_Text (Text : in String) is
   begin
      if SparkMakeCommandLine.Debug_On then
         Start_Debug_Line;

         SPARK_IO.Put_Line (File => SPARK_IO.Standard_Output,
                            Item => Text,
                            Stop => 0);
      end if;
   end Report_Text;

   -----------------------------------------------------------------------------------

   procedure Report_Text_E_Text (Text   : in String;
                                 E_Text : in E_Strings.T) is
   begin
      if SparkMakeCommandLine.Debug_On then
         Start_Debug_Line;

         SPARK_IO.Put_String (File => SPARK_IO.Standard_Output,
                              Item => Text,
                              Stop => 0);

         E_Strings.Put_Line (File  => SPARK_IO.Standard_Output,
                             E_Str => E_Text);
      end if;
   end Report_Text_E_Text;

   -----------------------------------------------------------------------------------

   procedure Report_List (Text : in String;
                          List : in StringList.Object) is
   begin
      if SparkMakeCommandLine.Debug_On then
         Start_Debug_Line;

         SPARK_IO.Put_String (File => SPARK_IO.Standard_Output,
                              Item => Text,
                              Stop => 0);

         StringList.Output (The_List => List,
                            How      => StringList.Horizontal);
      end if;
   end Report_List;

   -----------------------------------------------------------------------------------

   procedure Report_Cond_Text (Cond       : in Boolean;
                               True_Text  : in String;
                               False_Text : in String) is
   begin
      if SparkMakeCommandLine.Debug_On then
         Start_Debug_Line;
         if Cond then
            SPARK_IO.Put_Line (File => SPARK_IO.Standard_Output,
                               Item => True_Text,
                               Stop => 0);
         else
            SPARK_IO.Put_Line (File => SPARK_IO.Standard_Output,
                               Item => False_Text,
                               Stop => 0);
         end if;
      end if;
   end Report_Cond_Text;

end SparkMakeDebug;
