/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.bristol.star.cdf.CdfFormatException;
import uk.ac.bristol.star.cdf.record.AttributeDescriptorRecord;
import uk.ac.bristol.star.cdf.record.AttributeEntryDescriptorRecord;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.CdfDescriptorRecord;
import uk.ac.bristol.star.cdf.record.CompressedCdfRecord;
import uk.ac.bristol.star.cdf.record.CompressedParametersRecord;
import uk.ac.bristol.star.cdf.record.CompressedVariableValuesRecord;
import uk.ac.bristol.star.cdf.record.GlobalDescriptorRecord;
import uk.ac.bristol.star.cdf.record.Pointer;
import uk.ac.bristol.star.cdf.record.Record;
import uk.ac.bristol.star.cdf.record.RecordPlan;
import uk.ac.bristol.star.cdf.record.SparsenessParametersRecord;
import uk.ac.bristol.star.cdf.record.UnusedInternalRecord;
import uk.ac.bristol.star.cdf.record.VariableDescriptorRecord;
import uk.ac.bristol.star.cdf.record.VariableIndexRecord;
import uk.ac.bristol.star.cdf.record.VariableValuesRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordFactory {
    private final Map<Integer, TypedRecordFactory> factoryMap_;
    private final Logger logger_ = Logger.getLogger(RecordFactory.class.getName());

    public RecordFactory(int n) {
        this.factoryMap_ = RecordFactory.createFactoryMap(n);
    }

    public Record createRecord(Buf buf, long l) throws IOException {
        Pointer pointer = new Pointer(l);
        long l2 = buf.readOffset(pointer);
        int n = buf.readInt(pointer);
        RecordPlan recordPlan = new RecordPlan(l, l2, n, buf);
        TypedRecordFactory typedRecordFactory = this.factoryMap_.get(n);
        if (typedRecordFactory == null) {
            throw new CdfFormatException("Unknown record type " + n);
        }
        Object r = typedRecordFactory.createRecord(recordPlan);
        String string = new StringBuffer().append("CDF Record:\t").append("0x").append(Long.toHexString(l)).append("\t+").append(l2).append("\t").append(((Record)r).getRecordTypeAbbreviation()).toString();
        this.logger_.config(string);
        return r;
    }

    public <R extends Record> R createRecord(Buf buf, long l, Class<R> clazz) throws IOException {
        Record record = this.createRecord(buf, l);
        if (clazz.isInstance(record)) {
            return (R)((Record)clazz.cast(record));
        }
        String string = new StringBuffer().append("Unexpected record type at ").append("0x").append(Long.toHexString(l)).append("; got ").append(record.getClass().getName()).append(" not ").append(clazz.getName()).toString();
        throw new CdfFormatException(string);
    }

    private static Map<Integer, TypedRecordFactory> createFactoryMap(final int n) {
        HashMap<Integer, TypedRecordFactory> hashMap = new HashMap<Integer, TypedRecordFactory>();
        hashMap.put(1, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new CdfDescriptorRecord(recordPlan);
            }
        });
        hashMap.put(2, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new GlobalDescriptorRecord(recordPlan);
            }
        });
        hashMap.put(4, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new AttributeDescriptorRecord(recordPlan, n);
            }
        });
        hashMap.put(5, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new AttributeEntryDescriptorRecord.GrVariant(recordPlan);
            }
        });
        hashMap.put(9, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new AttributeEntryDescriptorRecord.ZVariant(recordPlan);
            }
        });
        hashMap.put(3, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new VariableDescriptorRecord.RVariant(recordPlan, n);
            }
        });
        hashMap.put(8, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new VariableDescriptorRecord.ZVariant(recordPlan, n);
            }
        });
        hashMap.put(6, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new VariableIndexRecord(recordPlan);
            }
        });
        hashMap.put(7, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new VariableValuesRecord(recordPlan);
            }
        });
        hashMap.put(10, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new CompressedCdfRecord(recordPlan);
            }
        });
        hashMap.put(11, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new CompressedParametersRecord(recordPlan);
            }
        });
        hashMap.put(12, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new SparsenessParametersRecord(recordPlan);
            }
        });
        hashMap.put(13, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new CompressedVariableValuesRecord(recordPlan);
            }
        });
        hashMap.put(-1, new TypedRecordFactory(){

            public Record createRecord(RecordPlan recordPlan) throws IOException {
                return new UnusedInternalRecord(recordPlan);
            }
        });
        int[] nArray = new int[hashMap.size()];
        int n2 = 0;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            nArray[n2++] = n3;
        }
        Arrays.sort(nArray);
        assert (Arrays.equals(nArray, new int[]{-1, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}));
        return Collections.unmodifiableMap(hashMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface TypedRecordFactory<R extends Record> {
        public R createRecord(RecordPlan var1) throws IOException;
    }
}

