/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.logging.Logger;
import uk.ac.bristol.star.cdf.CdfFormatException;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.Bufs;
import uk.ac.bristol.star.cdf.record.CdfDescriptorRecord;
import uk.ac.bristol.star.cdf.record.CompressedCdfRecord;
import uk.ac.bristol.star.cdf.record.CompressedParametersRecord;
import uk.ac.bristol.star.cdf.record.Compression;
import uk.ac.bristol.star.cdf.record.NumericEncoding;
import uk.ac.bristol.star.cdf.record.Pointer;
import uk.ac.bristol.star.cdf.record.Record;
import uk.ac.bristol.star.cdf.record.RecordFactory;

public class CdfReader {
    private final CdfDescriptorRecord cdr_;
    private final Buf buf_;
    private final RecordFactory recordFactory_;
    private static final Logger logger_ = Logger.getLogger(CdfReader.class.getName());

    public CdfReader(Buf buf) throws IOException {
        Object object;
        Object object2;
        Pointer pointer = new Pointer(0L);
        int n = buf.readInt(pointer);
        int n2 = buf.readInt(pointer);
        int n3 = (int)pointer.get();
        CdfVariant cdfVariant = CdfReader.decodeMagic(n, n2);
        if (cdfVariant == null) {
            String string = new StringBuffer().append("Unrecognised magic numbers: ").append("0x").append(Integer.toHexString(n)).append(", ").append("0x").append(Integer.toHexString(n2)).toString();
            throw new CdfFormatException(string);
        }
        logger_.config("CDF magic number for " + cdfVariant.label_);
        logger_.config("Whole file compression: " + cdfVariant.compressed_);
        buf.setBit64(cdfVariant.bit64_);
        this.recordFactory_ = new RecordFactory(cdfVariant.nameLeng_);
        if (cdfVariant.compressed_) {
            CompressedCdfRecord compressedCdfRecord = this.recordFactory_.createRecord(buf, n3, CompressedCdfRecord.class);
            object2 = this.recordFactory_.createRecord(buf, compressedCdfRecord.cprOffset, CompressedParametersRecord.class);
            object = Compression.getCompression(object2.cType);
            final int n4 = n3;
            assert (n4 == 8);
            Compression compression = new Compression("Padded " + ((Compression)object).getName(), (Compression)object){
                final /* synthetic */ Compression val$compress;
                {
                    this.val$compress = compression;
                    super(string);
                }

                public InputStream uncompressStream(InputStream inputStream) throws IOException {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[n4]);
                    InputStream inputStream2 = this.val$compress.uncompressStream(inputStream);
                    return new SequenceInputStream(byteArrayInputStream, inputStream2);
                }
            };
            buf = Bufs.uncompress(compression, buf, compressedCdfRecord.getDataOffset(), compressedCdfRecord.uSize + (long)n4);
        }
        this.cdr_ = this.recordFactory_.createRecord(buf, n3, CdfDescriptorRecord.class);
        boolean bl = Record.hasBit(this.cdr_.flags, 1);
        if (!bl) {
            throw new CdfFormatException("Multi-file CDFs not supported");
        }
        object2 = NumericEncoding.getEncoding(this.cdr_.encoding);
        object = ((NumericEncoding)((Object)object2)).isBigendian();
        if (object == null) {
            throw new CdfFormatException("Unsupported encoding " + object2);
        }
        buf.setEncoding((Boolean)object);
        this.buf_ = buf;
    }

    public CdfReader(File file) throws IOException {
        this(Bufs.createBuf(file, true, true));
    }

    public Buf getBuf() {
        return this.buf_;
    }

    public RecordFactory getRecordFactory() {
        return this.recordFactory_;
    }

    public CdfDescriptorRecord getCdr() {
        return this.cdr_;
    }

    public static boolean isMagic(byte[] byArray) {
        if (byArray.length < 8) {
            return false;
        }
        return CdfReader.decodeMagic(CdfReader.readInt(byArray, 0), CdfReader.readInt(byArray, 4)) != null;
    }

    private static int readInt(byte[] byArray, int n) {
        return (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CdfVariant decodeMagic(int n, int n2) {
        boolean bl;
        int n3;
        boolean bl2;
        String string;
        if (n == -839712767) {
            string = "V3";
            bl2 = true;
            n3 = 256;
            if (n2 == 65535) {
                bl = false;
                return new CdfVariant(string, bl2, n3, bl);
            } else {
                if (n2 != -859045887) return null;
                bl = true;
            }
            return new CdfVariant(string, bl2, n3, bl);
        } else if (n == -839753726) {
            string = "V2.6/2.7";
            bl2 = false;
            n3 = 64;
            if (n2 == 65535) {
                bl = false;
                return new CdfVariant(string, bl2, n3, bl);
            } else {
                if (n2 != -859045887) return null;
                bl = true;
            }
            return new CdfVariant(string, bl2, n3, bl);
        } else {
            if (n != 65535) return null;
            string = "pre-V2.6";
            bl2 = false;
            n3 = 64;
            if (n2 != 65535) return null;
            bl = false;
        }
        return new CdfVariant(string, bl2, n3, bl);
    }

    private static class CdfVariant {
        final String label_;
        final boolean bit64_;
        final int nameLeng_;
        final boolean compressed_;

        CdfVariant(String string, boolean bl, int n, boolean bl2) {
            this.label_ = string;
            this.bit64_ = bl;
            this.nameLeng_ = n;
            this.compressed_ = bl2;
        }
    }
}

