/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.IOException;
import uk.ac.bristol.star.cdf.DataType;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.CdfField;
import uk.ac.bristol.star.cdf.record.OffsetField;
import uk.ac.bristol.star.cdf.record.Pointer;
import uk.ac.bristol.star.cdf.record.Record;
import uk.ac.bristol.star.cdf.record.RecordPlan;

public abstract class VariableDescriptorRecord
extends Record {
    @CdfField
    @OffsetField
    public final long vdrNext;
    @CdfField
    public final int dataType;
    @CdfField
    public final int maxRec;
    @CdfField
    @OffsetField
    public final long vxrHead;
    @CdfField
    @OffsetField
    public final long vxrTail;
    @CdfField
    public final int flags;
    @CdfField
    public final int sRecords;
    @CdfField
    public final int rfuB;
    @CdfField
    public final int rfuC;
    @CdfField
    public final int rfuF;
    @CdfField
    public final int numElems;
    @CdfField
    public final int num;
    @CdfField
    @OffsetField
    public final long cprOrSprOffset;
    @CdfField
    public final int blockingFactor;
    @CdfField
    public final String name;
    @CdfField
    public final int zNumDims;
    @CdfField
    public final int[] zDimSizes;
    @CdfField
    public final boolean[] dimVarys;
    private final long padOffset_;
    private final int padBytes_;

    private VariableDescriptorRecord(RecordPlan recordPlan, String string, int n, boolean bl, int n2) throws IOException {
        super(recordPlan, string, n);
        int n3;
        Buf buf = recordPlan.getBuf();
        Pointer pointer = recordPlan.createContentPointer();
        this.vdrNext = buf.readOffset(pointer);
        this.dataType = buf.readInt(pointer);
        this.maxRec = buf.readInt(pointer);
        this.vxrHead = buf.readOffset(pointer);
        this.vxrTail = buf.readOffset(pointer);
        this.flags = buf.readInt(pointer);
        this.sRecords = buf.readInt(pointer);
        this.rfuB = buf.readInt(pointer);
        this.rfuC = buf.readInt(pointer);
        this.rfuF = buf.readInt(pointer);
        this.numElems = buf.readInt(pointer);
        this.num = buf.readInt(pointer);
        this.cprOrSprOffset = buf.readOffset(pointer);
        this.blockingFactor = buf.readInt(pointer);
        this.name = buf.readAsciiString(pointer, n2);
        if (bl) {
            this.zNumDims = buf.readInt(pointer);
            this.zDimSizes = VariableDescriptorRecord.readIntArray(buf, pointer, this.zNumDims);
        } else {
            this.zNumDims = 0;
            this.zDimSizes = null;
        }
        boolean bl2 = VariableDescriptorRecord.hasBit(this.flags, 1);
        int n4 = this.padBytes_ = bl2 ? DataType.getDataType(this.dataType).getByteCount() * this.numElems : 0;
        if (bl) {
            n3 = this.zNumDims;
        } else {
            long l = recordPlan.getReadCount(pointer);
            long l2 = this.getRecordSize() - l - (long)this.padBytes_;
            assert (l2 == (long)((int)l2));
            if (l2 % 4L != 0L) {
                this.warnFormat("rVDR DimVarys field non-integer size??");
            }
            n3 = (int)l2 / 4;
        }
        int[] nArray = VariableDescriptorRecord.readIntArray(buf, pointer, n3);
        this.dimVarys = new boolean[n3];
        for (int i = 0; i < n3; ++i) {
            this.dimVarys[i] = nArray[i] != 0;
        }
        long l = pointer.getAndIncrement(this.padBytes_);
        this.padOffset_ = bl2 ? l : -1L;
        this.checkEndRecord(pointer);
    }

    public long getPadValueOffset() {
        return this.padOffset_;
    }

    public int getPadValueSize() {
        return this.padBytes_;
    }

    public static class ZVariant
    extends VariableDescriptorRecord {
        public ZVariant(RecordPlan recordPlan, int n) throws IOException {
            super(recordPlan, "zVDR", 8, true, n);
        }
    }

    public static class RVariant
    extends VariableDescriptorRecord {
        public RVariant(RecordPlan recordPlan, int n) throws IOException {
            super(recordPlan, "rVDR", 3, false, n);
        }
    }
}

