/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.FlatHashList;
import cds.healpix.NeighbourSelector;
import cds.healpix.common.math.HackersDelight;

public final class CompassPoint {
    private CompassPoint() {
    }

    public static abstract class Cardinal
    extends Enum<Cardinal> {
        public static final /* enum */ Cardinal N = new Cardinal(0, 0, 1){

            @Override
            long internalCorner(NeighbourSelector neigSelect, long hash, int toEdgeDeltaDepth) {
                return neigSelect.internalCornerN(hash, toEdgeDeltaDepth);
            }
        };
        public static final /* enum */ Cardinal E = new Cardinal(1, 1, 0){

            @Override
            long internalCorner(NeighbourSelector neigSelect, long hash, int toEdgeDeltaDepth) {
                return neigSelect.internalCornerE(hash, toEdgeDeltaDepth);
            }
        };
        public static final /* enum */ Cardinal S = new Cardinal(2, 0, -1){

            @Override
            long internalCorner(NeighbourSelector neigSelect, long hash, int toEdgeDeltaDepth) {
                return neigSelect.internalCornerS(hash, toEdgeDeltaDepth);
            }
        };
        public static final /* enum */ Cardinal W = new Cardinal(3, -1, 0){

            @Override
            long internalCorner(NeighbourSelector neigSelect, long hash, int toEdgeDeltaDepth) {
                return neigSelect.internalCornerW(hash, toEdgeDeltaDepth);
            }
        };
        private static final Cardinal[] CARDINAL_POINTS;
        private final int index;
        private final int xOffset;
        private final int yOffset;
        private final long xOffsetSign;
        private final long yOffsetSign;
        private final long xOffsetMak;
        private final long yOffsetMak;
        private static final /* synthetic */ Cardinal[] $VALUES;

        public static Cardinal[] values() {
            return (Cardinal[])$VALUES.clone();
        }

        public static Cardinal valueOf(String name) {
            return Enum.valueOf(Cardinal.class, name);
        }

        private Cardinal(int index, int xAxisOffset, int yAxisOffset) {
            this.index = index;
            this.xOffset = xAxisOffset;
            assert (this.xOffset == -1 || this.xOffset == 0 || this.xOffset == 1);
            this.yOffset = yAxisOffset;
            assert (this.yOffset == -1 || this.yOffset == 0 || this.yOffset == 1);
            this.xOffsetSign = xAxisOffset >= 0 ? 0L : Long.MIN_VALUE;
            this.xOffsetMak = xAxisOffset == 0 ? 0L : -1L;
            this.yOffsetSign = yAxisOffset >= 0 ? 0L : Long.MIN_VALUE;
            this.yOffsetMak = yAxisOffset == 0 ? 0L : -1L;
        }

        public Cardinal nextClockwise() {
            return CARDINAL_POINTS[this.index + 1 & 3];
        }

        public Cardinal nextCounterClockwise() {
            return CARDINAL_POINTS[this.index - 1 & 3];
        }

        final int getOffsetX() {
            return this.xOffset;
        }

        final int getOffsetY() {
            return this.yOffset;
        }

        final double timeXOffset(double absValue) {
            return HackersDelight.fromBits((HackersDelight.toBits(absValue) | this.xOffsetSign) & this.xOffsetMak);
        }

        final double timeYOffset(double absValue) {
            return HackersDelight.fromBits((HackersDelight.toBits(absValue) | this.yOffsetSign) & this.yOffsetMak);
        }

        abstract long internalCorner(NeighbourSelector var1, long var2, int var4);

        static {
            $VALUES = new Cardinal[]{N, E, S, W};
            CARDINAL_POINTS = new Cardinal[4];
            Cardinal[] cardinalArray = Cardinal.values();
            int n = cardinalArray.length;
            for (int i = 0; i < n; ++i) {
                Cardinal cardinalPoint;
                Cardinal.CARDINAL_POINTS[cardinalPoint.index] = cardinalPoint = cardinalArray[i];
            }
        }
    }

    public static enum Ordinal {
        NE{

            @Override
            void orderedInternalEdge(NeighbourSelector neigSelect, long hash, int deltaDepth, FlatHashList result) {
                neigSelect.sortedInternalEdgeNE(hash, deltaDepth, result);
            }
        }
        ,
        SE{

            @Override
            void orderedInternalEdge(NeighbourSelector neigSelect, long hash, int deltaDepth, FlatHashList result) {
                neigSelect.sortedInternalEdgeSE(hash, deltaDepth, result);
            }
        }
        ,
        SW{

            @Override
            void orderedInternalEdge(NeighbourSelector neigSelect, long hash, int deltaDepth, FlatHashList result) {
                neigSelect.sortedInternalEdgeSW(hash, deltaDepth, result);
            }
        }
        ,
        NW{

            @Override
            void orderedInternalEdge(NeighbourSelector neigSelect, long hash, int deltaDepth, FlatHashList result) {
                neigSelect.sortedInternalEdgeNW(hash, deltaDepth, result);
            }
        };


        abstract void orderedInternalEdge(NeighbourSelector var1, long var2, int var4, FlatHashList var5);
    }

    public static enum MainWind {
        N(2, 2, Cardinal.N){

            @Override
            final int pickRightSouthToEastIntValue(int southWestValue, int centralValue, int northEastValue) {
                return northEastValue;
            }

            @Override
            final int pickRightSouthToWestIntValue(int southEastValue, int centralValue, int northWestValue) {
                return northWestValue;
            }

            @Override
            final long pickRightSouthToEastLongValue(long southWestValue, long centralValue, long northEastValue) {
                return northEastValue;
            }

            @Override
            final long pickRightSouthToWestLongValue(long southEastValue, long centralValue, long northWestValue) {
                return northWestValue;
            }

            @Override
            int pickRightIntValue(int northwestValue, int northValue, int northeastValue, int westValue, int centralValue, int eastValue, int southwestValue, int southValue, int southeastValue) {
                return northValue;
            }

            @Override
            long pickRightLongValue(long northwestValue, long northValue, long northeastValue, long westValue, long centralValue, long eastValue, long southwestValue, long southValue, long southeastValue) {
                return northValue;
            }
        }
        ,
        NE(2, 1, Ordinal.NE){

            @Override
            final int pickRightSouthToEastIntValue(int southWestValue, int centralValue, int northEastValue) {
                return northEastValue;
            }

            @Override
            final int pickRightSouthToWestIntValue(int southEastValue, int centralValue, int northWestValue) {
                return centralValue;
            }

            @Override
            final long pickRightSouthToEastLongValue(long southWestValue, long centralValue, long northEastValue) {
                return northEastValue;
            }

            @Override
            final long pickRightSouthToWestLongValue(long southEastValue, long centralValue, long northWestValue) {
                return centralValue;
            }

            @Override
            int pickRightIntValue(int northwestValue, int northValue, int northeastValue, int westValue, int centralValue, int eastValue, int southwestValue, int southValue, int southeastValue) {
                return northeastValue;
            }

            @Override
            long pickRightLongValue(long northwestValue, long northValue, long northeastValue, long westValue, long centralValue, long eastValue, long southwestValue, long southValue, long southeastValue) {
                return northeastValue;
            }
        }
        ,
        E(2, 0, Cardinal.E){

            @Override
            final int pickRightSouthToEastIntValue(int southWestValue, int centralValue, int northEastValue) {
                return northEastValue;
            }

            @Override
            final int pickRightSouthToWestIntValue(int southEastValue, int centralValue, int northWestValue) {
                return southEastValue;
            }

            @Override
            final long pickRightSouthToEastLongValue(long southWestValue, long centralValue, long northEastValue) {
                return northEastValue;
            }

            @Override
            final long pickRightSouthToWestLongValue(long southEastValue, long centralValue, long northWestValue) {
                return southEastValue;
            }

            @Override
            int pickRightIntValue(int northwestValue, int northValue, int northeastValue, int westValue, int centralValue, int eastValue, int southwestValue, int southValue, int southeastValue) {
                return eastValue;
            }

            @Override
            long pickRightLongValue(long northwestValue, long northValue, long northeastValue, long westValue, long centralValue, long eastValue, long southwestValue, long southValue, long southeastValue) {
                return eastValue;
            }
        }
        ,
        SE(1, 0, Ordinal.SE){

            @Override
            final int pickRightSouthToEastIntValue(int southWestValue, int centralValue, int northEastValue) {
                return centralValue;
            }

            @Override
            final int pickRightSouthToWestIntValue(int southEastValue, int centralValue, int northWestValue) {
                return southEastValue;
            }

            @Override
            final long pickRightSouthToEastLongValue(long southWestValue, long centralValue, long northEastValue) {
                return centralValue;
            }

            @Override
            final long pickRightSouthToWestLongValue(long southEastValue, long centralValue, long northWestValue) {
                return southEastValue;
            }

            @Override
            int pickRightIntValue(int northwestValue, int northValue, int northeastValue, int westValue, int centralValue, int eastValue, int southwestValue, int southValue, int southeastValue) {
                return southeastValue;
            }

            @Override
            long pickRightLongValue(long northwestValue, long northValue, long northeastValue, long westValue, long centralValue, long eastValue, long southwestValue, long southValue, long southeastValue) {
                return southeastValue;
            }
        }
        ,
        S(0, 0, Cardinal.S){

            @Override
            final int pickRightSouthToEastIntValue(int southWestValue, int centralValue, int northEastValue) {
                return southWestValue;
            }

            @Override
            final int pickRightSouthToWestIntValue(int southEastValue, int centralValue, int northWestValue) {
                return southEastValue;
            }

            @Override
            final long pickRightSouthToEastLongValue(long southWestValue, long centralValue, long northEastValue) {
                return southWestValue;
            }

            @Override
            final long pickRightSouthToWestLongValue(long southEastValue, long centralValue, long northWestValue) {
                return southEastValue;
            }

            @Override
            int pickRightIntValue(int northwestValue, int northValue, int northeastValue, int westValue, int centralValue, int eastValue, int southwestValue, int southValue, int southeastValue) {
                return southValue;
            }

            @Override
            long pickRightLongValue(long northwestValue, long northValue, long northeastValue, long westValue, long centralValue, long eastValue, long southwestValue, long southValue, long southeastValue) {
                return southValue;
            }
        }
        ,
        SW(0, 1, Ordinal.SW){

            @Override
            final int pickRightSouthToEastIntValue(int southWestValue, int centralValue, int northEastValue) {
                return southWestValue;
            }

            @Override
            final int pickRightSouthToWestIntValue(int southEastValue, int centralValue, int northWestValue) {
                return centralValue;
            }

            @Override
            final long pickRightSouthToEastLongValue(long southWestValue, long centralValue, long northEastValue) {
                return southWestValue;
            }

            @Override
            final long pickRightSouthToWestLongValue(long southEastValue, long centralValue, long northWestValue) {
                return centralValue;
            }

            @Override
            int pickRightIntValue(int northwestValue, int northValue, int northeastValue, int westValue, int centralValue, int eastValue, int southwestValue, int southValue, int southeastValue) {
                return southwestValue;
            }

            @Override
            long pickRightLongValue(long northwestValue, long northValue, long northeastValue, long westValue, long centralValue, long eastValue, long southwestValue, long southValue, long southeastValue) {
                return southwestValue;
            }
        }
        ,
        W(0, 2, Cardinal.W){

            @Override
            final int pickRightSouthToEastIntValue(int southWestValue, int centralValue, int northEastValue) {
                return southWestValue;
            }

            @Override
            final int pickRightSouthToWestIntValue(int southEastValue, int centralValue, int northWestValue) {
                return northWestValue;
            }

            @Override
            final long pickRightSouthToEastLongValue(long southWestValue, long centralValue, long northEastValue) {
                return southWestValue;
            }

            @Override
            final long pickRightSouthToWestLongValue(long southEastValue, long centralValue, long northWestValue) {
                return northWestValue;
            }

            @Override
            int pickRightIntValue(int northwestValue, int northValue, int northeastValue, int westValue, int centralValue, int eastValue, int southwestValue, int southValue, int southeastValue) {
                return westValue;
            }

            @Override
            long pickRightLongValue(long northwestValue, long northValue, long northeastValue, long westValue, long centralValue, long eastValue, long southwestValue, long southValue, long southeastValue) {
                return westValue;
            }
        }
        ,
        NW(1, 2, Ordinal.NW){

            @Override
            final int pickRightSouthToEastIntValue(int southWestValue, int centralValue, int northEastValue) {
                return centralValue;
            }

            @Override
            final int pickRightSouthToWestIntValue(int southEastValue, int centralValue, int northWestValue) {
                return northWestValue;
            }

            @Override
            final long pickRightSouthToEastLongValue(long southWestValue, long centralValue, long northEastValue) {
                return centralValue;
            }

            @Override
            final long pickRightSouthToWestLongValue(long southEastValue, long centralValue, long northWestValue) {
                return northWestValue;
            }

            @Override
            int pickRightIntValue(int northwestValue, int northValue, int northeastValue, int westValue, int centralValue, int eastValue, int southwestValue, int southValue, int southeastValue) {
                return northwestValue;
            }

            @Override
            long pickRightLongValue(long northwestValue, long northValue, long northeastValue, long westValue, long centralValue, long eastValue, long southwestValue, long southValue, long southeastValue) {
                return northwestValue;
            }
        }
        ,
        C(1, 1){

            @Override
            final int pickRightSouthToEastIntValue(int southWestValue, int centralValue, int northEastValue) {
                return centralValue;
            }

            @Override
            final int pickRightSouthToWestIntValue(int southEastValue, int centralValue, int northWestValue) {
                return centralValue;
            }

            @Override
            final long pickRightSouthToEastLongValue(long southWestValue, long centralValue, long northEastValue) {
                return centralValue;
            }

            @Override
            final long pickRightSouthToWestLongValue(long southEastValue, long centralValue, long northWestValue) {
                return centralValue;
            }

            @Override
            int pickRightIntValue(int northwestValue, int northValue, int northeastValue, int westValue, int centralValue, int eastValue, int southwestValue, int southValue, int southeastValue) {
                return centralValue;
            }

            @Override
            long pickRightLongValue(long northwestValue, long northValue, long northeastValue, long westValue, long centralValue, long eastValue, long southwestValue, long southValue, long southeastValue) {
                return centralValue;
            }
        };

        private static final MainWind[] MAIN_WINDS;
        private MainWind oppositeDirection;
        private Ordinal ordinal;
        private Cardinal cardinal;
        private final int index;
        private final int iSW;
        private final int iSE;
        private final int offsetSE;
        private final int offsetSW;

        private MainWind(int indexSE, int indexSW) {
            this(indexSE, indexSW, (Ordinal)null, (Cardinal)null);
        }

        private MainWind(int indexSE, int indexSW, Ordinal ordinal) {
            this(indexSE, indexSW, ordinal, (Cardinal)null);
        }

        private MainWind(int indexSE, int indexSW, Cardinal cardinal) {
            this(indexSE, indexSW, null, cardinal);
        }

        private MainWind(int indexSE, int indexSW, Ordinal ordinal, Cardinal cardinal) {
            this.iSE = indexSE;
            this.iSW = indexSW;
            this.index = MainWind.computeIndex(this.iSE, this.iSW);
            this.offsetSE = this.iSE - 1;
            this.offsetSW = this.iSW - 1;
            this.ordinal = ordinal;
            this.cardinal = cardinal;
        }

        private void setOppositeDirection(MainWind oppositeDirection) {
            this.oppositeDirection = oppositeDirection;
        }

        final int getIndex() {
            return this.index;
        }

        public MainWind getOppositeDirection() {
            return this.oppositeDirection;
        }

        public boolean isOrdinal() {
            return this.ordinal != null;
        }

        public Ordinal toOrdinal() {
            if (!this.isOrdinal()) {
                throw new IllegalArgumentException("Main wind " + (Object)((Object)this) + " is not an ordinal point!");
            }
            return this.ordinal;
        }

        public boolean isCardinal() {
            return this.cardinal != null;
        }

        public Cardinal toCardinal() {
            if (!this.isCardinal()) {
                throw new IllegalArgumentException("Main wind " + (Object)((Object)this) + " is not a cardinal point!");
            }
            return this.cardinal;
        }

        final int getOffsetSE() {
            return this.offsetSE;
        }

        final int getOffsetSW() {
            return this.offsetSW;
        }

        static final int size() {
            return MAIN_WINDS.length;
        }

        static final MainWind getFromCoo(int indexSE, int indexSW) {
            return MAIN_WINDS[MainWind.computeIndex(indexSE, indexSW)];
        }

        static final MainWind getFromOffset(int offsetSE, int offsetSW) {
            return MAIN_WINDS[MainWind.computeIndex(++offsetSE, ++offsetSW)];
        }

        static final MainWind getFromIndex(int i) {
            return MAIN_WINDS[i];
        }

        private static final int computeIndex(int indexSE, int indexSW) {
            return (indexSW << 1) + indexSW + indexSE;
        }

        abstract int pickRightSouthToEastIntValue(int var1, int var2, int var3);

        abstract int pickRightSouthToWestIntValue(int var1, int var2, int var3);

        abstract long pickRightSouthToEastLongValue(long var1, long var3, long var5);

        abstract long pickRightSouthToWestLongValue(long var1, long var3, long var5);

        abstract int pickRightIntValue(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        abstract long pickRightLongValue(long var1, long var3, long var5, long var7, long var9, long var11, long var13, long var15, long var17);

        static {
            MAIN_WINDS = new MainWind[9];
            MainWind[] mainWindArray = MainWind.values();
            int n = mainWindArray.length;
            for (int i = 0; i < n; ++i) {
                MainWind mainWind;
                MainWind.MAIN_WINDS[mainWind.index] = mainWind = mainWindArray[i];
            }
            N.setOppositeDirection(S);
            S.setOppositeDirection(N);
            E.setOppositeDirection(W);
            W.setOppositeDirection(E);
            NE.setOppositeDirection(SW);
            SW.setOppositeDirection(NE);
            NW.setOppositeDirection(SE);
            SE.setOppositeDirection(NW);
            C.setOppositeDirection(C);
        }
    }
}

