/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.AbstractHealpixNestedMOC;
import cds.healpix.HealpixNestedBMOC;
import java.util.Arrays;
import java.util.Iterator;

final class HealpixNestedMOC
extends AbstractHealpixNestedMOC<AbstractHealpixNestedMOC.CurrentCellAccessor> {
    private HealpixNestedMOC(int mocDepth, long[] mocCells) {
        this(mocDepth, mocCells, mocCells.length);
    }

    private HealpixNestedMOC(int mocDepth, long[] mocCells, int toIndex) {
        super(mocDepth, mocCells, toIndex);
    }

    public HealpixNestedMOC toDeeperDepth(int newDepth) {
        if (newDepth <= this.depthMax) {
            throw new IllegalArgumentException("The given depth must be higher than the depth max of the MOC");
        }
        int twiceDepthDiff = newDepth - this.depthMax << 1;
        long[] mocNew = new long[this.to];
        for (int i = 0; i < this.to; ++i) {
            long c = this.cells[i];
            mocNew[i] = c << twiceDepthDiff;
        }
        return new HealpixNestedMOC(newDepth, mocNew);
    }

    public HealpixNestedMOC toLowerDepth(int newDepth) {
        if (newDepth >= this.depthMax) {
            throw new IllegalArgumentException("The given depth lust be lower than the depth max of the MOC");
        }
        long[] mocNew = new long[this.to];
        int iNew = 0;
        long prevHashAtNewDepth = -1L;
        for (int i = 0; i < this.to; ++i) {
            long raw = this.cells[i];
            int depth = HealpixNestedMOC.getDepth(raw, this.depthMax);
            if (depth <= newDepth) {
                mocNew[iNew++] = raw;
                continue;
            }
            long currHashAtNewDepth = HealpixNestedMOC.getHashFromDepth(raw, depth) >> depth - newDepth;
            if (prevHashAtNewDepth == currHashAtNewDepth) continue;
            mocNew[iNew++] = prevHashAtNewDepth << 1 | 1L;
            prevHashAtNewDepth = currHashAtNewDepth;
        }
        return HealpixNestedMOC.newFrom(newDepth, mocNew, iNew);
    }

    public HealpixNestedMOC and(HealpixNestedMOC rightMoc) {
        int depthMax = Math.max(this.depthMax, rightMoc.depthMax);
        long[] result = new long[Math.min(this.size(), rightMoc.size())];
        int iResult = 0;
        Iterator<AbstractHealpixNestedMOC.CurrentCellAccessor> leftIt = this.iterator();
        Iterator<AbstractHealpixNestedMOC.CurrentCellAccessor> rightIt = rightMoc.iterator();
        if (!leftIt.hasNext() || !rightIt.hasNext()) {
            return new HealpixNestedMOC(depthMax, result, iResult);
        }
        AbstractHealpixNestedMOC.CurrentCellAccessor currLeft = leftIt.next();
        AbstractHealpixNestedMOC.CurrentCellAccessor currRight = rightIt.next();
        int dl = currLeft.getDepth();
        int dr = currRight.getDepth();
        long hl = currLeft.getHash();
        long hr = currRight.getHash();
        while (true) {
            int dd;
            if (dl < dr) {
                dd = dr - dl;
                long hrAtdl = hr >>> (dd << 1);
                if (hl < hrAtdl) {
                    if (!leftIt.hasNext()) break;
                    currLeft = leftIt.next();
                    dl = currLeft.getDepth();
                    hl = currLeft.getHash();
                    continue;
                }
                if (hl > hrAtdl) {
                    if (!rightIt.hasNext()) break;
                    currRight = rightIt.next();
                    dr = currRight.getDepth();
                    hr = currRight.getHash();
                    continue;
                }
                assert (hl == hrAtdl);
                result[iResult++] = currRight.getMOCEncodedHash();
                if (!rightIt.hasNext()) break;
                currRight = rightIt.next();
                dr = currRight.getDepth();
                hr = currRight.getHash();
                continue;
            }
            if (dl > dr) {
                dd = dl - dr;
                long hlAtdr = hl >>> (dd << 1);
                if (hlAtdr < hr) {
                    if (!leftIt.hasNext()) break;
                    currLeft = leftIt.next();
                    dl = currLeft.getDepth();
                    hl = currLeft.getHash();
                    continue;
                }
                if (hlAtdr > hr) {
                    if (!rightIt.hasNext()) break;
                    currRight = rightIt.next();
                    dr = currRight.getDepth();
                    hr = currRight.getHash();
                    continue;
                }
                assert (hlAtdr == hr);
                result[iResult++] = currLeft.getMOCEncodedHash();
                if (!leftIt.hasNext()) break;
                currLeft = leftIt.next();
                dl = currLeft.getDepth();
                hl = currLeft.getHash();
                continue;
            }
            assert (dl == dr);
            if (hl < hr) {
                if (!leftIt.hasNext()) break;
                currLeft = leftIt.next();
                dl = currLeft.getDepth();
                hl = currLeft.getHash();
                continue;
            }
            if (hl > hr) {
                if (!rightIt.hasNext()) break;
                currRight = rightIt.next();
                dr = currRight.getDepth();
                hr = currRight.getHash();
                continue;
            }
            assert (hl == hr);
            result[iResult++] = currLeft.getMOCEncodedHash();
            if (!leftIt.hasNext() || !rightIt.hasNext()) break;
            currLeft = leftIt.next();
            dl = currLeft.getDepth();
            hl = currLeft.getHash();
            currRight = rightIt.next();
            dr = currRight.getDepth();
            hr = currRight.getHash();
        }
        return HealpixNestedMOC.newFrom(depthMax, result, iResult);
    }

    public HealpixNestedMOC or(HealpixNestedMOC rightMoc) {
        int depthMax = Math.max(this.depthMax, rightMoc.depthMax);
        Iterator<AbstractHealpixNestedMOC.CurrentCellAccessor> leftIt = this.iterator();
        Iterator<AbstractHealpixNestedMOC.CurrentCellAccessor> rightIt = rightMoc.iterator();
        if (!leftIt.hasNext()) {
            return new HealpixNestedMOC(depthMax, Arrays.copyOf(rightMoc.cells, rightMoc.to));
        }
        if (!rightIt.hasNext()) {
            return new HealpixNestedMOC(depthMax, Arrays.copyOf(this.cells, this.to));
        }
        long[] result = new long[this.size() + rightMoc.size()];
        int iResult = 0;
        AbstractHealpixNestedMOC.CurrentCellAccessor currLeft = leftIt.next();
        AbstractHealpixNestedMOC.CurrentCellAccessor currRight = rightIt.next();
        int dl = currLeft.getDepth();
        int dr = currRight.getDepth();
        long hl = currLeft.getHash();
        long hr = currRight.getHash();
        while (true) {
            int dd;
            if (dl < dr) {
                dd = dr - dl;
                long hrAtdl = hr >>> (dd << 1);
                if (hl < hrAtdl) {
                    result[iResult++] = currLeft.getMOCEncodedHash();
                    if (!leftIt.hasNext()) {
                        iResult = HealpixNestedMOC.completeWith(rightIt, result, iResult);
                        break;
                    }
                    currLeft = leftIt.next();
                    dl = currLeft.getDepth();
                    hl = currLeft.getHash();
                    continue;
                }
                if (hrAtdl < hl) {
                    result[iResult++] = currRight.getMOCEncodedHash();
                    if (!rightIt.hasNext()) {
                        iResult = HealpixNestedMOC.completeWith(leftIt, result, iResult);
                        break;
                    }
                    currRight = rightIt.next();
                    dr = currRight.getDepth();
                    hr = currRight.getHash();
                    continue;
                }
                assert (hl == hrAtdl);
                result[iResult++] = currLeft.getMOCEncodedHash();
                if (!leftIt.hasNext()) {
                    iResult = HealpixNestedMOC.completeWith(rightIt, result, iResult);
                    break;
                }
                do {
                    if (rightIt.hasNext()) continue;
                    iResult = HealpixNestedMOC.completeWith(leftIt, result, iResult);
                    break;
                } while (HealpixNestedMOC.contains(dl, hl, dr = (currRight = rightIt.next()).getDepth(), hr = currRight.getHash()));
                currLeft = leftIt.next();
                dl = currLeft.getDepth();
                hl = currLeft.getHash();
                continue;
            }
            if (dl > dr) {
                dd = dl - dr;
                long hlAtdr = hl >>> (dd << 1);
                if (hlAtdr < hr) {
                    result[iResult++] = currLeft.getMOCEncodedHash();
                    if (!leftIt.hasNext()) {
                        iResult = HealpixNestedMOC.completeWith(rightIt, result, iResult);
                        break;
                    }
                    currLeft = leftIt.next();
                    dl = currLeft.getDepth();
                    hl = currLeft.getHash();
                    continue;
                }
                if (hr < hlAtdr) {
                    result[iResult++] = currRight.getMOCEncodedHash();
                    if (!rightIt.hasNext()) {
                        iResult = HealpixNestedMOC.completeWith(leftIt, result, iResult);
                        break;
                    }
                    currRight = rightIt.next();
                    dr = currRight.getDepth();
                    hr = currRight.getHash();
                    continue;
                }
                assert (hlAtdr == hr);
                result[iResult++] = currRight.getMOCEncodedHash();
                if (!rightIt.hasNext()) {
                    iResult = HealpixNestedMOC.completeWith(leftIt, result, iResult);
                    break;
                }
                do {
                    if (leftIt.hasNext()) continue;
                    iResult = HealpixNestedMOC.completeWith(rightIt, result, iResult);
                    break;
                } while (HealpixNestedMOC.contains(dr, hr, dl = (currLeft = leftIt.next()).getDepth(), hl = currLeft.getHash()));
                currRight = rightIt.next();
                dr = currRight.getDepth();
                hr = currRight.getHash();
                continue;
            }
            assert (dl == dr);
            if (hl < hr) {
                result[iResult++] = currLeft.getMOCEncodedHash();
                if (!leftIt.hasNext()) {
                    iResult = HealpixNestedMOC.completeWith(rightIt, result, iResult);
                    break;
                }
                currLeft = leftIt.next();
                dl = currLeft.getDepth();
                hl = currLeft.getHash();
                continue;
            }
            if (hr < hl) {
                result[iResult++] = currRight.getMOCEncodedHash();
                if (!rightIt.hasNext()) {
                    iResult = HealpixNestedMOC.completeWith(leftIt, result, iResult);
                    break;
                }
                currRight = rightIt.next();
                dr = currRight.getDepth();
                hr = currRight.getHash();
                continue;
            }
            assert (hl == hr);
            result[iResult++] = currLeft.getMOCEncodedHash();
            if (!leftIt.hasNext()) {
                iResult = HealpixNestedMOC.completeWith(rightIt, result, iResult);
                break;
            }
            if (!rightIt.hasNext()) {
                iResult = HealpixNestedMOC.completeWith(leftIt, result, iResult);
                break;
            }
            currLeft = leftIt.next();
            dl = currLeft.getDepth();
            hl = currLeft.getHash();
            currRight = rightIt.next();
            dr = currRight.getDepth();
            hr = currRight.getHash();
        }
        return HealpixNestedMOC.newFrom(depthMax, result, iResult);
    }

    private static int completeWith(Iterator<AbstractHealpixNestedMOC.CurrentCellAccessor> it, long[] result, int iResult) {
        while (it.hasNext()) {
            result[iResult++] = it.next().getMOCEncodedHash();
        }
        return iResult;
    }

    private static final boolean contains(int largeCellDepth, long largeCellHash, int smallCellDepth, long smallCellHash) {
        return largeCellDepth <= smallCellDepth && largeCellHash == smallCellHash >>> (smallCellDepth - largeCellDepth << 1);
    }

    /*
     * Exception decompiling
     */
    public HealpixNestedMOC xor(HealpixNestedMOC rightMoc) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public HealpixNestedMOC not() {
        long[] result = new long[3 * this.size() + 12];
        Iterator<AbstractHealpixNestedMOC.CurrentCellAccessor> it = this.iterator();
        if (!it.hasNext()) {
            for (int i = 0; i < 12; ++i) {
                result[i] = HealpixNestedMOC.encodeHash4MOC(0, i, this.depthMax);
            }
            return new HealpixNestedMOC(this.depthMax, result);
        }
        AbstractHealpixNestedMOC.CurrentCellAccessor v = it.next();
        int iResult = 0;
        int d = v.getDepth();
        int prevd = 0;
        long h = v.getHash();
        long prevh = 0L;
        int currd = 0;
        int dd = d;
        while (dd >= 0) {
            long targetHash = h >>> (dd << 1);
            while (prevh < targetHash) {
                result[iResult++] = HealpixNestedMOC.encodeHash4MOC(currd, prevh, this.depthMax);
                ++prevh;
            }
            prevh <<= 2;
            --dd;
            ++currd;
        }
        prevd = d;
        prevh = h;
        while (it.hasNext()) {
            long hAtPrevDepth;
            v = it.next();
            d = v.getDepth();
            h = v.getHash();
            int dd2 = d - prevd;
            if (dd2 < 0) {
                int nBits = -dd2 << 1;
                hAtPrevDepth = h << nBits;
            } else {
                hAtPrevDepth = h >>> (dd2 << 1);
            }
            dd2 = 63 - Long.numberOfLeadingZeros(prevh ^ hAtPrevDepth) >> 1;
            if (dd2 > prevd) {
                dd2 = prevd;
            }
            while (dd2 > 0) {
                while ((prevh & 3L) < 3L) {
                    result[iResult++] = HealpixNestedMOC.encodeHash4MOC(prevd, prevh, this.depthMax);
                    ++prevh;
                }
                prevh >>= 2;
                --dd2;
                --prevd;
            }
            ++prevh;
            for (dd2 = d - prevd; dd2 >= 0; --dd2) {
                long targetHash = h >>> (dd2 << 1);
                while (prevh < targetHash) {
                    result[iResult++] = HealpixNestedMOC.encodeHash4MOC(prevd, prevh, this.depthMax);
                    ++prevh;
                }
                prevh <<= 2;
            }
            prevd = d;
            prevh = h;
        }
        while (d > 0) {
            while ((h & 3L) < 3L) {
                result[iResult++] = HealpixNestedMOC.encodeHash4MOC(d, h, this.depthMax);
                ++h;
            }
            h >>= 2;
            --d;
        }
        ++h;
        while (h < 12L) {
            result[iResult++] = HealpixNestedMOC.encodeHash4MOC(0, h, this.depthMax);
            ++h;
        }
        return HealpixNestedMOC.newFrom(this.depthMax, result, iResult);
    }

    private static final HealpixNestedMOC newFrom(int depthMax, long[] a, int i) {
        return (double)((float)i / (float)a.length) > 0.75 ? new HealpixNestedMOC(depthMax, a, i) : new HealpixNestedMOC(depthMax, Arrays.copyOf(a, i));
    }

    public static HealpixNestedMOC createUnsafe(int mocDepth, long[] mocCells) {
        return new HealpixNestedMOC(mocDepth, mocCells);
    }

    public static HealpixNestedMOC createUnsafe(int mocDepth, long[] mocCells, int toIndex) {
        return new HealpixNestedMOC(mocDepth, mocCells);
    }

    public static HealpixNestedMOC createCheck(int mocDepth, long[] mocCells) {
        HealpixNestedMOC.checkIsSortedNoDuplicateNoOverlap(mocCells);
        return HealpixNestedMOC.createUnsafe(mocDepth, mocCells);
    }

    public static HealpixNestedMOC createCheck(int mocDepth, long[] mocCells, int toIndex) {
        HealpixNestedMOC.checkIsSortedNoDuplicateNoOverlap(mocCells);
        return HealpixNestedMOC.createUnsafe(mocDepth, mocCells, toIndex);
    }

    public static HealpixNestedBMOC create(int mocDepth, long[] mocCells) {
        throw new Error("Method not yet implemented!");
    }

    @Override
    public Iterator<AbstractHealpixNestedMOC.CurrentCellAccessor> iterator() {
        return new AbstractHealpixNestedMOC.Iter(){

            protected AbstractHealpixNestedMOC.CurrentCellAccessor returnThis() {
                return this;
            }

            @Override
            protected void calledInNext(int i) {
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

