/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.htm.core;

import edu.jhu.htm.core.HTMindexImp;
import edu.jhu.htm.core.Layer;
import edu.jhu.htm.core.QuadNode;
import edu.jhu.htm.core.Vector3d;

public class HTMedge {
    HTMindexImp tree_;
    Edge[] lTab_;
    Edge[] edges_;
    int index_;
    Layer layer_;

    HTMedge(HTMindexImp hTMindexImp, int n) {
        this.tree_ = hTMindexImp;
        this.layer_ = this.tree_.getLayer(n);
        this.edges_ = new Edge[this.layer_.nEdge_ + 1];
        this.lTab_ = new Edge[this.layer_.nVert_ * 6];
        this.index_ = this.layer_.nVert_;
    }

    void makeMidPoints() {
        int n = 0;
        int n2 = this.layer_.firstIndex_;
        int n3 = 0;
        while (n3 < this.layer_.nNode_) {
            n = this.newEdge(n, n2, 0);
            n = this.newEdge(n, n2, 1);
            n = this.newEdge(n, n2, 2);
            ++n3;
            ++n2;
        }
    }

    int newEdge(int n, int n2, int n3) {
        Edge edge;
        Edge edge2;
        this.edges_[n] = edge2 = new Edge();
        QuadNode quadNode = this.tree_.getNode(n2);
        if (n3 == 0) {
            edge2.start_ = quadNode.v_[1];
            edge2.end_ = quadNode.v_[2];
        } else if (n3 == 1) {
            edge2.start_ = quadNode.v_[0];
            edge2.end_ = quadNode.v_[2];
        } else {
            edge2.start_ = quadNode.v_[0];
            edge2.end_ = quadNode.v_[1];
        }
        if (edge2.start_ > edge2.end_) {
            int n4 = edge2.start_;
            edge2.start_ = edge2.end_;
            edge2.end_ = n4;
        }
        if ((edge = this.edgeMatch(edge2)) != null) {
            quadNode.w_[n3] = edge.mid_;
            return n;
        }
        this.insertLookup(edge2);
        quadNode.w_[n3] = edge2.mid_ = this.getMidPoint(edge2);
        return ++n;
    }

    void insertLookup(Edge edge) {
        int n = 6 * edge.start_;
        int n2 = 0;
        while (n2 < 6) {
            if (this.lTab_[n] == null) {
                this.lTab_[n] = edge;
                return;
            }
            ++n2;
            ++n;
        }
    }

    Edge edgeMatch(Edge edge) {
        int n = 6 * edge.start_;
        while (this.lTab_[n] != null) {
            if (edge.end_ == this.lTab_[n].end_) {
                return this.lTab_[n];
            }
            ++n;
        }
        return null;
    }

    int getMidPoint(Edge edge) {
        Vector3d vector3d = this.tree_.getVertex(edge.start_).add(this.tree_.getVertex(edge.end_));
        vector3d.normalize();
        this.tree_.add(vector3d, this.index_);
        return this.index_++;
    }

    public class Edge {
        public int start_;
        public int end_;
        public int mid_;
    }
}

