/* ====================================================================
 * Copyright (c) 2008  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "HeaderSettings.h"

// qt
#include <QtGui/QHeaderView>


HeaderSettings::HeaderSettings( QHeaderView* header )
: _h(header)
{
}

sc::String HeaderSettings::toString()
{
  QString sections;
  
  for( int i = 0; i < _h->count(); i++ )
  {
    QString v;
    int s = _h->logicalIndex(i);
    v.setNum(s);
    sections += v;
    sections += ":";    
    v.setNum( _h->sectionSize(s) );
    sections += v;
    sections += ",";    
  }
  // strip trailing ","
  sections.truncate( sections.length()-1 );

  return sc::String(sections.toUtf8());
}

void HeaderSettings::fromString( const sc::String& settings )
{
  QString qval((const char*)settings);

  int cnt = 0;
  while(true)
  {    
    QString section = qval.section( ',', cnt );

    if( section.isEmpty() )
      break;

    QRegExp exp("(\\d+):(\\d+)");
    exp.exactMatch(section);
    
    _h->moveSection( cnt, exp.cap(1).toInt() );
    _h->resizeSection( exp.cap(1).toInt(), exp.cap(2).toInt() );
    cnt++;
  }
}
