/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFF3_H
#define _SC_DIFF3_H

// sc
#include "util/FileData.h"
#include "util/String.h"
class DiffInfoModel;
namespace sc {
  class Error;
}


class Diff3
{
public:
  Diff3( const FileDataPtr original, const FileDataPtr modified,
    const FileDataPtr latest, const sc::String& merged );
  ~Diff3();

  const sc::Error* diff3( bool ignoreWhitespace = false );

  DiffInfoModel* getDiffInfo() const
  {
    return _diffInfo;
  }

private:
  // in
  FileDataPtr _original;
  FileDataPtr _modified;
  FileDataPtr _latest;
  sc::String  _merged;

  // out
  DiffInfoModel* _diffInfo;
};

#endif // _SC_DIFF3_H
