// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef CROUZEIXRAVIART_IS_INCLUDED
#define CROUZEIXRAVIART_IS_INCLUDED

#include "FE.h"

namespace SyFi
{

	class CrouzeixRaviart : public StandardFE
	{
		public:
			CrouzeixRaviart();
			CrouzeixRaviart(Polygon& p, unsigned int order = 1);
			virtual ~CrouzeixRaviart() {}

			void compute_basis_functions();
	};

	class VectorCrouzeixRaviart : public StandardFE
	{
		protected:
			unsigned int size;
		public:
			VectorCrouzeixRaviart();
			VectorCrouzeixRaviart(Polygon& p, unsigned int order = 1, unsigned int size = -1);
			virtual ~VectorCrouzeixRaviart() {}

			virtual void set_size(unsigned int size_);
			virtual void compute_basis_functions();
	};

}
#endif
