/* === S Y N F I G ========================================================= */
/*!	\file synfig/rendering/software/function/blur_iir_coefficients.hpp
**	\brief Initialization of IIR coefficients for Blur
**
**	$Id$
**
**	\legal
**	......... ... 2016 Ivan Mahonin
**
**	This package is free software; you can redistribute it and/or
**	modify it under the terms of the GNU General Public License as
**	published by the Free Software Foundation; either version 2 of
**	the License, or (at your option) any later version.
**
**	This package is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**	General Public License for more details.
**	\endlegal
*/

/* ========================================================================= */

/* === H E A D E R S ======================================================= */

#include <synfig/real.h>
/* === M A C R O S ========================================================= */

/* === G L O B A L S ======================================================= */

/* === P R O C E D U R E S ================================================= */

/* === M E T H O D S ======================================================= */

constexpr synfig::Real iir_coefficients_unprepared[][3] = {
	{ 0.45313319191336631775, 0.37030425295233726501, 0.42185796722769736133 },
	{ 0.47401428446173671238, 0.34647000357508656032, 0.44355906620621676772 },
	{ 0.49175928458571438462, 0.32472521439194673709, 0.46248708739876753793 },
	{ 0.50780449584126474694, 0.30499233528971664287, 0.47976472005248071984 },
	{ 0.52282591685652746172, 0.28712423667311665065, 0.49594448432326321274 },
	{ 0.5371419258415698339, 0.27095006629824636146, 0.51130555048584935829 },
	{ 0.55089805200695984855, 0.2562968827784061765, 0.52599096372723586068 },
	{ 0.56415559723973285333, 0.24299995824694631263, 0.54007412865757964404 },
	{ 0.57693636640906331703, 0.23090762570500375506, 0.55359314009547233582 },
	{ 0.58924567326903343201, 0.21988317146897318199, 0.56656913086771953925 },
	{ 0.60108401104807851478, 0.20980508849024773199, 0.57901618406176569298 },
	{ 0.61245266124606134728, 0.20056638643145560663, 0.5909465409815312098 },
	{ 0.6233558855950832589, 0.19207338616251945496, 0.60237300321459763541 },
	{ 0.63380151763558389977, 0.18424432501196863488, 0.61330992653965943351 },
	{ 0.64380064532160763413, 0.17700792625546454828, 0.62377334907650949791 },
	{ 0.6533669687807559523, 0.17030203267931937061, 0.63378072008490560219 },
	{ 0.66251615509390826553, 0.16407238617539407488, 0.64335056766867626532 },
	{ 0.67126512303948393523, 0.15827152058482168995, 0.65250201448798172965 },
	{ 0.67963153496384620667, 0.15285782590508462109, 0.66125445738434796006 },
	{ 0.68763331845402719811, 0.14779471680521966137, 0.6696272023022173947 },
	{ 0.69528831914067257269, 0.14304993674159049988, 0.67763921990990649835 },
	{ 0.70261409357190141023, 0.13859497234225273687, 0.68530900701880448356 },
	{ 0.70962765440344810486, 0.13440452888607978821, 0.69265436604619012861 },
	{ 0.71634543463587763146, 0.13045612499117850702, 0.69969243332743646935 },
	{ 0.7227831311523913449, 0.12672969922423363287, 0.70643951073288913101 },
	{ 0.72895569428801532119, 0.12320731356739997309, 0.71291109994053836196 },
	{ 0.73487733229994778306, 0.11987288370728492459, 0.71912190690636634827 },
	{ 0.74056145325303079918, 0.11671194210648536127, 0.72508579120039928778 },
	{ 0.74602073803544055597, 0.11371146067976951877, 0.73081586882472038269 },
	{ 0.75126713737845429719, 0.11085966154932976047, 0.73632448390126237214 },
	{ 0.75631188377738001183, 0.10814587399363517761, 0.74162322953343395859 },
	{ 0.76116553917527196571, 0.1055604226887226077, 0.74672302827239023237 },
	{ 0.7658380351960658583, 0.10309450104832648676, 0.75163414105772974327 },
	{ 0.77033871933817854583, 0.10074008628726005554, 0.7563662223517895189 },
	{ 0.77467633411288272516, 0.098489847034215927124, 0.76092831566929808318 },
	{ 0.7788591228425502111, 0.096337076276540756226, 0.76532893702387816415 },
	{ 0.78289481326937682137, 0.094275631755590436067, 0.76957609429955475822 },
	{ 0.78679066523909568787, 0.092299861460924143008, 0.77367728725075723961 },
	{ 0.79055350348353392587, 0.090404578298330304231, 0.77763959392905246393 },
	{ 0.79418975338339803383, 0.088584997504949566927, 0.78146966919302940369 },
	{ 0.79770543947815897301, 0.086836699396371827553, 0.78517375066876415879 },
	{ 0.80110625550150871277, 0.085155607014894482698, 0.78875774219632155404 },
	{ 0.80439752712845802307, 0.083537941426038736514, 0.7922271750867367901 },
	{ 0.80758430436253547668, 0.081980203837156290225, 0.79558728709816928237 },
	{ 0.8106713421642780526, 0.080479145795106885042, 0.79884301349520681068 },
	{ 0.81366307660937309265, 0.079031740874052042178, 0.80199896469712250724 },
	{ 0.81656376495957372352, 0.07763518467545507673, 0.80505956187844263106 },
	{ 0.8193773724138737613, 0.076286856085062026978, 0.80802893415093424156 },
	{ 0.82210767939686779648, 0.074984312802553174104, 0.81091100201010712922 },
	{ 0.82475821301341045722, 0.07372527197003364563, 0.81370944604277606338 },
	{ 0.82733236625790596008, 0.072507605701684949007, 0.81642780229449274376 },
	{ 0.82983331903815260588, 0.07132931277155875327, 0.81906936541199681923 },
	{ 0.83226405307650563881, 0.070188520103693002872, 0.82163725420832633972 },
	{ 0.83462746068835269586, 0.06908347979187964838, 0.82413448020815838202 },
	{ 0.83692621961236013384, 0.068012540787458414249, 0.82656384035944929778 },
	{ 0.83916292861104013756, 0.066974156349897381868, 0.82892803028225903184 },
	{ 0.84133998677134524957, 0.065966869145631781834, 0.83122956827282901138 },
	{ 0.84345972612500186294, 0.064989308267831807919, 0.83347088024020188346 },
	{ 0.8455243416130542311, 0.064040184766054136789, 0.83565426543354992539 },
	{ 0.84753592982888215079, 0.063118279725313169992, 0.83778190687298770278 },
	{ 0.84949645474553103774, 0.062222439795732498169, 0.8398558579385280165 },
	{ 0.85140782669186598763, 0.061351583153009418836, 0.84187811836600312532 },
	{ 0.85327183231711389855, 0.060504678636789321899, 0.84385055080056181609 },
	{ 0.85509019270539277091, 0.059680754691362386533, 0.84577495083212850258 },
	{ 0.85686454400420197786, 0.058878896385431291061, 0.84765304252505302429 },
	{ 0.85859644487500186294, 0.058098232001066209274, 0.84948645606636996597 },
	{ 0.86028736308217046425, 0.057337924093008037218, 0.85127670839428903893 },
	{ 0.86193875446915624305, 0.056597205251455305619, 0.85302535071969032288 },
	{ 0.86355193629860871329, 0.055875318497419355912, 0.8547337450087070243 },
	{ 0.86512820646166810334, 0.055171557515859601106, 0.85640325620770452186 },
	{ 0.86666885241866109535, 0.054485257714986801147, 0.858035228401422434 },
	{ 0.86817500069737429946, 0.053815772384405137496, 0.85963084772229203523 },
	{ 0.86964779719710361139, 0.053162493556737903944, 0.86119131669402115836 },
	{ 0.87108833715319633484, 0.052524841576814654265, 0.86271777674555782944 },
	{ 0.87249765917658805847, 0.051902268081903457642, 0.86421132907271380752 },
	{ 0.87387675717473034531, 0.051294241100549697876, 0.86567300185561169013 },
	{ 0.875226565450429983, 0.050700256973505018754, 0.86710378453135483756 },
	{ 0.87654802277684218392, 0.050119840353727344862, 0.86850466206669807434 },
	{ 0.87784199491143233285, 0.049552529305219646105, 0.86987653747200965881 },
	{ 0.87910932525992391273, 0.048997888714075087113, 0.87122030183672904968 },
	{ 0.88035080805420884431, 0.048455495387315750122, 0.87253678664565081924 },
	{ 0.88156723901629452378, 0.047924951463937763563, 0.87382682338356953977 },
	{ 0.882759379595518201, 0.047405878454446791215, 0.87509121969342218428 },
	{ 0.88392789140343663856, 0.046897902339696886931, 0.87633067443966849996 },
	{ 0.88507350459694866807, 0.046400674432516102186, 0.87754594460129742295 },
	{ 0.88619686141610154451, 0.045913856476545333862, 0.87873771116137500137 },
	{ 0.88729862496256828308, 0.045437128096818928114, 0.87990666553378094061 },
	{ 0.88837937936186783805, 0.044970176368951800261, 0.88105342611670489639 },
	{ 0.88943972662091252968, 0.044512707740068435669, 0.88217863067984580994 },
	{ 0.89048023894429206848, 0.044064434617757802792, 0.88328287675976746574 },
	{ 0.89150146320462231309, 0.043625081330537794633, 0.88436673060059545204 },
	{ 0.89250392243266107872, 0.043194387108087539673, 0.88543075546622262983 },
	{ 0.89348814114928232222, 0.042772101610898977109, 0.88647550269961361558 },
	{ 0.8944545753300190416, 0.042357974499464039198, 0.88750144913792605728 },
	{ 0.89540374353528018325, 0.041951779276132583618, 0.88850913867354397446 },
	{ 0.89633607491850841864, 0.041553286463022233443, 0.88949902579188344642 },
	{ 0.89725201204419136047, 0.041162277013063429398, 0.89047156795859327971 },
	{ 0.89815198704600340829, 0.040778548270463947645, 0.89142723754048336371 },
	{ 0.89903641417622570664, 0.040401897579431536589, 0.89236646071076397568 },
	{ 0.89990568533539772034, 0.040032128244638441605, 0.89328964725136761338 },
	{ 0.90076017752289772034, 0.039669054001569746537, 0.89419719949364651068 },
	{ 0.90160027369856832191, 0.039312497526407239046, 0.89508952274918551772 },
	{ 0.90242634192109105751, 0.038962284475564955277, 0.8959669940173625724 },
	{ 0.90323869958519942269, 0.038618244975805279817, 0.89682996198534969956 },
	{ 0.90403771921992304161, 0.038280222564935684204, 0.8976788140833377172 },
	{ 0.9048236943781375885, 0.037948054820299149947, 0.89851385578513143226 },
	{ 0.90559695437550546959, 0.037621594220399852404, 0.89933543875813481971 },
	{ 0.90635781362652778625, 0.037300697714090343127, 0.90014389380812631636 },
	{ 0.90710654035210613877, 0.036985217779874804411, 0.9009395025670529078 },
	{ 0.90784344151616103158, 0.036675024777650826191, 0.90172259286046030358 },
	{ 0.90856879726052275359, 0.036369984596967698531, 0.90249345228075972258 },
	{ 0.9092828579246996501, 0.036069969087839125199, 0.90325235202908504828 },
	{ 0.90998590216040597944, 0.03577485904097557623, 0.90399958714842787444 },
	{ 0.91067815646529193252, 0.035484527796506883102, 0.90473538711667056411 },
	{ 0.91135989353060731233, 0.035198869556188588925, 0.90546005293726916641 },
	{ 0.91203134283423414885, 0.034917766600847242875, 0.90617381706833843857 },
	{ 0.912692720443010308, 0.034641110152006153455, 0.90687690600752823844 },
	{ 0.91334428861737249061, 0.034368804842233653674, 0.90756961032748206808 },
	{ 0.91398620679974551528, 0.034100735932588575883, 0.90825208500027654335 },
	{ 0.91461873278021810219, 0.033836814016103743119, 0.90892460420727716475 },
	{ 0.91524205878376951873, 0.033576942235231395373, 0.90958737656474109023 },
	{ 0.91585636064410202994, 0.033321025222539900346, 0.91024058535695073768 },
	{ 0.91646185591816908822, 0.033068976551294322619, 0.91088446155190461173 },
	{ 0.91705872938036914199, 0.032820706814527512984, 0.9115191914141177465 },
	{ 0.91764717325568201378, 0.032576137036085132948, 0.91214499101042734175 },
	{ 0.91822732761502268151, 0.03233517631888389865, 0.91276199892163267791 },
	{ 0.91879941150546073914, 0.03209775462746620317, 0.91337045207619671494 },
	{ 0.91936355307698247596, 0.031863787025213238802, 0.91397048309445372283 },
	{ 0.91991994306445123986, 0.031633204966783526335, 0.91456229463219640419 },
	{ 0.92046872451901440293, 0.031405930966138841109, 0.91514603868126875863 },
	{ 0.92101005539298064217, 0.031181897968053817749, 0.91572188362479201018 },
	{ 0.92154408916831009879, 0.030961035937070849333, 0.91628999188542359366 },
	{ 0.92207097634673118591, 0.030743276327848435836, 0.91685051098465908392 },
	{ 0.92259085252881045669, 0.030528556555509567261, 0.91740359887480737999 },
	{ 0.92310384437441828087, 0.030316809564828871293, 0.9179493807256220439 },
	{ 0.92361009791493420273, 0.030107978731393814087, 0.91848802044987665205 },
	{ 0.92410977110266678825, 0.029902005940675734086, 0.9190196759998796594 },
	{ 0.92460295185446750299, 0.029698825627565386687, 0.91954443827271459266 },
	{ 0.92508977428078653649, 0.029498387128114700317, 0.92006246373057365417 },
	{ 0.92557036206126219735, 0.029300632327795027299, 0.92057387158274650574 },
	{ 0.92604484632611261397, 0.029105510562658309937, 0.92107880190014834731 },
	{ 0.92651333436369887053, 0.028912965208292007446, 0.92157736197113981902 },
	{ 0.92697593197226535455, 0.028722951561212538285, 0.92206967845559117958 },
	{ 0.92743277028203008339, 0.028535417467355723986, 0.92255587950348849624 },
	{ 0.92788393720984452262, 0.028350313752889634566, 0.92303606197237964004 },
	{ 0.92832952067255969375, 0.028167591243982319227, 0.92351031973958008781 },
	{ 0.92876966670155525208, 0.027987211197614665636, 0.92397880777716634437 },
	{ 0.92920444235205645889, 0.027809122949838636918, 0.92444159016013138785 },
	{ 0.92963396534323694542, 0.027633286267518999968, 0.92489879652857776016 },
	{ 0.93005830720067028672, 0.027459656447172166305, 0.92535050734877588585 },
	{ 0.93047756686806692983, 0.027288191825151440068, 0.92579681816697090291 },
	{ 0.93089185367524629466, 0.027118854627013199571, 0.92623784513771501015 },
	{ 0.93130123928189278981, 0.026951606214046471, 0.92667367437481817927 },
	{ 0.93170580443739892118, 0.026786404371261580276, 0.92710438594221988851 },
	{ 0.93210565192997452133, 0.026623217031359652091, 0.92753008864819930235 },
	{ 0.9325008586943148714, 0.026462001860141727561, 0.92795085683464906268 },
	{ 0.93289148359000662047, 0.026302727088332145122, 0.92836676616966617992 },
	{ 0.9332776338756081369, 0.026145356655120813305, 0.92877791941165821488 },
	{ 0.93365937684476341119, 0.025989855870604469668, 0.92918438751995457991 },
	{ 0.93403677541017482433, 0.025836195796728089052, 0.9295862544774994296 },
	{ 0.93440991212427571, 0.025684336259961079024, 0.92998358203470532501 },
	{ 0.93477886411547606027, 0.025534254252910559835, 0.93037647292017744416 },
	{ 0.93514369656145512888, 0.025385912910103742429, 0.93076498414575836726 },
	{ 0.93550447058677610457, 0.025239283859729708809, 0.93114918339252239488 },
	{ 0.93586126939952296588, 0.025094338193535747211, 0.93152915869652985759 },
	{ 0.93621415048837586248, 0.024951048165559708281, 0.93190497183799503311 },
	{ 0.93656317128240984538, 0.024809382870793279113, 0.93227668677270147946 },
	{ 0.93690839555859495302, 0.024669314771890570037, 0.93264436337351519501 },
	{ 0.93724989958107407517, 0.024530821874737665511, 0.93300809316336819066 },
	{ 0.93758772745728413689, 0.024393872052431028741, 0.93336791217326819936 },
	{ 0.9379219397753468801, 0.024258442476391715859, 0.93372389392554466792 },
	{ 0.93825259813666239683, 0.024124506801366726871, 0.93407609623670273535 },
	{ 0.93857976008951549129, 0.023992041364312093055, 0.93442458026110808422 },
	{ 0.93890348739921947185, 0.02386102361977092412, 0.93476941882073549817 },
	{ 0.93922381174564262274, 0.023731426626443778705, 0.93511064159869838885 },
	{ 0.93954080380499260805, 0.023603227928280744868, 0.93544831781088955136 },
	{ 0.93985452210903042136, 0.023476409763097675493, 0.93578252029418595992 },
	{ 0.94016498516499857896, 0.023350941255688574538, 0.93611325763165598168 },
	{ 0.94047227978706215978, 0.023226809650659461376, 0.93644063147902145694 },
	{ 0.94077643205225325307, 0.023103988632559677163, 0.93676466266810543004 },
	{ 0.94107750508189091931, 0.022982459336519135695, 0.93708541926741240058 },
	{ 0.94137552490830322949, 0.022862200945615661352, 0.93740293291210752269 },
	{ 0.94167056521773251365, 0.02274319544434536336, 0.93771727940439808524 },
	{ 0.94196265162527470505, 0.022625419870018845941, 0.93802847968041513926 },
	{ 0.9422518261373032944, 0.022508858323097114679, 0.93833659052848394921 },
	{ 0.94253814171254524101, 0.022393490418791659607, 0.93864165915548369856 },
	{ 0.94282162427902116431, 0.022279298365116009806, 0.93894371885060812222 },
	{ 0.94310233122110276316, 0.022166265130042918374, 0.93924282944201953338 },
	{ 0.94338031242787756536, 0.022054371401667480224, 0.93953903077542300082 },
	{ 0.94365558344125655132, 0.021943600863218195446, 0.93983235603570458583 },
	{ 0.9439282021671523415, 0.021833940550684823728, 0.94012286616861351352 },
	{ 0.94419818758964435546, 0.021725367367267500035, 0.94041057628392699108 },
	{ 0.94446559225022685968, 0.021617866501212008867, 0.94069553227722157995 },
	{ 0.94473045897483698408, 0.021511427789926412107, 0.94097779875993214915 },
	{ 0.94499280615150793583, 0.021406029239296797684, 0.94125738199054664879 },
	{ 0.94525267538428170422, 0.021301657229661822429, 0.94153432714938578574 },
	{ 0.94551010482013087, 0.021198298647999640892, 0.94180868287383967541 },
	{ 0.9457651305496679317, 0.021095937788486358172, 0.94208047986030030163 },
	{ 0.94601777790486674125, 0.020994559690356132814, 0.94234974984824082522 },
	{ 0.9462680984139427709, 0.020894152343273044575, 0.94261653977631942869 },
	{ 0.94651610328256952087, 0.020794699624180675718, 0.9428808683603943086 },
	{ 0.94676183447241668567, 0.02069618833065021285, 0.94314277669786816816 },
	{ 0.94700532205402709884, 0.020598606511950379866, 0.94340230037271355368 },
	{ 0.94724658271670203469, 0.02050193953514088327, 0.94365946120023103116 },
	{ 0.94748566235601772156, 0.020406175002455603784, 0.94391429786383462819 },
	{ 0.94772259378433088006, 0.020311300933360941501, 0.94416684615611390363 },
	{ 0.94795738965272757781, 0.020217302799224741439, 0.94441712433099112012 },
	{ 0.94819009859859815226, 0.020124171152710802063, 0.94466517727076360078 },
	{ 0.94842074269056186875, 0.020031897306442145862, 0.94491104495524702589 },
	{ 0.94864932548999647555, 0.019940460503101227474, 0.94515471369027437287 },
	{ 0.94887591658532488559, 0.019849855855107186031, 0.94539625714718633631 },
	{ 0.94910050845146054499, 0.019760070145130034097, 0.94563567578791896118 },
	{ 0.94932313527166711786, 0.019671094462275377779, 0.94587301333247941759 },
	{ 0.94954382094740730214, 0.019582914054393645714, 0.94610827842354072725 },
	{ 0.94976260836422299327, 0.019495521113276355341, 0.9463415217846561367 },
	{ 0.94997949710488160946, 0.019408906042575706924, 0.94657275241612681693 },
	{ 0.95019452904164636298, 0.019323056176304687775, 0.94680200348793741583 },
	{ 0.95040772831439812585, 0.019237962603568897063, 0.9470293024182243613 },
	{ 0.95061909870803185107, 0.019153611019253599657, 0.94725464807449999416 },
	{ 0.95082868328690361981, 0.019069999933242664375, 0.94747810631989648478 },
	{ 0.95103649558126757135, 0.018987113907933103607, 0.94769967283307698924 },
	{ 0.95124255287647063728, 0.018904943972825875853, 0.94791937339305043508 },
	{ 0.95144689793884562601, 0.018823482558131095915, 0.94813724695145229493 },
	{ 0.95164953541755492594, 0.01874272176623331676, 0.94835331112145515586 },
	{ 0.95185049454867642904, 0.018662649318575735141, 0.94856758363544069201 },
	{ 0.9520497743189313411, 0.018583255529403566036, 0.94878006571530426605 },
	{ 0.95224742986261623479, 0.018504537388682240628, 0.94899082447587557176 },
	{ 0.9524434666037535635, 0.018426483601331585666, 0.94919985863565492501 },
	{ 0.95263788986205844012, 0.018349083334207406948, 0.94940717604755442416 },
	{ 0.95283073525130546066, 0.018272330269217363502, 0.94961281256376783855 },
	{ 0.95302201372384809375, 0.01819621634483323952, 0.94981678214668341376 },
	{ 0.95321175365149757308, 0.018120734915137156479, 0.95001911489664614408 },
	{ 0.95339997369050777376, 0.018045876502990582102, 0.95021982562541074113 },
	{ 0.95358667956292442192, 0.017971634045243121969, 0.95041892893611468196 },
	{ 0.95377189600467493502, 0.01789799857139573111, 0.95061644417046586852 },
	{ 0.9539556442946176551, 0.017824965342879150326, 0.95081240014730983301 },
	{ 0.95413793966173943151, 0.017752524524926992927, 0.95100680389999436848 },
	{ 0.9543187920302135252, 0.017680669918656195805, 0.95119967477022715485 },
	{ 0.95449823719262893995, 0.017609396815299833972, 0.95139105114339883595 },
	{ 0.95467626889049816974, 0.017538692221045339842, 0.95158091430365121521 },
	{ 0.9548529168963413305, 0.017468555718660197518, 0.9517693120241073057 },
	{ 0.95502819375693615012, 0.017398976102471194749, 0.95195624609290618867 },
	{ 0.95520212596654685555, 0.017329948693513716473, 0.9521417432427313754 },
	{ 0.95537470240890742801, 0.017261466965079155095, 0.95232580594717519684 },
	{ 0.95554595389961971552, 0.017193522304296333936, 0.95250845262407324299 },
	{ 0.95571591199934224914, 0.017126113161444501964, 0.95268972547351371549 },
	{ 0.95588457348942468261, 0.017059229642152624884, 0.95286961585282325959 },
	{ 0.95605195231735407013, 0.016992866411804988247, 0.95304814259706971402 },
	{ 0.95621807172894168758, 0.016927017003297645942, 0.95322532582282060165 },
	{ 0.95638293384015260479, 0.016861675515770752076, 0.95340116973220345731 },
	{ 0.9565465589463679752, 0.016796836048364478106, 0.95357569769023886597 },
	{ 0.95670896922051607003, 0.016732494875788525568, 0.95374893341957567294 },
	{ 0.95687017756700232241, 0.016668644368648365128, 0.953920885562887233 },
	{ 0.9570301762372225296, 0.016605278179049328541, 0.95409155409037127438 },
	{ 0.95718900233506853947, 0.016542391359805896922, 0.95426096802948956466 },
	{ 0.95734665016829656459, 0.016479979559779003168, 0.95442913098632320423 },
	{ 0.95750314816832204912, 0.016418037056922751143, 0.95459606847166034171 },
	{ 0.95765850828587684163, 0.016356558665633041949, 0.95476179327069710112 },
	{ 0.95781272557377472587, 0.016295537203550179012, 0.95492630180715509791 },
	{ 0.95796582411229258547, 0.016234969154000120084, 0.95508961693941529791 },
	{ 0.95811782133578893283, 0.016174851685762235698, 0.9552517644166843569 },
	{ 0.95826872922479744421, 0.01611517675220948409, 0.95541274692117106326 },
	{ 0.95841854616999266891, 0.016055940151214417172, 0.95557256913184029923 },
	{ 0.95856729854642996891, 0.015997137144207768805, 0.95573125527798041823 },
	{ 0.95871498537063248868, 0.015938763111829575003, 0.95588880884646254543 },
	{ 0.95886163319646933179, 0.015880814656615071384, 0.95604525439440068979 },
	{ 0.95900722944736116471, 0.015823284506797607313, 0.95620058178900535495 },
	{ 0.95915180458128102003, 0.015766168728470617705, 0.9563548173457271373 },
	{ 0.95929537069797177207, 0.015709467440843397773, 0.95650798594950470211 },
	{ 0.95943793542682775932, 0.01565317066013794528, 0.95666008080540920755 },
	{ 0.95957949137687315044, 0.01559727388620357931, 0.95681110218166132153 },
	{ 0.9597200702577793896, 0.015541776224970634337, 0.95696108375488542208 },
	{ 0.95985967719554565747, 0.015486672967672164558, 0.95711003330348742857 },
	{ 0.95999831277131708607, 0.015431958228349501594, 0.95725794658063645404 },
	{ 0.96013600353896288997, 0.015377627804875188683, 0.95740484924613244999 },
	{ 0.96027275344729101647, 0.015323679685592466251, 0.95755074915288695969 },
	{ 0.96040854504704153971, 0.015270106136798668184, 0.95769563344119790216 },
	{ 0.96054343949257992019, 0.015216909363865658775, 0.95783955897389638778 },
	{ 0.96067741128801986683, 0.015164080321788590486, 0.95798250073193302878 },
	{ 0.96081047223508031507, 0.015111616179346837319, 0.95812447245417831088 },
	{ 0.96094264444708499262, 0.015059515565633570244, 0.95826549917458314631 },
	{ 0.96107390742003606654, 0.015007769420742783292, 0.95840555582939401802 },
	{ 0.96120431861281097063, 0.014956382423639088056, 0.95854470786451129172 },
	{ 0.96133384235202967716, 0.014905340418219358012, 0.95868290667234690172 },
	{ 0.96146252447366420402, 0.014854651868343143883, 0.95882021486758040041 },
	{ 0.96159033216535783062, 0.014804303631186274681, 0.95895659409462252754 },
	{ 0.96171729084849133518, 0.01475429251790025785, 0.95909206295012283672 },
	{ 0.96184343519806669853, 0.014704621165990616402, 0.95922666090725727805 },
	{ 0.96196872596442517533, 0.014655281826853537933, 0.95936035881935410874 },
	{ 0.96209322634339167202, 0.014606276094913267852, 0.95949321088193695317 },
	{ 0.96221690104901635987, 0.01455759344995000322, 0.95962518261371898554 },
	{ 0.9623397585749610128, 0.014509234398603224406, 0.95975628635286147627 },
	{ 0.96246184389293021333, 0.01446119661629178578, 0.95988656009732542529 },
	{ 0.96258312284946256909, 0.0144134738743303039, 0.96001598027347367914 },
	{ 0.96270362515747343046, 0.014366065666079300134, 0.96014456881581577985 },
	{ 0.96282335749268321834, 0.014318970203399434757, 0.96027234292029173268 },
	{ 0.96294231574237121318, 0.014272178694605603885, 0.96039928527175222328 },
	{ 0.96306051936745407094, 0.014225695252418291137, 0.96052543061970530047 },
	{ 0.9631779905706618905, 0.014179513826966061094, 0.96065078814326576584 },
	{ 0.96329469442367299248, 0.014133630156516802448, 0.96077533471583176361 },
	{ 0.96341067053377393847, 0.014088040813803444362, 0.96089909692107489114 },
	{ 0.96352592104673140394, 0.014042747825383913515, 0.96102209451793474404 },
	{ 0.96364044034480811352, 0.013997743278741606177, 0.9611443090140704415 },
	{ 0.96375424487888572411, 0.013953027203678854823, 0.96126576520501416656 },
	{ 0.96386733776330713042, 0.013908593714236982403, 0.96138645863531846381 },
	{ 0.96397972781955965083, 0.013864443406462440694, 0.96150640450416813287 },
	{ 0.96409142583608387067, 0.013820573359727634025, 0.96162561336158536296 },
	{ 0.9642024264782644849, 0.013776977762579691381, 0.961744076326477626 },
	{ 0.96431275163590701727, 0.013733660623430975212, 0.96186182619630100632 },
	{ 0.96442239826917441903, 0.013690610677003629131, 0.96197884237765085569 },
	{ 0.96453136743604928061, 0.013647830769419439303, 0.96209514366089088355 },
	{ 0.96463967543840167806, 0.013605317234992751405, 0.96221073719857919126 },
	{ 0.96474731492995968729, 0.013563067376613386142, 0.96232562199233739886 },
	{ 0.96485431171953417451, 0.013521079376339681724, 0.96243981553612900637 },
	{ 0.96496065634488781271, 0.013479351580142745134, 0.96255332341788957251 },
	{ 0.96506636862456529613, 0.013437880769371756545, 0.96266614906488590098 },
	{ 0.965171433120963429, 0.013396662443876040244, 0.96277828776835117086 },
	{ 0.96527588205039260849, 0.013355698719620480441, 0.96288976933060788088 },
	{ 0.96537970310449361389, 0.013314983040094152678, 0.96300058040021563333 },
	{ 0.96548289529978981172, 0.01327451409399487553, 0.96311072166262767791 },
	{ 0.96558547624945367804, 0.013234290987252973065, 0.96322021251915590501 },
	{ 0.96568745748698447962, 0.013194311901926781758, 0.96332906593381062432 },
	{ 0.96578883242606872184, 0.013154570788144852311, 0.9634372655451168832 },
	{ 0.96588961069285628191, 0.013115070238709241116, 0.96354483340679297765 },
	{ 0.96598979769646864391, 0.01307580704987028504, 0.96365177564321635728 },
	{ 0.96608939406275495809, 0.013036776900291235579, 0.9637580839991435333 },
	{ 0.96618841083347561938, 0.012997978284954815262, 0.96386377225814900971 },
	{ 0.96628686046600087423, 0.012959412395953920707, 0.963968858361230585 },
	{ 0.96638473059236762452, 0.012921074673533226862, 0.96407333113251725276 },
	{ 0.96648202478885392175, 0.012882959127425933771, 0.96417718362806814625 },
	{ 0.96657877691089844063, 0.012845072254538321757, 0.96428046290575020194 },
	{ 0.96667495454847551795, 0.012807403370737810433, 0.96438312445579521537 },
	{ 0.96677060121297575535, 0.012769958555698174632, 0.96448522260783653426 },
	{ 0.96686567260324673967, 0.01273272840678669679, 0.96458670775590860114 },
	{ 0.96696021845936508399, 0.012695716053247232263, 0.96468763089178510839 },
	{ 0.96705422516166905655, 0.012658920660614747522, 0.96478798551855970977 },
	{ 0.96714770275354122742, 0.012622334688901684641, 0.96488776504991935479 },
	{ 0.96724065469205100509, 0.012585961982607625151, 0.96498699061571024949 },
	{ 0.9673330674469443613, 0.012549796313047190816, 0.96508564233778382224 },
	{ 0.96742497332393839748, 0.012513839974999208665, 0.96518375329671757257 },
	{ 0.9675163548588725515, 0.012478087931871193611, 0.96528130793569932866 },
	{ 0.96760723029076789459, 0.012442536905407686892, 0.96537830965219373347 },
	{ 0.96769760191440334918, 0.012407192379236001156, 0.96547478970883704452 },
	{ 0.96778747086226712959, 0.012372046366333742246, 0.96557072521744558014 },
	{ 0.96787683039903404936, 0.012337098151445170108, 0.96566612249611216701 },
	{ 0.96796570475399257294, 0.012302345469593784985, 0.96576099441943974444 },
	{ 0.96805409398674713284, 0.012267793089151164676, 0.96585536018012374537 },
	{ 0.96814198489486924526, 0.012233429118990684151, 0.96594918705521437552 },
	{ 0.96822939038276434331, 0.012199258148669981858, 0.96604250180719697383 },
	{ 0.96831633143126716323, 0.012165278002619525979, 0.96613531471787295057 },
	{ 0.96840278866886841946, 0.01213148686289765299, 0.96622761532662715389 },
	{ 0.96848879025876266624, 0.012097884163260240117, 0.96631943015752619353 },
	{ 0.96857430189847681934, 0.012064464867114800539, 0.96641072446106268679 },
	{ 0.96865937362611009842, 0.012031231060623901602, 0.96650154416261480073 },
	{ 0.96874397963285185931, 0.011998180061578531119, 0.9665918719172312823 },
	{ 0.96882813344895568619, 0.011965310588478824533, 0.96668171574173700211 },
	{ 0.96891181853413310687, 0.011932619035243775124, 0.96677106350658670308 },
	{ 0.96899506445228777984, 0.011900103405117774813, 0.96685993264613845355 },
	{ 0.96907787331938477493, 0.011867768555879379747, 0.9669483449756928195 },
	{ 0.96916023521125060913, 0.011835607126354957472, 0.96703627495465938058 },
	{ 0.96924216020107023528, 0.011803619980811856649, 0.96712374386189625675 },
	{ 0.96932364408671600753, 0.011771805748343251719, 0.96721074505148563194 },
	{ 0.96940471225976687641, 0.011740160852670454561, 0.96729729205368164546 },
	{ 0.96948534022271348753, 0.011708687081932806634, 0.96738337804375262863 },
	{ 0.96956554749607748445, 0.011677381038665553964, 0.96746901455519762614 },
	{ 0.96964533250033568823, 0.011646240785717749955, 0.96755419678984233567 },
	{ 0.96972471344470700938, 0.011615267753600857364, 0.96763894900677760447 },
	{ 0.96980366744100765519, 0.011584459766745349579, 0.96772325296698180619 },
	{ 0.96988221475481706246, 0.011553813248872536745, 0.96780711689589571378 },
	{ 0.96996035175025174802, 0.011523328408598678546, 0.96789054296908916264 },
	{ 0.97003810104727483665, 0.011493006914853826431, 0.96797355809805885052 },
	{ 0.97011543028056368421, 0.011462840452790036549, 0.96805612073836821985 },
	{ 0.97019237282871950701, 0.011432835102081071593, 0.9681382776796629841 },
	{ 0.97026890517770991718, 0.011402985200285683035, 0.96821999786792312115 },
	{ 0.97034505179524166429, 0.011373288929462202143, 0.96830129921434449081 },
	{ 0.97042080835997801547, 0.011343747004866367237, 0.96838218666611264318 },
	{ 0.97049619629978922664, 0.011314361393451455653, 0.96846268084643438723 },
	{ 0.97057117338478338109, 0.011285123392939334919, 0.96854273830352388686 },
	{ 0.97064580585062276707, 0.011256041392683749716, 0.9686224269121703756 },
	{ 0.97072003173827881017, 0.011227104723453290233, 0.96870168295500813649 },
	{ 0.97079389987885689184, 0.01119831942021823519, 0.96878055958447995 },
	{ 0.97086737310886128682, 0.011169677585363156636, 0.96885901358721804311 },
	{ 0.9709404912143921873, 0.01114118202030635503, 0.96893708215652041282 },
	{ 0.97101323941349726443, 0.011112833201884992143, 0.96901476573942235682 },
	{ 0.9710856323391172662, 0.011084628507494696456, 0.96909206546841197838 },
	{ 0.97115767510235051496, 0.011056567296385530486, 0.96916898877916879407 },
	{ 0.97122934669255944762, 0.011028647452592611755, 0.96924552199242652861 },
	{ 0.97130066315829477475, 0.011000868603586915276, 0.96932167880235253765 },
	{ 0.97137162512540542458, 0.010973229110240701259, 0.96939745554326128829 },
	{ 0.97144223798811180082, 0.010945725753903155081, 0.96947285459933851826 },
	{ 0.97151250907778496924, 0.010918361991643673117, 0.96954789090154747111 },
	{ 0.97158242119848492457, 0.010891132965683704426, 0.96962254528699498568 },
	{ 0.97165199942886593121, 0.010864041998982193471, 0.96969684813914858168 },
	{ 0.97172124499082335181, 0.010837083071470023435, 0.9697707861363703552 },
	{ 0.97179014636575966612, 0.010810259684920074663, 0.96984436638651450036 },
	{ 0.97185872501134651369, 0.010783568531274557653, 0.96991759532688226475 },
	{ 0.97192695049941313368, 0.010757006004452467421, 0.96999044914541798779 },
	{ 0.97199485996365320162, 0.010730577528476475946, 0.97006297171114053146 },
	{ 0.97206243465840613815, 0.010704274609684705233, 0.97013512589035588718 },
	{ 0.97212968391179854777, 0.010678104460239170453, 0.9702069468200023028 },
	{ 0.97219661210477148483, 0.010652060702442883028, 0.97027842088041849067 },
	{ 0.97226322051882529962, 0.010626142889261003255, 0.97034954956172037033 },
	{ 0.97232951422035474032, 0.010600351825356242597, 0.97042034436760471472 },
	{ 0.97239549767970812066, 0.010574685633182281247, 0.97049080470202497839 },
	{ 0.97246115534007326886, 0.010549142792820686773, 0.97056092269716787158 },
	{ 0.97252649864554174819, 0.01052372196316694701, 0.97063070449231192427 },
	{ 0.97259153465926428961, 0.010498424723744148937, 0.97070016051826979453 },
	{ 0.97265626525878723374, 0.010473248660564180718, 0.97076928836105369491 },
	{ 0.97272069646417880229, 0.010448191002011058756, 0.97083808974919805213 },
	{ 0.97278482428192869502, 0.010423256963491197083, 0.97090657857058504376 },
	{ 0.97284864999353659609, 0.010398439094424003978, 0.97097473911939113922 },
	{ 0.97291216978430505868, 0.010373739928006883021, 0.97104257604477850485 },
	{ 0.97297540433704610141, 0.010349157586693523078, 0.97111010642347805888 },
	{ 0.97303834235667907571, 0.010324689567088837436, 0.97117731431124676433 },
	{ 0.97310098452865811947, 0.010300339922308677718, 0.97124421639738545142 },
	{ 0.97316333824395850893, 0.010276104062795393332, 0.97131080973146410873 },
	{ 0.97322539244591899088, 0.010251978680491201715, 0.97137707825003116735 },
	{ 0.97328716781735125085, 0.010227970391511671464, 0.97144305723903612293 },
	{ 0.97334866954385934612, 0.010204073593020194718, 0.97150873748956156906 },
	{ 0.97340988543629358709, 0.010180288404226059754, 0.97157411268351479006 },
	{ 0.97347080262005036833, 0.010156610593199486003, 0.97163917215166495378 },
	{ 0.97353146120905587058, 0.010133047282695527638, 0.97170395928619324177 },
	{ 0.97359184978902046925, 0.01010959275066828332, 0.9717684528380436948 },
	{ 0.97365193554758744376, 0.010086242198943847978, 0.97183262252805657777 },
	{ 0.97371176911890222616, 0.01006300289928888439, 0.97189652685819083455 },
	{ 0.97377132329344462391, 0.01003986963629697679, 0.97196013340351994358 },
	{ 0.97383060030638890492, 0.010016840502619493714, 0.97202344255147399288 },
	{ 0.97388962191343009245, 0.0099939178824422214564, 0.97208647775648049372 },
	{ 0.97394839192926585536, 0.0099711019247767755658, 0.97214924086628373701 },
	{ 0.97400687998532953227, 0.0099483884572980248173, 0.97221171331403655191 },
	{ 0.97406511358916458843, 0.0099257791787383409937, 0.9722739061564008578 },
	{ 0.97412306946515736517, 0.009903269827365621461, 0.97233580794928498037 },
	{ 0.97418077909946132475, 0.009880863308906299991, 0.97239744362233138109 },
	{ 0.97423823668062392578, 0.0098585586398837379146, 0.9724588098078773557 },
	{ 0.97429543292522136078, 0.0098363543450829780956, 0.97251989886162726329 },
	{ 0.9743523857146472178, 0.0098142517358062054261, 0.97258072955904439905 },
	{ 0.97440908247232138617, 0.0097922452986237730477, 0.97264128172395647454 },
	{ 0.97446551842987239045, 0.0097703380733725735813, 0.97270155955849102458 },
	{ 0.97452171808480914095, 0.009748530328273502174, 0.97276158821580804847 },
	{ 0.9745776606947154086, 0.0097268168181178192577, 0.97282133729753894613 },
	{ 0.97463336330651950679, 0.0097052023708817571762, 0.97288083532450597701 },
	{ 0.97468880532681667628, 0.0096836785227057513292, 0.97294004796443367411 },
	{ 0.97474404470622277863, 0.0096622577458617252971, 0.97299905042348278084 },
	{ 0.97479902172088372936, 0.0096409281790253639755, 0.97305776959655665426 },
	{ 0.97485376779734833619, 0.0096196920722720138941, 0.9731162404566803259 },
	{ 0.97490825980901463232, 0.0095985482931134191026, 0.97317444413898357425 },
	{ 0.97496252118050785729, 0.0095774985104796362539, 0.97323240335283656144 },
	{ 0.97501655274629317471, 0.0095565409064290035568, 0.9732901153266227956 },
	{ 0.97507035507261452523, 0.0095356735438105535985, 0.97334757716951736395 },
	{ 0.97512393236159988774, 0.0095149004161354938658, 0.97340480747816926499 },
	{ 0.97517726187407671734, 0.0094942139536139391609, 0.97346176941690820694 },
	{ 0.97523037251829791661, 0.009473618596791922794, 0.97351849940417201079 },
	{ 0.97528325460850895379, 0.0094531115740534663733, 0.9735749810486833411 },
	{ 0.97533590829372107667, 0.0094326938688752050982, 0.97363122463224349712 },
	{ 0.97538835285603731062, 0.0094123671501871904177, 0.97368724600968781235 },
	{ 0.97544055831432086023, 0.0093921230137345140115, 0.97374300697443916253 },
	{ 0.9754925364106870056, 0.0093719658404585633182, 0.97379852665958865909 },
	{ 0.97554431813955078123, 0.0093518988788124819689, 0.97385383665559754895 },
	{ 0.97559586785733465319, 0.0093319155722853455032, 0.97390890197453972021 },
	{ 0.97564720946550143044, 0.0093120155930516024939, 0.97396373412011150172 },
	{ 0.97569832144677404173, 0.0092922042161223163126, 0.97401833839712625984 },
	{ 0.975749230056998762, 0.0092724742293354717876, 0.97407271587846777638 },
	{ 0.97579992653429281635, 0.00925282831490008284, 0.97412686516342672505 },
	{ 0.97585042247175945995, 0.0092332681417462026535, 0.97418080517647775984 },
	{ 0.97590068753063452522, 0.009213786378502524313, 0.97423449568448583502 },
	{ 0.97595074418186922305, 0.0091943883001801111898, 0.97428796762226133055 },
	{ 0.97600059027969632286, 0.0091750713139769173032, 0.97434121502934001313 },
	{ 0.97605026032030395289, 0.0091558401733633637543, 0.97439427609739825975 },
	{ 0.97609969440102384297, 0.0091366827785965554209, 0.97444707864521062923 },
	{ 0.97614894185960099371, 0.0091176074594256032585, 0.97449968256054453342 },
	{ 0.97619797953963083348, 0.0090986109971996857043, 0.97455206230280921886 },
	{ 0.97624680005013775297, 0.0090796943455931245631, 0.97460421864686530569 },
	{ 0.97629544818401192696, 0.0090608564913269573626, 0.97465618211029070306 },
	{ 0.97634388591348986175, 0.0090420968681570595971, 0.9747079248577167343 },
	{ 0.97639213198423258078, 0.0090234153270718157197, 0.97475946521757139696 },
	{ 0.9764401707798232577, 0.0090048079043623472512, 0.97481077785788083911 },
	{ 0.97648801496624848539, 0.0089862794876095306723, 0.97486188983915356143 },
	{ 0.97653569008409879526, 0.0089678276628252524133, 0.97491281212864444594 },
	{ 0.97658313792943884923, 0.0089494484364983084568, 0.97496349680421900974 },
	{ 0.97663041989505228191, 0.0089311469942327959687, 0.97501400472221932958 },
	{ 0.97667748185992164789, 0.0089129175245758491403, 0.97506428050993054768 },
	{ 0.97672438327968047478, 0.0088947659879919475923, 0.97511438269911387966 },
	{ 0.97677108716964655688, 0.0088766864240166117039, 0.97516427391765703181 },
	{ 0.97681759400665679749, 0.0088586794584986118528, 0.97521395708618752174 },
	{ 0.97686393764614987134, 0.0088407486379143106203, 0.97526346373556260794 },
	{ 0.9769100914150469217, 0.008822889789938578517, 0.97531277091799384316 },
	{ 0.97695604380965161972, 0.0088050980567928628651, 0.97536185595391411418 },
	{ 0.97700181825458942697, 0.0087873803228136395521, 0.9754107539206569033 },
	{ 0.97704741372167991376, 0.0087697356194254231371, 0.97545946802197169845 },
	{ 0.97709283396601598337, 0.0087521589398380592734, 0.97550798383353432008 },
	{ 0.97713806770741840069, 0.0087346545606848107618, 0.97555630998311726465 },
	{ 0.97718313744664098142, 0.0087172205150123933254, 0.97560445547102192521 },
	{ 0.97722801835834860462, 0.0086998536437746364774, 0.97565239678321569183 },
	{ 0.97727272653579566608, 0.0086825597882267315647, 0.97570016634462541916 },
	{ 0.977317252948878612, 0.0086653292328115767013, 0.97574772737918546994 },
	{ 0.97736160820722417508, 0.008648169487714412948, 0.97579511335490376478 },
	{ 0.9774058030098656813, 0.0086310790032144840689, 0.97584232588110597639 },
	{ 0.97744980707764395067, 0.0086140539944168387915, 0.97588933739064365191 },
	{ 0.97749364568292840261, 0.0085970958322283078795, 0.97593616987763065485 },
	{ 0.97753731700777724001, 0.0085802050828930193083, 0.97598282310364825598 },
	{ 0.9775808356851308778, 0.008563382789492254149, 0.97602931608257836871 },
	{ 0.9776241623461215946, 0.0085466231703754721311, 0.97607560262082182501 },
	{ 0.97766732187568827772, 0.0085299283415075609349, 0.97612170700727063366 },
	{ 0.97771032172441152408, 0.0085133019685741748855, 0.97616765111682968215 },
	{ 0.97775315201282153588, 0.0084967376589771617668, 0.97621340858934479989 },
	{ 0.97779582683741683713, 0.0084802379757162437562, 0.97625899560747708694 },
	{ 0.97783833068608871919, 0.0084638008475300171435, 0.97630440032480347856 },
	{ 0.97788068340718392601, 0.0084474329501386981323, 0.97634965436158749341 },
	{ 0.97792286360263491751, 0.0084311225116249430278, 0.9763947119712650391 },
	{ 0.97796488185226571055, 0.0084148762971159342394, 0.9764396024495185511 },
	{ 0.97800675404071457653, 0.0083986957967277890702, 0.9764843406677069515 },
	{ 0.97804845194518219564, 0.0083825729936357878253, 0.97652888663111347967 },
	{ 0.97808999940752983093, 0.0083665139973163674125, 0.97657327428460127816 },
	{ 0.97813137809931860467, 0.0083505144864317315534, 0.97661748073993326358 },
	{ 0.97817261958121881626, 0.0083345796465870286562, 0.9766615447401821859 },
	{ 0.97821370299160093076, 0.0083187035769220762926, 0.97670543371139162403 },
	{ 0.97825462111830296941, 0.0083028879165646055777, 0.97674915167687526019 },
	{ 0.9782953992038923019, 0.0082871328145262233844, 0.97679271622000352071 },
	{ 0.97833601975440553922, 0.0082714380025860310963, 0.97683611777423051681 },
	{ 0.9783764723092275295, 0.0082557976990934849731, 0.97687933076916344532 },
	{ 0.97841679847240026202, 0.0082402219176289075858, 0.97692241540549418222 },
	{ 0.97845695835351520486, 0.008224700212478303768, 0.97696531459687374621 },
	{ 0.9784969642609313567, 0.008209240004419948375, 0.97700806413589147414 },
	{ 0.97853684407472163453, 0.0081938402950760356319, 0.97705067339537765569 },
	{ 0.97857655777036678391, 0.0081784931570288155189, 0.9770931008904997217 },
	{ 0.97861614051460754649, 0.0081632078886028757586, 0.97713539299367102586 },
	{ 0.97865556670724873634, 0.0081479754298922017069, 0.9771775120645587176 },
	{ 0.97869485533236977304, 0.0081328034996982975779, 0.97721949133275209931 },
	{ 0.97873397718369481435, 0.0081176830083128388021, 0.97726128523050015406 },
	{ 0.97877298936247369987, 0.0081026237308975609941, 0.9773029661774463861 },
	{ 0.97881183929740944727, 0.0080876175612207817228, 0.97734447257219025929 },
	{ 0.97885054621099965022, 0.0080726690292354952999, 0.9773858350813214857 },
	{ 0.97888911719619753349, 0.008057772025465618701, 0.97742703612147008307 },
	{ 0.97892754259705105913, 0.0080429339110847791749, 0.97746809893844743833 },
	{ 0.97896583320199992428, 0.0080281474143263208826, 0.97750900660453454716 },
	{ 0.97900398764013807362, 0.0080134178400036171208, 0.97754977321622993358 },
	{ 0.97904198552667665023, 0.0079987375885244692969, 0.9775903697162687811 },
	{ 0.97907987311482436166, 0.0079841159284114865402, 0.97763084843754755049 },
	{ 0.97911762453615225343, 0.0079695477336641611099, 0.97767118437586408852 },
	{ 0.979155211359257871, 0.0079550290703769999806, 0.97771134632824052701 },
	{ 0.97919268850981722174, 0.0079405661672350205671, 0.97775138743219969228 },
	{ 0.97923001301288137288, 0.0079261539280411075215, 0.97779126894472268017 },
	{ 0.97926720933615696296, 0.0079117923825975742386, 0.97783100734649353036 },
	{ 0.97930428206920161482, 0.0078974862396713595841, 0.9778706187903708491 },
	{ 0.97934121470152857292, 0.0078832301646467525802, 0.9779100804477758313 },
	{ 0.97937802349030478322, 0.0078690270334478683995, 0.97794941075144481424 },
	{ 0.97941467761992884178, 0.0078548701107498467011, 0.97798857200144018176 },
	{ 0.9794512264281457492, 0.0078407692462202395467, 0.97802762503920281922 },
	{ 0.97948764625191164779, 0.0078267168104645123972, 0.97806653392313203099 },
	{ 0.97952391333877519841, 0.0078127120882269286695, 0.97810528297720633617 },
	{ 0.97956007269024325534, 0.0077987619340416343763, 0.97814392185209453334 },
	{ 0.97959610579907374639, 0.0077848600596186080108, 0.97818241925535887038 },
	{ 0.97963200733065614045, 0.0077710084617137915874, 0.97822078391909605966 },
	{ 0.97966777615248645805, 0.0077572033852335367521, 0.97825900103150109643 },
	{ 0.9797034180015274929, 0.0077434468120333114355, 0.97829708035288553969 },
	{ 0.97973895058035342931, 0.0077297451198097616096, 0.97833505290745004235 },
	{ 0.97977435301243742671, 0.0077160868793722543063, 0.97837287707625131272 },
	{ 0.97980961579083880597, 0.0077024759352203762616, 0.97841055756805639376 },
	{ 0.97984477896987887124, 0.0076889164596792604345, 0.97844812925158231032 },
	{ 0.97987980869411950291, 0.0076754009127613462976, 0.97848555454610097737 },
	{ 0.97991471968590759811, 0.0076619347780939490999, 0.97852285842595809751 },
	{ 0.97994952249526534604, 0.0076485167443748856841, 0.97856004044411892817 },
	{ 0.97998417806624904536, 0.0076351433694359224433, 0.97859707257149930459 },
	{ 0.98001873411237738765, 0.0076218188852068330039, 0.97863399825988506286 },
	{ 0.98005316817760035342, 0.0076085402965542234602, 0.97867078784106475986 },
	{ 0.98008748035132464693, 0.0075953079313036330963, 0.97870745359359490045 },
	{ 0.9801216676831203678, 0.0075821207761761072463, 0.97874398648737181983 },
	{ 0.98015574760734613946, 0.0075689794868227357541, 0.97878039912877790041 },
	{ 0.98018969663977217888, 0.0075558822751041762947, 0.97881667533515193114 },
	{ 0.98022355334460320453, 0.0075428340882059434144, 0.97885285319386217129 },
	{ 0.98025727897882042328, 0.00752982687950099535, 0.97888888627289016853 },
	{ 0.98029089839756033964, 0.0075168667882677415309, 0.97892480863629072196 },
	{ 0.98032439780234825744, 0.0075039509534832321558, 0.97896060457823974588 },
	{ 0.98035777007042890219, 0.0074910767227407771066, 0.97899626450238896869 },
	{ 0.98039104598760129505, 0.0074782501459118213422, 0.97903182458875848138 },
	{ 0.98042420701682098105, 0.0074654661864038771718, 0.97906725807486238988 },
	{ 0.98045726388692400199, 0.0074527259469028767427, 0.97910257595775773698 },
	{ 0.98049019110202340066, 0.0074400297403332043764, 0.97913776743410263492 },
	{ 0.98052302354573772636, 0.0074273788332935609946, 0.97917285507915652332 },
	{ 0.98055573762952841221, 0.0074147641509767821949, 0.97920780195294043757 },
	{ 0.98058833852410309806, 0.0074021957814693443989, 0.97924263849854475961 },
	{ 0.98062084355949930004, 0.0073896718025203986593, 0.97927737101910705686 },
	{ 0.98065321822464035506, 0.0073771863430734906097, 0.97931196700034717217 },
	{ 0.98068552187084723215, 0.0073647482991215035622, 0.97934648278353808593 },
	{ 0.98071767851709901187, 0.0073523463010784443489, 0.97938084360955368624 },
	{ 0.98074974922835411739, 0.0073399912267919833336, 0.97941511754689825064 },
	{ 0.98078170762955729778, 0.007327672317623739294, 0.97944926021991385312 },
	{ 0.9808135524094064861, 0.007315398991107589094, 0.97948329758642338483 },
	{ 0.98084530799090474673, 0.007303164646029121701, 0.97951722674070007546 },
	{ 0.98087694953381643348, 0.007290972217917092088, 0.97955103896556494636 },
	{ 0.98090849497913956689, 0.0072788196802135779126, 0.97958474367855208342 },
	{ 0.98093993432819492906, 0.0072667100876566232889, 0.9796183428019106243 },
	{ 0.98097125858068101589, 0.0072546361088749230367, 0.97965181154010894105 },
	{ 0.98100248004495749221, 0.0072426041513677886716, 0.97968517707286473239 },
	{ 0.98103361684083600913, 0.0072306138277050298335, 0.97971844780443284595 },
	{ 0.98106463776528496368, 0.0072186631113287241801, 0.97975160287318807661 },
	{ 0.98109554991125713652, 0.0072067462801929747102, 0.97978462782500352901 },
	{ 0.98112638093530779582, 0.0071948770433660769186, 0.9798175825029430408 },
	{ 0.98115710571407899199, 0.0071830419003959923921, 0.97985041123626803738 },
	{ 0.98118772892653549622, 0.0071712453216310765094, 0.97988313351569733545 },
	{ 0.9812182474583347469, 0.0071594893783327364506, 0.97991574822364435615 },
	{ 0.98124867883324229378, 0.0071477713882919582944, 0.97994826379416577478 },
	{ 0.98127900584041671816, 0.0071360922902818958724, 0.97998067443071035232 },
	{ 0.98130922591685842971, 0.0071244489252563752285, 0.98001296806333693112 },
	{ 0.98133936353027440003, 0.0071128455251451751934, 0.98004517059026396986 },
	{ 0.98136939086019636669, 0.0071012768000360739634, 0.98007725320754690568 },
	{ 0.98139933004974966302, 0.0070897513031955945381, 0.98010925641654167428 },
	{ 0.9814291770607198595, 0.0070782587081190317599, 0.98014114575086275227 },
	{ 0.98145892152189884161, 0.007066806435584660484, 0.98017293471096178514 },
	{ 0.98148856870829748189, 0.0070553885847326486963, 0.98020461870728159415 },
	{ 0.98151812356710121943, 0.0070440077483650406429, 0.98023619943855455627 },
	{ 0.98154757785796797886, 0.007032662302255268845, 0.9802676713466470515 },
	{ 0.98157696209847622448, 0.0070213589519258681054, 0.98029907639322932944 },
	{ 0.98160622739791569824, 0.0070100846290584734738, 0.9803303435444656877 },
	{ 0.98163541780411900373, 0.0069988534003492513386, 0.98036154331265124018 },
	{ 0.98166450157761275808, 0.0069876528382297646916, 0.98039261999724525154 },
	{ 0.9816934961825578565, 0.0069764892905946835136, 0.98042360566554653811 },
	{ 0.98172239708900155275, 0.006965361565351112054, 0.9804544911682426811 },
	{ 0.98175121684372135267, 0.0069542716592546523213, 0.98048529319463373355 },
	{ 0.98177993775903893425, 0.0069432142227884349056, 0.98051598535476314211 },
	{ 0.98180856737494182074, 0.006932191252708058346, 0.98054657745359519172 },
	{ 0.98183711580931865015, 0.0069212060719724679755, 0.98057708786426156511 },
	{ 0.98186555996536928337, 0.0069102523922916431545, 0.98060748362539384981 },
	{ 0.98189392475783532355, 0.0068993351310487746261, 0.98063779626784897125 },
	{ 0.9819222028553457049, 0.0068884534239765154648, 0.980668018668871877 },
	{ 0.98195039255916782839, 0.0068776051551099762552, 0.98069814224539386682 },
	{ 0.98197849765419664703, 0.0068667911589141809869, 0.98072817859051808487 },
	{ 0.98200651189684562414, 0.006856011480092615365, 0.98075811710951898981 },
	{ 0.9820344381481376228, 0.0068452631980176854506, 0.98078795637188531664 },
	{ 0.98206227630376474735, 0.0068345507085319449209, 0.98081770667431922295 },
	{ 0.98209003458916788176, 0.0068238711804147634404, 0.98084737004337874122 },
	{ 0.98211769700050000065, 0.0068132238984104070284, 0.98087693342564674648 },
	{ 0.98214527712761978684, 0.0068026107996698274849, 0.98090640832481956757 },
	{ 0.98217277622222531885, 0.0067920317947860612065, 0.98093579733369928864 },
	{ 0.98220019255578161488, 0.0067814846783872473682, 0.98096509616075155957 },
	{ 0.98222752550243974667, 0.0067709700167175148125, 0.98099430304763923782 },
	{ 0.98225475700199260665, 0.006760486856102546939, 0.98102340753374717153 },
	{ 0.98228192362188970765, 0.0067500371336932981498, 0.98105243659017726809 },
	{ 0.98230900512635388466, 0.0067396209388967363851, 0.98108138088880236793 },
	{ 0.98233600044250168892, 0.0067292366623874508638, 0.98111023446915834878 },
	{ 0.98236291919648321969, 0.0067188832610841587797, 0.9811390004604887416 },
	{ 0.98238974237441711868, 0.0067085599005218335411, 0.9811676633655859181 },
	{ 0.98241650192439233802, 0.0066982719153161835238, 0.98119626151023642269 },
	{ 0.98244316339492465673, 0.0066880112886424855634, 0.98122475224731708909 },
	{ 0.98246974913775575455, 0.0066777851730581132966, 0.98125316821037067427 },
	{ 0.98249626165628078933, 0.0066675909459586943373, 0.98128150373695610664 },
	{ 0.98252267326414233217, 0.0066574248820539302235, 0.98130973358450634958 },
	{ 0.98254903204738719413, 0.0066472917944188896627, 0.9813379014879297646 },
	{ 0.98257530525326353121, 0.0066371904909606751696, 0.98136598217485659923 },
	{ 0.98260149769484628202, 0.0066271177679296288179, 0.98139397053418875316 },
	{ 0.98262760961055362063, 0.0066170763671394130026, 0.98142187774179689974 },
	{ 0.9826536483913622666, 0.0066070646196599728053, 0.98144970206914672328 },
	{ 0.98267960196733117328, 0.0065970838665958151867, 0.98147744020817995203 },
	{ 0.98270546860992535887, 0.0065871316939588274442, 0.98150508548317683122 },
	{ 0.98273127600550647109, 0.0065772123634815216064, 0.98153266832232477501 },
	{ 0.98275699059664822776, 0.0065673177391286580509, 0.98156014604864849638 },
	{ 0.98278265088796223914, 0.0065574603378768629713, 0.98158757525680795375 },
	{ 0.9828082154840190876, 0.0065476271659131723979, 0.98161489237843291278 },
	{ 0.9828337047398048032, 0.0065378242731090260853, 0.98164213818310042114 },
	{ 0.9828591258674815867, 0.0065280515700574586954, 0.98166930665074136897 },
	{ 0.98288446849584121257, 0.0065183048248286905302, 0.98169638204572928775 },
	{ 0.98290974773466133207, 0.006508593693375175869, 0.98172340585289719073 },
	{ 0.98293493223189842833, 0.0064989053905006102796, 0.9817503184676001915 },
	{ 0.98296005968749078363, 0.0064892499893899604699, 0.98177717573939060625 },
	{ 0.98298510727285892674, 0.0064796193242068911983, 0.98180393931267939678 },
	{ 0.98301008440553694356, 0.0064700232595201172953, 0.98183064432440481095 },
	{ 0.98303497469424727662, 0.0064604477286334663008, 0.98185723796485135928 },
	{ 0.98305980509519108601, 0.0064509055614467274847, 0.9818837779462166182 },
	{ 0.98308455978333464387, 0.0064413899630303998387, 0.98191023205219007952 },
	{ 0.98310924749075867535, 0.0064319032281633034542, 0.98193661837278112259 },
	{ 0.98313385468720893012, 0.0064224442243571893199, 0.98196292024849163305 },
	{ 0.98315839697420093213, 0.0064130126982923155166, 0.98198914878068666034 },
	{ 0.98318286064266668944, 0.0064036090373988758737, 0.9820152941644021416 },
	{ 0.98320725731551161797, 0.0063942317813630708198, 0.9820413669794627598 },
	{ 0.98323157441615560703, 0.0063848822712894099177, 0.98206735780833420701 },
	{ 0.98325584398209564529, 0.0063755640238519336802, 0.9820932994335715982 },
	{ 0.98328002640604483808, 0.0063662684857841156383, 0.98211914408205180926 },
	{ 0.98330414007603639259, 0.006357000961899341232, 0.9821449175923885333 },
	{ 0.98332819589972009222, 0.0063477625548835417413, 0.98217062753437178735 },
	{ 0.98335217167436583807, 0.0063385472148652704724, 0.98219624669848093479 },
	{ 0.98337606391310183884, 0.0063293589949603686409, 0.98222178712485408436 },
	{ 0.98339991787075464735, 0.0063202010393138517708, 0.98224728104470326873 },
	{ 0.98342369030415466291, 0.0063110670894380212909, 0.98227268786726529282 },
	{ 0.98344738870858594559, 0.0063019591867919571085, 0.98229801639912650568 },
	{ 0.98347103159129067862, 0.006292878106236038209, 0.98232328422365722265 },
	{ 0.98349459594487587122, 0.0062838225066657611012, 0.98234846830366173709 },
	{ 0.98351808728277134719, 0.0062747933119531220519, 0.98237358032165089661 },
	{ 0.98354152229427749266, 0.0062657898962493498163, 0.98239862626789153932 },
	{ 0.98356489588319728767, 0.0062568128257985671653, 0.98242360557613916949 },
	{ 0.98358820539712377151, 0.0062478618323798737477, 0.98244851726291693161 },
	{ 0.98361143898963399046, 0.0062389360964294057407, 0.98247335147855796578 },
	{ 0.98363461060821477666, 0.0062300340384240718294, 0.98249811168013145846 },
	{ 0.98365771621465136754, 0.0062211600840087503614, 0.98252281144259490109 },
	{ 0.98368075717985059558, 0.0062123096436257924796, 0.98254743497071761471 },
	{ 0.9837037354707660608, 0.0062034853696818917715, 0.98257199299333575215 },
	{ 0.98372664220630545717, 0.0061946848183866108639, 0.98259647582469455962 },
	{ 0.98374948343634005532, 0.0061859092712398134478, 0.98262088760731691739 },
	{ 0.98377227549254298022, 0.0061771603077645865013, 0.98264524693785215703 },
	{ 0.98379498305916190937, 0.0061684351265426234923, 0.98266952282188446688 },
	{ 0.98381764969229101858, 0.0061597349345679829405, 0.98269374608991677533 },
	{ 0.98384022636710999343, 0.006151057735085064572, 0.9827178791612201092 },
	{ 0.98386275085806240703, 0.0061424054503436626221, 0.98274195602534331062 },
	{ 0.98388522394000865745, 0.0061337785869832574595, 0.98276597334442661325 },
	{ 0.98390761730074249858, 0.0061251740455623201326, 0.98278990778325148181 },
	{ 0.98392997242509683264, 0.0061165949553247042636, 0.98281379504499988276 },
	{ 0.98395225277542441855, 0.0061080413162704072505, 0.98283761155603488469 },
	{ 0.9839744674712357364, 0.0060995100289579001415, 0.98286135603485669243 },
	{ 0.98399662396311149415, 0.0060910042524333568928, 0.98288504165409185109 },
	{ 0.98401872520148148116, 0.006082518950104293283, 0.9829086599498807475 },
	{ 0.98404075065254548171, 0.0060740590989585476617, 0.9829322032630264383 },
	{ 0.9840627256780801746, 0.0060656215399499504096, 0.98295568953452727712 },
	{ 0.98408464661239980487, 0.0060572092235084140643, 0.98297911569474383242 },
	{ 0.98410649757086643419, 0.0060488191395993784819, 0.98300247175989785564 },
	{ 0.98412828117608441847, 0.0060404520630832278516, 0.9830257578790012607 },
	{ 0.98415000498294236131, 0.0060321094989772405109, 0.98304898777602345294 },
	{ 0.98417169339954246876, 0.0060237895697351061947, 0.98307216162977861806 },
	{ 0.9841932976245819642, 0.0060154879391189170976, 0.9830952464341942143 },
	{ 0.98421484667062164586, 0.006007212966680105376, 0.98311828261612099755 },
	{ 0.98423635025321853931, 0.005998962447046812807, 0.98314126698671033822 },
	{ 0.98425778976082245464, 0.0059907324612136431466, 0.9831641812026327143 },
	{ 0.98427916653453739748, 0.0059825255423780017081, 0.98318703101573623471 },
	{ 0.9843004935085715168, 0.0059743427634234942333, 0.98320983073113599193 },
	{ 0.98432176946102978299, 0.0059661809653039476337, 0.98323256580529838633 },
	{ 0.98434296587108982557, 0.0059580399394031074295, 0.98325522375105034456 },
	{ 0.9843640989512147943, 0.0059499202221627751908, 0.98327781264482150281 },
	{ 0.9843852111697138918, 0.0059418274462218799783, 0.98330037790535085307 },
	{ 0.984406252548092775, 0.0059337535649533756921, 0.98332286335526086773 },
	{ 0.98442722091078183055, 0.0059257014393802173377, 0.98334527996180620679 },
	{ 0.98444815905391602762, 0.0059176736325021288276, 0.98336765803394921015 },
	{ 0.98446902433037197788, 0.005909666866063646197, 0.98338996687529689478 },
	{ 0.98448982010781216356, 0.0059016752094026118935, 0.98341218714414235791 },
	{ 0.9845105614662115201, 0.0058937102556224380684, 0.98343436214326007683 },
	{ 0.98453127200900969473, 0.0058857678025956662246, 0.98345649893580044942 },
	{ 0.98455192330479079921, 0.0058778475821013951436, 0.98347857376931269169 },
	{ 0.98457251295446801542, 0.0058699471652503519559, 0.9835005818903261865 },
	{ 0.98459304206072739696, 0.0058620664328332466528, 0.98352252335844569942 },
	{ 0.98461351701616695031, 0.0058542061150069751169, 0.98354440554974598143 },
	{ 0.984633939653629775, 0.0058463682830329453954, 0.98356623485682548313 },
	{ 0.98465431670844028034, 0.0058385515958066505279, 0.98358801324663691634 },
	{ 0.9846746355295129538, 0.0058307587802405884056, 0.98360973748562885444 },
	{ 0.98469491083919480356, 0.0058229839950795676817, 0.98363140539823112896 },
	{ 0.98471512243151126942, 0.0058152317702765982804, 0.98365301409361893814 },
	{ 0.98473528447746694336, 0.0058074982464309254926, 0.98367456111310036526 },
	{ 0.98475538106262139326, 0.0057997822016473314991, 0.9836960350721886126 },
	{ 0.98477543148397850281, 0.0057920923829074396835, 0.98371747574208279197 },
	{ 0.98479541973769113561, 0.0057844176739449979299, 0.98373883767424119551 },
	{ 0.98481536327301921752, 0.0057767647355790605404, 0.98376015140114303481 },
	{ 0.98483526465296222785, 0.0057691350877280677539, 0.98378142774103161106 },
	{ 0.98485510061680769933, 0.0057615236788983786517, 0.98380263291297431749 },
	{ 0.98487489984929066367, 0.0057539333850140997328, 0.98382379399238106821 },
	{ 0.98489462660252546922, 0.0057463621646161502227, 0.98384488640723699593 },
	{ 0.98491432760655373002, 0.0057388109713788467217, 0.98386593781409747983 },
	{ 0.98493393610417323547, 0.0057312759906049210931, 0.9838868967145493194 },
	{ 0.98495353125035256525, 0.0057237619906659563396, 0.98390783272681747729 },
	{ 0.98497305963932946238, 0.0057162727862592188632, 0.98392872105536977045 },
	{ 0.98499255655705408863, 0.0057087997943158592593, 0.98394955311713738766 },
	{ 0.98501197813450758201, 0.0057013468295331439298, 0.98397031746802854357 },
	{ 0.98503135775029138088, 0.0056939148455853894754, 0.98399103794990117056 },
	{ 0.9850506925433821781, 0.0056864971667523822943, 0.98401169262824605966 },
	{ 0.9850699853748031698, 0.0056791061908002338568, 0.9840323244184073781 },
	{ 0.98508921335637056327, 0.0056717266589398811563, 0.98405286847053152766 },
	{ 0.98510839842259390053, 0.0056643709689374391325, 0.98407337723670607055 },
	{ 0.98512753485142690035, 0.0056570333987470099169, 0.98409383355079305122 },
	{ 0.98514662264286989579, 0.0056497177630658573094, 0.98411424504218714127 },
	{ 0.98516566751896839094, 0.0056424183398480843091, 0.98413459835944783194 },
	{ 0.98518463514744758491, 0.00563513322174505598, 0.9841548687070429402 },
	{ 0.98520358751713743573, 0.0056278748065228863945, 0.98417513333259210029 },
	{ 0.98522246836125348946, 0.0056206287890668317486, 0.98419531117377856422 },
	{ 0.98524130247532804017, 0.0056134027987714213773, 0.98421544609962063888 },
	{ 0.98526010607182468171, 0.0056061977893109710136, 0.98423554097114163142 },
	{ 0.98527883909642177684, 0.0055990099459882168575, 0.98425557290015763812 },
	{ 0.98529754923283530132, 0.0055918411761517912428, 0.98427557049689839985 },
	{ 0.98531619261204683724, 0.0055846895724530609684, 0.98429549942908833859 },
	{ 0.98533482168614350272, 0.0055775618106122396359, 0.98431541787086074269 },
	{ 0.98535334680973973853, 0.0055704407244916327724, 0.98433521519599487259 },
	{ 0.98537187765538170048, 0.0055633482486005195883, 0.98435502396522078783 },
	{ 0.98539033792912433807, 0.0055562672168012030086, 0.98437475071845559338 },
	{ 0.98540874479710527378, 0.0055492071658368473039, 0.98439443169532336864 },
	{ 0.98542711733281085351, 0.0055421623736615537384, 0.98441406117377794338 },
	{ 0.98544544409214940295, 0.005535140469669854249, 0.98443366204200322134 },
	{ 0.9854637136310288037, 0.0055281319171185845651, 0.9844531885236316171 },
	{ 0.98548195265233007323, 0.0055211424380536434225, 0.98447268258033338029 },
	{ 0.98550013826786964088, 0.0055141701251263976202, 0.98449211941657599478 },
	{ 0.98551825903355572134, 0.0055072149783368471582, 0.98451149712501118128 },
	{ 0.98553637979924180179, 0.0055002789050336252374, 0.98453085385261129847 },
	{ 0.98555441664158793813, 0.0054933599978680977896, 0.9845501438230094271 },
	{ 0.98557243536412209028, 0.0054864611178632146163, 0.98456940613685228758 },
	{ 0.98559039305149998, 0.0054795774966473935821, 0.98458860741553888563 },
	{ 0.98560831736027687544, 0.0054727100878949521551, 0.98460776196418398065 },
	{ 0.98562618254124612083, 0.0054658598452802060683, 0.98462685738502142563 },
	{ 0.98564400957524267444, 0.0054590267688031553217, 0.98464591275153756644 },
	{ 0.98566179846226675831, 0.0054522108584638007828, 0.98466492424903506731 },
	{ 0.98567953203618030589, 0.0054454140216107739178, 0.98468388997016553787 },
	{ 0.98569722555577266032, 0.005438632443546809192, 0.98470280610023164236 },
	{ 0.9857148752063463748, 0.0054318661242719066054, 0.98472166691718721054 },
	{ 0.98573248670994750853, 0.0054251207858319648938, 0.98474050103126187228 },
	{ 0.98575004099308949357, 0.0054183849841351865856, 0.98475925885139148352 },
	{ 0.98576757238804812999, 0.0054116720706220032208, 0.98477799569068591445 },
	{ 0.98578503702580444479, 0.0054049706012006164604, 0.98479666195808091 },
	{ 0.98580248259007441369, 0.0053982901126141905751, 0.98481531105933828307 },
	{ 0.98581987284123406834, 0.0053916267901654608974, 0.98483390294013684052 },
	{ 0.98583721159398063349, 0.0053849749118085269567, 0.9848524356931276369 },
	{ 0.98585453699528680094, 0.0053783478289838202932, 0.98487096081672398373 },
	{ 0.9858717899173448096, 0.0053717302829022761657, 0.98488940773902622361 },
	{ 0.98588902185856785998, 0.0053651299029584291131, 0.98490781842170460614 },
	{ 0.98590619562565773304, 0.0053585457354779608002, 0.98492618237434148565 },
	{ 0.98592333410679777739, 0.0053519796878095052955, 0.98494450531898269929 },
	{ 0.98594044588505713733, 0.00534542889893011193, 0.98496279393134866798 },
	{ 0.98595749472081151143, 0.0053388933688397815711, 0.98498101769386114945 },
	{ 0.98597450731694169512, 0.0053323730975385116165, 0.98499920330940082813 },
	{ 0.98599147795140207329, 0.0053258718997235710707, 0.98501735268531653844 },
	{ 0.98600841425358698444, 0.005319384053349059463, 0.98503545437751649505 },
	{ 0.98602531431614803825, 0.0053129114657636108618, 0.98505351220069792273 },
	{ 0.98604215906559866678, 0.0053064541369672235324, 0.9850715185254661499 },
	{ 0.98605896471440246387, 0.0053000168353314813449, 0.98508949528633049653 },
	{ 0.98607574747502280132, 0.0052935909777875357618, 0.9851074262708274798 },
	{ 0.98609245489537200591, 0.005287179425358337452, 0.98512528763709972246 },
	{ 0.98610916231572132151, 0.00528078885376409915, 0.98514315091072046648 },
	{ 0.98612581633030882422, 0.0052744097262616583197, 0.98516094933448750126 },
	{ 0.98614243410527235856, 0.005268051579594177497, 0.98517872677741968879 },
	{ 0.98615898703038229467, 0.0052617010623212286113, 0.98519641648231481845 },
	{ 0.98617551706730866012, 0.0052553638964887095311, 0.98521407376228309349 },
	{ 0.98619201467930828198, 0.0052490496188397836597, 0.98523171387611363503 },
	{ 0.98620846460759192809, 0.0052427505999799216621, 0.98524930821357714628 },
	{ 0.98622488020360021821, 0.0052364649325604877353, 0.98526686058937074097 },
	{ 0.98624126146733315235, 0.0052301945239301150803, 0.98528437481819142185 },
	{ 0.98625759314000160938, 0.0052239355593915407644, 0.98530182228981011416 },
	{ 0.98627387236058272624, 0.0052176889926190796534, 0.98531921921669007869 },
	{ 0.98629013155400313551, 0.0052114662677045283518, 0.98533661137519834572 },
	{ 0.98630638311802898421, 0.0052052568942304077229, 0.9853539768308257063 },
	{ 0.98632254122197171586, 0.0051990570574994504974, 0.98537125454841600902 },
	{ 0.98633866403996495187, 0.0051928715258832388105, 0.98538848744331342111 },
	{ 0.98635479544102688809, 0.0051867079287763037318, 0.98540573273597675819 },
	{ 0.98637085436284088757, 0.0051805519610638997227, 0.9854228960126490966 },
	{ 0.98638689802586598798, 0.005174416974186457456, 0.98544004784522964968 },
	{ 0.98640287874638599153, 0.0051682915240521785927, 0.98545713292060799215 },
	{ 0.98641884802281432076, 0.0051621832400555968043, 0.98547419892250009976 },
	{ 0.98643474100529715543, 0.0051560844928021784192, 0.9854911905377954362 },
	{ 0.98645062445103703919, 0.0051500048190350885755, 0.98550817261634771071 },
	{ 0.98646646021306116925, 0.0051439404040570608709, 0.9855251108258814563 },
	{ 0.98648228166997053989, 0.0051378883868451472386, 0.98554201565681409658 },
	{ 0.98649802969395739005, 0.0051318506747479782776, 0.98555886040626472511 },
	{ 0.98651377199589829203, 0.0051258282214398731905, 0.98557568989692634354 },
	{ 0.98652945707738026737, 0.0051198153048749315067, 0.98559245072303713897 },
	{ 0.98654511927067867205, 0.0051138195544476851631, 0.98560919056831286511 },
	{ 0.98656074140965577257, 0.005107837155460868625, 0.98562588654457017334 },
	{ 0.98657633684575207766, 0.0051018738299603814956, 0.98564256726203836045 },
	{ 0.98659188459813262906, 0.0050959200412030577695, 0.98565918694435050718 },
	{ 0.9866073884814945405, 0.0050899757891888974468, 0.98567575131355222862 },
	{ 0.98662287519871871844, 0.0050840544253583312001, 0.98569231759010256244 },
	{ 0.98663831995427297983, 0.0050781425982709283568, 0.9857088266461938586 },
	{ 0.98665371130406553934, 0.0050722441226239561862, 0.98572528801856929004 },
	{ 0.98666908262669739127, 0.0050663599520917295543, 0.98574172364173817673 },
	{ 0.98668442915379694913, 0.0050604891329999327279, 0.98575812302528287301 },
	{ 0.98669973658024945351, 0.0050546326190228814401, 0.9857744871228778516 },
	{ 0.98671499632298620419, 0.0050487875491376276241, 0.98579079781471123933 },
	{ 0.98673022745549354706, 0.0050429558306928027461, 0.98580707417426927108 },
	{ 0.98674542044102830918, 0.0050371393710370408747, 0.98582332383094639638 },
	{ 0.9867605933994023637, 0.0050313391238446586104, 0.98583954583106847558 },
	{ 0.98677572153508352759, 0.0050255493670697554826, 0.98585571728645171596 },
	{ 0.98679080198704882676, 0.0050197729617352838949, 0.9858718467801650398 },
	{ 0.98680585764348194289, 0.0050140041857953433768, 0.98588792668281388654 },
	{ 0.98682088278233703882, 0.0050082544833417314001, 0.98590399132667361215 },
	{ 0.98683587644993964183, 0.005002519086002864962, 0.98592002259193234348 },
	{ 0.98685082910954669, 0.0049967941790814785277, 0.985936003312452236 },
	{ 0.98686572073399736471, 0.0049910807162518886979, 0.98595193062721042665 },
	{ 0.98688061808049409862, 0.004985386326908626542, 0.98596786366401456547 },
	{ 0.98689548586308684097, 0.0049797005206342137909, 0.98598374615607997651 },
	{ 0.98691031931340422734, 0.0049740299731488614443, 0.98599960575996170586 },
	{ 0.98692508886754237718, 0.0049683699160809899689, 0.98601539765296697393 },
	{ 0.98693982981145123023, 0.0049627213031049150979, 0.98603115330634827362 },
	{ 0.98695455549657096217, 0.0049570898562665355672, 0.98604689942298640037 },
	{ 0.98696925257146106425, 0.0049514717608685858419, 0.98606261692939511931 },
	{ 0.98698390005528680025, 0.0049458612948651689209, 0.98607826767860162764 },
	{ 0.98699852083623174082, 0.0049402679949994473402, 0.98609390316901912588 },
	{ 0.98701310633122685267, 0.0049346851855512066307, 0.98610949574409245688 },
	{ 0.98702766671776487328, 0.004929115623235731658, 0.98612506315111514432 },
	{ 0.98704218119382569618, 0.0049235537648201280203, 0.98614057004451149968 },
	{ 0.98705668638646393287, 0.0049180159121747432649, 0.98615609131751746919 },
	{ 0.9870711316913346467, 0.0049124798327680064408, 0.98617152844367705899 },
	{ 0.98708556555211357519, 0.0049069609194989640896, 0.98618695603309358688 },
	{ 0.9870999307483416807, 0.0049014496356244519407, 0.98620231877265651654 },
	{ 0.98711433695256545207, 0.0048959621936078504684, 0.98621772061286649969 },
	{ 0.987128635391591569, 0.0048904737979169332629, 0.98623300515113543341 },
	{ 0.98714293096959460083, 0.0048850016146893956645, 0.9862482849210330027 },
	{ 0.98715721033513437188, 0.0048795456439252359385, 0.98626354847846708918 },
	{ 0.98717143833636922245, 0.0048740983009338059717, 0.98627875894307504012 },
	{ 0.98718563839792883297, 0.0048686660826205881147, 0.98629394844173801093 },
	{ 0.98719981312751448055, 0.0048632428050040810152, 0.98630909770726571395 },
	{ 0.98721395491063501648, 0.0048578333407636176133, 0.9863242145627566515 },
	{ 0.98722805082797682186, 0.0048524335026741451105, 0.98633928596972841873 },
	{ 0.98724213466047916476, 0.0048470504581927843779, 0.98635434731840521128 },
	{ 0.98725618869065911998, 0.0048416778445243384421, 0.98636936992406276659 },
	{ 0.98727018736302774027, 0.0048363127261395952305, 0.98638433609901166044 },
	{ 0.98728416536748331289, 0.0048309597522016084134, 0.98639927540717819987 },
	{ 0.9872981300204984878, 0.0048256220370526828681, 0.98641420327125295398 },
	{ 0.98731205652654097094, 0.0048202976733441871282, 0.98642909680305213005 },
	{ 0.98732594488561076229, 0.0048149847537274888601, 0.98644395218787872537 },
	{ 0.98733980081975381005, 0.0048096794635053199268, 0.98645876179633806835 },
	{ 0.98735366056859408257, 0.0048043875247235825338, 0.98647356568275146316 },
	{ 0.98736746023595245436, 0.0047991098910565906793, 0.98648832283912335495 },
	{ 0.98738121508061793552, 0.0047938370257611809602, 0.98650302372871068179 },
	{ 0.98739495466649429556, 0.0047885794192548333803, 0.98651771126685761093 },
	{ 0.98740866182744402302, 0.0047833370715375488069, 0.98653237591682096941 },
	{ 0.98742235526442256877, 0.004778104275464972045, 0.98654701337217665102 },
	{ 0.98743600462376968085, 0.0047728800326581541369, 0.9865616012662472567 },
	{ 0.98744963167607679999, 0.004767672017216260244, 0.98657617627082483391 },
	{ 0.98746321772038836428, 0.0047624706774945816876, 0.98659070073066368334 },
	{ 0.98747678755223655678, 0.0047572855502362801361, 0.98660521470008488709 },
	{ 0.98749031637608930545, 0.004752107098698193921, 0.98661967812476736306 },
	{ 0.98750382135808401074, 0.0047469410449262217783, 0.98663411198554595849 },
	{ 0.98751729391515197243, 0.0047417845278974130388, 0.98664851151404919793 },
	{ 0.98753074549138497584, 0.0047366413623090332374, 0.98666289006171747911 },
	{ 0.98754416082799389986, 0.0047315096408124517752, 0.98667723809180774008 },
	{ 0.987557557091116478, 0.0047263893634076677847, 0.98669155751166848223 },
	{ 0.98757092855870687309, 0.0047212805300946812659, 0.9867058502286482069 },
	{ 0.98758424375951259222, 0.004716182187199174751, 0.9867200962155866506 },
	{ 0.98759754656255227534, 0.0047110924273725150388, 0.98673431454596982615 },
	{ 0.98761083315312847564, 0.0047060150653119685316, 0.98674850903449518036 },
	{ 0.98762408255040623484, 0.0047009501010175352292, 0.98676267586646515539 },
	{ 0.98763730524480330963, 0.0046958984881635317324, 0.98677681981025167079 },
	{ 0.98765049265325055572, 0.0046908516436811095035, 0.98679091511664807079 },
	{ 0.98766363905370235798, 0.0046858152896161690132, 0.98680496941504891595 },
	{ 0.98767677973210821207, 0.0046807961016889238631, 0.98681902371344965008 },
	{ 0.98768988130986701268, 0.0046757816821332608484, 0.98683302555976293302 },
	{ 0.98770296858251105387, 0.0046707796603437101712, 0.98684701119361295518 },
	{ 0.98771601198613667716, 0.0046657909899945901669, 0.98686096249518751033 },
	{ 0.9877290248721840582, 0.0046608080416913680311, 0.98687487183509225996 },
	{ 0.98774203585088271584, 0.0046558441668744744366, 0.98688879071174018254 },
	{ 0.98775499533116839501, 0.0046508821994062123084, 0.98690263710914005735 },
	{ 0.98776791284978426866, 0.0046459335833783817205, 0.9869164606183563615 },
	{ 0.98778085325658360194, 0.0046409983187909792032, 0.98693028794226989042 },
	{ 0.98779373835027262096, 0.0046360687762494754219, 0.98694405804572427066 },
	{ 0.98780659292638350877, 0.0046311563998456661134, 0.9869578147977383642 },
	{ 0.98781943510472836056, 0.0046262487918134398077, 0.98697153435645423869 },
	{ 0.98783222483098576117, 0.0046213516741986935057, 0.98698521099982583493 },
	{ 0.98784500692784849019, 0.0046164679080243770093, 0.98699888001380298164 },
	{ 0.98785777376592232013, 0.0046115955859418579846, 0.98701252995429356041 },
	{ 0.98787049292028028535, 0.0046067270785566036273, 0.98702611885962798777 },
	{ 0.98788316629827110926, 0.0046018719226117799428, 0.98703967915473300732 },
	{ 0.98789584921300499509, 0.0045970282107587528628, 0.9870532356351408021 },
	{ 0.98790848635137162859, 0.0045921921283002577197, 0.98706674252448400875 },
	{ 0.98792111776769242493, 0.0045873674899335600483, 0.98708024178443276586 },
	{ 0.9879337072223431937, 0.0045825562030072904476, 0.98709370861945466835 },
	{ 0.98794626425206721887, 0.0045777506381269195829, 0.9871071334928066543 },
	{ 0.98795881746709390825, 0.0045729565173383461898, 0.98712054692206685491 },
	{ 0.98797133062779962653, 0.0045681738406415685338, 0.98713392601905169954 },
	{ 0.98798382090032166314, 0.0045634007006879568832, 0.98714728413520147488 },
	{ 0.98799626730382505979, 0.0045586370974775077686, 0.98716059647498421992 },
	{ 0.98800870893895698099, 0.0045538820773359071914, 0.98717389260230348214 },
	{ 0.98802111719548779689, 0.0045491394549604206865, 0.98718716298041631063 },
	{ 0.98803351210057810405, 0.004544408276676730786, 0.98720041809973990699 },
	{ 0.98804584787786076117, 0.0045396790057416723518, 0.9872136007398155666 },
	{ 0.98805820558965273825, 0.0045349697619672599269, 0.98722682057318966731 },
	{ 0.98807049082219666758, 0.004530260518192847502, 0.98723994885382948539 },
	{ 0.98808278082311218338, 0.0045255674868818129494, 0.98725309143958384084 },
	{ 0.98809503839910095557, 0.0045208820849653085991, 0.98726619587836550451 },
	{ 0.98810726641118584723, 0.00451620717346628512, 0.98727927075324339867 },
	{ 0.98811947630345864368, 0.0045115389376874761099, 0.98729231797156591366 },
	{ 0.98813166140019936812, 0.0045068859606977301063, 0.98730535565314547775 },
	{ 0.98814383123815086041, 0.004502238705753883706, 0.98731835709510096244 },
	{ 0.98815595529973543343, 0.004497600987553200709, 0.98733132039008386638 },
	{ 0.98816806982457672248, 0.0044929766207929475175, 0.98734427605567220976 },
	{ 0.98818015573918860373, 0.0044883579760785939292, 0.98735719738898508613 },
	{ 0.98819218252599283492, 0.0044837431460615050083, 0.98737005005774725053 },
	{ 0.98820423792302658494, 0.0044791492968793778298, 0.98738294659552805488 },
	{ 0.98821623991429885514, 0.0044745592623945161861, 0.98739578019080387339 },
	{ 0.9882282285541306166, 0.0044699806720014511469, 0.9874085985272906818 },
	{ 0.98824019621312719774, 0.0044654097110029171772, 0.98742139206824508513 },
	{ 0.98825212000310524996, 0.0044608463793989134097, 0.98743413983283234714 },
	{ 0.98826403044164301548, 0.004456294491886707114, 0.98744687424597932246 },
	{ 0.98827591226995104012, 0.0044517502337690318878, 0.98745957432685083077 },
	{ 0.98828778456151600285, 0.0044472193270917864671, 0.98747227440772233908 },
	{ 0.98829960440099351437, 0.0044426931887861240492, 0.98748491440711194667 },
	{ 0.9883114461749804569, 0.0044381794482465739687, 0.98749756871161642469 },
	{ 0.98832324407994875948, 0.004433675244450188159, 0.98751018486914809991 },
	{ 0.98833501909673360242, 0.0044291786700483334188, 0.98752277241645025629 },
	{ 0.98834673975408238178, 0.0044246868640180616813, 0.98753529797492189957 },
	{ 0.98835846899449997238, 0.0044202112704511678162, 0.98754784737525136418 },
	{ 0.98837015436589892303, 0.0044157394915815394859, 0.98756034146247062555 },
	{ 0.98838183210790353517, 0.0044112791568037094947, 0.98757282601294671398 },
	{ 0.98839347265660948416, 0.0044068254977460931052, 0.98758526764807841314 },
	{ 0.98840510557592098362, 0.0044023832827802724527, 0.98759770546851288753 },
	{ 0.98841669939458554062, 0.0043979477435346680039, 0.9876100965589058589 },
	{ 0.98842829321325009762, 0.0043935255557294924933, 0.98762249527869339083 },
	{ 0.98843985460698791101, 0.0043891109973188489196, 0.98763486157355406814 },
	{ 0.9884513816684502574, 0.0043847059756513696166, 0.9876471916287908881 },
	{ 0.98846288488805478245, 0.0043803057223554724489, 0.98765948830542671377 },
	{ 0.98847438333928783205, 0.0043759159594770544177, 0.98767177830634211855 },
	{ 0.98848583601415362931, 0.0043715357333418015245, 0.98768402825293621916 },
	{ 0.98849729527890894953, 0.0043671646720167310932, 0.98769627336440146692 },
	{ 0.98850870568692883467, 0.0043628016120191735402, 0.98770847822127394444 },
	{ 0.98852011865079603137, 0.0043584491950269862309, 0.98772067975935984308 },
	{ 0.98853147891462056496, 0.0043541000014539884763, 0.98773282119689032044 },
	{ 0.98854284623563482004, 0.004349765799641244074, 0.98774497732100552394 },
	{ 0.98855415214002329005, 0.0043454329329725436062, 0.98775706264433937864 },
	{ 0.98856547753751478069, 0.0043411166983839217723, 0.98776917459426005763 },
	{ 0.98857675143659329287, 0.0043368033629652222999, 0.98778122634825804571 },
	{ 0.98858802474439333441, 0.0043325033980604384792, 0.98779328334746463458 },
	{ 0.98859926207959836209, 0.0043282085067030181408, 0.98780529796538452114 },
	{ 0.98861047568738646962, 0.0043239229995008700985, 0.98781728824553594048 },
	{ 0.98862166400373174824, 0.0043196430999037013776, 0.98782924575743769058 },
	{ 0.98863283477246932662, 0.004315376017689346623, 0.98784119617400256708 },
	{ 0.9886439988654869282, 0.0043111162215467690312, 0.98785312717375850511 },
	{ 0.98865511905133895976, 0.0043068629485365148013, 0.98786501907286750068 },
	{ 0.98866623256147079246, 0.0043026201659437414426, 0.98787689948973755882 },
	{ 0.98867734775006943515, 0.0042983897429701087289, 0.98788878738341423524 },
	{ 0.98868838801801361971, 0.0042941597777601476019, 0.9879005933373936621 },
	{ 0.98869942912519126477, 0.0042899408751722574798, 0.98791239646849715594 },
	{ 0.98871046603620194038, 0.0042857313567396405213, 0.9879241950982579068 },
	{ 0.98872146851956976832, 0.004281530135273577467, 0.98793595800337896673 },
	{ 0.98873242227017998918, 0.0042773345023390078878, 0.98794767591414556218 },
	{ 0.98874339269101740868, 0.0042731487494703564861, 0.98795939943251709359 },
	{ 0.98875431886136666559, 0.0042689711600538537278, 0.98797108388838883464 },
	{ 0.98876523568570739986, 0.0042648023825880339993, 0.98798275785384304104 },
	{ 0.98877615327298762349, 0.0042606429129835423145, 0.9879944244950783494 },
	{ 0.98878701608121533084, 0.0042564915305372532858, 0.98800604719100126871 },
	{ 0.98879787038266808707, 0.0042523445349928207931, 0.98801764604506636669 },
	{ 0.98880869746625577044, 0.0042482085448499982971, 0.98802922840056572884 },
	{ 0.98881950202405610728, 0.0042440784865614240504, 0.98804077827391767475 },
	{ 0.98883031531751319765, 0.0042399607497450178886, 0.98805233802733571924 },
	{ 0.98884106280744232809, 0.0042358435088392567408, 0.98806382472930098793 },
	{ 0.98885180415570894663, 0.0042317400389906252925, 0.988075315589286296 },
	{ 0.98886253783643407456, 0.0042276433211561525657, 0.98808679168639323986 },
	{ 0.98887324767530138114, 0.0042235533553358411626, 0.98809823516783856778 },
	{ 0.98888394309461291609, 0.0042194744521375990298, 0.98810967597899590498 },
	{ 0.98889459517896349805, 0.0042154005843397478193, 0.98812106841979174821 },
	{ 0.98890522468030628289, 0.0042113320571180680105, 0.98813242988524574439 },
	{ 0.98891585906446155541, 0.0042072783309217778869, 0.98814380538878565652 },
	{ 0.98892646949231788334, 0.0042032279616590825788, 0.98815514564452311408 },
	{ 0.98893705741346060734, 0.0041991894179579103419, 0.98816647361693521479 },
	{ 0.98894761638105066481, 0.0041951536589857419193, 0.98817776195464268607 },
	{ 0.98895815257489816386, 0.0041911274749037103274, 0.98818902996001378725 },
	{ 0.98896868840634932774, 0.0041871082526441887051, 0.9882002886003031783 },
	{ 0.98897918691098796184, 0.0041830965644117671862, 0.98821151311812560625 },
	{ 0.98898967378079960522, 0.0041790929251905757635, 0.98822272134719046921 },
	{ 0.98900011950910160508, 0.0041750937300916984157, 0.98823388832030456541 },
	{ 0.98901057460248531505, 0.0041711101943250963875, 0.98824507598815125586 },
	{ 0.98902101191937974445, 0.0041671316176649392943, 0.9882562335198896708 },
	{ 0.98903140347898033102, 0.0041631577140089333702, 0.98826734758315248897 },
	{ 0.98904178357541572275, 0.0041591911917921355751, 0.9882784420960918359 },
	{ 0.98905214494168769424, 0.0041552331763502411976, 0.98828952276168025026 },
	{ 0.98906250619351876452, 0.004151286109089499278, 0.98830060483870652011 },
	{ 0.98907282231748117063, 0.0041473403769728004256, 0.98831162752089629642 },
	{ 0.98908312903821471451, 0.004143406527638083918, 0.9883226507180704612 },
	{ 0.98909340178906912655, 0.0041394763976332011116, 0.98833363620696190743 },
	{ 0.98910368012845506502, 0.0041355590659376446905, 0.98834462827620617187 },
	{ 0.98911394141614417119, 0.0041316482573744133661, 0.98835559837279429729 },
	{ 0.98912415797650798943, 0.0041277406722303698616, 0.98836652271208869092 },
	{ 0.9891343559783696282, 0.004123841689228660741, 0.98837742795882332913 },
	{ 0.989144556555151655, 0.0041199512320753400169, 0.98838833105025380998 },
	{ 0.9891547257560489026, 0.0041160660582777322883, 0.98839920020995220007 },
	{ 0.98916488629758325679, 0.0041121941596266101127, 0.98841007360396448966 },
	{ 0.98917501561582044101, 0.0041083241492506335571, 0.98842089979109826192 },
	{ 0.98918512620389420498, 0.0041044618827101057509, 0.98843170923171108644 },
	{ 0.9891952250617738196, 0.0041006084090467759956, 0.98844250930724208981 },
	{ 0.98920530772626347193, 0.0040967607146498033824, 0.98845328517851871464 },
	{ 0.98921537040173956878, 0.0040929225569959941725, 0.98846404601988835381 },
	{ 0.98922540679395143393, 0.0040890894728895501795, 0.98847477912840886471 },
	{ 0.98923542813718257083, 0.0040852630835768065018, 0.9884854893296721734 },
	{ 0.98924544261395874756, 0.0040814480239149408813, 0.98849619949278855202 },
	{ 0.98925540715634774358, 0.0040776338416334467415, 0.98850685491499923341 },
	{ 0.98926537803113401282, 0.0040738313323255845658, 0.98851751655516628681 },
	{ 0.9892753283828490396, 0.0040700361090895012875, 0.98852816141066546241 },
	{ 0.98928524234235215573, 0.0040662438994642571832, 0.98853875919280043139 },
	{ 0.98929515170514503719, 0.0040624618560072258897, 0.98854935642180419286 },
	{ 0.98930505000531610005, 0.0040586859923597649186, 0.98855993831572519515 },
	{ 0.98931491935193494047, 0.0040549148970838860828, 0.98857048492369636872 },
	{ 0.98932478171765758646, 0.0040511554366346666511, 0.98858103393492680055 },
	{ 0.98933461596906135949, 0.0040474005156751939952, 0.98859154972014406937 },
	{ 0.98934443789899306765, 0.0040436534148451160758, 0.98860205097136477637 },
	{ 0.98935421700894787822, 0.0040399106436964345515, 0.98861251111922243684 },
	{ 0.98936401406705321016, 0.0040361774283644040115, 0.98862298322615604906 },
	{ 0.98937378228604722086, 0.0040324513846632320871, 0.98863343046126350711 },
	{ 0.9893835248512021785, 0.0040287321120497073326, 0.98864385089812256702 },
	{ 0.98939324836194419976, 0.0040250193434950200938, 0.9886542518990990569 },
	{ 0.98940296868741417491, 0.0040213123542066899971, 0.98866463972029661189 },
	{ 0.98941265260159871886, 0.0040176118689771982834, 0.98867499639449096804 },
	{ 0.98942233973920246104, 0.0040139181929823262995, 0.98868534717497802422 },
	{ 0.98943199906766299279, 0.0040102339774366725991, 0.98869567998824092747 },
	{ 0.98944162740170849002, 0.0040065517646070839333, 0.98870597192702269762 },
	{ 0.98945124314725285686, 0.0040028791648146037907, 0.98871625608382196493 },
	{ 0.98946086568295832375, 0.0039992175513502477985, 0.9887265494721884096 },
	{ 0.98947043908536314039, 0.0039955530387159694447, 0.98873677793440739592 },
	{ 0.98948001805722585189, 0.003991903708576809845, 0.98874702516493706561 },
	{ 0.98948956563413004162, 0.0039882564002272002587, 0.98875723070082555122 },
	{ 0.98949909291684490231, 0.0039846165686842315024, 0.98876742021498553736 },
	{ 0.98950863585889203833, 0.0039809877043959010501, 0.98877762309965966381 },
	{ 0.9895181304115044929, 0.0039773598510023456046, 0.98878777118620742037 },
	{ 0.98952759980618842928, 0.0039737401801344263835, 0.98879790063795924837 },
	{ 0.98953707148969072271, 0.0039701300078626980058, 0.98880803546843420992 },
	{ 0.98954652247846031088, 0.0039665219146009797827, 0.98881813404021157154 },
	{ 0.98955594020306980596, 0.0039629196196791054152, 0.98882820117888348133 },
	{ 0.98956537078320927492, 0.0039593288832899453319, 0.98883828666624939974 },
	{ 0.98957477212369393538, 0.0039557404547926316302, 0.98884833303389485515 },
	{ 0.98958415286481338224, 0.0039521625930067439195, 0.98885836894926959495 },
	{ 0.98959351977765530606, 0.0039485897475477604174, 0.98886838619170136511 },
	{ 0.98960287265241120291, 0.0039450214797254945162, 0.98887838085112522712 },
	{ 0.98961219954907875263, 0.0039414616423841869128, 0.98888835967955546202 },
	{ 0.98962151601254921829, 0.0039379079276319894909, 0.98889831994948362848 },
	{ 0.9896308195060489199, 0.0039343595916029368981, 0.98890826511321050507 },
	{ 0.98964009267270558468, 0.0039308190757032790419, 0.98891818715987200861 },
	{ 0.98964935643613349825, 0.0039272831565138263676, 0.98892809148726468216 },
	{ 0.98965860005795980303, 0.0039237524253126548554, 0.98893797170577069089 },
	{ 0.98966783729016816196, 0.0039202330809828215413, 0.98894785324034717444 },
	{ 0.98967705104291481266, 0.0039167154341932710476, 0.98895770122466120089 },
	{ 0.98968623362958496603, 0.0039132024031874115821, 0.98896751705107732722 },
	{ 0.98969543723523689671, 0.0039097058898207122032, 0.98897737121520090664 },
	{ 0.98970458459317778299, 0.0039062027961012297551, 0.98898714197096904144 },
	{ 0.98971374410092927132, 0.0039027126914259360584, 0.98899693319258774604 },
	{ 0.98972287229001632003, 0.0038992284232374587773, 0.9890066984361181035 },
	{ 0.98973199677884682313, 0.003895750525593415052, 0.98901645296034923494 },
	{ 0.98974108994901288661, 0.0038922777777906803626, 0.98902618028578881404 },
	{ 0.98975017798841113947, 0.0038888105803724670219, 0.98903589210448406011 },
	{ 0.98975925124585750758, 0.0038853520995375053111, 0.98904559951720394384 },
	{ 0.98976830090940115525, 0.0038818990164991751431, 0.98905527707991758302 },
	{ 0.98977733163297287877, 0.0038784495002027880028, 0.98906493013320140317 },
	{ 0.98978635396421077441, 0.0038750081473585495061, 0.98907457952437594084 },
	{ 0.98979537917554505366, 0.0038715746337171920259, 0.98908422496733872098 },
	{ 0.98980434756696344945, 0.0038681436568495158532, 0.98909381965575438045 },
	{ 0.9898133047813190144, 0.0038647162276502972957, 0.98910338966307875808 },
	{ 0.98982226985395094232, 0.0038613019973036178702, 0.98911298416075932316 },
	{ 0.98983121905744220204, 0.0038578924971815480201, 0.98912255485472899696 },
	{ 0.98984014430463440615, 0.0038544868117567441385, 0.98913209670958723851 },
	{ 0.98984905850827809015, 0.0038510870200392150788, 0.98914162637648772591 },
	{ 0.98985795117795594145, 0.0038476951438185121555, 0.98915114190993491672 },
	{ 0.98986683503568306808, 0.0038443087989088443011, 0.98916063955245203676 },
	{ 0.98987568744123122233, 0.0038409240370985415873, 0.98917010120330051137 },
	{ 0.98988452420652051078, 0.0038375475150343326368, 0.98917955186782080546 },
	{ 0.98989336326062826732, 0.0038341800338026433767, 0.98918900512633523014 },
	{ 0.98990218255460404873, 0.0038308161383863838581, 0.98919843160567477724 },
	{ 0.98991100018918642967, 0.0038274617606398018965, 0.98920786340651689628 },
	{ 0.98991978290021542808, 0.0038241094619032300894, 0.98921725612578559339 },
	{ 0.98992856326520584087, 0.0038207621413465894973, 0.98922663555083467646 },
	{ 0.9899373047775044121, 0.0038174225074049396821, 0.98923599164900966052 },
	{ 0.98994603129804270569, 0.0038140849333998133076, 0.98924531806883997387 },
	{ 0.98995475335538518635, 0.0038107570105787688837, 0.98925464818892661079 },
	{ 0.98996349595487254103, 0.0038074396735426358634, 0.98926399579940038631 },
	{ 0.98997217488706246158, 0.0038041197806593352558, 0.98927327554640964724 },
	{ 0.98998084786832474258, 0.0038008080512281832916, 0.98928254980025465137 },
	{ 0.9899895330947651173, 0.0037975056678053323647, 0.98929183805403886343 },
	{ 0.98999816028058662543, 0.003794202731251377584, 0.98930106155333696893 },
	{ 0.99000679982602735052, 0.003790909064411778287, 0.98931029825148752987 },
	{ 0.99001543977201134084, 0.003787624953388829107, 0.98931953985152409903 },
	{ 0.99002403249204307123, 0.0037843410712477161539, 0.98932873109755692376 },
	{ 0.99003262120664281554, 0.003781062720417637836, 0.98933791032729334614 },
	{ 0.99004118766248394579, 0.0037777908736463974675, 0.98934707008300004638 },
	{ 0.99004976809919043035, 0.0037745280486341905093, 0.9893562440103070843 },
	{ 0.99005829993665384059, 0.0037712662154432727117, 0.98936536834654975614 },
	{ 0.99006684161603608629, 0.0037680159789320426256, 0.98937450916228453224 },
	{ 0.99007536111295391112, 0.0037647659522291620528, 0.98938361406264463405 },
	{ 0.99008385505139995253, 0.0037615225249525508291, 0.98939269683776054354 },
	{ 0.99009234672010126843, 0.0037582835417982536803, 0.9894017723077314086 },
	{ 0.99010081752240841624, 0.0037550533705946404286, 0.98941083545622987572 },
	{ 0.99010927077710819688, 0.0037518254119154408575, 0.98941987091002636667 },
	{ 0.9901177206367274275, 0.0037486053496595815766, 0.98942890670714567225 },
	{ 0.99012617171704975227, 0.0037453941375013783191, 0.98943794464049539261 },
	{ 0.99013456908643449061, 0.003742181094288487414, 0.9894469227593919447 },
	{ 0.99014296822965353062, 0.0037389783698317008605, 0.98945591112075059748 },
	{ 0.99015136416852678192, 0.0037357806426283322355, 0.98946488548217026437 },
	{ 0.99015973159253800606, 0.0037325834304090940372, 0.98947382289824681312 },
	{ 0.99016809228360858075, 0.003729398825764318557, 0.98948277269301598835 },
	{ 0.99017643084943496312, 0.0037262152892347773572, 0.98949168777404017394 },
	{ 0.99018476449430214981, 0.0037230388098951783943, 0.98950059843001558768 },
	{ 0.99019307614743934387, 0.0037198664695021121593, 0.98950948381362147099 },
	{ 0.99020138453901029862, 0.0037167025786634896346, 0.98951837287841037938 },
	{ 0.99020967244565716303, 0.003713539717793127963, 0.98952722928939074176 },
	{ 0.99021793763578180858, 0.0037103836280104134614, 0.989536069583275113 },
	{ 0.99022620730817545454, 0.0037072376662489387768, 0.98954491996703364265 },
	{ 0.99023445289075606723, 0.0037040914946791145788, 0.98955373241362798442 },
	{ 0.99024268121183145475, 0.0037009521323439096771, 0.98956253290114637444 },
	{ 0.99025091296613443337, 0.0036978199416395642583, 0.98957133525786655781 },
	{ 0.99025910026014096754, 0.0036946882659193496998, 0.98958008720336232411 },
	{ 0.99026730468213819414, 0.003691567309498451372, 0.98958886001525203646 },
	{ 0.99027548078000804388, 0.0036884485846754538722, 0.98959760209975511369 },
	{ 0.99028363442838451824, 0.0036853343039747704472, 0.989606320857384536 },
	{ 0.9902917839568879943, 0.003682226889729165592, 0.98961503572402265139 },
	{ 0.99029993119657311329, 0.0036791265708204746662, 0.98962374898848814997 },
	{ 0.99030805264890464645, 0.0036760290747877601147, 0.98963243120131771935 },
	{ 0.99031615407407547202, 0.0036729346686598307245, 0.98964109064040473029 },
	{ 0.99032425572812821102, 0.003669851935505533732, 0.98964976266799276061 },
	{ 0.99033232854306962878, 0.0036667669135328775053, 0.9896583890718015919 },
	{ 0.99034040011823454286, 0.003663690302967692429, 0.98966701751647334628 },
	{ 0.99034845109403413232, 0.0036606202155348311483, 0.98967563215194098714 },
	{ 0.99035650258481788821, 0.0036575556784864912165, 0.98968424074111349675 },
	{ 0.99036450593412206356, 0.0036544913703199875116, 0.98969280149398208835 },
	{ 0.9903725390571384013, 0.0036514377242323407639, 0.98970138946471597485 },
	{ 0.99038052398145492994, 0.0036483874922987468044, 0.98970993713317312324 },
	{ 0.99038853969037821123, 0.003645344317555094648, 0.98971850147185724822 },
	{ 0.9903964950889377894, 0.0036422999602552896641, 0.98972700557647164121 },
	{ 0.99040446336210063993, 0.0036392673712965497787, 0.98973553289351878792 },
	{ 0.99041240853727152693, 0.003636236289143229914, 0.98974402646956871621 },
	{ 0.99042034659803190877, 0.0036332112914320485383, 0.98975251457152790824 },
	{ 0.99042826438367626007, 0.0036301897460218925107, 0.98976097984252386919 },
	{ 0.99043617316663523642, 0.0036271732360121274052, 0.98976943183837351459 },
	{ 0.99044407586515226249, 0.0036241670829054383439, 0.98977789354262779575 },
	{ 0.99045196687162206928, 0.003621158888935711688, 0.98978631998000587977 },
	{ 0.99045983228147338462, 0.0036181592017408875823, 0.98979473417220564802 },
	{ 0.99046768704831922303, 0.0036151646643873720788, 0.98980313581405154899 },
	{ 0.99047552569806895928, 0.0036121729308363475369, 0.98981151706634040721 },
	{ 0.99048335128248043979, 0.0036091874343153517238, 0.98981988433776357805 },
	{ 0.99049117120206653375, 0.0036062071067091507927, 0.98982825010238162378 },
	{ 0.99049899209440062098, 0.0036032330161329794577, 0.98983661024032121301 },
	{ 0.99050677079618287824, 0.0036002608329054408901, 0.98984493032393938705 },
	{ 0.99051456056058717614, 0.0035972965079542691853, 0.98985326085982805466 },
	{ 0.99052233245313492382, 0.0035943365508314668692, 0.98986157154021725546 },
	{ 0.99053006745756000395, 0.0035913775473829802863, 0.98986984182296255952 },
	{ 0.99053781173169941354, 0.0035884265547987516734, 0.98987812217650883451 },
	{ 0.9905455441612038836, 0.0035854808074232634961, 0.98988639263091560139 },
	{ 0.99055326404035437537, 0.0035825408965345917345, 0.98989464931426518479 },
	{ 0.99056096499860646354, 0.0035796025115248258398, 0.98990287944732191505 },
	{ 0.99056865994871012848, 0.0035766728430983124425, 0.98991111440597068238 },
	{ 0.99057633029401670477, 0.0035737441283461147783, 0.98991931560454871075 },
	{ 0.99058400813520330885, 0.0035708229094740446576, 0.98992752155242469403 },
	{ 0.99059165175855556917, 0.0035679041701551965707, 0.98993569915710000195 },
	{ 0.99059929944456026618, 0.0035649919730421589931, 0.98994387395797278639 },
	{ 0.9906069342941087319, 0.0035620832282301471972, 0.98995203584609547942 },
	{ 0.99061454535901960483, 0.0035591817504164262841, 0.98996018123565254765 },
	{ 0.99062215007245957299, 0.0035562813216444533714, 0.98996830688415116128 },
	{ 0.99062972922742786874, 0.003553386538624433641, 0.98997641490874843662 },
	{ 0.99063732646406121862, 0.0035505015212294144082, 0.98998454383788669908 },
	{ 0.99064487876356066565, 0.0035476157408949413746, 0.98999262165008161674 },
	{ 0.99065244864881463194, 0.0035447339659925975429, 0.99000070300994491568 },
	{ 0.99065998586118653169, 0.0035418595343824901475, 0.99000876768050760646 },
	{ 0.99066751836240740658, 0.0035389910346266310014, 0.99001682874618146535 },
	{ 0.9906750366538807917, 0.0035361229354139841682, 0.99002485961852659813 },
	{ 0.99068254523694954106, 0.0035332644683119334393, 0.99003289554534534833 },
	{ 0.99069003644407249709, 0.0035304069358107130309, 0.99004090509353270821 },
	{ 0.99069752709806435664, 0.0035275566321608100781, 0.99004891759811042284 },
	{ 0.99070498994291311678, 0.003524708045124677093, 0.99005689588485379371 },
	{ 0.99071245072782510022, 0.0035218657904860051037, 0.99006487363753958864 },
	{ 0.99071989556730266635, 0.0035190262061354188154, 0.99007283269820867133 },
	{ 0.99072732985914213621, 0.0035161951857801943509, 0.9900807899087493702 },
	{ 0.99073475585401515886, 0.0035133630019423033389, 0.99008871944366161344 },
	{ 0.99074215382993691126, 0.0035105400687452815306, 0.99009664087234205976 },
	{ 0.99074956052244189664, 0.0035077201682325860436, 0.99010455675063813175 },
	{ 0.9907569456619071957, 0.0035049039679762384117, 0.99011245275436143842 },
	{ 0.99076433045804990218, 0.0035020943671461601289, 0.9901203508561681188 },
	{ 0.99077167891920114862, 0.0034992876464125170603, 0.990128213652951783 },
	{ 0.99077904130399729876, 0.0034964868384596368284, 0.99013608461318736165 },
	{ 0.99078637727201490648, 0.0034936879187819026502, 0.99014392595229860916 },
	{ 0.99079370831907309647, 0.0034908968192335632086, 0.99015176832137818952 },
	{ 0.990801010412578953, 0.0034881073600050481812, 0.99015958372054801995 },
	{ 0.99080831532896085356, 0.0034853210288282908749, 0.99016738790450808949 },
	{ 0.99081561723173194878, 0.0034825423651930380656, 0.99017519456802127742 },
	{ 0.99082291812360834271, 0.0034797707015272669184, 0.99018300243316448306 },
	{ 0.99083016103208620962, 0.0034769965583082733038, 0.99019074998794354148 },
	{ 0.99083742907941874112, 0.0034742330199476782401, 0.99019852619109915981 },
	{ 0.99084467448652324695, 0.0034714697295424052498, 0.99020627223907276004 },
	{ 0.99085191167295505466, 0.0034687122184034898352, 0.99021401113448903608 },
	{ 0.99085915109098476883, 0.0034659610205885487029, 0.99022175180373950276 },
	{ 0.99086634797514006046, 0.0034632105475660879441, 0.99022944765029718983 },
	{ 0.99087355122983966638, 0.0034604650717970455477, 0.99023714635787796201 },
	{ 0.99088073399961484888, 0.0034577247458693117534, 0.99024483327804391219 },
	{ 0.99088793368757244195, 0.0034549932509657472687, 0.99025253307281313475 },
	{ 0.99089509656370156065, 0.0034522597342726323369, 0.9902601884263594334 },
	{ 0.99090223847806924162, 0.0034495295935865976332, 0.99026782228408649633 },
	{ 0.99090940442502961627, 0.0034468092948195089807, 0.99027548612533400352 },
	{ 0.99091652589261991491, 0.0034440892249342556879, 0.99028310335098101991 },
	{ 0.9909236523383901929, 0.0034413762694594026044, 0.99029072223602132574 },
	{ 0.99093076474607455495, 0.0034386670523878703695, 0.99029833021102742219 },
	{ 0.99093785951078405816, 0.0034359617072340625094, 0.99030592370925740742 },
	{ 0.99094493726194377015, 0.0034332569724318169092, 0.99031348409591513082 },
	{ 0.99095204299390804437, 0.0034305649977919251345, 0.99032108859954659508 },
	{ 0.99095910289228450463, 0.0034278708678480785191, 0.99032863983093089022 },
	{ 0.99096614922941217429, 0.0034251809531447101852, 0.99033617414413288582 },
	{ 0.99097320411146183616, 0.0034224969130751303932, 0.990343714408262632 },
	{ 0.99098023076475161286, 0.0034198166877028165697, 0.99035123308120587282 },
	{ 0.99098724141538663268, 0.0034171386176344575869, 0.99035872896133292365 },
	{ 0.9909942709106257519, 0.0034144685584303565741, 0.99036624307571274883 },
	{ 0.99100126416624101378, 0.0034117990332838731352, 0.99037372034011705857 },
	{ 0.99100826783597983916, 0.0034091384726759633994, 0.99038121206222384796 },
	{ 0.99101525838316006922, 0.0034064798194166868647, 0.99038868585525374755 },
	{ 0.99102222779691750976, 0.0034038249808546754312, 0.99039614065109105034 },
	{ 0.99102916287839937226, 0.0034011699897047737579, 0.99040355524001921772 },
	{ 0.99103612252653194847, 0.003398525527119325082, 0.99041099943099819569 },
	{ 0.9910430424636658131, 0.0033958830863234268534, 0.99041840627609101233 },
	{ 0.99104997769773561789, 0.0033932437354323142197, 0.99042581956802200338 },
	{ 0.99105688674390879367, 0.0033906065398451559929, 0.99043320331512263444 },
	{ 0.99106380069196775562, 0.0033879769545790434232, 0.99044059410033979951 },
	{ 0.99107070071638181386, 0.0033853518325087312082, 0.99044797508178494816 },
	{ 0.99107757770002413711, 0.0033827302199599036149, 0.99045533485351344716 },
	{ 0.99108444062650735695, 0.003380108969807316642, 0.99046266939101945681 },
	{ 0.99109131799161975795, 0.0033774970465895435591, 0.99047002206741108221 },
	{ 0.99109816813886697506, 0.003374887202381780197, 0.99047735084472432465 },
	{ 0.99110500634611176096, 0.0033722782355543874482, 0.99048465745864633369 },
	{ 0.99111183360517562946, 0.0033696777373549246896, 0.99049196308074727302 },
	{ 0.99111865783155495002, 0.0033670800429579524592, 0.990499262618405929 },
	{ 0.99112546119154021351, 0.0033644853621718194027, 0.99050653823791257047 },
	{ 0.99113225810468741361, 0.0033618949156996517751, 0.9905138075631689798 },
	{ 0.99113905217588493812, 0.0033593084555861266356, 0.99052106843887066656 },
	{ 0.99114582959592878453, 0.0033567253714796817243, 0.99052831277785979847 },
	{ 0.99115261601865822794, 0.0033541506797072212498, 0.99053557420669258171 },
	{ 0.99115935548246436593, 0.0033515754157301702078, 0.99054278585372623755 },
	{ 0.99116610944212013568, 0.0033490053397414007615, 0.99055000726638486874 },
	{ 0.99117283940732991976, 0.0033464358359572210153, 0.99055719880996395688 },
	{ 0.99117957374036824714, 0.0033438760787245550531, 0.99056440551696467445 },
	{ 0.99118628110349682458, 0.0033413144904372014433, 0.99057157304702447842 },
	{ 0.99119299146116279786, 0.0033387636786696233381, 0.99057875947890916546 },
	{ 0.99119968343198772143, 0.0033362108069655217919, 0.99058591058669720475 },
	{ 0.99120638207853295487, 0.0033336659079787052222, 0.99059307531295459626 },
	{ 0.99121305207670173942, 0.0033311214286085876791, 0.99060020383773494945 },
	{ 0.99121971322477298028, 0.0033285818320509708186, 0.99060732931075745622 },
	{ 0.99122637975156757673, 0.0033260489875075139807, 0.99061445901809408454 },
	{ 0.99123302453458772554, 0.0033235169059035096426, 0.9906215639298984188 },
	{ 0.99123964856565449644, 0.0033209881812330988189, 0.99062864976821618512 },
	{ 0.99124627805173859407, 0.0033184645301100514775, 0.99063573701797202897 },
	{ 0.99125288800657251898, 0.0033159414893385668298, 0.99064280046401709257 },
	{ 0.99125949685514413989, 0.0033134278708693287729, 0.99064987302718843232 },
	{ 0.99126608834684315497, 0.0033109135276076099089, 0.990656917399747039 },
	{ 0.99127269664228379042, 0.0033084108000990646026, 0.99066399162231177922 },
	{ 0.99127926570356306168, 0.0033059060698744546954, 0.99067101936279045038 },
	{ 0.99128581756055766938, 0.0033034029036757240824, 0.99067802493987788814 },
	{ 0.99129237023771221704, 0.0033009051352736241448, 0.99068503114639039353 },
	{ 0.99129890847623758354, 0.0032984113913771396891, 0.9906920237916539973 },
	{ 0.99130545884550014257, 0.0032959223014113192551, 0.99069902658401254314 },
	{ 0.99131199159086147432, 0.0032934401541945225109, 0.99070601831374882629 },
	{ 0.99131851144254590213, 0.0032909570151564366061, 0.99071298326431023185 },
	{ 0.99132500174940008097, 0.0032884772139784579359, 0.99071992843566636378 },
	{ 0.99133150439679984522, 0.0032860013610121496276, 0.99072687717376461958 },
	{ 0.99133799502790320712, 0.0032835320311781651149, 0.99073382038055168852 },
	{ 0.99134445857465613994, 0.0032810636931654697628, 0.99074073360381831321 },
	{ 0.99135092425763948754, 0.0032785982543226963384, 0.99074764560638184374 },
	{ 0.99135740933835836408, 0.003276143515705752865, 0.99075458272872685139 },
	{ 0.99136385365903711975, 0.0032736883002516506576, 0.99076147718368312578 },
	{ 0.99137027656019061084, 0.00327123188316791021, 0.99076834342895303553 },
	{ 0.99137672141492705347, 0.0032687878829237692474, 0.99077524146972451025 },
	{ 0.99138313662946564442, 0.003266339800953553963, 0.99078209583221243939 },
	{ 0.99138954062879425244, 0.0032638973647352922947, 0.99078894287048158152 },
	{ 0.99139595204770902814, 0.0032614612799879779022, 0.99079579763351255384 },
	{ 0.99140233075559491827, 0.0032590242224928606292, 0.99080261808334169071 },
	{ 0.99140872611463426445, 0.0032565964156386121263, 0.99080945701537914694 },
	{ 0.99141508599698890958, 0.0032541684561964733836, 0.9908162629121384235 },
	{ 0.99142144513547769691, 0.0032517434149977428488, 0.99082305707870343969 },
	{ 0.99142779677808645644, 0.0032493258315321664302, 0.99082985732971051718 },
	{ 0.99143415152967329096, 0.0032469124251600961668, 0.99083665672241061362 },
	{ 0.99144046567380772483, 0.0032444944602247928478, 0.99084339925704789653 },
	{ 0.99144681230008924189, 0.0032420879584547737141, 0.99085018312393025042 },
	{ 0.99145311288297499619, 0.0032396829444166878875, 0.99085693231521443369 },
	{ 0.99145942216337035191, 0.003237280219196961295, 0.99086367174087364162 },
	{ 0.99146572274625599519, 0.003234882834553406538, 0.99087041040359324917 },
	{ 0.9914720292609958685, 0.0032324927169081430975, 0.99087716216979804251 },
	{ 0.99147829787671870605, 0.0032300986129042371688, 0.99088385925231736717 },
	{ 0.99148456855237798724, 0.0032277128249403705569, 0.99089057029662896969 },
	{ 0.99149082972944113656, 0.0032253261595961328981, 0.99089726001678257727 },
	{ 0.99149707698285916013, 0.0032229473143812886748, 0.99090394428191908016 },
	{ 0.99150331305921435288, 0.0032205708724257222329, 0.99091061866698992855 },
	{ 0.99150954284131875838, 0.0032181950026747454911, 0.99091727493224845968 },
	{ 0.99151576837003585485, 0.0032158250647780169985, 0.99092393201766715283 },
	{ 0.99152197450101742238, 0.0032134589606520403207, 0.99093057271896112237 },
	{ 0.99152819856107610175, 0.0032110996466871966591, 0.99093723318038695602 },
	{ 0.9915343850082197763, 0.003208735678791688542, 0.99094383878646596919 },
	{ 0.99154057399213735291, 0.0032063813811537486553, 0.99095046241698969691 },
	{ 0.9915467573112292099, 0.0032040292388197644767, 0.99095707389770248952 },
	{ 0.99155292773664427397, 0.0032016796141859748918, 0.9909636697381563053 },
	{ 0.99155908982694584974, 0.0031993354636427619696, 0.99097026300368973306 },
	{ 0.99156524064481710301, 0.0031969895774122932333, 0.9909768300813264208 },
	{ 0.99157136615217200681, 0.0031946496611830448725, 0.99098338645873706998 },
	{ 0.99157751113355641071, 0.0031923170882460325144, 0.99098996112762138821 },
	{ 0.99158362800062183062, 0.0031899842482802118031, 0.99099650142608330938 },
	{ 0.99158974883497252861, 0.0031876576644179074015, 0.99100305179534597944 },
	{ 0.99159586694181467426, 0.0031853338843580926605, 0.99100959497390428421 },
	{ 0.99160196877897288648, 0.0031830122596022331939, 0.9910161185639921877 },
	{ 0.99160804070890462558, 0.0031806921607252795943, 0.99102261224685350705 },
	{ 0.99161410691679041651, 0.003178375342487974823, 0.99102910356460249819 },
	{ 0.99162021871030847642, 0.003176070235371275443, 0.99103564115462927653 },
	{ 0.99162625111997659832, 0.0031737554770704941125, 0.99104208372054714005 },
	{ 0.99163231112897942676, 0.0031714518767592147531, 0.99104856605468405473 },
	{ 0.99163835429609370475, 0.0031691504698988623608, 0.9910550299066128721 },
	{ 0.99164438657224751594, 0.0031668529349562352104, 0.99106148717818887128 },
	{ 0.99165041114271279543, 0.0031645551711317722668, 0.99106792289672540619 },
	{ 0.99165644341886627355, 0.0031622666007277188197, 0.99107437520919483553 },
	{ 0.99166244473875164722, 0.0031599784308668781192, 0.99108079866347953413 },
	{ 0.99166845273435733077, 0.003157692969441096547, 0.99108721925674136966 },
	{ 0.99167444493711609521, 0.0031554091101881663953, 0.99109361993728339879 },
	{ 0.99168042640150222411, 0.0031531319838759104199, 0.99110002407012642855 },
	{ 0.99168641076505836818, 0.0031508581382033024054, 0.99110642290054007386 },
	{ 0.9916923614066904813, 0.0031485854369398737912, 0.99111279151855147251 },
	{ 0.99169833310545163485, 0.003146316855549492926, 0.99111917005477578879 },
	{ 0.99170428899229268183, 0.0031440532904860158357, 0.99112554601607960603 },
	{ 0.99171022111356965656, 0.0031417899161574019788, 0.99113188920913375402 },
	{ 0.99171616538465745538, 0.0031395330077406535113, 0.9911382469934048034 },
	{ 0.99172208705366404757, 0.0031372768050428995711, 0.99114457607207917533 },
	{ 0.99172797723234451528, 0.0031350198203322059837, 0.99115087205825458394 },
	{ 0.99173389380873000487, 0.0031327746611830359011, 0.99115721137939105656 },
	{ 0.99173979794920241737, 0.0031305260688063267505, 0.99116351282058368088 },
	{ 0.99174569323957717515, 0.0031282852965590123365, 0.99116982227264049943 },
	{ 0.9917515700477437246, 0.0031260448104139925557, 0.99117610610900541701 },
	{ 0.99175744758070272233, 0.0031238098555800082774, 0.9911823937982143784 },
	{ 0.99176330478132546098, 0.0031215748625990510055, 0.99118865741668371605 },
	{ 0.99176917819441157143, 0.0031193489104506134241, 0.99119494220672266227 },
	{ 0.99177502635420167199, 0.0031171208983656524018, 0.99120119121490146696 },
	{ 0.99178085090101597565, 0.0031148954421278589669, 0.99120742294250152593 },
	{ 0.99178669055403134713, 0.0031126781493422137417, 0.9912136711495939112 },
	{ 0.99179250157774356822, 0.0031104572516676529288, 0.99121988046584752485 },
	{ 0.99179833001554884575, 0.0031082450705763437458, 0.99122611333785692889 },
	{ 0.99180414752424650437, 0.0031060349684950442836, 0.99123233173309011068 },
	{ 0.99180992864073214133, 0.0031038239508864016482, 0.99123851434646303993 },
	{ 0.99181572278440899293, 0.0031016215735670655228, 0.99124471696792315623 },
	{ 0.99182150430143767306, 0.0030994222861525149923, 0.99125090688644112991 },
	{ 0.99182728526533547875, 0.0030972236281630130018, 0.99125708427367875686 },
	{ 0.99183305476606786755, 0.0030950292617079352801, 0.99126325569091489065 },
	{ 0.99183882071913187506, 0.0030928362303969006257, 0.99126941562591230905 },
	{ 0.99184455981672725589, 0.0030906457930800061186, 0.99127555320678384376 },
	{ 0.99185030364454707108, 0.0030884590178724873402, 0.99128169406829480526 },
	{ 0.99185602675856077148, 0.0030862747222181905957, 0.99128781543670296816 },
	{ 0.99186177241743544997, 0.0030841003066298115949, 0.9912939655297815511 },
	{ 0.99186747571409694668, 0.0030819200736281033258, 0.9913000594895897688 },
	{ 0.99187320201338302628, 0.0030797499114271760338, 0.9913061864846763882 },
	{ 0.99187889010847596349, 0.0030775768309828405341, 0.99131227024016943528 },
	{ 0.991884582323441788, 0.0030754093962904582166, 0.99131835597930517689 },
	{ 0.99189026839674487857, 0.0030732425338026655992, 0.99132442924438080034 },
	{ 0.99189595920027273657, 0.0030710843688246391991, 0.99133052112517905385 },
	{ 0.99190162946165583158, 0.0030689277487990045123, 0.99133658929763379675 },
	{ 0.99190726926268135699, 0.0030667687827345517515, 0.99134262216506541243 },
	{ 0.99191294234694049603, 0.0030646188765761049611, 0.99134868606505932576 },
	{ 0.99191857900084057231, 0.003062469161152521404, 0.99135471723495061092 },
	{ 0.99192424436033765911, 0.003060325835346857249, 0.99136077138839295841 },
	{ 0.99192985093534991048, 0.0030581804114576970934, 0.99136677072463563754 },
	{ 0.99193548911512896549, 0.003056041949391047341, 0.99137280082641177081 },
	{ 0.99194107928694297271, 0.0030539000350233713732, 0.99137877681670705243 },
	{ 0.99194671208799911621, 0.0030517702704664865371, 0.99138480398116635151 },
	{ 0.9919522954887254329, 0.0030496365767714180527, 0.99139077243743478629 },
	{ 0.99195789067686646057, 0.0030475074225660954766, 0.9913967530244404136 },
	{ 0.99196347169340703953, 0.0030453829032179515098, 0.99140272420821728971 },
	{ 0.99196904633940319318, 0.0030432597953077957301, 0.99140868520675251574 },
	{ 0.9919746187728749609, 0.0030411419516798662323, 0.99141464582381799708 },
	{ 0.99198017388762116386, 0.0030390231162306480077, 0.99142058301864222081 },
	{ 0.99198572900236736682, 0.0030369109946486172458, 0.9914265299790915309 },
	{ 0.9919912730926384592, 0.0030348005896803555842, 0.99143245401321022925 },
	{ 0.99199680873335505105, 0.0030326936751600918306, 0.99143838176665877171 },
	{ 0.99200235392988822536, 0.0030305899459120450717, 0.99144430812774275719 },
	{ 0.99200785632551824467, 0.0030284849196669278056, 0.99145019123015987184 },
	{ 0.99201338759840651527, 0.0030263873320814788093, 0.99145610305724740652 },
	{ 0.99201889466704062936, 0.0030242937690016448611, 0.99146199937759038612 },
	{ 0.99202439130247799248, 0.0030222008353468598867, 0.99146787977157235794 },
	{ 0.99202988795698843205, 0.0030201115065809909337, 0.99147375690398820147 },
	{ 0.99203537146986697781, 0.0030180227690931979607, 0.99147961921630511917 },
	{ 0.99204086360396115385, 0.0030159425002333345445, 0.9914854957955897552 },
	{ 0.99204632106245749235, 0.0030138566237684909395, 0.99149132617889057517 },
	{ 0.99205178016127359975, 0.0030117781096693704845, 0.99149716659484510295 },
	{ 0.99205721822203407623, 0.0030096996527907084358, 0.99150297944961185426 },
	{ 0.9920626767677188651, 0.0030076291686293322308, 0.99150882141051865926 },
	{ 0.99206811118544335759, 0.0030055580931898796121, 0.99151462753234476111 },
	{ 0.99207355342329750503, 0.0030034936171766963425, 0.99152045604644378773 },
	{ 0.99207898150862483533, 0.003001428263783142026, 0.99152625888763024076 },
	{ 0.99208439485014698889, 0.0029993670111891478774, 0.99153204816756812523 },
	{ 0.9920898051208378865, 0.0029973075705763555301, 0.99153783311782450749 },
	{ 0.99209519137800961097, 0.0029952483016249397026, 0.99154358753142946004 },
	{ 0.99210058997572680983, 0.002993195727467224624, 0.99154936225829726215 },
	{ 0.9921059886115911608, 0.0029911489897963263948, 0.99155513961730612493 },
	{ 0.9921113681739692769, 0.0029891002684828498447, 0.99156089073119768607 },
	{ 0.99211674722136289351, 0.0029870575171705945373, 0.99156664747176770369 },
	{ 0.99212210568846503911, 0.0029850163108107318106, 0.99157238191543206618 },
	{ 0.99212746983946598078, 0.0029829778128859269111, 0.99157811700759512785 },
	{ 0.99213283669890195426, 0.0029809418708082909, 0.99158385305343255123 },
	{ 0.99213817132414616751, 0.0029789071112868072827, 0.99158955907760248927 },
	{ 0.99214349130095291773, 0.0029768744879957917925, 0.99159524923263175911 },
	{ 0.99214882314146823905, 0.002974846938252138917, 0.99160094957290267903 },
	{ 0.99215413545073316559, 0.0029728200751539942889, 0.99160662984786607232 },
	{ 0.99215945344389722127, 0.0029707992011305567499, 0.99161232137618637861 },
	{ 0.99216475758971023335, 0.0029687796622511618445, 0.9916179983705102341 },
	{ 0.99217006455839917844, 0.0029667623358961819208, 0.99162366887984865205 },
	{ 0.99217536492766189582, 0.0029647506934401273056, 0.99162934171615246814 },
	{ 0.99218064582289522413, 0.0029627373152968168764, 0.99163498504577285431 },
	{ 0.99218593255461529079, 0.0029607295066115136423, 0.99164063726363793627 },
	{ 0.99219119920195408824, 0.0029587216788527245619, 0.99164626829085966708 },
	{ 0.99219645541609591266, 0.002956717150807070156, 0.99165188983855856453 },
	{ 0.99220171679915258878, 0.0029547190123793355861, 0.99165752262054107646 },
	{ 0.99220697637022792215, 0.0029527217322584857831, 0.991663145884853936 },
	{ 0.99221221206129861514, 0.0029507248717543354405, 0.99166874092040668831 },
	{ 0.99221746283949685541, 0.0029487348967787490803, 0.99167435958800920215 },
	{ 0.9922226978629954397, 0.0029467452651259170605, 0.99167995532928121527 },
	{ 0.99222788665236316685, 0.002944753344654725373, 0.99168550567565572074 },
	{ 0.99223312549055908693, 0.0029427745467421276976, 0.99169111492095596283 },
	{ 0.99223831561507092047, 0.0029407869368788461251, 0.99169665538726470277 },
	{ 0.99224352233351575947, 0.00293880920708148273, 0.99170222816405928512 },
	{ 0.99224871938170311481, 0.0029368356925245980502, 0.99170779424606014807 },
	{ 0.99225391581953881204, 0.0029348629409071663038, 0.99171334949432077277 },
	{ 0.99225909633101350149, 0.0029328901320692757175, 0.99171888248382278341 },
	{ 0.99226425853194133442, 0.0029309222060438853801, 0.99172441272674272117 },
	{ 0.99226942355574498933, 0.0029289538985487677085, 0.99172992977081020349 },
	{ 0.99227460147322543715, 0.0029269943648573613741, 0.99173547023711883242 },
	{ 0.99227972522200469374, 0.002925030100941345898, 0.99174095104156223535 },
	{ 0.99228489032210243082, 0.0029230723983046272112, 0.9917464707559177084 },
	{ 0.99229001698912522311, 0.002921115363239930058, 0.99175195165572871403 },
	{ 0.99229515967787651487, 0.0029191644698378302336, 0.99175745399413817172 },
	{ 0.99230028811873349781, 0.0029172164183851930636, 0.99176294284759280995 },
	{ 0.99230541970671559682, 0.0029152684622999881607, 0.99176842157302624869 },
	{ 0.99231051957548976894, 0.0029133233481642459121, 0.99177388246474995626 },
	{ 0.99231563310088044538, 0.0029113836508986210526, 0.99177935731826560861 },
	{ 0.99232071448744663122, 0.0029094409972426154253, 0.99178478752074983316 },
	{ 0.99232581149519816233, 0.0029075039321181037066, 0.99179023731170434797 },
	{ 0.99233090228499332142, 0.0029055707961317756363, 0.99179568088470249076 },
	{ 0.99233596286238590078, 0.0029036355239149785716, 0.99180109424529816486 },
	{ 0.99234106379927555786, 0.0029017114669081427517, 0.99180655010162144247 },
	{ 0.99234611590804022718, 0.0028997805434462287956, 0.9918119488900736247 },
	{ 0.99235115935744200311, 0.0028978562957045293086, 0.9918173471063211899 },
	{ 0.9923562050956621361, 0.0028959331160780645356, 0.99182274433074757436 },
	{ 0.99236126254500300892, 0.0028940147048231823317, 0.99182814922271544944 },
	{ 0.99236629596175118806, 0.0028920980483290422217, 0.99183353481231506521 },
	{ 0.99237133983076986077, 0.0028901866561171279599, 0.9918389285653669285 },
	{ 0.99237634967268861796, 0.0028882722121474010968, 0.99184428798614343581 },
	{ 0.99238136947096733387, 0.0028863620787855843487, 0.99184965064941243984 },
	{ 0.99238637729109679952, 0.0028844556838270880156, 0.99185501201568448959 },
	{ 0.99239138331831866502, 0.0028825539046522831443, 0.99186037082610944982 },
	{ 0.99239638743819191813, 0.0028806509810682988729, 0.99186571552215452297 },
	{ 0.99240137267531369769, 0.0028787519103285531298, 0.9918710480493153625 },
	{ 0.99240636565627082799, 0.0028768589049574591621, 0.99187639625488188688 },
	{ 0.99241132955016142514, 0.0028749621039625859395, 0.99188170312820367336 },
	{ 0.99241631223143589313, 0.0028730694800612188722, 0.99188702470718326243 },
	{ 0.99242128915251759391, 0.0028711839896437382942, 0.99189235334335279504 },
	{ 0.99242622014464398905, 0.0028692924720045780672, 0.99189762628494204666 },
	{ 0.99243119752348929463, 0.0028674134665724491586, 0.99190295064865063868 },
	{ 0.99243613755644843888, 0.0028655297690626832345, 0.99190823125778160296 },
	{ 0.99244108226241156689, 0.0028636526137587282534, 0.99191352226196249919 },
	{ 0.99244600581587838484, 0.0028617750197645875319, 0.99191879157958950941 },
	{ 0.99245094047011428451, 0.0028599006682631230788, 0.99192406314788805766 },
	{ 0.99245586196364454779, 0.0028580281859633183995, 0.99192932338653549973 },
	{ 0.99246077542723698528, 0.0028561605674025276891, 0.99193458387313826474 },
	{ 0.99246566865386043332, 0.0028542907935377812706, 0.99193981668411235209 },
	{ 0.99247058370055241117, 0.0028524276572462776286, 0.99194506986556996164 },
	{ 0.99247546910704653733, 0.0028505625754591686592, 0.99195029218612673638 },
	{ 0.99248037351073303824, 0.0028487071830031142003, 0.99195554342208858145 },
	{ 0.99248525433959033926, 0.0028468488150831926936, 0.99196075506149272716 },
	{ 0.99249014123381629204, 0.002844995597004579789, 0.99196598436294536327 },
	{ 0.99249500680388447194, 0.0028431436377760639644, 0.99197118806777939692 },
	{ 0.99249985606612201039, 0.002841290515064882026, 0.99197637103973379524 },
	{ 0.99250470511855137801, 0.0028394425612684954033, 0.99198155822692868355 },
	{ 0.99250955403746621286, 0.0028375972968336816288, 0.99198674734054570479 },
	{ 0.9925144128364471463, 0.0028357567244765044361, 0.99199194259582545996 },
	{ 0.99251923566283273281, 0.0028339153128859283226, 0.99199710393844642287 },
	{ 0.99252407712401446993, 0.0028320764762160069439, 0.99200227498947191052 },
	{ 0.99252891217650485167, 0.0028302413016554599928, 0.99200744543014585108 },
	{ 0.99253371985854221826, 0.0028284072905775791557, 0.99201258701263494988 },
	{ 0.99253852509917350755, 0.002826577742695499107, 0.99201773385940628103 },
	{ 0.99254335530699822066, 0.0028247524482008698997, 0.9920228980058296564 },
	{ 0.99254815160216436354, 0.0028229273444411043595, 0.99202803213058554643 },
	{ 0.99255294919432757172, 0.0028211030799147368726, 0.99203316236435035158 },
	{ 0.99255773648680822863, 0.0028192790442702056128, 0.99203827314315917718 },
	{ 0.99256250668944512316, 0.0028174605017897368618, 0.99204338209091325052 },
	{ 0.99256728703917662671, 0.0028156437140700102048, 0.99204849264084005167 },
	{ 0.99257206181945023538, 0.0028138291388746976621, 0.99205359456955122255 },
	{ 0.99257683972777566161, 0.0028120207434889558755, 0.99205871259628464198 },
	{ 0.99258158032836163454, 0.0028102073889967682865, 0.99206377790390187776 },
	{ 0.99258632119597667298, 0.0028083994895216706465, 0.99206884843765430482 },
	{ 0.99259106286467801983, 0.0028065957480665924481, 0.99207392702041796717 },
	{ 0.99259581494750293018, 0.0028047954779860263114, 0.9920790118211383346 },
	{ 0.99260056310118960354, 0.0028029933387037999672, 0.99208407689987376799 },
	{ 0.9926052766364985569, 0.0028011946135756268447, 0.99208912216125688666 },
	{ 0.99260999654235193557, 0.0027993972617384689158, 0.99209416662155358591 },
	{ 0.992614716581719847, 0.002797605918049504356, 0.99209921876846529631 },
	{ 0.99261942212523790463, 0.0027958146506544844824, 0.99210425123153911375 },
	{ 0.99262412057341908866, 0.0027940259772536060572, 0.99210928033767931122 },
	{ 0.99262882111968375742, 0.0027922389441725516124, 0.99211430177627790705 },
	{ 0.99263352151336059492, 0.0027904567939039974164, 0.99211933664261087173 },
	{ 0.99263820060195318007, 0.0027886740905043393667, 0.99212433898864982318 },
	{ 0.99264288224639296576, 0.0027868938666579037844, 0.99212934431015242787 },
	{ 0.99264754479827288502, 0.002785114157795599496, 0.99213432760177844294 },
	{ 0.99265222260894192541, 0.0027833411628004826703, 0.99213933561264289196 },
	{ 0.99265688111724270648, 0.0027815683966872016379, 0.99214431882797493589 },
	{ 0.99266154427947428385, 0.0027797981482741165003, 0.99214930257736466679 },
	{ 0.99266618087233926548, 0.002778025591969185415, 0.99215425376831323234 },
	{ 0.99267083289565472004, 0.0027762625151869593267, 0.99215923538147243743 },
	{ 0.99267548438491259866, 0.0027745004302260223988, 0.99216421035705870679 },
	{ 0.99268008744658864373, 0.0027727352744337861561, 0.99216913659988714702 },
	{ 0.99268472703399102119, 0.0027709783774611295229, 0.99217409723221161588 },
	{ 0.99268936219634462681, 0.0027692225486037076038, 0.99217905343948720187 },
	{ 0.99269395841063923225, 0.0027674676734206022852, 0.99218397985397710492 },
	{ 0.99269856347503149241, 0.0027657113486525357858, 0.99218889635025409035 },
	{ 0.99270317075194802747, 0.0027639610511061493692, 0.99219382162033475936 },
	{ 0.99270776799621063269, 0.0027622110968825164257, 0.99219873365341604288 },
	{ 0.99271235270919289118, 0.0027604668074843229444, 0.99220364425598572833 },
	{ 0.99271693480910749852, 0.0027587216216322717026, 0.9922085435861252023 },
	{ 0.9927215407508799272, 0.0027569843322035607509, 0.99221347072540755363 },
	{ 0.9927261107963510911, 0.0027552428847548303577, 0.99221835296570304319 },
	{ 0.992730666765589298, 0.0027535067397352988063, 0.99222323547302726521 },
	{ 0.99273522675933334458, 0.0027517700415846642684, 0.99222810789047743985 },
	{ 0.99273981389464827085, 0.0027500395804640588929, 0.99223300897537758392 },
	{ 0.99274433965148423109, 0.0027483067923781217233, 0.9922378557771354135 },
	{ 0.99274888097228508599, 0.0027465749198195281607, 0.99224270349442078576 },
	{ 0.99275344071807380963, 0.0027448546057936488822, 0.9922475916093502768 },
	{ 0.99275796472014887772, 0.0027431281501051722749, 0.99225242536484359324 },
	{ 0.99276249089660162372, 0.0027414052420851532828, 0.99225726709305417383 },
	{ 0.99276700829925057512, 0.0027396855384108371317, 0.99226210088669419829 },
	{ 0.99277152913512711763, 0.0027379666739699194677, 0.99226692979752195711 },
	{ 0.99277604476394187838, 0.0027362547332045383461, 0.99227177024780865988 },
	{ 0.99278054744185917357, 0.0027345402175185033571, 0.99227658351837766393 },
	{ 0.99278505076827516795, 0.0027328258925673316014, 0.99228138652741071368 },
	{ 0.99278953551711557335, 0.0027311164885756322208, 0.9922861882012998791 },
	{ 0.9927940177101087782, 0.0027294089537855930477, 0.99229098457275999312 },
	{ 0.99279852191390527416, 0.002727707255482370724, 0.99229580295502306519 },
	{ 0.99280300166549229068, 0.0027260032302138157388, 0.99230058727203962476 },
	{ 0.99280745864333663775, 0.0027243008452650851678, 0.9923053578179992229 },
	{ 0.99281193690719160561, 0.0027226044875380342458, 0.99231014835297259857 },
	{ 0.99281639592589909782, 0.0027209075766798799037, 0.99231491483627942696 },
	{ 0.99282085069121905896, 0.0027192139655348606699, 0.99231968591629649001 },
	{ 0.99282530373992528006, 0.0027175222998854467633, 0.99232444749771731018 },
	{ 0.99282972587051010471, 0.0027158314162489720703, 0.99232918353974008951 },
	{ 0.9928341835922204206, 0.0027141433173415007579, 0.99233394246994655052 },
	{ 0.99283862668456668299, 0.0027124615317580045952, 0.9923387034791628647 },
	{ 0.99284303672256102313, 0.0027107737761732876233, 0.99234341644226697898 },
	{ 0.99284746613921759373, 0.0027090900260206998533, 0.99234814420639672061 },
	{ 0.99285189340057011798, 0.0027074130088087853922, 0.99235288228928253407 },
	{ 0.9928562939018213962, 0.0027057335311171347436, 0.99235758663117090705 },
	{ 0.99286070041122087559, 0.0027040594130751426441, 0.9923623057931583169 },
	{ 0.99286512214126243503, 0.002702388079762154359, 0.99236703086792643624 },
	{ 0.9928695042747462951, 0.0027007156020399862399, 0.99237171932160084253 },
	{ 0.9928738864082302662, 0.0026990467101332474287, 0.99237641349732108598 },
	{ 0.99287828177871373381, 0.0026973799163100050519, 0.99238111068665235681 },
	{ 0.99288264464797648667, 0.0026957125121351999814, 0.99238577629029023353 },
	{ 0.99288702952804264168, 0.0026940510207411568801, 0.99239046558319810032 },
	{ 0.99289139977874474319, 0.0026923913031813425864, 0.9923951424974132296 },
	{ 0.99289573508681983061, 0.0026907250243422306361, 0.99239976921021233469 },
	{ 0.99290011985244486237, 0.0026890746337172302324, 0.99240446647583746564 },
	{ 0.99290446994247172352, 0.0026874188643690854333, 0.9924091196817090843 },
	{ 0.99290881871642822087, 0.0026857649451491149954, 0.99241376630722799579 },
	{ 0.99291315999450446839, 0.0026841159278151306526, 0.99241841398178853861 },
	{ 0.99291750062408223876, 0.0026824674826857360099, 0.99242305665909591461 },
	{ 0.99292181886138697333, 0.0026808189231154232537, 0.9924276739686662685 },
	{ 0.99292614835204873192, 0.0026791758185622000128, 0.99243231054245795164 },
	{ 0.99293047284545710163, 0.0026775316840407154852, 0.99243692769944047427 },
	{ 0.99293478318633854318, 0.0026758891898390553717, 0.99244153619706021452 },
	{ 0.99293909888686959775, 0.0026742549544569753014, 0.99244616317688816309 },
	{ 0.99294342042388739067, 0.0026726187354323169103, 0.99245077722489238869 },
	{ 0.99294771989288166392, 0.0026709840613600515334, 0.9924553760713280548 },
	{ 0.99295200906219327486, 0.0026693508368727469036, 0.99245996828019034108 },
	{ 0.9929562902969345517, 0.0026677195960280201611, 0.99246454767167002764 },
	{ 0.99296055692138518456, 0.002666085341572453811, 0.99246909971177021959 },
	{ 0.99296485089721531203, 0.0026644631797072197525, 0.99247369825303000113 },
	{ 0.99296914037170269651, 0.0026628400260206960999, 0.99247828466355247912 },
	{ 0.99297339620056024323, 0.002661216643452336654, 0.99248283864914832453 },
	{ 0.992977643350981376, 0.0026595936614271899548, 0.99248738376557277263 },
	{ 0.99298191993179196757, 0.0026579776030775806653, 0.99249195850312155187 },
	{ 0.99298617896499508095, 0.0026563626128432056561, 0.99249651538788730143 },
	{ 0.99299041797103759777, 0.0026547433882948660855, 0.99250104118287019173 },
	{ 0.99299465691985966398, 0.0026531325370070246716, 0.99250558168351110666 },
	{ 0.9929988922256457462, 0.0026515193015333921901, 0.9925101027864162706 },
	{ 0.99300312926711920003, 0.0026499127990004330176, 0.99251464023529933911 },
	{ 0.99300735507430926141, 0.0026483040267226008908, 0.99251915603577545166 },
	{ 0.9930115530151358838, 0.0026466951972243094905, 0.99252364747940957646 },
	{ 0.99301579722824018237, 0.0026450956374403735739, 0.99252818481385174376 },
	{ 0.99301999879302904617, 0.0026434947425123954574, 0.99253268217026657805 },
	{ 0.99302421321334777282, 0.0026418971663710374281, 0.99253719165741882691 },
	{ 0.99302841895523008553, 0.0026402973204848064447, 0.99254168098389605746 },
	{ 0.9930326097434992727, 0.0026387009841200600828, 0.99254616466462131097 },
	{ 0.99303679658355681337, 0.0026371071082350499085, 0.99255064065873155332 },
	{ 0.99304097428741433529, 0.0026355151587721587815, 0.99255511255204220689 },
	{ 0.99304516267242437522, 0.0026339265662428616027, 0.99255959695755990868 },
	{ 0.99304933839263931361, 0.0026323387366530177911, 0.99256405954300930272 },
	{ 0.99305350213470489074, 0.0026307517462965724665, 0.99256851594864903277 },
	{ 0.9930576764434817516, 0.0026291681510206932164, 0.99257297674119071562 },
	{ 0.99306184373321571002, 0.002627587760090517241, 0.99257743349015326029 },
	{ 0.99306601159515428545, 0.0026260087043043843329, 0.99258189157425980031 },
	{ 0.99307016663970992809, 0.0026244327002760644597, 0.99258633851945021753 },
	{ 0.9930743065017706428, 0.0026228550940748922987, 0.99259076768815146519 },
	{ 0.99307843049469080032, 0.0026212793189284077852, 0.99259518159806381377 },
	{ 0.99308257153930756811, 0.002619704039692567852, 0.99259959707200184909 },
	{ 0.99308671634140133211, 0.0026181372481581437553, 0.99260403667390006976 },
	{ 0.99309081935348630932, 0.0026165650588270889833, 0.99260842563569229302 },
	{ 0.99309496371688954497, 0.0026150003463026750411, 0.99261285610139082802 },
	{ 0.99309906348648202545, 0.0026134352904555071921, 0.99261724769532411194 },
	{ 0.99310318902435457122, 0.0026118725425001848572, 0.99262165391862144936 },
	{ 0.9931072919982927294, 0.0026103102332350482627, 0.99262604078233007687 },
	{ 0.99311139390411562466, 0.0026087502127882704686, 0.99263042772233267552 },
	{ 0.99311549130859566592, 0.0026071908789870004881, 0.99263480398118297821 },
	{ 0.99311959012451367368, 0.0026056353980299699034, 0.99263918661057748416 },
	{ 0.99312367715301708149, 0.0026040851432081934744, 0.99264357103287981232 },
	{ 0.99312775872650349562, 0.0026025325614210839502, 0.99264793184220601052 },
	{ 0.9931318325180072959, 0.0026009819632765531806, 0.99265229188859283038 },
	{ 0.99313591809692580714, 0.0025994338446852453123, 0.99265665662705715455 },
	{ 0.99313997704925727206, 0.0025978876334425702113, 0.99266100259721090637 },
	{ 0.99314402453842365315, 0.0025963410216566823636, 0.99266533016145042101 },
	{ 0.99314809106292922802, 0.0025948015815016535653, 0.99266968786179821116 },
	{ 0.99315214536133022971, 0.0025932565909621029844, 0.99267400888383194868 },
	{ 0.99315619721832493205, 0.0025917214423414984548, 0.99267835691392236619 },
	{ 0.9931602581924461326, 0.0025901842719313430442, 0.99268269193589508959 },
	{ 0.99316428445282212145, 0.0025886485511061483808, 0.99268700307786283954 },
	{ 0.99316831288757556617, 0.0025871122580763640172, 0.99269130884110756696 },
	{ 0.99317234284820776757, 0.0025855816107985324023, 0.99269562101304364976 },
	{ 0.99317638024749976822, 0.0025840524512526345281, 0.99269993291795088908 },
	{ 0.99318038548889386874, 0.0025825211936232402195, 0.99270421647965745304 },
	{ 0.99318440785827866168, 0.0025809960776564441071, 0.99270851961076100878 },
	{ 0.99318842889251945927, 0.0025794751960036121224, 0.99271282751023626201 },
	{ 0.99319241265716795564, 0.002577947486042675429, 0.99271708471238462312 },
	{ 0.99319642365875482337, 0.002576427939533886078, 0.99272137571275087531 },
	{ 0.9932004380744958727, 0.00257491424858540029, 0.99272567546784740156 },
	{ 0.99320440856399783147, 0.0025733891326186041776, 0.9927299099344001343 },
	{ 0.99320839477005251617, 0.0025718748503920419758, 0.99273417690217358178 },
	{ 0.99321240081253303611, 0.0025703639250990732885, 0.99273845882356026582 },
	{ 0.99321637660446426832, 0.0025688517409560066539, 0.99274271263062829895 },
	{ 0.9932203428215052865, 0.00256734035789936638, 0.99274695228516929291 },
	{ 0.99322430253448756865, 0.0025658289557692398261, 0.99275118497788794603 },
	{ 0.99322826468887603912, 0.002564323351978957128, 0.99275542663514504405 },
	{ 0.99323224379959385022, 0.0025628198271986841507, 0.99275967842042334155 },
	{ 0.99323618777694977489, 0.0025613162642714381798, 0.99276389980256452006 },
	{ 0.99324012935104655231, 0.0025598138076063994828, 0.99276811756074334614 },
	{ 0.99324406907501516795, 0.0025583146125075224668, 0.99277233407914555752 },
	{ 0.99324803157272634202, 0.0025568203765150912532, 0.9927765744012587712 },
	{ 0.99325197276535326374, 0.0025553227263686076852, 0.99278078201234276623 },
	{ 0.99325590215149228701, 0.0025538301688429734457, 0.99278499414384324684 },
	{ 0.99325983369293524561, 0.0025523386603590867729, 0.99278919866502257641 },
	{ 0.99326375003280964471, 0.0025508448439833545859, 0.99279338115632509432 },
	{ 0.99326766950073563933, 0.0025493553000685603878, 0.99279757306992999499 },
	{ 0.9932715894836459114, 0.002547869399189654771, 0.99280176343858217436 },
	{ 0.99327549634399747713, 0.0025463819724318428536, 0.99280594007432443338 },
	{ 0.99327939420166366791, 0.0025449001914259836848, 0.99281011899888516048 },
	{ 0.99328328242721908303, 0.0025434135848280835408, 0.99281427356660367778 },
	{ 0.99328720347824450698, 0.0025419391280409745285, 0.99281847171723835999 },
	{ 0.99329108416977274221, 0.0025404587966200765405, 0.99282262355744843596 },
	{ 0.99329495404663437075, 0.0025389787513014736194, 0.99282676073014741736 },
	{ 0.99329883281174058407, 0.0025375025588271092267, 0.99283090843141086346 },
	{ 0.99330273642959943103, 0.0025360334807631450434, 0.99283508151948463016 },
	{ 0.99330659945907950892, 0.0025345590621230085909, 0.99283921317994605626 },
	{ 0.99331045304718379452, 0.0025330868369337999728, 0.99284333620011833155 },
	{ 0.99331431621017829414, 0.0025316165190932245557, 0.99284746398866197126 },
	{ 0.99331818980636965577, 0.0025301519805190062808, 0.99285160491883772682 },
	{ 0.99332203074875236037, 0.0025286865264174443989, 0.99285571929872051822 },
	{ 0.99332588916244857202, 0.0025272249633070931717, 0.99285984794557113897 },
	{ 0.99332973872604712895, 0.0025257611113783822766, 0.99286395782411107636 },
	{ 0.99333358508530011921, 0.0025243027526137347578, 0.9928680748742819695 },
	{ 0.99333742064895991231, 0.0025228445845839496051, 0.99287217685639861386 },
	{ 0.99334124381485344735, 0.0025213882094618799735, 0.99287627223908903051 },
	{ 0.99334506942215328174, 0.0025199296981093417813, 0.99288035373628136249 },
	{ 0.99334890017929444728, 0.0025184789305922527722, 0.99288445907533173784 },
	{ 0.99335271655502688226, 0.0025170267516371751422, 0.99288854278504856676 },
	{ 0.99335653294983283779, 0.0025155780631300954202, 0.99289262445390213951 },
	{ 0.99336034459534061636, 0.0025141272574660338511, 0.99289669122636314835 },
	{ 0.99336417764130013897, 0.0025126877814528503392, 0.99290080373704436845 },
	{ 0.99336795190277471512, 0.0025112356024977727093, 0.99290483190476896969 },
	{ 0.99337175515594855479, 0.0025097950202223823571, 0.99290890249192720329 },
	{ 0.99337555528107068792, 0.0025083543616530464514, 0.99291297010362178366 },
	{ 0.99337932864609157502, 0.0025069104033705763047, 0.99291700073182609376 },
	{ 0.993383118261722875, 0.0025054715567824422003, 0.9929210495942835113 },
	{ 0.99338690223160208692, 0.002504037325977999124, 0.99292510028779545905 },
	{ 0.99339067960205507113, 0.0025026025229689663476, 0.99292914285600220037 },
	{ 0.99339445540848225757, 0.0025011698943373751255, 0.99293318138062991451 },
	{ 0.99339822585525971999, 0.0024997377043959692101, 0.99293721061646988968 },
	{ 0.99340197673264030165, 0.0024983067733046608085, 0.99294122676789819959 },
	{ 0.99340573085251338004, 0.0024968771773573954741, 0.99294524272859152614 },
	{ 0.99340950988235954267, 0.0024954536467787823487, 0.99294928039491237026 },
	{ 0.99341323853912832931, 0.0024940254431960189214, 0.99295327245652742487 },
	{ 0.99341698277893553115, 0.0024926023703810778163, 0.99295727769792152539 },
	{ 0.99342072160187266938, 0.0024911776190993401708, 0.99296127180039972515 },
	{ 0.99342447665634658893, 0.0024897638350722408294, 0.99296529914796438643 },
	{ 0.99342820949020893551, 0.0024883413344618898581, 0.99296927673280332982 },
	{ 0.99343194133224999032, 0.0024869233351943126689, 0.99297326858460988053 },
	{ 0.99343567479553729349, 0.0024855101233718034613, 0.99297726346910097917 },
	{ 0.99343939698639438518, 0.002484100401997291728, 0.99298125474870313489 },
	{ 0.99344309741440328665, 0.002482683299183571432, 0.99298520854890459653 },
	{ 0.99344681605759177501, 0.0024812745314833767329, 0.9929891861337434289 },
	{ 0.99345052583160919912, 0.0024798661643263947806, 0.99299315767228701901 },
	{ 0.99345422809067296388, 0.0024784577590224402682, 0.99299711433351123269 },
	{ 0.99345792685928890897, 0.0024770497161147263764, 0.99300106594026171791 },
	{ 0.99346163230362483088, 0.0024756477385756642598, 0.99300503139436324673 },
	{ 0.99346531661453796325, 0.0024742430907485160087, 0.99300896533906524155 },
	{ 0.99346898633423363911, 0.0024728416281935843186, 0.99301290082871984666 },
	{ 0.99347268542709865624, 0.0024714425688979308436, 0.99301685050904819896 },
	{ 0.99347636332932021119, 0.0024700432616469548616, 0.99302078277528349481 },
	{ 0.9934800389427235201, 0.0024686467009780097004, 0.99302471137940928614 },
	{ 0.99348369100037114965, 0.0024672526007888007267, 0.99302863073289449058 },
	{ 0.99348737561645994454, 0.0024658616858718087478, 0.99303256940782125284 },
	{ 0.99349102635803698824, 0.002464467871784894841, 0.99303647390306037934 },
	{ 0.99349469338837137489, 0.0024630774527785474423, 0.99304039079606554186 },
	{ 0.99349835414352871688, 0.0024616898757216631316, 0.99304430541932586785 },
	{ 0.99350198886337737214, 0.0024603018599745935142, 0.9930481964868306255 },
	{ 0.99350562869492020646, 0.0024589148360488126237, 0.99305208412110790306 },
	{ 0.9935092806953473854, 0.0024575342589614099752, 0.99305599872529481953 },
	{ 0.99351293294372999831, 0.0024561535102126308069, 0.99305990186631654115 },
	{ 0.99351654752197704479, 0.0024547694617507165304, 0.99306376714646793502 },
	{ 0.99352020224991266506, 0.0024533959609267419651, 0.99306768115937682495 },
	{ 0.99352381392898969636, 0.0024520158797499843305, 0.99307154216706716721 },
	{ 0.99352741546097211867, 0.0024506354171035002291, 0.99307539150178392173 },
	{ 0.99353104834976591064, 0.0024492651015517426585, 0.99307928363740405331 },
	{ 0.99353466643753440835, 0.002447888682484360319, 0.993083140372633566 },
	{ 0.99353827050629051065, 0.0024465186148879248217, 0.99308700300157026764 },
	{ 0.99354186837616353944, 0.0024451482230422221312, 0.99309085416734166341 },
	{ 0.99354547025146866535, 0.0024437799292800150078, 0.99309470315873571433 },
	{ 0.99354908065262204087, 0.0024424161177870949528, 0.99309856956422271068 },
	{ 0.99355266955795662476, 0.0024410498839614108366, 0.99310240833222807044 },
	{ 0.99355625943603875783, 0.0024396855384108732077, 0.99310624334275676706 },
	{ 0.99355985204162955426, 0.0024383265143630220018, 0.99311009351670698209 },
	{ 0.99356341859283803242, 0.0024369624167678068799, 0.9931139038270707653 },
	{ 0.99356700604858760872, 0.0024356041938063811673, 0.99311774007737596559 },
	{ 0.99357057008209581639, 0.0024342426902053070602, 0.99312154558122112125 },
	{ 0.99357415131988879864, 0.0024328880149123380955, 0.99312537523210009383 },
	{ 0.99357770375671750074, 0.0024315335303542323642, 0.9931291816514725701 },
	{ 0.99358126538696667218, 0.0024301804572341152537, 0.99313299154221967857 },
	{ 0.99358480719986341789, 0.0024288276320693202165, 0.99313678310334640997 },
	{ 0.99358838096084967084, 0.0024274804335829920816, 0.99314060497224276869 },
	{ 0.99359193110885979383, 0.0024261299926039885458, 0.99314439491212314071 },
	{ 0.99359549453201634339, 0.0024247845107314303786, 0.99314820468842923695 },
	{ 0.99359902984085424205, 0.0024234394484755712382, 0.99315199268281406653 },
	{ 0.99360255395355567831, 0.0024220941001174165971, 0.99315576284348916491 },
	{ 0.99360610183182085375, 0.0024207522994277191376, 0.99315955226838548153 },
	{ 0.99360962579193423672, 0.002419410803913803025, 0.99316332345902891277 },
	{ 0.99361314971390080064, 0.0024180690032241059992, 0.99316708946168397176 },
	{ 0.99361667083206484108, 0.002416730502247543648, 0.99317085594117626712 },
	{ 0.99362019610824903193, 0.0024153973037001805722, 0.99317463558137408786 },
	{ 0.99362370223465290575, 0.0024140585356948103014, 0.9931783789056540801 },
	{ 0.99362722552719451308, 0.0024127277785536971333, 0.9931821466439965107 },
	{ 0.99363073810043678336, 0.0024113978224990098922, 0.99318591068208261774 },
	{ 0.99363422578277937891, 0.0024100629264113635625, 0.99318963521897851709 },
	{ 0.99363772901001323756, 0.0024087344580886096285, 0.99319338472306795129 },
	{ 0.99364122025909784597, 0.0024074044638869498275, 0.99319711248338304888 },
	{ 0.99364469941559196986, 0.0024060761862990595605, 0.99320083333909592316 },
	{ 0.99364820250931140677, 0.0024047544509169798028, 0.99320458396852095984 },
	{ 0.99365169671478636992, 0.0024034331351515990718, 0.99320832441270412438 },
	{ 0.993655177091983699, 0.0024021124869582403082, 0.99321205015122948634 },
	{ 0.99365863725128544814, 0.0024007865744826543952, 0.99321573965013087992 },
	{ 0.99366211631241219138, 0.0023994681960341685857, 0.99321946357667512117 },
	{ 0.99366558917465575007, 0.0023981516295668837101, 0.99322317844331331482 },
	{ 0.99366904422226309812, 0.0023968355590102434147, 0.99322687732636993907 },
	{ 0.99367249936523804887, 0.0023955189734694722591, 0.99323057306230122521 },
	{ 0.99367595498505001395, 0.002394205077290273518, 0.99323426649034074476 },
	{ 0.99367942588272462068, 0.0023928955870864162918, 0.99323798107087657439 },
	{ 0.99368288581314456742, 0.002391586230396963459, 0.99324167842805433093 },
	{ 0.99368632937851320008, 0.0023902770644423742934, 0.99324536399781759854 },
	{ 0.9936897641319312191, 0.0023889675551650307872, 0.99324903251588392283 },
	{ 0.99369319400253652841, 0.00238766414940331205, 0.99325271568238782116 },
	{ 0.99369663175049183224, 0.0023863559180495527712, 0.99325637910783337592 },
	{ 0.99370006402435651083, 0.002385055068135002055, 0.99326005994737198712 },
	{ 0.99370348355713256083, 0.0023837513953444749645, 0.9932637143129116053 },
	{ 0.99370691060486215918, 0.0023824517279860766422, 0.99326738260209612719 },
	{ 0.99371032437744499788, 0.0023811505347487720193, 0.9932710295289758351 },
	{ 0.9937137463134800841, 0.0023798514014479908371, 0.99327468278825303827 },
	{ 0.99371716134491316907, 0.0023785584098098074175, 0.99327834142625326397 },
	{ 0.99372055428924899179, 0.0023772601920363698423, 0.99328196752488595589 },
	{ 0.99372398675384854272, 0.0023759715873000416576, 0.99328564229905591532 },
	{ 0.99372737624588347582, 0.0023746777755019464647, 0.99328926876008483138 },
	{ 0.99373077058258396654, 0.0023733872443434987989, 0.99329290086686605754 },
	{ 0.99373415025177358473, 0.0023720974189040456605, 0.99329651948869213118 },
	{ 0.99373754720154161557, 0.0023708061820266039012, 0.99330013975083808475 },
	{ 0.99374094539108626112, 0.0023695226317641524851, 0.99330377616822695952 },
	{ 0.99374432237091425701, 0.0023682387000319746022, 0.99330739797532530133 },
	{ 0.99374769784393701677, 0.0023669535285231850519, 0.99331100477159006701 },
	{ 0.9937510890335122804, 0.0023656738501784584441, 0.99331463277757159336 },
	{ 0.99375444516601973977, 0.0023643883353469154207, 0.99331821336686632051 },
	{ 0.99375782853546568152, 0.0023631131964919342876, 0.99332183957994013568 },
	{ 0.99376116738739439516, 0.0023618301612136137317, 0.99332540685594117313 },
	{ 0.99376454619827692127, 0.0023605574828383687862, 0.99332902469575445892 },
	{ 0.99376791243973205958, 0.0023592798644301656193, 0.99333261463105737565 },
	{ 0.99377125434341873067, 0.0023580073577162980608, 0.99333619914949022878 },
	{ 0.99377460744324175312, 0.0023567354041335334888, 0.99333978731095873282 },
	{ 0.99377795556488479622, 0.002355462706684802697, 0.99334336210191331862 },
	{ 0.99378130303802947321, 0.0023541934806105839668, 0.99334694272935486481 },
	{ 0.99378463832321628502, 0.0023529260665175661706, 0.99335051402986151992 },
	{ 0.99378797616425018635, 0.0023516594535109743014, 0.99335408723771689843 },
	{ 0.99379131518784036281, 0.0023503937560317256054, 0.99335765281617760536 },
	{ 0.99379461736145513484, 0.0023491258460280627952, 0.99336118738114975724 },
	{ 0.99379796891632565803, 0.0023478667289015976022, 0.9933647721666112318 },
	{ 0.99380129592361943214, 0.0023466058760878765951, 0.99336833026826532045 },
	{ 0.99380461917343643208, 0.002345345538258286882, 0.99337188476503057721 },
	{ 0.99380790400925200778, 0.0023440844756362163616, 0.99337540138185198568 },
	{ 0.99381120189133209664, 0.002342824862599107022, 0.99337892906129554582 },
	{ 0.9938145407432609213, 0.0023415712767836773314, 0.99338249618470875202 },
	{ 0.99381783902588438639, 0.0023403182059523785011, 0.99338603395402647056 },
	{ 0.99382112531128496968, 0.002339061949848862676, 0.9933895472902082302 },
	{ 0.99382443126144970336, 0.0023378087264296727385, 0.99339307392060993696 },
	{ 0.99382772342148395506, 0.0023365600234267428631, 0.99339660243928673555 },
	{ 0.99383101428452125248, 0.0023353110915419771944, 0.99340012248933562411 },
	{ 0.99383429789963373402, 0.0023340614730117037121, 0.99340363544404752805 },
	{ 0.99383759570541996275, 0.0023328170424697113917, 0.99340716121614225376 },
	{ 0.99384085696640644958, 0.002331568110584945723, 0.99341064586580052342 },
	{ 0.99384412940445587825, 0.0023303231078383637026, 0.99341414627015856009 },
	{ 0.99384741176071822455, 0.0023290822249648285638, 0.99341765880525378929 },
	{ 0.99385067603531551672, 0.0023278377562758636836, 0.99342114402711656496 },
	{ 0.99385393899384222305, 0.0023265999442336274261, 0.99342464303911004464 },
	{ 0.99385720136109079181, 0.0023253595954177094275, 0.99342812841356087361 },
	{ 0.99386048055115427946, 0.0023241250830886074109, 0.99343163541734513799 },
	{ 0.99386372092667318867, 0.0023228880339858240869, 0.99343510421693614898 },
	{ 0.99386698003235574017, 0.0023216520911452484706, 0.99343858373582660803 },
	{ 0.99387021508637207745, 0.0023204199057814786818, 0.99344205659807027775 },
	{ 0.99387344880524430835, 0.0023191844779250330583, 0.99344551034868078254 },
	{ 0.99387670283737927779, 0.0023179550200698091113, 0.99344898860872110635 },
	{ 0.99387995747986590533, 0.002316725524067611737, 0.99345246354997462923 },
	{ 0.99388317838135520343, 0.0023154987937209318971, 0.99345591867387605944 },
	{ 0.9938864006179884969, 0.0023142665320632169884, 0.99345935331285295522 },
	{ 0.99388962590637963679, 0.0023130434256789398836, 0.99346281419694715265 },
	{ 0.993892877287299914, 0.0023118207007643892456, 0.99346628423631477833 },
	{ 0.99389606997910273645, 0.0023105960112807465666, 0.99346970798433109628 },
	{ 0.99389930016937977353, 0.0023093747550246429556, 0.99347315824449367039 },
	{ 0.99390251231613868654, 0.0023081527358290859775, 0.99347659221589879053 },
	{ 0.9939057242530893177, 0.0023069348174330900347, 0.99348002868593066061 },
	{ 0.99390892722550139293, 0.0023057160979506681649, 0.99348345718324526654 },
	{ 0.99391214459839560824, 0.0023045003348586270628, 0.99348689454973082569 },
	{ 0.99391533711853707889, 0.0023032836753127282001, 0.99349030862748954895 },
	{ 0.99391853429260934583, 0.0023020710593459315328, 0.99349373346269465035 },
	{ 0.99392171822968211625, 0.0023008544379470056637, 0.99349713018358087879 },
	{ 0.99392492179337232905, 0.0022996462661025230713, 0.99350056259096031219 },
	{ 0.99392808371964191938, 0.0022984331923720543837, 0.99350394973695632661 },
	{ 0.99393127932968827754, 0.0022972242766616047041, 0.99350736423433194666 },
	{ 0.99393447139206614338, 0.0022960195189711744661, 0.99351077968538181739 },
	{ 0.99393763581696237264, 0.0022948115760085272333, 0.99351416555345428705 },
	{ 0.99394082391205507143, 0.0022936065131423156484, 0.99351756849229710955 },
	{ 0.9939439776939460458, 0.0022924009734389461969, 0.99352094608247665253 },
	{ 0.99394716483536449392, 0.0022912028151747857417, 0.99352436187684933788 },
	{ 0.99395031690064161722, 0.0022899994879958304045, 0.99352773500383317895 },
	{ 0.99395348723831877802, 0.0022887999755141410357, 0.99353112155855149989 },
	{ 0.9939566433853220806, 0.0022875995856520797526, 0.99353449235856983179 },
	{ 0.9939597718185495534, 0.0022863987952468057228, 0.99353784463823302531 },
	{ 0.99396293103638411193, 0.0022852020102736613286, 0.99354121457994459821 },
	{ 0.99396608117523932435, 0.0022840084296462193417, 0.99354458726823824399 },
	{ 0.9939692327636792113, 0.0022828150016066680282, 0.99354795904100434711 },
	{ 0.9939723832458570163, 0.0022816243582961209628, 0.99355133016527208412 },
	{ 0.99397551162186426055, 0.0022804306823012480097, 0.99355467346132331219 },
	{ 0.99397864043656158906, 0.0022792403441664818575, 0.99355802139223159397 },
	{ 0.99398175626221485501, 0.0022780491095778583784, 0.99356135503709852586 },
	{ 0.99398491609040096062, 0.0022768652182814717692, 0.9935647339052016136 },
	{ 0.99398803166809890364, 0.0022756775885817643115, 0.99356806447923728953 },
	{ 0.99399114282074796378, 0.0022744907218215097873, 0.99357139184892728778 },
	{ 0.99399425689164022657, 0.002273308032154761852, 0.99357473083437042316 },
	{ 0.99399738124314174215, 0.0022721254378554457502, 0.99357806804597947892 },
	{ 0.99400049495163789182, 0.0022709428817031022084, 0.99358139415681956397 },
	{ 0.9940035974067771285, 0.002269764330982887001, 0.99358471908510337389 },
	{ 0.99400671630326153938, 0.0022685863524672619275, 0.99358805282533779746 },
	{ 0.99400980262223126438, 0.0022674037200209728321, 0.99359134880006938495 },
	{ 0.99401290891114113535, 0.002266231063008033314, 0.99359468076646961787 },
	{ 0.9940159897750939777, 0.0022650515967604744998, 0.99359796930254140612 },
	{ 0.99401909516755004859, 0.0022638814765212162891, 0.99360129991472423416 },
	{ 0.99402218202057746055, 0.0022627038031813725624, 0.99360458208025170812 },
	{ 0.99402526910248667491, 0.0022615345984694583924, 0.99360789621294220986 },
	{ 0.99402833510819355034, 0.0022603622084853276612, 0.99361117626131256753 },
	{ 0.99403143130722915188, 0.0022591926604506595844, 0.99361447952211578993 },
	{ 0.99403448508683123208, 0.0022580239516493899946, 0.99361775524080475641 },
	{ 0.994037581228646272, 0.0022568595725295172334, 0.99362106424272755856 },
	{ 0.99404064553681281691, 0.0022556932288405524313, 0.99362434369981988969 },
	{ 0.99404370580140033464, 0.0022545277243849861162, 0.99362761735857241252 },
	{ 0.994046773161324837, 0.0022533641272780525686, 0.99363089536607973606 },
	{ 0.99404985307160331764, 0.0022522043830153571156, 0.99363418996752050916 },
	{ 0.9940528988212677941, 0.0022510433989760504289, 0.99363745201051978384 },
	{ 0.99405594172898281702, 0.0022498822051283942289, 0.99364070976198470841 },
	{ 0.99405901091996184959, 0.0022487257796523201642, 0.99364398952425259104 },
	{ 0.99406206210556979919, 0.002247568972706519199, 0.99364725242555873574 },
	{ 0.99406510003510473172, 0.0022464110022780525537, 0.99365049962938556405 },
	{ 0.99406813138428684606, 0.0022452548056838142823, 0.9936537425416778202 },
	{ 0.99407117755356777522, 0.0022441033965346444262, 0.99365700481355889728 },
	{ 0.99407420100632648552, 0.0022429480773207767681, 0.9936602354806730597 },
	{ 0.99407723716202711639, 0.0022417968398329834318, 0.99366348091066558634 },
	{ 0.99408026889267908643, 0.0022406481963393311101, 0.99366672786653709171 },
	{ 0.99408329957428909207, 0.0022394984275099856681, 0.99366996801317397647 },
	{ 0.99408630723420121633, 0.0022383474570510011187, 0.99367318227708989475 },
	{ 0.99408932660523385838, 0.0022372027808425050052, 0.99367641717851795669 },
	{ 0.994092342352304148, 0.0022360534888503174299, 0.99367963312090057393 },
	{ 0.99409537030640560129, 0.0022349151831862548723, 0.99368288202226773276 },
	{ 0.99409836879197066573, 0.0022337697249648195454, 0.99368608901918553666 },
	{ 0.99410139869156777248, 0.0022326294738051516604, 0.99368932346285010482 },
	{ 0.99410437873307155865, 0.0022314859801528079408, 0.99369251529634605724 },
	{ 0.99410739171448636586, 0.0022303486090895757038, 0.99369574098528024031 },
	{ 0.99411037732544826895, 0.0022292074805495363382, 0.99369893411577325804 },
	{ 0.99411339927140152106, 0.0022280741149184328694, 0.99370216472566696986 },
	{ 0.99411637742463032641, 0.0022269341880080326113, 0.99370534921587061472 },
	{ 0.99411937562409324887, 0.0022258012229201418891, 0.9937085546296889893 },
	{ 0.99412236234131734491, 0.0022246682959792241606, 0.99371175100267494784 },
	{ 0.99412531794968539423, 0.002223531077503882597, 0.99371491458833771659 },
	{ 0.99412831136170320967, 0.0022223982840773688283, 0.9937181059449966547 },
	{ 0.9941312969345181827, 0.0022212706977126225015, 0.99372130392015545208 },
	{ 0.99413427110138841147, 0.0022201429969069584949, 0.99372449064195733648 },
	{ 0.99413724524918489767, 0.0022190147811171636281, 0.99372766967714409869 },
	{ 0.99414021201554236828, 0.0022178876143691167618, 0.99373084335268113687 },
	{ 0.99414319047394672513, 0.002216763899922094376, 0.9937340294832048837 },
	{ 0.99414612801972301881, 0.0022156343680617422882, 0.99373716676653001123 },
	{ 0.99414907554093256969, 0.0022145074492690170614, 0.99374031742036927906 },
	{ 0.99415205180588617218, 0.0022133906203505599591, 0.9937435082238972317 },
	{ 0.99415502103272335166, 0.0022122722464797107099, 0.99374668527544152141 },
	{ 0.99415794228974219138, 0.0022111476355788318646, 0.9937498086351216342 },
	{ 0.99416089795533046924, 0.0022100295096633046886, 0.99375296846330762879 },
	{ 0.99416383481446135573, 0.0022089108878371324987, 0.99375611253679396739 },
	{ 0.99416678662720547877, 0.0022077950125929919969, 0.99375926881731158069 },
	{ 0.99416972299042571937, 0.0022066764289137928007, 0.99376240270555638023 },
	{ 0.99417266589585173708, 0.0022055665618178452343, 0.99376556041658525853 },
	{ 0.99417560304108476554, 0.0022044507437941635725, 0.99376868959367881118 },
	{ 0.99417851836624959727, 0.0022033382827040754251, 0.99377181632936606448 },
	{ 0.99418144347611292488, 0.0022022277480361063251, 0.99377494834840907068 },
	{ 0.99418438762131566833, 0.0022011196166274145727, 0.99377809223116053694 },
	{ 0.99418729575577613478, 0.0022000094252821993795, 0.99378120429933691771 },
	{ 0.9941902196449362572, 0.0021989037734267305284, 0.9937843357080282658 },
	{ 0.99419313308182588607, 0.0021977934676405972217, 0.99378744399965435186 },
	{ 0.99419603261414390971, 0.0021966878730055872104, 0.99379054868639127296 },
	{ 0.99419895081940512505, 0.0021955853873488486404, 0.99379367288530484625 },
	{ 0.99420185206833688873, 0.0021944805938002645562, 0.99379677143037914444 },
	{ 0.99420476283493841585, 0.0021933789092299519133, 0.99379988483369940955 },
	{ 0.99420765864792670641, 0.0021922818022963581723, 0.99380299793184390111 },
	{ 0.99421057475510443702, 0.0021911805754897175497, 0.9938061035531817744 },
	{ 0.99421344012680867852, 0.0021900780516860064197, 0.99380917171419247413 },
	{ 0.99421635304871414096, 0.0021889827948805861725, 0.99381228326738457746 },
	{ 0.99421923148575652718, 0.0021878853255507513774, 0.99381536491335009664 },
	{ 0.99422212340775339978, 0.0021867892104384463632, 0.99381845489442921515 },
	{ 0.99422499740067327156, 0.0021856950026747741164, 0.99382153457582567135 },
	{ 0.99422788752976254401, 0.0021846022826430351767, 0.99382462238252722297 },
	{ 0.99423074220124085798, 0.0021835081702467943297, 0.99382768037736957112 },
	{ 0.99423362603607978727, 0.0021824160224196455238, 0.99383075708330237408 },
	{ 0.99423648974839073933, 0.002181324160694791351, 0.99383381931245906582 },
	{ 0.99423938153687341224, 0.0021802399283644682479, 0.99383691522539241436 },
	{ 0.9942422476905904416, 0.002179154666065883858, 0.99383998969972708881 },
	{ 0.99424510178986413855, 0.0021780652457472800265, 0.99384304132402501164 },
	{ 0.99424795205536697917, 0.0021769767600295060819, 0.99384608507097327301 },
	{ 0.99425080993119108186, 0.0021758918029067026052, 0.99384914073885055608 },
	{ 0.99425368024292803959, 0.0021748124533888797509, 0.99385221937120538094 },
	{ 0.99425652677002762658, 0.0021737264853713012674, 0.99385525541246511061 },
	{ 0.9942593666595540558, 0.0021726447135207152192, 0.99385829824388594034 },
	{ 0.9942622058624349668, 0.0021715642386671988109, 0.99386133642137608479 },
	{ 0.99426506383362645014, 0.0021704854422804798104, 0.9938643854326064675 },
	{ 0.99426789411011562425, 0.002169405501484580976, 0.99386741376817766547 },
	{ 0.99427073308411473285, 0.0021683287650343858501, 0.99387045263231343917 },
	{ 0.99427356162491686842, 0.0021672495681044541029, 0.99387346828401634813 },
	{ 0.99427640063706290707, 0.0021661758452650981509, 0.99387650550783213088 },
	{ 0.99427924745026485809, 0.002165106604695029701, 0.99387955854356824226 },
	{ 0.99428206202927482682, 0.0021640314513441992819, 0.99388256866395996436 },
	{ 0.99428486611786748295, 0.0021629577094313566163, 0.9938855692857555546 },
	{ 0.99428769856873411292, 0.0021618890219923911529, 0.99388859956682229502 },
	{ 0.99429052354279423565, 0.0021608194190260820826, 0.99389162099779138071 },
	{ 0.99429334695282833856, 0.0021597519904372145666, 0.99389464307725916559 },
	{ 0.99429615708771590388, 0.0021586850196120190709, 0.99389764669359204063 },
	{ 0.99429894772950067061, 0.0021576139670607492535, 0.99390063119829163973 },
	{ 0.99430176917496582156, 0.0021565515547987863798, 0.99390365089357368689 },
	{ 0.99430455020371333319, 0.0021554844695326732043, 0.99390662677705754469 },
	{ 0.99430736333313829434, 0.0021544219046828196572, 0.9939096302980231501 },
	{ 0.99431016988221054831, 0.0021533621817824287643, 0.9939126403993415737 },
	{ 0.99431294900360944755, 0.0021522966986891670094, 0.99391560819566726614 },
	{ 0.99431575890961521047, 0.0021512388068434633304, 0.99391861219346988587 },
	{ 0.99431856175843114087, 0.0021501817160841860122, 0.99392161035478576725 },
	{ 0.9943213422149741465, 0.0021491242820021543534, 0.99392458917558657028 },
	{ 0.99432412887040011462, 0.0021480668288466368485, 0.99392757091463079799 },
	{ 0.99432689551773900671, 0.0021470085555312067027, 0.99393052722871766402 },
	{ 0.99432967729035237614, 0.0021459534293410214255, 0.99393350362718557722 },
	{ 0.99433243878784993708, 0.0021448975592848686274, 0.9939364551729009678 },
	{ 0.99433521829071846998, 0.0021438429099318403494, 0.99393942418992975441 },
	{ 0.99433801743927807681, 0.0021427977591750037821, 0.99394242490709283633 },
	{ 0.99434077174607127247, 0.0021417429381605989844, 0.99394536666810950898 },
	{ 0.99434354182663764465, 0.0021406934386488793085, 0.99394832900941820775 },
	{ 0.99434628093186216979, 0.0021396428710219253522, 0.99395126617372497879 },
	{ 0.99434904063645201955, 0.0021385933715102061099, 0.99395421386659621454 },
	{ 0.99435183032456242458, 0.002137551882862744404, 0.99395719963014628195 },
	{ 0.9943545924705586847, 0.0021365054351088373294, 0.99396014549196276544 },
	{ 0.99435732716980806956, 0.0021354590445753895284, 0.99396307531297722893 },
	{ 0.9943600805992210967, 0.0021344163924452617086, 0.99396602157533697763 },
	{ 0.99436282140198606339, 0.0021333728629347632755, 0.99396895505846083463 },
	{ 0.99436555594864761698, 0.0021323300582167456496, 0.99397187927187036216 },
	{ 0.99436829034272111727, 0.0021312886267897432173, 0.99397480581224528784 },
	{ 0.99437104518357199989, 0.0021302514296767062138, 0.99397775402010069001 },
	{ 0.99437377593460962721, 0.0021292132598158658961, 0.99398067848146542946 },
	{ 0.99437651688996253618, 0.0021281735068556604379, 0.99398359971941108171 },
	{ 0.99437924815598432993, 0.0021271387892958454682, 0.99398652629793293745 },
	{ 0.99438197396698913, 0.0021261009436842727774, 0.99398943727434285744 },
	{ 0.99438469560090025912, 0.0021250678473707955082, 0.99399235742509961522 },
	{ 0.99438742120209666631, 0.002124034140705755979, 0.9939952713197529599 },
	{ 0.99439014710846873601, 0.0021230016547438414036, 0.9939981820100606269 },
	{ 0.99439286204758625676, 0.0021219705992934008616, 0.99400109027803529305 },
	{ 0.99439557860795013688, 0.002120940211414982287, 0.99400399757326241001 },
	{ 0.99439829415741909369, 0.0021199107199904206056, 0.99400689786852003405 },
	{ 0.99440099151078231721, 0.0021188794738051172639, 0.9940097830957234093 },
	{ 0.99440368833008785376, 0.0021178503638502829166, 0.99401266855180847593 },
	{ 0.99440640977326422156, 0.0021168258506056533176, 0.99401557599962353517 },
	{ 0.9944091216224768548, 0.0021158028060194711793, 0.99401848148286953144 },
	{ 0.99441180936280282321, 0.0021147763663527229666, 0.9940213543886007308 },
	{ 0.99441450303498302166, 0.0021137522345778198343, 0.99402423528612282588 },
	{ 0.9944171944946389452, 0.0021127265769240108351, 0.99402710817278072675 },
	{ 0.99441989898148586136, 0.0021117095977064813395, 0.99403001064241580664 },
	{ 0.99442258517685944152, 0.0021106859236952506612, 0.99403287651003069403 },
	{ 0.99442526603165670718, 0.0021096665984389026578, 0.99403574825227936085 },
	{ 0.99442795575562525912, 0.0021086491996046737019, 0.99403862337053483511 },
	{ 0.99443061252060926947, 0.0021076258116957376568, 0.99404145984590730478 },
	{ 0.99443330958787001794, 0.0021066134673353854694, 0.99404435054720119425 },
	{ 0.99443598201218641464, 0.002105599368214291188, 0.99404721523225980651 },
	{ 0.99443867204133062909, 0.0021045857077833822132, 0.99405008672655303936 },
	{ 0.99444133046570815093, 0.0021035697394606281581, 0.99405293222368440453 },
	{ 0.99444399619523071721, 0.0021025572997328445708, 0.99405578479707912276 },
	{ 0.99444665904465712192, 0.0021015446883436840302, 0.99405863250673498488 },
	{ 0.99444932353440318451, 0.0021005348616835273039, 0.9940614825433560231 },
	{ 0.99445198474350959827, 0.0020995251113173161311, 0.99406433052004061768 },
	{ 0.99445464732590715951, 0.0020985149031874333718, 0.99406717300356106648 },
	{ 0.99445732451859514267, 0.0020975103026625308011, 0.99407003635347568338 },
	{ 0.99445997548523956677, 0.0020965038901564272966, 0.9940728770250151225 },
	{ 0.99446261228028343115, 0.0020954950553175601645, 0.99407569372118198547 },
	{ 0.99446526326600126477, 0.0020944903403517394803, 0.99407852811754437994 },
	{ 0.99446791924897237624, 0.002093490317463555378, 0.99408137788713679672 },
	{ 0.99447053794327799903, 0.0020924833708998342996, 0.99408417774141544232 },
	{ 0.99447318538132745136, 0.0020914801436659469225, 0.99408700530946980667 },
	{ 0.99447582164231396185, 0.0020904817610975872343, 0.99408983261049521651 },
	{ 0.9944784471458540942, 0.0020894776564833292438, 0.99409263557375215914 },
	{ 0.99448108479920505065, 0.0020884796363112097424, 0.99409545774400964735 },
	{ 0.99448371831360937723, 0.0020874785071608183661, 0.99409826581896076902 },
	{ 0.99448635148469088918, 0.0020864840537306423261, 0.99410108995378743124 },
	{ 0.9944889787811386217, 0.0020854883033033957788, 0.99410390035570384004 },
	{ 0.99449159921113139404, 0.0020844915610548600711, 0.99410669977129240138 },
	{ 0.99449420386735098987, 0.0020834949523207291905, 0.99410948726595183 },
	{ 0.99449682864609867394, 0.0020825015670057878646, 0.99411229049623750509 },
	{ 0.99449943740311785856, 0.0020815094023939710588, 0.99411508464754372305 },
	{ 0.99450205836716820684, 0.0020805179244276620666, 0.99411788665712608193 },
	{ 0.99450467162553002343, 0.0020795282012220956021, 0.99412068447054158238 },
	{ 0.99450728341523331189, 0.002078540328144703065, 0.99412348054826971122 },
	{ 0.99450989818040058665, 0.0020775510054823493472, 0.9941262736505340758 },
	{ 0.99451248168412376138, 0.0020765590697523687684, 0.99412903491914961229 },
	{ 0.99451508279267497592, 0.0020755738669630619322, 0.99413181928575733437 },
	{ 0.99451768371049109607, 0.0020745868712660404422, 0.99413459953249194712 },
	{ 0.9945202698845021505, 0.0020736005049940679258, 0.99413736614168379813 },
	{ 0.99452288783494158242, 0.0020726189070936771111, 0.99414016139925220905 },
	{ 0.99452546275559594591, 0.0020716357833143799957, 0.99414292339266041587 },
	{ 0.99452805449906511726, 0.0020706555968519769345, 0.99414570083559250513 },
	{ 0.9945306364387623832, 0.0020696697264906485647, 0.99414845062196943726 },
	{ 0.99453321307603037571, 0.0020686908370253164445, 0.99415121280611229437 },
	{ 0.99453579778138312406, 0.0020677129966017323247, 0.9941539857286281201 },
	{ 0.99453836999360212268, 0.002066732276081712557, 0.99415673074663346576 },
	{ 0.99454096219483500985, 0.0020657554465529034439, 0.99415949918688006903 },
	{ 0.99454352460328221408, 0.0020647790366407942249, 0.99416224531114738561 },
	{ 0.99454610600892190408, 0.0020638046866652075793, 0.99416500692308573672 },
	{ 0.9945486712402449303, 0.0020628275901075905467, 0.99416774457872547632 },
	{ 0.99455123555604085794, 0.0020618552237745817884, 0.99417049352586894795 },
	{ 0.99455381019059274639, 0.0020608835631605675574, 0.99417324729860456767 },
	{ 0.99455636483613096832, 0.0020599087744947956052, 0.99417597482622299676 },
	{ 0.99455892806473822354, 0.0020589374572035357147, 0.99417871421754988592 },
	{ 0.99456147790375792894, 0.002057967742085126811, 0.99418144807756581027 },
	{ 0.99456403443757135374, 0.0020569976645704781543, 0.99418417779863532679 },
	{ 0.99456657578888985061, 0.002056029189228680918, 0.99418690164507106388 },
	{ 0.99456913110200029227, 0.0020550627738234066889, 0.99418963762224421554 },
	{ 0.99457167273942093111, 0.0020540953475233574531, 0.99419235633791203099 },
	{ 0.99457423638764486107, 0.0020531305533644213582, 0.99419509138048411945 },
	{ 0.99457676970902553215, 0.00205216488182511465, 0.99419780296266813124 },
	{ 0.99457930831376184511, 0.0020511991530653486682, 0.99420051246584217886 },
	{ 0.994581859812175062, 0.0020502400618788250292, 0.99420325179994872844 },
	{ 0.99458436114731918476, 0.0020492723113295081665, 0.99420591968477556311 },
	{ 0.99458691314164293651, 0.0020483159285780427883, 0.99420865699709259911 },
	{ 0.99458943711701519597, 0.0020473528510328762274, 0.99421135110796310386 },
	{ 0.9945919648880113817, 0.0020463942939039697286, 0.99421406198442796587 },
	{ 0.99459449038926261988, 0.0020454364424940573233, 0.99421676303804751296 },
	{ 0.99459701960984370217, 0.0020444791823622208982, 0.9942194689554061382 },
	{ 0.99459955401841304568, 0.0020435223799940560596, 0.99422217075289143207 },
	{ 0.99460206689301633443, 0.0020425656348463509283, 0.99422485959947959344 },
	{ 0.99460457963410531246, 0.0020416092902418585438, 0.99422754339159391535 },
	{ 0.99460708432618283314, 0.0020406561881300424276, 0.99423023111284636322 },
	{ 0.99460959826890127378, 0.0020397027999159308108, 0.99423291877687836049 },
	{ 0.99461210511628295183, 0.0020387512046095342816, 0.99423560110033426529 },
	{ 0.99461461938325068655, 0.0020377997428175417122, 0.9942382879442063226 },
	{ 0.99461712544861957674, 0.0020368503028151000236, 0.99424097131670396976 },
	{ 0.99461961482468774776, 0.0020358978682753050074, 0.99424363216341415939 },
	{ 0.99462213054124060108, 0.0020349541121717886275, 0.99424633098543580001 },
	{ 0.9946246259636037923, 0.002034002879261632285, 0.99424899120272103303 },
	{ 0.99462712167206934755, 0.0020330566626783801512, 0.99425166143358678639 },
	{ 0.99462962096635043618, 0.0020321124678846784646, 0.99425434020937408786 },
	{ 0.99463210296097936958, 0.0020311648970838969835, 0.99425699066103445656 },
	{ 0.99463458251420200362, 0.0020302197676893654101, 0.99425964477480399673 },
	{ 0.99463706828538134275, 0.0020292777281996189978, 0.9942623080057000351 },
	{ 0.99463955567780681921, 0.0020283349829908789257, 0.99426496751726622936 },
	{ 0.99464202481690600077, 0.0020273909598585541925, 0.99426760518969059532 },
	{ 0.99464449855271530598, 0.002026449969410556648, 0.99427025688112735669 },
	{ 0.99464699244919974053, 0.002025511248707431624, 0.99427291923464289347 },
	{ 0.99464948014680121258, 0.0020245764762159760945, 0.99427558702410212543 },
	{ 0.99465195117417548598, 0.0020236361342665129363, 0.99427822502077567446 },
	{ 0.99465441062394355232, 0.0020226966124769615515, 0.99428084911287772929 },
	{ 0.99465690129700867761, 0.0020217637091871662296, 0.99428351594866271057 },
	{ 0.99465934037629333275, 0.0020208257132765215791, 0.9942861314195490241 },
	{ 0.9946618101638912135, 0.0020198903495069900696, 0.99428876905382646001 },
	{ 0.99466426907960170389, 0.0020189569312330634537, 0.99429139917315023656 },
	{ 0.99466672124329791327, 0.0020180227118727122118, 0.99429402162493241146 },
	{ 0.99466918034974316498, 0.0020170907050367750842, 0.99429665162981517579 },
	{ 0.99467164100114102698, 0.0020161611205336015841, 0.99429928619326102268 },
	{ 0.9946740849632381698, 0.0020152284651991292028, 0.99430189838350735432 },
	{ 0.99467653245393017336, 0.002014298270344393009, 0.99430451398790786754 },
	{ 0.99467899564210160435, 0.0020133716422316002767, 0.99430714654863783242 },
	{ 0.99468143666688191296, 0.0020124444419142178443, 0.99430975999773452134 },
	{ 0.99468388249818084912, 0.002011518691181796159, 0.99431238161028334677 },
	{ 0.99468631295624965194, 0.0020105911475416598198, 0.99431498487413838561 },
	{ 0.99468876191560018363, 0.0020096669989820895551, 0.99431760061205332057 },
	{ 0.99469119691315888154, 0.0020087432318922457571, 0.99432020833910417235 },
	{ 0.99469362939301730897, 0.0020078155738111917381, 0.99432279630602304898 },
	{ 0.99469604951325651943, 0.0020068926459547468608, 0.99432538854540286621 },
	{ 0.99469848432008023398, 0.0020059744101759385652, 0.99432800477922855809 },
	{ 0.99470092891160244442, 0.0020050529891249137086, 0.99433061061800420699 },
	{ 0.99470335401002163422, 0.0020041343146559196728, 0.99433320970476557488 },
	{ 0.99470576863709680993, 0.0020032135230299433562, 0.99433579111040515386 },
	{ 0.99470817391816368502, 0.0020022940665480101069, 0.99433836980760970103 },
	{ 0.99471061273041971873, 0.0020013786917921507456, 0.99434097524584208472 },
	{ 0.99471302680436390897, 0.0020004623442884885039, 0.99434355888307957017 },
	{ 0.99471542930070189215, 0.0019995442229505978882, 0.99434612831056978788 },
	{ 0.99471785172883286918, 0.0019986297446485962875, 0.99434871618212128386 },
	{ 0.99472024060670150014, 0.0019977127295729129458, 0.99435127397478473288 },
	{ 0.99472265830460804281, 0.0019968000441786259991, 0.99435385597170244942 },
	{ 0.99472505973283065206, 0.0019958897048231575601, 0.99435643318117505896 },
	{ 0.99472745446625965293, 0.0019949735862013315453, 0.99435898572862990719 },
	{ 0.99472986796799911513, 0.0019940641814466929932, 0.99436156726778390791 },
	{ 0.99473226731721176019, 0.0019931550055738906681, 0.99436413480699881173 },
	{ 0.99473466151658296308, 0.0019922462111708148097, 0.99436669830263457737 },
	{ 0.99473705554429281417, 0.0019913383895155413982, 0.99436926353395771461 },
	{ 0.99473944281998849526, 0.0019904290801283346796, 0.99437181194246593297 },
	{ 0.99474185203019360735, 0.0019895253020521630298, 0.9943743917459326731 },
	{ 0.99474421908799381953, 0.0019886159163710107577, 0.9943769235223607339 },
	{ 0.99474660619202825984, 0.0019877119666334621545, 0.99437948049486435398 },
	{ 0.99474899110261172375, 0.0019868063956495754172, 0.99438202600420266819 },
	{ 0.99475138356629577707, 0.0019859054785963531353, 0.99438458768785742414 },
	{ 0.99475376634064882619, 0.0019850024253126618591, 0.99438713373125342532 },
	{ 0.99475613002244189786, 0.00198410080254044505, 0.99438966770113257354 },
	{ 0.99475850978318403062, 0.0019831968718763831605, 0.99439220127046845654 },
	{ 0.99476088015977104373, 0.0019822982054945471192, 0.99439474529207494413 },
	{ 0.9947632601493950899, 0.0019813993865248204045, 0.99439728778780256402 },
	{ 0.99476562222901532273, 0.001980499289631509896, 0.99439981149614597999 },
	{ 0.99476799680176930529, 0.0019796029883619786424, 0.99440235330522819268 },
	{ 0.99477032906953055669, 0.0019787009268995765267, 0.99440484785021110437 },
	{ 0.99477271050873961045, 0.0019778096610304357617, 0.99440740110338499136 },
	{ 0.99477506316605757153, 0.0019769127684828280943, 0.99440991691530522534 },
	{ 0.99477741996232227351, 0.0019760176116224766746, 0.99441243286073988106 },
	{ 0.99477979075852607238, 0.0019751260024305824364, 0.99441497249544452686 },
	{ 0.99478214999619685166, 0.0019742331343885906846, 0.9944174917978125805 },
	{ 0.9947844681114311749, 0.0019733383589979657316, 0.99441998081148452737 },
	{ 0.99478684627000057983, 0.0019724494582411297543, 0.99442251781404800148 },
	{ 0.99478917338792050007, 0.0019715566664930831223, 0.99442500850618664732 },
	{ 0.99479152919236391028, 0.0019706705886122235193, 0.99442753215730961269 },
	{ 0.99479386962357729818, 0.0019697787505384930541, 0.99443002944887470829 },
	{ 0.99479620025101866965, 0.0019688897734877119569, 0.99443252426088657447 },
	{ 0.9947985472816585073, 0.0019680040770765788206, 0.99443503730715121502 },
	{ 0.99480088660660970223, 0.0019671158629652506569, 0.99443753166139925437 },
	{ 0.99480322703782297911, 0.0019662314254042159017, 0.99444003650606471734 },
	{ 0.99480555833283634826, 0.0019653486853834639669, 0.99444253805101701094 },
	{ 0.99480788566056455036, 0.001964463198780680344, 0.99444502517641375494 },
	{ 0.99481019936982373331, 0.0019635777121778975884, 0.99444749902666407237 },
	{ 0.99481253804627634008, 0.0019626955634352220674, 0.99444999814928369819 },
	{ 0.99481487130585888323, 0.0019618163901564135941, 0.99445249765337317971 },
	{ 0.99481717637482869332, 0.0019609343558546557529, 0.99445496782244058309 },
	{ 0.9948195125145077311, 0.0019600552016493331259, 0.99445746265352574778 },
	{ 0.99482182078782344092, 0.0019591734725233570652, 0.9944599273294291164 },
	{ 0.99482413945618886064, 0.0019582955771681328193, 0.99446240663469642751 },
	{ 0.99482645450059192793, 0.0019574178344007988131, 0.99446488372743913065 },
	{ 0.9948287783760191294, 0.0019565412551161309208, 0.99446736354769049715 },
	{ 0.99483105798188475877, 0.0019556612235304381142, 0.9944698058885413916 },
	{ 0.99483335862580590803, 0.0019547863608595393223, 0.99447227102220836503 },
	{ 0.99483568124238308528, 0.0019539159232374691925, 0.99447476255358047137 },
	{ 0.99483798058930694719, 0.001953041442036297301, 0.9944772221177894389 },
	{ 0.99484028920594513856, 0.001952167380451824653, 0.99447968164385136536 },
	{ 0.9948425929016239122, 0.0019512963324781918296, 0.99448214891374886459 },
	{ 0.99484488597337072946, 0.0019504231673475765085, 0.99448459930361099435 },
	{ 0.99484719430390666783, 0.0019495539313551448358, 0.99448706560076072236 },
	{ 0.99484947148743940737, 0.0019486826926466485621, 0.99448950353563614346 },
	{ 0.99485176307145428698, 0.001947812960743572526, 0.99449195724428474108 },
	{ 0.99485405112687430584, 0.0019469442778822444902, 0.99449440368593522432 },
	{ 0.99485636327210724694, 0.0019460820990797544038, 0.99449688051164941704 },
	{ 0.99485861398164099345, 0.001945207121967937932, 0.99449927915514302335 },
	{ 0.99486091157380407424, 0.001944345076679852239, 0.99450174169481575515 },
	{ 0.99486318280640895217, 0.0019434799414869813848, 0.99450417642534538754 },
	{ 0.99486546937409703339, 0.0019426146537062198572, 0.99450661809862417329 },
	{ 0.99486772248688992715, 0.0019417494803663762262, 0.99450903478563579263 },
	{ 0.99487002944413482908, 0.0019408895903822453739, 0.99451149635256075321 },
	{ 0.99487229516450237377, 0.0019400282508131533408, 0.99451392614305778039 },
	{ 0.99487455886308040487, 0.0019391634398695498966, 0.99451634120882337342 },
	{ 0.9948768289131291187, 0.001938304827809002838, 0.99451877452791503931 },
	{ 0.99487909131470986246, 0.001937442229389813508, 0.99452118867815308967 },
	{ 0.99488135621491735616, 0.0019365846472975277361, 0.99452361867845828769 },
	{ 0.99488364201966594802, 0.0019357288962599298286, 0.99452605844438846106 },
	{ 0.99488587613526657805, 0.0019348660880323905516, 0.99452844453752820009 },
	{ 0.99488814067307784761, 0.0019340119582411305615, 0.99453087238252935176 },
	{ 0.99489039699021641905, 0.0019331548720594895867, 0.99453328372896476761 },
	{ 0.99489265269700344341, 0.0019322993117567551294, 0.99453569660127916219 },
	{ 0.99489490603867825058, 0.0019314465743299972633, 0.99453811229646960079 },
	{ 0.99489717055741588858, 0.0019305945616957197707, 0.99454053459108626711 },
	{ 0.99489941735688480762, 0.0019297386389967451266, 0.99454293081224720563 },
	{ 0.99490163733903203003, 0.0019288830596205243893, 0.99454530754030512352 },
	{ 0.99490390822831409334, 0.0019280358153578288152, 0.99454773879946034576 },
	{ 0.99490613547745965217, 0.0019271806365248208247, 0.99455011543215077197 },
	{ 0.99490838485184918127, 0.0019263318663832191668, 0.99455251739443106818 },
	{ 0.99491060977402945298, 0.0019254827529188636021, 0.99455491008699703492 },
	{ 0.99491285357896108721, 0.0019246342116590979543, 0.99455730586946777816 },
	{ 0.99491509143296485984, 0.0019237867385145668037, 0.99455969814241684812 },
	{ 0.99491732596818216461, 0.0019229395323988440064, 0.99456208908022214477 },
	{ 0.99491956443253770637, 0.0019220951110121252403, 0.99456448318422607802 },
	{ 0.99492177382890012449, 0.0019212455779310706489, 0.99456684654176996663 },
	{ 0.99492399722520141747, 0.0019204004317518715093, 0.99456922557771954008 },
	{ 0.99492622600022573298, 0.0019195562392469885365, 0.99457160663545873813 },
	{ 0.99492846156541125957, 0.0019187141066786292214, 0.99457399570406224143 },
	{ 0.99493070666734007013, 0.0019178764754530432547, 0.99457640392244606176 },
	{ 0.99493291575852671471, 0.0019170321303602698253, 0.9945787639230563304 },
	{ 0.99493512280885032517, 0.0019161890631910804064, 0.99458112207353843726 },
	{ 0.99493733855668364807, 0.0019153509932753084825, 0.99458350177706000839 },
	{ 0.99493953944627089303, 0.0019145065337416169397, 0.99458584709108577293 },
	{ 0.99494175309602050916, 0.0019136691886183256062, 0.99458821752489290358 },
	{ 0.99494395734254148511, 0.0019128311377760401791, 0.9945905776399439624 },
	{ 0.99494617928925777051, 0.0019119950705763328561, 0.99459295339525388702 },
	{ 0.99494839303437487832, 0.001911160719990395284, 0.99459532461107402757 },
	{ 0.99495058423463111907, 0.0019103220587965471632, 0.99459766862810261578 },
	{ 0.99495277615967991913, 0.0019094851142164687933, 0.9946000125306903028 },
	{ 0.99495498567048301641, 0.0019086504203077770975, 0.99460237165392018088 },
	{ 0.99495718179169878592, 0.0019078175193068002725, 0.99460472356737228417 },
	{ 0.99495938138428896558, 0.0019069858008619758414, 0.99460707948625659558 },
	{ 0.99496157954636776921, 0.0019061554366346805407, 0.99460943572939009005 },
	{ 0.99496377227250298869, 0.0019053220397230591354, 0.99461177249849419546 },
	{ 0.9949659528679007936, 0.0019044889479872192939, 0.99461410591066456988 },
	{ 0.99496815610352706827, 0.0019036603766676390807, 0.99461646192491637297 },
	{ 0.99497033189240646767, 0.0019028283530470337364, 0.99461878610551934798 },
	{ 0.9949725229019279471, 0.001902003310322424208, 0.99462113946855634783 },
	{ 0.99497470351639927255, 0.0019011732894178830309, 0.99462346546114044354 },
	{ 0.99497686232987569976, 0.0019003438216444452739, 0.99462577686250763787 },
	{ 0.99497906318131601466, 0.001899520381092687166, 0.99462813182771758758 },
	{ 0.99498124663773690468, 0.001898694041371007564, 0.99463046390474407765 },
	{ 0.99498340186539802055, 0.0018978655654188589675, 0.99463276668489530863 },
	{ 0.9949855764717210338, 0.0018970444136854605274, 0.99463510578096459014 },
	{ 0.99498777221146705863, 0.0018962195235487416724, 0.99463743640840596161 },
	{ 0.99498991847458939652, 0.0018953966552015734815, 0.99463974739015637017 },
	{ 0.99499209063950633247, 0.0018945739775892685239, 0.99464206542909672226 },
	{ 0.9949942554420573293, 0.0018937524062391710572, 0.9946443823617748814 },
	{ 0.99499642556611123112, 0.0018929312735792591139, 0.99464669843614617051 },
	{ 0.99499859395447798338, 0.0018921136695143176386, 0.99464902475297978235 },
	{ 0.99500074552002959472, 0.0018912902289625597475, 0.99465131654680294382 },
	{ 0.99500292052689587319, 0.0018904753905531358066, 0.99465364894807850593 },
	{ 0.99500506902161611755, 0.0018896562796827745274, 0.9946559473604016377 },
	{ 0.99500723531189938509, 0.0018888413077589464098, 0.99465826654375122384 },
	{ 0.99500936170044917972, 0.0018880215293165633801, 0.99466054384172464253 },
	{ 0.99501152186814323386, 0.0018872056609388779356, 0.99466285156190881178 },
	{ 0.99501368121567723701, 0.0018863930541273546057, 0.99466516273439398166 },
	{ 0.99501580649796483868, 0.0018855749160047959902, 0.99466743755281439299 },
	{ 0.99501796544495590968, 0.0018847608405348254164, 0.99466973840654360206 },
	{ 0.99502010020676601165, 0.0018839462691542100455, 0.99467202190340031631 },
	{ 0.99502227122727371356, 0.0018831399947401477116, 0.99467435039461138402 },
	{ 0.99502437072220761838, 0.0018823207885023545988, 0.99467659088075632834 },
	{ 0.99502652949753722655, 0.0018815131789442491976, 0.99467890270174030842 },
	{ 0.99502865680161434181, 0.0018807005721327256509, 0.99468117328584682024 },
	{ 0.99503078391495658472, 0.001879890902638096592, 0.99468345100343713572 },
	{ 0.99503295279923387184, 0.0018790879851576279894, 0.99468577308595662601 },
	{ 0.99503504046860635768, 0.0018782736617323349086, 0.99468800998628614796 },
	{ 0.99503718570176058478, 0.0018774696761366318088, 0.99469030689180371052 },
	{ 0.99503930114212923996, 0.0018766607695814559002, 0.99469257186830506434 },
	{ 0.99504144715729636594, 0.0018758546668287705197, 0.99469485341966612513 },
	{ 0.9950435568374721429, 0.0018750456458326767144, 0.99469710714281056596 },
	{ 0.99504569907608919621, 0.0018742468672987412735, 0.99469940532625156226 },
	{ 0.9950478094047634503, 0.0018734402495619250327, 0.99470166274965232667 },
	{ 0.99504992640915790325, 0.0018726403838392685977, 0.99470393783510135943 },
	{ 0.99505204150620374381, 0.0018718364745375108346, 0.99470619621217648554 },
	{ 0.99505415412369635497, 0.0018710320693251087081, 0.99470845012605590973 },
	{ 0.99505626214447884248, 0.0018702321082350206564, 0.99471071084916973248 },
	{ 0.99505838864746942729, 0.0018694347983595322425, 0.99471298704088106923 },
	{ 0.99506048787537459965, 0.001868630736469883806, 0.99471522512376686631 },
	{ 0.99506260886612774019, 0.0018678359252211045732, 0.99471750263154867788 },
	{ 0.99506469369355077248, 0.001867033179402012924, 0.99471972852647649876 },
	{ 0.99506680327835905775, 0.0018662361556288193602, 0.99472198532045230657 },
	{ 0.9950689048141559967, 0.0018654389029737897861, 0.99472423349321226205 },
	{ 0.99507100461426567506, 0.0018646415168043562523, 0.9947264770311150528 },
	{ 0.9950731027168350229, 0.0018638482314344831034, 0.99472872962892378013 },
	{ 0.99507519050064840993, 0.0018630501204725689792, 0.994730959166887585 },
	{ 0.99507729228440078284, 0.0018622573119398541305, 0.99473320911348184215 },
	{ 0.99507939509812137757, 0.0018614646178480571785, 0.99473545413911657054 },
	{ 0.99508148471298951687, 0.0018606730681654400604, 0.9947376937478811243 },
	{ 0.99508354281845823319, 0.0018598747283216899261, 0.99473989345491231617 },
	{ 0.99508566514435548012, 0.0018590870505567971827, 0.99474216161668593816 },
	{ 0.99508773881378898007, 0.0018582914572950783028, 0.99474437139451787893 },
	{ 0.99508981927338358009, 0.0018575018912550390719, 0.99474660245836044048 },
	{ 0.99509190623703713818, 0.0018567150908705175923, 0.99474884189546353142 },
	{ 0.99509399033966772219, 0.0018559267264601172522, 0.99475107099473714101 },
	{ 0.99509606666031569233, 0.0018551370650526461878, 0.99475328971803400613 },
	{ 0.99509815581742000479, 0.0018543514662977631652, 0.99475552688539237156 },
	{ 0.99510020232620888248, 0.0018535586196180755397, 0.99475771011293123713 },
	{ 0.99510229194107679973, 0.0018527753096815519681, 0.99475994636476217092 },
	{ 0.995104363550573634, 0.0018519900161024502924, 0.99476216644227666297 },
	{ 0.99510643079224214702, 0.0018512044745680265433, 0.99476437677323981124 },
	{ 0.99510848897400472346, 0.0018504175025221281103, 0.9947665735048070168 },
	{ 0.99511056691589916401, 0.0018496365576979091096, 0.99476880403459211344 },
	{ 0.99511262622299745395, 0.0018488526183363367811, 0.99477100318849220884 },
	{ 0.99511468402329028571, 0.0018480680114027431358, 0.99477320136964442199 },
	{ 0.99511675807419341933, 0.0018472892791029388998, 0.99477542053163170443 },
	{ 0.9951188206047109075, 0.0018465075713392669655, 0.9947776258844146513 },
	{ 0.99512086211624661836, 0.0018457255965467864612, 0.99477981174409479959 },
	{ 0.99512291881027725715, 0.001844944918751376681, 0.99478200675904848715 },
	{ 0.99512497130814103752, 0.0018441671401258886119, 0.99478421092927538094 },
	{ 0.99512704398575324571, 0.0018433894759413186563, 0.99478641986787397222 },
	{ 0.99512907599869260267, 0.0018426092940565532395, 0.99478859470307912094 },
	{ 0.99513114257278922903, 0.0018418349868055767984, 0.99479080791413876383 },
	{ 0.99513317973556991713, 0.001841058428883213683, 0.99479298965394591381 },
	{ 0.99513523755493649148, 0.0018402849417921492321, 0.99479519235551450151 },
	{ 0.99513727609100832705, 0.0018395075446363876297, 0.9947973698228607109 },
	{ 0.99513931828918955613, 0.0018387340384718371157, 0.99479955713212586677 },
	{ 0.99514135247650625793, 0.0018379602271315052548, 0.99480173459947207615 },
	{ 0.9951433916610763486, 0.0018371832495924428959, 0.99480390195787060659 },
	{ 0.99514543004456035291, 0.0018364130240675409934, 0.99480609292924515596 },
	{ 0.99514745999756337724, 0.0018356423789259394136, 0.9948082682985077696 },
	{ 0.99514949580612666047, 0.0018348682051893673659, 0.99481043601930219111 },
	{ 0.99515152812424201301, 0.00183409839928116449, 0.99481261543214416498 },
	{ 0.99515356418076084122, 0.001833330958485266185, 0.99481479797303762336 },
	{ 0.99515559129181418996, 0.0018325611716505493722, 0.994816965731979308 },
	{ 0.99515760137024422693, 0.0018317884284254520085, 0.99481911146104440302 },
	{ 0.99515963954391972734, 0.0018310223799940558275, 0.99482129051148993071 },
	{ 0.99516167556229118141, 0.0018302562743422005898, 0.99482346744477845313 },
	{ 0.99516368819656841893, 0.0018294881469007946879, 0.99482562045991518307 },
	{ 0.99516570729675757345, 0.0018287230902906876674, 0.99482778470933530546 },
	{ 0.99516771975937334815, 0.0018279563170668111129, 0.99482993831575006194 },
	{ 0.99516974435272664845, 0.0018271919471022119059, 0.9948320992845305355 },
	{ 0.99517174867096380719, 0.0018264261847731107918, 0.99483424444139079146 },
	{ 0.99517376899185605588, 0.0018256644469496247259, 0.99483640705049103392 },
	{ 0.99517576060715151609, 0.0018248983412977694881, 0.99483853828370649719 },
	{ 0.99517778747024965291, 0.0018241383391615390193, 0.99484070575654581781 },
	{ 0.99517981326523263785, 0.0018233781081434727572, 0.99484286758363305037 },
	{ 0.99518181899490787412, 0.0018226186400648594285, 0.99484501911103762062 },
	{ 0.99518379733505668572, 0.0018218545943495276316, 0.99484713760316390019 },
	{ 0.99518580371323039913, 0.001821094248890543256, 0.99484927764832975505 },
	{ 0.99518779319229522251, 0.001820334551930094134, 0.99485141361176965269 },
	{ 0.99518980147781765933, 0.0018195755034681802657, 0.99485355358064164744 },
	{ 0.99519180121841821496, 0.001818818591236735175, 0.9948556953805681724 },
	{ 0.99519381003799822771, 0.0018180643492933757852, 0.9948578494638199432 },
	{ 0.99519580272140883981, 0.0018173070937391767876, 0.99485997764527722698 },
	{ 0.99519777270737075359, 0.0018165465193983564018, 0.99486208236634643409 },
	{ 0.99519980405273822388, 0.0018157981711622727013, 0.99486425863206284781 },
	{ 0.99520178208771126194, 0.0018150401526686203366, 0.99486637002885214276 },
	{ 0.99520374925079713169, 0.0018142839270826828426, 0.99486847757279728288 },
	{ 0.99520575271072742041, 0.0018135299330946457429, 0.99487060878693900356 },
	{ 0.99520774520340316016, 0.0018127819472548022291, 0.99487275203645064714 },
	{ 0.99520972087326398103, 0.0018120279723402514093, 0.99487486282288850603 },
	{ 0.99521170577469197926, 0.0018112792617079273051, 0.99487699489533709674 },
	{ 0.99521368371429763666, 0.0018105240470167652516, 0.99487909978806765565 },
	{ 0.99521565400543532398, 0.0018097740012403980801, 0.99488120893418574564 },
	{ 0.99521764438095405847, 0.0018090247756239433326, 0.99488333751618629464 },
	{ 0.99521961501541456041, 0.001808277590870525529, 0.9948854531854366412 },
	{ 0.99522157859268489677, 0.0018075273925062676841, 0.99488755332886913418 },
	{ 0.99522354592743234036, 0.0018067789298292660869, 0.99488965734421941356 },
	{ 0.99522552371444994446, 0.001806032412647869817, 0.994891771544811232 },
	{ 0.99522750104370405477, 0.0018052852851149112871, 0.99489388204514683789 },
	{ 0.99522945613327307157, 0.001804539950489667411, 0.99489598094880282719 },
	{ 0.99523143756332677068, 0.0018037966185804879191, 0.99489809696137598838 },
	{ 0.99523337962570457282, 0.001803049014210370872, 0.99490017604767966297 },
	{ 0.99523535685959119146, 0.0018023065215345898671, 0.99490229061066803862 },
	{ 0.99523731721344232959, 0.0018015652304884477528, 0.99490439592301527227 },
	{ 0.99523928451004251006, 0.0018008195143934771932, 0.99490648769318723588 },
	{ 0.99524122909012058269, 0.0018000761061903523645, 0.99490856899201529639 },
	{ 0.99524319671097027928, 0.0017993349868055869868, 0.99491066875397826674 },
	{ 0.99524515099945298768, 0.0017985946494337612563, 0.99491276552140384126 },
	{ 0.9952470871681237119, 0.001797852519154220655, 0.99491483795106072652 },
	{ 0.99524905522766338173, 0.001797114928364425962, 0.99491694299637944976 },
	{ 0.99525099526825178131, 0.0017963741523024144911, 0.99491901662766613068 },
	{ 0.99525295449676731696, 0.0017956380683180398188, 0.99492111745774425291 },
	{ 0.99525489154281832072, 0.0017948971587416239545, 0.99492318336426877057 },
	{ 0.99525683728637903691, 0.0017941607505079814385, 0.99492526605546127705 },
	{ 0.99525879174652287507, 0.0017934259253737044968, 0.9949273606675826942 },
	{ 0.99526070424499701872, 0.0017926865226027086531, 0.99492940683304909033 },
	{ 0.99526266576233080041, 0.0017919515067335682612, 0.99493149896561727807 },
	{ 0.99526458344879320528, 0.0017912134772535882616, 0.99493355039536568452 },
	{ 0.99526654530944991262, 0.0017904855948683345759, 0.99493565484940627019 },
	{ 0.99526846579971472995, 0.0017897484999891844631, 0.99493770938813319571 },
	{ 0.99527038371505893721, 0.0017890106230970949201, 0.99493975288331160112 },
	{ 0.99527233912887724809, 0.0017882826262709235546, 0.99494184776246197277 },
	{ 0.99527426131668239595, 0.0017875489455458262299, 0.99494390438019875145 },
	{ 0.9952761986488356527, 0.001786819651722584357, 0.99494597782075067105 },
	{ 0.99527812438430918185, 0.0017860874587294207731, 0.99494803417145871727 },
	{ 0.99528006413879532843, 0.001785361159443532228, 0.99495011663376953237 },
	{ 0.99528199437561171159, 0.0017846302634474387177, 0.99495217016160164558 },
	{ 0.99528389405670303347, 0.0017838986426588648339, 0.99495420656144284433 },
	{ 0.99528580895843643539, 0.0017831713324782010651, 0.99495626275956305928 },
	{ 0.9952877457565321162, 0.0017824436408278106127, 0.99495832681595941516 },
	{ 0.99528964715423717813, 0.0017817144232985142934, 0.99496036096512929792 },
	{ 0.99529155408325320487, 0.0017809873801466590947, 0.99496240484177711494 },
	{ 0.99529348575058107507, 0.0017802632552382121039, 0.9949644693750108182 },
	{ 0.99529538844528320229, 0.0017795345717665327079, 0.99496649856507424214 },
	{ 0.9952972986167919478, 0.0017788135176893843815, 0.99496855537354600418 },
	{ 0.99529921817245592397, 0.0017780890303846972039, 0.99497060432374129224 },
	{ 0.99530112620773414367, 0.0017773635512587208658, 0.99497263961732029802 },
	{ 0.99530303655090412995, 0.0017766425162550588193, 0.99497468801438437858 },
	{ 0.99530494445266792791, 0.0017759191542860651956, 0.9949767251199447271 },
	{ 0.9953068533653266492, 0.0017751985198256158959, 0.99497876686036201832 },
	{ 0.99530873279037546109, 0.0017744738799330380449, 0.99498077995240297167 },
	{ 0.99531064212265074609, 0.0017737544280287413558, 0.99498282478272503937 },
	{ 0.99531253661575369573, 0.0017730355483290345837, 0.9949848557656961745 },
	{ 0.99531444745483443892, 0.0017723154669996891378, 0.99498689142167151545 },
	{ 0.99531634940567048631, 0.0017715991622206366668, 0.99498893020569856294 },
	{ 0.99531823270263708459, 0.0017708790045973458842, 0.99499094671189369787 },
	{ 0.99532011846008316969, 0.0017701611548659008325, 0.99499296842515061456 },
	{ 0.99532203446807865355, 0.001769444182514826611, 0.99499500604569501849 },
	{ 0.99532390286865246587, 0.0017687253028151200557, 0.99499700796067291897 },
	{ 0.99532579364242557141, 0.0017680082350966142175, 0.99499902572571796711 },
	{ 0.99532768216552724994, 0.0017672956305739093846, 0.99500105405747452103 },
	{ 0.995329575495147445, 0.0017665817290541344781, 0.99500307773530027866 },
	{ 0.99533146401824912353, 0.0017658661109205898206, 0.99500509233414657917 },
	{ 0.99533333558502168348, 0.0017651531440016445841, 0.99500709955155375308 },
	{ 0.99533521911087019518, 0.0017644387465712246636, 0.99500911113678924824 },
	{ 0.99533709409179671468, 0.0017637274008986173444, 0.99501112390458090751 },
	{ 0.99533896863403314992, 0.0017630122214552582105, 0.99501311899125099991 },
	{ 0.99534084721984872335, 0.001762302916645688269, 0.99501513536393182413 },
	{ 0.9953427193969729414, 0.0017615913230177586597, 0.99501713998734497846 },
	{ 0.99534459271850628248, 0.0017608801108595559509, 0.99501913995682733649 },
	{ 0.99534646134796200823, 0.0017601693946119976054, 0.99502113637864142426 },
	{ 0.99534833589019855449, 0.0017594627600905135816, 0.99502315130173712987 },
	{ 0.99535021615448071586, 0.0017587543708082872471, 0.99502515546738656838 },
	{ 0.99535206431808553873, 0.0017580433684584338347, 0.99502712966858897214 },
	{ 0.99535392459335414461, 0.0017573363524672233442, 0.99502912666260756591 },
	{ 0.99535580466690165569, 0.0017566303664442743573, 0.99503113155304967474 },
	{ 0.99535765622558691756, 0.00175592333137957737, 0.9950331175035197484 },
	{ 0.99535952884140121988, 0.001755219348072692984, 0.99503511901795471672 },
	{ 0.99536138041916022434, 0.0017545115691420291263, 0.99503709510743243438 },
	{ 0.99536325271072523257, 0.0017538091689345098809, 0.99503909992158046105 },
	{ 0.99536509324493560591, 0.0017531040030714728842, 0.9950410743898117083 },
	{ 0.99536697129669349238, 0.0017524027091261606959, 0.99504307939469460731 },
	{ 0.99536881072464156173, 0.0017516968184706433256, 0.99504504283845074397 },
	{ 0.99537065665664847813, 0.0017509951430556044537, 0.99504702106415887641 },
	{ 0.99537251176300234334, 0.0017502945166823135822, 0.99504900606095469939 },
	{ 0.99537437383117866041, 0.001749594710468934701, 0.99505099851548362011 },
	{ 0.9953762047714254102, 0.0017488926154371965856, 0.99505296136796173023 },
	{ 0.99537805795135703146, 0.0017481939154860249783, 0.99505494638383085171 },
	{ 0.99537990506592000095, 0.0017474925833937400132, 0.99505691305100629762 },
	{ 0.99538172681274617037, 0.0017467908316847555877, 0.9950588663285940827 },
	{ 0.99538357333603111332, 0.0017460938674208397944, 0.99506084289490859263 },
	{ 0.99538542468490798232, 0.0017453960829970115772, 0.9950628193658557219 },
	{ 0.99538726088943663139, 0.0017446981078383203435, 0.99506478382050644882 },
	{ 0.99538910998764207338, 0.0017440028029677152443, 0.99506675926148535627 },
	{ 0.99539093070449990996, 0.0017433042174574615336, 0.99506870670258618095 },
	{ 0.99539276885452432353, 0.0017426080352064851706, 0.99507067378937796853 },
	{ 0.99539462027969516367, 0.0017419176512953526634, 0.99507265888154095013 },
	{ 0.99539643561782997772, 0.0017412192565199621861, 0.99507459384858187867 },
	{ 0.99539828792038109739, 0.0017405304366347083226, 0.9950765830224708175 },
	{ 0.99540011138382111788, 0.0017398354369398841366, 0.99507853366791765293 },
	{ 0.99540193293991252599, 0.0017391392928358803335, 0.99508047012269051912 },
	{ 0.99540374064865277948, 0.0017384463912245523651, 0.99508241119324725155 },
	{ 0.99540556598129437127, 0.0017377537184950601901, 0.99508436073243178299 },
	{ 0.99540740392151028093, 0.0017370658332106364303, 0.99508633253037481747 },
	{ 0.99540922370376727635, 0.0017363756591078534364, 0.99508828155457529352 },
	{ 0.99541104361953869351, 0.0017356818419691818611, 0.99509021682679210663 },
	{ 0.99541286050262578478, 0.0017349949103590747018, 0.99509216764390040488 },
	{ 0.99541469197692988846, 0.0017343074637648364655, 0.99509412645279926579 },
	{ 0.99541650113525492749, 0.0017336184531447193687, 0.99509606424271623837 },
	{ 0.9954183174652110333, 0.0017329318839308521794, 0.99509801057755509213 },
	{ 0.99542012036743265924, 0.0017322436362501884496, 0.99509994104325338871 },
	{ 0.99542192305984600331, 0.0017315536147352959123, 0.99510186363160180179 },
	{ 0.99542373988571264398, 0.0017308705168959407847, 0.99510381359040300797 },
	{ 0.99542556985321117846, 0.001730186026692083533, 0.9951057649797157012 },
	{ 0.99542735215606747978, 0.0017294971686598568927, 0.99510767377793341026 },
	{ 0.9954291494888309888, 0.0017288100653883727801, 0.99510959470688831185 },
	{ 0.99543096427383470637, 0.0017281277495619568659, 0.9951115347284031909 },
	{ 0.99543275914611861754, 0.0017274421149489197803, 0.99511344991623873479 },
	{ 0.99543458177032506651, 0.0017267635184523375674, 0.99511540506302820219 },
	{ 0.99543638062896755425, 0.0017260806876417905762, 0.99511732751786219353 },
	{ 0.9954381707519533995, 0.0017253963690993100611, 0.99511924100815762895 },
	{ 0.9954399762290956355, 0.0017247156172987730075, 0.99512116966187458278 },
	{ 0.99544178103866576279, 0.0017240387374159605455, 0.99512310996949171482 },
	{ 0.99544355159225472729, 0.0017233539992567810037, 0.99512499862610781509 },
	{ 0.99544535129013056451, 0.0017226742964979917336, 0.99512692176758732465 },
	{ 0.99544713735046364, 0.0017219952613112239972, 0.9951288393968291679 },
	{ 0.99544893857421845595, 0.0017213189154860286754, 0.99513076681076950702 },
	{ 0.99545072930755573726, 0.0017206393271681575188, 0.99513267663895543791 },
	{ 0.9954525100273128313, 0.0017199607115980892428, 0.99513458351075090302 },
	{ 0.9954542991203303437, 0.0017192848998305110611, 0.99513649833619022278 },
	{ 0.99545610515060367618, 0.0017186104613539487235, 0.99513842521607298597 },
	{ 0.99545786101760813658, 0.0017179302626845153069, 0.99514030391632934958 },
	{ 0.9954596417182918211, 0.0017172524672743590211, 0.99514220424591925962 },
	{ 0.99546141333999593748, 0.0017165794783827574305, 0.99514411090790644288 },
	{ 0.99546320596160842165, 0.0017159047919508728028, 0.99514602067887181214 },
	{ 0.99546498834075869411, 0.0017152314215895447455, 0.99514792482315883593 },
	{ 0.99546674645843435947, 0.0017145585089918887085, 0.99514981904923294209 },
	{ 0.99546853784027011791, 0.0017138865119215762785, 0.99515173128067813124 },
	{ 0.99547031159820464907, 0.0017132113867995059104, 0.99515361841141547483 },
	{ 0.99547208281936550023, 0.0017125402861830508073, 0.99515551708161187339 },
	{ 0.99547383099975506049, 0.0017118658286330021897, 0.99515738771378325911 },
	{ 0.99547563342513945006, 0.0017112014037367619893, 0.99515932002960949543 },
	{ 0.99547738822402853653, 0.0017105273848768986784, 0.99516119178711670568 },
	{ 0.99547915011825438558, 0.0017098574095961371292, 0.99516307689606442466 },
	{ 0.99548091885986200733, 0.0017091904669997014677, 0.99516497556626071219 },
	{ 0.99548268489303459727, 0.0017085219603773867288, 0.9951668635171577737 },
	{ 0.99548443618240223252, 0.0017078529006239687865, 0.99516873893677437746 },
	{ 0.9954861953681932718, 0.0017071847182509218913, 0.99517062232910824537 },
	{ 0.9954879649681078746, 0.0017065181761976994101, 0.99517251186310473621 },
	{ 0.99548970755996590842, 0.0017058482772108829809, 0.99517437210022652305 },
	{ 0.99549149026336547497, 0.0017051859503981387813, 0.99517627733170233029 },
	{ 0.99549322907867310306, 0.0017045184546705996996, 0.99517813836991020349 },
	{ 0.99549499301376220828, 0.0017038547927138128664, 0.99518002906738933788 },
	{ 0.99549675097885004238, 0.0017031899672743597025, 0.99518190483032875626 },
	{ 0.99549850373687620575, 0.0017025262671706000925, 0.99518378190933876049 },
	{ 0.995500250524901098, 0.0017018616324660103788, 0.99518564634262740576 },
	{ 0.99550200097503538377, 0.0017012000495192330495, 0.99518752313553515698 },
	{ 0.99550375588836548246, 0.0017005407172438426113, 0.99518940774857223008 },
	{ 0.99550547681274292877, 0.0016998717337843702226, 0.99519123815476107087 },
	{ 0.99550722073974495796, 0.0016992114859816359607, 0.99519310720383336033 },
	{ 0.99550897521438486137, 0.0016985526305434036059, 0.99519498351990376417 },
	{ 0.99551070613326908543, 0.0016978899031874466596, 0.995196834220282045 },
	{ 0.9955124368232716181, 0.0016972283202406693303, 0.99519868843018199911 },
	{ 0.99551418631973143114, 0.0016965716582533648098, 0.99520055816589969577 },
	{ 0.99551593524398673818, 0.0016959125930067829417, 0.99520242603241571011 },
	{ 0.995517666010283242, 0.0016952557402846151879, 0.99520428626953727491 },
	{ 0.99551939505996578372, 0.0016945969420668418898, 0.99520613586365347381 },
	{ 0.99552114200057861826, 0.0016939409285780724062, 0.99520800182282087576 },
	{ 0.99552285228195058764, 0.00169327877342670516, 0.99520982547699565757 },
	{ 0.99552460170211665158, 0.001692627986073189832, 0.99521170154511084949 },
	{ 0.99552635762634145156, 0.0016919766074415978734, 0.99521358472763632452 },
	{ 0.99552804776611192317, 0.0016913167411085900781, 0.99521539922653767807 },
	{ 0.99552977109374862774, 0.0016906578665968714434, 0.99521722814499458121 },
	{ 0.99553152501525732365, 0.0016900089865919884491, 0.99521910871445251612 },
	{ 0.99553323708953711524, 0.0016893546515700159395, 0.99522094545303885216 },
	{ 0.99553495919647061463, 0.0016887000495192348599, 0.99522278413712073064 },
	{ 0.99553668317260601839, 0.0016880476981398406713, 0.99522462774216213788 },
	{ 0.99553840161743034631, 0.0016873967581984346698, 0.99522647191940816214 },
	{ 0.99554011735381964243, 0.0016867418128248996834, 0.99522829759537245753 },
	{ 0.99554186002197153638, 0.001686093505024606606, 0.9952301594346669722 },
	{ 0.99554357682647598438, 0.001685443060993844968, 0.99523199457108058041 },
	{ 0.99554526669921772353, 0.001684789412617380272, 0.9952338083451895967 },
	{ 0.99554700726928624377, 0.0016841447287794897129, 0.99523567129074641535 },
	{ 0.99554870297851472127, 0.0016834924155470678674, 0.99523748418747504108 },
	{ 0.99555041839065450127, 0.0016828448516127416604, 0.99523931987701974577 },
	{ 0.99555212108077895117, 0.0016821954756972145196, 0.99524114227234461438 },
	{ 0.99555382598342789802, 0.001681546023487742042, 0.99524296176849946782 },
	{ 0.99555554198684592659, 0.0016809036284682107171, 0.99524481265961273202 },
	{ 0.99555726005020039882, 0.0016802552062269999599, 0.99524663738190277673 },
	{ 0.99555896150054823401, 0.0016796093970534158469, 0.99524845777451143025 },
	{ 0.99556066832961909174, 0.0016789630538222148105, 0.99525028163849471596 },
	{ 0.99556234973373303188, 0.001678315661549265557, 0.99525208457886338298 },
	{ 0.99556404427947886582, 0.0016776682883498025833, 0.99525389234482408707 },
	{ 0.99556575622024434669, 0.0016770252257582495079, 0.99525572273193962936 },
	{ 0.99556744780959982588, 0.0016763816100355932292, 0.99525753272949835093 },
	{ 0.99556915463867090565, 0.0016757405692335910347, 0.99525936235367440386 },
	{ 0.99557085069122219778, 0.0016750983649489229431, 0.99526117780625000808 },
	{ 0.99557254075469880927, 0.0016744532233473601469, 0.99526297895371096391 },
	{ 0.99557422608795065333, 0.0016738106757399381485, 0.99526478300034182389 },
	{ 0.99557591632308861662, 0.0016731697112318812907, 0.99526659351288448985 },
	{ 0.99557760711135756537, 0.0016725308638808067136, 0.99526840858399034939 },
	{ 0.99557929259719735171, 0.0016718890792128376487, 0.99527021003662696774 },
	{ 0.99558099543990974389, 0.0016712529021498492062, 0.99527203258453955659 },
	{ 0.99558268014373674237, 0.0016706114798781205449, 0.99527383138596170475 },
	{ 0.99558435538711453905, 0.0016699717742201614177, 0.99527562503754241074 },
	{ 0.99558604358138935719, 0.0016693326216933059274, 0.9952774283593806004 },
	{ 0.99558772792281990949, 0.0016686941176649856908, 0.9952792257684383026 },
	{ 0.99558941596450678535, 0.0016680588561293412889, 0.9952810364144953903 },
	{ 0.99559109883727880952, 0.0016674217444655229595, 0.99528283311783405374 },
	{ 0.99559277331771689479, 0.0016667829161879348793, 0.99528461811005197735 },
	{ 0.99559444556655707359, 0.0016661488753554154311, 0.99528641624390201681 },
	{ 0.99559613637389954288, 0.0016655155020949172998, 0.9952882248109490293 },
	{ 0.99559780034484679501, 0.0016648781424757766803, 0.99529000535904477154 },
	{ 0.99559947408141902248, 0.0016642441397902297921, 0.99529179536758971558 },
	{ 0.99560113439025688109, 0.0016636076956984329964, 0.99529357316910327391 },
	{ 0.99560280953826707506, 0.0016629752570387647519, 0.99529536344467695042 },
	{ 0.99560449635925085676, 0.001662346404194526249, 0.99529717378555826457 },
	{ 0.99560616143646052389, 0.0016617138129469677648, 0.99529895536362233965 },
	{ 0.99560780511321844699, 0.001661075995564155125, 0.99530070646225510256 },
	{ 0.99560949809493859419, 0.0016604484587904731925, 0.99530251754700260758 },
	{ 0.99561114381255944039, 0.0016598136740919864403, 0.99530427587448666582 },
	{ 0.99561280459823453537, 0.0016591846495863707672, 0.99530606178223202107 },
	{ 0.99561446574630585449, 0.0016585536223646909267, 0.99530783447205140035 },
	{ 0.99561615056457375417, 0.0016579263907667901243, 0.99530963354050228098 },
	{ 0.99561780358733997787, 0.0016572973853346609479, 0.99531140626846870134 },
	{ 0.99561945321502565154, 0.0016566670447584889211, 0.99531317064224800184 },
	{ 0.99562112580718875599, 0.0016560398322340748323, 0.99531495431839556165 },
	{ 0.99562277854385250464, 0.0016554116469618580798, 0.99531672260223968962 },
	{ 0.99562443787994259203, 0.001654788153767278126, 0.99531850637375451907 },
	{ 0.99562609551849245992, 0.0016541623145338796644, 0.99532028165756802895 },
	{ 0.99562773637237433899, 0.0016535337287184499484, 0.99532203405319796818 },
	{ 0.99562937352599978347, 0.0016529034262892502646, 0.99532377969681351537 },
	{ 0.99563102864684938087, 0.0016522804099318283942, 0.9953255544465693383 },
	{ 0.99563268817367422958, 0.0016516565352675217568, 0.99532732818543057096 },
	{ 0.99563434459152089229, 0.001651032221913029379, 0.99532909767090416153 },
	{ 0.99563597255172586742, 0.0016504040175673263466, 0.9953308351892146133 },
	{ 0.99563763371887070708, 0.001649785102009464861, 0.99533261892258251269 },
	{ 0.99563925975265366031, 0.001649158557057072089, 0.99533435390411928445 },
	{ 0.99564088918151727459, 0.0016485327750441324673, 0.99533609327255812005 },
	{ 0.99564253385009648945, 0.0016479128867384683181, 0.99533785879074676561 },
	{ 0.99564419141235238619, 0.0016472944480177651328, 0.99533963323532692602 },
	{ 0.99564580584945561181, 0.0016466700011488685784, 0.99534136135040873761 },
	{ 0.99564745320739622692, 0.0016460507804152261797, 0.99534312360703114386 },
	{ 0.99564911227645747083, 0.0016454352599379309854, 0.9953449045556700403 },
	{ 0.99565072410049315632, 0.0016448105269667395809, 0.99534662013947139414 },
	{ 0.99565235835494858563, 0.0016441912108656655655, 0.99534836997925413282 },
	{ 0.99565398717346065283, 0.0016435732108351479037, 0.99535011403977069477 },
	{ 0.99565561721267592521, 0.0016429529601332435677, 0.99535185588776264876 },
	{ 0.99565726193847547965, 0.0016423351126906165793, 0.99535360780655546264 },
	{ 0.99565888194503671116, 0.001641719287037540255, 0.99535534809052150784 },
	{ 0.99566052031936536082, 0.0016411035567518957642, 0.99535710235535301837 },
	{ 0.99566215651931655461, 0.0016404906111952550878, 0.99535885696350723251 },
	{ 0.99566376372756859592, 0.0016398688155409581711, 0.99536056762634905759 },
	{ 0.99566539832534695087, 0.0016392541152235754007, 0.99536231468140279333 },
	{ 0.99566701363983067807, 0.0016386386328932529832, 0.99536404195725125543 },
	{ 0.99566862065734773601, 0.0016380231314894442857, 0.99536577028214123786 },
	{ 0.99567024949493321273, 0.0016374088507887607589, 0.99536750471054713518 },
	{ 0.99567188283386143244, 0.0016367980033156163001, 0.99536925470291770512 },
	{ 0.99567348441543501725, 0.0016361821395155674158, 0.99537097122131990012 },
	{ 0.99567510627212452157, 0.0016355719405409579938, 0.99537270812927891583 },
	{ 0.99567671657028111731, 0.0016349565917250399698, 0.99537442371308026967 },
	{ 0.99567833335342326162, 0.001634345744251895511, 0.99537615760742836901 },
	{ 0.99567993796768106129, 0.0016337347823378331555, 0.99537787940918620588 },
	{ 0.99568156299056931324, 0.0016331213408705481157, 0.99537960025726979207 },
	{ 0.99568316426696701349, 0.0016325107413527261638, 0.99538131776749327884 },
	{ 0.99568478124084391911, 0.0016319032889601479963, 0.99538305528580373061 },
	{ 0.99568640834274202422, 0.0016312979537245523264, 0.99538479927002632142 },
	{ 0.99568801394882100464, 0.0016306859999892005936, 0.99538650939881045954 },
	{ 0.9956896067375172743, 0.0016300754195448647049, 0.99538821220337581064 },
	{ 0.99569119796218763518, 0.0016294651061293373862, 0.99538991496979423168 },
	{ 0.99569279839935187493, 0.0016288593512770422559, 0.99539163598953905865 },
	{ 0.99569441268386726929, 0.0016282540541884193627, 0.99539336330353445081 },
	{ 0.99569602260055423137, 0.0016276459532973059415, 0.99539507614075362074 },
	{ 0.99569760610046265104, 0.0016270375663038974534, 0.99539677366196321895 },
	{ 0.99569921250762805087, 0.0016264326697584868733, 0.99539849199234664567 },
	{ 0.9957007899612413393, 0.0016258220130202056478, 0.9954001707643193031 },
	{ 0.99570240796508657777, 0.0016252213889357330565, 0.9954019056504886942 },
	{ 0.9957040015739427874, 0.0016246176940199615838, 0.9954036159890812252 },
	{ 0.99570559478225595385, 0.0016240129500624418939, 0.99540531715332669638 },
	{ 0.99570719230117687992, 0.0016234101516005277482, 0.9954070268243472297 },
	{ 0.9957087824386586794, 0.0016228051978346583282, 0.99540872404038105437 },
	{ 0.99571036805572399331, 0.0016222025519606346391, 0.99541042272507340716 },
	{ 0.99571196904601932953, 0.0016216008597609277674, 0.99541213418900165166 },
	{ 0.99571356557311907487, 0.0016210019522902244932, 0.99541384698807378051 },
	{ 0.99571515420379530514, 0.0016204010230299705549, 0.99541554677902832626 },
	{ 0.995716736959837867, 0.0016197991782423727929, 0.99541723703323969907 },
	{ 0.99571831149520773074, 0.0016191975432631245443, 0.99541892223297723241 },
	{ 0.99571990348281758099, 0.00161859867393939383, 0.99542062728821401052 },
	{ 0.99572146872939959472, 0.0016179977828261124517, 0.99542230606018666794 },
	{ 0.9957230507225025562, 0.0016173943358656630524, 0.99542398654877306541 },
	{ 0.9957246326011647275, 0.0016167993956801162032, 0.99542568988739588143 },
	{ 0.99572621970596209007, 0.0016162018996474013331, 0.99542738487183191065 },
	{ 0.99572779292526147898, 0.0016156010466810925147, 0.9954290578073177187 },
	{ 0.99572936505737208446, 0.0016150063163038951789, 0.9954307532304439432 },
	{ 0.99573093558730996211, 0.0016144058638807993241, 0.99543242233215889492 },
	{ 0.99573251975479049047, 0.0016138098555800179778, 0.99543411636292056244 },
	{ 0.99573408233108451348, 0.0016132134658095101647, 0.99543579246460500709 },
	{ 0.99573565066757141473, 0.0016126167327162484449, 0.99543746868073046397 },
	{ 0.99573723033370908908, 0.00161202400505511571, 0.99543916095673135036 },
	{ 0.99573881032409594649, 0.001611428778767273794, 0.99544084680496736084 },
	{ 0.99574037452163632889, 0.0016108330947157602914, 0.99544251686035656324 },
	{ 0.99574192176284737066, 0.0016102404433485726764, 0.99544418495117681367 },
	{ 0.99574349265518136143, 0.0016096439772841195266, 0.99544585655151862635 },
	{ 0.9957450559371944232, 0.0016090524131056526888, 0.99544753274857067371 },
	{ 0.99574662652435264043, 0.001608460829853699571, 0.99544921167313116239 },
	{ 0.99574820071639991159, 0.0016078698378798226502, 0.99545089443146250741 },
	{ 0.9957497553009031499, 0.0016072795325514533261, 0.99545256704269891035 },
	{ 0.99575129857482880258, 0.0016066841346022344567, 0.99545421773849962488 },
	{ 0.99575287959518399283, 0.0016060957366224981168, 0.99545589954315649717 },
	{ 0.99575443828048693096, 0.0016055059844252324297, 0.99545757083832242529 },
	{ 0.99575597072067267845, 0.0016049131804701541413, 0.99545921558319550027 },
	{ 0.99575753781738285397, 0.0016043249732252814685, 0.99546088922440012503 },
	{ 0.99575909030380260756, 0.0016037343627211310144, 0.99546254463135197543 },
	{ 0.9957606505912782735, 0.0016031459075209356178, 0.99546421295105413929 },
	{ 0.99576220441284202245, 0.0016025589972731328018, 0.99546587785660223258 },
	{ 0.99576376286926293613, 0.0016019729834791873128, 0.99546755044876544805 },
	{ 0.99576529698791527156, 0.0016013800269362185678, 0.99546917795120659633 },
	{ 0.995766862043762635, 0.0016007979422804569439, 0.99547086065231749075 },
	{ 0.99576838420333890767, 0.0016002064925429080027, 0.99547248767792173574 },
	{ 0.99576994479599034715, 0.0015996250563856814157, 0.99547416576324887494 },
	{ 0.99577148143234284206, 0.0015990370589491578225, 0.99547580463348805946 },
	{ 0.99577302411499057921, 0.001598448851704284716, 0.99547744829117212895 },
	{ 0.99577459075393703891, 0.0015978678160902710925, 0.9954791247171059787 },
	{ 0.99577610429229757028, 0.0015972815161940309703, 0.99548075109421163553 },
	{ 0.99577765382232685809, 0.001596697867512390269, 0.99548240407883081815 },
	{ 0.99577920035781863906, 0.0015961136656996461475, 0.99548405502258696664 },
	{ 0.99578073970260616576, 0.0015955318862196656536, 0.99548570407806802329 },
	{ 0.99578227221908566236, 0.001594948008656189159, 0.99548734584747722298 },
	{ 0.99578381488265987898, 0.0015943678694960330793, 0.99548899898468423686 },
	{ 0.99578535724105832205, 0.001593786204456970482, 0.99549064632355144244 },
	{ 0.99578689948501586393, 0.0015932035857435915011, 0.99549228889404706155 },
	{ 0.99578842799606315239, 0.0015926232558485719712, 0.99549392589508489682 },
	{ 0.99578995023193350722, 0.0015920433264967654048, 0.99549556436478114918 },
	{ 0.99579151215972894207, 0.0015914644461867068388, 0.99549722379623872826 },
	{ 0.99579301959457378057, 0.0015908801680800173806, 0.99549883071838851656 },
	{ 0.99579454944076517542, 0.0015903024703261112085, 0.99550047286926746093 },
	{ 0.99579607037963846494, 0.0015897238761183477094, 0.99550210264145377881 },
	{ 0.99579759688796976036, 0.0015891449385878303035, 0.99550373760162846892 },
	{ 0.99579912352981547752, 0.0015885670882460334579, 0.99550536830841562796 },
	{ 0.99580064711990323723, 0.0015879898482557990892, 0.99550699993073021865 },
	{ 0.99580215991439779977, 0.0015874105101820685029, 0.99550861671387247398 },
	{ 0.99580370213928193213, 0.0015868387824293829231, 0.99551027452408391571 },
	{ 0.99580521405639610411, 0.0015862585669752812898, 0.99551188379227251168 },
	{ 0.99580673154296817096, 0.001585681632160828268, 0.99551350229202850706 },
	{ 0.99580825848998966165, 0.0015851092749830941481, 0.99551514703690158203 },
	{ 0.99580977471771181531, 0.0015845310050245982759, 0.9955167561906492768 },
	{ 0.99581128823699882613, 0.0015839592581984264161, 0.99551838842331541457 },
	{ 0.99581279366912767159, 0.0015833803397413950733, 0.99551998845993661114 },
	{ 0.99581431127014086169, 0.0015828073340651254829, 0.99552161325394306068 },
	{ 0.9958158356231683328, 0.0015822363501784067735, 0.9955232468599002349 },
	{ 0.99581733581008857747, 0.0015816628295180063229, 0.99552485668122003837 },
	{ 0.99581884635391193505, 0.0015810878020521860685, 0.99552646442352965561 },
	{ 0.99582035964431736552, 0.0015805194884535530599, 0.99552809322296820227 },
	{ 0.99582187499465923963, 0.0015799453002211312925, 0.99552970409332963708 },
	{ 0.99582339019241317146, 0.0015793749266859750599, 0.99553132549225542558 },
	{ 0.99582488271179181449, 0.0015788034659620980502, 0.99553292928635339631 },
	{ 0.99582640517654408274, 0.0015782362776991588123, 0.99553455680786839821 },
	{ 0.99582789605560295687, 0.0015776640540358288691, 0.99553615373551129775 },
	{ 0.99582938411178600902, 0.0015770925170180067395, 0.99553774715363263503 },
	{ 0.99583090074005142789, 0.0015765244132277236779, 0.99553936666428344271 },
	{ 0.99583239526214628601, 0.0015759548789259659324, 0.99554096692978633065 },
	{ 0.99583389102401764781, 0.00157538532555072169, 0.995542566565864262 },
	{ 0.99583538562240636605, 0.001574819682240174816, 0.99554417346894052976 },
	{ 0.99583691031875654076, 0.001574250567555116314, 0.99554578994690690052 },
	{ 0.99583839606704760428, 0.0015736833983656633561, 0.99554738464295178257 },
	{ 0.99583987185897870908, 0.0015731152755018937978, 0.99554896900116707226 },
	{ 0.99584138381424003317, 0.0015725519591566787178, 0.99555058868347912071 },
	{ 0.99584286021652279608, 0.001571981089710877905, 0.99555215846955091852 },
	{ 0.99584437701644967778, 0.0015714184218641980787, 0.99555377948700707336 },
	{ 0.99584585750045850894, 0.0015708491927382214632, 0.99555535793244165355 },
	{ 0.99584735690536563268, 0.0015702880507704479376, 0.99555696979462438012 },
	{ 0.99584886182251053377, 0.0015697255164381725048, 0.99555857606827558026 },
	{ 0.99585032212677082608, 0.0015691583853956921069, 0.99556014478623211517 },
	{ 0.99585179803314294311, 0.001568593581318543503, 0.9955617230790788641 },
	{ 0.99585330399932947554, 0.0015680322867628795208, 0.99556333173691580196 },
	{ 0.99585479150238109813, 0.0015674709922072153218, 0.99556492696701825995 },
	{ 0.99585625766220176036, 0.0015669028884169320433, 0.99556648296295946476 },
	{ 0.99585774878921595743, 0.0015663426238295297815, 0.99556808128296692129 },
	{ 0.99585924437942596743, 0.0015657840758558970538, 0.9955696859735186921 },
	{ 0.99586072102966394226, 0.0015652220374342659844, 0.99557126535355422448 },
	{ 0.99586218993606667738, 0.0015646604949232794952, 0.99557283988892419924 },
	{ 0.99586367133560282916, 0.0015641022521254276806, 0.99557442840515952831 },
	{ 0.99586513282241928557, 0.0015635361510512087863, 0.99557598266541336152 },
	{ 0.99586661635818574112, 0.0015629805022474977695, 0.99557757774292798825 },
	{ 0.995868090223694713, 0.0015624209433790898181, 0.99557915277420849787 },
	{ 0.99586957780304041776, 0.0015618626242872926668, 0.99558073984085893038 },
	{ 0.99587104524078451373, 0.0015613049155470579924, 0.99558231225907189987 },
	{ 0.99587253741684034214, 0.0015607492476698604789, 0.99558391220032549374 },
	{ 0.99587399194183412465, 0.0015601872473952021862, 0.99558546102463563177 },
	{ 0.99587546296539375401, 0.0015596311408278191492, 0.99558703657090019679 },
	{ 0.99587693238678054453, 0.0015590748053786003188, 0.99558860853134922841 },
	{ 0.99587840627136303695, 0.0015585190421339711886, 0.99559018693863687854 },
	{ 0.9958798809951791009, 0.0015579643470045767724, 0.99559176702439133866 },
	{ 0.99588133752288920952, 0.0015574059516188345012, 0.99559332212387874339 },
	{ 0.99588281117858989955, 0.0015568519431349476818, 0.99559489633499942407 },
	{ 0.9958842644065868388, 0.0015562965422865589551, 0.99559645175873601186 },
	{ 0.99588573413314940286, 0.0015557447844740588099, 0.99559802890717352675 },
	{ 0.99588717833938733559, 0.0015551858168837268386, 0.99559956764160950637 },
	{ 0.99588865430298001424, 0.0015546341925856310869, 0.99560114484726736084 },
	{ 0.99589012122574005481, 0.0015540818053480821848, 0.99560271537720512747 },
	{ 0.99589156978073289928, 0.0015535252791639999042, 0.99560425922333550819 },
	{ 0.99589303880157642457, 0.001552977202534361334, 0.99560583673416913619 },
	{ 0.99589448337021047042, 0.0015524248534437852087, 0.99560738693177042169 },
	{ 0.99589594224395916466, 0.0015518716651198105963, 0.99560894334732830124 },
	{ 0.99589737733307059919, 0.0015513188391920761707, 0.99561048433243570788 },
	{ 0.99589883336487006193, 0.0015507660514113145219, 0.99561203657090013852 },
	{ 0.99590031527939026912, 0.0015502204161879256424, 0.9956136213296585824 },
	{ 0.99590174212875559601, 0.0015496645385023786155, 0.99561513973175819192 },
	{ 0.99590320207061966418, 0.0015491196662184426695, 0.99561671182572175631 },
	{ 0.99590464868011685518, 0.0015485670691725440373, 0.9956182516664199289 },
	{ 0.99590609570923060989, 0.001548021071552914971, 0.99561981046616354618 },
	{ 0.99590755654754847814, 0.0015474745398756689814, 0.99562137422501362227 },
	{ 0.99590898824157925162, 0.0015469240409132665667, 0.99562290372788231352 },
	{ 0.99591044049682830863, 0.0015463758689161959461, 0.99562445440232083538 },
	{ 0.99591188237610084322, 0.0015458273917433441955, 0.9956259934800795186 },
	{ 0.99591332156601175551, 0.0015452809172865570458, 0.99562753776489998359 },
	{ 0.99591475707473975376, 0.001544732783436459202, 0.99562907321869631438 },
	{ 0.99591622413101421607, 0.0015441914778944669344, 0.9956306437295606715 },
	{ 0.99591765876236182375, 0.0015436449080702479512, 0.99563217784821289591 },
	{ 0.99591908635559311946, 0.0015430962210890464704, 0.99563370218216673546 },
	{ 0.99592056703033671194, 0.0015425553351637534463, 0.99563527868210566218 },
	{ 0.99592197440567253874, 0.0015420068389174154157, 0.99563678806244626518 },
	{ 0.99592341624679814327, 0.0015414654952284503713, 0.99563833587586181295 },
	{ 0.99592484042587536841, 0.0015409194594618487451, 0.99563985877930416546 },
	{ 0.99592626876297263294, 0.0015403762084242509332, 0.99564139202057611033 },
	{ 0.99592769151153848206, 0.0015398300772902172567, 0.99564290777146113864 },
	{ 0.9959291320747404308, 0.0015392879515883129988, 0.99564444705902821475 },
	{ 0.99593057351532277011, 0.0015387466269728344512, 0.99564598821579708421 },
	{ 0.9959319867080717037, 0.0015382021170851389088, 0.99564749982773548265 },
	{ 0.99593343144836721237, 0.0015376621466871894916, 0.99564904252945662932 },
	{ 0.99593486043396295404, 0.001537124884724298552, 0.99565058412491547202 },
	{ 0.99593628636780096031, 0.0015365806037184390198, 0.99565209672867527324 },
	{ 0.99593772271576230803, 0.0015360426169630677067, 0.99565364034592385156 },
	{ 0.99593914208832090562, 0.0015355009299513487555, 0.99565515371262314215 },
	{ 0.99594054646911944761, 0.0015349611884352353484, 0.99565666841446620605 },
	{ 0.99594198247375831379, 0.0015344224005934383251, 0.99565819902359709026 },
	{ 0.99594340474548681552, 0.0015338820868727352179, 0.99565971589981783207 },
	{ 0.99594482346954693597, 0.0015333428031202938312, 0.99566123228012781698 },
	{ 0.99594624871673931299, 0.0015328082114454890262, 0.99566276525437080736 },
	{ 0.99594765363159543092, 0.0015322646552321098675, 0.99566425683914872025 },
	{ 0.99594908811035520735, 0.0015317307502028128761, 0.99566579996048654166 },
	{ 0.99595050343933477777, 0.0015311928015944143398, 0.99566730989395824114 },
	{ 0.99595191178741826477, 0.0015306554251906055036, 0.99566881734787671121 },
	{ 0.99595335536423112988, 0.001530124705433525507, 0.99567036537110065186 },
	{ 0.99595475999298466174, 0.0015295865088698044638, 0.99567186616837222157 },
	{ 0.99595616578522094819, 0.0015290513831373823018, 0.99567337511002251826 },
	{ 0.99595756768646614976, 0.0015285123664137492683, 0.99567486825882611789 },
	{ 0.99595899110260377451, 0.0015279803687330852612, 0.99567639223038384433 },
	{ 0.99596039338531860974, 0.0015274466162916789432, 0.99567790010391887812 },
	{ 0.99596182139816669121, 0.0015269133025404581488, 0.99567942180573154598 },
	{ 0.99596322019043359575, 0.0015263782721754678203, 0.99568091840683647931 },
	{ 0.99596462203445834671, 0.0015258435851332316155, 0.99568241603790952343 },
	{ 0.99596602916183885057, 0.0015253091841932902607, 0.99568391632019725979 },
	{ 0.9959674094146772072, 0.0015247738486525185854, 0.99568539735733729845 },
	{ 0.9959688490051312737, 0.0015242490226027138444, 0.99568694726883633095 },
	{ 0.99597023717346622185, 0.0015237138205763463457, 0.99568842180191741154 },
	{ 0.99597166322174501829, 0.001523182852863944059, 0.99568993993698828859 },
	{ 0.99597304543915210484, 0.0015226520758864047888, 0.99569143308579199925 },
	{ 0.99597444697800108226, 0.0015221179610487580672, 0.99569291721283659236 },
	{ 0.99597585040512515153, 0.0015215916091200468088, 0.99569443126618129014 },
	{ 0.99597723857345998866, 0.001521060984730398212, 0.99569591556488734607 },
	{ 0.99597863082352089403, 0.0015205274993178004642, 0.9956973977655100283 },
	{ 0.99598004844131871049, 0.0015200026732679955063, 0.99569891868530990831 },
	{ 0.99598142592850136268, 0.0015194720488783471264, 0.99570039184509995245 },
	{ 0.9959828272003213856, 0.001518944991230642208, 0.99570189508377793253 },
	{ 0.99598422975006495328, 0.0015184171515699976425, 0.99570339239060168257 },
	{ 0.99598561585846323574, 0.0015178879767653100097, 0.99570487371384386321 },
	{ 0.99598701928558719398, 0.0015173639136549582022, 0.99570637952744256438 },
	{ 0.99598841477814092915, 0.0015168360358473408599, 0.99570786992966420215 },
	{ 0.9959897799247778849, 0.0015163060027357686769, 0.99570933101593739334 },
	{ 0.99599116292419798135, 0.0015157778769728288276, 0.99571080667435407641 },
	{ 0.99599254624786748291, 0.0015152517157789808025, 0.99571228925644628127 },
	{ 0.99599394875946423156, 0.0015147287207838634922, 0.99571379171311125145 },
	{ 0.99599535193863297788, 0.0015142067748304939654, 0.99571529220520715864 },
	{ 0.99599672540131001242, 0.0015136774665114019391, 0.9957167571061775746 },
	{ 0.99599811318817510486, 0.0015131539374586672718, 0.99571823888718347106 },
	{ 0.99599948619308842357, 0.0015126301604506103143, 0.9957197152322458944 },
	{ 0.99600086854401004288, 0.0015121059638258541134, 0.99572119317948115658 },
	{ 0.9960022535461462434, 0.0015115825492140375595, 0.99572267103134881605 },
	{ 0.99600363576355332995, 0.0015110592490431389023, 0.99572415182053330973 },
	{ 0.99600503728332867581, 0.0015105387717482166195, 0.99572564550339470735 },
	{ 0.99600639033737536909, 0.0015100129348036362212, 0.99572709304749251746 },
	{ 0.99600778790893906844, 0.0015094962912794661868, 0.99572859533249613584 },
	{ 0.99600914838257170736, 0.0015089707785841534153, 0.99573004857956637359 },
	{ 0.99601050570907911919, 0.0015084471923109596912, 0.99573150085388895114 },
	{ 0.99601190066757505637, 0.0015079299193617406831, 0.99573299163758033359 },
	{ 0.9960132698768644488, 0.0015074088698622287001, 0.99573445720612274723 },
	{ 0.99601465461197180584, 0.0015068899184462129347, 0.99573594051300740038 },
	{ 0.99601602027359292801, 0.0015063702040907438022, 0.99573740383087849803 },
	{ 0.99601739287796287048, 0.001505851481556564047, 0.99573887287079554387 },
	{ 0.99601876731338756521, 0.0015053329116102747483, 0.99574034023224566869 },
	{ 0.99602012490692404256, 0.0015048112326857140085, 0.99574179143845298334 },
	{ 0.9960214948982264449, 0.0015042930632826376734, 0.99574325591980683559 },
	{ 0.9960228557533288285, 0.0015037754088636919817, 0.99574471626221405796 },
	{ 0.99602421887817604862, 0.0015032547599073927454, 0.99574616693436379666 },
	{ 0.99602558953705033762, 0.0015027398139235057482, 0.99574763807236432722 },
	{ 0.99602696366729925881, 0.0015022235327955759006, 0.99574910512863867851 },
	{ 0.99602832309189015536, 0.0015017062789198431724, 0.99575056095062963735 },
	{ 0.99602967925491492363, 0.0015011911040541203819, 0.9957520151513742368 },
	{ 0.99603103881302024192, 0.0015006738311049013738, 0.99575346504151107663 },
	{ 0.99603239081802485977, 0.0015001590758558778268, 0.99575492004334220653 },
	{ 0.99603376380386454692, 0.0014996454650160338969, 0.99575638824402579186 },
	{ 0.99603511054458715446, 0.0014991281920668148887, 0.99575782836853743429 },
	{ 0.99603646352233965455, 0.0014986118918653987611, 0.9957592707246469832 },
	{ 0.99603784627380431704, 0.0014980982810255548312, 0.99576073831497891042 },
	{ 0.99603917935791086435, 0.0014975836783644217408, 0.99576217393814780987 },
	{ 0.99604053994598429345, 0.0014970734626051441021, 0.9957636351579354228 },
	{ 0.99604190850677509772, 0.0014965618354078782763, 0.99576509588181227883 },
	{ 0.99604326287689237684, 0.0014960497504469404302, 0.99576654668747643928 },
	{ 0.99604460399093652789, 0.0014955358535048016502, 0.99576798374115704782 },
	{ 0.99604595023574848955, 0.0014950216704603678033, 0.99576941993653078633 },
	{ 0.99604730523529061426, 0.0014945105963942056145, 0.99577086725174690507 },
	{ 0.99604865046920787464, 0.0014939973860975746481, 0.99577230392395743586 },
	{ 0.99605000285568245921, 0.0014934885054823398599, 0.99577375366150622238 },
	{ 0.99605134612503065661, 0.0014929758483168120969, 0.99577518619477045636 },
	{ 0.99605270587387073622, 0.0014924693709608546563, 0.99577664924561293258 },
	{ 0.99605404788436868735, 0.0014919592696424951311, 0.9957780879968336496 },
	{ 0.99605540183486906969, 0.0014914495879408346327, 0.99577952793061053072 },
	{ 0.99605673745574896394, 0.0014909401541944966411, 0.99578095994889048725 },
	{ 0.99605807370605403683, 0.0014904303199049459029, 0.99578239126145151605 },
	{ 0.99605942651214518513, 0.0014899217826124652383, 0.99578382974564338959 },
	{ 0.99606077350082322663, 0.0014894143706556779109, 0.99578527263581062545 },
	{ 0.99606210750045687252, 0.001488905413746497786, 0.99578670062958496434 },
	{ 0.99606345813217056495, 0.0014883996611830211526, 0.99578814311920904601 },
	{ 0.99606477279128913249, 0.0014878886061903452438, 0.99578954765259519721 },
	{ 0.9960661140007006642, 0.001487383883595130114, 0.99579099033295415122 },
	{ 0.99606747298660147649, 0.0014868828231092900624, 0.99579244956909906961 },
	{ 0.99606879271926740405, 0.0014863699752088992828, 0.9957938498681713213 },
	{ 0.99607014222564527195, 0.0014858693152662724116, 0.99579530042588004779 },
	{ 0.99607146462859941227, 0.0014853624945875612811, 0.99579671499192001782 },
	{ 0.99607278993072334572, 0.0014848562842604126275, 0.99579813398300898175 },
	{ 0.99607413384856990923, 0.0014843522101637329682, 0.99579956777512335098 },
	{ 0.99607545098724170618, 0.0014838456183668578478, 0.99580097524582655844 },
	{ 0.99607677499236868535, 0.0014833431464430296091, 0.99580239904343403889 },
	{ 0.99607809939803870769, 0.0014828360778089964053, 0.9958038098138503047 },
	{ 0.99607944587173258277, 0.0014823362380262815243, 0.99580525264679708997 },
	{ 0.99608078780593667378, 0.0014818378096815548305, 0.99580669330536653039 },
	{ 0.99608211165847571067, 0.0014813306075331170164, 0.99580809528290570309 },
	{ 0.99608341784896636817, 0.0014808287078138786946, 0.99580950820862590422 },
	{ 0.9960847579330422974, 0.0014803278189894155965, 0.99581093332230397053 },
	{ 0.99608605889739776362, 0.0014798221427198842998, 0.99581232767044847165 },
	{ 0.99608739312591343396, 0.0014793204337355092114, 0.99581374978958914213 },
	{ 0.9960887146324137742, 0.0014788201171156362471, 0.99581516364991018442 },
	{ 0.99609003961028863561, 0.00147832178413834117, 0.99581658475815604259 },
	{ 0.99609135259094050419, 0.0014778196555372666212, 0.99581798761307549483 },
	{ 0.99609266477050595334, 0.0014773189383741806933, 0.9958193963807757676 },
	{ 0.99609399674835008565, 0.0014768207007643172329, 0.99582081693589052929 },
	{ 0.99609532302322190134, 0.0014763246566053818236, 0.99582223968445626738 },
	{ 0.99609664109649476149, 0.0014758255225416610362, 0.99582364999710881737 },
	{ 0.99609795180740168252, 0.0014753253585096783116, 0.99582504936158033892 },
	{ 0.99609927771987727407, 0.0014748290663954203954, 0.99582646957337250804 },
	{ 0.9961005782836895861, 0.0014743298941847270481, 0.9958278634446797728 },
	{ 0.99610190122070130236, 0.0014738333731886331217, 0.99582927854477754082 },
	{ 0.99610318562927058217, 0.0014733323508497658469, 0.9958306511491475943 },
	{ 0.99610451283874323902, 0.0014728364402052343974, 0.99583206930100309773 },
	{ 0.9961058247512798447, 0.0014723382788893162737, 0.99583346826493146509 },
	{ 0.99610713641586112743, 0.0014718446379896577784, 0.99583487800537950907 },
	{ 0.99610843142928884308, 0.0014713458281752046179, 0.9958362596887291307 },
	{ 0.99610975791396894063, 0.0014708539229628023702, 0.99583768161713503986 },
	{ 0.99611106372298985345, 0.001470358508228915501, 0.99583907867371479483 },
	{ 0.99611235057296532158, 0.0014698570281263764227, 0.99584044227539936234 },
	{ 0.99611365018310338293, 0.0014693647986647065482, 0.99584184156357691275 },
	{ 0.99611496114196573792, 0.001468872473835605057, 0.99584324956833769615 },
	{ 0.99611627627792154183, 0.0014683783751722749751, 0.99584465045868797439 },
	{ 0.99611757047118931752, 0.0014678864127394136707, 0.99584604597031534112 },
	{ 0.99611887677612087622, 0.0014673909598585542415, 0.99584743406235654017 },
	{ 0.99612017859878321246, 0.0014668984252211028033, 0.99584882686554865305 },
	{ 0.99612146918716204524, 0.0014664055663343839551, 0.99585021022736519569 },
	{ 0.99612279124679337095, 0.0014659153395887782479, 0.99585161720215775727 },
	{ 0.99612408477248903793, 0.0014654233580824306635, 0.99585300785004615687 },
	{ 0.99612538634719616226, 0.0014649298888441493385, 0.99585439182221435761 },
	{ 0.99612667972030410901, 0.0014644403487440514448, 0.99585578346192393795 },
	{ 0.99612797259750129886, 0.0014639503890272543077, 0.9958571660608008802 },
	{ 0.99612925853194944636, 0.0014634554702040120187, 0.99585853576600114057 },
	{ 0.99613055896224722563, 0.0014629683333631914727, 0.99585993293702168572 },
	{ 0.99613184176864366659, 0.0014624756270643632979, 0.9958613018029885966 },
	{ 0.99613314532699326342, 0.0014619902449842850627, 0.99586270179688518578 },
	{ 0.99613444831313824324, 0.0014614991027113357486, 0.99586408580720009454 },
	{ 0.99613572181167331365, 0.0014610099059339919786, 0.9958654563516338154 },
	{ 0.99613701320113867688, 0.0014605205947157300951, 0.99586683647095775029 },
	{ 0.99613829287948330027, 0.0014600310164686596415, 0.99586820632874606396 },
	{ 0.99613958083572107238, 0.0014595426970716867017, 0.99586958156525740016 },
	{ 0.99614088054122640337, 0.0014590577346083074932, 0.995870974044200441 },
	{ 0.99614216014327716664, 0.0014585673171278385526, 0.99587233604371228068 },
	{ 0.99614345351638500237, 0.0014580793792005920795, 0.99587371211945696636 },
	{ 0.99614474076690373572, 0.001457598403095855576, 0.99587510770737797117 },
	{ 0.99614600972594902206, 0.0014571057349439997444, 0.99587645341813235689 },
	{ 0.99614730897369063722, 0.001456624816059721864, 0.99587785032212416958 },
	{ 0.99614859488906515317, 0.0014561396056410205822, 0.99587922481476942593 },
	{ 0.99614987471999782986, 0.0014556526213880907096, 0.99588058963715719862 },
	{ 0.99615116197051645219, 0.0014551684790846237082, 0.99588196832596942443 },
	{ 0.99615241387786501726, 0.0014546834784742719397, 0.99588332185685324305 },
	{ 0.99615371301116573122, 0.0014542016059156778925, 0.99588470460831812758 },
	{ 0.99615499535979845636, 0.0014537163764234901139, 0.99588607362687286972 },
	{ 0.99615625085296244379, 0.0014532287055250522109, 0.99588741456925577999 },
	{ 0.99615754664840316934, 0.001452747538685452474, 0.99588879650056083559 },
	{ 0.99615880427779768258, 0.0014522632247206083023, 0.99589014751374449474 },
	{ 0.99616008662643051874, 0.0014517828780409205557, 0.99589152507722111807 },
	{ 0.99616135478438938566, 0.0014512987166639672743, 0.9958928762429927195 },
	{ 0.99616263076247768549, 0.0014508167296644553304, 0.9958942429345820635 },
	{ 0.99616390448989466933, 0.0014503338652845721227, 0.99589560104310270727 },
	{ 0.99616519030990191563, 0.0014498550826307634535, 0.99589697711884728193 },
	{ 0.99616642394485066525, 0.0014493675261732434471, 0.99589829521119344058 },
	{ 0.99616772368850281527, 0.0014488941985365245101, 0.99589969505250208748 },
	{ 0.99616899014892146269, 0.0014484122306104986293, 0.99590104555070158021 },
	{ 0.99617027257384838101, 0.0014479342490431154535, 0.99590241876542340282 },
	{ 0.99617152604522274384, 0.0014474522620436035096, 0.99590375783860451975 },
	{ 0.99617277570189988189, 0.0014469721823927245499, 0.99590510240494978245 },
	{ 0.99617406485976733865, 0.0014464941436048825343, 0.99590647491395245527 },
	{ 0.99617531466903241899, 0.0014460117751356439068, 0.99590780460297823051 },
	{ 0.99617656428756262699, 0.00144553058922255789, 0.99590914440095201776 },
	{ 0.99617784831466216211, 0.0014450577193495107563, 0.99591052516877442979 },
	{ 0.99617912440719136313, 0.0014445793563124011138, 0.99591188274323749763 },
	{ 0.99618036256255626526, 0.0014441000205274890245, 0.99591321050584113994 },
	{ 0.99618162164153578608, 0.00144362448036635619, 0.99591456449448878541 },
	{ 0.99618286614837159298, 0.0014431404715772933652, 0.99591588102280903527 },
	{ 0.9961841316360425802, 0.001442669509052878999, 0.99591724889695454337 },
	{ 0.99618537393035400118, 0.0014421890860792461325, 0.99591857511460601948 },
	{ 0.99618666428985092054, 0.0014417173606153788328, 0.99591995305955238749 },
	{ 0.99618790038527937902, 0.001441239665150290724, 0.9959212774652227429 },
	{ 0.99618917888106794933, 0.0014407650023695287196, 0.99592263873994224532 },
	{ 0.99619044310988857927, 0.001440292704701071503, 0.99592399345338233907 },
	{ 0.99619169097365811716, 0.0014398163253065401814, 0.99592532920777687711 },
	{ 0.99619292605819165232, 0.0014393423491712859907, 0.99592665973603622387 },
	{ 0.9961941809219304611, 0.0014388672477003386797, 0.99592799726426495255 },
	{ 0.99619543548049360737, 0.0014383911162611296482, 0.99592933193147081816 },
	{ 0.99619666425170338986, 0.0014379135733839322128, 0.99593064180314427869 },
	{ 0.99619792207183277544, 0.0014374428778883264167, 0.99593199567735080091 },
	{ 0.99619918469848067755, 0.0014369738608595178115, 0.99593335008561512112 },
	{ 0.99620043443145167572, 0.0014365017157789512683, 0.99593468931138418032 },
	{ 0.99620167216720001413, 0.0014360306197401327254, 0.99593602104127321173 },
	{ 0.99620291293563267843, 0.0014355529433485308966, 0.99593733413636609253 },
	{ 0.99620414639891996522, 0.0014350823813673294939, 0.9959386590379469828 },
	{ 0.9962053959411563131, 0.0014346116477247513547, 0.99593999677598410436 },
	{ 0.99620665902556782001, 0.0014341402655836379618, 0.99594133974015641719 },
	{ 0.9962078985732971681, 0.0014336706763502394396, 0.99594266977250500705 },
	{ 0.9962091188186583679, 0.0014331981116529736529, 0.9959439791291945232 },
	{ 0.99621039258422217078, 0.0014327312308546338252, 0.99594533712327415476 },
	{ 0.9962116076606686299, 0.001432257922291401385, 0.99594663871705468861 },
	{ 0.99621285495223343975, 0.0014317900496717723968, 0.99594797458589023886 },
	{ 0.99621408458174987022, 0.0014313172560926705999, 0.99594928523957670929 },
	{ 0.99621533866347589115, 0.0014308508330580025757, 0.99595062339723039457 },
	{ 0.99621658580245286974, 0.0014303864699598577755, 0.99595196941316066486 },
	{ 0.9962178052848746912, 0.0014299140578504826622, 0.99595326702058262214 },
	{ 0.99621903153838409217, 0.0014294421225782658492, 0.9959545728868242076 },
	{ 0.99622027190627349125, 0.0014289760619398382286, 0.99595590373933284845 },
	{ 0.99622153428496618144, 0.0014285155707594184536, 0.99595726076066448673 },
	{ 0.99622275094451206989, 0.0014280461341139103881, 0.99595856195390164434 },
	{ 0.99622396600188500848, 0.001427575400471332032, 0.99595985818803234313 },
	{ 0.99622522439421901108, 0.0014271119910475040492, 0.9959612005037060678 },
	{ 0.9962264400619437188, 0.0014266452246900819013, 0.99596250650346185296 },
	{ 0.99622767751158958216, 0.0014261799460645930605, 0.99596382970750219066 },
	{ 0.99622889905394795829, 0.001425711882710100839, 0.99596513441026091051 },
	{ 0.9962301317352223462, 0.0014252471762892025657, 0.99596645223557822568 },
	{ 0.99623134854735617694, 0.0014247821646925229455, 0.9959677586168036445 },
	{ 0.99623259440840994383, 0.001424318965077044476, 0.99596908805787420782 },
	{ 0.99623381616057660182, 0.0014238548499342221828, 0.99597039926469188575 },
	{ 0.99623501820983195731, 0.0014233875113722103348, 0.99597168500840516092 },
	{ 0.99623625939788129635, 0.0014229262763258236895, 0.99597301080643985127 },
	{ 0.99623745927275919598, 0.0014224586707350034883, 0.99597429445206964171 },
	{ 0.99623868638457568903, 0.001421995108723284832, 0.99597560396134698912 },
	{ 0.99623992410125061792, 0.0014215331488844178132, 0.99597692392289494112 },
	{ 0.99624113904418276633, 0.0014210691672560001302, 0.99597822332322438754 },
	{ 0.99624237752379685151, 0.0014206148368116641809, 0.99597956052720382214 },
	{ 0.99624360253752963779, 0.0014201512366529725311, 0.99598086603104907244 },
	{ 0.99624480145873317571, 0.0014196858817335390041, 0.99598214445054367161 },
	{ 0.99624603358687646715, 0.0014192287474867129604, 0.9959834709542972897 },
	{ 0.99624722045363678369, 0.0014187627822157169565, 0.99598473823487598811 },
	{ 0.99624845771254777471, 0.0014183021956678655649, 0.99598605239808402079 },
	{ 0.99624965064467663201, 0.0014178380233045844317, 0.99598732894837693763 },
	{ 0.99625088805617567633, 0.0014173820143934517252, 0.99598865699708316601 },
	{ 0.99625209243239642998, 0.0014169204360243113899, 0.99598994560181952629 },
	{ 0.99625332253875031885, 0.0014164634925123485796, 0.99599126016557093521 },
	{ 0.99625452195586461368, 0.0014160016852613722341, 0.99599254320084917858 },
	{ 0.99625572740020063023, 0.0014155433112379349567, 0.9959938353151071011 },
	{ 0.99625695186080243104, 0.00141508713066542508, 0.99599514560639756944 },
	{ 0.99625815391005778654, 0.0014146273452039996154, 0.99599643440186891308 },
	{ 0.99625937152327814772, 0.0014141708403822223286, 0.99599773792207169087 },
	{ 0.99626058267058670292, 0.0014137142783399859851, 0.99599903463303973705 },
	{ 0.99626176852645220716, 0.0014132506972547810489, 0.9960002952951186872 },
	{ 0.99626299971999465743, 0.0014128002196546831943, 0.99600162101685962845 },
	{ 0.99626419997634230175, 0.0014123409301039020931, 0.99600290122926204983 },
	{ 0.99626538909377404529, 0.0014118817931410116654, 0.9960041709131000065 },
	{ 0.99626660689772927881, 0.0014114254027601524921, 0.99600546806275847 },
	{ 0.99626779937209442028, 0.0014109714537855434432, 0.99600675636231916776 },
	{ 0.99626901648940402456, 0.0014105166655775356905, 0.99600805755555643639 },
	{ 0.99627021560134265687, 0.0014100617247816374811, 0.99600933784425282891 },
	{ 0.99627144076766338543, 0.0014096072798963836352, 0.99601064411103767959 },
	{ 0.99627261058272686967, 0.0014091491347547821511, 0.99601189983308369147 },
	{ 0.99627383311690664858, 0.0014086993056532199839, 0.99601321269929476987 },
	{ 0.99627500388564460554, 0.0014082401305433569962, 0.99601446128785675604 },
	{ 0.99627620019378060334, 0.0014077829200025858327, 0.99601573446214275442 },
	{ 0.99627741229476318718, 0.0014073331862684552822, 0.99601703327119439635 },
	{ 0.99627860385360123008, 0.0014068795424696273633, 0.99601831180513000774 },
	{ 0.99627981471480742126, 0.0014064281111952135588, 0.99601960842073067326 },
	{ 0.99628100415648845889, 0.0014059753638502431837, 0.99602087808549522041 },
	{ 0.99628219912948035031, 0.0014055225402113274719, 0.99602215934693949517 },
	{ 0.99628340901793865925, 0.001405072081684716331, 0.99602345220506338652 },
	{ 0.99628456872405457556, 0.0014046177893873533753, 0.99602469842851315551 },
	{ 0.99628577632369474948, 0.0014041637068983397162, 0.99602597476899790152 },
	{ 0.99628697452010583913, 0.0014037176162000975302, 0.99602726833284072061 },
	{ 0.99628815885009247566, 0.0014032607108351074967, 0.99602852174699485488 },
	{ 0.9962893313163705411, 0.0014028110152479492893, 0.99602978919923490508 },
	{ 0.99629053914489251742, 0.0014023613196607910818, 0.9960310752671978074 },
	{ 0.99629171172561159509, 0.0014019086104627930499, 0.99603232879579295389 },
	{ 0.99629292663039681344, 0.0014014615279432619203, 0.99603362426698449639 },
	{ 0.99629411113204480177, 0.0014010121947523443333, 0.99603489490449681476 },
	{ 0.99629527697982311896, 0.0014005625945326177426, 0.99603614879548818539 },
	{ 0.99629646315993813932, 0.001400110896229395151, 0.99603741195619388549 },
	{ 0.99629764981689006298, 0.0013996652823683110485, 0.99603868917405880001 },
	{ 0.99629883473815472605, 0.0013992172080274909753, 0.99603996015489393301 },
	{ 0.99630000745238822546, 0.0013987644034620615435, 0.99604120641649052104 },
	{ 0.99630118352355523381, 0.0013983180075880380106, 0.99604246702134902058 },
	{ 0.99630237983169134264, 0.0013978726226087901351, 0.9960437477105885673 },
	{ 0.99630357818069048559, 0.0013974265319105477322, 0.99604502479493928213 },
	{ 0.99630475203933299699, 0.0013969786864515634523, 0.99604628379762494284 },
	{ 0.99630593257369581828, 0.001396535227894434841, 0.99604755435884317905 },
	{ 0.99630712306441848725, 0.0013960881453749037114, 0.99604881809175349616 },
	{ 0.99630827838363245075, 0.0013956397658583020744, 0.99605005931794976526 },
	{ 0.99630946559371547089, 0.0013951938277479505619, 0.99605132419526909437 },
	{ 0.99631062877120579735, 0.0013947450667616222413, 0.99605256580293510815 },
	{ 0.99631181353988262916, 0.0013943012648817392895, 0.99605383403718805724 },
	{ 0.99631298638763055031, 0.0013938543921705576732, 0.99605508443773138616 },
	{ 0.99631414622726066632, 0.0013934118682142587319, 0.99605634212434635 },
	{ 0.99631533658446891355, 0.0013929682761427255103, 0.996057607211474072 },
	{ 0.99631651345672234132, 0.0013925250464674326922, 0.9960588666337761854 },
	{ 0.99631766732635129724, 0.0013920773535963388689, 0.99606009618699886676 },
	{ 0.99631885486068350044, 0.0013916374999281260622, 0.99606137279451234523 },
	{ 0.99632002410354247868, 0.0013911936599012705504, 0.99606262168825010495 },
	{ 0.99632119365157711943, 0.0013907525664564465099, 0.99606387958467357269 },
	{ 0.99632237307967774775, 0.0013903090697523449049, 0.9960651340860164904 },
	{ 0.99632352921905165122, 0.0013898652106520028963, 0.9960663737672605933 },
	{ 0.99632470155181551696, 0.0013894219428297373015, 0.99606761903703622263 },
	{ 0.99632586457671801217, 0.0013889797431227062039, 0.99606886568010277738 },
	{ 0.99632703729095162259, 0.0013885400611158703506, 0.99607012399614314191 },
	{ 0.9963281800216644557, 0.0013880970984693861026, 0.99607135034502014559 },
	{ 0.99632935536803901577, 0.001387656310200343409, 0.99607260808885578207 },
	{ 0.99633053117217718064, 0.0013872147589918473482, 0.99607385560930250534 },
	{ 0.99633168679656669564, 0.0013867772132154802724, 0.99607510629594797624 },
	{ 0.9963328334945646958, 0.0013863336402174333307, 0.99607632776201249225 },
	{ 0.99633398469390554997, 0.0013858893805738787923, 0.99607755006731035774 },
	{ 0.99633518014373456673, 0.001385457175373683552, 0.99607883966386800978 },
	{ 0.99633630380096105394, 0.0013850134497877461537, 0.99608004266679772698 },
	{ 0.99633748092116980466, 0.0013845731383558615435, 0.99608129299104708476 },
	{ 0.99633865966262491476, 0.0013841405516859396196, 0.99608256084383028917 },
	{ 0.99633978801192912833, 0.0013836944991346699935, 0.99608375747621547003 },
	{ 0.9963409622329679749, 0.0013832615882154804428, 0.99608502656877540016 },
	{ 0.99634211389007243387, 0.001382822058796535046, 0.99608625513017690078 },
	{ 0.99634327880324990989, 0.0013823847609754902604, 0.99608749881685287875 },
	{ 0.99634442420425084475, 0.0013819470626112325112, 0.99608872692049055253 },
	{ 0.99634559920730259019, 0.0013815113478895530829, 0.9960899805063060386 },
	{ 0.99634672849120764493, 0.0013810709983106956959, 0.99609118646562611055 },
	{ 0.99634789128722822671, 0.0013806361991163598746, 0.99609243013322867899 },
	{ 0.99634903062286062081, 0.0013801997596021996391, 0.99609365819871942271 },
	{ 0.99635019002380054154, 0.0013797639304396020973, 0.99609489412248664042 },
	{ 0.99635134860458052231, 0.0013793274718519557987, 0.99609612670839364768 },
	{ 0.99635250369491246136, 0.001378896258473049502, 0.99609737640321782681 },
	{ 0.99635365123214392202, 0.0013784587126966824262, 0.99609859748781259814 },
	{ 0.99635481065215736329, 0.0013780234748121608646, 0.99609982789934203851 },
	{ 0.99635593377532638559, 0.0013775863867994655922, 0.99610103631914193034 },
	{ 0.99635710227431928399, 0.0013771568709608427664, 0.99610229083955814655 },
	{ 0.99635822890700986854, 0.0013767179518934600634, 0.99610349101961193075 },
	{ 0.99635936751784981436, 0.0013762818557020539516, 0.99610470287263930267 },
	{ 0.99636052169265465484, 0.0013758491164442415711, 0.99610593761385035627 },
	{ 0.99636165879668914247, 0.0013754178076979036577, 0.99610716386735986827 },
	{ 0.99636281566085560524, 0.0013749860793348669345, 0.99610840118349153194 },
	{ 0.99636394536437744573, 0.0013745516425367712999, 0.99610960889757227399 },
	{ 0.99636506799163582215, 0.0013741160422560095514, 0.99611080812395169648 },
	{ 0.99636623813094860047, 0.0013736885100599648298, 0.99611206203401647663 },
	{ 0.99636737973632572007, 0.0013732572394605996931, 0.99611328653276531853 },
	{ 0.99636851796569581019, 0.0013728262549635294066, 0.99611450456560224342 },
	{ 0.99636964909972902671, 0.0013723954993482951302, 0.99611572206438148136 },
	{ 0.99637078717651128557, 0.0013719620734449749361, 0.99611692987382982611 },
	{ 0.99637191970290905907, 0.0013715288192030319122, 0.9961181407922564679 },
	{ 0.99637307040633937838, 0.0013710995513197313765, 0.9961193674844562862 },
	{ 0.99637418992461956879, 0.0013706652671095264154, 0.99612056047380559409 },
	{ 0.99637532693328645372, 0.0013702374869581594036, 0.99612178399980666477 },
	{ 0.99637648515167032137, 0.0013698100119825737386, 0.99612302003801467265 },
	{ 0.99637760669174002537, 0.0013693793517347710789, 0.99612422080934626134 },
	{ 0.99637874148788274642, 0.0013689498168226617563, 0.99612543495119199033 },
	{ 0.99637988725127990541, 0.0013685226279493709414, 0.99612666078508471657 },
	{ 0.99638099427642634609, 0.0013680909568067930581, 0.99612784440935209229 },
	{ 0.99638212689819150025, 0.0013676639014479066367, 0.99612906179369042903 },
	{ 0.99638327437820251031, 0.0013672383147474672423, 0.99613029056490010049 },
	{ 0.99638439715804871799, 0.0013668063765760805721, 0.9961314823907666538 },
	{ 0.99638553342284974512, 0.0013663798362013250109, 0.99613269700944950813 },
	{ 0.99638667615356257823, 0.0013659570151564031509, 0.99613392732561134579 },
	{ 0.99638778277816597573, 0.0013655254775282294442, 0.99613510684907913273 },
	{ 0.99638891551437203109, 0.0013651009017225657072, 0.99613632488191616865 },
	{ 0.99639005067291086526, 0.001364673903584137692, 0.99613753274858485298 },
	{ 0.99639116742553535122, 0.0013642474585768137475, 0.99613873212755210673 },
	{ 0.99639230708541692838, 0.0013638219481703199067, 0.99613994670808791998 },
	{ 0.99639341014327820201, 0.0013633963805433670091, 0.99614113643587098856 },
	{ 0.99639454600753607494, 0.001362972186207429522, 0.99614235042512888629 },
	{ 0.99639565715255562495, 0.0013625446349378983035, 0.99614353847444514489 },
	{ 0.99639678889694049957, 0.0013621199828382890128, 0.99614474498689642434 },
	{ 0.99639790076675227581, 0.0013616926985975665813, 0.99614593093812942026 },
	{ 0.99639901399078190103, 0.0013612678366896077773, 0.99614712682664874333 },
	{ 0.99640013059081855573, 0.0013608429175611899166, 0.99614831819475191388 },
	{ 0.99640123692931958921, 0.0013604163581129478586, 0.99614949808061625802 },
	{ 0.99640237397613373727, 0.0013599944907423425992, 0.99615071103990582291 },
	{ 0.99640350835265967255, 0.0013595759803053310711, 0.99615193300188120684 },
	{ 0.99640461804809421498, 0.0013591520148512295941, 0.99615312158525537445 },
	{ 0.99640573327483983324, 0.0013587253409620696394, 0.99615430349290923218 },
	{ 0.99640684367599341442, 0.0013583063918348725879, 0.99615550247133344275 },
	{ 0.99640793696822982373, 0.001357877772450107089, 0.99615666503847233315 },
	{ 0.99640906947555396567, 0.0013574575453993260269, 0.99615787322939042259 },
	{ 0.99641019351425019757, 0.0013570376998182714316, 0.99615908058107505152 },
	{ 0.99641131495895240988, 0.001356616480946201209, 0.9961602761834922326 },
	{ 0.99641241908492894641, 0.0013561971694227637538, 0.99616146942079697446 },
	{ 0.99641353331985327291, 0.0013557761412855569814, 0.99616265903413925287 },
	{ 0.99641463323058920842, 0.0013553537970777934218, 0.99616383516252682284 },
	{ 0.99641575215759126127, 0.0013549340277906841631, 0.99616503068864992176 },
	{ 0.99641684342803826802, 0.0013545105582472274832, 0.99616619489610847005 },
	{ 0.9964179605239855686, 0.0013540923148390247421, 0.99616739438951673602 },
	{ 0.99641904672088499328, 0.0013536697226759388923, 0.99616855855882835424 },
	{ 0.99642020518722418387, 0.0013532583647963003504, 0.99616979721010401327 },
	{ 0.99642129031600845668, 0.0013528354674574331537, 0.99617095832765778507 },
	{ 0.99642239999236958958, 0.0013524159461256461852, 0.99617214212358673464 },
	{ 0.99642349397125140609, 0.0013519985419508419311, 0.99617332155168747398 },
	{ 0.99642460099639795779, 0.0013515757209059200711, 0.99617449479997866035 },
	{ 0.99642571202697638455, 0.0013511603385206662643, 0.99617568403185119408 },
	{ 0.99642680982055553685, 0.0013507417136427366227, 0.99617686269701233304 },
	{ 0.99642791446151612877, 0.0013503234893080199447, 0.99617804000795595609 },
	{ 0.99642900878372064888, 0.001349906886219641184, 0.99617921489656668932 },
	{ 0.99643011868896358418, 0.0013494902640577761434, 0.99618040220201731216 },
	{ 0.99643121390762201539, 0.0013490736800428838795, 0.99618157627046810543 },
	{ 0.99643232638778544974, 0.0013486572295423955754, 0.99618275932253108618 },
	{ 0.99643341872634738632, 0.0013482423049208137888, 0.99618393711031172355 },
	{ 0.9964345116180405304, 0.0013478227835890268203, 0.99618509759844042772 },
	{ 0.99643560124816732415, 0.0013474054557081676861, 0.99618626657427045146 },
	{ 0.99643672414245443303, 0.001346992400288246107, 0.99618746179521766582 },
	{ 0.99643779765548545768, 0.0013465752059217911494, 0.99618861438692318799 },
	{ 0.99643890428008874416, 0.0013461637336012347108, 0.99618980413377999916 },
	{ 0.99644000352325279302, 0.0013457480841871725507, 0.99619097661913158515 },
	{ 0.99644106877746418949, 0.001345325759052895271, 0.99619210481584796746 },
	{ 0.99644220479430989368, 0.001344922469257973539, 0.99619333787859210005 },
	{ 0.99644329444351031899, 0.0013445058089491357216, 0.99619449848116170543 },
	{ 0.99644437522353956904, 0.0013440897017714015411, 0.99619564975679641972 },
	{ 0.99644547442855668784, 0.0013436771422621245423, 0.99619682380617391448 },
	{ 0.99644655476989596465, 0.0013432639533277987865, 0.99619798849046958811 },
	{ 0.99644765885772557112, 0.0013428517752882482544, 0.9961991660493685341 },
	{ 0.99644873605193962085, 0.0013424377280470375148, 0.99620031999529135014 },
	{ 0.99644981095733520249, 0.0013420209342237957376, 0.99620146280229826541 },
	{ 0.99645090686263926294, 0.0013416101485487466789, 0.99620263812959941596 },
	{ 0.99645202313842673458, 0.0013412033301588542622, 0.99620383527696887427 },
	{ 0.9964530881256093986, 0.0013407866889235029416, 0.99620496877611441899 },
	{ 0.99645417294921767581, 0.0013403763037916670633, 0.99620613370836552658 },
	{ 0.99645523911895650393, 0.0013399612265821948202, 0.99620727273882203612 },
	{ 0.99645633695068258628, 0.001339553397297526963, 0.99620845060289675565 },
	{ 0.99645743844451806215, 0.0013391441947218432618, 0.99620962587297734459 },
	{ 0.99645851861419587614, 0.0013387338858839527202, 0.99621078264177620465 },
	{ 0.99645961438598551485, 0.0013383252936598319296, 0.99621195638597792588 },
	{ 0.99646070752563398187, 0.0013379145270582695846, 0.99621311666429834819 },
	{ 0.99646176631393357237, 0.0013375027495619317992, 0.99621425571382837827 },
	{ 0.99646284758987357932, 0.0013370946151014825951, 0.99621541877687769251 },
	{ 0.99646394605102450726, 0.0013366853934523128308, 0.99621658216417618981 },
	{ 0.9964650223678580554, 0.0013362788611647150473, 0.9962177458375769401 },
	{ 0.99646608310165318834, 0.0013358644896742368977, 0.99621887111604989773 },
	{ 0.99646715957107456774, 0.0013354580336805846677, 0.99622002822817135037 },
	{ 0.99646825232925329008, 0.0013350487166639832867, 0.99622118949831295343 },
	{ 0.9964693311256399566, 0.0013346400862928895024, 0.99622234031618406291 },
	{ 0.99647040587844748494, 0.001334235499500897263, 0.99622350219667721305 },
	{ 0.99647148887100123194, 0.0013338296920057800699, 0.99622466117800045904 },
	{ 0.99647254401626483844, 0.0013334187728163270515, 0.99622578864992428205 },
	{ 0.99647362281265150497, 0.0013330138045546083454, 0.99622694801271727272 },
	{ 0.99647468833389174492, 0.0013326041060682802808, 0.99622808341921131881 },
	{ 0.99647579617919812556, 0.0013322031241652042798, 0.99622927022875107372 },
	{ 0.99647684422912485847, 0.0013317928916212590749, 0.99623038709581634986 },
	{ 0.99647792176666138975, 0.0013313884955641302858, 0.99623154397905622215 },
	{ 0.99647898324432249151, 0.0013309811621901067921, 0.99623268159807465416 },
	{ 0.99648004739227180604, 0.0013305749732252629153, 0.99623381837785984771 },
	{ 0.99648113801422022462, 0.0013301706916090520229, 0.99623498163164392327 },
	{ 0.99648220902862461035, 0.0013297646552320990364, 0.99623612100542313641 },
	{ 0.99648325007858185032, 0.001329358065724042413, 0.99623724681795366998 },
	{ 0.9964843130821219308, 0.0013289521056410345465, 0.99623837573946250057 },
	{ 0.99648539447250283896, 0.0013285524779554878927, 0.9962395431894136566 },
	{ 0.99648646939697194114, 0.0013281473380323922332, 0.99624068494737871848 },
	{ 0.99648753066482487206, 0.0013277433425184761908, 0.99624182392061499947 },
	{ 0.99648860862197830013, 0.0013273402816053902521, 0.99624297222078594949 },
	{ 0.9964896736473078942, 0.0013269359618422065829, 0.99624410880983638172 },
	{ 0.99649072444381658897, 0.0013265322905775581673, 0.99624523910463613774 },
	{ 0.99649180360259970168, 0.0013261336737867867371, 0.99624639661730096662 },
	{ 0.9964928608268733834, 0.0013257265502211129735, 0.99624751697481428447 },
	{ 0.9964939072364803474, 0.0013253244429823436354, 0.99624864517153066679 },
	{ 0.99649498847427342429, 0.0013249261885878126088, 0.99624980514467520454 },
	{ 0.99649604117813106452, 0.0013245204573866407524, 0.99625092681825921925 },
	{ 0.99649710765304566618, 0.0013241230803724803392, 0.99625207355440437151 },
	{ 0.99649817592086797902, 0.0013237188750502147834, 0.99625320499361325055 },
	{ 0.99649923268737805593, 0.0013233193427320997463, 0.99625434034288695706 },
	{ 0.9965002888816834048, 0.0013229172545668166881, 0.99625546779573725953 },
	{ 0.99650134910049437131, 0.0013225169783827347807, 0.99625659988344472673 },
	{ 0.99650237880172731764, 0.0013221126586195511114, 0.99625770374239241978 },
	{ 0.99650345328750611351, 0.0013217142134901566346, 0.99625885078371323456 },
	{ 0.99650452178421011773, 0.001321318629383711309, 0.99626000015199933646 },
	{ 0.99650553092422489154, 0.0013209119063612505089, 0.99626108268678947866 },
	{ 0.9965066126388552048, 0.0013205144721266312557, 0.99626223497331911627 },
	{ 0.99650769339981115635, 0.0013201197463270709139, 0.99626338855684593021 },
	{ 0.99650872277679469757, 0.0013197151786085653882, 0.99626448553026514254 },
	{ 0.99650977788391148504, 0.0013193198615309288495, 0.99626562280596087096 },
	{ 0.99651083627166803236, 0.0013189221030470421863, 0.99626675451219881552 },
	{ 0.99651188706817683816, 0.0013185263663527061872, 0.99626788648546538152 },
	{ 0.99651293172302302104, 0.001318126013874678943, 0.99626900140703522624 },
	{ 0.99651397536697450263, 0.0013177271300550989427, 0.99627011791170438926 },
	{ 0.99651503085556103478, 0.0013173292952772669429, 0.99627124282778112274 },
	{ 0.99651607055130075885, 0.0013169284087416225585, 0.99627234615267135087 },
	{ 0.99651712909164502641, 0.0013165342360731656368, 0.99627348304689755665 },
	{ 0.99651818118515100853, 0.0013161361342665250668, 0.99627460472048157136 },
	{ 0.99651920922699066541, 0.0013157401114698942177, 0.99627571512163515255 },
	{ 0.99652028527679548109, 0.0013153439933058317518, 0.99627685098589302548 },
	{ 0.99652132178726293699, 0.0013149484282728729229, 0.996277965506919716 },
	{ 0.99652234815063567286, 0.0013145505362745818663, 0.9962790677064741196 },
	{ 0.99652340287628271565, 0.0013141571265455780949, 0.99628019857347860366 },
	{ 0.99652446242752190653, 0.0013137644988295137539, 0.99628133212984459899 },
	{ 0.99652548034134036392, 0.0013133651763197482301, 0.99628241901338965292 },
	{ 0.99652653193893570016, 0.0013129722243544162622, 0.99628354690493015067 },
	{ 0.99652758000793606463, 0.0013125794440504612477, 0.99628466993273157026 },
	{ 0.99652863297882221527, 0.0013121848136183325226, 0.9962857937806928188 },
	{ 0.9965296577400221123, 0.0013117913466688696945, 0.99628689720095031657 },
	{ 0.99653070067825466616, 0.0013113938552137918182, 0.99628800453127253078 },
	{ 0.99653173852386633946, 0.0013110023719069073111, 0.9962891200822673321 },
	{ 0.99653276648941213622, 0.0013106038314100810008, 0.9962902096551738973 },
	{ 0.99653382346573060602, 0.0013102161055800027548, 0.99629134811342578981 },
	{ 0.99653485379638861996, 0.0013098208838697976159, 0.99629244539202077569 },
	{ 0.99653587712707702995, 0.0013094289618727271516, 0.99629354852617602045 },
	{ 0.99653690762939639569, 0.0013090336829420631728, 0.99629464601457917716 },
	{ 0.99653798453750797037, 0.0013086499053236548551, 0.9962958060830912066 },
	{ 0.99653900023880193082, 0.0013082498961683815177, 0.9962968783944925466 },
	{ 0.99654002557220655589, 0.0013078585654493872503, 0.99629798025072413559 },
	{ 0.9965410728973407295, 0.0013074702674147193043, 0.99629910325945203464 },
	{ 0.99654210584106628357, 0.001307079718708664684, 0.9963002121919470877 },
	{ 0.9965431403869647875, 0.0013066872626539772963, 0.99630131387651743591 },
	{ 0.99654417279663298768, 0.0013062963324781962093, 0.9963024176973181989 },
	{ 0.99654519359054782868, 0.0013059037047621316514, 0.99630350818575186267 },
	{ 0.99654622840347506507, 0.0013055122023817604306, 0.99630461013735105436 },
	{ 0.99654726006927707438, 0.0013051256400343482986, 0.99630572496355329637 },
	{ 0.99654828515472637651, 0.0013047334891554420409, 0.99630681718767433175 },
	{ 0.99654932866516332535, 0.0013043433600660864474, 0.99630792409837987123 },
	{ 0.99655035733642804985, 0.0013039554053541724081, 0.99630903211534760366 },
	{ 0.9965513679641747613, 0.0013035642844435278709, 0.99631011285722992366 },
	{ 0.99655240376892351151, 0.0013031787329908911793, 0.99631122800768157077 },
	{ 0.99655342664184831669, 0.0013027868109938209318, 0.99631231435716893774 },
	{ 0.99655445310058854425, 0.0013024000006910865096, 0.99631341619432700618 },
	{ 0.99655549394073750236, 0.0013020154410597389785, 0.99631453584612139629 },
	{ 0.99655650491180691741, 0.0013016230612989969275, 0.99631560892046222566 },
	{ 0.99655751582565599289, 0.0013012327605482643805, 0.99631669101656206156 },
	{ 0.99655855723800967905, 0.0013008468657728737821, 0.99631780353487253699 },
	{ 0.99655957919540716361, 0.0013004589110609597429, 0.99631889827669362081 },
	{ 0.99656057757797555929, 0.0013000678282972877656, 0.9963199634927579762 },
	{ 0.9965616309112580451, 0.0012996882086988991063, 0.99632109826982706569 },
	{ 0.99656264655533155494, 0.0012992984420057839164, 0.99632217651308252471 },
	{ 0.99656366065445278757, 0.0012989130049940651214, 0.99632326995790665425 },
	{ 0.99656468362274519546, 0.0012985258704420630724, 0.9963243578904932285 },
	{ 0.99656570407333744388, 0.0012981424742933812214, 0.99632545597017463379 },
	{ 0.9965667162651099531, 0.0012977552825209201157, 0.99632653575838259208 },
	{ 0.99656772818985361884, 0.0012973630934950412981, 0.9963276039117638927 },
	{ 0.99656874663772976319, 0.0012969818526503147215, 0.99632870552004038078 },
	{ 0.9965697831291239206, 0.0012966007262465062584, 0.99632981632173711617 },
	{ 0.99657077861252252315, 0.0012962107115980687783, 0.99633087650240115263 },
	{ 0.99657179484787428159, 0.0012958304625746311454, 0.99633197940767470602 },
	{ 0.99657281722488855191, 0.0012954463607069554177, 0.99633306838930313365 },
	{ 0.99657383071365823746, 0.0012950603133436741458, 0.99633414596498670601 },
	{ 0.99657486230316638665, 0.0012946785193678441491, 0.9963352474016018423 },
	{ 0.99657585311356067237, 0.0012942915755507057671, 0.99633630908907122592 },
	{ 0.99657686751785767854, 0.0012939070540663307959, 0.99633739185274317052 },
	{ 0.99657787492218519176, 0.0012935241538282935252, 0.99633847162187771929 },
	{ 0.99657891782227070454, 0.0012931492072340553846, 0.99633959600389676581 },
	{ 0.99657989232483434883, 0.0012927585059401100909, 0.99634063276231965567 },
	{ 0.99658091556015548917, 0.0012923788481947488718, 0.9963417304986780243 },
	{ 0.99658191264572670853, 0.0012919934874769754135, 0.99634279563844840855 },
	{ 0.99658293660584018614, 0.0012916116553541724232, 0.99634388345659397057 },
	{ 0.99658394631805946595, 0.001291231749653488697, 0.99634496969164010327 },
	{ 0.99658494138184128275, 0.0012908474951979220791, 0.99634603341997252102 },
	{ 0.99658597209396904137, 0.0012904676848646701864, 0.99634712707460515446 },
	{ 0.99658696978989202986, 0.0012900884276625219308, 0.99634820457399464466 },
	{ 0.99658798106613732948, 0.0012897073394056860277, 0.99634928466737837649 },
	{ 0.99658896497192972497, 0.0012893234091993872534, 0.99635033620775315111 },
	{ 0.99658996055069593023, 0.0012889411193129126764, 0.99635140331209259834 },
	{ 0.99659100539627698545, 0.0012885679656263891897, 0.99635252536714635774 },
	{ 0.99659197791519793519, 0.0012881829100843970783, 0.99635356349886028404 },
	{ 0.99659299869003936667, 0.0012878043013807838595, 0.99635465103090392613 },
	{ 0.99659399295273476405, 0.001287421610951096319, 0.99635570877016166325 },
	{ 0.99659500077667884099, 0.001287043364643723287, 0.99635678895891266471 },
	{ 0.99659601247254070433, 0.0012866669684645241824, 0.99635787443101941907 },
	{ 0.99659700017395680405, 0.0012862871772047585698, 0.99635893506944706033 },
	{ 0.99659800990524971542, 0.0012859067565199442003, 0.99636000472963381913 },
	{ 0.99659902644577713637, 0.0012855323058363504231, 0.99636109817445783765 },
	{ 0.99660000855866182068, 0.0012851499778029032862, 0.99636214399278677512 },
	{ 0.9966010044807505075, 0.0012847752410170148758, 0.99636322433412571886 },
	{ 0.99660201369705914143, 0.0012843995696302961448, 0.99636430496156702663 },
	{ 0.99660299210968728012, 0.0012840147620436261067, 0.99636533685625083834 },
	{ 0.99660399079743144934, 0.0012836392432447980491, 0.99636640970170975429 },
	{ 0.99660499774399513573, 0.0012832632857557844681, 0.99636748664796825903 },
	{ 0.9966059820503305744, 0.0012828836852308820888, 0.99636853816926951311 },
	{ 0.99660697530213115947, 0.0012825081473585675344, 0.9963696043962286808 },
	{ 0.99660799687805889935, 0.0012821341544386457775, 0.99637069127977351268 },
	{ 0.99660897874298792765, 0.0012817568427321030661, 0.99637174676835982279 },
	{ 0.99660996385040978573, 0.0012813796454664780344, 0.99637280267656280763 },
	{ 0.99661096223297818142, 0.00128100382149186863, 0.99637386819780293656 },
	{ 0.99661194413605436182, 0.0012806283026930405725, 0.99637492395341797913 },
	{ 0.99661293132248618409, 0.0012802524596449448881, 0.9963759769052304982 },
	{ 0.99661392665329673335, 0.0012798763304945543536, 0.99637703723848236592 },
	{ 0.99661491637650234665, 0.0012795017653700426798, 0.99637809570253244029 },
	{ 0.99661590636673669241, 0.0012791294509169176801, 0.99637916625917288815 },
	{ 0.99661690959397064571, 0.0012787543517347888661, 0.99638023189485391828 },
	{ 0.99661786748352743093, 0.001278376677632005751, 0.99638125871599036998 },
	{ 0.99661887008133620558, 0.0012780041152235584612, 0.99638232639253443423 },
	{ 0.99661984654846869081, 0.0012776289969679433672, 0.99638337530076792614 },
	{ 0.99662082826081010989, 0.0012772544318434316934, 0.99638442590654174857 },
	{ 0.99662183190766073793, 0.001276884940266283068, 0.99638550294816763397 },
	{ 0.99662281712952360824, 0.0012765085440870839635, 0.99638654684007421647 },
	{ 0.99662378995362033152, 0.0012761361533400134103, 0.99638759611070393252 },
	{ 0.9966247711128305431, 0.0012757619124647691464, 0.99638864223420831046 },
	{ 0.99662577504578331311, 0.0012753939276930403249, 0.99638972028672900816 },
	{ 0.99662675130310751648, 0.0012750206977125715015, 0.99639076856553754347 },
	{ 0.99662774915161844724, 0.0012746478492018295785, 0.99639182607591347818 },
	{ 0.99662871587219969971, 0.0012742748481031967653, 0.99639286344468791512 },
	{ 0.99662971923294796373, 0.0012739058333632062234, 0.99639393619477956143 },
	{ 0.99663068255844844412, 0.0012735334044691631102, 0.99639496978700370367 },
	{ 0.99663166802826663737, 0.0012731629401442120381, 0.9963960271257183976 },
	{ 0.99663263764801757194, 0.0012727878028151106641, 0.99639705594957095336 },
	{ 0.99663362933579224823, 0.0012724197036024639459, 0.99639811859071492073 },
	{ 0.99663458733978993465, 0.0012720479041334698065, 0.99639915090501540718 },
	{ 0.99663560601654765936, 0.0012716823035475320527, 0.99640023672044497616 },
	{ 0.99663656045380355497, 0.0012713098365065165964, 0.99640126256883365663 },
	{ 0.99663753467026472421, 0.0012709400969740458978, 0.99640230701387155765 },
	{ 0.99663850383225205398, 0.0012705670958754128677, 0.99640333629548771821 },
	{ 0.99663950877609952528, 0.0012702011901136939839, 0.99640440654695261458 },
	{ 0.99664047152939538865, 0.0012698320037123267054, 0.99640544254243601507 },
	{ 0.99664142920914400303, 0.0012694586592909399853, 0.99640646591127146614 },
	{ 0.99664241359177341284, 0.0012690909606215064476, 0.99640751880586364564 },
	{ 0.99664339030686133203, 0.0012687261229750218441, 0.99640857120454517926 },
	{ 0.99664436629715669191, 0.001268353312611252481, 0.99640960189759941734 },
	{ 0.99664532241287928649, 0.0012679806929823461345, 0.99641062087953302662 },
	{ 0.99664631274643644687, 0.0012676184111830295521, 0.99641168880403241381 },
	{ 0.99664728177490946592, 0.0012672511893507540977, 0.99641272951066706121 },
	{ 0.99664823926392309694, 0.001266882079243332156, 0.99641375291764955335 },
	{ 0.99664921836319686488, 0.0012665154677626191786, 0.99641479785859810026 },
	{ 0.99665020303192852769, 0.0012661505728956757352, 0.99641585325181714072 },
	{ 0.99665115769806611468, 0.0012657809287306366532, 0.9964168713945172895 },
	{ 0.99665212153855076149, 0.0012654144698378145661, 0.99641790878236524698 },
	{ 0.99665309718552341778, 0.0012650455123182832978, 0.99641894119203311408 },
	{ 0.99665406169358006228, 0.0012646797591444550873, 0.99641997711122254344 },
	{ 0.99665504641953228671, 0.0012643183547255095519, 0.99642103568971374106 },
	{ 0.99665600161972756066, 0.0012639466506239468123, 0.99642204460084649043 },
	{ 0.99665695617142424645, 0.0012635831481215050592, 0.99642307659089768279 },
	{ 0.99665794391098727623, 0.0012632194930311728496, 0.99642412971437166469 },
	{ 0.99665887731018765194, 0.0012628504019972371878, 0.9964251301378030945 },
	{ 0.99665985436859816371, 0.0012624885779615926257, 0.99642618074357713898 },
	{ 0.9966608250183173201, 0.0012621227866407920722, 0.996427213115097965 },
	{ 0.99666177564087587992, 0.001261753829121260587, 0.99642822416246112915 },
	{ 0.99666274562302303863, 0.0012613929396864461286, 0.99642926780641249973 },
	{ 0.99666371068421077961, 0.0012610300666090533492, 0.9964303025621191745 },
	{ 0.99666465485993083195, 0.0012606638175245805586, 0.99643131563127207428 },
	{ 0.99666563952866260578, 0.0012603025847670121934, 0.99643236728608752806 },
	{ 0.99666659223023124081, 0.0012599363547560256827, 0.99643338239610346196 },
	{ 0.99666755109253590827, 0.0012595731955763380533, 0.99643440839707986267 },
	{ 0.99666851733627959131, 0.0012592113524672072112, 0.99643544273317008475 },
	{ 0.99666944140854518697, 0.0012588414794203321191, 0.99643642295777945517 },
	{ 0.99667041690293001199, 0.0012584833556410351951, 0.99643747566163676233 },
	{ 0.9966713932365481865, 0.0012581237822767773072, 0.99643851928651461236 },
	{ 0.99667233802261989695, 0.0012577599745985544241, 0.99643953472077972933 },
	{ 0.99667328225556051091, 0.001257395537495283001, 0.99644053960740686104 },
	{ 0.99667426335755027189, 0.0012570369940992868335, 0.99644159074723837044 },
	{ 0.99667521047058726946, 0.0012566749030348337013, 0.99644260835588094327 },
	{ 0.99667615670624398749, 0.0012563127738234077923, 0.99644362226426708151 },
	{ 0.99667711350861210029, 0.0012559515219923531471, 0.99644464315354919215 },
	{ 0.9966780683464111501, 0.0012555902510878117883, 0.99644566188752736746 },
	{ 0.99667902459564816642, 0.0012552293997999701067, 0.99644668703019689815 },
	{ 0.99667998084488507171, 0.0012548670226332219076, 0.99644770305574015268 },
	{ 0.99668092591705892414, 0.0012545060569044618956, 0.99644871526658607142 },
	{ 0.99668188775482735586, 0.0012541512137648135831, 0.99644975202500885025 },
	{ 0.99668281949463444214, 0.0012537859565016297361, 0.99645074594438132198 },
	{ 0.99668378560486392548, 0.0012534276038404965851, 0.99645177415788221964 },
	{ 0.99668472899857118996, 0.0012530698424574398479, 0.99645279518067886304 },
	{ 0.99668567531052176811, 0.0012527048140760922278, 0.99645379009187262653 },
	{ 0.99668661639633726601, 0.001252346919178631314, 0.99645480518281492888 },
	{ 0.99668757739487234826, 0.0012519926100966001416, 0.99645584064424053139 },
	{ 0.99668853299561088743, 0.0012516313773390317764, 0.99645685174882425716 },
	{ 0.99668946647110512327, 0.001251272547840740542, 0.99645785999238500885 },
	{ 0.99669042903366600328, 0.0012509154540297053385, 0.9964588844293356118 },
	{ 0.99669135997238655911, 0.0012505585509535333683, 0.99645989074647423056 },
	{ 0.99669230245056639195, 0.0012501962882277032826, 0.99646088758409012698 },
	{ 0.99669325326385982411, 0.0012498384314772149287, 0.9964619022554158656 },
	{ 0.9966942069763230494, 0.0012494809561964530416, 0.99646292150437820734 },
	{ 0.99669514821472615651, 0.0012491259604689140556, 0.99646393506944153096 },
	{ 0.9966960950988814627, 0.0012487688285109062921, 0.99646494924485651268 },
	{ 0.99669702735367260438, 0.0012484132415052911092, 0.9964659543603654468 },
	{ 0.9966979715675396978, 0.0012480574065443536362, 0.99646696815431057281 },
	{ 0.99669892121735037538, 0.0012476982718702814886, 0.99646797002732678816 },
	{ 0.99669986531677634556, 0.0012473418647047540986, 0.99646897859513683393 },
	{ 0.99670080270233540887, 0.0012469850760695000251, 0.99646998159348876278 },
	{ 0.99670174725952509487, 0.0012466266089674491943, 0.99647098039567372219 },
	{ 0.99670268651428550744, 0.00124627603828873822, 0.99647200311601047407 },
	{ 0.99670362725677807969, 0.0012459209281202811206, 0.99647300954758988301 },
	{ 0.99670455178680716912, 0.001245560668110515419, 0.99647399084031418326 },
	{ 0.99670550187530804198, 0.001245208876728679491, 0.99647501020371720415 },
	{ 0.99670643880310338947, 0.0012448526221510427744, 0.99647600976884154189 },
	{ 0.99670736340942656106, 0.0012444993048903005457, 0.99647700883805534477 },
	{ 0.99670829961242946027, 0.0012441438513990895395, 0.9964780076020932631 },
	{ 0.99670923726501725604, 0.001243788169026042523, 0.99647900781571607798 },
	{ 0.99671015319290423573, 0.0012434305220839036825, 0.99647998363434986402 },
	{ 0.99671110785904182272, 0.0012430793410536302313, 0.99648100589692290008 },
	{ 0.99671205123367545564, 0.0012427278548475754333, 0.99648201778351930269 },
	{ 0.99671298449936140962, 0.0012423757201429855984, 0.9964830217736925233 },
	{ 0.99671391408386444954, 0.001242018607258463898, 0.99648400339066611764 },
	{ 0.99671482938232636162, 0.0012416625434156904149, 0.99648498720109068838 },
	{ 0.99671578721466280726, 0.0012413153678175459487, 0.99648601415574156182 },
	{ 0.99671670278015334077, 0.0012409571295973311281, 0.99648698434769700238 },
	{ 0.99671765073242368782, 0.0012406106787916670355, 0.99648800645768231821 },
	{ 0.99671856799545455186, 0.0012402537947889815621, 0.99648898368775407075 },
	{ 0.99671951714935458355, 0.0012399051886793624119, 0.99649000162064593766 },
	{ 0.99672042008819738967, 0.0012395524817701828769, 0.99649097673356068494 },
	{ 0.99672135720672749848, 0.0012392005378004562755, 0.9964919747346591139 },
	{ 0.9967222658866896623, 0.0012388459807631025961, 0.99649294731080029219 },
	{ 0.9967231934875501187, 0.0012384939795729171547, 0.99649393762528393204 },
	{ 0.99672414037170531387, 0.0012381469184156905852, 0.9964949531739899502 },
	{ 0.99672506978454700199, 0.0012377973395582687714, 0.996495952777261218 },
	{ 0.99672598786773780599, 0.001237442229389811672, 0.99649692335068629223 },
	{ 0.99672691190185636056, 0.0012370935279127606883, 0.99649791986405289457 },
	{ 0.99672784993591378999, 0.0012367458564039714251, 0.99649892274796392222 },
	{ 0.99672877156677297528, 0.0012363955146070964609, 0.99649991273819815696 },
	{ 0.99672970118942272322, 0.0012360428649183757659, 0.99650089317261569821 },
	{ 0.99673062436523429675, 0.0012356965857740886267, 0.99650189607560035743 },
	{ 0.99673152512969942496, 0.0012353405600782877034, 0.99650285093247270574 },
	{ 0.996732454218291819, 0.0012349919539686683365, 0.99650384151398496702 },
	{ 0.99673337232055614354, 0.0012346450644728189372, 0.99650483285843682868 },
	{ 0.99673431260528499998, 0.0012342953711744792267, 0.99650582883774574405 },
	{ 0.99673522981109552443, 0.0012339479285475261905, 0.99650681653916173275 },
	{ 0.99673613534393235014, 0.0012335962897535809359, 0.99650778066574852154 },
	{ 0.99673707398834143767, 0.0012332524329420574243, 0.99650879056870256267 },
	{ 0.99673797501983552038, 0.0012329028540846356105, 0.99650976148545056255 },
	{ 0.99673890017928978846, 0.0012325544768568524705, 0.99651074489533209011 },
	{ 0.99673982093276869421, 0.0012322065383192546371, 0.99651172996460690712 },
	{ 0.99674075324478028648, 0.0012318619948622233119, 0.99651273307739973717 },
	{ 0.99674166079940651475, 0.001231510470509195954, 0.99651369464813932542 },
	{ 0.99674257846298075503, 0.0012311616545912272905, 0.99651466602265081907 },
	{ 0.99674350314559789776, 0.0012308192473646649596, 0.99651567127167417492 },
	{ 0.99674441543044900449, 0.0012304700881239423894, 0.99651663970886883437 },
	{ 0.99674535237731787252, 0.001230126402973796048, 0.99651763956009542511 },
	{ 0.99674625068130351391, 0.0012297784835096847115, 0.99651860622345600493 },
	{ 0.99674715968551486078, 0.0012294304686781417583, 0.99651957443176886198 },
	{ 0.99674804919662318703, 0.0012290834075209151888, 0.99652053520142191978 },
	{ 0.99674899135055372579, 0.0012287392455336103303, 0.99652153243958074835 },
	{ 0.99674990104141059089, 0.0012283964186903485391, 0.99652251964508586912 },
	{ 0.99675081309737978419, 0.0012280493956800947464, 0.99652349059998079905 },
	{ 0.99675172086181451636, 0.0012277030020948894937, 0.99652445447861237593 },
	{ 0.99675263425292770503, 0.0012273560172316082609, 0.99652542524277221148 },
	{ 0.99675356118621627477, 0.0012270139533277998369, 0.99652641893326276978 },
	{ 0.99675444032134818961, 0.0012266639930006513395, 0.99652736001907826768 },
	{ 0.99675536000671194348, 0.0012263231497999678692, 0.99652834981857763008 },
	{ 0.99675624326171696765, 0.0012259750205275070194, 0.99652929639755716273 },
	{ 0.99675718806686242068, 0.0012256347686048997461, 0.99653029968201145561 },
	{ 0.99675810737075654089, 0.0012252945357557785359, 0.99653128940521706891 },
	{ 0.99675897082748277089, 0.0012249457579847824323, 0.99653222114502415518 },
	{ 0.99675991748275638571, 0.0012246082335707199167, 0.99653323371826640908 },
	{ 0.99676079347076307346, 0.0012242573767897138755, 0.99653416204391953581 },
	{ 0.99676173692169078855, 0.0012239221411940108108, 0.99653517873703478802 },
	{ 0.99676260512771508449, 0.0012235715514418135565, 0.99653610172211171125 },
	{ 0.99676354203643702245, 0.0012232347708937179112, 0.99653710512100701635 },
	{ 0.99676443995895291916, 0.0012228899794813642959, 0.99653806339203354625 },
	{ 0.99676533906402497998, 0.0012225472480055343382, 0.99653902704178332073 },
	{ 0.99676624045791539785, 0.0012222050505873215207, 0.99653999214111799176 },
	{ 0.99676713397445604325, 0.0012218599349257002785, 0.99654094150482652736 },
	{ 0.99676804187240530819, 0.0012215184432264815546, 0.9965419116586351489 },
	{ 0.99676894526901183013, 0.0012211776381727708612, 0.99654288066803442536 },
	{ 0.99676985310974064447, 0.0012208376914259449347, 0.99654385423599700644 },
	{ 0.9967707513183589052, 0.0012204947501417654637, 0.99654480905472264674 },
	{ 0.9967716500610348529, 0.0012201538687941092167, 0.99654577127396104519 },
	{ 0.99677256129684432828, 0.0012198163634535331978, 0.99654675399719727658 },
	{ 0.99677346938552846556, 0.0012194769698378104747, 0.99654772785126222168 },
	{ 0.99677434659423824748, 0.0012191342383619803002, 0.99654866884171022789 },
	{ 0.9967752480072021859, 0.0012187940436598320836, 0.99654962961136350774 },
	{ 0.99677614049377449845, 0.00121845331490006651, 0.99655058710037724978 },
	{ 0.9967770535034182755, 0.0012181129676100274032, 0.99655155336319456438 },
	{ 0.99677796546402031019, 0.0012177770262953300281, 0.99655253360687734432 },
	{ 0.99677883315506043971, 0.0012174330168959160599, 0.99655346157013413588 },
	{ 0.9967797101921087588, 0.0012170884352919119579, 0.99655439186035632559 },
	{ 0.99678062236251885331, 0.0012167536574598806966, 0.99655537605225086306 },
	{ 0.99678152648391771251, 0.0012164199858900567094, 0.99655635639130102366 },
	{ 0.99678244058075005096, 0.0012160805350538753632, 0.99655731939255232099 },
	{ 0.9967833250755314678, 0.0012157409697767761203, 0.99655826763092503207 },
	{ 0.99678420936050460277, 0.0012154028731581239045, 0.99655921897827615119 },
	{ 0.99678511310043393934, 0.0012150634795424013982, 0.99656017764984605734 },
	{ 0.99678598185958910971, 0.001214722064137128011, 0.99656110973297584721 },
	{ 0.99678689204635673171, 0.001214388354420331247, 0.99656208553253633475 },
	{ 0.9967877975028996973, 0.001214051745533612555, 0.99656305202423556278 },
	{ 0.99678866359176698797, 0.00121371544182267521, 0.99656399501739967306 },
	{ 0.99678955554428161356, 0.0012133711272474798949, 0.99656492633759019562 },
	{ 0.99679044972839425665, 0.0012130393820997747382, 0.99656589509903426016 },
	{ 0.99679133439483691426, 0.001212701972126630336, 0.99656684621750357689 },
	{ 0.99679223248901405174, 0.0012123658591505560075, 0.99656780176102155444 },
	{ 0.99679311994018593435, 0.0012120301657911811393, 0.99656875513016229817 },
	{ 0.99679401320877103476, 0.0012116914016005076067, 0.99656970096527575098 },
	{ 0.99679488051834119755, 0.0012113526564833201372, 0.99657062931000228723 },
	{ 0.99679577899398807972, 0.0012110192137953319433, 0.99657159484802715355 },
	{ 0.99679666846694947591, 0.0012106842452284374487, 0.99657254627167213279 },
	{ 0.99679755938949587968, 0.0012103497344252147575, 0.99657350051819315606 },
	{ 0.99679844899597180863, 0.0012100150901075878897, 0.9965744507020615206 },
	{ 0.99679933932724007484, 0.0012096811324354688356, 0.99657540782867892748 },
	{ 0.99680021230163584622, 0.0012093447715040722169, 0.99657634176193699016 },
	{ 0.99680108991088878234, 0.0012090082389112988617, 0.99657727903305515227 },
	{ 0.99680197904052736391, 0.001208673003315595797, 0.99657822614609214984 },
	{ 0.99680287122192390292, 0.0012083374625441116023, 0.99657917264877771135 },
	{ 0.99680374867858900778, 0.0012080071860548539063, 0.99658012273727869523 },
	{ 0.99680463775100713875, 0.0012076734191175983023, 0.9965810749047896433 },
	{ 0.9968055139106751783, 0.0012073343688246297029, 0.99658200050293421768 },
	{ 0.99680640361251837689, 0.0012070035201307816562, 0.99658295589386436397 },
	{ 0.99680728141250629637, 0.0012066716033216995461, 0.99658390205322699984 },
	{ 0.99680816621246348674, 0.0012063385611769243157, 0.99658484601913877032 },
	{ 0.9968090329116823245, 0.0012060040885206744013, 0.99658577619492005883 },
	{ 0.99680991925659179209, 0.0012056714087721391408, 0.99658672304092854599 },
	{ 0.99681077084960945101, 0.0012053337317701861685, 0.99658763475357514672 },
	{ 0.99681166835250867297, 0.0012050022536512897987, 0.99658858661591032124 },
	{ 0.9968125313705447077, 0.0012046698981520219483, 0.99658951665817718801 },
	{ 0.99681344623031631347, 0.0012043426543470903568, 0.99659049293457502294 },
	{ 0.99681430179061902841, 0.0012040065032240434683, 0.99659140556274894429 },
	{ 0.9968151820701601773, 0.0012036776763197465194, 0.99659235725342276702 },
	{ 0.99681604117813138455, 0.0012033434706923051751, 0.99659327617584725356 },
	{ 0.99681693938674953426, 0.0012030119734999223085, 0.996594224891057201 },
	{ 0.99681781379165679269, 0.0012026807814833207887, 0.99659516109406032225 },
	{ 0.99681871053161652529, 0.0012023560935255567846, 0.99659613111435452204 },
	{ 0.9968195683807375973, 0.0012020207053419630465, 0.99659704450546782173 },
	{ 0.99682042424621608578, 0.0012016888266798537131, 0.99659796079575124761 },
	{ 0.99682126845779439606, 0.0012013508635756058908, 0.99659885848938545294 },
	{ 0.99682218505325348445, 0.0012010299712416213583, 0.99659984741150464682 },
	{ 0.99682305129470849536, 0.0012006993132826369788, 0.99660077163635818476 },
	{ 0.99682392146530163224, 0.0012003698378798052099, 0.99660170726715657796 },
	{ 0.99682479861679074151, 0.001200038951038985037, 0.99660264331757153489 },
	{ 0.99682567450942993759, 0.0011997109252211140152, 0.99660357994019133088 },
	{ 0.99682652507247915263, 0.0011993780165907429614, 0.99660449153839691938 },
	{ 0.99682739743652326592, 0.0011990472632643267483, 0.9966054145616208837 },
	{ 0.99682827180328348327, 0.0011987184745070025762, 0.99660635370194072813 },
	{ 0.99682914235534647585, 0.001198390601277022011, 0.9966072849839842096 },
	{ 0.99683001830520623354, 0.0011980612975355669787, 0.99660821651398323606 },
	{ 0.99683087600173947429, 0.0011977339965101763304, 0.99660914531647359915 },
	{ 0.99683174987258893474, 0.0011974060851332232053, 0.99661007900177644991 },
	{ 0.99683261475982642974, 0.0011970769339796588464, 0.99661100236832311783 },
	{ 0.99683350642623880233, 0.0011967527800795124161, 0.99661195449768724686 },
	{ 0.9968343398040770964, 0.0011964217978712604097, 0.99661285066544236244 },
	{ 0.99683520520629875783, 0.0011960933524366899276, 0.99661377374588677736 },
	{ 0.99683607400360085826, 0.0011957678443190139332, 0.99661470907150950804 },
	{ 0.99683694304885828164, 0.0011954394561049027246, 0.99661563232361527476 },
	{ 0.99683779731216393127, 0.0011951110106703322425, 0.99661654701172563975 },
	{ 0.99683867261352498979, 0.0011947838431593457709, 0.99661747823654878164 },
	{ 0.99683952657165497691, 0.001194456160664228439, 0.99661839551865338827 },
	{ 0.99684038402023289471, 0.0011941306716200389415, 0.9966193195718455744 },
	{ 0.99684127547683687443, 0.001193808062672284875, 0.9966202691644359124 },
	{ 0.99684214316787689292, 0.001193479006886151916, 0.99662118659912835028 },
	{ 0.99684299273910503825, 0.0011931558638807809262, 0.99662210895478020589 },
	{ 0.99684383695068334852, 0.001192824805378583583, 0.99662300504624146136 },
	{ 0.99684470366897548477, 0.0011925008422133003862, 0.99662393596588849665 },
	{ 0.99684555709304778492, 0.0011921756774183785155, 0.9966248531716990211 },
	{ 0.99684642177047699807, 0.0011918494826551947075, 0.99662576980530503956 },
	{ 0.99684728467407202057, 0.0011915240317579775531, 0.99662669233261824697 },
	{ 0.99684814107360797397, 0.0011911990958448914757, 0.99662760946213480029 },
	{ 0.99684900678100540894, 0.0011908772116896179996, 0.99662854337631934243 },
	{ 0.99684985211791954374, 0.0011905494529005555479, 0.9966294436448740468 },
	{ 0.99685069518508873099, 0.0011902223235365418531, 0.99663034206330058939 },
	{ 0.99685156299056965068, 0.0011898993331190613199, 0.99663126975952853748 },
	{ 0.99685242267074536393, 0.0011895737105604674289, 0.99663218437134493133 },
	{ 0.99685326041641175721, 0.0011892480498549009779, 0.99663308353363744274 },
	{ 0.99685414248886028421, 0.00118892917931046776, 0.99663402809082723977 },
	{ 0.99685499446334746576, 0.0011886034804579285323, 0.99663493743836129024 },
	{ 0.99685583302917391002, 0.0011882822257277035963, 0.99663585069596016819 },
	{ 0.99685669106902985437, 0.0011879560309645200052, 0.99663675291001041501 },
	{ 0.99685753934326071235, 0.0011876320487257505283, 0.99663766122757635468 },
	{ 0.99685841155471699437, 0.0011873128920790220267, 0.99663859397827814224 },
	{ 0.99685925406875508514, 0.0011869858199354673886, 0.99663948944031421906 },
	{ 0.99686010291519044912, 0.0011866682845350768043, 0.99664041274964032535 },
	{ 0.99686097068252432774, 0.001186347087025310925, 0.99664134002625159869 },
	{ 0.99686180940093871428, 0.0011860225516554378112, 0.9966422361940068253 },
	{ 0.9968626780456527614, 0.001185701926350261632, 0.9966431606095953466 },
	{ 0.99686349757613956779, 0.0011853762084242363412, 0.99664403926789002508 },
	{ 0.9968643477195721081, 0.0011850560027357598392, 0.99664495456635182613 },
	{ 0.99686519896926684137, 0.0011847330886122248595, 0.99664585670410821283 },
	{ 0.99686605445327536312, 0.0011844154769178891554, 0.99664678344666191023 },
	{ 0.99686692634048235107, 0.0011840953475233577732, 0.99664770782410327943 },
	{ 0.9968677540916419666, 0.00118377235710587724, 0.99664859622894941271 },
	{ 0.99686860822143308347, 0.0011834524756666683649, 0.9966495088761968546 },
	{ 0.9968694521850560708, 0.0011831331092115901331, 0.99665041875778859204 },
	{ 0.99687028922500353634, 0.0011828103286024591132, 0.99665131038605403457 },
	{ 0.99687116450729107431, 0.0011824932128187677725, 0.99665224487244308271 },
	{ 0.99687198966445655923, 0.0011821705275770685861, 0.99665312976776776477 },
	{ 0.99687282363357276882, 0.0011818481856581233066, 0.99665401866852454393 },
	{ 0.99687368173064916377, 0.0011815310508009456859, 0.99665493761002221795 },
	{ 0.99687453284682958632, 0.001181212809681561008, 0.99665585052429828128 },
	{ 0.99687534980239600468, 0.0011808890181776547645, 0.99665672363220836338 },
	{ 0.99687619912566871605, 0.0011805686408278010923, 0.99665762510239264138 },
	{ 0.99687708447875700291, 0.0011802564841505549034, 0.99665857408463132128 },
	{ 0.99687791448058804544, 0.0011799339896437187336, 0.99665945489822993508 },
	{ 0.99687874009551713517, 0.001179616263508464916, 0.99666035139023423373 },
	{ 0.99687958871307080777, 0.0011792995673414728187, 0.99666125814377426462 },
	{ 0.99688039870681455223, 0.0011789757186171077354, 0.99666212512909513332 },
	{ 0.99688124694289859118, 0.0011786594039198423217, 0.99666303684174162303 },
	{ 0.9968821098464937247, 0.0011783444434401062553, 0.99666395479141811631 },
	{ 0.996882931837460462, 0.0011780253821608093704, 0.99666484209000205663 },
	{ 0.9968837805122345852, 0.0011777070266005067959, 0.9966657433313044212 },
	{ 0.99688463618697831237, 0.0011773917418715028858, 0.99666665584503733033 },
	{ 0.99688548360290230033, 0.0011770771247145207263, 0.99666756811081480549 },
	{ 0.99688629039230025608, 0.0011767540007826360164, 0.99666842788635812145 },
	{ 0.99688714269103695376, 0.0011764385825392279297, 0.99666933687149583676 },
	{ 0.99688797978820486989, 0.0011761227256056343195, 0.9966702319520621689 },
	{ 0.99688881186904598763, 0.0011758040648695501813, 0.99667112224518350505 },
	{ 0.99688964942397761959, 0.0011754895812269721984, 0.99667202327667747674 },
	{ 0.99689047728957813632, 0.0011751681548353705258, 0.99667289966522709665 },
	{ 0.99689129878463422774, 0.0011748542433973822429, 0.996673788680424666 },
	{ 0.99689213029327061744, 0.0011745348960157905079, 0.99667467081009375462 },
	{ 0.99689299004974019081, 0.001174226134419111044, 0.99667559892593848847 },
	{ 0.99689382211150767699, 0.001173906767964033029, 0.99667648073135828302 },
	{ 0.99689466100158319328, 0.001173592551350263833, 0.99667737913071119404 },
	{ 0.9968954827827415377, 0.0011732779723402540165, 0.99667826553284133428 },
	{ 0.99689629908980925688, 0.001172957652210859401, 0.99667913066803415223 },
	{ 0.99689715062560635417, 0.001172646124958661969, 0.99668004125534492843 },
	{ 0.99689798291625564275, 0.0011723323279615915828, 0.99668093564926574235 },
	{ 0.99689880723418755615, 0.0011720180350538766164, 0.99668182184158737869 },
	{ 0.99689964969100519632, 0.0011717049819227731006, 0.99668272033630767037 },
	{ 0.99690046840133228478, 0.0011713870650526560496, 0.99668359321533583906 },
	{ 0.99690130858840508843, 0.0011710780364271677987, 0.99668450122772600519 },
	{ 0.99690212489547291863, 0.0011707602339979686443, 0.99668536880432501146 },
	{ 0.99690294873656781771, 0.0011704474097487011387, 0.99668625699936275186 },
	{ 0.99690377360763093861, 0.0011701334792372265758, 0.99668713874756198479 },
	{ 0.99690461978377831187, 0.0011698239547010939616, 0.99668804824768397754 },
	{ 0.99690544534148683997, 0.0011695041877028027662, 0.99668890943466526 },
	{ 0.99690627475203974495, 0.0011691953688856640287, 0.99668981037079196206 },
	{ 0.9969070789283702716, 0.0011688784819838084813, 0.99669067199646332877 },
	{ 0.9969079281181284502, 0.0011685668593641794326, 0.99669156986175866386 },
	{ 0.99690873752059427915, 0.0011682529097792185898, 0.9966924418252594009 },
	{ 0.99690958703460175183, 0.0011679462271925488467, 0.99669335630356137301 },
	{ 0.99691040502013639202, 0.001167628195881513899, 0.99669421678482350568 },
	{ 0.99691122264327491909, 0.0011673164016005081137, 0.99669509563385283446 },
	{ 0.99691203395308924939, 0.0011670028334852737377, 0.99669596797882331618 },
	{ 0.99691287402572104082, 0.0011666931563612502332, 0.99669686420379877134 },
	{ 0.99691369058074419396, 0.0011663804084059280642, 0.99669773710190046057 },
	{ 0.99691451852263879285, 0.0011660724860426468705, 0.99669863218246679271 },
	{ 0.99691535798491892617, 0.0011657631140944047128, 0.99669952749191481622 },
	{ 0.99691614959182195399, 0.0011654470473524615893, 0.99670037414489931482 },
	{ 0.99691697486342811807, 0.0011651366072889851513, 0.99670125526367359114 },
	{ 0.99691779578627959246, 0.0011648247176405475325, 0.99670213111816563512 },
	{ 0.99691861558379546437, 0.0011645131140944047637, 0.99670300386367938206 },
	{ 0.99691944302977930636, 0.0011642071372267288974, 0.99670389982162599374 },
	{ 0.99692027478637113003, 0.001163895400166181952, 0.99670477827011216831 },
	{ 0.996921072115319995, 0.0011635839110609570799, 0.99670563804565537325 },
	{ 0.99692191474379898697, 0.0011632765609022655863, 0.99670653987823576436 },
	{ 0.9969227105659426158, 0.0011629635268446485673, 0.99670738941131664657 },
	{ 0.99692352691115737606, 0.0011626525527235547722, 0.99670825824676567706 },
	{ 0.99692436137618423153, 0.0011623465758558791227, 0.99670915725647013517 },
	{ 0.99692517642440181547, 0.0011620373564955276385, 0.99671002525268570515 },
	{ 0.99692598143996580262, 0.0011617267256971875334, 0.99671088993011469626 },
	{ 0.99692681657256443373, 0.0011614210349318067339, 0.99671178525863635134 },
	{ 0.99692762162627535094, 0.0011611115866896192395, 0.99671264890609712062 },
	{ 0.99692843196334191003, 0.0011607976180311721168, 0.99671350025115923454 },
	{ 0.99692926364363987357, 0.0011604943495985549449, 0.99671439937530459385 },
	{ 0.99693007266463584681, 0.0011601858168837112743, 0.99671527004180837661 },
	{ 0.99693087874831498585, 0.0011598756438490434063, 0.99671612548766996831 },
	{ 0.99693169042052565132, 0.0011595690375563189999, 0.99671700094161874706 },
	{ 0.99693250230254459865, 0.001159259169697432262, 0.99671786416946284159 },
	{ 0.99693333295287411833, 0.0011589552527662800533, 0.99671875654159425295 },
	{ 0.99693413072051317858, 0.001158644316792159035, 0.99671960550247051813 },
	{ 0.99693495713652879875, 0.0011583403617140340496, 0.99672049295364228971 },
	{ 0.99693574166716847351, 0.0011580271750685263571, 0.99672132783828581992 },
	{ 0.996936576704399946, 0.00115772741615739359, 0.9967222313874800621 },
	{ 0.99693738469542780845, 0.0011574212867018270502, 0.99672309980331252888 },
	{ 0.99693820004882138797, 0.0011571132880446005197, 0.99672396413741881638 },
	{ 0.9969390031951836928, 0.0011568040686842490355, 0.99672482023177899624 },
	{ 0.99693983437957089944, 0.0011565019828077842574, 0.99672570901809476318 },
	{ 0.99694062463225641135, 0.0011561932975050499134, 0.9967265572541786911 },
	{ 0.99694143144072810969, 0.0011558830100294641488, 0.99672740846572638329 },
	{ 0.99694223897399214529, 0.0011555781012770227796, 0.99672827520309192906 },
	{ 0.99694303880156776021, 0.0011552726584669640534, 0.99672913621841152665 },
	{ 0.99694386628569853226, 0.0011549709922071985189, 0.99673002534805010821 },
	{ 0.99694464717330200099, 0.001154663699268966082, 0.99673086421905221499 },
	{ 0.99694544272841667532, 0.001154354670643478048, 0.99673170799194032998 },
	{ 0.99694626481475079327, 0.0011540503913160856525, 0.99673258565841360568 },
	{ 0.99694704892577368227, 0.0011537441855665739928, 0.99673343194900188013 },
	{ 0.99694788859786209745, 0.0011534427672621307484, 0.99673432281432772228 },
	{ 0.99694867518843821586, 0.0011531374388929901357, 0.99673517074523576564 },
	{ 0.99694949544371769257, 0.0011528346091505584873, 0.99673604600844967205 },
	{ 0.99695031598509942228, 0.0011525351554152068502, 0.9967369281953393223 },
	{ 0.99695107423247486533, 0.0011522241431471402784, 0.99673774015365235179 },
	{ 0.99695188847960602985, 0.0011519193106886440291, 0.99673860536513902986 },
	{ 0.99695269614638437616, 0.0011516174346205287644, 0.99673947162566745028 },
	{ 0.99695348586501231214, 0.001151311419605880338, 0.99674031383452965649 },
	{ 0.99695428321303469765, 0.0011510075408217006893, 0.99674116977630211611 },
	{ 0.9969551179450903966, 0.0011507090026136928759, 0.99674205638824042719 },
	{ 0.99695591361464608315, 0.0011504039031263882734, 0.99674290821013977748 },
	{ 0.99695673217238534036, 0.0011501035338636930293, 0.99674378307281075173 },
	{ 0.99695750951232076087, 0.0011497989875074918469, 0.99674461885390819305 },
	{ 0.99695831326903450176, 0.001149495413899093545, 0.99674547403274094126 },
	{ 0.99695910718382940718, 0.0011491943579908902705, 0.99674633294997727617 },
	{ 0.99695988437117677439, 0.0011488871031996303936, 0.99674715797362833936 },
	{ 0.99696068665923220919, 0.0011485887747999723105, 0.99674802469192069765 },
	{ 0.99696149957121948937, 0.0011482850486036831183, 0.99674888185439614041 },
	{ 0.99696230296553711714, 0.0011479879790541227657, 0.99674975616393590716 },
	{ 0.99696310267867183086, 0.0011476838713881071068, 0.99675060104308610409 },
	{ 0.99696389083327396907, 0.0011473827773329314892, 0.99675144809661386791 },
	{ 0.99696466817320916753, 0.0011470763617750700993, 0.99675227758346074403 },
	{ 0.99696546689452270051, 0.0011467761451002655287, 0.99675313230453010949 },
	{ 0.99696627641142954168, 0.0011464756613966526049, 0.99675399118361940332 },
	{ 0.99696708018721669209, 0.0011461769133802952782, 0.99675485637603267186 },
	{ 0.99696785834731194154, 0.0011458742171522682401, 0.9967556884759470881 },
	{ 0.99696866012038320992, 0.00114557537376847908, 0.99675654884276820855 },
	{ 0.99696946965636346061, 0.0011452760535475320532, 0.99675741300521325527 },
	{ 0.99697025081099599486, 0.0011449781829115457735, 0.99675826023040237089 },
	{ 0.9969710375541598335, 0.0011446736174818583111, 0.99675908969817583749 },
	{ 0.9969718131011874318, 0.0011443708258863994395, 0.99675991926131657372 },
	{ 0.99697259683074057612, 0.0011440710288282938956, 0.99676076356826237568 },
	{ 0.99697341590346399975, 0.0011437750273939678233, 0.99676163818297791597 },
	{ 0.99697421325148638527, 0.001143473895191819429, 0.99676248176513115862 },
	{ 0.99697500050963450136, 0.0011431754142042706724, 0.99676332632003239453 },
	{ 0.99697577825011307606, 0.0011428737479445051379, 0.9967641589921514278 },
	{ 0.9969765618080049796, 0.0011425785475966049928, 0.99676501365600012061 },
	{ 0.99697736226500566215, 0.0011422751456495834274, 0.99676585092482938855 },
	{ 0.99697814374388737946, 0.001141977217793138091, 0.99676669298110376349 },
	{ 0.99697894723357227686, 0.0011416859656569076573, 0.99676757009444594271 },
	{ 0.99697973815382978646, 0.0011413818007704329416, 0.99676839332518940573 },
	{ 0.9969805302947902792, 0.0011410875922438217401, 0.9967692505830324512 },
	{ 0.99698131707610115892, 0.0011407893210646224968, 0.99677009466109633973 },
	{ 0.99698208802641841153, 0.0011404881888624743193, 0.99677091672835704816 },
	{ 0.99698287696303322658, 0.0011401912719008044234, 0.99677176055846561376 },
	{ 0.99698366111220315666, 0.0011398935729261950971, 0.99677260116515509214 },
	{ 0.99698444922865825379, 0.0011395937377211172101, 0.99677343322692268934 },
	{ 0.99698523890913914869, 0.0011393003493544182157, 0.99677429180083609861 },
	{ 0.99698602899016319778, 0.0011390025550123774895, 0.99677513509688708826 },
	{ 0.99698680488051349968, 0.0011387042266127194064, 0.99677596176085814239 },
	{ 0.99698760985793033473, 0.0011384084349867430643, 0.99677681709227894391 },
	{ 0.99698837218703184604, 0.0011381087523695556339, 0.99677763435302102479 },
	{ 0.99698914504469771103, 0.0011378116637465090014, 0.99677846366820666013 },
	{ 0.99698996020735630719, 0.0011375221663710208785, 0.99677934307036730743 },
	{ 0.99699072579802383576, 0.0011372223502394292714, 0.99678015905318573253 },
	{ 0.99699150456847063229, 0.0011369257575270272191, 0.99678099008498521894 },
	{ 0.99699227818907598664, 0.0011366269904371833956, 0.99678181497512186038 },
	{ 0.99699308537901742966, 0.0011363373786207771592, 0.9967826874726803954 },
	{ 0.99699386317671634394, 0.0011360406142469979367, 0.99678351333556491909 },
	{ 0.99699463653029296584, 0.0011357428771254160504, 0.99678433963713952704 },
	{ 0.99699541190565910131, 0.0011354438811537364337, 0.99678516078887291485 },
	{ 0.99699620040358383211, 0.0011351531249281503633, 0.99678601352629958576 },
	{ 0.99699697181166491156, 0.0011348559600111579604, 0.99678683284697822131 },
	{ 0.99699775237501930825, 0.0011345639830824471531, 0.99678767764983466915 },
	{ 0.99699854731978254652, 0.0011342706710096932786, 0.99678852729735667459 },
	{ 0.99699929255904029546, 0.0011339722090956310188, 0.99678932746825499311 },
	{ 0.99700006694258513917, 0.0011336766463514904701, 0.99679014915404584585 },
	{ 0.99700086440504842589, 0.0011333826476332285651, 0.99679099643645541207 },
	{ 0.99700163213194648026, 0.0011330885535475350434, 0.99679182115493070171 },
	{ 0.99700240804137019168, 0.0011327945166823003616, 0.99679265230117075625 },
	{ 0.99700318570555468423, 0.0011325031501051518144, 0.99679349466262079371 },
	{ 0.99700396819533110282, 0.0011322081786390874626, 0.99679432361541020491 },
	{ 0.9970047610801576754, 0.0011319197493788336201, 0.99679517639098380588 },
	{ 0.99700551295698858212, 0.0011316209059950444599, 0.996795976333000322 },
	{ 0.99700628163756110922, 0.0011313278800245856522, 0.99679680044112406456 },
	{ 0.99700708356322009784, 0.0011310392600294683595, 0.99679766218123622146 },
	{ 0.99700785865248409134, 0.0011307458525892828682, 0.99679848510680379992 },
	{ 0.99700859561384891361, 0.0011304476577040289617, 0.9967992750924606904 },
	{ 0.99700938258589488772, 0.0011301587325331305389, 0.99680012126860806365 },
	{ 0.99701017180861206679, 0.0011298665648695564983, 0.99680095802245327619 },
	{ 0.9970109281104919674, 0.0011295726042982675869, 0.99680176818785859449 },
	{ 0.99701171164931046142, 0.0011292810088392830296, 0.99680260513243867937 },
	{ 0.99701247146071170224, 0.0011289858275648689476, 0.99680341285643780935 },
	{ 0.99701324229658816467, 0.0011286978560682869085, 0.99680424915251930607 },
	{ 0.99701402820051876486, 0.0011284074050184819682, 0.99680508251128396857 },
	{ 0.99701480826796273771, 0.0011281182891127200952, 0.9968059263604660547 },
	{ 0.99701554919661272702, 0.0011278236037489505934, 0.99680671878752891146 },
	{ 0.99701633820952173526, 0.0011275322180983157663, 0.99680755315718827525 },
	{ 0.99701709010542627354, 0.0011272413283583257362, 0.99680836715636422785 },
	{ 0.99701787095488303425, 0.0011269512015577884227, 0.99680919908461729229 },
	{ 0.9970186425918459161, 0.0011266608268019288192, 0.9968100219911113502 },
	{ 0.9970193835586429465, 0.0011263666373488038976, 0.99681081666884563397 },
	{ 0.9970201827377201953, 0.0011260793906447022321, 0.99681166971144807842 },
	{ 0.99702093427122839842, 0.0011257869178053468446, 0.99681247289595731331 },
	{ 0.99702171674193151851, 0.0011255024939772217702, 0.99681331884322277315 },
	{ 0.99702248979033236687, 0.0011252124625441162903, 0.99681414361891851339 },
	{ 0.99702321933211102145, 0.0011249168044325441249, 0.9968149235147009124 },
	{ 0.99702399972380395532, 0.0011246295386549561793, 0.99681575864729965453 },
	{ 0.99702477958143942427, 0.0011243415862318604202, 0.99681659068999373119 },
	{ 0.99702552806318989198, 0.0011240492659803957062, 0.99681738975462985675 },
	{ 0.99702630649031387389, 0.0011237621718641847141, 0.99681822280821863469 },
	{ 0.99702705953062753519, 0.0011234707099196045502, 0.9968190260118012791 },
	{ 0.99702781609953616826, 0.0011231786948439209661, 0.99681982889113474045 },
	{ 0.99702858483732914596, 0.0011228915244337646373, 0.99682065439162292897 },
	{ 0.99702933808745108912, 0.0011226029044386473445, 0.99682146501479185208 },
	{ 0.99703013078154290039, 0.001122321074604663068, 0.99682231935439136183 },
	{ 0.99703087205351570432, 0.001122029021382006924, 0.99682311128554368373 },
	{ 0.99703164063872073974, 0.0011217389518019288842, 0.99682392473158842883 },
	{ 0.99703239743651128624, 0.0011214506751295654982, 0.99682473318037978505 },
	{ 0.99703315082014776216, 0.001121160739063891635, 0.99682553951201424702 },
	{ 0.99703392125548095937, 0.0011208777076002684678, 0.99682637060103385096 },
	{ 0.99703467097700804178, 0.0011205865508314698676, 0.9968271707147118299 },
	{ 0.99703543975294794954, 0.0011203010970350832896, 0.99682799182829828766 },
	{ 0.99703619407118537765, 0.0011200127822157473437, 0.9968288001626488537 },
	{ 0.99703694077910165472, 0.0011197255164381593982, 0.99682960260329200874 },
	{ 0.99703772355498054836, 0.0011194413977858156707, 0.99683043786940517261 },
	{ 0.9970384752029297637, 0.001119153617024096865, 0.99683124261794020526 },
	{ 0.99703923364104007909, 0.0011188686591383546504, 0.99683205964980037272 },
	{ 0.99703999986113278631, 0.0011185827857252686121, 0.99683288003859416015 },
	{ 0.99704072650374120368, 0.0011182911711927977748, 0.99683365398344869757 },
	{ 0.99704149028242772257, 0.001118004840016039933, 0.99683446353850224675 },
	{ 0.99704222701491063141, 0.0011177158766981687334, 0.99683525443968612478 },
	{ 0.99704299418867781135, 0.0011174330168959227365, 0.9968360794442635564 },
	{ 0.99704374339522083837, 0.0011171452361342039308, 0.99683687747893146014 },
	{ 0.99704450358809193489, 0.0011168611174818602032, 0.99683769626555240873 },
	{ 0.99704525840223978683, 0.0011165738326307857609, 0.99683849800047663603 },
	{ 0.99704602424086286039, 0.0011162883406874264062, 0.99683931144652138112 },
	{ 0.99704678155363768433, 0.0011160068351027097565, 0.99684013090071432739 },
	{ 0.99704753205717766562, 0.0011157218772169675419, 0.99684093206343393767 },
	{ 0.99704827187956523993, 0.001115433562397631596, 0.99684172437605589323 },
	{ 0.99704905196608251128, 0.0011151529341932859933, 0.99684255851683345462 },
	{ 0.9970497885078306588, 0.0011148662215468014679, 0.996843345107409462 },
	{ 0.99705052466810895062, 0.0011145797377821531696, 0.9968441351312130605 },
	{ 0.99705129287184435238, 0.0011142964583632077123, 0.9968449520104853967 },
	{ 0.99705206134260859763, 0.0011140152770277584725, 0.99684577640471128124 },
	{ 0.99705280864180301226, 0.0011137304717299067146, 0.99684657695707934444 },
	{ 0.99705352633894650527, 0.001113443225025805049, 0.99684734714445710768 },
	{ 0.99705429694594105428, 0.0011131596785780510216, 0.99684816322264313548 },
	{ 0.99705504943312373012, 0.0011128780776259025384, 0.99684897491392721047 },
	{ 0.99705578462065425072, 0.0011125908499952873697, 0.99684975667891118079 },
	{ 0.99705654252470699017, 0.0011123087149855217463, 0.99685056615767086985 },
	{ 0.99705729360045158849, 0.0011120280677076896467, 0.9968513778871018749 },
	{ 0.99705804334105219144, 0.0011117437201735099091, 0.99685217325148167689 },
	{ 0.99705878274382309101, 0.0011114610892530997054, 0.9968529704850631612 },
	{ 0.99705952882231418943, 0.0011111764365431388377, 0.99685376081404253323 },
	{ 0.99706026690901461418, 0.0011108930617567617637, 0.99685455505308673274 },
	{ 0.99706103335798912379, 0.0011106142836805898717, 0.99685537734922913256 },
	{ 0.99706177291334785462, 0.0011103305846449453877, 0.99685616741117966111 },
	{ 0.99706250846327459936, 0.0011100460845228749766, 0.99685695270475871421 },
	{ 0.99706325873793277825, 0.0011097648650404529601, 0.99685775455412373169 },
	{ 0.99706403062285098304, 0.0011094891959425525092, 0.99685858755049205904 },
	{ 0.99706474433363589949, 0.0011092007094618396099, 0.99685934257444819284 },
	{ 0.99706551188887271309, 0.0011089226561781483082, 0.99686016536650123854 },
	{ 0.99706625646055846435, 0.0011086436301466541261, 0.99686097227034031754 },
	{ 0.99706698983610786424, 0.0011083578711744862012, 0.99686174447950759436 },
	{ 0.99706771809996275202, 0.0011080766135450918417, 0.99686253309187311533 },
	{ 0.99706847155989319909, 0.0011077944213148671615, 0.99686332881864914146 },
	{ 0.99706920100630425097, 0.0011075129729506093517, 0.99686411716398581895 },
	{ 0.99706996783674839424, 0.0011072342711683827964, 0.99686493038114865062 },
	{ 0.99707070624769800204, 0.0011069547682997305307, 0.9968657243340904861 },
	{ 0.99707144288481353023, 0.0011066721945997796007, 0.99686651052412333929 },
	{ 0.99707216576994528445, 0.0011063910514113031378, 0.99686728895124721017 },
	{ 0.99707292294920535358, 0.0011061113196608146451, 0.9968680906861715485 },
	{ 0.99707366189421253733, 0.0011058303672072014156, 0.99686888311323440526 },
	{ 0.99707440179289397175, 0.0011055512839552481767, 0.9968696742814472378 },
	{ 0.99707511779249724526, 0.0011052701216932854338, 0.99687044967588678279 },
	{ 0.99707586635054146207, 0.0011049914580580316552, 0.99687124866422893721 },
	{ 0.99707660300673028875, 0.0011047104293104733058, 0.99687203247007594165 },
	{ 0.99707736201704499912, 0.0011044361907240475389, 0.99687284877714366083 },
	{ 0.99707809529722690733, 0.0011041546469923581124, 0.9968736297791882528 },
	{ 0.99707881968916400872, 0.0011038757354017820437, 0.99687441265043452709 },
	{ 0.99707956773222428115, 0.0011035962134596432813, 0.99687520395216178137 },
	{ 0.99708030688703985778, 0.0011033186751600826229, 0.996875998267499841 },
	{ 0.99708105006636094103, 0.0011030395156141842641, 0.99687678813871549721 },
	{ 0.99708177661360208877, 0.0011027589827772702781, 0.99687756305631802789 },
	{ 0.99708251786650103909, 0.0011024815207716549565, 0.99687835927900458888 },
	{ 0.99708323522032160646, 0.0011022004920240963902, 0.99687912469801076565 },
	{ 0.99708396876753213611, 0.001101924632191332706, 0.99687991882261384191 },
	{ 0.9970847092002712575, 0.0011016473037001219947, 0.99688070793089011978 },
	{ 0.99708544719160407954, 0.0011013702803846924135, 0.99688149825986960284 },
	{ 0.99708619639814699553, 0.0011010934859510988423, 0.99688229812559214782 },
	{ 0.99708692017973243882, 0.001100815642475757054, 0.99688307451185298458 },
	{ 0.99708763850630088843, 0.0011005360060927003949, 0.99688384311613165156 },
	{ 0.99708837306440611936, 0.0011002579909559816532, 0.99688462406095579293 },
	{ 0.99708911128462085482, 0.0010999818068739505589, 0.99688541660245955089 },
	{ 0.99708983783186200256, 0.0010997041732069582839, 0.99688619289335300699 },
	{ 0.99709057300031900262, 0.0010994279891249269729, 0.9968869799416927302 },
	{ 0.99709132388532872859, 0.0010991522628065676821, 0.99688778148588208516 },
	{ 0.99709205621183616408, 0.0010988778907057375218, 0.99688856744703313595 },
	{ 0.99709277064741352881, 0.0010985967665907475557, 0.99688932372983929397 },
	{ 0.99709349093855126345, 0.0010983203536268804513, 0.99689009895261748717 },
	{ 0.99709421779096829574, 0.0010980448561903569538, 0.99689087737974146908 },
	{ 0.99709495318830720922, 0.0010977675276991460257, 0.99689165977415061803 },
	{ 0.99709569247663720759, 0.0010974954634901615963, 0.99689245826658212657 },
	{ 0.99709640973509050532, 0.001097216971516284988, 0.99689322252210554876 },
	{ 0.99709712556303231601, 0.0010969393759962654897, 0.99689398740705403856 },
	{ 0.99709786931455823833, 0.0010966670447584727071, 0.99689478639539619298 },
	{ 0.99709858983457788639, 0.0010963914710280038729, 0.99689556245740784668 },
	{ 0.9970993124145339781, 0.0010961139899489022714, 0.99689632684644580163 },
	{ 0.99710004567564247679, 0.0010958423072096445255, 0.99689712037977096237 },
	{ 0.9971007604926895862, 0.0010955640059706307169, 0.99689787895139569951 },
	{ 0.99710149030149697325, 0.0010952906256910901507, 0.99689866167005414255 },
	{ 0.99710223071516279614, 0.0010950163680311781039, 0.99689944927152496223 },
	{ 0.99710296912611262599, 0.0010947436553236586376, 0.99690023696836338463 },
	{ 0.99710368125379822413, 0.0010944670134779555231, 0.99690099883970106909 },
	{ 0.99710442706526070111, 0.0010941961318251234875, 0.99690180004056772045 },
	{ 0.99710511716306959862, 0.0010939164191481217086, 0.99690253343519041884 },
	{ 0.9971058603233174944, 0.0010936483412977799842, 0.99690333892759153134 },
	{ 0.99710657903135579971, 0.0010933722144362075131, 0.99690410329755596575 },
	{ 0.99710732297361648335, 0.0010931031256910903483, 0.99690490140851784062 },
	{ 0.99710801797331127805, 0.0010928224784132582487, 0.99690563791211883604 },
	{ 0.99710872432173036639, 0.0010925489836927993522, 0.99690640243467132375 },
	{ 0.99710948245466501927, 0.0010922812682386978146, 0.99690721260007664206 },
	{ 0.99711019915998722052, 0.0010920073729750259545, 0.99690798088010579292 },
	{ 0.9971109203285052347, 0.001091733363270435981, 0.99690874813016672196 },
	{ 0.99711164008558528238, 0.0010914600783583265978, 0.99690951549466855219 },
	{ 0.99711235730589165005, 0.0010911873084303478579, 0.99691028848584883892 },
	{ 0.99711308114469776598, 0.0010909171134230238528, 0.99691106664594397735 },
	{ 0.99711378203809986065, 0.0010906392318007092877, 0.99691180770810816636 },
	{ 0.99711450540006885124, 0.0010903679496046645055, 0.99691258367475232838 },
	{ 0.99711523799360535225, 0.0010900990325209242941, 0.99691337127622337011 },
	{ 0.99711595134199393353, 0.0010898248320814715208, 0.99691412887510033602 },
	{ 0.99711667499006517712, 0.0010895545226332291854, 0.99691490745481214919 },
	{ 0.99711739283979661241, 0.0010892816191908464857, 0.99691566894468031101 },
	{ 0.99711808879316565779, 0.0010890068083998308019, 0.99691641677793241261 },
	{ 0.99711884505689851732, 0.0010887401992079363214, 0.99691722331937515644 },
	{ 0.99711953360975502658, 0.0010884656172987566478, 0.99691796192105974761 },
	{ 0.99712025624693156889, 0.0010881958991285907261, 0.99691873598035540827 },
	{ 0.99712096822202911373, 0.0010879252082106221407, 0.99691950349744518078 },
	{ 0.9971216795867752225, 0.0010876551276442160323, 0.99692026979383185914 },
	{ 0.99712240603864887856, 0.0010873804122206319651, 0.99692102817472172394 },
	{ 0.99712311082304216914, 0.0010871109610792746136, 0.99692179117139534394 },
	{ 0.9971238257926771098, 0.0010868402129408471883, 0.99692255603727053526 },
	{ 0.99712454890669066643, 0.0010865684539076443226, 0.99692332218106938235 },
	{ 0.99712525733411982998, 0.0010863010817762969087, 0.9969240913384790348 },
	{ 0.99712597678602410411, 0.0010860271865126250486, 0.99692484832700423159 },
	{ 0.9971267069190805632, 0.0010857624465223907756, 0.99692563583310767061 },
	{ 0.99712740607679528626, 0.0010854893141981720658, 0.99692637954648655185 },
	{ 0.9971281186050240386, 0.001085220168232596278, 0.99692714815076499679 },
	{ 0.99712880681455773324, 0.0010849486762282017655, 0.9969278878587116699 },
	{ 0.99712954198301462228, 0.0010846810370680457815, 0.99692867124494211062 },
	{ 0.99713024102628844414, 0.001084413588642752814, 0.99692942857679012203 },
	{ 0.9971309870094121619, 0.0010841453200575478562, 0.9969302108758317793 },
	{ 0.9971316971534550655, 0.0010838789016005166092, 0.99693098205503094533 },
	{ 0.99713237454832193141, 0.0010836047583815226758, 0.99693170354779814257 },
	{ 0.99713309148252593506, 0.0010833359748121868579, 0.99693247114118177521 },
	{ 0.99713380872190571225, 0.0010830693274733198175, 0.99693324071820821342 },
	{ 0.99713452121198731248, 0.0010827993804213178856, 0.9969339966958385979 },
	{ 0.9971352333968932502, 0.0010825332862135544822, 0.99693476545270498512 },
	{ 0.99713593226850583129, 0.0010822620803114548198, 0.99693550857480595084 },
	{ 0.99713662551343984486, 0.0010819924956556930748, 0.9969362535470348563 },
	{ 0.99713734054029534715, 0.0010817266875502243046, 0.99693702045377297072 },
	{ 0.99713805848539405208, 0.0010814534598585739782, 0.99693776895459695897 },
	{ 0.99713876843870230537, 0.0010811897498366012087, 0.99693853818830047153 },
	{ 0.9971394896262938401, 0.0010809241515394823856, 0.99693930858548662766 },
	{ 0.99714017587125836073, 0.0010806553107496875109, 0.99694005269940866309 },
	{ 0.99714087155759856262, 0.0010803850394484179522, 0.99694078905042171623 },
	{ 0.99714159511030242555, 0.0010801203185316699592, 0.99694156467374317465 },
	{ 0.99714232165754357329, 0.0010798570281263966501, 0.99694233989652125683 },
	{ 0.99714300437391323317, 0.0010795881301161427187, 0.99694307929929237844 },
	{ 0.99714369216383014205, 0.0010793172103163381232, 0.99694381011899446676 },
	{ 0.99714441676557585836, 0.0010790545684096000678, 0.99694458911832306569 },
	{ 0.99714511252821014242, 0.0010787839919325493791, 0.99694532417233905353 },
	{ 0.99714582803190265903, 0.0010785210257765439137, 0.99694609559949354249 },
	{ 0.99714651437223456032, 0.0010782546073195126667, 0.99694683687146601336 },
	{ 0.99714722955167789387, 0.0010779868155714657924, 0.99694759233411245347 },
	{ 0.99714793275297186614, 0.0010777194052931456016, 0.9969483403962460244 },
	{ 0.99714862527311332041, 0.0010774523001906065409, 0.99694907991345782516 },
	{ 0.99714933526456839274, 0.0010771872550245911379, 0.99694984086926830003 },
	{ 0.99715004575193411096, 0.0010769246131178528657, 0.99695060712750804832 },
	{ 0.99715072038114549446, 0.0010766583091017397321, 0.99695133645947831003 },
	{ 0.99715141938627227525, 0.0010763883811232242971, 0.99695207300122634653 },
	{ 0.99715214906156524055, 0.0010761274558302557757, 0.99695285211499573563 },
	{ 0.99715282702863683451, 0.0010758598738905586316, 0.99695358173306825034 },
	{ 0.99715355086744295043, 0.0010755985289808908667, 0.99695435661252385096 },
	{ 0.99715423835218408577, 0.0010753312712904613494, 0.99695509078915944823 },
	{ 0.99715493714750258469, 0.001075065749287287863, 0.99695583417828903539 },
	{ 0.99715564664304690012, 0.0010748060065504717354, 0.99695660524304730021 },
	{ 0.99715631997526132935, 0.0010745323020216631087, 0.99695730703290319497 },
	{ 0.99715703732908200774, 0.0010742739325758623916, 0.99695808412488318151 },
	{ 0.99715773860395384709, 0.0010740110427138020461, 0.99695883819516517566 },
	{ 0.9971584171241564265, 0.0010737442046400715555, 0.99695956317838030358 },
	{ 0.99715914012372908193, 0.0010734849959608725681, 0.99696034248288456503 },
	{ 0.99715982873380604179, 0.0010732172614332845337, 0.99696106931622796576 },
	{ 0.99716049806058826288, 0.001072951529621761534, 0.99696178930218981584 },
	{ 0.99716121980131100511, 0.0010726906043287930126, 0.99696256109174052895 },
	{ 0.99716193065107305848, 0.0010724318724867523255, 0.99696332874234472321 },
	{ 0.99716261487424817656, 0.0010721658545729342588, 0.99696405767377171969 },
	{ 0.99716330205381376039, 0.001071899359821957675, 0.99696478559430379285 },
	{ 0.99716400994718523698, 0.0010716375571486178898, 0.99696554330762165996 },
	{ 0.99716469096601467736, 0.0010713711959120456995, 0.99696626659329679043 },
	{ 0.99716538400114040908, 0.001071110327839536018, 0.9969670137589766723 },
	{ 0.99716608743131618375, 0.0010708506232496924505, 0.99696777334149611072 },
	{ 0.99716677409589737913, 0.0010705857878920265608, 0.99696850368436096268 },
	{ 0.99716747554243057028, 0.0010703237944838237591, 0.99696925304349182095 },
	{ 0.99716815612256970436, 0.0010700613051649761603, 0.99696998359616528784 },
	{ 0.99716887441099133493, 0.0010698027640577982729, 0.99697074998791934686 },
	{ 0.99716954320371586906, 0.0010695331412550639679, 0.99697145387585872633 },
	{ 0.9971702471298021786, 0.0010692783576246929923, 0.99697222204144697599 },
	{ 0.99717094350278800974, 0.0010690174704786972477, 0.9969729699128457856 },
	{ 0.99717162671506820448, 0.0010687534171339707883, 0.99697369630749899105 },
	{ 0.99717232566297464569, 0.0010684923201796255304, 0.99697444042142124854 },
	{ 0.99717303420484471044, 0.0010682336074110711233, 0.99697519931729527976 },
	{ 0.99717369559705659743, 0.0010679690963026726436, 0.99697590831692917135 },
	{ 0.99717438386381063165, 0.0010677065116163934281, 0.99697664243634431802 },
	{ 0.99717508485258010698, 0.0010674492484327999849, 0.99697740018780933724 },
	{ 0.99717577203214546877, 0.0010671864157911984793, 0.9969781302445719362 },
	{ 0.99717644914091008168, 0.0010669252616163939478, 0.99697885816510412038 },
	{ 0.99717714726865658292, 0.0010666649848219604633, 0.9969795997803995169 },
	{ 0.99717783791959646589, 0.0010664042502638553921, 0.99698034055646156393 },
	{ 0.9971785222953593042, 0.001066143572926208944, 0.99698107109006139925 },
	{ 0.9971792194312846247, 0.0010658861190077520507, 0.99698181941922414673 },
	{ 0.9971799010986124312, 0.0010656263953444219863, 0.99698255567486981921 },
	{ 0.99718056168973789877, 0.0010653609305617073397, 0.9969832560151408174 },
	{ 0.99718128343046052997, 0.0010651091605421761886, 0.99698403879101982206 },
	{ 0.99718195167005396762, 0.0010648436766859750453, 0.99698474327023722807 },
	{ 0.99718263709485865931, 0.0010645830565687876539, 0.99698547508176071918 },
	{ 0.997183322519663351, 0.0010643236571547254332, 0.99698620689328432132 },
	{ 0.99718399667203749814, 0.0010640639334913953688, 0.99698693201001409303 },
	{ 0.99718471023023447231, 0.0010638075286146866927, 0.99698769115384344719 },
	{ 0.99718537318647226808, 0.0010635483199354879222, 0.99698841201718579885 },
	{ 0.99718607577741458226, 0.0010632893019911519514, 0.99698915336545235188 },
	{ 0.99718674407422858152, 0.0010630291777846091403, 0.99698987262662175368 },
	{ 0.99718742110669922329, 0.0010627696257826560293, 0.99699059604581108385 },
	{ 0.99718811379850225141, 0.0010625138312575096132, 0.9969913435929607104 },
	{ 0.99718880189359504485, 0.0010622554236647363361, 0.9969920754807779506 },
	{ 0.99718947713315808645, 0.0010619942313429590278, 0.99699279100354409877 },
	{ 0.99719016831815554536, 0.0010617387610670802386, 0.9969935366624187445 },
	{ 0.99719085717618771714, 0.0010614809638258694384, 0.9969942729752849786 },
	{ 0.99719153665006465825, 0.0010612220221754790211, 0.99699499395306823146 },
	{ 0.99719222131192986058, 0.0010609639960524322108, 0.99699572225507027134 },
	{ 0.99719287599027450764, 0.0010607019263502838555, 0.99699642454083681198 },
	{ 0.99719356809079950921, 0.0010604456931349516991, 0.99699716539319271913 },
	{ 0.99719424962461300499, 0.0010601911002394439568, 0.99699790353711359447 },
	{ 0.99719494380414785972, 0.0010599356871840244412, 0.99699864242490054966 },
	{ 0.99719561580121818256, 0.0010596762877699622205, 0.99699935836728337257 },
	{ 0.99719629172742663137, 0.001059419978260685161, 0.99700008647855042909 },
	{ 0.99719696174085414864, 0.0010591607314345133969, 0.99700080104764232658 },
	{ 0.99719764869153781905, 0.0010589046889540446907, 0.99700153438504479642 },
	{ 0.99719833781659883432, 0.0010586506682631268653, 0.99700227416928555169 },
	{ 0.9971989906638887291, 0.0010583899718519941373, 0.99700297233517909401 },
	{ 0.99719970401227742141, 0.0010581395751234786134, 0.99700373420651700052 },
	{ 0.99720036689222135706, 0.0010578816634413496997, 0.99700445133145587651 },
	{ 0.997201040071847844, 0.0010576230651137131893, 0.99700516494687330127 },
	{ 0.99720171742856789088, 0.0010573688727614184105, 0.99700589559491414882 },
	{ 0.9972023816436558219, 0.0010571087104079030395, 0.99700659856732631869 },
	{ 0.99720305730283553824, 0.0010568554145094655877, 0.99700732915814660462 },
	{ 0.99720374066770356425, 0.001056598075031926591, 0.9970080502122237176 },
	{ 0.99720440583646574595, 0.0010563427573439384752, 0.99700876771863233827 },
	{ 0.99720510369718362575, 0.0010560893851515556867, 0.99700951425488715252 },
	{ 0.997205771993997514, 0.001055833762287786224, 0.99701022832806840412 },
	{ 0.99720643189847735233, 0.0010555745536085870198, 0.99701093011792429888 },
	{ 0.99720712094724450747, 0.0010553239661452078289, 0.99701167226727727133 },
	{ 0.99720778445661339973, 0.0010550644332167412147, 0.9970123727792095103 },
	{ 0.99720846389234341078, 0.001054813159107854427, 0.99701310821469535384 },
	{ 0.99720913585126669254, 0.0010545580703017018876, 0.99701382663663140615 },
	{ 0.99720982268750923971, 0.0010543046599623465392, 0.9970145590966533744 },
	{ 0.99721048339307560848, 0.0010540504485365654805, 0.99701527351315721859 },
	{ 0.99721118285596621611, 0.00105380020439594063, 0.99701601692136043731 },
	{ 0.99721183919370426363, 0.0010535421591994075397, 0.9970167183488199969 },
	{ 0.99721249928891908532, 0.0010532861167189388335, 0.997017424830753618 },
	{ 0.99721317851484070349, 0.0010530337935683040454, 0.9970181503289531344 },
	{ 0.99721384444654226353, 0.001052780383228948697, 0.99701886882718315785 },
	{ 0.99721450194776284359, 0.0010525223571059018866, 0.99701956142361869428 },
	{ 0.99721518769681682937, 0.0010522730857130796998, 0.997020305690128672 },
	{ 0.99721583281934489396, 0.0010520156508681093033, 0.99702099555905543404 },
	{ 0.99721653573453661323, 0.0010517672187086856035, 0.9970217457001991912 },
	{ 0.99721718724668262368, 0.0010515114432570256842, 0.99702244398053374574 },
	{ 0.99721785115659467014, 0.001051257689594916429, 0.99702315153058262975 },
	{ 0.99721854621350991543, 0.0010510065108534610411, 0.99702388805325714571 },
	{ 0.99721918282926313992, 0.0010507509833571231951, 0.99702457998212068446 },
	{ 0.99721986825406783161, 0.0010504976874586855265, 0.99702529958661290088 },
	{ 0.99722054028928508451, 0.0010502468711134707591, 0.9970260208314248862 },
	{ 0.99722121133268115667, 0.001049997122883490272, 0.99702674962933757197 },
	{ 0.99722186292112102723, 0.0010497405844923772024, 0.99702744241650798074 },
	{ 0.99722254369199492263, 0.0010494888907667911711, 0.99702816682751860267 },
	{ 0.99722322289884313129, 0.0010492398291823184977, 0.99702889280255513338 },
	{ 0.99722385814130531934, 0.0010489853316542423721, 0.99702958126004403994 },
	{ 0.99722451713025794806, 0.0010487313872572696666, 0.99703028175290286939 },
	{ 0.99722519618451821444, 0.0010484825545546330033, 0.99703101299222174347 },
	{ 0.99722584546506631842, 0.0010482260733839789905, 0.99703169942792113645 },
	{ 0.99722653790891391257, 0.0010479773551222602238, 0.9970324339860264784 },
	{ 0.99722719495237099885, 0.0010477280265089789803, 0.9970331477921787755 },
	{ 0.99722786588132605878, 0.0010474773246046821095, 0.99703386693890716508 },
	{ 0.99722850749433256112, 0.0010472230559584419941, 0.99703455314572475565 },
	{ 0.99722917252958032108, 0.0010469713050123969061, 0.9970352629273714351 },
	{ 0.99722983605802262286, 0.0010467215949293889789, 0.99703597314770830984 },
	{ 0.99723050223767950584, 0.0010464708739516056114, 0.99703668479855656059 },
	{ 0.99723117150724127633, 0.0010462208014723574975, 0.99703740198071588718 },
	{ 0.99723182376325314458, 0.0010459674483534612058, 0.99703809467251880427 },
	{ 0.99723249528348623105, 0.0010457206946608342633, 0.99703882078106975673 },
	{ 0.99723315404355705738, 0.0010454679709669865116, 0.99703951906140408923 },
	{ 0.99723380902707758899, 0.0010452153617140566566, 0.99704021341260040678 },
	{ 0.99723447875440296428, 0.0010449694091078552075, 0.9970409426110560247 },
	{ 0.99723513539731667432, 0.0010447180777785091462, 0.99704164110119897213 },
	{ 0.99723581536710426132, 0.0010444700080153254164, 0.99704236555035652412 },
	{ 0.99723645263135596295, 0.0010442187529799251255, 0.99704305320675912228 },
	{ 0.99723710341870952512, 0.0010439653044935970003, 0.9970437421410852652 },
	{ 0.99723778365552584457, 0.0010437202483412533118, 0.99704447486813618795 },
	{ 0.9972384355491415997, 0.0010434685164686947206, 0.99704516788418839912 },
	{ 0.99723908877790135019, 0.0010432211714979915812, 0.99704587512906139857 },
	{ 0.99723976233899747079, 0.0010429757720228939859, 0.99704659919674942792 },
	{ 0.99724041213452951915, 0.0010427237731215268247, 0.99704728835995737324 },
	{ 0.99724107705533626689, 0.0010424749213454038814, 0.99704799871380866971 },
	{ 0.99724173341214772393, 0.0010422253638502866277, 0.99704869886334490658 },
	{ 0.99724240327298763198, 0.0010419784766432552917, 0.99704941266949720369 },
	{ 0.99724304227292648317, 0.0010417280417677667742, 0.99705010011609140896 },
	{ 0.99724370242536175546, 0.0010414804488417413447, 0.99705080875332885437 },
	{ 0.99724434865415190199, 0.0010412291938063410537, 0.99705149362500244958 },
	{ 0.99724502673566428612, 0.0010409867507216242263, 0.99705222793515269064 },
	{ 0.99724566230237565723, 0.0010407328826185968575, 0.99705289951260622772 },
	{ 0.99724632968366222485, 0.0010404871779677179154, 0.99705361587460583639 },
	{ 0.997246973146797, 0.0010402380019423271285, 0.99705430389340465869 },
	{ 0.99724764522016118296, 0.0010399942427870537305, 0.99705502860959116518 },
	{ 0.99724828807294441102, 0.0010397438460585382066, 0.99705571235592904689 },
	{ 0.99724893107831547034, 0.0010394945174452569631, 0.99705639869626094818 },
	{ 0.99724957572400629857, 0.0010392465239760187868, 0.99705708927090674898 },
	{ 0.99725025790631827149, 0.0010390031844374446324, 0.9970578178399374103 },
	{ 0.99725089085996210247, 0.0010387525016066342584, 0.99705849660809531265 },
	{ 0.99725157308042100546, 0.0010385097342726498041, 0.99705922399456992089 },
	{ 0.99725222957074699526, 0.0010382627898451594114, 0.99705992507870699892 },
	{ 0.99725286761701159577, 0.0010380132323500423745, 0.99706060768063575761 },
	{ 0.99725349915921734922, 0.0010377633506056577108, 0.99706128107007052641 },
	{ 0.99725415965497532511, 0.0010375196868178159296, 0.99706199478085533183 },
	{ 0.99725478599011929681, 0.0010372698622938901058, 0.99706266498501794349 },
	{ 0.99725546147763755034, 0.0010370290213820249157, 0.99706339406903288225 },
	{ 0.99725611943662195724, 0.0010367861014601500048, 0.99706410329754857624 },
	{ 0.99725676251828698771, 0.001036534560322454647, 0.99706477827008277437 },
	{ 0.99725742305219200468, 0.0010362898665663513621, 0.99706548217709567439 },
	{ 0.99725805550992507875, 0.001036042731403997736, 0.99706616208966281079 },
	{ 0.99725870938718330638, 0.0010357978659865174978, 0.99706686471875216604 },
	{ 0.99725939099729066228, 0.0010355563193556582141, 0.99706759241040254782 },
	{ 0.99725999555051325629, 0.0010353057700392520168, 0.99706824335034394124 },
	{ 0.9972606576293706615, 0.0010350614768263614787, 0.99706895120556837675 },
	{ 0.99726132523953903153, 0.0010348176795241155208, 0.997069658336000475 },
	{ 0.9972619393295049095, 0.0010345687323805609608, 0.99707032049115185135 },
	{ 0.99726260611951356161, 0.0010343267852064887136, 0.99707103420193676779 },
	{ 0.99726324490964424196, 0.0010340796500441353043, 0.99707171338971134489 },
	{ 0.99726389890134348182, 0.0010338370352980415234, 0.99707241743023866665 },
	{ 0.99726453835904627088, 0.0010335915595289988083, 0.99707310213025091006 },
	{ 0.99726519092023402369, 0.0010333462554213330466, 0.9970737942498490991 },
	{ 0.99726583135068436192, 0.0010331005698439403844, 0.99707448018963773517 },
	{ 0.99726647637784493483, 0.0010328565436598584164, 0.9970751713746353051 },
	{ 0.99726711080014729394, 0.0010326108390089792574, 0.99707585195477443918 },
	{ 0.99726775193631678196, 0.0010323644477125927185, 0.99707653184826794401 },
	{ 0.99726842042386565357, 0.0010321268683668896431, 0.9970772546571057271 },
	{ 0.99726904233396085342, 0.0010318794852492137269, 0.99707791982586779778 },
	{ 0.9972696848052743368, 0.0010316360312697216758, 0.99707860990460306372 },
	{ 0.9972703500884774197, 0.0010313955527540966724, 0.99707931913311864669 },
	{ 0.99727100846707839032, 0.0010311541205641555023, 0.99708002435620213255 },
	{ 0.99727163840711141596, 0.0010309080153700635966, 0.99708069610531713245 },
	{ 0.99727227202832724462, 0.0010306616622206496176, 0.99708136756832976832 },
	{ 0.99727293391644977749, 0.001030424426197700449, 0.99708208942349330073 },
	{ 0.99727357572019137422, 0.0010301790457960891337, 0.99708276578839205584 },
	{ 0.99727420644223718771, 0.0010299358969923784295, 0.99708344457562347873 },
	{ 0.99727485719144381981, 0.0010296920233961873517, 0.9970841343110361521 },
	{ 0.99727548318326508792, 0.0010294493323561482341, 0.99708481294567974373 },
	{ 0.99727612882077742995, 0.0010292040854689413123, 0.9970854960435191483 },
	{ 0.99727676989972635635, 0.0010289654952284627964, 0.99708619209225568536 },
	{ 0.99727741418302118248, 0.0010287219077345665687, 0.9970868751328745283 },
	{ 0.99727804076612058815, 0.0010284783202406699073, 0.99708754619534400998 },
	{ 0.99727868932187624385, 0.0010282369834181601369, 0.99708823915417588157 },
	{ 0.99727932095944948898, 0.0010279936820265585425, 0.99708891153271583807 },
	{ 0.99727999371945919016, 0.0010277591544386680683, 0.99708964197094818172 },
	{ 0.99728060765683701483, 0.0010275094443556601412, 0.99709028627331630634 },
	{ 0.99728124322354827491, 0.0010272693091627892615, 0.99709097364361654048 },
	{ 0.99728188630521330538, 0.0010270292121168907249, 0.99709166372235180642 },
	{ 0.99728252957761309716, 0.001026785719990425897, 0.99709234483654862746 },
	{ 0.99728314870297929406, 0.0010265411978956993488, 0.99709300607617268319 },
	{ 0.99728379464566718759, 0.0010263010627028284691, 0.99709369466717601149 },
	{ 0.99728444940030580579, 0.0010260647040602505643, 0.99709440282757644258 },
	{ 0.99728507352292528054, 0.0010258240348097621107, 0.99709507844860922887 },
	{ 0.99728573132932185619, 0.0010255827933546839571, 0.99709577348645106465 },
	{ 0.99728633195340632422, 0.0010253376990553674918, 0.99709641546185390215 },
	{ 0.9972869953674077248, 0.0010251026755568324374, 0.99709713106091402146 },
	{ 0.99728764405667769122, 0.0010248631507155238178, 0.99709782545025726908 },
	{ 0.99728824002683136296, 0.0010246175986525353323, 0.99709846216137787422 },
	{ 0.99728888593137232643, 0.0010243775779005823492, 0.99709915048535235904 },
	{ 0.99728953084409210916, 0.0010241359549757777288, 0.99709983110363842318 },
	{ 0.99729017444074119503, 0.0010239001494643030273, 0.9971005289452825604 },
	{ 0.99729080817639792489, 0.0010236597090956508008, 0.99710120632107590577 },
	{ 0.99729143813550424902, 0.0010234203749892056313, 0.99710188205654937121 },
	{ 0.99729207309186418406, 0.0010231796294447720579, 0.99710256195004298707 },
	{ 0.99729269904553841108, 0.0010229376631972135307, 0.99710322505886872513 },
	{ 0.99729334937512814641, 0.0010227005416151824756, 0.9971039199441225076 },
	{ 0.99729396747052612149, 0.0010224583464857879382, 0.99710458053524786415 },
	{ 0.99729461009442743613, 0.0010222238951918428008, 0.99710527854855346419 },
	{ 0.99729522176206064632, 0.001021979811787301776, 0.99710592901165762125 },
	{ 0.99729587520062878969, 0.0010217426329848114473, 0.99710662208493039405 },
	{ 0.99729647773206198114, 0.0010215012770888156138, 0.99710727519924924334 },
	{ 0.99729712092816780178, 0.0010212634307143039682, 0.99710795982296740458 },
	{ 0.99729776297986438838, 0.0010210245925185031622, 0.99710863803799432148 },
	{ 0.99729837275922228468, 0.0010207841521498507188, 0.99710929901058942271 },
	{ 0.99729902415692750495, 0.0010205496245619602447, 0.99710999893124374616 },
	{ 0.99729965033948364539, 0.001020310099720651625, 0.99711066448147556152 },
	{ 0.99730028106152945888, 0.001020069239735300155, 0.99711133197720303034 },
	{ 0.9973008995765441087, 0.0010198312789198706128, 0.99711200267727628788 },
	{ 0.99730154271542947875, 0.0010195970374342749887, 0.99711269529278523382 },
	{ 0.997302180895208501, 0.001019358981251413613, 0.99711337245877040836 },
	{ 0.99730280856549657909, 0.0010191202574965307036, 0.99711404224331634527 },
	{ 0.99730341685712242672, 0.0010188816863295384677, 0.99711469860012791333 },
	{ 0.99730405620038409253, 0.0010186421233412572881, 0.99711537212307710387 },
	{ 0.99730468284070372675, 0.001018404429554636316, 0.9971160420983578021 },
	{ 0.99730530654370652677, 0.0010181670790907692507, 0.99711671234066723279 },
	{ 0.99730593705594394738, 0.0010179288321730448584, 0.99711738168652275238 },
	{ 0.99730656194150291149, 0.0010176939612624002606, 0.99711805837567069055 },
	{ 0.99730718179166155668, 0.0010174573355910137857, 0.99711872804577550422 },
	{ 0.99730779939114866384, 0.0010172170859572247925, 0.99711938333447158733 },
	{ 0.99730845117032340674, 0.001016981566548044941, 0.99712007341320685327 },
	{ 0.99730906228482518738, 0.0010167464286085917732, 0.99712073610241558352 },
	{ 0.99730967862546227032, 0.001016508200764353444, 0.99712139623577711323 },
	{ 0.99731032647549877623, 0.0010162743979689435603, 0.99712208826000792161 },
	{ 0.9973109458678937056, 0.0010160388404127913657, 0.99712275548870654696 },
	{ 0.99731155307233088081, 0.001015797885060008279, 0.99712340007717692458 },
	{ 0.99731218175351354915, 0.0010155624991652330378, 0.9971240722459084882 },
	{ 0.99731279759823987519, 0.0010153250724074206358, 0.9971247320359473143 },
	{ 0.99731345540463622878, 0.001015094206928905023, 0.99712543104107420611 },
	{ 0.99731405106961423801, 0.0010148522406813464958, 0.99712606508190682053 },
	{ 0.99731469296872321539, 0.0010146213370558583231, 0.99712676092083496471 },
	{ 0.99731528577267825053, 0.0010143794852492176925, 0.99712738729412597749 },
	{ 0.99731592479169062226, 0.0010141481429335439963, 0.9971280776208166774 },
	{ 0.99731655263363994113, 0.0010139132148024407754, 0.99712874853069821679 },
	{ 0.9973171842330662562, 0.001013677657246288364, 0.9971294187348606064 },
	{ 0.99731776994168430672, 0.0010134375602003898274, 0.99713004732067600511 },
	{ 0.99731842103421353141, 0.0010132076102492178216, 0.99713074602062701235 },
	{ 0.99731903047024861309, 0.0010129717093703117202, 0.99713140001232614118 },
	{ 0.9973196525901520948, 0.0010127345305678218251, 0.99713205867702947582 },
	{ 0.99732026723324884721, 0.001012500632404979891, 0.9971327220338104258 },
	{ 0.9973209088844022796, 0.0010122693663832513147, 0.99713341018612355882 },
	{ 0.99732152814328289825, 0.0010120332938429682599, 0.99713406942303139946 },
	{ 0.9973221357673367482, 0.001011798136830028812, 0.99713472301418726307 },
	{ 0.99732276477276871063, 0.0010115629607436030842, 0.99713538703854021072 },
	{ 0.99732338818966925764, 0.0010113303595778316574, 0.9971360587113613505 },
	{ 0.99732397695004515459, 0.0010110898047682615342, 0.99713667890484269929 },
	{ 0.9973246174377158324, 0.0010108625251051756629, 0.99713737859661499829 },
	{ 0.99732523753582968951, 0.001010629695057568226, 0.99713804313595211237 },
	{ 0.99732583795010576466, 0.0010103921729323239904, 0.99713868242199332759 },
	{ 0.99732646193921103972, 0.0010101578170058102529, 0.99713934505398171826 },
	{ 0.99732708587109564213, 0.0010099248152968256457, 0.99714001201565161114 },
	{ 0.99732771184384338969, 0.0010096953421828119401, 0.9971406914704549207 },
	{ 0.99732831189572335173, 0.0010094582968947262216, 0.99714132799084065351 },
	{ 0.99732895173489566343, 0.0010092271643874020388, 0.99714200948650710821 },
	{ 0.99732954907834059366, 0.0010089928275343750148, 0.99714265489513731477 },
	{ 0.99733016599118251566, 0.0010087604361769531014, 0.99714331636364317291 },
	{ 0.99733078893124593733, 0.001008526900410351354, 0.99714397638256402345 },
	{ 0.99733138957440392591, 0.0010082927733656736266, 0.9971446223443253265 },
	{ 0.99733201243817326542, 0.0010080611449477046467, 0.99714528610164943068 },
	{ 0.99733264014660827357, 0.0010078300887343258005, 0.99714596095974261658 },
	{ 0.99733324613034246564, 0.0010075984412428705406, 0.99714661363537138161 },
	{ 0.99733385068356505965, 0.0010073613196608392686, 0.99714725175792995326 },
	{ 0.99733448293148996289, 0.0010071311408278314694, 0.99714792612011260431 },
	{ 0.99733508836209283643, 0.0010068987113234367792, 0.99714857549602797793 },
	{ 0.99733569707333569188, 0.0010066659003493158391, 0.9971492276948195066 },
	{ 0.99733628190457379592, 0.0010064311820265619147, 0.99714985860760019243 },
	{ 0.99733691962658921337, 0.001006202090382274459, 0.99715053890163696249 },
	{ 0.99733754222332993145, 0.0010059725600478016967, 0.99715120727474504392 },
	{ 0.9973381331199363542, 0.0010057345992323721545, 0.99715183128292372849 },
	{ 0.99733876571118407206, 0.0010055086547133293504, 0.99715251224453271828 },
	{ 0.99733936866223404927, 0.0010052795439955558316, 0.99715317180568996402 },
	{ 0.99733999034344744672, 0.0010050431472060047163, 0.99715381584102935619 },
	{ 0.99734059279858666702, 0.0010048114806410631764, 0.99715446178371724972 },
	{ 0.99734119494855011379, 0.0010045779830214342059, 0.99715510284359265558 },
	{ 0.99734181527554610636, 0.001004351714253123775, 0.99715577688152612357 },
	{ 0.99734242680966478378, 0.0010041192084547837481, 0.9971564249604445429 },
	{ 0.99734304067074885936, 0.0010038868170973618346, 0.99715707544262222051 },
	{ 0.99734366256177053867, 0.0010036600524184068235, 0.9971577464669446611 },
	{ 0.99734425849377739137, 0.0010034294158217272209, 0.99715839214260382217 },
	{ 0.99734486354291063126, 0.0010031970626112778674, 0.99715903602535516104 },
	{ 0.99734546573102078604, 0.0010029677993056136751, 0.9971596873467660771 },
	{ 0.99734608123242451949, 0.0010027363616225081454, 0.99716033977443929714 },
	{ 0.9973466944640833054, 0.0010025086432692367506, 0.99716099878246511334 },
	{ 0.99734730222165157709, 0.0010022759467360334903, 0.99716164102489668331 },
	{ 0.99734791608273543062, 0.0010020469123122053082, 0.99716230157787522081 },
	{ 0.99734851930081391824, 0.0010018167716261700689, 0.99716294706279939852 },
	{ 0.99734912471234349329, 0.0010015871840712382498, 0.99716359447414559813 },
	{ 0.99734972167431856782, 0.0010013564330336405337, 0.99716423294002687339 },
	{ 0.99735032741009732593, 0.0010011271315810035647, 0.99716488544399406457 },
	{ 0.99735095117032068757, 0.0010008978873488256524, 0.9971655443757262427 },
	{ 0.9973515343993856197, 0.0010006694251295873872, 0.99716618192608008631 },
	{ 0.99735216651379599018, 0.0010004410964247532987, 0.99716684848720682499 },
	{ 0.99735275351941121702, 0.001000209925770456339, 0.99716747974331021442 },
	{ 0.99735335891186727153, 0.0009999805098769016902, 0.99716812679226018989 },
	{ 0.99735397382199286742, 0.00099975294411152096884, 0.99716878400737862798 },
	{ 0.99735458503186213974, 0.00099952534019916725386, 0.99716943912441347031 },
	{ 0.99735518794476485382, 0.00099929611504047583838, 0.99717008407528007208 },
	{ 0.9973557784599015319, 0.00099906692802875698284, 0.99717071609432295087 },
	{ 0.99735640069424591481, 0.00099884062111347355836, 0.997171381778069299 },
	{ 0.99735698071896505823, 0.00099860773384540706468, 0.9971720014756400019 },
	{ 0.99735757972180327791, 0.00099838146507709663383, 0.99717264961177876081 },
	{ 0.9973581861251540337, 0.00099814993202655927056, 0.99717328607494404302 },
	{ 0.99735879861294685078, 0.0009979219657179653688, 0.99717393701488532542 },
	{ 0.99735941104351943931, 0.0009976966506239711048, 0.99717459663326291075 },
	{ 0.99736000773846578138, 0.00099746876060932253977, 0.99717523910457628311 },
	{ 0.99736061309277479481, 0.00099724182426899035843, 0.99717588733608253371 },
	{ 0.9973612213081066713, 0.00099701263725727150289, 0.99717652912075038785 },
	{ 0.99736179057537954762, 0.00099678325951068941398, 0.99717714721614802986 },
	{ 0.99736241443097040094, 0.00099655857384174390684, 0.99717781669551808221 },
	{ 0.99736299712597775713, 0.00099632988274066963154, 0.99717844196254679101 },
	{ 0.99736358947216907644, 0.0009961000853773882991, 0.99717907337123812272 },
	{ 0.99736421180188095104, 0.00099587738335102111292, 0.99717973873073495472 },
	{ 0.99736480029522822655, 0.00099564945518939977111, 0.9971803745263280172 },
	{ 0.99736540873944201646, 0.00099542080223529827258, 0.99718101379329571188 },
	{ 0.99736601048886197596, 0.00099519651710956594584, 0.99718166513378037052 },
	{ 0.99736662423550492829, 0.00099496897041767150445, 0.9971823128312291562 },
	{ 0.99736722268521205148, 0.000994744055866890204, 0.99718295766765474575 },
	{ 0.99736781247555617025, 0.00099451361000507405158, 0.99718358354503500163 },
	{ 0.99736840049206598735, 0.00099428783714740798412, 0.99718421634609089033 },
	{ 0.99736901271283007198, 0.0009940627318617634503, 0.99718486961299757088 },
	{ 0.99736959542691083769, 0.00099383734047382384959, 0.99718550432140196094 },
	{ 0.99737020862042269354, 0.00099361286461322807263, 0.99718616008693516939 },
	{ 0.99737080489575213882, 0.00099338737785785707207, 0.99718679695064349477 },
	{ 0.99737140220104980592, 0.00099315857231586490012, 0.99718743011409549659 },
	{ 0.99737199147640975827, 0.00099293321907489807618, 0.99718806280071037307 },
	{ 0.99737259969174163476, 0.00099271013557880420641, 0.99718871374065165547 },
	{ 0.99737319308697458542, 0.00099248421013324746552, 0.99718935363704419572 },
	{ 0.99737377025067075476, 0.00099225326836078629918, 0.99718995902950025023 },
	{ 0.9973744047111199329, 0.0009920350676771924614, 0.99719064170772286904 },
	{ 0.99737498265682911214, 0.00099180403053729967837, 0.99719125150615417486 },
	{ 0.99737555415570000594, 0.00099157783806293458423, 0.99719187187129698646 },
	{ 0.99737617637097086831, 0.00099135547935932130485, 0.99719253642970751006 },
	{ 0.99737677150189119057, 0.00099113167107074706154, 0.99719317512447069873 },
	{ 0.99737735171734509532, 0.00099090561211078614402, 0.99719379684383091522 },
	{ 0.99737796367108033646, 0.00099068352043598143473, 0.99719445274287865644 },
	{ 0.99737854442059203919, 0.00099045189201801245478, 0.99719506095821053293 },
	{ 0.99737913272320422031, 0.0009902296477553172889, 0.99719569732600843448 },
	{ 0.99737971805035252615, 0.00099000564873187981221, 0.99719632903987542871 },
	{ 0.99738034436642297731, 0.00098978555977313948701, 0.99719699689799901066 },
	{ 0.99738091876446355322, 0.00098955692589252426845, 0.99719760711604710224 },
	{ 0.99738151153027165829, 0.00098933563530414526943, 0.99719825015956509162 },
	{ 0.99738209580837822177, 0.00098910719215839306741, 0.99719886831218340628 },
	{ 0.99738269681393232347, 0.00098888552010028760164, 0.99719951021129216162 },
	{ 0.99738327617107946921, 0.00098865890800922326398, 0.99720013015681829849 },
	{ 0.99738389651714864925, 0.00098844139397113745665, 0.99720079856807297691 },
	{ 0.99738448081432862224, 0.00098821743309467275675, 0.99720142658168364758 },
	{ 0.99738505536495714043, 0.00098799108803241698917, 0.99720204027110614931 },
	{ 0.99738565080105334726, 0.00098776590645282711864, 0.99720267072612323034 },
	{ 0.99738624829708610875, 0.00098754492104022946648, 0.99720331094676539774 },
	{ 0.99738683227001689868, 0.00098732040703266091275, 0.99720393768245263466 },
	{ 0.99738741511761208614, 0.0009870951491591257055, 0.99720455623561410352 },
	{ 0.99738800717770115245, 0.00098687406837909621982, 0.99720519433909904361 },
	{ 0.99738860707699295016, 0.00098665045082538542671, 0.99720582918101796643 },
	{ 0.99738920728146085448, 0.00098643278419940894595, 0.99720648309642323515 },
	{ 0.99738979163586150012, 0.000986209719776801573, 0.99720710929805278511 },
	{ 0.99739034865795606066, 0.00098598045647113738074, 0.9972077008050105329 },
	{ 0.99739094520031446045, 0.00098575836479633267145, 0.99720833564692923368 },
	{ 0.9973915525382660574, 0.00098554073631732875063, 0.99720899311000277265 },
	{ 0.99739209781109305908, 0.00098531193077533657868, 0.99720957591945091902 },
	{ 0.99739269851147138723, 0.00098509064018695779649, 0.99721021209651372619 },
	{ 0.9973932952445643263, 0.00098486973106830569789, 0.997210852011979898 },
	{ 0.99739387809215951375, 0.00098464989006488787965, 0.9972114854424607433 },
	{ 0.99739446757732785898, 0.00098442661583393055967, 0.99721211048060753868 },
	{ 0.99739504811703116882, 0.00098420530617206528068, 0.99721273508006413877 },
	{ 0.99739563352047366784, 0.00098398245155780742106, 0.99721335847789127627 },
	{ 0.99739623555599621341, 0.00098376341164081531308, 0.99721400155955619571 },
	{ 0.99739681403576296859, 0.00098353977501361802317, 0.99721461940699862581 },
	{ 0.99739740418850342252, 0.00098331892311542454764, 0.99721525010997080773 },
	{ 0.99739800280987178649, 0.00098310055077045375646, 0.99721589553767464587 },
	{ 0.997398578371395228, 0.00098287899315326618735, 0.99721651504451047643 },
	{ 0.99739914849697486332, 0.00098265142738788546599, 0.99721710985118150461 },
	{ 0.99739975060879115798, 0.00098243261635272915132, 0.99721775224620079481 },
	{ 0.99740032258449917713, 0.00098221067726581511546, 0.99721836801463337174 },
	{ 0.99740091342388503826, 0.00098199390709369574481, 0.99721900943690489072 },
	{ 0.99740149054943427753, 0.00098176811516254361423, 0.99721961471491993301 },
	{ 0.99740206576763501545, 0.00098154758751361776553, 0.99722023258143599467 },
	{ 0.99740266358791696, 0.00098132810890643991722, 0.99722086797648590295 },
	{ 0.99740324542461744617, 0.0009811120635268013538, 0.99722150653773455886 },
	{ 0.99740382350384104715, 0.00098088997185199664451, 0.99722212139063970415 },
	{ 0.99740441007076607871, 0.00098066942512958451585, 0.99722274545603872831 },
	{ 0.99740498446880687666, 0.00098044895470111794074, 0.99722336502009489845 },
	{ 0.99740557387768125075, 0.00098022972404926259939, 0.99722399417811480316 },
	{ 0.99740615199505167077, 0.00098000995933979011786, 0.99722461280757024316 },
	{ 0.99740674050747235579, 0.00097978872597187017558, 0.99722523511820848618 },
	{ 0.99740731976925212088, 0.00097956735908954583984, 0.9972258529084305767 },
	{ 0.99740789281307540293, 0.00097934862434833486189, 0.99722646715098417491 },
	{ 0.99740847981869062977, 0.00097912844002216292, 0.99722709566050549146 },
	{ 0.99740905267177892846, 0.0009789098197218698387, 0.99722771245890629022 },
	{ 0.99740962525783849468, 0.00097869032204120571042, 0.99722832670145988843 },
	{ 0.99741020245968181612, 0.00097846926033466272155, 0.99722894510203352603 },
	{ 0.99741079701839763239, 0.00097825372993915480149, 0.99722958101206748971 },
	{ 0.99741138055263833806, 0.00097803289711444782277, 0.99723019971781701187 },
	{ 0.99741195254741987775, 0.00097781456291644980837, 0.99723081596308671415 },
	{ 0.99741255174099285874, 0.00097759874641864703826, 0.99723145593577344759 },
	{ 0.9974131151145585461, 0.00097737858116596159318, 0.99723206436091371696 },
	{ 0.99741370776592574998, 0.00097716068565814910227, 0.99723269241267142871 },
	{ 0.99741427264629678451, 0.0009769382125136177094, 0.99723328964167523569 },
	{ 0.9974148402541764824, 0.00097672296822040485624, 0.99723391244822434665 },
	{ 0.99741540534435579879, 0.00097650017082660594495, 0.99723450881892117259 },
	{ 0.99741599036632833108, 0.00097628380119769953786, 0.99723514205866703453 },
	{ 0.9974165527099256856, 0.00097606241524188892215, 0.99723573770457141219 },
	{ 0.99741716460644058717, 0.00097585151970355874396, 0.99723639701777322397 },
	{ 0.99741770280300434681, 0.00097562719643085353202, 0.99723697198801852792 },
	{ 0.99741829072414689428, 0.00097541220009296286057, 0.99723760538035244316 },
	{ 0.99741888297497083293, 0.00097519344627826560264, 0.99723822608881784735 },
	{ 0.99741943480907724329, 0.0009749748641249451897, 0.99723882446223088838 },
	{ 0.99742001084743792116, 0.0009747556525465760199, 0.99723943780833046446 },
	{ 0.99742060197292614632, 0.00097453989326923230654, 0.99724006799631859099 },
	{ 0.99742116914211553791, 0.0009743230658766542044, 0.99724067911082037163 },
	{ 0.99742174725948606895, 0.00097410536110370505528, 0.99724129682474849101 },
	{ 0.99742232747493997369, 0.00097388723671405655422, 0.99724190984659877302 },
	{ 0.99742291581569930692, 0.00097367243111102922456, 0.99724254068308537668 },
	{ 0.99742346301494855254, 0.00097344990074603888336, 0.99724312061243713945 },
	{ 0.99742405795513400246, 0.0009732385665175232901, 0.99724376377039591901 },
	{ 0.99742463761745714379, 0.00097302282631366574829, 0.99724438665323889008 },
	{ 0.99742518973766591817, 0.00097280399620502326207, 0.99724498138361605815 },
	{ 0.99742576754986067566, 0.00097258728325336294817, 0.99724559467249540567 },
	{ 0.99742636851726773628, 0.00097237434685199560912, 0.9972462372963966093 },
	{ 0.99742691577373754352, 0.00097215240776508157327, 0.99724681873255371922 },
	{ 0.99742748446880602486, 0.00097193802177875337871, 0.99724743167811025213 },
	{ 0.99742806300579334167, 0.00097172157585590185173, 0.99724804683619128198 },
	{ 0.99742863543926507663, 0.00097150558769672223664, 0.99724866107874488019 },
	{ 0.99742919291912357505, 0.00097128959953754251313, 0.99724926464014607141 },
	{ 0.99742974830089847771, 0.00097107029259174172664, 0.9972498529046114335 },
	{ 0.99743033595501218169, 0.00097085350334613629286, 0.99725047511988229587 },
	{ 0.99743092601238525496, 0.00097064338982074576181, 0.99725111186914983108 },
	{ 0.99743147141872690042, 0.0009704259330031187944, 0.99725170156412668021 },
	{ 0.99743206767498326926, 0.00097021274864642938207, 0.99725233394556589417 },
	{ 0.99743262982784586246, 0.00096999750435321652892, 0.99725293954783023054 },
	{ 0.99743319562374443965, 0.000969782050251654054, 0.99725354806833799159 },
	{ 0.99743374814449659027, 0.00096956217110126335056, 0.99725413080149238887 },
	{ 0.99743435513912559465, 0.00096935251533954473139, 0.99725478235178521835 },
	{ 0.99743490975796100795, 0.00096913656532733756781, 0.99725537816935128088 },
	{ 0.99743548203884491166, 0.0009689205771681578443, 0.9972559876816803337 },
	{ 0.99743601399837866772, 0.0009686995917555599753, 0.99725655260019840931 },
	{ 0.99743661721645726637, 0.00096849012672870448109, 0.99725719991617733928 },
	{ 0.99743717935024633903, 0.00096827345192401694397, 0.99725779500895084251 },
	{ 0.99743774270473850585, 0.00096806165993182943883, 0.99725841207438059577 },
	{ 0.99743830125271226716, 0.00096784597694843095377, 0.99725900907450271138 },
	{ 0.99743887635647199286, 0.00096763006508319656697, 0.99725961622171965804 },
	{ 0.99743944047390364904, 0.00096741751015155601993, 0.99726022489481536137 },
	{ 0.99743998986660398209, 0.00096720075905292314609, 0.99726081441813085871 },
	{ 0.99744056687771243119, 0.00096699011146991525802, 0.99726143705301861786 },
	{ 0.9974411131423610577, 0.0009667697745558526427, 0.99726201139383907623 },
	{ 0.99744169341503585713, 0.00096655910789935847467, 0.99726263595514896831 },
	{ 0.99744226073681330202, 0.00096634701073138973108, 0.99726324844294200744 },
	{ 0.99744282802044370584, 0.00096613045036762019904, 0.99726384433680181907 },
	{ 0.99744338857113334917, 0.00096591928780048155918, 0.99726445424967424813 },
	{ 0.9974439599555634528, 0.00096570453941791328627, 0.99726505874567650256 },
	{ 0.99744452580868236957, 0.0009654913932081965423, 0.99726566289835605339 },
	{ 0.99744509419857496635, 0.00096528036415546207907, 0.99726628103190095853 },
	{ 0.99744565667568685363, 0.00096506502449481739239, 0.99726687211924236465 },
	{ 0.99744622792660253552, 0.00096485288917987608887, 0.99726748716288260432 },
	{ 0.99744678254543805984, 0.00096463899910419247455, 0.9972680819123331819 },
	{ 0.99744735215603375078, 0.00096442735969989564285, 0.99726869272165930003 },
	{ 0.99744789500652830672, 0.00096420799553363579961, 0.99726926368647261789 },
	{ 0.99744846991955316007, 0.00096399776756732715507, 0.99726987857752491529 },
	{ 0.99744903014599362034, 0.00096378620445697544324, 0.99727048000269591377 },
	{ 0.99744960357128653605, 0.00096357715904681919255, 0.99727110164576238116 },
	{ 0.99745015471874753921, 0.00096336170494525660921, 0.99727168697291090904 },
	{ 0.99745069455563117877, 0.00096314504921405546048, 0.99727226194315632402 },
	{ 0.99745129031597667968, 0.00096293762505023712713, 0.99727290038996452282 },
	{ 0.99745185475765762995, 0.00096272383034198512949, 0.9972734961884570648 },
	{ 0.99745239562450938031, 0.00096251095116107695561, 0.9972740816491199034 },
	{ 0.9974529692596106889, 0.0009623025351759695702, 0.99727470186167488375 },
	{ 0.99745350976406632615, 0.00096208719551532510036, 0.99727528112345475986 },
	{ 0.9974540733283671079, 0.00096187424004047148134, 0.99727587608271384134 },
	{ 0.99745463920055954521, 0.00096166450798480741704, 0.99727648773127330895 },
	{ 0.99745517878948763979, 0.00096145023643939711913, 0.99727706394129533862 },
	{ 0.99745577018200470842, 0.00096124367058246355279, 0.9972776975243641262 },
	{ 0.99745632766186320683, 0.00096102936089008080336, 0.99727828750544322833 },
	{ 0.99745689517437552407, 0.00096081981956928008085, 0.99727889629298005492 },
	{ 0.9974574374717388725, 0.00096060711204974875196, 0.99727947887354650991 },
	{ 0.99745799939571955228, 0.00096039736092059829926, 0.99728008432322312604 },
	{ 0.99745856481014827377, 0.00096018778145282490839, 0.99728069292002485824 },
	{ 0.99745912490307431231, 0.00095997570335834244478, 0.99728128662043380448 },
	{ 0.99745966987072565146, 0.0009597623091933034107, 0.99728186622553638419 },
	{ 0.99746021613537416695, 0.00095954929649799095177, 0.99728244911127872374 },
	{ 0.99746078296124096596, 0.00095933952629535432753, 0.99728305469446965059 },
	{ 0.99746133975445383513, 0.00095913124382465122716, 0.99728365817957720374 },
	{ 0.99746192376553177716, 0.00095892397224872367566, 0.99728428060465668104 },
	{ 0.99746246255337367437, 0.00095870836555927052731, 0.99728484777384618365 },
	{ 0.99746299371182089999, 0.00095849367439716131115, 0.99728541921549662685 },
	{ 0.99746356584011686142, 0.00095828714668720041316, 0.99728603452616571001 },
	{ 0.99746410951077113527, 0.0009580745917555597577, 0.9972866145127380344 },
	{ 0.99746466172634740133, 0.00095786478340595024826, 0.99728720548563853932 },
	{ 0.99746524074017184347, 0.00095765804588763994536, 0.99728782485896005916 },
	{ 0.99746579348980546342, 0.00095744892418353835795, 0.99728842170649445453 },
	{ 0.99746635005413664121, 0.00095724010765521822582, 0.99728901824885296534 },
	{ 0.99746689313351299955, 0.000957027838825872312, 0.99728959516459392276 },
	{ 0.99746745219647070524, 0.00095681946098773759495, 0.9972901982110111696 },
	{ 0.99746799071728375896, 0.00095660656273334324952, 0.99729077266627230713 },
	{ 0.99746854560314801574, 0.00095639637291400749017, 0.99729136005335727866 },
	{ 0.99746912703930534772, 0.00095619350731342145355, 0.99729199230128207088 },
	{ 0.99746964574276608673, 0.00095597574532001335611, 0.99729253454142507973 },
	{ 0.99747023312985116927, 0.0009557710486647398888, 0.99729315977030696949 },
	{ 0.99747078431545921351, 0.00095556486427753278921, 0.99729376001292191489 },
	{ 0.99747133264004417263, 0.00095535284340350927392, 0.99729434053355192624 },
	{ 0.99747189141689973635, 0.00095514440834491560854, 0.99729494203501678484 },
	{ 0.99747242097317423415, 0.00095493452370136108764, 0.9972955118744943892 },
	{ 0.99747298705517495332, 0.00095472900688617563011, 0.99729612178736692929 },
	{ 0.99747352982937542709, 0.0009545183020827086853, 0.99729670091563227263 },
	{ 0.99747408582150198786, 0.00095430639564960317509, 0.99729728307658205289 },
	{ 0.99747463044583051239, 0.00095409929573505257699, 0.99729787164622318851 },
	{ 0.9974751866859123961, 0.00095389087974994519158, 0.99729846519404430349 },
	{ 0.99747570329128965039, 0.00095367735207050187245, 0.99729901693278344421 },
	{ 0.99747628562390100448, 0.00095347648918598043675, 0.9972996467965224987 },
	{ 0.99747684356152299667, 0.00095326889336078514999, 0.99730024211817780433 },
	{ 0.9974773830932308627, 0.0009530594855543886041, 0.99730082040720990921 },
	{ 0.99747793378292815003, 0.00095285181343524808905, 0.99730141138011030311 },
	{ 0.99747848603665134615, 0.0009526440268751894605, 0.99730200200968788238 },
	{ 0.99747902816235334278, 0.00095243645012348056213, 0.99730258590632492322 },
	{ 0.9974795745032958294, 0.00095222549736469154404, 0.9973031601708511884 },
	{ 0.99748012586056511442, 0.0009520200568434513148, 0.9973037541382888671 },
	{ 0.99748068879544038445, 0.00095181318581073651001, 0.99730435323649446744 },
	{ 0.99748121264874245462, 0.00095160324394672271553, 0.99730491779261631891 },
	{ 0.99748179793774394142, 0.00095140117943256260601, 0.99730554366999679683 },
	{ 0.99748230941235327407, 0.00095118755638568756178, 0.99730608932429376523 },
	{ 0.99748287032543925257, 0.00095098186790912504242, 0.9973066868584735678 },
	{ 0.9974834208434751881, 0.00095077703773944739849, 0.99730728097849929981 },
	{ 0.99748397046505732355, 0.00095056921303241621, 0.99730786172801100253 },
	{ 0.99748449328839094985, 0.00095036133110492607319, 0.99730843139582714407 },
	{ 0.99748505740582271706, 0.00095015640556781681258, 0.99730903366023138101 },
	{ 0.99748559895932009667, 0.00094994932472675238603, 0.99730961507731508142 },
	{ 0.99748614650189215691, 0.00094974296867816844145, 0.99731019824915945193 },
	{ 0.99748670033871467133, 0.00094953531563251420636, 0.99731078451090870995 },
	{ 0.99748723300396735514, 0.00094933071434467235575, 0.99731136470728942722 },
	{ 0.99748778495251488874, 0.00094912247002094192374, 0.99731194892817565112 },
	{ 0.99748833369671663363, 0.00094891948997943788204, 0.99731254482203568479 },
	{ 0.99748888997494555841, 0.0009487098914381782112, 0.99731312238627500832 },
	{ 0.99748942889630187736, 0.00094850662529437942787, 0.9973137083428484928 },
	{ 0.99748994187771666819, 0.00094829454719989707268, 0.99731425405436591181 },
	{ 0.99749053000866771956, 0.00094809849083393033225, 0.99731489353114211038 },
	{ 0.99749106982647772757, 0.00094788818657367645941, 0.99731545761042672549 },
	{ 0.99749160687863225316, 0.00094768141090839327131, 0.99731603212290853566 },
	{ 0.99749214364468452576, 0.00094747690498798303738, 0.99731661397868254237 },
	{ 0.99749269387661809727, 0.00094727091133563927957, 0.99731719839030363861 },
	{ 0.99749323026120073621, 0.00094706564247577600373, 0.99731777437144386589 },
	{ 0.99749375565945519462, 0.00094685655891864708468, 0.99731833478861908748 },
	{ 0.99749431989132786303, 0.00094665586769550249396, 0.99731894258433428924 },
	{ 0.99749483342587375034, 0.00094644476234882291086, 0.99731948480540377755 },
	{ 0.99749540387570290179, 0.00094624388039081497835, 0.997320096911727072 },
	{ 0.9974959453719798308, 0.00094603952705829552627, 0.99732067838603133403 },
	{ 0.99749646928250235156, 0.00094582857429950650818, 0.99732123083048940249 },
	{ 0.99749701192318840359, 0.00094562780678241668917, 0.99732182184153672644 },
	{ 0.99749756560742308675, 0.00094542347252338340864, 0.99732241126948484311 },
	{ 0.99749810454785270419, 0.00094522266685932092127, 0.99732299659663325997 },
	{ 0.99749864421307499196, 0.00094501602470844223505, 0.99732357028895501916 },
	{ 0.99749917966305645667, 0.00094481169044940917136, 0.99732414659434420745 },
	{ 0.99749971139370829931, 0.00094460459053485835643, 0.99732470968180741977 },
	{ 0.99750028060376072503, 0.00094440639793842283845, 0.99732532321864209024 },
	{ 0.99750080539166352533, 0.00094419945061176258853, 0.99732588653498721598 },
	{ 0.99750134877621543517, 0.00094399530708759264979, 0.99732646551066450602 },
	{ 0.99750188374935988556, 0.00094378809273212382978, 0.9973270273392775831 },
	{ 0.99750242438732983352, 0.00094358471214740693295, 0.99732760551386856473 },
	{ 0.9975029612106024457, 0.00094338060677020966257, 0.99732818227702157987 },
	{ 0.99750350007473820302, 0.00094317636787860810715, 0.99732875806742693481 },
	{ 0.99750403424679612296, 0.00094297689735858857864, 0.99732934350901625287 },
	{ 0.99750457322537278149, 0.00094277200996845198638, 0.99732991712504381887 },
	{ 0.99750511098324623482, 0.00094256796181171377275, 0.99733048913889854603 },
	{ 0.99750566146313512927, 0.00094236683189838355013, 0.99733107791834763045 },
	{ 0.99750617797314489188, 0.00094215793907611797287, 0.99733162433558397719 },
	{ 0.99750674951016260472, 0.00094195764839618645412, 0.99733222661906151263 },
	{ 0.99750727227627578042, 0.00094175592720478014299, 0.99733280126505763352 },
	{ 0.99750780105053715729, 0.00094155052483051247369, 0.99733336093836677527 },
	{ 0.99750833770214841767, 0.00094134987175434055133, 0.99733394367152106152 },
	{ 0.99750888307034302205, 0.00094114576637714338937, 0.99733451879435408571 },
	{ 0.99750942607342507618, 0.00094094501793353974191, 0.99733510200434538628 },
	{ 0.9975099405044248746, 0.00094073740303485817518, 0.99733564458781076567 },
	{ 0.99751048339306624957, 0.00094053558647602024737, 0.99733622459345649958 },
	{ 0.99751103095471171933, 0.0009403372985121531127, 0.99733681701594179003 },
	{ 0.99751156733929424725, 0.00094013325035541468223, 0.99733738643580271965 },
	{ 0.99751208712994354766, 0.0009399320632216256197, 0.99733795581751649717 },
	{ 0.99751264396130334688, 0.00093973129570453569227, 0.99733854499750895783 },
	{ 0.99751317592083721397, 0.00093952747642963327195, 0.99733911014490872482 },
	{ 0.99751368094860792812, 0.00093932426750629354536, 0.99733965911799205006 },
	{ 0.99751422652661081436, 0.0009391218596693793122, 0.99734023643427605066 },
	{ 0.99751475114285215184, 0.00093891969978778747757, 0.99734080335551000829 },
	{ 0.99751529870449762161, 0.00093871836006610785003, 0.99734138585978238112 },
	{ 0.99751582938610761087, 0.00093851745903461374597, 0.99734195579462714409 },
	{ 0.99751637116848668185, 0.00093831632912128374018, 0.99734253263407390833 },
	{ 0.99751688559948636925, 0.00093811207115619579637, 0.99734308303766872061 },
	{ 0.99751741492687895363, 0.00093790836632221148954, 0.99734364318781498771 },
	{ 0.99751795276104648913, 0.00093770675957172318349, 0.99734421787195792763 },
	{ 0.99751847770153712069, 0.00093750591576068802776, 0.99734478103571500007 },
	{ 0.99751903022228904927, 0.00093731106102435996115, 0.99734538360529489953 },
	{ 0.99751952969967550011, 0.00093710253059833467908, 0.9973459118836455195 },
	{ 0.99752007092892347462, 0.00093690126717060017141, 0.99734648240976830902 },
	{ 0.99752061765133548388, 0.00093670671761005323483, 0.99734708223276624661 },
	{ 0.99752114571987793301, 0.00093650541603534627564, 0.99734764730387204246 },
	{ 0.99752166123806640385, 0.00093630071938007280834, 0.99734819364481419601 },
	{ 0.99752221444546385065, 0.00093610182106464308836, 0.9973487816422506036 },
	{ 0.99752274373470928293, 0.00093590273201435013502, 0.99734935144358105585 },
	{ 0.99752327449261324332, 0.00093569958031146935676, 0.99734991035395093029 },
	{ 0.99752378232418659199, 0.0009354968482252877136, 0.99735045896463803139 },
	{ 0.99752433263241402361, 0.00093529856026142047052, 0.997351043605140819 },
	{ 0.9975248578017865686, 0.00093510061562030702582, 0.99735161737375643831 },
	{ 0.99752538522183031855, 0.00093489744484393985918, 0.99735217241220830431 },
	{ 0.99752591283260905186, 0.00093469652473895936673, 0.99735273237161969906 },
	{ 0.99752643628536774578, 0.00093449808418720145022, 0.9973533017533335876 },
	{ 0.99752697331844875084, 0.00093430086433856870433, 0.99735387830667809883 },
	{ 0.99752748921810696636, 0.00093409746468036563595, 0.99735442563944154415 },
	{ 0.99752800868450686167, 0.0009338991576430121129, 0.99735499191217691362 },
	{ 0.99752855887829350312, 0.00093369777977435981699, 0.99735556476526532332 },
	{ 0.99752907241283927942, 0.00093349781334369570825, 0.99735611965112946908 },
	{ 0.99752961890636948628, 0.00093330044090717228893, 0.9973567042916322567 },
	{ 0.99753013631283293794, 0.00093309885323017037126, 0.99735725297861332894 },
	{ 0.99753066335140705423, 0.00093290140449970161522, 0.99735781969003889369 },
	{ 0.99753120458065502874, 0.00093270502388446724796, 0.99735840333872038954 },
	{ 0.99753172320782157456, 0.00093250564873187922772, 0.9973589638512629918 },
	{ 0.9975322600692411168, 0.00093230642616718188091, 0.99735953195505322455 },
	{ 0.99753278369366138456, 0.0009321076613661565544, 0.99736009281091864143 },
	{ 0.99753328502117588616, 0.00093190769493549244565, 0.997360637473393985 },
	{ 0.99753382224499165254, 0.00093170791923969167869, 0.99736120574884545853 },
	{ 0.99753433583675787943, 0.00093150770485370549667, 0.99736175310068242439 },
	{ 0.99753486173092276168, 0.00093130743324726014947, 0.9973623139374742097 },
	{ 0.99753540631710435616, 0.00093111379921405692823, 0.99736289789133136807 },
	{ 0.99753593171535859252, 0.00093091577827899814682, 0.99736346471719783402 },
	{ 0.99753646577297561127, 0.00093071741402118567544, 0.99736403295450226647 },
	{ 0.99753696536480285229, 0.00093051372826068754016, 0.99736456111841198524 },
	{ 0.99753752334057188556, 0.00093031936943500394537, 0.99736515258722291399 },
	{ 0.99753803565441456769, 0.00093012214958637109107, 0.99736570854120232266 },
	{ 0.99753854739605274382, 0.00092992214500873431396, 0.99736625339441276061 },
	{ 0.99753905198513359576, 0.00092972242653339260375, 0.99736679914407688763 },
	{ 0.99753958491741512304, 0.00092952545464008214798, 0.9973673674004547296 },
	{ 0.99754012200771646768, 0.00092933008491962311275, 0.99736794252328775379 },
	{ 0.99754064204632109103, 0.0009291336089369571288, 0.99736850707940949423 },
	{ 0.9975411443656568844, 0.00092893036186664451701, 0.99736903503351082012 },
	{ 0.99754170005260744958, 0.00092873798668353891791, 0.99736963123254629426 },
	{ 0.99754221532284059748, 0.00092853937447040415642, 0.99737018205575789231 },
	{ 0.99754272031246460362, 0.00092833711922138070511, 0.99737071161203216807 },
	{ 0.99754325046001701693, 0.00092814434349506214246, 0.99737129211358843683 },
	{ 0.99754376511989850673, 0.00092794683754413432968, 0.99737184511117737973 },
	{ 0.99754429128109212144, 0.00092775003731220082731, 0.99737240438394336728 },
	{ 0.99754479863582834476, 0.00092754999458759149027, 0.9973729428666092689 },
	{ 0.99754534535824046504, 0.00092735758125751333123, 0.9973735320084547995 },
	{ 0.99754585490642766477, 0.00092715847313373388108, 0.99737407657556276241 },
	{ 0.99754633067547060499, 0.00092695431053607755395, 0.99737458347253515889 },
	{ 0.99754687310634815312, 0.00092676340401141930718, 0.99737517141275100485 },
	{ 0.99754741280971725992, 0.00092656976997821630278, 0.99737574956826857697 },
	{ 0.99754793107448769263, 0.0009263731604811461422, 0.99737630323342951755 },
	{ 0.99754844693599897809, 0.00092617346107929060355, 0.99737684846810947814 },
	{ 0.99754896035610396421, 0.00092597765266864604482, 0.99737740133218399929 },
	{ 0.99754947619854150709, 0.00092577923119037462511, 0.99737794559411618867 },
	{ 0.9975500026839845269, 0.00092558561623065779226, 0.99737851633004748209 },
	{ 0.99755053180156871839, 0.00092538978874652695356, 0.99737907718591278794 },
	{ 0.99755105975567004428, 0.00092519752800433935954, 0.99737965030602981908 },
	{ 0.99755156028209812646, 0.00092499691307514010554, 0.99738017684869328949 },
	{ 0.99755207221447128596, 0.00092480053245990562986, 0.99738072692803891872 },
	{ 0.9975526243728269904, 0.00092460668861835289527, 0.99738130720071327406 },
	{ 0.99755308940349729507, 0.0009244065505263117247, 0.99738181949548243566 },
	{ 0.99755364619671005322, 0.00092421596825092099635, 0.99738240772180064564 },
	{ 0.99755416110454686596, 0.00092401951134174140079, 0.99738296169213735975 },
	{ 0.99755465579448820979, 0.00092382084190814769097, 0.99738348812035981794 },
	{ 0.99755517106472124667, 0.00092362474739520817376, 0.99738403631143035533 },
	{ 0.99755569199977978112, 0.0009234315711256768644, 0.99738460058144984277 },
	{ 0.99755621234356028904, 0.00092323677360980774612, 0.99738515441827224617 },
	{ 0.99755673453746895873, 0.00092304180443256156601, 0.99738571140221965461 },
	{ 0.9975572434753047224, 0.00092284574806659460874, 0.99738625722817786379 },
	{ 0.99755775075374697458, 0.00092265157997577424732, 0.99738680341653218608 },
	{ 0.99755827056347001758, 0.00092245571434467063185, 0.99738735534600608812 },
	{ 0.99755880393444162912, 0.0009222632247206471361, 0.99738792686395039144 },
	{ 0.99755929433284851182, 0.00092206816017596933931, 0.99738846082620002953 },
	{ 0.99755983287273497506, 0.00092187694847552996251, 0.99738903579644522246 },
	{ 0.99756033027111123968, 0.0009216774016615652057, 0.99738956172875703476 },
	{ 0.99756086478649208527, 0.00092148804008929964798, 0.99739013835839562816 },
	{ 0.99756136878429479964, 0.00092129043877094021851, 0.99739067439965523043 },
	{ 0.99756186921535572321, 0.00092109270393817650399, 0.99739120565346983671 },
	{ 0.99756237887798382413, 0.00092089992821185804976, 0.99739175712518002292 },
	{ 0.99756289620815341568, 0.00092070341408221950587, 0.99739230024270308927 },
	{ 0.99756340627132489285, 0.00092051157295673115537, 0.99739285692147505724 },
	{ 0.99756393697200840265, 0.00092032083809344975359, 0.99739342485360382717 },
	{ 0.99756441937862450065, 0.0009201217871901294686, 0.99739393838814971449 },
	{ 0.99756494336544099255, 0.00091992861092059815924, 0.99739449594430207302 },
	{ 0.99756545133052887397, 0.00091973345100848885418, 0.99739503839425314169 },
	{ 0.99756596814571441012, 0.00091953981697528574136, 0.99739558938912631358 },
	{ 0.99756648541866366209, 0.00091934847176044186268, 0.99739614755563021919 },
	{ 0.99756701386867574488, 0.00091916052162616460053, 0.99739671995095491308 },
	{ 0.99756750909267466465, 0.00091896040260760992677, 0.99739723821572534579 },
	{ 0.99756800555645019912, 0.00091876732170551034251, 0.99739777698449350041 },
	{ 0.99756851390300771421, 0.00091857269585101817763, 0.9973983201210900873 },
	{ 0.99756904609142316165, 0.00091838070213763926212, 0.99739888061455928003 },
	{ 0.99756952868877424301, 0.00091818596184222909216, 0.99739940257958603631 },
	{ 0.99757007262645736034, 0.00091799923241107689222, 0.99739999198846052142 },
	{ 0.99757058125911723945, 0.0009178049689528248057, 0.99740053209237289344 },
	{ 0.9975711182349777939, 0.00091761623680560800483, 0.99740110618523791786 },
	{ 0.99757160911022191296, 0.0009174195510145922907, 0.99740162452630243273 },
	{ 0.9975720977729416461, 0.00091722050011127189729, 0.99740213943413924547 },
	{ 0.99757262092052478852, 0.00091703365623920147544, 0.99740271049431994399 },
	{ 0.99757313638149280877, 0.00091684561073749237976, 0.99740327279977025743 },
	{ 0.99757363238750484946, 0.00091664676964252171654, 0.99740378986291122754 },
	{ 0.99757414748607664556, 0.00091645622551410376496, 0.99740434104851916075 },
	{ 0.99757464681087515412, 0.00091626455604999236786, 0.99740488519601078199 },
	{ 0.99757514920650502965, 0.00091607023537128133301, 0.99740541917733405164 },
	{ 0.99757566808162700944, 0.00091587850868671098759, 0.99740597070626468845 },
	{ 0.99757615924297327048, 0.00091568409264056833605, 0.99740649459771368868 },
	{ 0.99757669104991919529, 0.00091549827873675985145, 0.99740707401208150706 },
	{ 0.99757717872081774768, 0.00091530479729144741206, 0.99740760074547996084 },
	{ 0.99757769570766474665, 0.00091511205971210151777, 0.99740814149789092102 },
	{ 0.99757818738399528513, 0.00091491602241962094889, 0.9974086643021511378 },
	{ 0.99757870118556979389, 0.00091472845375507004506, 0.99740922128609887931 },
	{ 0.99757921481548317288, 0.00091453899681537287065, 0.99740977329186675249 },
	{ 0.99757971160350811246, 0.00091434349358050955037, 0.99741029533318759093 },
	{ 0.99758023765026093699, 0.00091415451347797045938, 0.99741085998467682305 },
	{ 0.99758074344097136255, 0.00091396343529193515079, 0.99741140064172029156 },
	{ 0.99758125596462243756, 0.00091377378761737463458, 0.99741195138863791847 },
	{ 0.99758173407970407442, 0.00091357929527728664633, 0.99741246517113912873 },
	{ 0.99758223475872009889, 0.00091338600456683744031, 0.99741299667290905795 },
	{ 0.997582745928153658, 0.00091319832146136853141, 0.99741355361870975837 },
	{ 0.99758325416027027188, 0.00091300739586322389625, 0.99741409206322872993 },
	{ 0.99758377974925949161, 0.00091281780540912232837, 0.99741464755944442278 },
	{ 0.99758427764354651313, 0.00091262386620013786868, 0.99741517719201278069 },
	{ 0.99758480035243934925, 0.00091243921577899528112, 0.99741574415139389043 },
	{ 0.99758527875362335013, 0.0009122451621290930332, 0.9974162577240867078 },
	{ 0.99758578206478054629, 0.00091205343544452279619, 0.99741679323128895618 },
	{ 0.9975862874549475956, 0.00091186523735492313551, 0.99741733932427589782 },
	{ 0.99758679862438104369, 0.00091167328178851677993, 0.99741787673882664755 },
	{ 0.9975873093932714486, 0.00091148439705340941405, 0.99741842470101538254 },
	{ 0.99758779141841791294, 0.00091129289925067497036, 0.99741894121102514514 },
	{ 0.99758830571590317859, 0.00091110605537860465692, 0.99741949808053198545 },
	{ 0.9975888056319797137, 0.00091091215431659275717, 0.9974200238602559665 },
	{ 0.99758928983150352288, 0.00091072328865497167126, 0.99742055757455039267 },
	{ 0.99758979566036087849, 0.00091052904427020608154, 0.99742107896737264294 },
	{ 0.99759029202876903231, 0.00091034242927997166984, 0.99742162202767536971 },
	{ 0.99759079139171458195, 0.00091015426933734446067, 0.99742216648034276449 },
	{ 0.99759130530773021395, 0.00090996261894671934354, 0.99742269992760834718 },
	{ 0.99759180797038882194, 0.00090977550804584035159, 0.9974232472985189446 },
	{ 0.99759232833324273937, 0.00090958549797503954019, 0.99742379413537185506 },
	{ 0.99759282010494054749, 0.00090939779579608445974, 0.99742433053902790352 },
	{ 0.99759332120357335771, 0.00090920553505389686572, 0.99742485361031696378 },
	{ 0.99759379970012473926, 0.00090901451408832061388, 0.99742537338189274365 },
	{ 0.99759429797588161648, 0.0009088235503432035272, 0.99742590248040341461 },
	{ 0.99759481479106726365, 0.00090863907158343789304, 0.9974264617150224721 },
	{ 0.99759531493602571217, 0.0009084499770399809054, 0.9974269933693803436 },
	{ 0.99759580733714869893, 0.00090826305687396514683, 0.9974275309365189246 },
	{ 0.9975963178199366288, 0.0009080737715956448174, 0.9974280698006545709 },
	{ 0.99759680739818357154, 0.00090788387596576190265, 0.99742859676293482707 },
	{ 0.99759731566844711548, 0.00090769176781146498206, 0.99742912609032730042 },
	{ 0.99759779488979094531, 0.00090750376045672877159, 0.99742964944771861369 },
	{ 0.99759830499110935254, 0.00090731561958758795081, 0.99743019189766968235 },
	{ 0.99759881213603740502, 0.00090712944328753917101, 0.99743073791436276387 },
	{ 0.99759931308208238399, 0.0009069409972426172202, 0.99743126998833742114 },
	{ 0.99759979718623881251, 0.00090675054848163088531, 0.99743178823403433331 },
	{ 0.99760029492793811379, 0.00090656286537616208483, 0.99743231954506950121 },
	{ 0.99760079610286489515, 0.00090637403786151355886, 0.9974328544419202025 },
	{ 0.99760128957210314482, 0.00090618513405291969617, 0.99743338025979122463 },
	{ 0.99760177577434305807, 0.00090599792778460919596, 0.99743391158989980205 },
	{ 0.99760225806651836589, 0.00090580768883197237441, 0.99743442340783206035 },
	{ 0.99760277396617658141, 0.00090562259972064426336, 0.99743497989586915597 },
	{ 0.99760327704845186414, 0.00090543567955462861321, 0.99743551441125000157 },
	{ 0.99760378585277320607, 0.00090524959862201134168, 0.99743605815819824656 },
	{ 0.9976042748206684907, 0.00090506092369525338072, 0.9974365803902537353 },
	{ 0.99760474908290597273, 0.00090486982643573190058, 0.99743708856514989858 },
	{ 0.99760526261745197107, 0.00090468298256366158714, 0.99743762712410977134 },
	{ 0.99760577851710996455, 0.00090450094521014575213, 0.99743819032601399588 },
	{ 0.99760624322353075311, 0.00090430754005877854104, 0.99743868158272763758 },
	{ 0.99760674849925712326, 0.000904123309254335197, 0.99743922756127356699 },
	{ 0.99760723859248834344, 0.00090393446266620039106, 0.99743974939278590153 },
	{ 0.99760771726070129883, 0.00090374693214862226402, 0.99744026712349875829 },
	{ 0.99760824168620798602, 0.0009035649901625380457, 0.99744082935265532264 },
	{ 0.99760871785579408044, 0.00090337209999530169481, 0.99744132921151162918 },
	{ 0.99760922320781431072, 0.00090318809807269414408, 0.99744187091759684005 },
	{ 0.99760970731197085026, 0.00090300100624530164894, 0.99744239438942916554 },
	{ 0.99761019746242241002, 0.00090281229317157123647, 0.99744291536263474107 },
	{ 0.9976106977599686898, 0.00090262945473162979962, 0.99744345891884811373 },
	{ 0.99761119327006997359, 0.00090244049370257709702, 0.99744397827080721886 },
	{ 0.99761167367397018957, 0.00090225092232196180912, 0.99744448934487328629 },
	{ 0.99761218713222221677, 0.00090206919014422732098, 0.99744504552773460837 },
	{ 0.9976126571029253487, 0.00090187998115985232826, 0.99744554479531277735 },
	{ 0.99761316136775679553, 0.00090169447243182497369, 0.99744608797005651635 },
	{ 0.99761367074428264345, 0.0009015139228102428794, 0.997446640528955486 },
	{ 0.99761413812099164478, 0.00090132181465594585039, 0.99744713231972692569 },
	{ 0.99761461945949247987, 0.00090113481819598486352, 0.99744764799050322779 },
	{ 0.99761513352809605415, 0.00090095247566668779007, 0.99744819593361844223 },
	{ 0.99761560056148235187, 0.00090076223671405096852, 0.99744869600228303064 },
	{ 0.99761610204158479576, 0.0009005785971876838214, 0.99744923303536425774 },
	{ 0.99761660224376369488, 0.00090039421379534980393, 0.99744977035454762682 },
	{ 0.99761707614360495278, 0.0009002058821913458582, 0.99745027561120058746 },
	{ 0.99761758201060934947, 0.00090002281486956841119, 0.9974508151238347109 },
	{ 0.99761806956706688965, 0.00089983806908099420695, 0.99745134235314369953 },
	{ 0.99761854993281995352, 0.00089965093910662904345, 0.99745185548714643264 },
	{ 0.99761904241023691142, 0.00089946699440448044105, 0.99745238290719040464 },
	{ 0.99761954398570662494, 0.00089928001701800573415, 0.99745291000298497153 },
	{ 0.99762003268657328814, 0.00089909656822650160356, 0.99745343898705474128 },
	{ 0.99762053046641940846, 0.00089891311943499747298, 0.99745397277764313859 },
	{ 0.99762100676951992462, 0.00089872597038714581268, 0.99745447898797023889 },
	{ 0.99762150763927082142, 0.00089854538261859105003, 0.99745502380303363577 },
	{ 0.99762199122844319454, 0.00089835621178118872567, 0.99745553417138077545 },
	{ 0.99762248696742616971, 0.00089817323982684289536, 0.99745606412819853848 },
	{ 0.99762295264659484051, 0.00089798446953265342613, 0.99745655986718162467 },
	{ 0.99762347041545462734, 0.00089780529320208685064, 0.99745712089470839334 },
	{ 0.99762394214091854039, 0.00089761677086321956312, 0.99745761856011372348 },
	{ 0.99762442878184887096, 0.00089743156731097344699, 0.99745813671044325499 },
	{ 0.99762490863261787943, 0.00089724849998919599999, 0.99745866012505501885 },
	{ 0.99762542294917666563, 0.00089706342995135406049, 0.99745919393471682568 },
	{ 0.99762591140208800589, 0.0008968848067518912304, 0.99745973129204723584 },
	{ 0.99762637412486632194, 0.000896695826649352031, 0.99746022422722790957 },
	{ 0.99762686835704406096, 0.00089651256859271124221, 0.99746075080803831003 },
	{ 0.99762733319697927126, 0.00089632612526385367548, 0.9974612529557127516 },
	{ 0.99762784360347345203, 0.00089614622414080661802, 0.99746179754189434608 },
	{ 0.99762831475673263704, 0.000895960410236998025, 0.9974623053925413263 },
	{ 0.99762881410060466614, 0.0008957750922438339038, 0.99746282701424526795 },
	{ 0.99762930350719025707, 0.00089559341728655836399, 0.99746335582665368591 },
	{ 0.99762977994380508395, 0.00089540720283953680741, 0.99746386239937689933 },
	{ 0.99763025966105967068, 0.00089522537529437070259, 0.99746438136986648182 },
	{ 0.9976307583373597021, 0.00089504389107195839615, 0.99746491815499227496 },
	{ 0.99763124410090942007, 0.00089486131966082542097, 0.99746543947152044307 },
	{ 0.99763171353755486503, 0.0008946737128493019572, 0.99746593454293153158 },
	{ 0.99763222966609488296, 0.0008944966346022314909, 0.99746649156502609213 },
	{ 0.99763268594203491357, 0.00089430807411639175186, 0.99746697690895913535 },
	{ 0.99763317346034530164, 0.0008941254264113136568, 0.99746749525002365022 },
	{ 0.99763365859446984096, 0.0008939435607191747752, 0.99746801895073766708 },
	{ 0.99763415526805387934, 0.00089376243889300287238, 0.99746854980400911916 },
	{ 0.99763460935054282253, 0.00089357508003680169873, 0.99746903585366109013 },
	{ 0.99763512078700522512, 0.00089339788734881322736, 0.99746958703926902334 },
	{ 0.99763558738170110551, 0.00089320980370013146332, 0.99747007717064717358 },
	{ 0.99763608279643489762, 0.0008930300933119479645, 0.99747061172417506025 },
	{ 0.9976365712684196474, 0.0008928501540419283471, 0.99747113719872326776 },
	{ 0.99763704738078540224, 0.00089266327202288525688, 0.99747163894585455512 },
	{ 0.9976375229972405112, 0.0008924812346693695303, 0.99747215148857903966 },
	{ 0.99763801602778867661, 0.00089230310738055106361, 0.99747268903664432216 },
	{ 0.9976384862083000904, 0.00089211841881243569927, 0.99747318748406232913 },
	{ 0.99763898860392996593, 0.00089193584740130283251, 0.99747371383599103822 },
	{ 0.99763943498073048843, 0.00089174856483904688716, 0.99747419202736664623 },
	{ 0.99763992036281046172, 0.00089156591713396868368, 0.99747470731667331467 },
	{ 0.99764040166316436675, 0.00089138590157000383799, 0.99747522981575775791 },
	{ 0.99764091151652734002, 0.00089121208488909548634, 0.99747578624657429192 },
	{ 0.99764137134013575192, 0.00089102356255022830724, 0.99747626926354204802 },
	{ 0.99764184714732573322, 0.00089084362328020879826, 0.99747678504875925132 },
	{ 0.99764233382640299386, 0.00089065937340227906583, 0.99747729370049287301 },
	{ 0.99764281884608685402, 0.00089047941505877295162, 0.99747781339577468174 },
	{ 0.99764330750880647614, 0.00089029897987810886241, 0.99747833730629709148 },
	{ 0.99764376155314871131, 0.00089011570274798190207, 0.99747883289269223539 },
	{ 0.99764426719127119458, 0.00088993667900530610843, 0.9974793656151653698 },
	{ 0.99764473201213299536, 0.00088975467979876294179, 0.99747986812523614653 },
	{ 0.99764520289836355893, 0.00088957126915423158798, 0.99748036708763854197 },
	{ 0.99764570449290679299, 0.00088939201652971978419, 0.99748090408257239492 },
	{ 0.99764616683421536436, 0.00088920982658831349259, 0.99748140243462313226 },
	{ 0.99764664893565568882, 0.00088903061211077424875, 0.99748192100456933851 },
	{ 0.99764712676463507268, 0.00088884880363909442389, 0.99748242660454489172 },
	{ 0.99764760226664928044, 0.00088866512596575439158, 0.9974829307167885073 },
	{ 0.99764809182582281366, 0.00088848676979510002316, 0.99748345792702397539 },
	{ 0.99764853879390147373, 0.00088830362617937723944, 0.99748394166878406875 },
	{ 0.99764903615413114135, 0.00088812532722918192778, 0.9974844722931736074 },
	{ 0.99764952649531768447, 0.00088794519722429907701, 0.99748499177864713428 },
	{ 0.99764999854503078058, 0.00088776386558977733558, 0.99748549568108235697 },
	{ 0.99765046613154784172, 0.00088758169472185732395, 0.99748599862984321796 },
	{ 0.99765091645656001074, 0.00088740053474871253593, 0.99748648771217962583 },
	{ 0.99765142503199932822, 0.00088722215950457199597, 0.99748702344826356558 },
	{ 0.99765190413890236787, 0.00088704258263079256534, 0.99748753539971002358 },
	{ 0.99765235389170991986, 0.00088685924828020654825, 0.99748802268913860924 },
	{ 0.99765283862529152703, 0.00088667930901018703928, 0.9974885359566557641 },
	{ 0.99765332358775482557, 0.00088650112450090962427, 0.99748905273369425917 },
	{ 0.9976537770026718821, 0.00088631733238665180372, 0.99748953773430448777 },
	{ 0.99765426516948085833, 0.0008861378508803040982, 0.99749005870750995228 },
	{ 0.99765474048076008273, 0.00088596069633928851202, 0.99749057552269537741 },
	{ 0.99765523396907185294, 0.0008857839804884582325, 0.99749110212257952046 },
	{ 0.99765568469462717616, 0.00088560085594622183717, 0.9974915834801538761 },
	{ 0.99765617822108587642, 0.00088542402565447366099, 0.99749211603096554768 },
	{ 0.99765667384562806141, 0.00088524875938860445382, 0.99749264663628178784 },
	{ 0.99765712092814762268, 0.00088506290733782319244, 0.99749311996391853974 },
	{ 0.99765758937297188691, 0.00088488498985735434751, 0.99749362441948485891 },
	{ 0.99765806922374078436, 0.00088470344841448320117, 0.99749412906578605043 },
	{ 0.99765853818354910398, 0.00088452604591814532487, 0.99749463922432490826 },
	{ 0.99765902764735514552, 0.00088434870064226618006, 0.99749516035011831505 },
	{ 0.99765951425013843501, 0.00088417246162859409239, 0.99749568296364365949 },
	{ 0.99765995406565954884, 0.00088398636162249043247, 0.99749614555290744278 },
	{ 0.99766045392451552232, 0.00088381216347185572249, 0.9974966853134971112 },
	{ 0.99766090482173230836, 0.00088363195717302753501, 0.99749717130592863157 },
	{ 0.9976613882010962886, 0.00088345344841448260158, 0.99749768543175254543 },
	{ 0.99766184958873049826, 0.00088327465355364270967, 0.99749818550041713383 },
	{ 0.99766232352671879724, 0.00088309673607317397317, 0.99749868934563190592 },
	{ 0.99766279593882811749, 0.00088291729271379882759, 0.99749919349602245155 },
	{ 0.99766327901301610215, 0.00088274187386003894699, 0.9974997172348835095 },
	{ 0.99766375649867278241, 0.00088256307899919883824, 0.99750022218636058557 },
	{ 0.99766421781001302094, 0.00088238313972917922084, 0.99750071821144592477 },
	{ 0.99766469203410357292, 0.00088220436394182571733, 0.99750122215202818854 },
	{ 0.99766516160426343962, 0.00088202455818621027656, 0.99750172002724180054 },
	{ 0.99766562665400693177, 0.00088184843361345630237, 0.99750222703865532026 },
	{ 0.99766609876094036746, 0.00088166868507830002677, 0.99750272417000296343 },
	{ 0.99766657754359411303, 0.00088149423897234291825, 0.99750324346474161796 },
	{ 0.99766703576502957507, 0.00088130976021257717568, 0.99750371938637250047 },
	{ 0.99766750003276016834, 0.00088113441765276263179, 0.99750422496727464416 },
	{ 0.99766796990809591961, 0.00088095621406999893681, 0.99750472997597217084 },
	{ 0.99766846923289442817, 0.00088078201591936422683, 0.997505260009083905 },
	{ 0.9976689197486413585, 0.00088060219109026261451, 0.99750574500969413361 },
	{ 0.99766938418803352562, 0.0008804257613417275103, 0.99750624515465269315 },
	{ 0.99766986667094370578, 0.0008802478438612587738, 0.99750675266197685875 },
	{ 0.99767033492503298664, 0.00088007088005510631257, 0.99750725906303894241 },
	{ 0.99767079221186771854, 0.00087989088356462763843, 0.99750774312904832986 },
	{ 0.99767126904902581064, 0.00087971525490251813607, 0.99750825597694880997 },
	{ 0.99767173764643790612, 0.00087953718483415872613, 0.99750875478676326313 },
	{ 0.9976721979278098118, 0.00087936025917497904168, 0.99750925413063518121 },
	{ 0.99767266755519001808, 0.00087918436348406107765, 0.99750975816658471462 },
	{ 0.9976731261580952248, 0.00087900469124285003034, 0.99751024286201928071 },
	{ 0.99767360341487010267, 0.00087883039772478348684, 0.99751075643471220911 },
	{ 0.99767407651362483012, 0.00087865484535661921277, 0.99751126722267613456 },
	{ 0.99767452344355644911, 0.00087847555458513463221, 0.99751174436501011122 },
	{ 0.99767501428065352709, 0.0008783028632399198345, 0.99751226846626739331 },
	{ 0.99767547236857456738, 0.00087812336266008574059, 0.99751275459221333541 },
	{ 0.99767595086512594893, 0.00087794889748064235211, 0.99751327005318135566 },
	{ 0.99767640317378059045, 0.00087776895821062262629, 0.99751375036171396893 },
	{ 0.9976768816131115214, 0.00087759523689714610817, 0.99751426526955078167 },
	{ 0.9976773214286325242, 0.00087741428673235105033, 0.99751473102501353463 },
	{ 0.99767779185709903889, 0.00087723743736711659418, 0.99751523319176160776 },
	{ 0.99767826957163763257, 0.00087706375420061263599, 0.99751574523857566845 },
	{ 0.99767874755320495872, 0.00087689277946916715546, 0.99751626594475240051 },
	{ 0.997679197458600453, 0.00087671264946428430469, 0.99751673995903467063 },
	{ 0.99767967742381036267, 0.00087653740227190148591, 0.99751725379875633148 },
	{ 0.99768012252268734041, 0.00087635689079729205998, 0.99751772361687152113 },
	{ 0.99768061870036062189, 0.00087618694603410840829, 0.99751825717857811604 },
	{ 0.99768106160578662323, 0.00087600801765886412292, 0.99751873117378686562 },
	{ 0.99768152430949141873, 0.00087583427727190121641, 0.99751923232964001542 },
	{ 0.99768201671061429447, 0.00087565895378557316933, 0.99751974700859513678 },
	{ 0.99768247100291151952, 0.0008754849654432879727, 0.99752024082115620107 },
	{ 0.99768291976389766873, 0.00087530689537492856276, 0.99752072437218153311 },
	{ 0.99768340495524276967, 0.00087513038933244801341, 0.99752122772148577035 },
	{ 0.99768385960993621886, 0.00087495844185319986922, 0.99752173120430442932 },
	{ 0.99768430011210285091, 0.000874779742359791594, 0.99752220157555093749 },
	{ 0.99768480487284505465, 0.00087460945427385403551, 0.99752273563316817828 },
	{ 0.99768524617609821714, 0.00087443128883806290046, 0.99752320901802538078 },
	{ 0.99768569768366643924, 0.00087425657570329711344, 0.99752369928291795276 },
	{ 0.9976861568206292219, 0.00087407911598650007198, 0.99752418374947071644 },
	{ 0.99768662969050214695, 0.00087390592873064058561, 0.99752469140938293535 },
	{ 0.99768708032068997849, 0.00087373155891862870539, 0.99752518072060114562 },
	{ 0.99768756848749895472, 0.0008735597068068122863, 0.99752569749763986273 },
	{ 0.99768799609598868283, 0.00087337955772844304714, 0.99752615398338828623 },
	{ 0.99768847629008028388, 0.00087320667564836479922, 0.99752666561058556116 },
	{ 0.99768894875941005473, 0.00087303236305681208417, 0.99752716752937831135 },
	{ 0.99768941661295595935, 0.00087286110222307164517, 0.99752767253807594905 },
	{ 0.99768986655649838369, 0.00087268413841691907552, 0.99752815330437250019 },
	{ 0.99769032609400432055, 0.00087251123726335465605, 0.99752865072182239636 },
	{ 0.99769077939448025383, 0.00087233442604509297668, 0.99752913148811883648 },
	{ 0.99769125123438495706, 0.00087216394722429207639, 0.99752964391640253083 },
	{ 0.99769170897898307171, 0.000871986125111255065, 0.9975301211159569581 },
	{ 0.99769217070993998497, 0.00087181614220109885337, 0.99753062984398432889 },
	{ 0.99769261952814680683, 0.00087163782417741715331, 0.99753109735420775195 },
	{ 0.9976930983108005524, 0.00087146627724138186425, 0.99753161207130980337 },
	{ 0.99769354098734475134, 0.00087128788292375471906, 0.99753207992485604105 },
	{ 0.99769399478373155254, 0.00087111606895891096833, 0.99753257278374285466 },
	{ 0.99769447982248871121, 0.00087094696342912580368, 0.9975330956642971536 },
	{ 0.99769492156443206898, 0.00087076706230607885464, 0.99753355785301789371 },
	{ 0.99769536498484212572, 0.00087059219658342261103, 0.99753403362206083393 },
	{ 0.99769584571299141373, 0.00087042366325822736334, 0.99753455249718292475 },
	{ 0.9976962972396332674, 0.0008702486258741940579, 0.99753503736427884263 },
	{ 0.99769676667627871236, 0.00087007627785173316699, 0.99753553609779932465 },
	{ 0.9976972162764984331, 0.00086990240395036597543, 0.99753601850441575571 },
	{ 0.99769769381937545294, 0.00086973079979387173805, 0.99753652446678764409 },
	{ 0.997698139108987192, 0.00086955642998186007467, 0.99753700485161445055 },
	{ 0.99769859891352208336, 0.0008693844062086668106, 0.99753750112465533473 },
	{ 0.99769902348932759661, 0.00086920625984636195552, 0.99753795194557814963 },
	{ 0.9976994936698390104, 0.00086903435051408647969, 0.99753845134667062933 },
	{ 0.99769996436533459061, 0.00086886486351457463146, 0.99753896301201494534 },
	{ 0.99770042344507692267, 0.00086868967354265076101, 0.99753944303444552766 },
	{ 0.99770088923868649466, 0.00086852035820451586618, 0.99753994998863859678 },
	{ 0.99770133517679682189, 0.00086834678947892980465, 0.99754042919090923913 },
	{ 0.99770179641184297825, 0.00086817417442766034365, 0.99754091941765488105 },
	{ 0.9977022602218098557, 0.00086800066292253323045, 0.99754141126564688236 },
	{ 0.99770270381388126424, 0.00086782692253557021551, 0.99754188617638295256 },
	{ 0.9977031625503008927, 0.00086765833198991591108, 0.9975423874466772256 },
	{ 0.99770362254557043435, 0.00086748298943010147561, 0.99754286586693496908 },
	{ 0.99770405427393338282, 0.00086730676948991588474, 0.99754332799843525859 },
	{ 0.99770452802118669844, 0.00086713774025407594839, 0.99754383516243683161 },
	{ 0.99770498368677495993, 0.00086696726143327515653, 0.99754432973793738526 },
	{ 0.99770541951593749719, 0.00086679197609391966939, 0.99754479211739288669 },
	{ 0.99770589234766349218, 0.00086662493050065794557, 0.99754530675820096697 },
	{ 0.99770633611139625252, 0.00086645254433122438631, 0.99754578470162147408 },
	{ 0.99770679885324808911, 0.00086627712547746461413, 0.99754626754692787838 },
	{ 0.99770725242075286587, 0.00086610599815812867701, 0.99754675300530193383 },
	{ 0.99770770684656462368, 0.00086593492805925179664, 0.99754724126747840174 },
	{ 0.99770815764841402906, 0.00086576111137834355341, 0.99754771942070719071 },
	{ 0.99770859614786455705, 0.000865591090321214565, 0.99754820049217940436 },
	{ 0.99770905665811837615, 0.00086541866600480822896, 0.99754868724755052511 },
	{ 0.99770951411661434882, 0.0008652511245009019249, 0.99754918559960115143 },
	{ 0.9977099491065435366, 0.000865074923634202614, 0.9975496467583535587 },
	{ 0.9977104234641483993, 0.00086490436851945648542, 0.99755014652184226254 },
	{ 0.99771087169107697257, 0.0008647338515516830252, 0.9975506318276283757 },
	{ 0.9977113388770508795, 0.00086456314384904622318, 0.99755112312248928053 },
	{ 0.99771178748544919745, 0.0008643916350599837109, 0.99755160591057523423 },
	{ 0.99771224257883284192, 0.00086422355949846026667, 0.9975521032708046798 },
	{ 0.99771269975122645057, 0.00086405126869645832409, 0.99755258333138219218 },
	{ 0.99771312734064276917, 0.00086387689888444666071, 0.99755304288796164958 },
	{ 0.99771357198175592007, 0.00086370508491960290998, 0.9975535186570045898 },
	{ 0.99771400975641399977, 0.00086353189766374342361, 0.99755398542336193302 },
	{ 0.99771450654443882833, 0.00086336859047380178946, 0.99755451959542007501 },
	{ 0.99771494935449744901, 0.00086319616615739556183, 0.99755498865059577529 },
	{ 0.99771539536890163635, 0.00086302297890153618388, 0.99755546243599613199 },
	{ 0.99771585816797392354, 0.00086285711586442685392, 0.99755596643379884636 },
	{ 0.99771631402429694635, 0.00086268583595720024337, 0.99755644731453618768 },
	{ 0.99771674844202151711, 0.00086251478493180953454, 0.99755691957405778769 },
	{ 0.99771719891962151738, 0.00086234232246843053014, 0.99755739248207786485 },
	{ 0.99771762694772825331, 0.00086216881096330363378, 0.99755785137108532457 },
	{ 0.99771809916910270122, 0.00086200359642472944906, 0.99755836303642952956 },
	{ 0.99771853404459087677, 0.00086183239281144806681, 0.99755883270195699897 },
	{ 0.99771901244577509971, 0.00086166466057267842096, 0.99755933483055814204 },
	{ 0.9977194367545518805, 0.00086149120628801058135, 0.99755979194573141111 },
	{ 0.99771989383157821951, 0.00086132450401750287276, 0.99756029083183983541 },
	{ 0.99772035474237519281, 0.0008611554938551493248, 0.99756077848366475624 },
	{ 0.99772079495843957186, 0.00086098322212663366219, 0.99756124525002221048 },
	{ 0.9977212458175092058, 0.0008608158713575905915, 0.9975617348664161943 },
	{ 0.99772169625696227602, 0.00086064375221696549391, 0.99756220483711932623 },
	{ 0.99772213859018354931, 0.0008604753142592018629, 0.99756268474510889632 },
	{ 0.99772258386072176783, 0.00086030329048600849041, 0.99756315618447055638 },
	{ 0.99772303479608537291, 0.00086013578712907485472, 0.99756364435127964363 },
	{ 0.99772347337182987204, 0.000859965155720383281, 0.99756411527565702624 },
	{ 0.99772391313013053527, 0.00085979334175553942185, 0.99756457944802046089 },
	{ 0.99772438058313350773, 0.00085962908089128162083, 0.99756508642128693953 },
	{ 0.99772485246118525204, 0.00085946008980241435284, 0.99756558179787380158 },
	{ 0.99772528596338239115, 0.00085929209053483613691, 0.99756605558327415828 },
	{ 0.99772571383890129582, 0.00085911865532365457726, 0.99756650512627353944 },
	{ 0.99772615539010967023, 0.0008589475661512913085, 0.99756697650841463787 },
	{ 0.99772662002023648764, 0.000858784754871994363, 0.99756748477867829283 },
	{ 0.99772705565866415256, 0.00085861309349504117729, 0.9975679445259927336 },
	{ 0.9977275315040009529, 0.00085844700157609594559, 0.99756844844750147683 },
	{ 0.99772795043405448911, 0.00085827495872941618471, 0.99756890003136378109 },
	{ 0.99772839370187660357, 0.00085810482323136940807, 0.99756937015465474428 },
	{ 0.99772883597787753729, 0.00085793812096086148264, 0.99756985286644672684 },
	{ 0.9977292851203335422, 0.00085776851952043184617, 0.99757032871178374922 },
	{ 0.99772973239358786479, 0.00085759971916642781155, 0.99757080673149811645 },
	{ 0.99773016004022474501, 0.00085742780983415233572, 0.99757125654152611904 },
	{ 0.99773062001642098817, 0.00085726202309098823405, 0.99757174825600380963 },
	{ 0.99773109740671017676, 0.00085709930717912301366, 0.9975722607033609135 },
	{ 0.99773150954660261291, 0.00085692825615373241326, 0.99757270885399573768 },
	{ 0.99773195441659767724, 0.00085675926506486525368, 0.99757318683556317485 },
	{ 0.99773241454538186268, 0.00085659347832170093517, 0.99757367763451343379 },
	{ 0.99773282073434654826, 0.00085641983330216964534, 0.99757411006859542102 },
	{ 0.99773329558786216786, 0.00085625503838029459573, 0.99757461910179856535 },
	{ 0.99773373879846383172, 0.00085609068214860528645, 0.99757509778908493026 },
	{ 0.99773419272836494365, 0.0008559237700697479561, 0.9975755835335612387 },
	{ 0.9977346190398578285, 0.00085575243294206239722, 0.99757603731087463039 },
	{ 0.9977350687354449299, 0.00085558567345109563188, 0.99757651912621270185 },
	{ 0.99773552459176795271, 0.00085541958153215018335, 0.99757700336388355211 },
	{ 0.9977359651130081053, 0.00085525005638566577518, 0.99757747043541677989 },
	{ 0.99773639010843029329, 0.00085508293449845871464, 0.99757793395928151536 },
	{ 0.99773682927545292998, 0.00085491430580583174185, 0.99757840318611878949 },
	{ 0.9977373009055491293, 0.00085474937736955229877, 0.99757890174797769767 },
	{ 0.99773770902093594781, 0.00085457960426774549206, 0.99757934816292503921 },
	{ 0.99773816136773740837, 0.00085441229164567519816, 0.99757982446602555537 },
	{ 0.99773861249383588579, 0.00085424558937516727273, 0.99758030336312031316 },
	{ 0.99773905911859162021, 0.00085407972633805783434, 0.99758078447273934586 },
	{ 0.99773948838647474879, 0.00085390909492936658588, 0.99758123418740007882 },
	{ 0.99773992997583016429, 0.00085374582588639783692, 0.99758172033241954146 },
	{ 0.99774036172326652228, 0.00085357546150651505013, 0.99758217908791257944 },
	{ 0.99774081727441377154, 0.00085341333687272591824, 0.99758266897133529572 },
	{ 0.9977412442534787651, 0.00085324194252458130262, 0.99758312028816886752 },
	{ 0.99774169709619098256, 0.00085307886421647567861, 0.99758361158302977234 },
	{ 0.9977421343367913753, 0.00085291078865495223438, 0.99758407812050542418 },
	{ 0.99774256967004315566, 0.00085274675667253044351, 0.99758455099037834923 },
	{ 0.99774302545007231835, 0.00085257967293229594292, 0.9975850299637667451 },
	{ 0.99774347794946183221, 0.00085241495430436601318, 0.99758551771095904659 },
	{ 0.99774390130456436232, 0.00085224367439713940263, 0.99758595968178431779 },
	{ 0.99774434106286502555, 0.00085207979500260817678, 0.99758643667153046319 },
	{ 0.99774474687036007747, 0.00085190912544694425996, 0.99758687284401570405 },
	{ 0.99774520726617277333, 0.00085174894630876056383, 0.9975873764984956038 },
	{ 0.99774563153680240202, 0.00085157614052262776104, 0.99758781602791446463 },
	{ 0.99774609212334997022, 0.0008514143210646198676, 0.99758831125191349543 },
	{ 0.99774655290063252178, 0.00085125353157487358615, 0.9975888100235809075 },
	{ 0.99774697217400865057, 0.00085108541786637736514, 0.99758925928047781362 },
	{ 0.99774741719659143513, 0.0008509185630079788747, 0.99758972963265057921 },
	{ 0.99774784331734933662, 0.00085075321495500029652, 0.99759019367149925905 },
	{ 0.99774828870232845635, 0.0008505837470289749451, 0.99759065534523572172 },
	{ 0.99774872695382377241, 0.00085042225182023467849, 0.99759113727501469437 },
	{ 0.99774916287835369033, 0.00085025686562028343195, 0.99759160604408814166 },
	{ 0.99774958430703408752, 0.00085008575737443377481, 0.99759204318932115374 },
	{ 0.99775004039223902375, 0.0008499253875013868453, 0.99759253803185032883 },
	{ 0.99775048533852794819, 0.00084975876152482425659, 0.99759300861290500784 },
	{ 0.99775091628487799778, 0.00084959286034074225826, 0.99759347167900591646 },
	{ 0.99775134459908687568, 0.00084942730247941405832, 0.99759393630913273388 },
	{ 0.99775179995949947465, 0.00084926452934708967276, 0.99759441883018984409 },
	{ 0.99775220706399159187, 0.00084909302055802705206, 0.99759484424522892887 },
	{ 0.99775267016823954158, 0.00084893600761857385389, 0.99759535434654722508 },
	{ 0.99775308293755704536, 0.00084876661598649383918, 0.99759579431465639221 },
	{ 0.99775354592736409387, 0.00084860483467545850568, 0.9975962866013385888 },
	{ 0.9977539467376056459, 0.00084843450844254838725, 0.99759671861580390129 },
	{ 0.99775440162118100851, 0.00084827503502335900153, 0.99759721141747015327 },
	{ 0.99775482821877614636, 0.00084810524284806591486, 0.99759765273979672529 },
	{ 0.99775526126320968068, 0.00084794319450822211968, 0.99759812606743347718 },
	{ 0.99775571650918126743, 0.00084778061211076107592, 0.99759861167839536389 },
	{ 0.99775615649636373305, 0.00084761360466447191204, 0.99759907607964060094 },
	{ 0.99775658795769794907, 0.0008474501258131534329, 0.99759954027107744512 },
	{ 0.99775701651986214991, 0.00084728576958146390678, 0.99759999999931847636 },
	{ 0.99775743171151254352, 0.00084711746513810445239, 0.9976004399102071929 },
	{ 0.99775788827355460509, 0.0008469548255201844603, 0.99760092683723966545 },
	{ 0.99775830964501455167, 0.00084679102241959835432, 0.99760138498238126736 },
	{ 0.99775875367577615549, 0.00084663202583756694362, 0.99760186990669774687 },
	{ 0.99775919143136071465, 0.00084646164238419766002, 0.9976023175804954457 },
	{ 0.99775960217888870485, 0.00084629591286149261509, 0.99760275957039412642 },
	{ 0.99776004634316473041, 0.0008461342269178890067, 0.99760323966911845783 },
	{ 0.99776050616677303129, 0.00084597439110245921737, 0.99760373153618386866 },
	{ 0.99776092517312076069, 0.0008458099013563654062, 0.99760418472221901176 },
	{ 0.99776136500771539506, 0.000845644724964763673, 0.9976046448510031972 },
	{ 0.99776178897316958327, 0.000845480616688396437, 0.9976051036064963462 },
	{ 0.99776223151619936047, 0.00084531738579240013956, 0.99760557475975553121 },
	{ 0.99776265857155843619, 0.00084515339195695090863, 0.99760603561333227596 },
	{ 0.99776310325081862818, 0.00084499351799454845095, 0.99760651393822252775 },
	{ 0.99776350490029364071, 0.00084482281029191175735, 0.99760693298271718721 },
	{ 0.99776395734246270397, 0.00084466444313492932035, 0.99760742544106073559 },
	{ 0.99776437829430586479, 0.00084450052559342531772, 0.99760788270882194695 },
	{ 0.99776480443413750887, 0.00084433454811539798267, 0.99760832982948843828 },
	{ 0.99776522584374438551, 0.00084416864693131576751, 0.99760877809456405263 },
	{ 0.99776565127785676879, 0.00084400551140275119517, 0.99760923541954582561 },
	{ 0.99776611512597079834, 0.00084384832680192115202, 0.99760973562172483575 },
	{ 0.99776654574807166487, 0.00084368377983536828411, 0.99761019237450199171 },
	{ 0.99776696345742221794, 0.00084352211296525095568, 0.99761064777306152074 },
	{ 0.99776740634377469874, 0.00084335953056778991191, 0.99761111598900398256 },
	{ 0.99776781028206817936, 0.00084319347679581724015, 0.99761155471733653499 },
	{ 0.99776824077065462415, 0.00084302933037247722737, 0.99761200969627927826 },
	{ 0.99776868819649666698, 0.0008428696089979653347, 0.99761248802116930801 },
	{ 0.99776913669045419475, 0.00084271126091446917766, 0.99761297359398437568 },
	{ 0.99776956456597298839, 0.00084254759132828757357, 0.99761342649391726578 },
	{ 0.99776997632439579089, 0.0008423799735304359328, 0.99761386022499642934 },
	{ 0.99777039378579102102, 0.00084221687614884402882, 0.99761431251457777236 },
	{ 0.99777084514077141186, 0.00084205665886368777275, 0.99761479194572999507 },
	{ 0.9977712716239255375, 0.00084189567863907825793, 0.99761524986198968357 },
	{ 0.997771682237939328, 0.00084173042595353118802, 0.99761569435051511423 },
	{ 0.99777212245400359603, 0.00084157127678360910388, 0.99761616661003660322 },
	{ 0.99777256356652188618, 0.0008414106971022124442, 0.99761663774422237871 },
	{ 0.99777297704155853975, 0.00084124548256363815106, 0.99761707639626096 },
	{ 0.99777341029580035592, 0.00084108604729142132529, 0.99761754970482408034 },
	{ 0.99777385127480433535, 0.0008409233886000149448, 0.99761801204613276273 },
	{ 0.99777425498421590255, 0.00084075733482804227304, 0.99761844291618884117 },
	{ 0.99777469924385930877, 0.00084059887230362811093, 0.9976189199822288467 },
	{ 0.99777512689049630001, 0.00084043699562516126916, 0.99761937471321637805 },
	{ 0.99777554513390454005, 0.00084027448952164556211, 0.99761982530525739055 },
	{ 0.99777597590859312682, 0.00084011127769913576148, 0.99762028060844953892 },
	{ 0.99777641360695723538, 0.00083995235741104979591, 0.99762075141838613135 },
	{ 0.99777684541161404397, 0.00083979162514176257121, 0.997621216449056325 },
	{ 0.99777725572045194991, 0.0008396257621046530244, 0.9976216481201989339 },
	{ 0.99777767716820575661, 0.00083946493446793418302, 0.99762210252693739321 },
	{ 0.99777810271675926312, 0.00083930248558487753271, 0.99762255184105486094 },
	{ 0.99777853743965960742, 0.00083914364159073690386, 0.99762302410057634994 },
	{ 0.99777895118172499345, 0.00083897968590226012445, 0.99762346561363790531 },
	{ 0.99777937465126831373, 0.00083881920158829518987, 0.9976239190667018919 },
	{ 0.99777979464943722387, 0.00083865783989395920831, 0.99762437431267370069 },
	{ 0.99778023246224234466, 0.00083849727928604893702, 0.99762483531883816568 },
	{ 0.99778068000252551073, 0.00083833874046768943819, 0.99762531215599647982 },
	{ 0.99778110091622163047, 0.00083817936241593166916, 0.99762577014855002844 },
	{ 0.99778150889809413826, 0.00083801536858048232981, 0.99762620567253690318 },
	{ 0.99778194203789505323, 0.00083785761177506226129, 0.9976266726105555982 },
	{ 0.99778239871437812702, 0.00083770000755753286619, 0.99762715652397715438 },
	{ 0.99778278144295484697, 0.00083752983391251320435, 0.99762755863121577171 },
	{ 0.99778323111946842783, 0.00083737434685196630683, 0.99762804004601068897 },
	{ 0.99778364318306689285, 0.00083721481621231786437, 0.99762849056175784135 },
	{ 0.99778406878884084996, 0.00083705089867081375332, 0.99762893592766366258 },
	{ 0.99778452151711227724, 0.00083689571678604809425, 0.99762942283562272561 },
	{ 0.9977849408477091897, 0.000836736701130530512, 0.99762987806252090284 },
	{ 0.99778534696038001517, 0.00083657457649674127169, 0.99763031515053357534 },
	{ 0.99778576711113686759, 0.00083641123115982718601, 0.99763076108864379155 },
	{ 0.99778617560799331976, 0.00083624924004044244759, 0.9976311954491479117 },
	{ 0.99778659896309573885, 0.00083609123527970019736, 0.9976316531365257978 },
	{ 0.99778703887398434436, 0.00083593422234024699919, 0.99763212722710192804 },
	{ 0.99778747191841787867, 0.0008357703429457155565, 0.99763257247856673704 },
	{ 0.99778789925987898535, 0.00083561273872818626982, 0.99763303651741541689 },
	{ 0.99778830443794885863, 0.00083545357048477812256, 0.9976334780114033407 },
	{ 0.99778872125084561162, 0.00083529276192154556114, 0.99763392515114324155 },
	{ 0.99778913991387030435, 0.00083513044655289308746, 0.99763436632088187128 },
	{ 0.99778956849510791471, 0.00083497095406021731336, 0.9976348237412309139 },
	{ 0.9977899907820950709, 0.00083481050789322515555, 0.99763527181557176693 },
	{ 0.99779043309624293467, 0.00083465643227066666204, 0.99763575212410449122 },
	{ 0.99779084012444108076, 0.00083449629127945563426, 0.99763619440010542494 },
	{ 0.9977912572997340579, 0.00083433363258804925378, 0.99763663415840619919 },
	{ 0.99779168618614744179, 0.00083417475044693606499, 0.99763708906105508234 },
	{ 0.9977920847457174558, 0.00083401422798599835363, 0.99763752180031295413 },
	{ 0.99779251332695506616, 0.00083385443031754123266, 0.99763797594002234792 },
	{ 0.99779295295174141867, 0.00083369991600479710723, 0.99763845107964022052 },
	{ 0.99779334983284495575, 0.00083353618919815633797, 0.99763887267998208053 },
	{ 0.99779376891548632322, 0.00083337833702530465275, 0.99763932426384438479 },
	{ 0.99779420844490507303, 0.00083322063744034364097, 0.99763979293755045141 },
	{ 0.99779461865837537626, 0.00083305853188004078905, 0.99764022558144083153 },
	{ 0.99779504743034785896, 0.00083290075600113454898, 0.99764068242958525712 },
	{ 0.99779549157555025296, 0.00083274629890884926346, 0.99764116220406029445 },
	{ 0.99779589539940283238, 0.00083258478462662260846, 0.99764159318855738512 },
	{ 0.99779631047661221377, 0.00083242811500992342551, 0.99764204725197291879 },
	{ 0.99779671889717491684, 0.00083226681053604639228, 0.99764247772148595406 },
	{ 0.99779714019234078126, 0.0008321064406629995712, 0.99764292251518704724 },
	{ 0.99779756726677315548, 0.00083195047676529448183, 0.99764338533333285497 },
	{ 0.99779797780449264177, 0.00083179094612564603937, 0.99764382623604275224 },
	{ 0.99779838147575727891, 0.00083162988960709129625, 0.99764425676277601607 },
	{ 0.99779883151466697289, 0.0008314772063490346015, 0.99764473804405662261 },
	{ 0.99779924384529428139, 0.00083131809532608540256, 0.99764518119743794689 },
	{ 0.99779964486534433732, 0.00083115572273697398056, 0.99764560720375494718 },
	{ 0.99780007691795646885, 0.00083100046455826298477, 0.99764607343605482548 },
	{ 0.99780047494346901793, 0.00083083895027603632977, 0.99764649236610847272 },
	{ 0.99780090783531438792, 0.0008306837683912706707, 0.99764695943764158947 },
	{ 0.9978013198035455833, 0.00083052555382217879872, 0.99764740379265270942 },
	{ 0.9978017502158378349, 0.00083037063896622181815, 0.99764786777428116071 },
	{ 0.99780216994697790156, 0.00083021351158585061491, 0.99764831748894178265 },
	{ 0.99780258391792520101, 0.00083005161583389738475, 0.99764874671867820322 },
	{ 0.99780299447471831886, 0.00082989549934830162195, 0.99764919633797133347 },
	{ 0.99780342511589259491, 0.00082973776161636794181, 0.99764964910438969081 },
	{ 0.99780382169182013641, 0.0008295780020948834892, 0.99765007833412588933 },
	{ 0.99780425986702137031, 0.00082942303001846734347, 0.99765054153374144175 },
	{ 0.99780467513496562404, 0.00082926700890030319736, 0.99765099510124632953 },
	{ 0.9978050633376328582, 0.000829104750752109672, 0.99765140737465329845 },
	{ 0.99780547576362743634, 0.00082894554436172863954, 0.9976518453972667011 },
	{ 0.99780589757377746718, 0.00082879106819595718247, 0.99765230184486786147 },
	{ 0.99780631867820845926, 0.0008286331015821876006, 0.99765274949959181772 },
	{ 0.99780675019676301485, 0.00082847746193375013807, 0.99765320421150593955 },
	{ 0.99780714887077415209, 0.0008283194190260353279, 0.9976536370652044905 },
	{ 0.99780757260734620484, 0.00082816301643814471505, 0.99765408826759693905 },
	{ 0.99780797780448948764, 0.00082800257027115255724, 0.99765451543739658291 },
	{ 0.99780841557914745632, 0.00082784830391373072193, 0.99765498342445702029 },
	{ 0.99780881659919729021, 0.00082768944084610381311, 0.99765541438988059042 },
	{ 0.99780922603065447252, 0.00082753582298721701464, 0.99765586357048352539 },
	{ 0.99780965163642820759, 0.00082737778007950209605, 0.9976563102333863009 },
	{ 0.99781007289344703093, 0.00082722141563858425997, 0.99765675826958011285 },
	{ 0.99781049457008252901, 0.00082706920921768586549, 0.99765721610954583021 },
	{ 0.99781089265281552869, 0.00082690801918472694575, 0.99765764264992051746 },
	{ 0.99781129903251519764, 0.00082675173103775433797, 0.99765807741096779182 },
	{ 0.99781171262199264138, 0.00082659616768326221216, 0.9976585219757870826 },
	{ 0.99781213590080097831, 0.00082644083321060598808, 0.99765897516182211469 },
	{ 0.99781254367286498219, 0.00082628032982315477353, 0.99765940257957730353 },
	{ 0.99781297450477390854, 0.00082612690269913120842, 0.99765986255577354669 },
	{ 0.9978133723014045442, 0.00082596866905655294804, 0.9976602945320918181 },
	{ 0.99781379092628230687, 0.00082581417381729499416, 0.99766074077537791887 },
	{ 0.99781421105796552773, 0.00082565874397720715339, 0.99766119035652411906 },
	{ 0.99781462396079734223, 0.00082550340950455082089, 0.99766163194587942353 },
	{ 0.9978150429289978085, 0.00082534941017593755567, 0.99766208387306432037 },
	{ 0.99781544534141219938, 0.00082519106209244139864, 0.99766251214912626821 },
	{ 0.99781584609443330081, 0.00082503486931290029912, 0.99766294628074858597 },
	{ 0.99781624709540961415, 0.00082487922966446272817, 0.99766338390281883441 },
	{ 0.9978166721289787322, 0.00082472336113418925549, 0.99766383090904442454 },
	{ 0.99781707494193627728, 0.00082456598579849587054, 0.99766425947120862538 },
	{ 0.9978175059836535965, 0.00082441185295547821186, 0.99766471877983287087 },
	{ 0.99781790065223241459, 0.0008242549163099703504, 0.99766514244011117452 },
	{ 0.99781830329352849684, 0.00082409908592666954608, 0.99766557643821907053 },
	{ 0.99781874000007142467, 0.00082394558250870075268, 0.99766603694847288963 },
	{ 0.99781916131431058758, 0.00082378946602310498988, 0.99766648210457020696 },
	{ 0.99781954186850962962, 0.00082363107979263627291, 0.99766689317634749123 },
	{ 0.99781997695380608704, 0.00082348030388321245398, 0.9976673632424178928 },
	{ 0.99782037888938324155, 0.00082332166969742133847, 0.99766778482368612124 },
	{ 0.99782079827720038256, 0.00082317312538589791377, 0.99766825059822206168 },
	{ 0.99782120316916811387, 0.00082301466286148364324, 0.99766867563179129075 },
	{ 0.99782161353522624836, 0.00082285972893204016587, 0.9976691148369608575 },
	{ 0.9978220247023709133, 0.00082270380318130774486, 0.99766955514839261721 },
	{ 0.9978224162810449549, 0.00082254476845230377422, 0.99766996457985002156 },
	{ 0.99782283713752051302, 0.00082239445030655186717, 0.99767042598655775176 },
	{ 0.9978232442229391097, 0.00082223703682388581387, 0.99767085458686899369 },
	{ 0.99782366357260943168, 0.00082208219826187395318, 0.99767129995277470389 },
	{ 0.99782407538825268478, 0.00082193031609024318554, 0.99767174770286637386 },
	{ 0.99782448235923038027, 0.00082177404701675696615, 0.99767217771461547127 },
	{ 0.99782486535483583268, 0.00082161627113785083449, 0.99767259611061154256 },
	{ 0.99782529138022635351, 0.00082146612465347577242, 0.99767305143287710045 },
	{ 0.99782571069174963441, 0.00082131170570816326368, 0.9976734975998693411 },
	{ 0.9978260942977066339, 0.00082115331947769454671, 0.99767390745094364224 },
	{ 0.99782650952750373552, 0.00082099802315201099098, 0.99767434343269401076 },
	{ 0.99782691384726673878, 0.00082084387123550716075, 0.99767477567604123667 },
	{ 0.9978273431914438385, 0.00082069406807388611391, 0.99767524133613649795 },
	{ 0.99782774991446610002, 0.00082054018318619063692, 0.99767568010261598044 },
	{ 0.99782816575461485975, 0.00082038770973648367235, 0.99767612478187628344 },
	{ 0.9978285508101567558, 0.00082023031532730400744, 0.99767653715065063302 },
	{ 0.99782893821173745952, 0.0008200737029310636644, 0.99767695175102277805 },
	{ 0.99782934834891379161, 0.00081991880714859285539, 0.99767738595893895592 },
	{ 0.99782977057868038617, 0.00081976639091934473073, 0.99767783416679411967 },
	{ 0.99783015633994120996, 0.00081961347877945202583, 0.99767826349189803192 },
	{ 0.99783060048514360396, 0.00081946169197525276645, 0.99767872777870225676 },
	{ 0.99783099408560715915, 0.00081930857002701054821, 0.99767915265968354355 },
	{ 0.99783142964774074191, 0.00081915712654556530406, 0.99767961492469803275 },
	{ 0.9978318159621327732, 0.00081900083839859269628, 0.99768002756050122581 },
	{ 0.99783221421652712468, 0.00081884489357437388688, 0.99768045450141928931 },
	{ 0.99783261037283799144, 0.00081868990242447135276, 0.99768087522438053671 },
	{ 0.99783303292685376906, 0.00081854101479019402126, 0.99768133424690264022 },
	{ 0.99783344106131410811, 0.00081838548958267434696, 0.99768175962379479493 },
	{ 0.99783382695608946467, 0.00081822939217056508097, 0.99768217725685159891 },
	{ 0.99783425668173630907, 0.00081808142006363157323, 0.99768264108589210792 },
	{ 0.99783467675619907933, 0.00081793081581558459928, 0.99768309106758168436 },
	{ 0.99783503556662378475, 0.00081777052223648289807, 0.99768347551277192231 },
	{ 0.9978354687636450393, 0.00081762052833999850944, 0.99768393434455893143 },
	{ 0.99783585969382071479, 0.00081746702492202982446, 0.9976843582337191485 },
	{ 0.99783625626974825629, 0.00081731001198257673471, 0.99768477189949067441 },
	{ 0.99783667539053666484, 0.00081716127693618996822, 0.99768523046424884004 },
	{ 0.99783707276755062576, 0.00081700521767105326217, 0.99768564668586734445 },
	{ 0.99783745805197421319, 0.0008168500357862876031, 0.99768605943611143871 },
	{ 0.99783788083487190423, 0.00081670213997329932365, 0.99768651861122126245 },
	{ 0.99783827281408932208, 0.00081654743492569196485, 0.99768693931510921136 },
	{ 0.9978386757033408383, 0.00081639574348892443058, 0.99768736951759329212 },
	{ 0.99783908139639476698, 0.00081624464333023298481, 0.99768781076362600402 },
	{ 0.99783949124746884607, 0.0008160899192091391292, 0.99768824258735633315 },
	{ 0.99783988706045712025, 0.0008159358054396078589, 0.99768865976264908824 },
	{ 0.99784032151632862107, 0.00081579134285415864751, 0.99768913785865731558 },
	{ 0.9978407145445878923, 0.00081563680946792813369, 0.99768955354621835507 },
	{ 0.99784111295157018606, 0.00081548132240738123618, 0.99768997301032946723 },
	{ 0.99784151791983211055, 0.00081533148109878752097, 0.99769041337898178856 },
	{ 0.99784193234854312582, 0.00081518072426284998201, 0.99769085710456772986 },
	{ 0.99784230916433902525, 0.00081502622902359202813, 0.99769126321723844431 },
	{ 0.99784272069388013637, 0.00081487165749038884596, 0.9976916900055684545 },
	{ 0.99784312623434634482, 0.00081472063362564262849, 0.99769212514808547354 },
	{ 0.99784351289206130176, 0.00081456774055923631198, 0.99769254415443309192 },
	{ 0.99784390298300362776, 0.00081441767036880658662, 0.9976929717819964516 },
	{ 0.99784432811194034851, 0.00081426605522598428065, 0.99769341541221501224 },
	{ 0.99784473742895696269, 0.00081411476433242960151, 0.99769385341575511639 },
	{ 0.99784512484961129797, 0.00081395958244766394244, 0.99769426158836249652 },
	{ 0.9978455190604267333, 0.0008138084441419997199, 0.99769469089439266618 },
	{ 0.99784594829016315387, 0.00081366150200332782415, 0.99769514850547658114 },
	{ 0.99784633166723835096, 0.00081350746452774189057, 0.9976955614846024778 },
	{ 0.99784675490789997987, 0.00081335773766006607202, 0.99769601135185093099 },
	{ 0.99784712729864710745, 0.00081320400536026148531, 0.99769641578605494647 },
	{ 0.99784751355581868815, 0.00081304895698990011128, 0.99769682161262351894 },
	{ 0.99784791789465532297, 0.00081290069878067164506, 0.99769726154258553397 },
	{ 0.99784832255774136289, 0.0008127499419447341061, 0.99769769794395268825 },
	{ 0.9978487198393881652, 0.00081259630501236102765, 0.9976981125443249443 },
	{ 0.99784914540701508123, 0.00081245027840103284725, 0.99769857442786979984 },
	{ 0.99784952964239714834, 0.00081229534447158958672, 0.99769897869041257454 },
	{ 0.9978499177878439319, 0.00081214172661270289666, 0.99769939124992190749 },
	{ 0.9978503411810935031, 0.00081199360191787871548, 0.99769984088828855828 },
	{ 0.99785073630743637008, 0.00081184139549698021258, 0.99770026485374263547 },
	{ 0.9978511158698143424, 0.00081168964683975372999, 0.99770067584922594861 },
	{ 0.99785153956823968713, 0.00081154251396621849245, 0.99770113044669905822 },
	{ 0.99785192489081053768, 0.00081139103233780057994, 0.99770154430320545647 },
	{ 0.99785231139593755234, 0.00081123981773819112909, 0.99770195980003162362 },
	{ 0.99785272700720473171, 0.00081109108269180425418, 0.99770240318229475029 },
	{ 0.9978531247275417293, 0.0008109376555677807975, 0.99770282165458479273 },
	{ 0.99785351970129676502, 0.00081078895866836669937, 0.99770325553825167653 },
	{ 0.9978539231055326697, 0.00081063900291885497909, 0.99770368198325909415 },
	{ 0.99785430190497126368, 0.00081048725426162838807, 0.99770408992698444983 },
	{ 0.99785472609930725429, 0.00081033893883194097352, 0.99770453853538276778 },
	{ 0.99785511191778875073, 0.00081018566429580808185, 0.9977049495308659699 },
	{ 0.9978555104773590978, 0.0008100361281629956051, 0.99770537860801433716 },
	{ 0.99785590667181722768, 0.00080988498985733138255, 0.99770579845359552706 },
	{ 0.99785627112799402116, 0.00080973232567276118461, 0.9977062005989812965 },
	{ 0.99785670516424895826, 0.00080958484947647214869, 0.99770665279319503682 },
	{ 0.99785710444861186463, 0.00080943725883926521611, 0.99770708984306055722 },
	{ 0.99785749595099215714, 0.00080928615868057387876, 0.99770750797202767401 },
	{ 0.9978578922598910772, 0.00080913543999160911658, 0.99770792808463759638 },
	{ 0.99785830214911241942, 0.00080898495018448014771, 0.99770835910728150608 },
	{ 0.99785867247992299234, 0.00080883282005752698152, 0.997708762091900625 },
	{ 0.99785908118658817045, 0.00080868427574600344841, 0.99770919475486452566 },
	{ 0.9978594779913977364, 0.00080853527367080800341, 0.99770961826255499805 },
	{ 0.99785986657553471524, 0.00080838457405532952119, 0.99771003675391856103 },
	{ 0.9978602557890967617, 0.00080823744118179439207, 0.99771046396186535699 },
	{ 0.99786066396170425286, 0.00080808805763687248033, 0.99771089288642589299 },
	{ 0.99786105321341322938, 0.00080793714821304437636, 0.99771131082465835949 },
	{ 0.99786146789007967861, 0.00080779114067520258434, 0.99771175411155399448 },
	{ 0.99786185876303501452, 0.0008076402121778882004, 0.9977121703140992004 },
	{ 0.99786226052695103927, 0.00080749357521499765152, 0.99771260259559324535 },
	{ 0.99786265588217581968, 0.0008073435813185133713, 0.99771302663734129368 },
	{ 0.99786302972250784382, 0.00080719007790054468632, 0.99771342489173575618 },
	{ 0.99786343362265428336, 0.00080704222023452907523, 0.99771385381629629219 },
	{ 0.99786383080893370501, 0.00080689558327163841793, 0.99771428548743879006 },
	{ 0.99786421018057680499, 0.00080674043953384542722, 0.99771468065192847607 },
	{ 0.99786461783819990767, 0.00080659664452041764104, 0.99771512714316989978 },
	{ 0.99786501248770531625, 0.0008064470893141187759, 0.99771554399421347181 },
	{ 0.99786537679129416745, 0.00080629579842056398834, 0.99771594385078066214 },
	{ 0.99786578792029201335, 0.00080614765465225341878, 0.99771637699058168813 },
	{ 0.99786617762976459467, 0.00080600086510147208804, 0.99771679843833549484 },
	{ 0.99786655270987323352, 0.0008058457785841382625, 0.99771719129493330325 },
	{ 0.99786696957999043711, 0.00080570356667007583373, 0.99771764600684742508 },
	{ 0.99786735261374304162, 0.00080555231392349382295, 0.99771805078437425518 },
	{ 0.99786774148398238449, 0.00080540041267837655849, 0.99771846025397881164 },
	{ 0.99786816623144936056, 0.00080525932610000724998, 0.99771892154624564064 },
	{ 0.99786853162222688418, 0.00080510462105239989118, 0.99771930608680348129 },
	{ 0.9978689208739358607, 0.00080495859444107181919, 0.99771973470618813273 },
	{ 0.99786930322104283597, 0.000804807723164216492, 0.99772014078071191712 },
	{ 0.99786970788412865385, 0.00080465818703140401524, 0.9977205613129384032 },
	{ 0.99787010091238792509, 0.00080451326668228289197, 0.99772099462440066997 },
	{ 0.99787052228384787167, 0.00080436792671646252517, 0.99772143690040160369 },
	{ 0.99787087159567644523, 0.00080421530067886477875, 0.99772181672980841949 },
	{ 0.997871270574863245, 0.00080406824409927487793, 0.99772224317481572609 },
	{ 0.99787169610434311995, 0.00080392523109878652205, 0.99772269868781615632 },
	{ 0.99787207156592150348, 0.00080377388298477289458, 0.99772309802939929124 },
	{ 0.99787246379309424427, 0.00080362732231582746558, 0.99772352199485336843 },
	{ 0.99787285769873379504, 0.00080347999870742888625, 0.99772394168784650503 },
	{ 0.99787322122030952531, 0.00080332876503433315544, 0.99772433275153649124 },
	{ 0.99787361752920844538, 0.00080318285286392287169, 0.99772476179053792844 },
	{ 0.997874022039706432, 0.00080303560554946984591, 0.99772518552711020323 },
	{ 0.99787440244131764278, 0.00080288347542251678815, 0.99772558637549890737 },
	{ 0.99787481786184983878, 0.00080273966133560272201, 0.99772603032996665107 },
	{ 0.99787520110541061413, 0.00080259266197647176951, 0.99772644599845417002 },
	{ 0.99787558320456237748, 0.000802445510029450252, 0.99772686036994462366 },
	{ 0.99787595235281667527, 0.00080229395210708700278, 0.99772725027015207733 },
	{ 0.9978763511412686027, 0.00080214891731704776601, 0.9977276821701763776 },
	{ 0.99787674855642982674, 0.00080200296699966503074, 0.99772810689856983313 },
	{ 0.99787715829306311566, 0.00080185552895034855475, 0.99772853563239549679 },
	{ 0.9978775298827237128, 0.00080170557320083694289, 0.99772892980506400207 },
	{ 0.99787792422705368089, 0.00080155964195694027075, 0.99772935710837817869 },
	{ 0.99787832034521772862, 0.00080141620933975267135, 0.99772978740622975113 },
	{ 0.99787869655066208097, 0.00080126507103408866565, 0.99773018207480879127 },
	{ 0.99787908191137986158, 0.00080111912071670571354, 0.99773059886863213475 },
	{ 0.99787947024756140646, 0.00080097309410537753313, 0.99773102016379799917 },
	{ 0.99787985999518091784, 0.00080082466423477211351, 0.99773143135001607362 },
	{ 0.99788024999075586319, 0.00080067903816665689665, 0.99773184980323259552 },
	{ 0.99788064156943012684, 0.00080053205788101233255, 0.9977322640412085164 },
	{ 0.99788104348593398285, 0.00080038526833023111023, 0.99773268915107160559 },
	{ 0.99788141299658450478, 0.00080023788750137379942, 0.99773309295585066447 },
	{ 0.9978818008940759654, 0.00080008867561782873266, 0.99773349832465563214 },
	{ 0.99788218083792357138, 0.00079994432747329741792, 0.99773391488959695117 },
	{ 0.99788258004599239559, 0.0007997991019483950562, 0.99773434179236786257 },
	{ 0.99788296479635862912, 0.00079965345680679345095, 0.99773475889136675754 },
	{ 0.99788335442953723931, 0.00079950430214370744094, 0.99773516378333437782 },
	{ 0.99788373509817729357, 0.0007993596106764222194, 0.99773558031012876679 },
	{ 0.99788413865500102951, 0.0007992133170362854689, 0.99773600309302667988 },
	{ 0.99788448056631706695, 0.00079906366646255498707, 0.99773637857367847293 },
	{ 0.99788489812307967775, 0.0007989190894361877706, 0.99773681978156414374 },
	{ 0.99788530185156476549, 0.00079877773582901000042, 0.9977372560112698352 },
	{ 0.99788567481451628804, 0.00079863014519180295942, 0.99773765674521752711 },
	{ 0.9978860544150410794, 0.00079848057091201781431, 0.99773805732657727674 },
	{ 0.9978864486449301463, 0.00079833849251235945374, 0.99773848390509889406 },
	{ 0.99788680690222364422, 0.00079818668663467402281, 0.99773886489798835342 },
	{ 0.99788719827108962601, 0.00079804296791519157336, 0.99773928434302616708 },
	{ 0.99788761269980053026, 0.00079790197670425398995, 0.99773972806861210838 },
	{ 0.99788799783163639745, 0.00079775488197769142077, 0.9977401388352135081 },
	{ 0.99788837748938163941, 0.0007976086455580136186, 0.99774054542472156992 },
	{ 0.99788877345495774485, 0.00079746445000137286888, 0.99774096946646950723 },
	{ 0.99788914145880291962, 0.00079731792747940010823, 0.99774136867453822042 },
	{ 0.9978895327704484508, 0.00079717289268936087146, 0.99774178485800979477 },
	{ 0.99788988273077550151, 0.00079702083885635315041, 0.99774215587546577488 },
	{ 0.99789032096319729703, 0.00079688289940322816832, 0.99774262340476260746 },
	{ 0.99789068854742579706, 0.0007967353469129939041, 0.99774302181174501225 },
	{ 0.99789106967382978919, 0.00079658867180313057844, 0.99774342224051715267 },
	{ 0.99789142520361484578, 0.00079644371330703667838, 0.99774382049491161517 },
	{ 0.9978918445151382377, 0.0007963027220960992034, 0.99774426055838816296 },
	{ 0.997892230829530269, 0.00079615505516494682568, 0.99774466709067555215 },
	{ 0.99789259612494041196, 0.00079600582420791558737, 0.99774505008628100455 },
	{ 0.99789297648840469268, 0.00079586273491348189478, 0.99774546653678142238 },
	{ 0.99789338769369617665, 0.00079572363197769090722, 0.99774591123511502389 },
	{ 0.99789375935965074493, 0.00079557359993423385023, 0.99774630311896506107 },
	{ 0.9978941657393505249, 0.00079543257057632359847, 0.99774673864295182479 },
	{ 0.99789452132635636517, 0.00079528560936416531433, 0.99774712150504285546 },
	{ 0.9978948672431043887, 0.00079513195335830584749, 0.99774748359610732074 },
	{ 0.99789528544836558765, 0.00079499237358535666809, 0.99774792789389765701 },
	{ 0.99789566405706919827, 0.00079484699547256363293, 0.9977483350365367043 },
	{ 0.99789604690008681942, 0.00079470432579482918386, 0.99774875175406607664 },
	{ 0.99789640901022480524, 0.00079455568611587414247, 0.99774913495947992192 },
	{ 0.99789681542807140424, 0.00079441339790786637699, 0.9977495621292796768 },
	{ 0.99789719914846941595, 0.00079427191078628421334, 0.99774998384406243801 },
	{ 0.99789758542471440617, 0.00079412901222671375412, 0.99775040033270989692 },
	{ 0.99789794461660896729, 0.00079397917091812003892, 0.9977507772247997675 },
	{ 0.99789833112173587093, 0.00079383344948257309696, 0.99775118692328601533 },
	{ 0.99789873433523679225, 0.00079369680702651818852, 0.99775162965705066487 },
	{ 0.99789907262259036624, 0.00079354437172378367547, 0.99775198656012686893 },
	{ 0.99789949319296389341, 0.00079340547859634220126, 0.99775243871619356817 },
	{ 0.99789986516409434625, 0.00079326002418960382939, 0.99775283571173811747 },
	{ 0.99790025861197029222, 0.00079311941444839271272, 0.99775325601508280116 },
	{ 0.99790061738424795656, 0.00079297251045669348533, 0.99775364698340551772 },
	{ 0.99790100276403936874, 0.00079282642662490613976, 0.99775404773642673018 },
	{ 0.99790139346533324183, 0.00079268398582900770084, 0.997754466971656373 },
	{ 0.99790176825933962768, 0.00079254150688613648514, 0.99775487380911986879 },
	{ 0.99790213036947761349, 0.00079239660561050164183, 0.99775526746680420764 },
	{ 0.99790254064016858937, 0.00079225313484634126565, 0.99775569177558098843 },
	{ 0.99790294774466081762, 0.00079211458504165369824, 0.99775613061835444206 },
	{ 0.99790328353338753065, 0.00079196445763076502456, 0.99775649303366820142 },
	{ 0.99790367698126358764, 0.00079182339012588210444, 0.99775691394736443218 },
	{ 0.99790405734472797938, 0.00079168014824355773841, 0.99775731979300652519 },
	{ 0.99790442798071432584, 0.00079153808891738587465, 0.99775773071219608923 },
	{ 0.9979048018973402101, 0.00079139244377578437783, 0.9977581226341931675 },
	{ 0.99790518760138080534, 0.00079124851524795230661, 0.99775853115012347327 },
	{ 0.99790554763250871595, 0.00079110409080947554673, 0.99775892154624168384 },
	{ 0.99790595908575574491, 0.00079096393883193655879, 0.99775935619284816802 },
	{ 0.99790632832937753438, 0.00079081754982436808319, 0.99775974424292768195 },
	{ 0.99790670491629163141, 0.00079067777931655556199, 0.99776016111304488554 },
	{ 0.99790707265310807372, 0.00079052854835952432368, 0.9977605422775956967 },
	{ 0.99790746728354029482, 0.00079039163887466095358, 0.99776097467353075388 },
	{ 0.99790782407217570871, 0.00079024687111343039532, 0.99776135900428042369 },
	{ 0.99790822982245042105, 0.00079010647118056900884, 0.99776178878714794074 },
	{ 0.99790860999517994046, 0.00078996067345107683858, 0.99776218666007288061 },
	{ 0.99790897769384923066, 0.00078981750786269770085, 0.99776258449485077939 },
	{ 0.99790934754782256721, 0.00078967520058120333013, 0.99776298433234467122 },
	{ 0.99790972810202194232, 0.00078953329384292203139, 0.99776339662482527171 },
	{ 0.99791012322836492032, 0.0007893923789259297847, 0.99776381204535746772 },
	{ 0.9979104689925251126, 0.00078924558937514856238, 0.99776418710639258602 },
	{ 0.9979108807509479151, 0.00078910543739760957444, 0.99776461717536224505 },
	{ 0.99791125977926820045, 0.00078896322548354703725, 0.99776502305915126811 },
	{ 0.99791160531454647931, 0.00078881483375991417756, 0.99776539133002528636 },
	{ 0.99791199481421077877, 0.00078867576897109585837, 0.997765809630653977 },
	{ 0.99791237319403258699, 0.00078853344261611542452, 0.99776621593405967481 },
	{ 0.99791274030142396168, 0.00078839151680434773738, 0.99776661340644123843 },
	{ 0.99791311795645332161, 0.00078824732124770698766, 0.99776700845649013427 },
	{ 0.99791353421621897812, 0.00078811182320083202155, 0.99776746133734961486 },
	{ 0.99791385253363229513, 0.00078796207725966981462, 0.99776780342032689308 },
	{ 0.99791425582342718759, 0.00078782184898818527312, 0.99776822532584463765 },
	{ 0.99791461043768503458, 0.00078767841637099778214, 0.99776861289908680419 },
	{ 0.997914995683961914, 0.00078753738701308753038, 0.99776902301718983779 },
	{ 0.99791537497931104284, 0.00078739681541884929891, 0.99776943237235349304 },
	{ 0.99791574384146319865, 0.00078725347816909353304, 0.99776982419898319066 },
	{ 0.9979161123412190193, 0.00078711050331557784552, 0.99777021985938363358 },
	{ 0.99791650643759355344, 0.00078697336494887857369, 0.99777064630439116222 },
	{ 0.99791688083105656304, 0.00078682922661269677229, 0.99777104106833780506 },
	{ 0.99791724925451841255, 0.0007866878539320325053, 0.99777143726279582392 },
	{ 0.99791762778692816305, 0.00078654522240127061616, 0.99777183906485877873 },
	{ 0.99791799481802567762, 0.00078640219032729608874, 0.99777222982337332446 },
	{ 0.99791838096075646813, 0.00078626461327041129341, 0.99777265201499309999 },
	{ 0.99791875049048073265, 0.0007861187773939464548, 0.99777303291251506767 },
	{ 0.99791913306646951032, 0.00078598163902724718297, 0.99777345439841602648 },
	{ 0.99791950360708847612, 0.00078583917915786235565, 0.99777384817054126653 },
	{ 0.99791988374167106546, 0.00078569776833022563715, 0.99777425210883474715 },
	{ 0.99792025361471792255, 0.00078555738747085053063, 0.99777465372016282963 },
	{ 0.99792060021811146431, 0.0007854100638624519513, 0.99777502092292147395 },
	{ 0.9979209850638450785, 0.00078527160942519600058, 0.99777543182303729541 },
	{ 0.99792135875158916036, 0.00078513077080214909061, 0.99777583572318373495 },
	{ 0.99792173285895013901, 0.00078499027550185608744, 0.99777623584677987978 },
	{ 0.99792212544851910394, 0.0007848529654737798622, 0.99777665727546027696 },
	{ 0.99792249505453711755, 0.0007847077399488776089, 0.99777704137732792233 },
	{ 0.99792284158163679919, 0.00078456323921645562073, 0.99777741201331415777 },
	{ 0.99792324483328465057, 0.00078442968666518598196, 0.99777785806586527517 },
	{ 0.99792360509329425255, 0.00078428396522963904, 0.99777822992255460477 },
	{ 0.99792397689276346462, 0.00078414387047255900039, 0.99777863120963339316 },
	{ 0.99792436015539787153, 0.00078400474846328173286, 0.997779040335915135 },
	{ 0.99792470838003777267, 0.00078385862648452182735, 0.99777940797736408562 },
	{ 0.99792510234289788507, 0.00078372127830947282533, 0.99777982692649136442 },
	{ 0.9979254539816919678, 0.00078358066856826170867, 0.99778021167685759796 },
	{ 0.9979258397048061946, 0.0007834400779005369804, 0.99778062097480069159 },
	{ 0.9979262054198330123, 0.00078330400764907220576, 0.99778102964331882863 },
	{ 0.99792656333380402867, 0.00078315594017470697291, 0.99778139450003877631 },
	{ 0.99792695456915547769, 0.0007830210524793944837, 0.99778182357718714357 },
	{ 0.99792730063849133249, 0.00078287273704970685231, 0.99778218307425725619 },
	{ 0.99792768958502431342, 0.00078273769676650368967, 0.99778260192801693229 },
	{ 0.99792807120733872939, 0.00078260052025283174948, 0.9977830171196673259 },
	{ 0.99792842549734717128, 0.00078245619118178693155, 0.99778339143683658641 },
	{ 0.99792881575995084908, 0.0007823187285658201413, 0.99778380741049998992 },
	{ 0.99792917493277177865, 0.00078217653572524388408, 0.99778418947150449014 },
	{ 0.99792955670767391485, 0.00078203829109633755511, 0.99778459993293022734 },
	{ 0.99792990901403988424, 0.0007818962508436518629, 0.99778497615744787819 },
	{ 0.9979302740805682248, 0.00078175915062392536785, 0.99778538196494304113 },
	{ 0.99793063998632980383, 0.00078161663353408159221, 0.9977857655708999296 },
	{ 0.99793102420263823937, 0.00078147777855361267793, 0.99778617359091936745 },
	{ 0.99793140826635884366, 0.00078134029686415960771, 0.9977865832894057263 },
	{ 0.99793177911215347198, 0.00078120222389663023215, 0.99778698827674083827 },
	{ 0.997932128691010778, 0.00078105833351577082929, 0.99778735708167243246 },
	{ 0.99793250152044798984, 0.00078091865837538992478, 0.99778775588919788042 },
	{ 0.99793289786749383996, 0.00078078232109511636321, 0.99778817481925163868 },
	{ 0.99793322337561152224, 0.00078063846886122952029, 0.99778853145529899926 },
	{ 0.99793361352377418783, 0.00078050039589370025315, 0.9977889409821238953 },
	{ 0.99793398969107138807, 0.00078036310493911030788, 0.99778935048987515977 },
	{ 0.99793436280661085291, 0.00078022375404799692179, 0.99778974603583447944 },
	{ 0.99793472484045475657, 0.00078008373558486200205, 0.9977901336281500555 },
	{ 0.99793510257177797662, 0.00077994587242568224825, 0.99779053653647509226 },
	{ 0.99793543380194138503, 0.00077980064690077999495, 0.99779089393546183118 },
	{ 0.99793583741598546055, 0.00077966646492446159931, 0.99779132207800924625 },
	{ 0.99793618287496976826, 0.00077952364265883658523, 0.99779169439246229167 },
	{ 0.99793656016760290406, 0.00077938614189589712662, 0.99779209617545172595 },
	{ 0.99793692611151152416, 0.000779247782826072901, 0.99779248851706536794 },
	{ 0.99793729339056413963, 0.00077910785973036970637, 0.99779288234641105859 },
	{ 0.99793765828543090635, 0.00077896707832778174473, 0.99779326555182479286 },
	{ 0.99793802617483506889, 0.00077882776558364124383, 0.99779365846564305187 },
	{ 0.99793840588980076145, 0.00077868974983657070817, 0.99779406228949552027 },
	{ 0.99793875169210788378, 0.00077855108559096513569, 0.9977944456284237873 },
	{ 0.99793915770941121757, 0.00077841678917372862656, 0.99779487396170618574 },
	{ 0.9979395130866084429, 0.00077827839195693173258, 0.99779525985648143127 },
	{ 0.99793988570623715084, 0.00077813953697646292672, 0.99779565750052434669 },
	{ 0.99794022302084273157, 0.00077799764931166779953, 0.99779601964880915155 },
	{ 0.99794060353689484355, 0.0007778580695387185117, 0.99779641458441703517 },
	{ 0.99794096604757587254, 0.00077772085487807390315, 0.99779681074072801295 },
	{ 0.99794134627752595357, 0.00077758404076064225816, 0.99779721645285546217 },
	{ 0.99794171489172267542, 0.00077744560539687269582, 0.99779760772635395227 },
	{ 0.99794206872396751251, 0.00077730657875502693656, 0.99779799028326909838 },
	{ 0.99794241593771260135, 0.00077716245949233163197, 0.99779835336615474439 },
	{ 0.99794278344564701921, 0.00077702474892104266002, 0.99779874788214595327 },
	{ 0.99794317464285153818, 0.00077689379036391392752, 0.99779918058325667296 },
	{ 0.99794351411276116526, 0.00077675054848158966991, 0.99779953592230696824 },
	{ 0.99794389577322240026, 0.00077661318123305449635, 0.99779993963171864646 },
	{ 0.99794425931387165107, 0.00077647455513442159222, 0.99780033002783674601 },
	{ 0.99794462115698079341, 0.00077633571922743906633, 0.99780071582724461088 },
	{ 0.99794499019079419, 0.00077620060265029056697, 0.99780111766745460677 },
	{ 0.997945339197446879, 0.000776058352589255253, 0.9978014840691269427 },
	{ 0.99794573480062664927, 0.00077592798531020239217, 0.99780191858221889412 },
	{ 0.99794608075552160287, 0.0007757880240675266376, 0.99780228650976998672 },
	{ 0.99794645907812273844, 0.00077564922630751678007, 0.9978026844780620852 },
	{ 0.99794681807928231621, 0.00077551193535292694322, 0.99780307163168735496 },
	{ 0.99794716334753175158, 0.00077536854088271201218, 0.99780343215872580043 },
	{ 0.9979475453513158012, 0.00077523861229384478325, 0.9978038570397069762 },
	{ 0.99794789561681862544, 0.00077509861290419614348, 0.99780422698904769341 },
	{ 0.99794825936727638016, 0.0007749582892652799853, 0.99780460939337489723 },
	{ 0.997948629659939912, 0.00077482343971694016445, 0.99780501546789868161 },
	{ 0.997948991064358637, 0.00077468679726088547285, 0.99780539991308903058 },
	{ 0.99794933881216130178, 0.00077454504311049484754, 0.99780576597143866291 },
	{ 0.99794971303396295959, 0.00077440885841811195941, 0.99780616887976369966 },
	{ 0.99795009353094144, 0.00077427524864638326389, 0.99780657905508718386 },
	{ 0.99795045323781994551, 0.000774137824177389142, 0.99780696493078890885 },
	{ 0.99795080510549549757, 0.00077399713814223290546, 0.99780733022619894079 },
	{ 0.99795118270330418486, 0.00077386322319472318834, 0.99780774169851949029 },
	{ 0.9979515467017171515, 0.000773725817799215238, 0.99780812873770385885 },
	{ 0.99795188514165844573, 0.00077358391106093393925, 0.99780848792959819793 },
	{ 0.9979522684042926306, 0.00077345302879775032663, 0.9978089066689168618 },
	{ 0.99795260569982491283, 0.00077331196129286751493, 0.99780926502157785141 },
	{ 0.99795296260290100587, 0.00077317478477919557474, 0.99780965183188052858 },
	{ 0.9979533391516679508, 0.00077304092705214491436, 0.99781005409170719922 },
	{ 0.99795369414739543146, 0.00077290199577773088021, 0.99781043151785453471 },
	{ 0.99795407496862331698, 0.00077276684105360971249, 0.99781083507467804861 },
	{ 0.9979544184821118602, 0.00077262710869276975123, 0.99781120277334733881 },
	{ 0.99795480098180666673, 0.00077249302208388308071, 0.99781161098410153798 },
	{ 0.99795514316015132561, 0.0007723562270399378241, 0.99781198520590308476 },
	{ 0.99795550179891456821, 0.00077221784889662710167, 0.99781236452032562312 },
	{ 0.99795586863927709942, 0.00077208099663222278831, 0.99781275356222620676 },
	{ 0.9979562464278208811, 0.00077194910347426384366, 0.99781316640783757066 },
	{ 0.99795658830098987746, 0.00077180864632094340044, 0.99781352735449269087 },
	{ 0.99795694074087026859, 0.00077167120277846278174, 0.99781390321661400655 },
	{ 0.99795731131963605343, 0.00077153724968398028784, 0.99781430393148817792 },
	{ 0.99795768819265218141, 0.00077140165626967359663, 0.99781470315863041165 },
	{ 0.99795802697591629027, 0.00077126589119398995201, 0.99781507398535151943 },
	{ 0.99795839150838683285, 0.00077112810432875542651, 0.99781545835424800828 },
	{ 0.99795876019887763686, 0.00077099256813490757521, 0.99781584939886458496 },
	{ 0.99795911296300732207, 0.00077085617363417506531, 0.99781623020101894994 },
	{ 0.99795947408132412715, 0.00077071951210463409375, 0.99781661508489949419 },
	{ 0.99795985719137048076, 0.00077058832466566924268, 0.99781702398229921158 },
	{ 0.99796020982198563321, 0.00077044687569105985581, 0.99781739095617616453 },
	{ 0.99796057046346520192, 0.00077031542122328632623, 0.99781778684545829883 },
	{ 0.99796091340474935016, 0.00077017572700941903333, 0.99781815206457447065 },
	{ 0.99796124139242037288, 0.00077003511726820802509, 0.9978185044663078207 },
	{ 0.99796163857869979452, 0.00076990465462172376441, 0.99781892698217677928 },
	{ 0.99796199517660022504, 0.00076976900398695801645, 0.99781930677343633196 },
	{ 0.99796235562734481039, 0.00076963468849623522736, 0.99781969636846790106 },
	{ 0.99796271665029401277, 0.0007694976645704539606, 0.99782008546758904632 },
	{ 0.99796308406286116099, 0.00076936302483046365309, 0.99782047389913797186 },
	{ 0.9979634117835032292, 0.00076922497093642055749, 0.9978208306877731637 },
	{ 0.99796377295904037386, 0.00076908993065321750327, 0.99782121719289995632 },
	{ 0.99796413443975340307, 0.00076895122826063937085, 0.99782159271169867942 },
	{ 0.99796450534276837097, 0.00076882179558241672216, 0.99782200038839530265 },
	{ 0.99796486842565401698, 0.00076868698418104935283, 0.99782238910604659221 },
	{ 0.997965216860102311, 0.00076855018913710409622, 0.99782276073385411941 },
	{ 0.99796559218816616177, 0.00076841396629774853973, 0.99782314834524321601 },
	{ 0.99796594054632048465, 0.00076828228294813921684, 0.99782353668142476089 },
	{ 0.99796629231862876708, 0.00076814470589125442151, 0.99782390832830580862 },
	{ 0.9979666332762703318, 0.00076800836861098096837, 0.99782427827764652584 },
	{ 0.99796700845174657335, 0.0007678753501173285782, 0.997824676341306116 },
	{ 0.99796737006597380226, 0.00076773971855604921863, 0.99782506061483522419 },
	{ 0.99796773013524864293, 0.00076760578453505311312, 0.99782544654775762183 },
	{ 0.99796809586934898118, 0.00076747392952406672841, 0.99782584131170404262 },
	{ 0.9979684457152352417, 0.00076733732521498470517, 0.99782621404577387381 },
	{ 0.99796880267553189636, 0.00076720112144911553707, 0.99782659351278424342 },
	{ 0.99796916568212368226, 0.00076706699669325608976, 0.99782697910238382644 },
	{ 0.99796950969152309341, 0.00076693126976454511351, 0.99782735073019146466 },
	{ 0.99796985766820767161, 0.0007667958480116153757, 0.99782772342611425476 },
	{ 0.99797020129613733808, 0.0007666621810194279487, 0.99782810123373122391 },
	{ 0.99797056834630826216, 0.00076652553856337336553, 0.99782848262716361543 },
	{ 0.99797092441015111675, 0.00076639087974989666963, 0.99782886478353560733 },
	{ 0.9979712868826853267, 0.00076625850975477942471, 0.99782925258565957627 },
	{ 0.99797164973668917032, 0.00076612392723524817394, 0.99782963375021016539 },
	{ 0.99797200929097984456, 0.00076599111854994529711, 0.99783002641607310146 },
	{ 0.99797234040670257382, 0.00076585043251478895215, 0.99783037218023318271 },
	{ 0.99797268874578348719, 0.00076571472465956436429, 0.99783074336935051463 },
	{ 0.99797304549627174897, 0.00076558502495253314551, 0.99783113918233867778 },
	{ 0.99797341262273653317, 0.00076545105278456437164, 0.99783152522970197662 },
	{ 0.99797376794271341893, 0.00076531889259779685691, 0.99783190946508404373 },
	{ 0.99797415254049171018, 0.00076518499672377341975, 0.99783231161046970215 },
	{ 0.99797447524480698, 0.00076504909813368538168, 0.99783266498495082342 },
	{ 0.99797484902791855355, 0.00076491632759535517321, 0.99783305890966389473 },
	{ 0.99797518926076755896, 0.00076478010475599972513, 0.99783342523504214849 },
	{ 0.99797554315023284666, 0.00076465013802015993627, 0.99783381437231000177 },
	{ 0.99797587153844691255, 0.00076450836479628303099, 0.99783414974141992904 },
	{ 0.99797625758581021138, 0.00076437988579237665758, 0.99783456630636124807 },
	{ 0.99797660918645714201, 0.00076424839317763056806, 0.99783495201040173228 },
	{ 0.99797695111684658897, 0.00076411016762221062749, 0.99783530927587393844 },
	{ 0.99797730605535361903, 0.00076397610008681012851, 0.99783568733144645257 },
	{ 0.9979776556914315977, 0.00076384302437269889843, 0.99783606382299272486 },
	{ 0.9979780063193307571, 0.00076370697319472040376, 0.99783643421102363735 },
	{ 0.99797835357122288702, 0.00076357563316786498768, 0.99783681442190008681 },
	{ 0.99797872447423818798, 0.0007634455901380798621, 0.9978372149269658653 },
	{ 0.99797905806951414664, 0.00076330768883192754836, 0.99783756431508829898 },
	{ 0.99797943345479855903, 0.00076317701637709344908, 0.99783796342778963151 },
	{ 0.99797977950506089329, 0.00076304607689345077971, 0.99783834522176539927 },
	{ 0.99798011912755857367, 0.00076290771782362644567, 0.99783869850087902886 },
	{ 0.99798046054296396523, 0.00076277382194960311693, 0.99783906783986819899 },
	{ 0.99798081803731819583, 0.00076264223396742530231, 0.99783945482183211695 },
	{ 0.9979811667769422634, 0.00076250818550551119172, 0.99783982644963964415 },
	{ 0.99798154450826548345, 0.00076237764656508159433, 0.99784022569585539841 },
	{ 0.99798187356405154702, 0.0007622402411695737524, 0.99784057550359450683 },
	{ 0.99798224980764282943, 0.00076211225807631195923, 0.99784098401952447954 },
	{ 0.99798257852010607838, 0.00076197809517348006041, 0.99784134012151415316 },
	{ 0.99798294448308821902, 0.00076184616386854833898, 0.99784172698903716991 },
	{ 0.9979832913153636742, 0.00076171112358534528476, 0.99784209487844133246 },
	{ 0.99798364516668203184, 0.00076157913505995461501, 0.99784247711110729551 },
	{ 0.99798398332052118409, 0.00076144377052748393395, 0.99784283708501475552 },
	{ 0.99798434743337505193, 0.00076131433784926139368, 0.99784322660375235348 },
	{ 0.99798470916204329306, 0.00076118004143202499297, 0.99784360446858988425 },
	{ 0.99798505408696991381, 0.00076104965507948596059, 0.99784398540425867097 },
	{ 0.99798540812902303276, 0.00076091373741591164254, 0.99784435180593100689 },
	{ 0.99798576022558049825, 0.0007607831984754818283, 0.99784473197866030425 },
	{ 0.99798610360555484178, 0.00076065122902357765536, 0.99784510526586100987 },
	{ 0.99798645167760702268, 0.00076051845848524766373, 0.99784547840047399525 },
	{ 0.9979867915671333245, 0.00076038410484755220627, 0.99784584361959005605 },
	{ 0.99798714229039986456, 0.00076025280296766924171, 0.99784621936727058156 },
	{ 0.99798750834874927484, 0.00076012081444227868037, 0.99784660678792469479 },
	{ 0.9979878457205754172, 0.00075998638451063799462, 0.99784696460652799743 },
	{ 0.99798820300512125492, 0.0007598563033338803091, 0.99784734966206989348 },
	{ 0.99798854442052642444, 0.00075972362816298193416, 0.99784771900105895259 },
	{ 0.99798891372136855349, 0.00075959396660292327532, 0.99784811332631506708 },
	{ 0.9979892509024598235, 0.00075945911705458334605, 0.99784847034383206132 },
	{ 0.99798957896642448429, 0.00075932575523817715749, 0.99784882526326545982 },
	{ 0.99798997184209570221, 0.00075920059502089184706, 0.99784924728322388354 },
	{ 0.99799031958989836699, 0.0007590649443861260991, 0.99784960510182718618 },
	{ 0.99799065017156329827, 0.00075893287956679009263, 0.99784997138905850989 },
	{ 0.99799101211003982126, 0.00075880287468397752699, 0.99785035774159736022 },
	{ 0.99799135638646807589, 0.00075867245018446582625, 0.99785073131490042986 },
	{ 0.9979916926711054348, 0.00075853956520521782954, 0.99785109437871266636 },
	{ 0.99799206548146901508, 0.00075840784370863583829, 0.99785148115086830245 },
	{ 0.99799240651540443992, 0.00075827707588637012232, 0.99785185331273329457 },
	{ 0.99799274131230986118, 0.00075814274132216116168, 0.99785220790791739898 },
	{ 0.99799307822637217669, 0.00075801090538466105694, 0.99785257411885475154 },
	{ 0.99799341432027455223, 0.00075787554085219037588, 0.99785292791295265857 },
	{ 0.99799379441670998947, 0.00075774904549086232342, 0.99785333455968105998 },
	{ 0.99799414826802823608, 0.00075761522591078422299, 0.99785370397496420125 },
	{ 0.99799445416860199654, 0.0007574821311231864961, 0.99785404413151923553 },
	{ 0.99799482747487622269, 0.00075735082924330374837, 0.99785443315434629863 },
	{ 0.99799517724446840106, 0.00075722597420179989323, 0.99785482305455375229 },
	{ 0.99799554227284970054, 0.00075709173500502254927, 0.99785519906926312128 },
	{ 0.99799587636403608304, 0.00075696134865248351688, 0.99785556260991248312 },
	{ 0.99799620921544585084, 0.00075682773888075482137, 0.99785591911244531094 },
	{ 0.99799657065801172795, 0.00075669815361464160767, 0.99785630100178834834 },
	{ 0.99799689773015509697, 0.00075656257927382130485, 0.99785665141987911486 },
	{ 0.99799724994115357468, 0.00075643581688368468231, 0.99785703887868026918 },
	{ 0.99799759520940301005, 0.00075630310356581353058, 0.99785740047383397755 },
	{ 0.99799794206075187475, 0.00075617231667006164306, 0.99785777608800008132 },
	{ 0.99799828898839471059, 0.0007560424834486259224, 0.99785814918446591459 },
	{ 0.9979986424963902536, 0.00075590992271864544411, 0.99785851772236855428 },
	{ 0.99799899588994478439, 0.00075578113853895783226, 0.99785889919209502796 },
	{ 0.99799931701116040283, 0.00075564724266493428669, 0.99785924152302740708 },
	{ 0.9979997011702484988, 0.00075552255928480738494, 0.99785965715336788495 },
	{ 0.99800002915791929947, 0.0007553875952955494506, 0.99786000146794306964 },
	{ 0.99800035783223550734, 0.0007552560645338305843, 0.9978603582184312204 },
	{ 0.99800070413045316453, 0.00075512811958754145949, 0.99786073594975444045 },
	{ 0.99800105472020517183, 0.00075499557793104726117, 0.99786110229420610374 },
	{ 0.99800140922002189559, 0.00075486286461317621786, 0.99786147128987245924 },
	{ 0.99800173934392322206, 0.0007547324782606372939, 0.99786183086323665403 },
	{ 0.99800209731511446698, 0.00075460583031141845959, 0.99786222179341232952 },
	{ 0.99800243438176461375, 0.00075447231590712148918, 0.99786257198262118262 },
	{ 0.99800277766637157661, 0.00075434341728651608909, 0.99786294792103646945 },
	{ 0.9980031226675921685, 0.0007542135649915943053, 0.9978633173363194997 },
	{ 0.9980034693091325293, 0.00075408153831923096719, 0.99786368060993990703 },
	{ 0.99800381812505023493, 0.00075395122826063727152, 0.99786405078816242664 },
	{ 0.99800418712071659044, 0.00075382576286757083106, 0.99786445259022527043 },
	{ 0.99800451808385115537, 0.00075369468986952409349, 0.99786480766224661121 },
	{ 0.9980048476355477538, 0.00075356258690321552707, 0.99786515994953894904 },
	{ 0.99800520104817580513, 0.00075343252479994401311, 0.99786553220677143283 },
	{ 0.99800554759434878527, 0.00075330627739393825077, 0.99786591365742438597 },
	{ 0.99800587558201969696, 0.00075317314445936796394, 0.99786626483845453084 },
	{ 0.99800622981480757723, 0.00075304275810682882314, 0.99786663402485575869 },
	{ 0.99800657010487703324, 0.0007529124289747488475, 0.99786699876713458313 },
	{ 0.99800691663197638182, 0.00075278654396498327194, 0.99786738283085507639 },
	{ 0.9980072526305113767, 0.00075265257179701449807, 0.99786772920536670473 },
	{ 0.9980076023047361744, 0.00075252308189833279264, 0.99786810230183264903 },
	{ 0.99800793900899031907, 0.00075239343941176052219, 0.99786846574711440816 },
	{ 0.99800828694752774517, 0.00075226499855482703398, 0.99786883871006604174 },
	{ 0.99800863660267902233, 0.00075213613808119430225, 0.99786921354221924663 },
	{ 0.9980089584486873111, 0.0007520025855299247719, 0.99786955362248019874 },
	{ 0.99800930234364559901, 0.00075187582313978804094, 0.99786992757725301306 },
	{ 0.99800966760090858987, 0.00075175119698012008752, 0.99787032380985796198 },
	{ 0.99800999589375516408, 0.00075161821663344047413, 0.99787067560123965393 },
	{ 0.99801034789494502686, 0.00075148849785292286697, 0.99787103977131397237 },
	{ 0.99801068740300158399, 0.0007513589507337822132, 0.99787140582966349367 },
	{ 0.99801102702549904233, 0.00075123173057997367878, 0.9978717772667360375 },
	{ 0.99801136714390714655, 0.00075109974205458311745, 0.99787213203358160474 },
	{ 0.99801173236302320735, 0.00075097439110243457364, 0.99787252319263919365 },
	{ 0.9980120539801495827, 0.00075084595024550097701, 0.9978728800575682456 },
	{ 0.99801240161351123525, 0.00075071529686415337454, 0.99787324294971890826 },
	{ 0.99801273112706090362, 0.00075058658897841120782, 0.99787360252308299202 },
	{ 0.9980130697958842223, 0.00075045330345595024756, 0.99787395248341004272 },
	{ 0.99801339379719622436, 0.00075032198250258111145, 0.99787430055546200158 },
	{ 0.998013746256150025, 0.00075019859611952439179, 0.99787468566822423721 },
	{ 0.998014102014816884, 0.0007500701934095633551, 0.99787506568836581433 },
	{ 0.99801443713597148832, 0.00074993908226454384074, 0.99787541667866108686 },
	{ 0.9980147613089449532, 0.00074980884849989548179, 0.99787576938557021045 },
	{ 0.99801513019017051853, 0.00074968349754774693799, 0.99787615871357293607 },
	{ 0.99801545100621047446, 0.00074954960167372339241, 0.99787649616169293854 },
	{ 0.99801579749516289297, 0.00074942596733534438264, 0.99787687637256927697 },
	{ 0.99801613885334761189, 0.00074929720222914326759, 0.99787724473881067588 },
	{ 0.99801649054936192318, 0.00074916961967909443797, 0.99787761562275212324 },
	{ 0.99801681823185683928, 0.00074904091179335216284, 0.99787797229694619183 },
	{ 0.99801715047291506, 0.0007489101248976001669, 0.99787832490848793476 },
	{ 0.99801749265125971888, 0.00074878111183607665331, 0.99787868463443996081 },
	{ 0.99801783856800774242, 0.0007486555320020923162, 0.99787906289982064578 },
	{ 0.99801816031864853951, 0.00074852089226210222553, 0.99787939575123030256 },
	{ 0.99801853125981054848, 0.00074839805901014914286, 0.99787979598926723757 },
	{ 0.99801885011128121938, 0.0007482673102613699237, 0.99788013822483223603 },
	{ 0.99801919934681559976, 0.00074814169228041302664, 0.99788051706241764904 },
	{ 0.99801955657414087586, 0.0007480134612318291602, 0.9978808872597136892 },
	{ 0.99801986464909175911, 0.0007478842192884698533, 0.99788123256611005463 },
	{ 0.99802020919254863518, 0.00074775757133925112741, 0.99788159908222318073 },
	{ 0.9980205598967416547, 0.00074762956917250305428, 0.997881969355813081 },
	{ 0.99802088496616891966, 0.00074750187218153643642, 0.9978823230736170169 },
	{ 0.99802121005466970516, 0.00074736767113173186924, 0.99788265945362186748 },
	{ 0.99802155763081079609, 0.00074724466621840172475, 0.9978830396072776443 },
	{ 0.99802189305714117395, 0.00074711492836439772919, 0.99788339525150371312 },
	{ 0.9980222518294188383, 0.00074699152290785472957, 0.99788378271030486744 },
	{ 0.99802256955555379569, 0.00074685819923842099253, 0.99788411561893508583 },
	{ 0.99802290902546331175, 0.0007467329627271904538, 0.99788448507236526819 },
	{ 0.99802325108936695841, 0.00074660482704603820404, 0.99788484743045846592 },
	{ 0.99802358252933887073, 0.00074647625267470021394, 0.99788520423816695626 },
	{ 0.99802391467502971079, 0.00074634903252089178794, 0.99788556186603538656 },
	{ 0.99802426383427034207, 0.00074622326195204410904, 0.99788593368457789712 },
	{ 0.99802460036686302391, 0.00074609516441786452763, 0.99788629554676033795 },
	{ 0.99802494544437758694, 0.00074596828758680990001, 0.99788666015552496269 },
	{ 0.99802526582172734759, 0.00074584059059584317374, 0.99788700937198604457 },
	{ 0.99802560040882437598, 0.00074571230232680025055, 0.99788736707614855703 },
	{ 0.99802595160892793036, 0.00074558834373915383077, 0.99788774799274393423 },
	{ 0.99802628440311735858, 0.00074545696556532585475, 0.99788809055255822678 },
	{ 0.99802662078312220917, 0.00074533100426161483405, 0.99788845394061975735 },
	{ 0.99802696671894364222, 0.00074520494759047219667, 0.99788882558750080509 },
	{ 0.99802728303364085516, 0.00074507631599867536667, 0.99788916662143622993 },
	{ 0.99802764264515198001, 0.00074495062172377302448, 0.99788954606937307901 },
	{ 0.99802795249393716492, 0.00074482288658583362985, 0.99788988899158370671 },
	{ 0.99802829150608307618, 0.00074469337761366586129, 0.99789024166034578922 },
	{ 0.99802864741733787746, 0.00074456924736464237969, 0.99789062015460838762 },
	{ 0.99802898105076054414, 0.00074444374382460327087, 0.99789098308490620237 },
	{ 0.99802932208469585795, 0.00074431785881483758689, 0.99789134700702519787 },
	{ 0.998029635652810998, 0.00074418587028944702556, 0.99789168041156606215 },
	{ 0.99802999791553670406, 0.00074406580269301126045, 0.99789207372592747536 },
	{ 0.99803029857090141963, 0.00074393413841688821753, 0.99789239898608972368 },
	{ 0.99803065833500037574, 0.0007438076812025326166, 0.99789277263568687548 },
	{ 0.99803099326542021874, 0.00074368423759901694861, 0.99789313747333330262 },
	{ 0.99803130649021254417, 0.00074355160057509124202, 0.99789346679614809865 },
	{ 0.99803166884830563088, 0.00074342712700331407046, 0.99789384944843062542 },
	{ 0.99803201461246549009, 0.00074330536186659526814, 0.99789422450946552168 },
	{ 0.99803231158664751366, 0.00074317402183973974364, 0.99789454635547369943 },
	{ 0.99803268226078067915, 0.00074304985344374359368, 0.99789493472980217437 },
	{ 0.99803300349643730982, 0.00074292324364149764458, 0.99789528663562465649 },
	{ 0.99803333087375656341, 0.000742794383167864696, 0.99789563018726046284 },
	{ 0.99803366465976717237, 0.0007426708632704036913, 0.99789599677966756008 },
	{ 0.99803401803424829364, 0.00074254812538588211689, 0.99789637826846744328 },
	{ 0.99803432816913573156, 0.00074241667091810869573, 0.99789670091556204046 },
	{ 0.99803467997959094404, 0.00074229339897596998115, 0.99789707805560701193 },
	{ 0.99803497703006693875, 0.00074216358482802064888, 0.99789740241931546016 },
	{ 0.99803532641818937243, 0.00074203590691054009416, 0.99789776714252087508 },
	{ 0.99803566928317932749, 0.0007419145995374930953, 0.99789814235614382465 },
	{ 0.99803601058414359581, 0.0007417877608534109192, 0.99789849807666364256 },
	{ 0.99803633086612586478, 0.00074166187584364534364, 0.99789885131763023107 },
	{ 0.99803668292453640021, 0.00074153648674452413148, 0.99789921909259349242 },
	{ 0.99803699496677267256, 0.00074140602409803987079, 0.99789955066607960443 },
	{ 0.99803730435779425267, 0.00074127992927992456505, 0.99789988904880033704 },
	{ 0.99803765115192266677, 0.00074115690529310824901, 0.99790026582644919539 },
	{ 0.99803799758365463468, 0.00074103214561903601055, 0.99790062919543720543 },
	{ 0.99803833510806849727, 0.0007409070235487234769, 0.99790099113391350638 },
	{ 0.99803866790225781447, 0.00074078022301161407757, 0.99790134834216526194 },
	{ 0.99803899348666935687, 0.00074065506279432898398, 0.99790169437335407565 },
	{ 0.99803931010654223233, 0.00074052612602675091553, 0.99790203144000444446 },
	{ 0.99803966796329257605, 0.00074040439903700488999, 0.99790241439746274477 },
	{ 0.99803999457767222925, 0.00074027904808485634619, 0.99790276908801445188 },
	{ 0.99804031615665156352, 0.00074015079796278609135, 0.99790310836718931764 },
	{ 0.99804066935947133299, 0.00074002876579725882736, 0.99790348445819265777 },
	{ 0.99804098897388149325, 0.00073990274727308885834, 0.99790383310244934467 },
	{ 0.99804133782794635099, 0.00073978048622572569262, 0.99790420652316447203 },
	{ 0.99804163014819768929, 0.00073964891731703426639, 0.99790451906131139026 },
	{ 0.99804199437549245832, 0.00073952822029554985284, 0.9979049064819655035 },
	{ 0.99804229010989764515, 0.00073939586937391899631, 0.9979052168266613343 },
	{ 0.99804264445712642662, 0.00073927551567518859799, 0.99790559925006194764 },
	{ 0.99804299457004130858, 0.0007391507750746026395, 0.99790596782611151738 },
	{ 0.99804329463412821966, 0.00073902298271620429655, 0.99790629306720024516 },
	{ 0.99804362941196000936, 0.00073889694511854804755, 0.99790664859698519074 },
	{ 0.99804397166659852836, 0.00073877319633925124954, 0.99790701251910418623 },
	{ 0.99804430221011630753, 0.0007386485701795831877, 0.99790736709521499215 },
	{ 0.99804463111331442882, 0.00073852657616102859207, 0.99790772712634279173 },
	{ 0.99804496028354139359, 0.00073839836418593089717, 0.9979080687324828336 },
	{ 0.99804530549457037836, 0.00073827749550306953023, 0.99790844423220792514 },
	{ 0.9980456310408349907, 0.00073815168678724918296, 0.9979087943451228071 },
	{ 0.99804595097949433402, 0.00073802736580336235957, 0.99790914129183905246 },
	{ 0.99804625375201627691, 0.00073789602577650683507, 0.99790945878909220745 },
	{ 0.99804658181598093769, 0.00073777303993666307896, 0.99790981309817405887 },
	{ 0.99804693379809750198, 0.00073765436470472954631, 0.99791019849703865852 },
	{ 0.99804728799273845219, 0.00073752920448744423588, 0.9979105637543017604 },
	{ 0.99804758845736851747, 0.00073740036308729756728, 0.99791088760302593119 },
	{ 0.998047928194306877, 0.00073728050529921164077, 0.99791126243517913608 },
	{ 0.9980482371847851919, 0.00073715065300428985699, 0.99791158058093099026 },
	{ 0.9980485794394237109, 0.00073702995598280544344, 0.99791195609972971337 },
	{ 0.99804891524722383345, 0.00073690494835341102328, 0.99791231059954643712 },
	{ 0.99804923249652177653, 0.00073678022682631123634, 0.99791265233920090072 },
	{ 0.99804956262042299198, 0.00073665533363783471284, 0.99791300336764321433 },
	{ 0.99804989751269590492, 0.0007365293341871511322, 0.99791335122988666928 },
	{ 0.99805023244311574793, 0.0007364089423414479571, 0.99791371972964237891 },
	{ 0.99805055970599398929, 0.00073628469765150647043, 0.99791406888888301019 },
	{ 0.99805087281634541352, 0.000736155913471818967, 0.99791439786837510262 },
	{ 0.99805121306826782845, 0.00073603435814344978644, 0.99791476394579803344 },
	{ 0.99805151847293072098, 0.00073590793907606696228, 0.99791509437487513345 },
	{ 0.99805186248233002111, 0.00073578548729384045477, 0.99791546325610058776 },
	{ 0.99805219047000071075, 0.00073566669762098880862, 0.99791582466051942379 },
	{ 0.99805251784731985332, 0.00073553844749891855379, 0.99791616546557304623 },
	{ 0.99805285977770907824, 0.0007354166632887134715, 0.99791653016970482959 },
	{ 0.99805318355013916687, 0.00073529381096327389201, 0.99791688152239643728 },
	{ 0.99805350390841540698, 0.0007351683074232347832, 0.99791722141192273909 },
	{ 0.99805381930758518827, 0.00073504150688612527546, 0.99791755359576050921 },
	{ 0.9980541410963728044, 0.00073491442024672080924, 0.99791788942263426332 },
	{ 0.99805447863986007651, 0.00073479549705946487805, 0.99791826164171981706 },
	{ 0.99805481250216465661, 0.0007346715956922774066, 0.99791861625597755303 },
	{ 0.99805515654971077577, 0.00073455253899061708194, 0.99791898799822587041 },
	{ 0.99805548783709474581, 0.00073442877113783378712, 0.99791933801577326069 },
	{ 0.99805581124712883234, 0.00073430494606459165239, 0.9979196858398698966 },
	{ 0.99805613316943098123, 0.00073418077766859539401, 0.99792003263399819968 },
	{ 0.99805643216540274043, 0.0007340539008375407664, 0.99792035314486238207 },
	{ 0.99805676047732283518, 0.00073392834007704270925, 0.99792069694445328931 },
	{ 0.99805711295535004535, 0.00073381206810438641581, 0.99792108360216802421 },
	{ 0.99805740989138513886, 0.00073368480980360532145, 0.99792140373156246191 },
	{ 0.99805776786257638378, 0.00073356426537001158134, 0.99792177818224592212 },
	{ 0.99805806621004922174, 0.000733438342213273229, 0.99792210544512405246 },
	{ 0.99805840411593282901, 0.00073331344902479659708, 0.99792245113299027359 },
	{ 0.99805872535158934866, 0.00073319515526258942275, 0.99792281257555592866 },
	{ 0.99805905986239251693, 0.00073306808769667145334, 0.99792315380022622584 },
	{ 0.99805936122347627126, 0.00073294311821424959312, 0.99792348262713037599 },
	{ 0.99805970351626172032, 0.00073282322227919099826, 0.99792385055468169064 },
	{ 0.99806004313875917866, 0.00073270477592909336734, 0.99792422107622691385 },
	{ 0.99806034839083423993, 0.00073257728874647626283, 0.99792454311296985292 },
	{ 0.99806069442202305364, 0.0007324589186903238602, 0.99792491615221534662 },
	{ 0.99806099364687639319, 0.00073233089745008939867, 0.99792523338243988018 },
	{ 0.99806134931017576051, 0.00073221189796888813076, 0.99792561178133498689 },
	{ 0.99806165141512570571, 0.00073208526909315557642, 0.99792593311235899822 },
	{ 0.99806198007036850406, 0.00073196073830091913127, 0.99792627729341987219 },
	{ 0.99806228343416847348, 0.00073183788597547966021, 0.99792661197588439226 },
	{ 0.99806260642458577426, 0.00073171509087049913748, 0.99792695877001258431 },
	{ 0.99806295468737249443, 0.00073159780800306740359, 0.99792733804628830363 },
	{ 0.99806328694750434671, 0.00073147596657240326456, 0.99792768587038493955 },
	{ 0.99806360463549248507, 0.00073135359108412187693, 0.99792803529665441431 },
	{ 0.99806392968584645153, 0.00073122820198500077318, 0.99792837087557273446 },
	{ 0.99806423844744307505, 0.00073110636055433674257, 0.99792871122286275209 },
	{ 0.99806459144045456267, 0.00073098640739881909096, 0.99792908088610132733 },
	{ 0.99806490043093298858, 0.00073086082756483464543, 0.99792941001818136204 },
	{ 0.99806519473482691041, 0.000730738642811416708, 0.99792973773882331923 },
	{ 0.99806552936007086885, 0.00073061397850477597781, 0.99793008274004391112 },
	{ 0.99806587207247310367, 0.00073049587547743214527, 0.99793045535967273008 },
	{ 0.99806618865419893805, 0.00073037231743299858063, 0.99793079078600321896 },
	{ 0.99806651761461762096, 0.00073024767219984413041, 0.99793113054201521006 },
	{ 0.99806685471941480881, 0.0007301311331983793753, 0.99793150274202735428 },
	{ 0.99806716500689030003, 0.00073000807106459028248, 0.99793183591768641616 },
	{ 0.99806746941973190079, 0.00072988127052748088316, 0.99793215742037177929 },
	{ 0.99806779687334512552, 0.00072976194679701198841, 0.99793251295015683588 },
	{ 0.99806812524248567087, 0.00072963621437513686944, 0.99793284864351605723 },
	{ 0.99806843617845963923, 0.00072951578438246113441, 0.99793319246218048502 },
	{ 0.99806877639223534615, 0.00072939792931043970041, 0.99793356262132959511 },
	{ 0.99806911622454119737, 0.00072927797615492215722, 0.99793392591402352299 },
	{ 0.99806942765642592263, 0.00072915422737562514237, 0.99793425413057601503 },
	{ 0.99806970837999764434, 0.00072902883827650414705, 0.99793456346437736659 },
	{ 0.99807006112505369799, 0.00072891123115980478633, 0.9979349384109715837 },
	{ 0.99807038558412963791, 0.00072879070579969721776, 0.99793528858110713831 },
	{ 0.99807072146822406467, 0.00072866646110975573109, 0.99793563224718373483 },
	{ 0.99807102977205686134, 0.00072854477226698215707, 0.99793596832201270086 },
	{ 0.99807135062624374733, 0.00072842388451063461857, 0.99793631427690765445 },
	{ 0.99807166253496548691, 0.00072829824745619133313, 0.99793663778230912165 },
	{ 0.99807199429918669331, 0.00072818086922132798256, 0.99793700433656939985 },
	{ 0.99807230397631052643, 0.000728054602741835615, 0.99793732088014830417 },
	{ 0.99807261542726855019, 0.00072793564140760712387, 0.99793766757890911556 },
	{ 0.99807295968462306224, 0.00072781889259779253016, 0.99793803884432041862 },
	{ 0.99807327203203521915, 0.00072769392311537056152, 0.99793836706087302169 },
	{ 0.99807357812334374092, 0.00072757337868177671299, 0.99793870428011111073 },
	{ 0.99807390662599848596, 0.00072745418846571232013, 0.99793905792162107549 },
	{ 0.99807423598696032307, 0.00072733143150770446575, 0.99793940193102037561 },
	{ 0.99807454486299784779, 0.00072720878899061472487, 0.99793973163530491632 },
	{ 0.99807488791872289724, 0.00072708980858289984535, 0.99794009330675259584 },
	{ 0.99807521300722379376, 0.00072697071373426706917, 0.99794044555589789258 },
	{ 0.99807550166536573855, 0.00072684364616834899134, 0.99794075031206219695 },
	{ 0.99807583108354791523, 0.0007267241507765031432, 0.99794110490724630136 },
	{ 0.99807612714220239614, 0.00072660059273206936171, 0.99794142324373291686 },
	{ 0.99807648049760977482, 0.00072648596107923726559, 0.99794180322572734188 },
	{ 0.99807680304933699134, 0.00072636436760389552509, 0.99794214832231531442 },
	{ 0.99807709453035498015, 0.00072623646080457906864, 0.99794244895860662048 },
	{ 0.99807742541719568496, 0.00072611858665907135467, 0.99794280807420709944 },
	{ 0.99807775010515331626, 0.00072600168526136630437, 0.99794316434785790282 },
	{ 0.99807807589937314052, 0.00072587925255262618525, 0.99794350429460465524 },
	{ 0.99807838605333409898, 0.00072576101601087806767, 0.99794384836122440596 },
	{ 0.99807872754503323964, 0.00072563925087415937377, 0.99794419839784531678 },
	{ 0.99807904843736716671, 0.00072552252113783116845, 0.99794455224916345237 },
	{ 0.99807935300279670976, 0.000725401061176893713, 0.9979448800079522286 },
	{ 0.99807967053819690584, 0.00072527700722181556812, 0.99794521310731731933 },
	{ 0.99807998223711025254, 0.00072515657722913983308, 0.99794554716035666075 },
	{ 0.99808027076173777559, 0.00072503074943983309743, 0.9979458537666491269 },
	{ 0.99808061347414001041, 0.0007249150878187393893, 0.9979462251655748517 },
	{ 0.99808094596315355407, 0.00072479439079725497576, 0.9979465738289048371 },
	{ 0.99808126452852197197, 0.00072467808067762601396, 0.99794692169114829206 },
	{ 0.99808157351900028686, 0.00072455616295301653821, 0.99794725082322821574 },
	{ 0.99808188590455926281, 0.00072443588554823136819, 0.9979475911323711923 },
	{ 0.9980822154944027913, 0.00072431625664198134341, 0.99794794025346489352 },
	{ 0.99808252505708594526, 0.00072419704735243056216, 0.99794827751084991263 },
	{ 0.99808282016206617548, 0.00072406978905164935938, 0.99794858543321307565 },
	{ 0.99808315167833205894, 0.00072395273506605352723, 0.99794893735810918933 },
	{ 0.99808348906923149979, 0.00072383381187879770446, 0.99794929458543435441 },
	{ 0.99808380095887982986, 0.00072371601402723511037, 0.99794963821336390986 },
	{ 0.99808411527086082771, 0.00072359579384290878025, 0.99794997251435857422 },
	{ 0.99808439748216437604, 0.00072347196876966664552, 0.99795027913972467193 },
	{ 0.99808475037980837197, 0.00072335596382581881375, 0.99795065118714887387 },
	{ 0.99808506699968135845, 0.00072323618233167811555, 0.99795098642274449041 },
	{ 0.99808536330629127331, 0.00072311603844129723057, 0.9979513153450159102 },
	{ 0.99808566676545873442, 0.00072299103081190270199, 0.99795162979051132979 },
	{ 0.99808601584840550558, 0.0007228767806287970726, 0.99795200672074813042 },
	{ 0.99808632949281450575, 0.00072275387108289854479, 0.99795233501359470463 },
	{ 0.99808661786485408651, 0.00072263044655286926519, 0.99795264200135702648 },
	{ 0.99808698039460863605, 0.00072252048790418757929, 0.99795303775712473904 },
	{ 0.9980872704451150268, 0.00072239507973158019558, 0.99795334138795344092 },
	{ 0.99808758460450808236, 0.00072227817833387514528, 0.99795369003220990578 },
	{ 0.99808789277482667934, 0.00072215509712659955565, 0.99795401067658839889 },
	{ 0.99808821658540380906, 0.00072203823387586706529, 0.99795436263963144263 },
	{ 0.99808854533601398806, 0.00072191959679090598415, 0.99795470832749766377 },
	{ 0.9980888608114777405, 0.00072179973900281984081, 0.99795504348679930917 },
	{ 0.99808916957307425299, 0.00072168232262098403872, 0.99795538368150127351 },
	{ 0.99808948550630161023, 0.00072156017601453876966, 0.9979557131950510529 },
	{ 0.9980898018591456422, 0.00072144157707655035688, 0.99795605304643020261 },
	{ 0.99809011542726078225, 0.00072132393181287854465, 0.99795639224931087519 },
	{ 0.99809041236329587576, 0.00072119850456678477255, 0.9979566995613223801 },
	{ 0.99809074714112788751, 0.00072108650505506592578, 0.99795707340165440424 },
	{ 0.99809104215074073707, 0.00072096430122816149155, 0.99795738470002459675 },
	{ 0.99809135632920731318, 0.00072084360420667707801, 0.99795771993562010227 },
	{ 0.99809171025681953093, 0.00072072939217054411698, 0.99795809431000970235 },
	{ 0.99809196874070615912, 0.00072060335457288786799, 0.9979583735458493754 },
	{ 0.99809229585099679127, 0.00072048742592298537293, 0.99795872842713595485 },
	{ 0.9980926383917376743, 0.00072037090599500668096, 0.99795908668442967482 },
	{ 0.99809296306062167403, 0.00072025261223279950663, 0.99795943141862153425 },
	{ 0.99809326468873427185, 0.00072013164818250641457, 0.99795975318833562984 },
	{ 0.99809356574464236367, 0.00072001369774305325547, 0.99796008201523977998 },
	{ 0.99809389056611441671, 0.00071989326775037752043, 0.9979604224769705878 },
	{ 0.99809421685624488685, 0.00071978170692884419716, 0.9979607859985464291 },
	{ 0.99809452348161098456, 0.00071966017067396129657, 0.99796110650941061149 },
	{ 0.998094838957074737, 0.00071954168617689099729, 0.99796144899293104391 },
	{ 0.99809515309739438305, 0.00071942362129651983311, 0.99796178144379743546 },
	{ 0.99809544391084026316, 0.00071930305778943959619, 0.99796209953232883905 },
	{ 0.99809578938889820243, 0.00071918844521009388845, 0.99796246412201994325 },
	{ 0.99809608487534828836, 0.00071906507790052355718, 0.99796277227326490866 },
	{ 0.99809640752244288553, 0.00071894689857923449634, 0.99796311551972483045 },
	{ 0.99809670186448384843, 0.00071882894813978144566, 0.99796343885346483482 },
	{ 0.99809702189851079446, 0.00071871078789197877321, 0.99796377983017969804 },
	{ 0.99809732898164049697, 0.00071859062492811149984, 0.9979641067497352358 },
	{ 0.99809763862061751105, 0.00071847507774793568838, 0.99796444782181770172 },
	{ 0.99809795752930874357, 0.00071835453331434173142, 0.99796477832718877288 },
	{ 0.99809826091218234456, 0.00071823616325818943722, 0.99796510238572144758 },
	{ 0.99809859254288912922, 0.00071812265694105078661, 0.99796546480103520693 },
	{ 0.99809888783860423178, 0.00071800039589368751247, 0.99796577649994877568 },
	{ 0.99809923417496881903, 0.00071788461983167569085, 0.99796613771363285039 },
	{ 0.99809952508378196878, 0.00071776705086194910691, 0.99796645685120577429 },
	{ 0.99809982724595225356, 0.00071764837563001535742, 0.99796678579255093666 },
	{ 0.99810015981125976836, 0.00071753263771497631258, 0.99796713743134490837 },
	{ 0.99810047362733034237, 0.00071741653740369697254, 0.9979674806968783507 },
	{ 0.99810077033448352246, 0.00071729484856092339852, 0.99796779113694167318 },
	{ 0.99810110003876806317, 0.00071718212425672417821, 0.99796815128251037397 },
	{ 0.99810138593125452555, 0.00071705770790540584655, 0.99796844816132490585 },
	{ 0.99810171018052207259, 0.00071694158852064011813, 0.99796879529877602355 },
	{ 0.99810201989579283577, 0.00071682596504651886152, 0.99796913293763089836 },
	{ 0.99810234334397374134, 0.00071670851051771017424, 0.99796947492524079593 },
	{ 0.99810263003754651212, 0.00071658909141980977123, 0.99796979000016117212 },
	{ 0.99810295989441899511, 0.00071647369682752452477, 0.9979701402275170663 },
	{ 0.99810325253891951647, 0.00071635153114759286732, 0.99797044485016694892 },
	{ 0.99810357774186142521, 0.00071623728096448723793, 0.99797079942627775484 },
	{ 0.9981038819258213346, 0.00071611849129163559179, 0.99797111886902678535 },
	{ 0.99810421197342846789, 0.00071600023567640130265, 0.99797146417542315078 },
	{ 0.99810451465058303011, 0.00071588833153211396416, 0.99797180808945507025 },
	{ 0.99810480187821348785, 0.00071576242744886189179, 0.9979721001617510856 },
	{ 0.9981051451628203397, 0.00071565206825696735075, 0.99797247060700233767 },
	{ 0.9981054336683743422, 0.00071552995979749475005, 0.99797277536316664204 },
	{ 0.99810575860428740746, 0.00071541712105237741624, 0.99797312959595463333 },
	{ 0.99810606685089986456, 0.00071529690086805130297, 0.99797345050736219196 },
	{ 0.99810638530182738126, 0.00071518383324109795901, 0.99797380130692259215 },
	{ 0.9981066489546286391, 0.00071505937874280685058, 0.99797408132477516407 },
	{ 0.99810699563431604098, 0.00071494707405530665695, 0.99797444753571262765 },
	{ 0.9981072967474445834, 0.00071483146965467200557, 0.99797477916641930129 },
	{ 0.99810760470795456545, 0.0007147091323133632863, 0.99797509277268126038 },
	{ 0.99810789420533008176, 0.00071459167778455449059, 0.99797540988846489274 },
	{ 0.99810823123383340949, 0.00071448093712293348281, 0.99797577697678252484 },
	{ 0.99810853227066809179, 0.00071436235725843156685, 0.99797609914703999667 },
	{ 0.99810883922028337256, 0.00071424572288953508663, 0.99797643154068604865 },
	{ 0.9981091408483960814, 0.00071412712395154678228, 0.9979767551414548965 },
	{ 0.99810946052002702533, 0.00071401039421521857696, 0.99797708915634730786 },
	{ 0.99810978995728294461, 0.00071389763176404668829, 0.99797744270248978093 },
	{ 0.99811008643555432229, 0.00071377846062146846698, 0.99797775688095635704 },
	{ 0.99811038131165286114, 0.00071365890800916377892, 0.99797806976242586785 },
	{ 0.99811069520401740629, 0.00071354563057386103005, 0.99797841463013214902 },
	{ 0.99811100182938361502, 0.00071342562019788443011, 0.997978730410771675 },
	{ 0.9981113214628676289, 0.00071331175148450537589, 0.99797907522125739455 },
	{ 0.99811160737442761182, 0.00071319437324964202532, 0.99797939027710447224 },
	{ 0.99811195548462650073, 0.00071308212578260099686, 0.99797975715561404453 },
	{ 0.99811224212097904296, 0.00071296242058240574379, 0.99798006668015004639 },
	{ 0.99811254699158458159, 0.00071284614860974934193, 0.99798038986130233052 },
	{ 0.99811283660340077706, 0.00071272865593396809471, 0.9979807069389389218 },
	{ 0.99811315774368991605, 0.00071261358559095036667, 0.99798104787750696598 },
	{ 0.9981134776442027734, 0.00071249952614270807907, 0.99798139112396677675 },
	{ 0.9981137793486095644, 0.00071238214790784483692, 0.99798171159668380703 },
	{ 0.998114065069434786, 0.0007122610694166337398, 0.99798201303406164353 },
	{ 0.99811438447403677543, 0.00071215093910657510049, 0.99798236967010878207 },
	{ 0.99811470055985218597, 0.000712033675312629755, 0.99798269903107050816 },
	{ 0.9981150037901379557, 0.00071191683113538365302, 0.99798302087707879693 },
	{ 0.99811534055161255097, 0.00071180406868421165593, 0.99798337869568221059 },
	{ 0.99811561923432123855, 0.00071168720543347916557, 0.99798368862076136665 },
	{ 0.99811591405319943782, 0.00071156694710218038394, 0.9979839933578522615 },
	{ 0.99811624951767696778, 0.00071145258247815696632, 0.99798434423370674384 },
	{ 0.99811653790879018011, 0.00071133692085706304135, 0.99798466375274952345 },
	{ 0.99811685361313595699, 0.00071122110664807855138, 0.99798499441070842586 },
	{ 0.99811714744019286449, 0.00071110573112927969331, 0.997985319556429884 },
	{ 0.99811746619629626576, 0.00071098991692029520333, 0.99798565265579497474 },
	{ 0.99811775386261714083, 0.00071087230980359584261, 0.99798596626205682281 },
	{ 0.99811806933808100428, 0.00071075840294324422845, 0.99798630142135857923 },
	{ 0.99811839223313114644, 0.00071064428627454310095, 0.99798664720459218103 },
	{ 0.99811867131638298822, 0.00071052328407727734054, 0.99798693971557828064 },
	{ 0.99811900044846313396, 0.00071041143715344916721, 0.99798729295654509119 },
	{ 0.99811929278778821484, 0.00071029693901502124771, 0.9979876140586871891 },
	{ 0.99811960297989621438, 0.00071018198311292141632, 0.99798794824524106328 },
	{ 0.99811990016388674185, 0.00071006386101209130381, 0.99798826118393113571 },
	{ 0.99812020364212761248, 0.00070994680702649558008, 0.99798858003540191763 },
	{ 0.99812051045822880457, 0.00070983171760999157207, 0.9979889087478652776 },
	{ 0.99812080329346442031, 0.00070971897423230607179, 0.99798923835678232663 },
	{ 0.9981211374037245454, 0.00070960649788342892476, 0.997989587840272252 },
	{ 0.99812144387650292288, 0.00070949045479260853305, 0.99798991231842160143 },
	{ 0.99812172501969143035, 0.00070936998665296002124, 0.99799020780487157634 },
	{ 0.99812203231262952574, 0.00070925564110242266674, 0.9979905406181345251 },
	{ 0.99812237168717188318, 0.00070914789497815498669, 0.99799091100616543759 },
	{ 0.99812262587952416126, 0.00070902351677380932339, 0.9979911771003731058 },
	{ 0.99812295678543849764, 0.00070891222298108467863, 0.99799153055114819821 },
	{ 0.99812324742722313697, 0.00070879431068860418788, 0.99799183874054009369 },
	{ 0.99812354390549473671, 0.00070867666542493226722, 0.99799215230865523374 },
	{ 0.99812386445450584915, 0.00070856523811780333742, 0.99799249727172878455 },
	{ 0.99812413667130261974, 0.00070844682991467815801, 0.99799279634399429284 },
	{ 0.99812446580338276547, 0.00070833467781506874623, 0.99799314287109386346 },
	{ 0.9981247873442152807, 0.0007082238608595021849, 0.9979934932510375889 },
	{ 0.99812508155274204391, 0.00070810764610730494821, 0.99799380523605329962 },
	{ 0.99812537557053382375, 0.00070798971474133817749, 0.99799411443634011842 },
	{ 0.99812567826676190652, 0.00070787775337659199909, 0.99799444757385225024 },
	{ 0.99812598328995538743, 0.00070775980293713883999, 0.99799476510925255734 },
	{ 0.99812629250931572678, 0.00070764574348889633555, 0.99799509462280222571 },
	{ 0.99812659387039981418, 0.00070753267586194320844, 0.99799542253417905524 },
	{ 0.99812689315247382638, 0.00070741718590222634529, 0.99799574161453175059 },
	{ 0.9981271880667194063, 0.00070730034172498002648, 0.99799605400009083755 },
	{ 0.99812749102997633255, 0.00070718750297986269267, 0.99799638580245886299 },
	{ 0.99812780879425866409, 0.00070707557976208907421, 0.99799672431869412836 },
	{ 0.99812812846588960802, 0.00070696312248669831556, 0.99799706565780543777 },
	{ 0.99812843936371686837, 0.00070685058891736211178, 0.99799739913864027319 },
	{ 0.99812871684479609335, 0.00070673225700818237752, 0.99799769645614511138 },
	{ 0.99812902217316534781, 0.00070661430656872921841, 0.99799800910873304183 },
	{ 0.99812933028626360521, 0.00070650409996472513397, 0.99799834781570317954 },
	{ 0.9981296265738003326, 0.00070638962089978360286, 0.99799866676254145315 },
	{ 0.9981299418394559142, 0.00070627523720227368843, 0.99799899999542096563 },
	{ 0.99813023045945103995, 0.00070616056740246881552, 0.99799931272430275619 },
	{ 0.99813054648804611091, 0.00070604927360974406234, 0.99799965442581017872 },
	{ 0.99813083907532640371, 0.00070593139946423623995, 0.99799995998306112455 },
	{ 0.99813113696503585892, 0.00070581669151745869868, 0.99800027725143269919 },
	{ 0.9981314275686735682, 0.00070570202171765404262, 0.99800059272689645162 },
	{ 0.99813175603318171625, 0.00070559160530530055325, 0.99800094175262266116 },
	{ 0.99813204183030102001, 0.00070547670662365977862, 0.99800125623626523286 },
	{ 0.99813234166550612869, 0.00070536211311780035085, 0.99800157041473203101 },
	{ 0.99813264813828439515, 0.00070524591743908928571, 0.99800189016265683506 },
	{ 0.99813293645310363633, 0.00070513216316662823656, 0.99800220502776904041 },
	{ 0.99813325402665098451, 0.00070502264320813218257, 0.99800255296630657753 },
	{ 0.99813355233597722549, 0.00070490957558117905545, 0.9980028738586405046 },
	{ 0.99813384637284230383, 0.00070479284584485085013, 0.99800318345947036658 },
	{ 0.99813416024613332844, 0.00070467947304211648457, 0.99800351381225338443 },
	{ 0.99813445794510791131, 0.00070456548988781953369, 0.99800383287353267026 },
	{ 0.9981347617857451171, 0.00070445154488049514276, 0.99800415563506827965 },
	{ 0.99813505662369672589, 0.00070433874428235058573, 0.99800447549743387388 },
	{ 0.9981353441946502203, 0.00070422256767712590898, 0.99800478122634617151 },
	{ 0.99813564185547776209, 0.00070410923302136410335, 0.9980051022331211108 },
	{ 0.99813595767426444016, 0.00070399612724743819946, 0.99800543239516936733 },
	{ 0.99813625735688160656, 0.00070388077080212572978, 0.99800574550552068054 },
	{ 0.99813656314301446582, 0.00070377029716931318367, 0.99800608425063785933 },
	{ 0.99813685573029475862, 0.00070365761101208641488, 0.99800640109939275924 },
	{ 0.99813716763901672024, 0.00070354574501477174474, 0.99800673547668150576 },
	{ 0.99813746533799130312, 0.00070343054115734984007, 0.99800704507751147876 },
	{ 0.998137738565682886, 0.0007033130675550547644, 0.99800733867568636182 },
	{ 0.99813807303833912421, 0.00070320808708630472717, 0.99800770732803001373 },
	{ 0.99813834071564622175, 0.00070308986961804278114, 0.99800799331588385677 },
	{ 0.99813863688874182589, 0.00070297558128796470023, 0.99800830688399910784 },
	{ 0.99813894141602443888, 0.00070286255180798413306, 0.99800863048476817774 },
	{ 0.99813925353455479339, 0.00070275017082653881955, 0.99800896671218508605 },
	{ 0.99813956069397857807, 0.00070264320671521056979, 0.99800930377883534383 },
	{ 0.99813985654282499915, 0.00070252352058850137985, 0.99800960241241076787 },
	{ 0.99814016599106714089, 0.00070241670906506391194, 0.99800994604034032331 },
	{ 0.99814043828415788262, 0.00070229959785900902304, 0.99801023786468101573 },
	{ 0.99814075549530889564, 0.00070218811333142103649, 0.99801057426375938686 },
	{ 0.99814105138230224679, 0.00070207426369152826223, 0.99801089067382398046 },
	{ 0.99814134320664316125, 0.00070196127235852036341, 0.9980112029449420552 },
	{ 0.99814163339066419578, 0.00070184587776623522538, 0.99801151121062792182 },
	{ 0.99814191993164924632, 0.00070173202812634255954, 0.9980118208686782344 },
	{ 0.9981422437422267091, 0.00070162325203381315907, 0.99801216554564942118 },
	{ 0.99814253613877201854, 0.00070150823891125448778, 0.99801247411651106134 },
	{ 0.99814286771225846362, 0.00070140157997570758489, 0.99801283376616922727 },
	{ 0.99814313323426151481, 0.00070128223717175262701, 0.99801310886306249248 },
	{ 0.99814341941285034121, 0.00070117077171765102885, 0.99801342830581141197 },
	{ 0.99814372159409425755, 0.00070105795204602019185, 0.99801374769133988085 },
	{ 0.99814402364182386318, 0.00070094709694348107058, 0.99801407491607119216 },
	{ 0.99814430962967781724, 0.00070083254158459420274, 0.99801437822265071098 },
	{ 0.99814463918137463772, 0.00070072439491711366755, 0.99801472684783376632 },
	{ 0.99814491937088878348, 0.00070060961067639078957, 0.9980150292388858535 },
	{ 0.99814522889542500739, 0.00070049921333752358018, 0.9980153622619569731 },
	{ 0.99814552766251485316, 0.00070038782417736721031, 0.99801568239135152183 },
	{ 0.99814582284378927657, 0.00070027559578381246182, 0.99801599801940310552 },
	{ 0.99814609937119402883, 0.00070016020119152721536, 0.99801629476470332669 },
	{ 0.99814639283585449014, 0.00070004450142346073046, 0.99801660211486198371 },
	{ 0.99814669022965329948, 0.00069993204414806997182, 0.99801691781920753854 },
	{ 0.99814699035096055013, 0.00069982166588268904239, 0.99801724391860324737 },
	{ 0.99814729129242785177, 0.00069970894157848971366, 0.99801756011885944808 },
	{ 0.99814758786606672114, 0.0006995985251661362243, 0.99801788324279117059 },
	{ 0.99814786698746560401, 0.00069948389351330401975, 0.99801817945403381582 },
	{ 0.99814817815232170783, 0.00069937444984875319406, 0.99801851632994931229 },
	{ 0.99814845759796977376, 0.00069925854027233697897, 0.99801881175917894762 },
	{ 0.9981487498037804329, 0.00069914272606335259742, 0.9980191146461417917 },
	{ 0.99814907443451783564, 0.00069903919517956330729, 0.99801947009963287716 },
	{ 0.99814935983109365214, 0.00069892538368664330981, 0.9980197805587698312 },
	{ 0.99814965012955558787, 0.00069881285011730721445, 0.99802008672637221309 },
	{ 0.99814993424820797063, 0.0006986984091993383517, 0.9980203885452199053 },
	{ 0.99815025517868904981, 0.00069859262764416238736, 0.99802074022216080706 },
	{ 0.99815054463791763606, 0.00069847589790783418204, 0.99802103547972909059 },
	{ 0.99815083510804092359, 0.0006983679610487031602, 0.99802136356276727192 },
	{ 0.99815112533020888819, 0.00069825474083385935965, 0.99802167087477888785 },
	{ 0.99815145272660166231, 0.000698149054646115012, 0.99802202173155962761 },
	{ 0.99815174260544692331, 0.00069803442299328291587, 0.99802232244414490481 },
	{ 0.99815201777863427068, 0.0006979219084974332089, 0.99802263008040581482 },
	{ 0.99815230296540191635, 0.00069780639946422995737, 0.99802292625350141897 },
	{ 0.99815259364533370778, 0.00069769638359508932314, 0.9980232453147807048 },
	{ 0.99815290286469404712, 0.00069758476555309715996, 0.99802356735152364386 },
	{ 0.99815320790696082653, 0.00069747904121838025238, 0.99802390355986703163 },
	{ 0.99815349568772249178, 0.00069736398994884902115, 0.99802420293730820244 },
	{ 0.99815377814698147407, 0.00069725181877575322098, 0.99802451072615705474 },
	{ 0.99815408738541522293, 0.00069714151680431762827, 0.99802484109801359313 },
	{ 0.99815439555573381991, 0.0006970317870374718441, 0.99802516361159387959 },
	{ 0.99815467030930449255, 0.00069691759407482527146, 0.99802545980376289325 },
	{ 0.99815495400834020057, 0.00069680448830089936757, 0.99802576150816957323 },
	{ 0.99815527696061079332, 0.00069669714271984465107, 0.99802610475462949502 },
	{ 0.99815555940079625508, 0.00069658590614757906305, 0.99802641282958060032 },
	{ 0.99815582984375883502, 0.00069647316276989356277, 0.99802670974654217328 },
	{ 0.99815614093232096771, 0.00069636371910534262866, 0.99802703807753567755 },
	{ 0.99815644526886881938, 0.00069625347435436587586, 0.99802736194533336889 },
	{ 0.9981566941397184145, 0.0006961352187391314783, 0.99802762912672982054 },
	{ 0.99815702399659100852, 0.00069602989494762742585, 0.99802797859114633638 },
	{ 0.9981573260824675442, 0.00069591953575573288482, 0.99802830036086054299 },
	{ 0.99815761611390074748, 0.00069580971062145548396, 0.99802861465376813133 },
	{ 0.99815789702820734153, 0.00069569542229137740306, 0.99802891113203950901 },
	{ 0.99815818482804263834, 0.00069558668434582067094, 0.99802922635954793851 },
	{ 0.99815850325989685654, 0.00069547783195934604217, 0.99802956436079914848 },
	{ 0.99815878878998731683, 0.00069536587059459975535, 0.99802986987990316425 },
	{ 0.99815907800126046912, 0.00069525739967785170174, 0.99803018609923299653 },
	{ 0.99815936171936969767, 0.00069514175713024427359, 0.99803047885817453011 },
	{ 0.99815965020585040168, 0.00069503080666027342721, 0.99803078657072930024 },
	{ 0.99815993272233005662, 0.00069491857826671867872, 0.99803109243315590859 },
	{ 0.99816027265000339952, 0.00069481790840587875652, 0.99803146310728907409 },
	{ 0.99816056214737891583, 0.00069470388710460902887, 0.9980317614547621341 },
	{ 0.99816083089280127627, 0.00069459055244884733166, 0.99803205072325573699 },
	{ 0.99816114596772176348, 0.00069448593437633737279, 0.99803239715498792695 },
	{ 0.99816142962861054144, 0.0006943713408704778366, 0.99803269271773198401 },
	{ 0.99816172751831999665, 0.00069426395714245034332, 0.99803301898878904463 },
	{ 0.998162020410776063, 0.00069415142357311424796, 0.9980333242408641059 },
	{ 0.99816229918885224226, 0.0006940401870008484431, 0.99803362224501435129 },
	{ 0.99816258468079555044, 0.00069392986595592646201, 0.99803393367689907656 },
	{ 0.99816286612915983145, 0.00069381595909557473943, 0.99803422977370082059 },
	{ 0.99816318240571011433, 0.0006937077361341487591, 0.99803456169050996927 },
	{ 0.99816345548081397698, 0.0006935985404249201151, 0.99803486383360695555 },
	{ 0.99816373410630232499, 0.00069348837196788869902, 0.99803517236632166565 },
	{ 0.99816401296067247539, 0.00069337400734386517298, 0.99803545503538904082 },
	{ 0.99816432561326029482, 0.00069326643288097455475, 0.99803579088133620445 },
	{ 0.99816462148118023645, 0.00069315519630870885831, 0.99803610048216606643 },
	{ 0.99816489774155614523, 0.0006930452567335135608, 0.9980364074127080487 },
	{ 0.99816518918442731501, 0.00069293447792491977624, 0.99803671350401645945 },
	{ 0.99816548163819329709, 0.00069282501518688256216, 0.99803702575606101366 },
	{ 0.99816579879212385951, 0.00069271751701793728064, 0.99803735999983522742 },
	{ 0.99816608624863634169, 0.00069260866463146254345, 0.99803767366331774813 },
	{ 0.99816637322831169854, 0.00069249761879405997197, 0.99803797712248509821 },
	{ 0.99816664224076279144, 0.00069238516151866921332, 0.99803827176970183466 },
	{ 0.99816695271897337705, 0.00069227861702404009867, 0.99803859994810761869 },
	{ 0.99816725423264529571, 0.00069217241585216510765, 0.99803893320006076273 },
	{ 0.99816751986908935912, 0.00069205982506237006396, 0.99803921802443196221 },
	{ 0.99816782849717167192, 0.00069195116341075866857, 0.99803953962248481702 },
	{ 0.99816810538697275934, 0.00069183830559215505479, 0.99803983329695389326 },
	{ 0.99816839631485987372, 0.00069173033058605158142, 0.99804015176695515255 },
	{ 0.9981687066786294471, 0.00069162504494152030575, 0.99804048776549025845 },
	{ 0.99816898663926190149, 0.00069151285469493822562, 0.99804078069609314383 },
	{ 0.99816927293229185114, 0.00069140119850597328566, 0.99804108392637858049 },
	{ 0.99816955411362728867, 0.00069129251778087571871, 0.99804139234465250041 },
	{ 0.99816983630585731646, 0.00069118175804576832254, 0.99804169025343525412 },
	{ 0.9981701294844156358, 0.00069107008278331710262, 0.99804199430388074177 },
	{ 0.99817045762467448977, 0.00069096700966319983279, 0.9980423473159656389 },
	{ 0.99817072059083056246, 0.00069085258781871735842, 0.99804262252729969429 },
	{ 0.99817101230073035367, 0.00069074642479381503576, 0.99804294536512927483 },
	{ 0.9981712938253884948, 0.00069063518822154944775, 0.99804324336927952022 },
	{ 0.99817156926560457464, 0.00069052477180919584997, 0.9980435395614486449 },
	{ 0.9981718595640666214, 0.0006904157477613442678, 0.99804385152739094611 },
	{ 0.99817215497422295822, 0.00069030588448009409016, 0.99804416158598463493 },
	{ 0.99817247464585390215, 0.00069020258247814081018, 0.99804450750273254744 },
	{ 0.99817272660660838479, 0.00069008970558605080801, 0.99804478540342822512 },
	{ 0.99817303609299767864, 0.0006899820166822421847, 0.99804510648649702453 },
	{ 0.99817330987382046903, 0.00068987577736339441691, 0.99804541810911662214 },
	{ 0.99817361529755710414, 0.00068976326286754460152, 0.99804572505873212496 },
	{ 0.99817389605927586693, 0.00068965828239879445587, 0.99804604000013830145 },
	{ 0.99817418643403177381, 0.00068954887688121619012, 0.99804634899061672737 },
	{ 0.99817447572159900826, 0.00068943964302501509461, 0.99804665708464146423 },
	{ 0.99817474471497658062, 0.00068932648003063013396, 0.99804694015425210463 },
	{ 0.99817502555298920353, 0.000689216235279653598, 0.99804723945539952634 },
	{ 0.99817532172608502972, 0.00068911110222301277892, 0.99804756492537016754 },
	{ 0.99817562568116324773, 0.00068900490105113767949, 0.99804788597029192587 },
	{ 0.99817591866898669473, 0.00068889570534190892707, 0.99804819765013186306 },
	{ 0.99817620889115465932, 0.0006887885886426901123, 0.99804851289671381309 },
	{ 0.99817648208069942317, 0.0006886775618787739292, 0.99804880287092634372 },
	{ 0.99817676818299438946, 0.00068856632530650834119, 0.99804909812849462725 },
	{ 0.99817706736970102099, 0.00068846275627574659954, 0.99804943172377036387 },
	{ 0.99817735595154910566, 0.0006883548384901020745, 0.99804973945539865454 },
	{ 0.99817763129639780484, 0.00068824093162975035192, 0.9980500236503447864 },
	{ 0.99817789973664439174, 0.00068812988579234788886, 0.99805031284254452917 },
	{ 0.99817821261811401357, 0.00068802589714488690369, 0.99805064922254926874 },
	{ 0.99817849120545532049, 0.00068791569054088292767, 0.99805094543379191396 },
	{ 0.99817876412797124086, 0.00068780786812266991089, 0.99805124505918851874 },
	{ 0.9981790621321217083, 0.00068769998848399783737, 0.99805155923765531689 },
	{ 0.99817937722611593809, 0.00068759638130626331894, 0.99805189966123919465 },
	{ 0.99817963960099387322, 0.00068748338997325542012, 0.99805217500608767178 },
	{ 0.99817990271973777716, 0.00068737198173961266186, 0.99805245849531476487 },
	{ 0.99818021533417877755, 0.00068726955711803053729, 0.99805279933851531737 },
	{ 0.99818049136567288393, 0.00068715984642467092466, 0.99805309368055616925 },
	{ 0.99818078227448625572, 0.00068705311119517868505, 0.9980534057990861907 },
	{ 0.99818108294892460286, 0.00068694759666881139923, 0.99805373180311451886 },
	{ 0.99818135421204734481, 0.0006868334990735965517, 0.99805400855940118454 },
	{ 0.99818164248871976696, 0.0006867268019910767636, 0.99805432109754810277 },
	{ 0.99818191760468655271, 0.00068661526024302993714, 0.99805460842054616322 },
	{ 0.99818221103120019499, 0.00068651043236217046493, 0.99805492626112224386 },
	{ 0.99818249791550817118, 0.00068639936745128172189, 0.99805522340696573025 },
	{ 0.99818279605317283831, 0.00068629810631236560278, 0.99805555679243307399 },
	{ 0.99818306109833887518, 0.00068618717491588114479, 0.99805583892744265118 },
	{ 0.99818334792542628975, 0.00068607864677867403443, 0.9980561424629039724 },
	{ 0.99818362327027498893, 0.00068597084343394740605, 0.99805644664686388179 },
	{ 0.99818392035889802472, 0.00068586113274058801027, 0.99805674800794785817 },
	{ 0.99818420051026535145, 0.00068575432121715032552, 0.99805705379408049538 },
	{ 0.99818450148987958315, 0.00068565017998179866691, 0.99805737979810882354 },
	{ 0.99818476384568399773, 0.00068553919136485536902, 0.99805765874784624359 },
	{ 0.99818507270264822395, 0.00068543274223765808788, 0.99805798381727350854 },
	{ 0.99818536485123832147, 0.00068532720863780441367, 0.99805829862516515227 },
	{ 0.99818563531327442195, 0.00068521604835948405395, 0.99805858358305066247 },
	{ 0.99818592206406775436, 0.00068511102974376113153, 0.99805889779966439068 },
	{ 0.99818619138169473182, 0.00068500162422618286577, 0.99805918451231090405 },
	{ 0.998186496023418246, 0.00068489809334239368406, 0.99805951463621223052 },
	{ 0.99818676183152366121, 0.0006847836524244248213, 0.99805978654783322757 },
	{ 0.9981870511000172641, 0.00068468122780284269673, 0.99806010969083847062 },
	{ 0.99818733033585715919, 0.00068457411110362388195, 0.99806040967863129953 },
	{ 0.9981876113264578354, 0.00068446401894053791101, 0.9980607039443782913 },
	{ 0.99818790927338785224, 0.00068436226189097721165, 0.99806103023450887246 },
	{ 0.99818817599702058807, 0.00068425300896128972775, 0.99806132259290725184 },
	{ 0.9981884413473625095, 0.00068414207756480526976, 0.9980615983192256957 },
	{ 0.99818875569749077048, 0.00068404001533946344037, 0.99806193784635577337 },
	{ 0.99818903863358698914, 0.00068393209755381880691, 0.99806223695676843377 },
	{ 0.99818932731080256548, 0.00068382133781871119391, 0.99806253284376178492 },
	{ 0.99818960555482116881, 0.00068371551811656277806, 0.99806283702772158328 },
	{ 0.99818990085053649342, 0.00068361110985240254936, 0.99806315391462341324 },
	{ 0.99819014853882992444, 0.00068349937736949227269, 0.99806342182081231318 },
	{ 0.99819045356202329433, 0.00068339454948863269206, 0.9980637466804314073 },
	{ 0.99819071261811465057, 0.00068328304588755842553, 0.99806401679914469316 },
	{ 0.99819102229523859471, 0.00068318348228892545205, 0.99806436309736246137 },
	{ 0.9981912820761222882, 0.0006830721694227144189, 0.99806463767927167119 },
	{ 0.99819157859254070697, 0.00068296608269175732454, 0.99806495113294613208 },
	{ 0.99819186131882842172, 0.00068285848915538031791, 0.99806524682920461089 },
	{ 0.9981921536772268011, 0.00068275289833506758695, 0.9980655611602592403 },
	{ 0.99819240949082532754, 0.00068264631569346591235, 0.99806584916990281897 },
	{ 0.99819272250580937111, 0.00068254215538462786536, 0.99806617603223801716 },
	{ 0.99819300149369383224, 0.00068243559181651247073, 0.99806647573392848205 },
	{ 0.99819328639435911388, 0.00068232990562876812309, 0.99806678245466196042 },
	{ 0.99819357037949696387, 0.00068222353279551617867, 0.99806708581846192985 },
	{ 0.99819383267808081683, 0.00068211351692637543602, 0.99806736490171377163 },
	{ 0.99819412766862025688, 0.00068200880348643386046, 0.99806768117826383246 },
	{ 0.99819443173813937609, 0.00068190569221934392227, 0.99806800439756315768 },
	{ 0.99819468709397429773, 0.00068179514229258614787, 0.99806827546995080525 },
	{ 0.99819496877122038114, 0.00068169229805430488819, 0.9980685901061812082 },
	{ 0.99819526534485902847, 0.00068158111870249803166, 0.99806888484876543632 },
	{ 0.99819552077698792125, 0.00068147339165171673999, 0.99806916530530831455 },
	{ 0.99819580279755681929, 0.00068136783897837667739, 0.99806947242658505814 },
	{ 0.99819610946106995808, 0.00068126503288706786923, 0.99806979778211468712 },
	{ 0.99819635886597724017, 0.0006811558562513255052, 0.99807006870191428138 },
	{ 0.99819664596009349822, 0.00068104973137339563406, 0.99807037792127439868 },
	{ 0.99819694732117736358, 0.00068094490349253616185, 0.99807069148938953873 },
	{ 0.99819720742631046217, 0.00068083589851817085965, 0.99807097318570903166 },
	{ 0.99819749703812687969, 0.00068073305427988949155, 0.99807128782193932359 },
	{ 0.99819779324936963594, 0.00068062872230967459957, 0.99807160341184408825 },
	{ 0.99819805028367147859, 0.0006805186301465885202, 0.99807187585752266124 },
	{ 0.9981983164350995974, 0.00068041010200938140985, 0.99807216009061583417 },
	{ 0.99819863191056346086, 0.00068030977547129528604, 0.99807249921720275765 },
	{ 0.99819888377595056284, 0.00068020096123179332563, 0.9980727738944792371 },
	{ 0.99819916652131179813, 0.00068009674370249633031, 0.99807308135907890634 },
	{ 0.9981994730703839247, 0.00067999161064585561965, 0.99807339645307313614 },
	{ 0.99819975108552072562, 0.00067988510429819928177, 0.99807369338910811862 },
	{ 0.99820001553940873595, 0.00067977655708750578303, 0.99807397661130659028 },
	{ 0.99820030486512267842, 0.00067967083275278876702, 0.99807428493421290749 },
	{ 0.9982005729048260001, 0.0006795655661817436629, 0.99807457517545417058 },
	{ 0.99820085521149704011, 0.00067946037590464389549, 0.99807487796704952299 },
	{ 0.99820116233277389473, 0.00067936115562876493723, 0.99807521125714948607 },
	{ 0.99820141356873570704, 0.0006792480117078664734, 0.998075472411324216 },
	{ 0.99820170482087189345, 0.00067914360344370602787, 0.99807578197400736997 },
	{ 0.99820198014664707209, 0.00067903711616953586153, 0.99807607587735802657 },
	{ 0.99820225499558490334, 0.0006789342337842819335, 0.99807637910764346323 },
	{ 0.99820253459382102257, 0.00067882271110972127858, 0.99807666023175845016 },
	{ 0.99820278895783465245, 0.0006787175780530804595, 0.99807694358747123253 },
	{ 0.9982030850546365075, 0.00067861145317515058836, 0.99807725540082559146 },
	{ 0.99820337619233179272, 0.00067850952446421304402, 0.99807756851117712671 },
	{ 0.99820367217469274657, 0.00067840656578501377927, 0.99807788761060334259 },
	{ 0.99820394351410934863, 0.00067830391228159564454, 0.99807818603437037375 },
	{ 0.9982042084448344843, 0.00067819561302622454434, 0.99807846675794209546 },
	{ 0.99820449714112347017, 0.0006780900222059119218, 0.99807877376477793785 },
	{ 0.99820476769852695131, 0.00067798334419687873893, 0.99807905973355837137 },
	{ 0.99820503198075349882, 0.0006778765326734411626, 0.99807934354703475854 },
	{ 0.99820531136918133619, 0.00067777353584726922949, 0.99807965070645854322 },
	{ 0.99820562436509197024, 0.00067767065346201508461, 0.99807997720639751726 },
	{ 0.99820587500977575601, 0.00067756099998911452874, 0.99808024475018997101 },
	{ 0.99820614985871380931, 0.00067745666801889963676, 0.99808054111402055852 },
	{ 0.99820642428803507684, 0.00067735359489878247535, 0.99808084392468932045 },
	{ 0.99820671435761509915, 0.0006772460204358917487, 0.9980811413184882408 },
	{ 0.99820699466157036817, 0.00067714393913706353093, 0.99808144725720882029 },
	{ 0.99820727130341602162, 0.00067703850090464158182, 0.99808174251477721484 },
	{ 0.99820754247117116087, 0.00067693369209726849799, 0.99808203664700978486 },
	{ 0.99820782082963066539, 0.00067682775795420196865, 0.9980823318664310273 },
	{ 0.99820810075211596768, 0.00067672178566416266252, 0.99808262414853543554 },
	{ 0.99820838849473070287, 0.00067662012398203357985, 0.99808293783109136577 },
	{ 0.9982086478941447627, 0.00067651209175547104974, 0.99808321676175537629 },
	{ 0.99820892222809864958, 0.00067640682518442605403, 0.99808350814740598445 },
	{ 0.99820923058915200787, 0.00067630697548349823049, 0.99808383649747300925 },
	{ 0.99820950520920814775, 0.00067620157539804884132, 0.99808412813107905137 },
	{ 0.9982097652952677258, 0.00067609377205332232136, 0.99808440744321269555 },
	{ 0.9982100328962808522, 0.00067599020302256047129, 0.99808470220487044422 },
	{ 0.99821031440186547279, 0.00067588337242563650657, 0.99808499244611204038 },
	{ 0.99821057963776649302, 0.00067577881157358560445, 0.99808528316419053983 },
	{ 0.99821088044571937292, 0.00067567739784677892032, 0.99808560594479978079 },
	{ 0.9982111546652323586, 0.00067557182609995268616, 0.99808589702527450438 },
	{ 0.99821142527985651238, 0.00067546707451303844225, 0.99808618701856044453 },
	{ 0.99821172240662647823, 0.00067536838829477662417, 0.99808651222150213123 },
	{ 0.99821195523667416438, 0.00067525366127451291135, 0.99808674993436219403 },
	{ 0.99821222087311822779, 0.00067514900505503028412, 0.99808703773419749083 },
	{ 0.99821251784730036238, 0.00067504764854868265674, 0.99808735843579676761 },
	{ 0.99821282142090883571, 0.00067494411766489358345, 0.99808766658704184405 },
	{ 0.99821308135438058251, 0.00067483814537485438574, 0.99808794864575756112 },
	{ 0.99821336066651433772, 0.00067473537743051846278, 0.9980882517616022076 },
	{ 0.99821363059449286226, 0.00067462871849497134304, 0.99808853542249076352 },
	{ 0.99821391906190015675, 0.00067452793419321341577, 0.99808884891431204345 },
	{ 0.9982141687338361713, 0.00067442253410776391818, 0.99808912612836220291 },
	{ 0.99821444919037916055, 0.00067431724846323264251, 0.99808942123334254415 },
	{ 0.99821473523545356521, 0.00067421510994394547641, 0.99808972570340470654 },
	{ 0.99821499305176819572, 0.00067410774528940437152, 0.99808999797742203874 },
	{ 0.9982152761023054266, 0.00067400718986948234598, 0.99809031307141615752 },
	{ 0.99821557361054513713, 0.00067390446007211887453, 0.99809062400739045895 },
	{ 0.9982158320181379052, 0.00067379970848520463061, 0.9980909036246999877 },
	{ 0.99821609294343072172, 0.00067369198143442333895, 0.99809118041913347241 },
	{ 0.99821637141633123846, 0.00067359081566293883651, 0.99809148208539322233 },
	{ 0.99821665423798655592, 0.00067348774254282156668, 0.99809178657452912731 },
	{ 0.99821694369721514217, 0.00067338627159555571738, 0.99809209190289838176 },
	{ 0.99821719623017413081, 0.00067327869713266499073, 0.99809236396710721007 },
	{ 0.99821746676850431346, 0.00067317447960336799541, 0.99809265800397251045 },
	{ 0.99821777392792820915, 0.00067307606041391485584, 0.99809298561017378848 },
	{ 0.99821803183961033135, 0.00067296860039194224268, 0.99809325382153846196 },
	{ 0.99821830155778057403, 0.00067286650001962774494, 0.99809355192105619903 },
	{ 0.99821858369279048429, 0.0006727589255567371267, 0.99809383466641765636 },
	{ 0.99821883416581291826, 0.00067265203773935421366, 0.99809410573880519291 },
	{ 0.99821914893555774295, 0.00067255825340707870753, 0.99809445526044204833 },
	{ 0.9982193984930528563, 0.00067244907677133645193, 0.99809471778790770369 },
	{ 0.99821966109681259383, 0.0006723436385389143944, 0.99809499870221429774 },
	{ 0.99821994159150262416, 0.00067224273979623846206, 0.99809529888074211001 },
	{ 0.99822021506714964101, 0.0006721392470594219487, 0.99809559448163309714 },
	{ 0.99822050673890272421, 0.00067203556358774220198, 0.99809589393536857216 },
	{ 0.99822076793122449523, 0.00067193199455698024349, 0.99809618091504381798 },
	{ 0.99822103492188618556, 0.00067182842552621839342, 0.99809646751324931913 },
	{ 0.99822132007050667912, 0.00067172600090463626885, 0.99809676982800765721 },
	{ 0.99822159583497205304, 0.00067162334740121824254, 0.99809706848065649076 },
	{ 0.99822186877656138293, 0.00067152138054330792142, 0.99809736484448707827 },
	{ 0.99822213046479379983, 0.0006714147216077609101, 0.99809763812939922278 },
	{ 0.99822239722657368777, 0.00067130970299203820452, 0.99809792243878625584 },
	{ 0.99822269357133064371, 0.00067120958626230170247, 0.99809823793332352881 },
	{ 0.9982229577772633311, 0.00067110697090585612768, 0.99809852380673658168 },
	{ 0.99822321353364140695, 0.0006710042601819789362, 0.99809880809705020521 },
	{ 0.99822345687318003726, 0.00067089214622934208437, 0.9980990557090496651 },
	{ 0.99822378053116944674, 0.00067079634010751580577, 0.99809940015713927153 },
	{ 0.99822404595780511727, 0.00067069448769052348973, 0.99809969182889213268 },
	{ 0.99822431655335552847, 0.00067059097588022080483, 0.99809997890393487019 },
	{ 0.9982246125357163713, 0.00067049320518930281051, 0.99810030166547047958 },
	{ 0.99822484887528539765, 0.00067038271248300376759, 0.99810054876248566202 },
	{ 0.99822513465333106986, 0.00067028278648813071575, 0.9981008551398964368 },
	{ 0.99822538571763153037, 0.00067017874062021067384, 0.99810113058011240561 },
	{ 0.99822566113877420069, 0.0006700739127393510932, 0.99810141393582529901 },
	{ 0.99822594279694676356, 0.00066997448265512251318, 0.99810172492901994001 },
	{ 0.99822622714448105974, 0.00066987247765023952371, 0.99810202194134911569 },
	{ 0.99822649974274768603, 0.00066976848900277843012, 0.99810231239239877166 },
	{ 0.99822677007126936477, 0.00066966860115487793822, 0.99810261327664540065 },
	{ 0.99822704898285985475, 0.00066956611931283675689, 0.99810290592114625507 },
	{ 0.99822731181550139468, 0.00066946090996225070952, 0.99810318263928587967 },
	{ 0.99822759128022309216, 0.00066935921013314906691, 0.99810348163525741683 },
	{ 0.998227857431651322, 0.00066925503075082463152, 0.99810376281659296538 },
	{ 0.99822813395905618528, 0.00066915413200814859076, 0.9981040655128208261 },
	{ 0.99822840510773769296, 0.00066905052483041396391, 0.99810435222546733947 },
	{ 0.99822865672516924995, 0.00066894722282846068393, 0.99810462825696155686 },
	{ 0.99822892316269973279, 0.00066884317696054053359, 0.99810490873257795563 },
	{ 0.99822922696519000851, 0.00066874567329843110936, 0.99810523389737293432 },
	{ 0.99822948728013138897, 0.00066863916695077466306, 0.99810550336758774304 },
	{ 0.99822975682664005781, 0.0006685385352369073008, 0.99810579778592267708 },
	{ 0.99823002162385066072, 0.00066843727409799107327, 0.99810608756940033537 },
	{ 0.99823030944275936704, 0.00066833416283090113508, 0.99810638339917312489 },
	{ 0.99823056136536669758, 0.0006682345229383229333, 0.99810667255322571556 },
	{ 0.99823084371018488969, 0.0006681308966871021349, 0.99810696576993107598 },
	{ 0.99823110446381646543, 0.00066802681267220942463, 0.99810724510113846275 },
	{ 0.99823138720917792277, 0.00066792625725228750751, 0.99810754524151956701 },
	{ 0.99823165765214039169, 0.0006678265601392503574, 0.99810784006039776628 },
	{ 0.99823191131043498281, 0.00066772064506967021644, 0.9981081094733921244 },
	{ 0.99823218665528368199, 0.00066761635124642788441, 0.99810839061658074289 },
	{ 0.99823244697022506244, 0.0006675141173597089932, 0.99810867534558445069 },
	{ 0.9982327241270547713, 0.00066741476356942564148, 0.99810897680203591875 },
	{ 0.99823299546647126235, 0.00066731172859628114843, 0.99810926141659905841 },
	{ 0.99823326180863436452, 0.00066721247017342941339, 0.99810955644528531749 },
	{ 0.99823354154038501651, 0.00066710829079110508643, 0.99810984586636686267 },
	{ 0.99823379006791179702, 0.00066700319588143693571, 0.99811011239926472616 },
	{ 0.99823408877778119219, 0.00066690826713998192093, 0.9981104386131014472 },
	{ 0.99823434161591595437, 0.00066680221855599749493, 0.99811070182721284283 },
	{ 0.99823460902619420843, 0.00066670204460580215298, 0.99811099639813571915 },
	{ 0.99823488292145801104, 0.00066659996330697393521, 0.99811128372113389062 },
	{ 0.99823515628266412669, 0.00066650039970834096172, 0.99811158546368761169 },
	{ 0.99823543126511660173, 0.00066639742195565530858, 0.99811187093655773239 },
	{ 0.9982356880323896009, 0.00066629453957040127212, 0.99811214715878682213 },
	{ 0.99823595553803534663, 0.00066619507133919991532, 0.9981124422065468238 },
	{ 0.99823624789643383703, 0.00066609314262826226256, 0.99811274310986719538 },
	{ 0.99823649579453566094, 0.00066598989784676803933, 0.99811301149289322066 },
	{ 0.99823677743363492532, 0.00066588747322518580633, 0.99811330709378442982 },
	{ 0.99823702638077838056, 0.00066578607857186540217, 0.99811357953946311383 },
	{ 0.998237294553996235, 0.00066568208992440430858, 0.99811386175076688421 },
	{ 0.99823756951737530052, 0.00066558534920174792626, 0.9981141684524271751 },
	{ 0.99823785081315163925, 0.00066548563301522427934, 0.99811446409146531433 },
	{ 0.99823808576035621964, 0.0006653771811719625057, 0.9981147105590556512 },
	{ 0.99823836726594106228, 0.00066527927696664011792, 0.99811501521985290797 },
	{ 0.9982386207335010031, 0.00066517580330330988454, 0.99811528886716138764 },
	{ 0.99823889295029799573, 0.00066507448494393470867, 0.99811557573239595431 },
	{ 0.99823919753480128136, 0.00066497646629769453265, 0.9981158937446336088 },
	{ 0.99823942275452781647, 0.00066486721336800694033, 0.99811613361279771794 },
	{ 0.99823971621918861086, 0.00066477234184701087388, 0.99811645652692126962 },
	{ 0.99823998877930830709, 0.00066467373192269439252, 0.99811675159375479183 },
	{ 0.99824024230408869851, 0.00066456730186898328294, 0.99811701137463870737 },
	{ 0.99824053256440348214, 0.00066447349846322149684, 0.99811733650128664497 },
	{ 0.99824077876496519757, 0.00066436737358529173413, 0.99811759521405518658 },
	{ 0.99824107097077596773, 0.00066426773369271353235, 0.99811790023724855647 },
	{ 0.9982413046209833718, 0.00066416401207406100884, 0.9981181566993457821 },
	{ 0.99824159930634726035, 0.00066406708061654139315, 0.99811846984784446946 },
	{ 0.99824182553696849673, 0.00066395975410897295661, 0.99811871267239882233 },
	{ 0.99824212193894612533, 0.0006638623267408088691, 0.99811902830045051704 },
	{ 0.99824237107682445291, 0.00066375868141610157389, 0.99811929262082399461 },
	{ 0.99824264371323823131, 0.00066366136848885527461, 0.99811959455411281006 },
	{ 0.99824291673112153234, 0.00066356024086434333212, 0.99811988359372461055 },
	{ 0.99824316949296232337, 0.00066345548927742919662, 0.9981201479522451292 },
	{ 0.99824345191407459765, 0.00066335800468880616078, 0.99812044872205107904 },
	{ 0.99824370932984607396, 0.00066325348198372803543, 0.99812072170178745001 },
	{ 0.99824398518967871752, 0.00066315752327401130024, 0.99812102426450111103 },
	{ 0.99824426778245212155, 0.0006630555945630737559, 0.99812131174008722478 },
	{ 0.9982445235197568989, 0.00066295122444588619557, 0.99812158334653244829 },
	{ 0.9982447762053037188, 0.00066285478889901105169, 0.99812187021176668189 },
	{ 0.99824502801347037018, 0.00066275121986824920162, 0.99812213972012853169 },
	{ 0.99824532491135864465, 0.00066265726387459663368, 0.99812246477048260918 },
	{ 0.99824557614732056798, 0.00066254930794197922344, 0.99812271493832938063 },
	{ 0.99824584645676872618, 0.00066245279610115874284, 0.99812301530759206525 },
	{ 0.99824611619401237839, 0.00066235212624031892907, 0.99812329923550957567 },
	{ 0.99824640965867295073, 0.00066225557625252599696, 0.99812361680905703487 },
	{ 0.99824665139603863118, 0.0006621531516309439808, 0.9981238757125603378 },
	{ 0.99824692029404882287, 0.00066205301582772119878, 0.99812416673581472182 },
	{ 0.99824719552445662085, 0.00066195326149422510035, 0.99812445608060251789 },
	{ 0.99824742679047839822, 0.00066184917747933239007, 0.99812470619122872773 },
	{ 0.99824768901276850208, 0.00066174778282601198591, 0.99812498733441734622 },
	{ 0.99824796729493425751, 0.00066165100395638293523, 0.9981252894202938819 },
	{ 0.99824823264527617894, 0.00066155044853646090969, 0.99812557247083111278 },
	{ 0.99824851497102085052, 0.00066145168602425375489, 0.99812587287824083848 },
	{ 0.99824877047944382547, 0.00066135044395882380732, 0.99812614684979850121 },
	{ 0.99824904204774211891, 0.00066124649345833538209, 0.99812642047803357137 },
	{ 0.99824929118562055752, 0.00066114872276741727935, 0.99812670402448144813 },
	{ 0.99824956717896773384, 0.00066104942619759298437, 0.99812699359815093558 },
	{ 0.99824979655671419732, 0.00066094524681526865741, 0.99812724395673246836 },
	{ 0.99825010234284716759, 0.00066085430443245602242, 0.99812757781903715948 },
	{ 0.99825037200379684865, 0.00066075180351692866954, 0.99812785831372707879 },
	{ 0.99825060801911669195, 0.000660644801258627643, 0.99812810272138086098 },
	{ 0.99825087790894839745, 0.00066054970085579545799, 0.99812840145032388772 },
	{ 0.99825115407395714762, 0.00066045046150643000292, 0.99812869546811566757 },
	{ 0.99825141642976167322, 0.00066034859001595140691, 0.99812897212903495259 },
	{ 0.99825168294358612719, 0.00066025015175301187895, 0.99812925958554743477 },
	{ 0.9982519279615915675, 0.00066014467537361726148, 0.99812951147000794627 },
	{ 0.99825220193314911921, 0.00066004709541756239211, 0.99812981061856764775 },
	{ 0.99825246077943219358, 0.00065995205223518926384, 0.99813010314862748995 },
	{ 0.99825272612977411502, 0.00065984813988167339855, 0.99813037490766076676 },
	{ 0.99825298896241576596, 0.00065975010216194672572, 0.99813065742414031067 },
	{ 0.99825324820924199454, 0.00065965259849983719307, 0.99813094718854467047 },
	{ 0.99825353175568976027, 0.00065955307304817688795, 0.99813124156873267445 },
	{ 0.99825380010056896651, 0.00065945368111092097629, 0.99813152292172968583 },
	{ 0.99825404473710466213, 0.00065934919655281530246, 0.99813178319852413622 },
	{ 0.99825430592942654417, 0.00065925218880135035004, 0.99813206849973268309 },
	{ 0.99825459248948522628, 0.00065915483772713149083, 0.99813237092893192237 },
	{ 0.99825483968186812245, 0.00065905046760994393049, 0.99813262544553349453 },
	{ 0.99825509320664851387, 0.00065895197212654523736, 0.99813290567319457036 },
	{ 0.99825537816453446816, 0.00065885408699470912955, 0.99813320466916632956 },
	{ 0.99825563142228590507, 0.0006587574607129707523, 0.9981334895126111606 },
	{ 0.99825588990617275531, 0.00065865766823250176867, 0.99813376691739641444 },
	{ 0.99825614409852525544, 0.0006585561782117496394, 0.99813403541486356296 },
	{ 0.99825639510560548739, 0.00065845257103401512097, 0.99813429710309620191 },
	{ 0.9982566821234277743, 0.00065836086571174944407, 0.99813461769025457748 },
	{ 0.99825695403504899339, 0.00065825985252815561507, 0.99813489997785243002 },
	{ 0.99825719546723901132, 0.00065816009819465929979, 0.99813516574781102619 },
	{ 0.99825745288301059865, 0.0006580616790052060518, 0.99813544574659052167 },
	{ 0.99825772815156532669, 0.00065796097099739335283, 0.99813572711866094256 },
	{ 0.99825799907136525402, 0.00065786461174446354567, 0.99813602123182032511 },
	{ 0.99825827311921688789, 0.00065776512443977580048, 0.99813630870740632783 },
	{ 0.99825853236604300545, 0.0006576660948987600756, 0.99813658779065828064 },
	{ 0.99825875621247850411, 0.00065756370842415051096, 0.99813683574598044412 },
	{ 0.9982590106146392861, 0.00065745754539924797146, 0.99813708969037751029 },
	{ 0.99825929028916937646, 0.0006573669272657029633, 0.99813740503232717405 },
	{ 0.99825956353593447989, 0.0006572686988111130571, 0.99813769147794506598 },
	{ 0.99825983148027042091, 0.00065716554939705055897, 0.99813796430509360569 },
	{ 0.99826009442735286203, 0.00065707075416999972083, 0.99813825982969084372 },
	{ 0.9982603480284272246, 0.00065697401344734344692, 0.99813854028623394399 },
	{ 0.99826063105989093494, 0.00065687683403450154111, 0.9981388372794894881 },
	{ 0.99826087665010099226, 0.00065677330315071225098, 0.99813908973615472764 },
	{ 0.99826112391877763752, 0.00065667328178840758245, 0.99813935836713618688 },
	{ 0.99826140448976175001, 0.00065657963097053636137, 0.99813966785352559175 },
	{ 0.99826164901185654443, 0.00065647793114143461034, 0.99813992702405784918 },
	{ 0.99826191178727774478, 0.00065637838661628791683, 0.99814020296018468592 },
	{ 0.99826216760087638225, 0.0006562785178418737049, 0.9981404773895061755 },
	{ 0.99826246446061761564, 0.00065618612587410043123, 0.99814079973142522118 },
	{ 0.99826268113542238058, 0.00065608297646003782468, 0.99814103593748004783 },
	{ 0.99826295892167737911, 0.00065598112404304550864, 0.99814131448667453572 },
	{ 0.99826321624208136374, 0.00065588566124397324527, 0.99814160194318701791 },
	{ 0.99826349502015765403, 0.00065578663170295752038, 0.99814188865583353127 },
	{ 0.99826375697541869236, 0.00065568809807258648416, 0.99814216945569922412 },
	{ 0.99826403582978873175, 0.00065559723198371940272, 0.99814248050611420471 },
	{ 0.99826425967622423041, 0.00065549270927864106053, 0.99814271747510840971 },
	{ 0.99826452189851433427, 0.00065539177238899245983, 0.99814299266736927763 },
	{ 0.99826477519441281228, 0.00065529716789680474663, 0.99814327648084599787 },
	{ 0.99826503690171874972, 0.00065519758522468549318, 0.99814355039518332102 },
	{ 0.99826529946733155718, 0.00065509775459724394961, 0.99814382684629421316 },
	{ 0.99826558181214963827, 0.00065500446617561313215, 0.99814413078229902165 },
	{ 0.99826580598283432, 0.00065489687263923612552, 0.99814436159055719422 },
	{ 0.9982660680525365926, 0.00065480310738044700779, 0.99814465738218316471 },
	{ 0.99826634614396747569, 0.0006547046118970485315, 0.99814494356077221315 },
	{ 0.99826660558152857661, 0.00065460966408210712834, 0.99814522924345039367 },
	{ 0.99826683562684737083, 0.00065450764000373775047, 0.99814547870557834841 },
	{ 0.99826712405610762424, 0.00065441154777961662182, 0.99814577934186998753 },
	{ 0.99826739600587577339, 0.00065431682884651101197, 0.99814607456129145202 },
	{ 0.99826765035081610478, 0.00065421701729255585678, 0.99814634275358271598 },
	{ 0.99826789462495557625, 0.00065411667168098334459, 0.99814660446088865342 },
	{ 0.99826818576265097249, 0.00065402328789192080202, 0.99814691635053709451 },
	{ 0.9982684262983869683, 0.00065392412483650079209, 0.99814717870634150909 },
	{ 0.99826866603303676673, 0.00065382164299445971918, 0.99814743053358156999 },
	{ 0.99826893599916233235, 0.00065372417747932307173, 0.99814771148603531614 },
	{ 0.9982692016546799163, 0.00065362758934455736284, 0.99814799789350605597 },
	{ 0.9982694547789170425, 0.00065352972328620764341, 0.99814827077787482423 },
	{ 0.99826971599031244509, 0.00065343357384162745801, 0.99814855499189469867 },
	{ 0.99826995585847655423, 0.00065333042442756474304, 0.998148803404980689 },
	{ 0.9982702257864551898, 0.00065323810875373648083, 0.99814910446088900287 },
	{ 0.99827050584245502485, 0.0006531431037183359125, 0.99814940278928898643 },
	{ 0.99827072793412985341, 0.00065303697884040614978, 0.99814963190000705051 },
	{ 0.99827100448060812621, 0.00065294224083381425996, 0.99814992725294293674 },
	{ 0.99827126986909708872, 0.00065284904777961484234, 0.99815022109907325376 },
	{ 0.99827151103425826317, 0.00065274856865363815352, 0.99815047782819921185 },
	{ 0.99827179877687310938, 0.00065265461265998580241, 0.99815078533094592217 },
	{ 0.99827203946519715849, 0.00065255529701667511905, 0.99815104444425761798 },
	{ 0.99827229810167183999, 0.00065245748817878445637, 0.99815131894987285666 },
	{ 0.99827257152009851726, 0.0006523601180310794256, 0.99815160232465938162 },
	{ 0.99827282103944658953, 0.00065226318657355980991, 0.99815187938612170981 },
	{ 0.99827306487489586573, 0.00065216156303840339559, 0.99815213115614120909 },
	{ 0.998273322252520523, 0.00065206623375373530885, 0.99815241538923449305 },
	{ 0.99827359252382186217, 0.0006519700652356689519, 0.99815270030897318421 },
	{ 0.99827384913850691905, 0.00065187160789924292713, 0.99815297271650504918 },
	{ 0.99827409467149641475, 0.00065177301704841294257, 0.99815323751371543004 },
	{ 0.99827435723710922222, 0.00065167837440925266944, 0.9981535216705149649 },
	{ 0.99827461961198737939, 0.00065157926857429171626, 0.99815379197996334515 },
	{ 0.99827486432481704615, 0.0006514831763501705876, 0.99815406736295886336 },
	{ 0.99827512818742691891, 0.00065138464271979944296, 0.99815433992307855959 },
	{ 0.99827537705827662506, 0.00065128897011237744941, 0.99815461625974855053 },
	{ 0.99827562760759303018, 0.00065118917763190868261, 0.99815487779539313618 },
	{ 0.99827590779710728697, 0.00065109644234138139372, 0.99815518262785163373 },
	{ 0.99827616349626491221, 0.00065099783241706480393, 0.9981554510680981096 },
	{ 0.99827640807558015723, 0.00065089954674201584098, 0.99815571418684201355 },
	{ 0.99827667022157628995, 0.00065080219566779687335, 0.99815599098127549826 },
	{ 0.99827691836763354782, 0.00065070343315558982697, 0.99815625545423669607 },
	{ 0.99827718375612228829, 0.00065061077415900776637, 0.99815654670637288248 },
	{ 0.9982774304525946496, 0.000650512164234691285, 0.99815681034010106387 },
	{ 0.99827771523881914106, 0.00065041689217048214659, 0.99815710752409170237 },
	{ 0.99827795728136059505, 0.00065032041847663444277, 0.99815737298887430295 },
	{ 0.99827821519304271725, 0.00065022341072516959878, 0.99815764905851522837 },
	{ 0.99827847146440518156, 0.00065012735664802103006, 0.99815792547147907943 },
	{ 0.99827871430803316599, 0.00065002870857673177192, 0.99815818479459927914 },
	{ 0.99827896647859593049, 0.00064993053734260092247, 0.99815845348280130001 },
	{ 0.99827922149110814853, 0.00064983085930305005233, 0.99815871925275978516 },
	{ 0.99827948607851046958, 0.00064973717033820627131, 0.99815900398176360397 },
	{ 0.99827974631715798992, 0.00064964187920051085293, 0.99815928771894624205 },
	{ 0.99827999066759132152, 0.00064954286873298140801, 0.99815954614561241964 },
	{ 0.99828025464464220651, 0.00064945040047126247236, 0.99815983575742883716 },
	{ 0.99828050229478870747, 0.00064934770882087177769, 0.99816008768003616769 },
	{ 0.99828077182222407782, 0.00064925556480842068572, 0.99816038017194907983 },
	{ 0.99828102309633304223, 0.00064915825188117449486, 0.99816065021436850557 },
	{ 0.99828127452302983791, 0.0006490633040662330917, 0.99816092529218825025 },
	{ 0.99828153239656491902, 0.00064896961510138920226, 0.99816121185224682133 },
	{ 0.99828179545808837236, 0.0006488701277967015655, 0.99816147491377027468 },
	{ 0.99828204821992905238, 0.00064877392113166254019, 0.99816175056379463637 },
	{ 0.99828229773927712465, 0.00064867561638312729727, 0.99816201244276192561 },
	{ 0.99828254481721923064, 0.00064858051598029522068, 0.99816228599470302463 },
	{ 0.99828279773164796396, 0.00064848141014533426749, 0.99816254547041094458 },
	{ 0.9982830584280590891, 0.00064838688194709189101, 0.9981628319541754335 },
	{ 0.99828332433153221803, 0.00064829401314216020865, 0.99816312036436238841 },
	{ 0.99828355229784071501, 0.00064819422066169133344, 0.99816336542051464775 },
	{ 0.99828383307863288731, 0.00064810299217658384838, 0.9981636704246344971 },
	{ 0.99828408091951426062, 0.00064800194084601724261, 0.9981639223090950086 },
	{ 0.99828431945253415236, 0.00064790340721564609796, 0.99816417777937094247 },
	{ 0.99828457427431160909, 0.00064780727684455219253, 0.99816444541853099892 },
	{ 0.99828485307146130889, 0.00064771780312018690986, 0.99816475549619831931 },
	{ 0.99828508553911265988, 0.00064761503517585077006, 0.99816499193113494837 },
	{ 0.99828536054063865546, 0.00064752031624274537704, 0.99816527913969210761 },
	{ 0.99828559876848288468, 0.00064742834389167113005, 0.99816555772703330351 },
	{ 0.99828584710527501489, 0.00064732923805671006845, 0.99816581643980173411 },
	{ 0.99828612189699250656, 0.00064723545372443467075, 0.99816610793989324346 },
	{ 0.99828635167528223526, 0.00064713487923102636524, 0.99816634923856872863 },
	{ 0.99828663407732076696, 0.00064704489052253022236, 0.99816665628355161211 },
	{ 0.9982868732588394689, 0.00064694624245124096422, 0.99816691453855654892 },
	{ 0.99828713563371740403, 0.00064685385048346747371, 0.99816719430845401995 },
	{ 0.99828738351274581841, 0.00064675581276374080088, 0.99816745622556846129 },
	{ 0.99828764359880550749, 0.00064666250526862359502, 0.99816774057310275747 },
	{ 0.99828790227342700803, 0.00064656381905036166852, 0.99816800695341278971 },
	{ 0.99828814866472326273, 0.00064647024452643578416, 0.99816827752988979139 },
	{ 0.99828840375352945191, 0.00064637377083258786351, 0.9981685511581246395 },
	{ 0.99828866008211236682, 0.00064628048241095693762, 0.99816882980268650805 },
	{ 0.99828888711382024468, 0.00064617826759772432638, 0.99816906484525869114 },
	{ 0.99828917428423036284, 0.00064608824074225551515, 0.99816937215727030708 },
	{ 0.9982893624250995801, 0.00064598463356452110514, 0.99816957921903792794 },
	{ 0.99828962508607976822, 0.00064588882744269482655, 0.99816985481184183904 },
	{ 0.99828989798952216805, 0.00064579399406867132004, 0.99817013915937613522 },
	{ 0.99829014739442956117, 0.00064570221245246041484, 0.9981704190818614375 },
	{ 0.99829041900087500672, 0.00064560760796027281006, 0.99817070655744744023 },
	{ 0.99829065452028431515, 0.00064551094353156176445, 0.99817095962446411583 },
	{ 0.99829091130663072384, 0.00064541700661139547648, 0.998171236361677372 },
	{ 0.99829117120195554058, 0.00064532076179938356597, 0.99817150808256371874 },
	{ 0.9982914251844995368, 0.00064522730171637568668, 0.99817178464811540106 },
	{ 0.99829166818071524148, 0.00064513078987555520609, 0.99817204900663580869 },
	{ 0.99829194268633059117, 0.00064503877937750839916, 0.9981723381606886214 },
	{ 0.99829218858171653306, 0.00064494165718512555009, 0.998172598551923973 },
	{ 0.99829243552614410628, 0.00064484607994513528165, 0.99817286785047754094 },
	{ 0.99829268142152993715, 0.00064474865257697119413, 0.99817312396925206297 },
	{ 0.9982929539435025923, 0.000644658015369939906, 0.99817341846388096815 },
	{ 0.99829318053652005283, 0.00064455715477423664202, 0.99817365360182042089 },
	{ 0.99829341357637602083, 0.00064446304619269350906, 0.99817391731184224035 },
	{ 0.99829367412019920369, 0.00064436287224249805868, 0.99817417755048964967 },
	{ 0.9982939688437100223, 0.00064427826225714631119, 0.99817450309675448405 },
	{ 0.99829417430330480432, 0.00064417717277960703706, 0.9981747267143080693 },
	{ 0.99829443561006758756, 0.00064408478081183343812, 0.99817500587385410427 },
	{ 0.99829468924928876916, 0.00064398464500861076452, 0.99817526546400303644 },
	{ 0.99829496978212561853, 0.00064389606773810291723, 0.99817556919019923001 },
	{ 0.99829520900179102849, 0.00064380081474738005878, 0.99817582801740867282 },
	{ 0.99829543773103923687, 0.00064370422661261434989, 0.99817607902448879376 },
	{ 0.99829570712496018547, 0.00064361122429327827406, 0.99817636794965980407 },
	{ 0.99829597537447190003, 0.00064351570427374706236, 0.998176638640577929 },
	{ 0.99829619883943765402, 0.00064341827690558297485, 0.99817688774030932652 },
	{ 0.99829646426607343557, 0.00064332939445929378068, 0.99817718337934746575 },
	{ 0.99829669896532269302, 0.00064323065102057301427, 0.99817742750089910597 },
	{ 0.99829693150926801515, 0.00064313238441901054813, 0.99817767469328200214 },
	{ 0.99829717765260916895, 0.00064303493797736007223, 0.99817793243330288355 },
	{ 0.99829745217729792817, 0.00064294641792731128168, 0.99817823114317227873 },
	{ 0.99829771094728692038, 0.00064285255730109054726, 0.99817851032179172321 },
	{ 0.99829796500612477672, 0.00064275718986944979216, 0.99817877872389115801 },
	{ 0.99829821595598433603, 0.0006426669150586586908, 0.9981790615264728439 },
	{ 0.99829844350267604725, 0.00064256761848883450425, 0.99817929639738356418 },
	{ 0.99829875138689239122, 0.00064248045265631495253, 0.9981796215240316128 },
	{ 0.99829894517351336347, 0.00064237577736334604533, 0.998179829348738612 },
	{ 0.99829919795442767505, 0.00064228222191290654935, 0.99818009475630087302 },
	{ 0.99829946311403461312, 0.0006421884948010902084, 0.99818037708204565561 },
	{ 0.99829969947267727104, 0.00064209373772101203861, 0.99818063480299279444 },
	{ 0.99829995244432634394, 0.00064199800789313098831, 0.99818090112608237607 },
	{ 0.99830021439958760432, 0.00064190817177252551887, 0.99818118726652427242 },
	{ 0.99830043889452169115, 0.00064181009590582617768, 0.99818142686765953808 },
	{ 0.99830068841386998546, 0.00064171438515143151577, 0.99818169355314545488 },
	{ 0.99830092757631494482, 0.00064162002861456609269, 0.99818195304792700639 },
	{ 0.9983012037222499524, 0.00064153133690314024032, 0.99818224956434542516 },
	{ 0.9983014580862636933, 0.00064143474876837463985, 0.99818251369398414141 },
	{ 0.99830168971468158379, 0.00064133861839728073442, 0.99818276180189424718 },
	{ 0.9983019554464932499, 0.00064124531090216352856, 0.99818304523390122274 },
	{ 0.99830219178606216524, 0.00064115183174566926089, 0.99818330545347522254 },
	{ 0.99830243607927504623, 0.00064105493843512242197, 0.99818356225889515176 },
	{ 0.99830268575121094976, 0.00064096037208990759397, 0.99818382497709579049 },
	{ 0.99830293832231686846, 0.00064086824715094278197, 0.9981841011993247692 },
	{ 0.9983031923239342742, 0.00064077579796271023471, 0.99818437313001928679 },
	{ 0.99830344464708486996, 0.0006406807929273097748, 0.99818463434141457835 },
	{ 0.9983036982481591215, 0.00064058588325934103999, 0.99818490503233270328 },
	{ 0.99830393832613140148, 0.00064049316704229992264, 0.99818516899030984568 },
	{ 0.9983041987936606132, 0.00064040207207159672263, 0.99818545295637428616 },
	{ 0.99830444516588345838, 0.00064030760109381351132, 0.99818571256559662785 },
	{ 0.9983046839659321936, 0.00064021406471686029532, 0.99818597394865327121 },
	{ 0.99830494521547419318, 0.00064012054741339335928, 0.99818624908369357751 },
	{ 0.99830520343233197789, 0.00064002926170782681748, 0.9981865284339743738 },
	{ 0.99830543805528748624, 0.00063993147194342232635, 0.99818677461546223562 },
	{ 0.998305690378438082, 0.00063983955681280713611, 0.99818704940717983831 },
	{ 0.99830593926836119767, 0.00063974329292730916247, 0.998187306765730753 },
	{ 0.99830616280962103382, 0.00063964853584723099268, 0.99818755563658012608 },
	{ 0.99830640572954287837, 0.00063955210030035595722, 0.99818780588072075766 },
	{ 0.99830666467119322238, 0.00063946527779059031231, 0.99818809869688296388 },
	{ 0.99830693841386886067, 0.0006393709784741840544, 0.99818838098448059437 },
	{ 0.99830717160631265994, 0.00063927526771978950091, 0.99818863058012252676 },
	{ 0.99830741063524330858, 0.00063918134987310960132, 0.99818888608854527966 },
	{ 0.99830766469408116492, 0.00063909056007818763976, 0.99818916456144568539 },
	{ 0.99830791770387716788, 0.00063899292290167382206, 0.99818941646497949538 },
	{ 0.99830815780092307943, 0.00063890022575811920152, 0.99818968372266980715 },
	{ 0.99830841384340351929, 0.0006388089781995254365, 0.99818996112745494997 },
	{ 0.99830865256715828338, 0.00063871719658331431446, 0.99819022487562381052 },
	{ 0.99830889434267089388, 0.00063862190544561889607, 0.99819048007887078988 },
	{ 0.99830914431978257095, 0.00063852741539434929637, 0.99819074287336539975 },
	{ 0.99830938907075916777, 0.0006384303694959116756, 0.99819099372785746738 },
	{ 0.9983096432821849664, 0.00063834095299200544968, 0.99819127845686128619 },
	{ 0.99830988610673943029, 0.00063824934303717149788, 0.99819154275816135424 },
	{ 0.99831015763689068265, 0.00063815649330572609549, 0.99819181825559788468 },
	{ 0.99831035746980689716, 0.00063805881798223971785, 0.99819204437177810885 },
	{ 0.99831063842226042127, 0.0006379709655042122441, 0.99819234531324529947 },
	{ 0.9983108825056650204, 0.00063787786781744476843, 0.99819260431211609408 },
	{ 0.99831109235216164421, 0.00063777780830816732313, 0.99819282552641042106 },
	{ 0.9983113848631480769, 0.00063769098579840167822, 0.9981931366531194838 },
	{ 0.99831163457323102151, 0.00063759691536383132204, 0.99819340070646411789 },
	{ 0.99831184590745936092, 0.00063750154793219056693, 0.99819363553922768606 },
	{ 0.99831210370470058191, 0.00063740854561285449111, 0.99819390874784585943 },
	{ 0.99831235249925609487, 0.00063731523811773717683, 0.99819417310636626706 },
	{ 0.99831259831834784357, 0.00063722292244390902304, 0.99819443571012589356 },
	{ 0.99831284078050586128, 0.00063712877571539343856, 0.99819469404142480151 },
	{ 0.99831306088853788427, 0.00063703394234137004047, 0.99819493657987701241 },
	{ 0.99831331891466079664, 0.00063694040596441704131, 0.99819520315092180596 },
	{ 0.99831357556749278359, 0.00063684732735113573718, 0.99819547079008186241 },
	{ 0.9983138251440615285, 0.00063676029503302036209, 0.99819575996320797362 },
	{ 0.99831407832551899428, 0.00063666748344854762805, 0.99819602321546607726 },
	{ 0.9983143209402650653, 0.00063657135307745383104, 0.99819627681654010676 },
	{ 0.99831456149507458164, 0.00063648140251593046494, 0.9981965405647089673 },
	{ 0.99831481265474253384, 0.00063638893425421163771, 0.99819681125562698121 },
	{ 0.99831505504060680245, 0.00063629562675909432344, 0.99819706676404984513 },
	{ 0.99831527997423108456, 0.00063619947731451413804, 0.99819730703275710848 },
	{ 0.99831555081773692972, 0.00063611082375006095403, 0.99819759954374343014 },
	{ 0.99831579028535777365, 0.00063601749718145735978, 0.99819785709302921717 },
	{ 0.99831602744508673997, 0.00063592315971807821667, 0.99819810424726496123 },
	{ 0.99831627730775762686, 0.00063583107292608607303, 0.99819837211530682008 },
	{ 0.99831650954652706442, 0.00063573555290655486133, 0.99819862144392013104 },
	{ 0.99831677009035024728, 0.00063564270317510945894, 0.99819888976972581673 },
	{ 0.99831702071596051251, 0.00063555626213507028077, 0.99819917259138091215 },
	{ 0.99831725755144018475, 0.0006354611426587519242, 0.99819942247312531958 },
	{ 0.99831750428605936509, 0.00063536638557867386283, 0.99819967622678740238 },
	{ 0.99831774985719579085, 0.00063527839958624232088, 0.99819995403211592144 },
	{ 0.99831798373628510834, 0.00063518215477423062721, 0.99820019554059968847 },
	{ 0.99831823096681482355, 0.00063508911430792199145, 0.99820045680921543063 },
	{ 0.99831848502565267989, 0.00063499801933721879144, 0.99820072948377591704 },
	{ 0.99831870852876547495, 0.00063490269005255092153, 0.99820096748273834386 },
	{ 0.99831897115159862199, 0.00063481500923590029276, 0.99820125638883572261 },
	{ 0.99831920728135925547, 0.0006347236853833610826, 0.99820151784818633711 },
	{ 0.99831945811677791358, 0.00063462791740850736395, 0.9982017660896107536 },
	{ 0.99831971385408246888, 0.00063454185783819476094, 0.99820205478589973946 },
	{ 0.99831993419099651632, 0.00063444481193975724859, 0.99820229221265754926 },
	{ 0.998320195764787921, 0.00063435520470098757245, 0.99820256774824112078 },
	{ 0.99832046206880398209, 0.00063426658928350716522, 0.99820285152357068892 },
	{ 0.99832067063737695012, 0.00063416784584478629039, 0.99820307355802506688 },
	{ 0.99832092095781144181, 0.00063407972633795035497, 0.99820334829252210795 },
	{ 0.99832116555620009635, 0.00063398741066412220117, 0.99820360784452399905 },
	{ 0.99832140733171281788, 0.00063389349281744251843, 0.99820386396329841006 },
	{ 0.99832164628434949538, 0.000633797362446348613, 0.99820411024015387458 },
	{ 0.9983218925612049599, 0.00063371099770025466312, 0.9982043876449390174 },
	{ 0.99832213166642946867, 0.00063361807167486403243, 0.99820464322965585247 },
	{ 0.99832238816667362435, 0.00063352789223150454776, 0.99820491651456777493 },
	{ 0.9983226299040393048, 0.00063343340218023483964, 0.99820516839902828643 },
	{ 0.99832284039903451678, 0.00063333719551519559749, 0.99820539644163075454 },
	{ 0.99832308740068231856, 0.00063324598610357428399, 0.99820565816800999048 },
	{ 0.99832335538316507861, 0.00063315843880132794026, 0.99820594644468241263 },
	{ 0.99832358601976178836, 0.00063306268989996060999, 0.99820618959348605959 },
	{ 0.99832382647920392404, 0.0006329715758557710216, 0.99820644740980057907 },
	{ 0.99832408687043916462, 0.00063288223564581013239, 0.99820672534864318681 },
	{ 0.99832434506822353981, 0.00063279531776861287079, 0.99820701124112976022 },
	{ 0.99832457332063440081, 0.00063269802391485306832, 0.99820724483411660266 },
	{ 0.9983248111670086633, 0.00063260643303350539649, 0.99820749801557395742 },
	{ 0.99832506427217226896, 0.00063251896202520449791, 0.99820777919690950597 },
	{ 0.99832530162263610762, 0.00063242687523321213742, 0.99820803302686555991 },
	{ 0.99832554591584898862, 0.00063233425438360263676, 0.99820829257886745101 },
	{ 0.99832576892305102678, 0.00063223697960332911425, 0.99820852397840353909 },
	{ 0.99832601546693511274, 0.00063215004265264546426, 0.9982087978355201896 },
	{ 0.99832626042771999142, 0.00063205766975835836214, 0.99820905515592417423 },
	{ 0.998326490415818113, 0.00063196516334966686655, 0.99820930299680543651 },
	{ 0.99832673114228909217, 0.00063187294304327032944, 0.99820956108014879948 },
	{ 0.99832698890138327208, 0.00063178173363164923278, 0.99820982349317344262 },
	{ 0.9983272328131264084, 0.00063169147789434441139, 0.99821009288709439122 },
	{ 0.99832744286943120304, 0.00063159803688482281207, 0.99821032571714196635 },
	{ 0.99832769404817256476, 0.00063150387108282094763, 0.99821057701032434029 },
	{ 0.99832793946672104823, 0.00063141615211919775892, 0.99821085348050875297 },
	{ 0.99832819854188570297, 0.00063132648765996924288, 0.99821112422864710645 },
	{ 0.99832845878053311228, 0.00063123668968633633337, 0.99821139987867146814 },
	{ 0.99832868979859945568, 0.00063114605247930504524, 0.99821165592115179699 },
	{ 0.99832892106462134407, 0.0006310542136426350833, 0.99821190275113824697 },
	{ 0.99832916142869587706, 0.00063096071541265464407, 0.99821215433042298493 },
	{ 0.99832938069749455057, 0.00063086931526617020562, 0.99821239801328420782 },
	{ 0.99832963384080508629, 0.00063077547371343585959, 0.99821265909116496662 },
	{ 0.9983298519651947478, 0.00063068460762456845289, 0.99821289750974395716 },
	{ 0.99833011802125548595, 0.00063059475243047659505, 0.99821317737500880884 },
	{ 0.99833036048341361468, 0.00063050609886602341104, 0.99821344425122937594 },
	{ 0.99833059338975516095, 0.00063041292488531038181, 0.99821369127195080928 },
	{ 0.9983308299009855391, 0.000630320456623591663, 0.99821394182126721439 },
	{ 0.99833108287263472302, 0.00063023178398565209059, 0.99821421050946923526 },
	{ 0.99833132815766889578, 0.0006301413756604567042, 0.99821447181623190748 },
	{ 0.99833154406953417137, 0.00063004692375615966443, 0.99821470420758928732 },
	{ 0.99833179110932901423, 0.00062995643913701904974, 0.99821496894757943963 },
	{ 0.9983320540182645253, 0.00062986931145147194953, 0.99821524894635860203 },
	{ 0.99833228967118792241, 0.0006297803336377512471, 0.99821551309507083882 },
	{ 0.99833252662110849585, 0.00062968666374639385448, 0.99821575424115849273 },
	{ 0.99833277205873038884, 0.0006295976287122140953, 0.99821602058332159491 },
	{ 0.9983330107061912928, 0.0006295066863294014603, 0.99821627754132935539 },
	{ 0.99833321914124983909, 0.00062940994560674529482, 0.99821649574201287702 },
	{ 0.99833349425721662485, 0.00062932617485479214279, 0.9982167949668663276 },
	{ 0.99833372687745580709, 0.00062923607170537788642, 0.99821705017011330696 },
	{ 0.99833398272920137462, 0.00062914676964238955715, 0.99821732013623876156 },
	{ 0.99833420291352747977, 0.00062904926598028013292, 0.99821754245679539252 },
	{ 0.99833446471620068685, 0.00062896698296026050477, 0.99821783943097741609 },
	{ 0.99833469899583315854, 0.00062887129127935223125, 0.99821807603757528593 },
	{ 0.99833492129731637998, 0.00062877769768194006691, 0.99821831352155354633 },
	{ 0.99833517878938171641, 0.00062869552910283833542, 0.99821860702436115975 },
	{ 0.99833540711808632651, 0.00062859884560064090142, 0.99821883909146924552 },
	{ 0.99833561646867219341, 0.00062850424110845340506, 0.9982190618697895923 },
	{ 0.99833588445115506449, 0.00062841677010015239806, 0.99821934389035837931 },
	{ 0.99833612908769064909, 0.00062832830727056266425, 0.99821961080472598749 },
	{ 0.99833638574052263603, 0.00062823950111821869838, 0.99821988149564389037 },
	{ 0.99833661744523449766, 0.00062815290749028884678, 0.99822014539640058217 },
	{ 0.99833686349320815978, 0.00062806082069829648629, 0.99822039907376869383 },
	{ 0.99833709535050796369, 0.00062796995460942929643, 0.99822064634244533909 },
	{ 0.99833732818055542779, 0.00062788002312139199346, 0.99822090042035660495 },
	{ 0.99833757010865609161, 0.00062778808891729030641, 0.99822115638654296266 },
	{ 0.99833778056550415148, 0.00062769222557500518791, 0.99822137378614017589 },
	{ 0.99833804072785770067, 0.00062760998070195811969, 0.99822166934888423295 },
	{ 0.99833828320908934995, 0.00062751814186528826617, 0.99822192262570919041 },
	{ 0.99833852218079954799, 0.00062742786705449716481, 0.99822217677991442741 },
	{ 0.99833874144959833252, 0.00062733372032598147192, 0.99822240703504128145 },
	{ 0.99833900601792724405, 0.00062724775612310048559, 0.99822268957059412386 },
	{ 0.99833921954560655987, 0.0006271533232922897258, 0.99822291774671112474 },
	{ 0.99833949000764254933, 0.00062706932365850056362, 0.9982232098762275907 },
	{ 0.99833971118379005727, 0.00062697677910283639967, 0.99822344585340039291 },
	{ 0.99833995120454199768, 0.00062688782036260186879, 0.9982237081519843569 },
	{ 0.99834016112733237058, 0.00062679119408086359996, 0.99822392356793887558 },
	{ 0.99834042777467113527, 0.00062670643150762128746, 0.99822421188275822779 },
	{ 0.99834067134309134595, 0.00062661667168096104631, 0.99822446842114931354 },
	{ 0.99834090880799608581, 0.00062652851402715244254, 0.99822472907941350861 },
	{ 0.99834113677430458278, 0.00062644031822637106198, 0.99822498145978466599 },
	{ 0.99834136598038980548, 0.00062634699165776746774, 0.99822522226254950528 },
	{ 0.99834163556504540438, 0.00062626051247075572963, 0.99822550237576967991 },
	{ 0.99834184066224385123, 0.00062616329491094126387, 0.99822571582715524663 },
	{ 0.99834205838609035855, 0.00062607549965337273845, 0.99822596864621659929 },
	{ 0.99834232688355739604, 0.00062598671257451516097, 0.99822623939435495277 },
	{ 0.99834256671357446411, 0.00062589657127812834466, 0.99822649555127629384 },
	{ 0.99834278720307634281, 0.0006258051711316439062, 0.99822673374097348198 },
	{ 0.99834304965424813805, 0.0006257209426160188423, 0.99822702060620771558 },
	{ 0.99834327077317519539, 0.00062562818825200516501, 0.99822725400845979671 },
	{ 0.99834353093552863356, 0.00062554075539067693478, 0.99822752790372337728 },
	{ 0.99834373128342901449, 0.00062544477760747370278, 0.99822773984830348581 },
	{ 0.9983439828627135304, 0.00062536066353276642711, 0.99822801835935071058 },
	{ 0.9983442203085446387, 0.00062526890099004180188, 0.9982282658759827898 },
	{ 0.99834446450639002801, 0.00062518041908696546285, 0.99822852903287362381 },
	{ 0.99834468255448560736, 0.00062508810341313720063, 0.99822876417081285449 },
	{ 0.99834492949891284752, 0.0006250037032361350749, 0.99822903289716158337 },
	{ 0.9983451826803703133, 0.0006249160796399436113, 0.99822930423657796339 },
	{ 0.99834538577485265609, 0.00062481888115361553394, 0.99822951160352113575 },
	{ 0.99834562697816064958, 0.00062472812950566624073, 0.99822976715009081872 },
	{ 0.99834585746216930602, 0.00062464580833867394422, 0.9982300370017752611 },
	{ 0.99834612481522722049, 0.0006245553427930196095, 0.99823030412595126215 },
	{ 0.99834634927201415522, 0.00062446546852544158011, 0.99823054872433969464 },
	{ 0.99834660762238647269, 0.00062437954246953326215, 0.99823082332532209193 },
	{ 0.99834680310654777546, 0.00062428541481450395764, 0.99823103937070167824 },
	{ 0.99834705289292458019, 0.00062419554054692592826, 0.99823129648129715896 },
	{ 0.99834729928422094591, 0.00062410852730229694155, 0.99823156110684641007 },
	{ 0.99834753398347020337, 0.00062401993095830270587, 0.99823181556622753163 },
	{ 0.9983477766172896839, 0.00062393419563725762127, 0.99823208200375812549 },
	{ 0.99834800439286341955, 0.00062384420692876136998, 0.99823232694546948363 },
	{ 0.9983482533781540269, 0.00062375353157475741349, 0.99823258119504210129 },
	{ 0.99834847661423786747, 0.00062366213142827308345, 0.99823282243649713585 },
	{ 0.99834870244431572761, 0.00062357057869389797156, 0.99823306047360638171 },
	{ 0.99834895083832808638, 0.00062348640739873174756, 0.9982333340446206682 },
	{ 0.99834915868210838408, 0.00062339407265141720538, 0.99823355913083267055 },
	{ 0.9983493976538184711, 0.00062330223381474735185, 0.99823380725781629685 },
	{ 0.99834965802598008011, 0.00062322141945317496761, 0.9982340962783545768 },
	{ 0.99834988095688814713, 0.00062313062965825300604, 0.9982343320266454656 },
	{ 0.99835011298584930284, 0.00062303890526250104917, 0.99823457504193457979 },
	{ 0.99835035640168157123, 0.0006229501372571299685, 0.99823483150403158337 },
	{ 0.99835057462143850238, 0.0006228609305615731475, 0.99823507196347349701 },
	{ 0.99835084613251645624, 0.00062277805626347732242, 0.99823536704938031772 },
	{ 0.9983510518591398597, 0.00062268448173955143806, 0.99823558544079848964 },
	{ 0.99835129704880654078, 0.00062259371101811575647, 0.99823583482663202915 },
	{ 0.99835153369355111863, 0.00062250973045781298268, 0.99823610034863530238 },
	{ 0.99835175471711057327, 0.00062241535484746149647, 0.99823632930676509112 },
	{ 0.99835197448181989266, 0.00062232689201787154583, 0.99823656829754869868 },
	{ 0.99835223622727264914, 0.00062224180519536182333, 0.99823684789578459586 },
	{ 0.99835245698380314927, 0.00062215036690190471651, 0.99823708421628010168 },
	{ 0.99835269875931553774, 0.00062206178963139686922, 0.99823733697812078169 },
	{ 0.99835293918061063234, 0.00062197513878300806928, 0.99823759921948418405 },
	{ 0.99835317830490855062, 0.0006218881827588380309, 0.99823785577694867932 },
	{ 0.99835340142655148998, 0.00062179811775639655131, 0.99823809583584743876 },
	{ 0.99835364781784774468, 0.00062170919716313468879, 0.99823835512082048638 },
	{ 0.9983538471739266118, 0.00062161833107426739051, 0.99823857507626478913 },
	{ 0.99835410996842111064, 0.00062153360664799774636, 0.99823885518948496376 },
	{ 0.99835434857773497352, 0.00062144804298832972359, 0.99823911699215817084 },
	{ 0.99835457854675946354, 0.00062135990440800739978, 0.99823936450879025006 },
	{ 0.9983548181097475771, 0.00062126621544316361877, 0.99823960224072361136 },
	{ 0.99835503133225111938, 0.00062117689430668900953, 0.99823983701626672893 },
	{ 0.99835529179978022007, 0.00062109648048832958884, 0.99824013044278014917 },
	{ 0.99835549344467744426, 0.00062099783241704043912, 0.99824032842556809086 },
	{ 0.9983557494871577731, 0.00062091329872563402834, 0.99824060216824384018 },
	{ 0.99835596196579534656, 0.00062082228004887594821, 0.99824083234707672307 },
	{ 0.99835620631622845611, 0.00062073581993535038165, 0.99824109393994153727 },
	{ 0.99835642321991480141, 0.00062064525902226432182, 0.99824132671276855078 },
	{ 0.99835666800903810625, 0.00062055794060185409666, 0.99824158965985088088 },
	{ 0.99835689914154535085, 0.00062046985924199072118, 0.9982418342963865765 },
	{ 0.99835715196060659249, 0.00062038652718022309265, 0.99824210904995702709 },
	{ 0.99835737386154643769, 0.00062029707252934408995, 0.9982423529235530113 },
	{ 0.9983576105253646471, 0.00062020414650395335084, 0.9982425828735040918 },
	{ 0.99835786492752509602, 0.00062012216865971496113, 0.99824286504666071007 },
	{ 0.99835806184219777482, 0.00062002947151616023217, 0.99824307935635292477 },
	{ 0.99835833047317890099, 0.0006199448615308085931, 0.99824336339871111434 },
	{ 0.99835854936050782982, 0.00061985597908451939893, 0.99824359891812020074 },
	{ 0.99835878522323939777, 0.00061976919472172620554, 0.99824385209957744447 },
	{ 0.99835898480820006728, 0.00061967581093266366297, 0.99824406511227259386 },
	{ 0.99835924191879565903, 0.00061959265053227287941, 0.99824434694210639751 },
	{ 0.99835947278427394913, 0.00061950460731938217229, 0.99824459215084637709 },
	{ 0.99835973666595712039, 0.000619422953724411301, 0.99824487800518579839 },
	{ 0.99835994143890616215, 0.00061932804405644245778, 0.99824508705059578073 },
	{ 0.99836015963958957276, 0.00061923923790409870875, 0.99824532783428698846 },
	{ 0.99836040095733846744, 0.00061915493309452830813, 0.99824558914104966068 },
	{ 0.99836062865661812094, 0.00061906448662236025337, 0.9982458284370091528 },
	{ 0.99836088555740543082, 0.00061897978126957688919, 0.99824609979549894234 },
	{ 0.9983611225263995248, 0.00061889417946293608964, 0.99824635690609453409 },
	{ 0.99836134354995897944, 0.00061880255043461574946, 0.99824658845821845343 },
	{ 0.99836155410217464201, 0.00061871311485722313515, 0.99824681713024576712 },
	{ 0.99836181029724269109, 0.00061862812340214481249, 0.99824709041515780061 },
	{ 0.99836200141357556159, 0.00061853359520390265285, 0.99824729083935204166 },
	{ 0.99836225219177365808, 0.00061844852745487899348, 0.99824755794445452217 },
	{ 0.99836249612259020392, 0.00061836389839604107444, 0.99824782220760754914 },
	{ 0.99836271979736423976, 0.0006182756835217733055, 0.99824806392589970905 },
	{ 0.99836296256469814203, 0.00061818855583622631372, 0.99824831706921013375 },
	{ 0.99836316451477125078, 0.00061809814751103092732, 0.99824854038158816749 },
	{ 0.99836340136932444356, 0.00061801204979374565595, 0.99824879669109733982 },
	{ 0.99836364081787176694, 0.00061792877495243686732, 0.99824906330028928547 },
	{ 0.99836386901306228836, 0.00061783134758427288823, 0.99824927562633913869 },
	{ 0.99836410195755076469, 0.00061775297462895051998, 0.99824955133358395098 },
	{ 0.99836432883667058924, 0.00061766243278935106537, 0.99824978561321642268 },
	{ 0.99836459136413635562, 0.0006175784331555619032, 0.9982500643149986308 },
	{ 0.99836481452392644709, 0.00061749138176396035655, 0.99825031097332384 },
	{ 0.99836503364013740036, 0.00061740043938114772155, 0.9982505374137535803 },
	{ 0.99836524382995661675, 0.00061731201469853054769, 0.99825076652447120029 },
	{ 0.99836547210144088726, 0.00061722534477665535937, 0.99825101676861172084 },
	{ 0.99836574368881270125, 0.00061714411079838362318, 0.99825130411068319081 },
	{ 0.9983659674017338892, 0.00061705635368778776612, 0.99825154476086008781 },
	{ 0.99836619521545444389, 0.00061696800529911582055, 0.99825178691784233198 },
	{ 0.99836641660141023369, 0.00061687792122318806098, 0.99825201833645194061 },
	{ 0.9983666502706911583, 0.00061678985893681096547, 0.99825226306835501688 },
	{ 0.99836689296173120045, 0.00061670814812138125428, 0.99825253337780317509 },
	{ 0.99836709628509523462, 0.00061661514580204517845, 0.99825274875561054166 },
	{ 0.99836735042022717312, 0.00061653312981083422881, 0.99825302501598645044 },
	{ 0.99836756764816281251, 0.00061644129097416415844, 0.99825324518123903506 },
	{ 0.99836780667709346115, 0.00061635988533451557727, 0.99825351762691771906 },
	{ 0.99836801911758399353, 0.00061626364052250377518, 0.99825372342983520468 },
	{ 0.99836825696395847807, 0.00061618364632084338117, 0.99825399423519400877 },
	{ 0.99836849215911827038, 0.0006160947829480405754, 0.99825423686901360032 },
	{ 0.99836872020172073849, 0.00061601078331425141322, 0.99825449054638171198 },
	{ 0.99836895669387748509, 0.00061592169105961259729, 0.9982547360412241666 },
	{ 0.99836916602538983145, 0.00061583496391727835222, 0.99825496963421112007 },
	{ 0.99836941798614409205, 0.00061574917137577421088, 0.99825523487011202928 },
	{ 0.99836964290069496464, 0.00061566158592655530722, 0.99825547260204561262 },
	{ 0.99836985991882232216, 0.00061557213127567641294, 0.9982557019797920761 },
	{ 0.99837010398315328974, 0.00061548797905399657733, 0.99825596588054887892 },
	{ 0.99837033091949356489, 0.00061539867699100824806, 0.99825619678417432112 },
	{ 0.99837056247161770628, 0.00061531299889042222022, 0.99825645259777273655 },
	{ 0.9983707854025257733, 0.00061522831261112524443, 0.9982566959754581859 },
	{ 0.99837100924896127196, 0.00061513874351932823666, 0.99825693477550692112 },
	{ 0.99837124865936166529, 0.00061505832970096881596, 0.9982572028724306934 },
	{ 0.99837148124145380645, 0.00061496574699833176682, 0.99825742980877085753 },
	{ 0.99837170524047713638, 0.00061488334953739424201, 0.99825768676677850699 },
	{ 0.99837193074630592449, 0.00061479482948734523462, 0.99825792188564432816 },
	{ 0.99837215781616062138, 0.00061470512688114405022, 0.9982581571952451327 },
	{ 0.99837241830276346466, 0.00061462736427738415886, 0.99825844808498498395 },
	{ 0.99837263577865431596, 0.00061453913032963010995, 0.99825868066707712511 },
	{ 0.99837284636901679757, 0.00061444881737186644866, 0.99825890201488598485 },
	{ 0.99837308827804360778, 0.00061436182320072385034, 0.99825915494838812769 },
	{ 0.99837332395004074748, 0.00061428011238529413914, 0.99825941900173276178 },
	{ 0.99837352223800457374, 0.00061418665230228625986, 0.99825961942592711384 },
	{ 0.99837375102447289965, 0.00061409984886600700333, 0.99825986568370916885 },
	{ 0.99837397880004663531, 0.0006140184050793857538, 0.99826012489238835634 },
	{ 0.99837422738479375539, 0.00061393194496586018724, 0.99826038171688169509 },
	{ 0.99837444547103637582, 0.00061384187996341870765, 0.99826060583034603724 },
	{ 0.99837468762801861999, 0.00061376024544193422475, 0.99826087331691815141 },
	{ 0.99837492850707743042, 0.00061367416679813534177, 0.99826112499157027003 },
	{ 0.9983751349584935042, 0.00061358307182743214176, 0.9982613430396659604 },
	{ 0.99837533702300773619, 0.00061349567711307657989, 0.99826156974712432213 },
	{ 0.99837559352325189188, 0.00061341434776737333544, 0.99826183845439964148 },
	{ 0.99837579364227047041, 0.00061332195579959995334, 0.9982620501700978366 },
	{ 0.99837602334426611694, 0.00061323507606937525168, 0.99826229402462041129 },
	{ 0.99837626679824575948, 0.00061315199196292980485, 0.99826255868831670348 },
	{ 0.99837649695800534388, 0.00061306564629032224336, 0.99826279857555422215 },
	{ 0.99837672671722155204, 0.00061298351585819318022, 0.99826305480876953435 },
	{ 0.99837696481155135952, 0.000612897971272011329, 0.99826330968776733066 },
	{ 0.9983771856825229829, 0.00061280893623783135298, 0.99826353895107289294 },
	{ 0.99837740189956414305, 0.00061272363960697179188, 0.99826378263393411583 },
	{ 0.99837767173217517591, 0.00061264305412723530937, 0.9982640634528732182 },
	{ 0.99837786277221418629, 0.00061255211174442267437, 0.99826427036205278576 },
	{ 0.99837811492370343025, 0.00061247024834110228974, 0.99826453853527052917 },
	{ 0.99837832656310776525, 0.00061238342583133664482, 0.99826476879039738321 },
	{ 0.99837854133056380679, 0.0006122898131604380921, 0.99826498416820497184 },
	{ 0.99837877524780027638, 0.0006122087889905160861, 0.99826524219432799523 },
	{ 0.9983789957373022661, 0.00061212105095340661742, 0.99826547580638846924 },
	{ 0.99837922309325932702, 0.00061203468620731288439, 0.99826571903148608733 },
	{ 0.99837946351455464367, 0.0006119535666699592617, 0.99826598127284948969 },
	{ 0.99837967727111576188, 0.00061186584770633607299, 0.99826621395030912254 },
	{ 0.99837992572234857125, 0.00061178097069217575541, 0.99826646865764545602 },
	{ 0.99838015017913572802, 0.00061169597923709743276, 0.99826671173015524285 },
	{ 0.99838035403655767119, 0.00061160442650272242929, 0.99826692535320205035 },
	{ 0.99838056046890022444, 0.00061151846229984144297, 0.99826715291896739313 },
	{ 0.99838081872390516125, 0.00061143644630863027648, 0.99826742551723401942 },
	{ 0.99838106120513692154, 0.00061135334312869833284, 0.99826768840709589892 },
	{ 0.99838127974914336882, 0.00061126861870242858027, 0.99826792564311872535 },
	{ 0.9983815096228005892, 0.00061118141472293636019, 0.99826816802898299397 },
	{ 0.99838173194335722016, 0.00061109825432254557664, 0.9982684120170199904 },
	{ 0.99838193911956574222, 0.00061100628197147122123, 0.99826862285533779495 },
	{ 0.99838215526031282021, 0.00061092335045291644782, 0.99826886630931732647 },
	{ 0.99838239653991478484, 0.00061083839714481079353, 0.99826911933818696099 },
	{ 0.99838265193389674756, 0.00061075870811893174638, 0.99826939906993739093 },
	{ 0.99838286170409951126, 0.0006106661254162950225, 0.99826960632243977312 },
	{ 0.99838309714721473753, 0.00061058571159793549338, 0.99826987136760569896 },
	{ 0.99838331450866490968, 0.00061049881279422440333, 0.99827010276714189807 },
	{ 0.99838354726241862469, 0.00061041445076419505438, 0.99827035325923785258 },
	{ 0.99838376584457211305, 0.00061032770454837463776, 0.99827058420101022485 },
	{ 0.99838398362563907096, 0.00061024191200687071326, 0.99827081808009943131 },
	{ 0.99838420861648358162, 0.00061015425026370658131, 0.99827105237880553457 },
	{ 0.99838440091537283827, 0.00061006815254642141836, 0.9982712711516935622 },
	{ 0.99838466584609797394, 0.00060998739540530798244, 0.99827154790798011685 },
	{ 0.9983848858396894288, 0.0006099016028638038411, 0.99827178804317295846 },
	{ 0.99838510213302444907, 0.0006098150092358739895, 0.9982720176116544053 },
	{ 0.99838535378860304714, 0.00060973547279788550737, 0.99827229093471347987 },
	{ 0.99838553307937449866, 0.0006096416312451509445, 0.99827247938075835965 },
	{ 0.99838578116821108388, 0.00060955971062137161154, 0.99827274150768086081 },
	{ 0.99838602162765299752, 0.00060947702705813912825, 0.99827299848476214184 },
	{ 0.99838621369766022973, 0.00060938673317386174693, 0.99827320642390993122 },
	{ 0.99838646098541039553, 0.000609304087757601932, 0.99827346126476079746 },
	{ 0.99838667254852064836, 0.00060921825706912533915, 0.99827369449535152679 },
	{ 0.99838691026138060014, 0.00060913435280276790208, 0.99827394773402944317 },
	{ 0.99838714406417605751, 0.0006090521460766933938, 0.99827420122066279351 },
	{ 0.99838735505508191537, 0.00060896154701663477403, 0.99827441686549922562 },
	{ 0.99838755639480369908, 0.00060887556374026750774, 0.99827463956752560126 },
	{ 0.99838777934478528664, 0.00060879196464969120069, 0.99827488418498755429 },
	{ 0.99838805171416999951, 0.00060871338188601921068, 0.9982751727286887089 },
	{ 0.99838825030730982135, 0.00060862480461551136338, 0.99827538444438679299 },
	{ 0.99838849177764676934, 0.00060854217827273772001, 0.9982756416312764669 },
	{ 0.99838870658324985197, 0.0006084528762097491739, 0.9982758637610981145 },
	{ 0.99838893033431796997, 0.00060836878120852828662, 0.99827610540309641429 },
	{ 0.99838913285659580676, 0.00060828291237307891698, 0.99827632867732740696 },
	{ 0.99838937997268462077, 0.00060819860756350862478, 0.99827657915034972991 },
	{ 0.99838961274551185632, 0.00060811628639651632827, 0.99827683740535466672 },
	{ 0.9983898360388162585, 0.00060803337395144783483, 0.99827707714000424311 },
	{ 0.99839003005431925519, 0.00060794449150515864067, 0.99827728961864192758 },
	{ 0.9983902788488749902, 0.00060786278068972882105, 0.99827755275645935207 },
	{ 0.99839049617217834331, 0.00060777996361209216114, 0.9982777931205341071 },
	{ 0.9983907306234721668, 0.00060769336998416252638, 0.99827803199687692448 },
	{ 0.99839093974517623131, 0.0006076061660046703063, 0.99827825622478216783 },
	{ 0.99839116792129301015, 0.00060752210915042208737, 0.99827849580684402397 },
	{ 0.99839137360976959457, 0.00060743849098635950036, 0.99827872957149244026 },
	{ 0.99839163100646743931, 0.00060735828697634970143, 0.99827899940410325108 },
	{ 0.9983918542425513909, 0.00060727360069705272564, 0.99827924339214024751 },
	{ 0.99839206832336169217, 0.00060718799889041192609, 0.9982794696799819345 },
	{ 0.99839227572845201664, 0.00060709877312136893354, 0.99827968448558501713 },
	{ 0.99839251262115213947, 0.00060701614677859539859, 0.99827993801036518651 },
	{ 0.99839272281097157791, 0.00060693123161746241265, 0.9982801645270886759 },
	{ 0.99839296946929689813, 0.00060685333549929834467, 0.99828043880382200115 },
	{ 0.99839319381164304268, 0.00060676426231814591713, 0.99828066543498650276 },
	{ 0.99839342189239255188, 0.00060668358147097770951, 0.99828091358104353858 },
	{ 0.9983936136190771915, 0.00060659469902468862376, 0.99828112285533543435 },
	{ 0.99839384658263918837, 0.00060651142418337994355, 0.99828136878886808425 },
	{ 0.99839406524108653684, 0.00060642734825564555308, 0.99828160575786228925 },
	{ 0.99839430295394648862, 0.00060634531319094832347, 0.9982818611709176615 },
	{ 0.99839452008651474735, 0.000606258795856963917, 0.99828208715358368597 },
	{ 0.99839471929000600525, 0.00060617128670169024163, 0.99828229993739714399 },
	{ 0.99839497907088980977, 0.00060609430611086978057, 0.99828258596339802811 },
	{ 0.99839516488479340683, 0.00060600263893557666361, 0.99828277673640830603 },
	{ 0.99839540095733370073, 0.00060592247307253953303, 0.99828303577342614172 },
	{ 0.99839562644408907932, 0.00060583904564334028781, 0.99828327552714912763 },
	{ 0.99839583123611186366, 0.00060575266182375994955, 0.99828349939265814683 },
	{ 0.99839608220504494351, 0.00060566885292483402074, 0.99828375272670333285 },
	{ 0.99839630984710425743, 0.00060558842003298832008, 0.99828400382915083444 },
	{ 0.99839650172637661729, 0.00060550060570193351469, 0.9982842100516849948 },
	{ 0.99839677987502750689, 0.00060542318642092742172, 0.99828450330653717426 },
	{ 0.99839694909499820952, 0.00060533178627444298326, 0.99828468931117586571 },
	{ 0.99839718526290588407, 0.00060525163948489202424, 0.99828494760432762156 },
	{ 0.99839742757247607052, 0.00060516924202395439101, 0.9982852021209290827 },
	{ 0.99839762599395442955, 0.00060508182823611244075, 0.99828541355052502482 },
	{ 0.99839785556243565434, 0.00060500011742068262113, 0.99828566203990487526 },
	{ 0.99839805911468171296, 0.00060491497337771384189, 0.99828588207164314916 },
	{ 0.99839832049773824529, 0.00060483242332888553523, 0.99828614925303948979 },
	{ 0.99839851624892850257, 0.00060474611580325075052, 0.99828635999598980266 },
	{ 0.99839872476028113102, 0.00060466211616946147992, 0.99828658880153187116 },
	{ 0.99839897843764913166, 0.00060458483040285967199, 0.99828686628261098512 },
	{ 0.99839920670913340217, 0.00060449816048098448367, 0.99828708967128276797 },
	{ 0.99839940816329597606, 0.00060441389381838664299, 0.99828732042232015687 },
	{ 0.99839963746474857942, 0.00060433222114992949173, 0.99828756566920739957 },
	{ 0.99839982568191165679, 0.00060423982918215610963, 0.99828775693812821235 },
	{ 0.99840008805678959192, 0.00060416651070071072677, 0.99828805028834788349 },
	{ 0.99840029189513790353, 0.00060408020317507583365, 0.99828826747813659281 },
	{ 0.99840051999496093327, 0.00060399526894045656774, 0.99828850282588421639 },
	{ 0.99840071427749277344, 0.00060391046822024158688, 0.99828872243800581554 },
	{ 0.99840094642089471932, 0.00060382461845827860563, 0.99828895725169597419 },
	{ 0.9984011519186364314, 0.00060373760521364961892, 0.99828917373576575578 },
	{ 0.99840142316268543077, 0.00060366682350588597716, 0.99828947854915062177 },
	{ 0.99840158751891705524, 0.00060357334434939181791, 0.99828965125956914406 },
	{ 0.99840182122634502093, 0.00060349165260744838668, 0.99828989972987525192 },
	{ 0.99840207341598108393, 0.00060341158211184298121, 0.99829016389766089823 },
	{ 0.99840225964950157778, 0.00060332590401125695337, 0.99829037164607392629 },
	{ 0.99840247054503983293, 0.00060324055015993855236, 0.99829059650340412624 },
	{ 0.99840273188994943521, 0.00060316292107058316289, 0.99829087516703929328 },
	{ 0.998402921480403438, 0.0006030744963879658806, 0.99829107376017889308 },
	{ 0.99840316020415831311, 0.00060299644768191103077, 0.99829133796611158047 },
	{ 0.99840339061187299841, 0.00060291191399050472841, 0.99829157325663886446 },
	{ 0.99840359424041302816, 0.0006028302031750749088, 0.99829180694499330961 },
	{ 0.99840384799407488892, 0.00060274734795046547211, 0.99829206680217097425 },
	{ 0.99840404807494642636, 0.00060266384422732089017, 0.99829228946605019779 },
	{ 0.99840424931930060737, 0.0006025767356152603952, 0.99829249875941572512 },
	{ 0.99840446866439347406, 0.00060249197304201808269, 0.99829273137965501839 },
	{ 0.9984047060148572017, 0.00060241438209963525316, 0.9982929910079507696 },
	{ 0.99840493428634158324, 0.00060233503639651022124, 0.99829324125209129015 },
	{ 0.99840513701842781291, 0.00060224212944460597894, 0.99829343864360131633 },
	{ 0.99840534976409422985, 0.00060216205894900046505, 0.99829368053355493906 },
	{ 0.99840555751250747996, 0.00060207546532107072187, 0.99829389881053254285 },
	{ 0.99840579020904063334, 0.00060199901878786761782, 0.99829415897288598103 },
	{ 0.99840601352141833402, 0.00060191242515993787464, 0.99829438442149420752 },
	{ 0.99840623097823577581, 0.00060183138191652969708, 0.99829462358393916688 },
	{ 0.99840644267486045038, 0.0006017435485119885033, 0.99829483951487774096 },
	{ 0.99840668195174619992, 0.00060166818916750628484, 0.99829510892787198806 },
	{ 0.99840689267562310327, 0.00060158228218508424685, 0.99829533155360428154 },
	{ 0.99840711772368817556, 0.00060150177299929310105, 0.99829557430186488531 },
	{ 0.9984073332922305255, 0.00060141674339724211003, 0.99829579933085654808 },
	{ 0.99840754657195451838, 0.00060133400261355057, 0.9982960360328219096 },
	{ 0.99840776683257459467, 0.00060124862968874567219, 0.99829625995555126838 },
	{ 0.99840798201964742198, 0.00060116825401735881143, 0.99829649719157409482 },
	{ 0.99840820319579470787, 0.00060108593285036651492, 0.99829673255839523893 },
	{ 0.99840841073439945408, 0.00060100183784914573606, 0.99829695783534222464 },
	{ 0.99840864755080560577, 0.00060092127144289553351, 0.99829720930018583935 },
	{ 0.99840885079787589085, 0.00060083643257570788429, 0.99829743085780298095 },
	{ 0.99840907258437472382, 0.0006007541114087156962, 0.998297663935805768 },
	{ 0.99840928819106400383, 0.00060066942512941861199, 0.99829788991847168145 },
	{ 0.99840952557967477254, 0.00060058691322756308211, 0.99829813539424072655 },
	{ 0.99840973756240192216, 0.00060050546944094183258, 0.99829837087550277186 },
	{ 0.99840993001387889905, 0.00060042005836916426641, 0.99829858087458722693 },
	{ 0.99841013791487986939, 0.00060033590614748464764, 0.99829880067744336536 },
	{ 0.99841042397902768357, 0.0006002624732251212597, 0.99829910543360778075 },
	{ 0.99841062982009198823, 0.00060017931282473058457, 0.99829932683863698006 },
	{ 0.9984108372633294648, 0.0006000968390698475062, 0.99829955579676699085 },
	{ 0.99841106988356853602, 0.00060001543343019903345, 0.99829979696192827632 },
	{ 0.99841125544951714321, 0.00059992538750124394225, 0.99829998989024237854 },
	{ 0.99841148829863823888, 0.00059985061943483770387, 0.99830025264658994733 },
	{ 0.99841167869017877212, 0.00059975963890505250894, 0.99830044624247615825 },
	{ 0.99841194472716598973, 0.00059968342125368530662, 0.99830072524943413992 },
	{ 0.99841215808318406477, 0.00059960045158815786486, 0.99830095508494431922 },
	{ 0.99841235700057295865, 0.00059951689064455422618, 0.99830117074885416084 },
	{ 0.99841255608962342638, 0.00059943262398195649391, 0.99830138883509667025 },
	{ 0.99841279286788264802, 0.00059935026466799152904, 0.99830163186945952702 },
	{ 0.99841302133010201292, 0.00059927278816652659616, 0.99830188680567777393 },
	{ 0.99841324807570763777, 0.0005991888648266827707, 0.9983021220962049469 },
	{ 0.99841344563887890473, 0.0005991062766308819041, 0.99830233911433230443 },
	{ 0.99841365567611028986, 0.00059902426063967095446, 0.99830256883540158253 },
	{ 0.99841387502120304553, 0.00059893904030275683849, 0.99830279718317971316 },
	{ 0.9984141151373223666, 0.00059886432945680954845, 0.99830306102671595436 },
	{ 0.99841432494567217137, 0.00059877598106813749446, 0.99830327083506553709 },
	{ 0.99841453343795127928, 0.00059869562447023723893, 0.9983035032073493964 },
	{ 0.99841472619460402971, 0.00059860845863771757879, 0.99830370458521799915 },
	{ 0.99841498242781911987, 0.00059853349983644810704, 0.99830398126521047164 },
	{ 0.99841518918441096719, 0.00059845033943605743191, 0.99830420663752483801 },
	{ 0.99841540582106858004, 0.00059836912453127219253, 0.9983044412032595627 },
	{ 0.99841562795089033866, 0.00059828661262941666265, 0.99830467439570336197 },
	{ 0.99841583751128459845, 0.00059820610344362551685, 0.99830490600504773191 },
	{ 0.99841603221343289132, 0.00059812126457643786763, 0.99830511291422729947 },
	{ 0.99841627784178976768, 0.0005980395156140355965, 0.99830535961069943873 },
	{ 0.99841646346495871445, 0.00059795337974977765677, 0.99830556461253050493 },
	{ 0.99841672810958148609, 0.00059788091957521714934, 0.99830585531153548384 },
	{ 0.99841693925307506419, 0.00059779680550050987367, 0.99830607637324186854 },
	{ 0.99841712417052486117, 0.00059771416008424995032, 0.99830628738322102489 },
	{ 0.99841736901686872763, 0.0005976328116650604259, 0.99830653535761670891 },
	{ 0.99841756711409757052, 0.00059754732429933763143, 0.99830674261011920212 },
	{ 0.99841779775069428027, 0.00059746790230226715437, 0.99830699415125678797 },
	{ 0.99841801366255944483, 0.00059738474190187647924, 0.99830721891321960726 },
	{ 0.99841821759627524813, 0.00059730440437746239526, 0.99830744634547041727 },
	{ 0.99841846551345037053, 0.00059722837746095842632, 0.99830771211542890242 },
	{ 0.99841866349623853427, 0.0005971436148877160054, 0.99830792917170319001 },
	{ 0.99841885943816344184, 0.00059705730736208111227, 0.99830812995829354417 },
	{ 0.99841911168502006646, 0.00059698107063722773841, 0.99830839902796497665 },
	{ 0.99841930818007629256, 0.00059689726173830191802, 0.99830861467280118671 },
	{ 0.99841952702925829133, 0.00059681505501222762659, 0.99830884435572353475 },
	{ 0.9984197287504497087, 0.0005967354041333212478, 0.99830907415308678399 },
	{ 0.99841994012282497817, 0.00059664991676759845333, 0.99830928789057449269 },
	{ 0.99842016732619398578, 0.00059657011330080140111, 0.99830952791132632207 },
	{ 0.99842037984297871134, 0.00059649057686281291898, 0.99830976629175838255 },
	{ 0.99842060124800802168, 0.00059640589058351583477, 0.99830998922266644957 },
	{ 0.99842080270217059557, 0.00059632513344240250727, 0.99831021562494903776 },
	{ 0.99842101668761373823, 0.00059624412834596699808, 0.99831044719614658867 },
	{ 0.99842125306532991669, 0.00059616140663576184643, 0.99831068490900665147 },
	{ 0.99842145087645650658, 0.00059608219444704109956, 0.99831091377176905954 },
	{ 0.99842165934966198293, 0.00059599808037233393231, 0.99831112918772357823 },
	{ 0.99842187777922719594, 0.00059591667473268545956, 0.99831136150278687591 },
	{ 0.99842210154936883448, 0.0005958381682629590231, 0.99831160404123886476 },
	{ 0.99842230828688693922, 0.00059575506508302718787, 0.99831182382502181571 },
	{ 0.99842253816054393756, 0.00059567426979494119202, 0.99831206636347391559 },
	{ 0.99842276086257020218, 0.00059559423744630834649, 0.99831229959406464491 },
	{ 0.99842294207976378662, 0.00059550922691774396071, 0.99831250125803550066 },
	{ 0.99842317309783024104, 0.00059543079674196275255, 0.99831274875559405935 },
	{ 0.99842338580534972792, 0.00059534809410524388087, 0.99831297305979316281 },
	{ 0.99842361464903872648, 0.00059526634514284160974, 0.99831320564188530398 },
	{ 0.99842382865355527866, 0.00059518631279420876421, 0.99831344345011285846 },
	{ 0.99842403905318299895, 0.00059510492622804667985, 0.99831367059626141547 },
	{ 0.99842422803328545466, 0.00059502046883058571421, 0.99831387514032865482 },
	{ 0.99842444791243578628, 0.00059494036018800753197, 0.99831410966791644945 },
	{ 0.99842469731734295735, 0.00059486627876710921562, 0.99831437738337036603 },
	{ 0.99842487651274680616, 0.00059477863609743136363, 0.99831456920542227529 },
	{ 0.99842510497496594901, 0.00059470024406862271541, 0.99831481315531234166 },
	{ 0.99842529956267334068, 0.00059461483299684525766, 0.99831501697458724376 },
	{ 0.99842553458617189222, 0.00059454048454713815438, 0.99831528007425762716 },
	{ 0.99842574706480946567, 0.00059445862114381766133, 0.99831550033487759244 },
	{ 0.99842596459792098962, 0.00059437807381105363033, 0.9983157372847982769 },
	{ 0.99842615113661714599, 0.00059429209053468625562, 0.99831593450464684025 },
	{ 0.99842637416289270469, 0.00059421387016725466922, 0.99831617813028772357 },
	{ 0.99842659060881544519, 0.00059413414299440295372, 0.99831641014017535873 },
	{ 0.99842680533812455668, 0.00059405300438356283422, 0.99831663707651541184 },
	{ 0.99842703538344312886, 0.00059397402107667788065, 0.99831688280023977988 },
	{ 0.99842722367690006635, 0.00059388826668214651609, 0.99831707963861859856 },
	{ 0.9984274565069477525, 0.0005938118010754572405, 0.99831733520426180206 },
	{ 0.99842765349791451346, 0.00059372925102662893384, 0.9983175480643691202 },
	{ 0.99842787537978083812, 0.00059364698708009558566, 0.99831777494348894475 },
	{ 0.99842810189650421648, 0.00059356863319825971421, 0.99831801748194104462 },
	{ 0.99842830106184832228, 0.00059348856270265441717, 0.99831824319757800357 },
	{ 0.99842854518339974046, 0.00059341156303834756772, 0.99831849857248633473 },
	{ 0.99842871837065561014, 0.00059332443535280068436, 0.99831868152536706873 },
	{ 0.99842896436140871064, 0.00059324953377199016093, 0.99831894964136425052 },
	{ 0.9984291648618968118, 0.00059316500008058375016, 0.998319159297126002 },
	{ 0.9984293868772775582, 0.00059308458626222443789, 0.99831938833154965085 },
	{ 0.99842959546492404677, 0.00059300752937745874853, 0.99831962438501631318 },
	{ 0.99842979094908546056, 0.00059292431175660901665, 0.99831983795084255906 },
	{ 0.99843003312514133629, 0.00059284521400880616643, 0.99832008405603667178 },
	{ 0.99843021569655232561, 0.00059276106178712643924, 0.99832027990259430972 },
	{ 0.99843045342848590895, 0.00059268629372072030928, 0.9983205426589418785 },
	{ 0.9984306693784981146, 0.00059260584175538822023, 0.99832077325739154716 },
	{ 0.9984308690397529773, 0.00059252565681886459285, 0.99832099306024801866 },
	{ 0.99843107934401331693, 0.00059244116127443074201, 0.9983212099257874339 },
	{ 0.99843128480360787691, 0.00059236036598634463773, 0.99832142866052853147 },
	{ 0.99843149568007272254, 0.00059228254616212601489, 0.99832166150964962714 },
	{ 0.99843173913405203201, 0.00059220083534669619527, 0.99832190511621676787 },
	{ 0.9984319224111820601, 0.00059211983025026046924, 0.99832211059488507043 },
	{ 0.99843212977812534348, 0.0005920366698498697941, 0.99832232864298064978 },
	{ 0.99843234113142742547, 0.00059195791542482106753, 0.99832256101526439807 },
	{ 0.99843258431837811351, 0.00059188089668702804653, 0.9983228150359551023 },
	{ 0.99843275872633707735, 0.00059179407417726229319, 0.99832299676813274214 },
	{ 0.99843298909590494361, 0.00059171758949708662921, 0.99832324735559596629 },
	{ 0.99843321080611002749, 0.00059163992226075846296, 0.99832348585046892797 },
	{ 0.99843342053816563908, 0.00059156065285157855092, 0.99832372075952646728 },
	{ 0.99843364516661414765, 0.00059148227989625618266, 0.99832395645059679445 },
	{ 0.99843381638930084332, 0.00059139604866456651783, 0.99832413850702361735 },
	{ 0.99843406281874425012, 0.00059132143318605095289, 0.998324405688420069 },
	{ 0.9984342600004457724, 0.00059123724281739844892, 0.99832461179651321714 },
	{ 0.99843449189589250636, 0.00059116266548585555234, 0.99832486390985542002 },
	{ 0.99843469010756236148, 0.00059107431709718360677, 0.9983250569335369029 },
	{ 0.99843489381239625136, 0.00059099664986085554894, 0.99832528444208168406 },
	{ 0.99843508929655755413, 0.0005909183913464514026, 0.99832550697244648585 },
	{ 0.99843532687590330621, 0.00059084041893434188948, 0.99832575614847185452 },
	{ 0.99843550795958235788, 0.00059075249016236907901, 0.99832594112314199108 },
	{ 0.99843575755522451232, 0.0005906795912976230481, 0.99832621307290991819 },
	{ 0.99843595469877921555, 0.00059059841453981047708, 0.99832642608560517861 },
	{ 0.99843615855620115873, 0.00059051662743043553758, 0.9983266397086519861 },
	{ 0.99843637309477539787, 0.00059043697655152937564, 0.99832686889566357724 },
	{ 0.99843660113737797701, 0.00059035969078492789297, 0.99832711311258237608 },
	{ 0.99843681641981818498, 0.00059028227150392212526, 0.99832734910882869883 },
	{ 0.99843698787138668305, 0.00059019516289186163029, 0.99832753074563895801 },
	{ 0.99843722039625848463, 0.00059011846840333623612, 0.99832777723230248235 },
	{ 0.99843743985579214151, 0.00059003794014405902719, 0.99832800386346676191 },
	{ 0.99843764554426861491, 0.00058996408760499661258, 0.99832824495233374318 },
	{ 0.99843785966322606829, 0.00058988142311525040926, 0.99832846525110063851 },
	{ 0.9984380790846127951, 0.0005898017722363441389, 0.99832869810022162316 },
	{ 0.99843829179213228198, 0.0005897270041699377921, 0.99832893705285841168 },
	{ 0.99843850495741548468, 0.00058964140236329710097, 0.9983291499129656188 },
	{ 0.99843870995924655087, 0.00058956381142091437986, 0.99832937398828291986 },
	{ 0.99843890574858351616, 0.00058948280632447887066, 0.99832958389199988325 },
	{ 0.99843912276671098471, 0.00058940311729859993194, 0.99832981494821326773 },
	{ 0.99843932204649610274, 0.00058932285606813107626, 0.99833003314889690039 },
	{ 0.99843953967497500734, 0.0005892449218029942315, 0.99833026512063760549 },
	{ 0.9984397695486321167, 0.00058916565239381442787, 0.9983304994193434867 },
	{ 0.99843994708464278709, 0.00058908333122682202294, 0.9983306986228347446 },
	{ 0.99844016122267376101, 0.00058900415718507416127, 0.9983309277907728152 },
	{ 0.99844036660597457189, 0.00058892511665773047622, 0.99833114782251097807 },
	{ 0.99844059140608443226, 0.00058884794533204710704, 0.99833139360345579671 },
	{ 0.99844082063124306448, 0.000588770087360855599, 0.99833163381494249844 },
	{ 0.99844100316450723476, 0.00058868620216798433348, 0.998331823825013287 },
	{ 0.99844123578474652803, 0.00058860967934083589272, 0.99833207109369004328 },
	{ 0.9984414301435721173, 0.00058852716743898036283, 0.99833227979577721101 },
	{ 0.99844164876387242469, 0.00058845075905274992715, 0.99833251558221502986 },
	{ 0.99844185660765283341, 0.00058837166130494686009, 0.99833274242318781333 },
	{ 0.99844204314634898978, 0.0005882856780285795938, 0.99833292850412025388 },
	{ 0.99844229150221441849, 0.00058821321785401897795, 0.99833319761193894948 },
	{ 0.9984424881880054059, 0.00058813371956300338102, 0.99833341443933132364 },
	{ 0.99844268853590578683, 0.00058805696785401893011, 0.99833363798059104877 },
	{ 0.99844287728712632912, 0.00058796831428956574609, 0.99833382612146004398 },
	{ 0.99844311702177590551, 0.00058789436638307160637, 0.99833408351815799975 },
	{ 0.99844329425261080235, 0.00058781250297975122174, 0.99833427585519407543 },
	{ 0.99844352883741915861, 0.00058773821175050317521, 0.998334532031188715 },
	{ 0.99844372651503143778, 0.00058765314400147973268, 0.99833472848809790001 },
	{ 0.99844394942686609529, 0.00058758285820436056274, 0.99833498874581882987 },
	{ 0.9984441442625288099, 0.00058749723732423370006, 0.99833518308557100962 },
	{ 0.99844437917158646023, 0.00058742361366700718717, 0.99833544164575149793 },
	{ 0.99844456357405231284, 0.00058734342873048355979, 0.99833564206994573897 },
	{ 0.99844480529234458377, 0.00058726658165406749219, 0.99833589637673891826 },
	{ 0.99844496907637159122, 0.00058718180000733889972, 0.99833607294000192844 },
	{ 0.99844519944593945748, 0.00058710157692384282082, 0.99833630605615175657 },
	{ 0.99844539521620301326, 0.00058702482521485858675, 0.99833652898705982359 },
	{ 0.99844564828321968886, 0.0005869502860302882501, 0.99833679502404693018 },
	{ 0.99844581162855650103, 0.00058686689674806156482, 0.99833697698510648344 },
	{ 0.99844604279921067569, 0.00058678953468751485385, 0.99833721761620985991 },
	{ 0.99844623658583186998, 0.00058671049416017106038, 0.9983374291030261416 },
	{ 0.99844643861219906089, 0.00058663175880860861378, 0.99833764821923698385 },
	{ 0.99844666863844411253, 0.00058655477821778826113, 0.99833788801110712186 },
	{ 0.9984468776838542059, 0.00058647451698731929703, 0.99833811109460313116 },
	{ 0.9984470690672160309, 0.00058639253914308101575, 0.99833830987847738125 },
	{ 0.99844729443953050829, 0.00058631883919190916615, 0.99833856363213946405 },
	{ 0.99844749423429979274, 0.00058623783409547344011, 0.99833877155221384392 },
	{ 0.99844771914885066533, 0.00058615879356812964664, 0.9983390025702800763 },
	{ 0.9984479365103009485, 0.00058608608543824706593, 0.99833924800790208032 },
	{ 0.99844811702177549417, 0.00058599773704957501194, 0.99833942394173991186 },
	{ 0.99844833245680342237, 0.00058592016518067867922, 0.99833965494073284574 },
	{ 0.99844853169844161034, 0.00058584421455812004699, 0.99833988248742466798 },
	{ 0.99844873732969774416, 0.00058576404869508302484, 0.9983400973121010491 },
	{ 0.9984489594595196138, 0.00058568962395143091011, 0.99834034225381229621 },
	{ 0.99844915484831342489, 0.00058560791313600109049, 0.99834054450906128952 },
	{ 0.99844936404631146054, 0.00058553085625123550955, 0.99834077537453957962 },
	{ 0.99844959948942668682, 0.00058545654594850107463, 0.99834102485574072183 },
	{ 0.99844978339598178252, 0.0005853724318737940158, 0.99834121448434165469 },
	{ 0.99844998502180570821, 0.00058529550850343250307, 0.99834143831170363281 },
	{ 0.99845018880293368024, 0.00058521456062745605062, 0.99834165368951122144 },
	{ 0.99845039695189008455, 0.00058513664543580570267, 0.99834187591470036072 },
	{ 0.99845062222883718128, 0.00058506109535646014241, 0.9983421164885833976 },
	{ 0.99845082158491627045, 0.00058498213112306168566, 0.99834233323968180063 },
	{ 0.99845101277754322311, 0.00058490232765626463344, 0.99834253969109776339 },
	{ 0.99845123425886650459, 0.00058482199013185054946, 0.99834276147759659636 },
	{ 0.99845143647596856784, 0.00058474413216065925826, 0.99834298475182747801 },
	{ 0.99845164613173031931, 0.00058466570198487815852, 0.9983432047835657519 },
	{ 0.99845183553144967181, 0.00058458639442872579496, 0.99834341508782586949 },
	{ 0.99845205674574399879, 0.00058450922310304231737, 0.99834364477074821753 },
	{ 0.9984522599546673538, 0.00058442915260743702032, 0.99834386331475455378 },
	{ 0.99845250617430236773, 0.00058436046898316948775, 0.99834413478768546657 },
	{ 0.99845266650602826353, 0.00058427437126588421638, 0.99834430847085198213 },
	{ 0.99845289874479781211, 0.00058419838249635313264, 0.99834454803384020671 },
	{ 0.99845311379835599563, 0.00058412702858399957392, 0.99834479860222991032 },
	{ 0.99845333260939106435, 0.00058404310524415574846, 0.99834500764763989267 },
	{ 0.9984535272352454971, 0.00058396932899903856214, 0.99834523630059379684 },
	{ 0.9984537267439123065, 0.00058388883888673369631, 0.99834544328606722452 },
	{ 0.99845391772673086628, 0.00058381027519654798627, 0.99834565532601471372 },
	{ 0.99845410163328596198, 0.000583726008533950254, 0.9983458383170424888 },
	{ 0.99845433757231194516, 0.00058365494072389165377, 0.9983461031714735423 },
	{ 0.9984545428793187849, 0.00058357445061158689636, 0.99834631427682007931 },
	{ 0.99845476157591295241, 0.0005834946089978172842, 0.99834653503335080149 },
	{ 0.99845498389646958337, 0.00058342243492555173525, 0.99834678726113379454 },
	{ 0.99845515548155250318, 0.00058333843529176246465, 0.99834696540749601201 },
	{ 0.99845534182951389823, 0.00058326065361451640175, 0.99834717365181957494 },
	{ 0.99845557696745323994, 0.00058318451225709464457, 0.99834741519845027202 },
	{ 0.99845577220365921978, 0.00058310539543580573122, 0.99834762309945102032 },
	{ 0.99845598889753739424, 0.00058302934944581559073, 0.99834786214745507849 },
	{ 0.99845618407652292348, 0.0005829517394299463728, 0.99834807277596449016 },
	{ 0.99845641530439777078, 0.00058287687599610851774, 0.99834832189476907516 },
	{ 0.99845660457060236848, 0.00058279495537232918478, 0.99834851814186975627 },
	{ 0.99845681079313663986, 0.00058271538078736835956, 0.99834873062050732972 },
	{ 0.99845701789305107976, 0.00058264011681031775778, 0.99834895816719904094 },
	{ 0.99845725409910568438, 0.00058256748497438018853, 0.99834921756661298975 },
	{ 0.99845740815565464654, 0.00058247854530763215446, 0.99834937059319384112 },
	{ 0.99845763778135654398, 0.00058240768730592339282, 0.99834962413704742001 },
	{ 0.99845782718107578546, 0.00058232586204957578497, 0.99834982162392471583 },
	{ 0.9984580501119839635, 0.00058225490868043518981, 0.99835007202065306764 },
	{ 0.99845826095030176806, 0.00058217743217897014851, 0.99835029659188101459 },
	{ 0.99845844558164931204, 0.00058209167778443878394, 0.99835047878182237024 },
	{ 0.99845863679334978524, 0.00058201624214601101193, 0.99835069562828837597 },
	{ 0.99845887284681644758, 0.0005819422370190580323, 0.9983509444991379711 },
	{ 0.99845906861708000335, 0.00058186151802491737316, 0.99835114728844454035 },
	{ 0.99845926904127446644, 0.00058178743660401894839, 0.99835137777245308577 },
	{ 0.99845948842451415217, 0.00058170904457521040859, 0.9983515995970988488 },
	{ 0.9984597040312035432, 0.00058163320839356988986, 0.99835183229363189117 },
	{ 0.99845991078779516847, 0.0005815524893994291223, 0.99835204240715735846 },
	{ 0.99846011174604709648, 0.00058147939979981985801, 0.9983522741881630802 },
	{ 0.99846027970716755284, 0.00058139780342530793505, 0.99835245641625136592 },
	{ 0.99846049348280230262, 0.00058132074654054224569, 0.99835268636620244642 },
	{ 0.99846070575163159422, 0.00058124283134889200616, 0.9983529056540747515 },
	{ 0.99846093205854691277, 0.000581168730854507193, 0.99835314767754257392 },
	{ 0.99846111733839315594, 0.00058108774483155796377, 0.99835334463036218278 },
	{ 0.99846130063459681558, 0.00058100866615724161036, 0.99835354120171215797 },
	{ 0.99846154385969443368, 0.00058093511879396054261, 0.99835379724419270886 },
	{ 0.99846173728391929281, 0.00058085624992799381097, 0.99835400722420364339 },
	{ 0.99846192943022038513, 0.00058078213036012260942, 0.99835422721779476518 },
	{ 0.99846214204237238032, 0.00058070299446534719926, 0.99835444421684860217 },
	{ 0.99846233624861013833, 0.00058062315285157769552, 0.99835464948570840082 },
	{ 0.99846254760191210931, 0.00058054539024781802101, 0.99835486812508200671 },
	{ 0.99846274571821458377, 0.00058046716988038654303, 0.99835508222496582853 },
	{ 0.9984629588072037043, 0.00058039171516847259946, 0.99835531072533190144 },
	{ 0.99846316300794835108, 0.0005803171378369298113, 0.99835553689873279826 },
	{ 0.99846336146757364016, 0.00058023948967408803343, 0.99835574939644389225 },
	{ 0.99846358653471223299, 0.00058016426384400988318, 0.99835598758614096937 },
	{ 0.99846378570005633879, 0.00058008755028199810062, 0.99835620330727137262 },
	{ 0.9984639716284010591, 0.00058001026451539661796, 0.99835641197121183232 },
	{ 0.9984642084448072108, 0.00057993458092164666424, 0.99835664878761798402 },
	{ 0.99846438025877204403, 0.00057985248863649026946, 0.99835683158791077574 },
	{ 0.99846458465025156315, 0.0005797753554577793518, 0.99835705428993704036 },
	{ 0.99846478354856704751, 0.00057969822227906854257, 0.99835726722633821861 },
	{ 0.99846498153135521125, 0.00057962169945192010181, 0.99835748428261239518 },
	{ 0.99846519175932169077, 0.00057954193413209593479, 0.99835769649422112515 },
	{ 0.99846539042875526171, 0.00057946838676881486704, 0.99835792018806857051 },
	{ 0.99846561314985515789, 0.00057939653694581694492, 0.99835816480553063457 },
	{ 0.9984657912580704453, 0.00057931013405275043511, 0.99835833772575743872 },
	{ 0.99846599873945474091, 0.00057923700630616850246, 0.99835857023155571977 },
	{ 0.99846622655317540662, 0.0005791660529370279073, 0.99835882245933882384 },
	{ 0.99846642173216104688, 0.00057908874809694003624, 0.99835903415596338739 },
	{ 0.99846661628172150849, 0.00057900863945436196242, 0.99835923389351211021 },
	{ 0.99846684567854160353, 0.00057893316566896173888, 0.99835947126304935839 },
	{ 0.99846701978132479383, 0.00057885122597169612595, 0.99835965330040277177 },
	{ 0.99846723496839751011, 0.00057877870857667656178, 0.99835988931572261507 },
	{ 0.99846744012281629654, 0.00057870310127687194478, 0.99836011552727033092 },
	{ 0.99846763608381483568, 0.00057862707436036819268, 0.99836033056175499389 },
	{ 0.99846781125471328888, 0.00057854589760255551324, 0.99836051671898140558 },
	{ 0.99846802396223277576, 0.00057847112953614927486, 0.99836074468528990256 },
	{ 0.99846822282240133006, 0.00057839021980714559919, 0.99836094514763096264 },
	{ 0.9984684502546522511, 0.00057831812202882549537, 0.99836119256889555018 },
	{ 0.99846866147443980033, 0.00057824583351564194135, 0.99836142881309719588 },
	{ 0.99846884931013313302, 0.000578166335224626236, 0.99836162031089981106 },
	{ 0.99846907025739872754, 0.00057808943092775132849, 0.99836185102379038092 },
	{ 0.99846923547193733306, 0.00057800722420167714548, 0.99836202920829952845 },
	{ 0.99846944421217176391, 0.00057793276131105225397, 0.99836225747978379896 },
	{ 0.99846966779157841909, 0.00057786138832521230686, 0.99836250188743747014 },
	{ 0.99846985623762329887, 0.0005777797538037280408, 0.99836269521629472656 },
	{ 0.99847007184431268989, 0.00057770696937990001496, 0.99836292730247622185 },
	{ 0.99847028415128891154, 0.00057763119041871844456, 0.99836315444862488988 },
	{ 0.99847047572538560889, 0.00057755543053102315412, 0.99836336357032895439 },
	{ 0.99847068076536360515, 0.00057747589409303510567, 0.99836357120430097023 },
	{ 0.99847085904524035538, 0.00057739687263917780901, 0.99836376756584255254 },
	{ 0.99847107846662708219, 0.00057732149422120909374, 0.99836399919426044303 },
	{ 0.9984713036291331667, 0.00057725368797731271657, 0.99836425285255503415 },
	{ 0.99847148662016083076, 0.000577171786427019772, 0.99836444042121952336 },
	{ 0.99847168475553671474, 0.00057709373772096503059, 0.99836464755928089332 },
	{ 0.99847187396452097286, 0.00057701683342409001466, 0.9983648538581089138 },
	{ 0.99847208205625681554, 0.0005769422560925472265, 0.99836507781898509162 },
	{ 0.99847230773374695545, 0.00057687099754762539289, 0.99836532119667042995 },
	{ 0.9984724927274908346, 0.00057678903877687339157, 0.99836551072990398215 },
	{ 0.9984726994077888218, 0.00057671678841066250591, 0.9983657444182584273 },
	{ 0.99847289475843592488, 0.00057663694679689311059, 0.99836594510948151182 },
	{ 0.99847310126707222722, 0.00057656338036012565445, 0.99836616912757836229 },
	{ 0.99847328704282911627, 0.00057648685753297721369, 0.99836637626563973225 },
	{ 0.99847349158689635562, 0.00057641018211793809949, 0.99836658874427708366 },
	{ 0.99847372348234308959, 0.00057633781731080920875, 0.99836683399116410431 },
	{ 0.99847388570234418825, 0.00057625562965822130571, 0.99836700876151918127 },
	{ 0.99847411000654351376, 0.00057618452370119025395, 0.99836725564872608185 },
	{ 0.9984742918340887563, 0.00057610431969118045502, 0.99836744674598554283 },
	{ 0.99847451026365419136, 0.00057602932274293842333, 0.99836767326270925427 },
	{ 0.99847470605299137869, 0.00057595667183351468253, 0.99836789503013478875 },
	{ 0.99847492144987248786, 0.00057588268578004787445, 0.99836812633430327413 },
	{ 0.99847509150907653996, 0.00057580036461305546952, 0.99836830234443507681 },
	{ 0.99847531779691833798, 0.00057572727501344620523, 0.99836854114448381203 },
	{ 0.99847551684782154258, 0.00057565304100465710703, 0.99836875896369758898 },
	{ 0.99847572593137867702, 0.00057557678520631723636, 0.99836897910987676408 },
	{ 0.99847592004224905438, 0.00057549719154787023958, 0.99836917341148179172 },
	{ 0.99847612588331347006, 0.00057542013466310465864, 0.99836939420615933294 },
	{ 0.9984763410894598179, 0.0005753526335949894115, 0.99836963863288663568 },
	{ 0.99847651763364919653, 0.00057527160942506740549, 0.9983698246375252161 },
	{ 0.99847673970625050455, 0.00057519769966554593413, 0.99837005323325889172 },
	{ 0.998476928533765129, 0.00057512148201417884023, 0.99837026357566593937 },
	{ 0.99847711842939501636, 0.00057504495918703050789, 0.99837047086631525161 },
	{ 0.99847732144758349904, 0.00057496568977785081269, 0.99837067510520682845 },
	{ 0.99847752808973433414, 0.00057489355385255782368, 0.99837090143119555652 },
	{ 0.99847772347852836727, 0.00057481962501955007235, 0.99837111970817282725 },
	{ 0.99847793443128707302, 0.00057474203407716745965, 0.99837133233939834298 },
	{ 0.9984781542341434335, 0.00057467039406251905088, 0.99837157197868042768 },
	{ 0.99847830464765641167, 0.00057458711922121026225, 0.99837173543845814105 },
	{ 0.9984785448591431134, 0.00057451834022951122141, 0.99837199197684911578 },
	{ 0.99847872483656008313, 0.00057444120705080019534, 0.99837218538200045437 },
	{ 0.99847893783018193403, 0.00057436649620485290529, 0.99837241523658404319 },
	{ 0.99847911153242185911, 0.00057428552925539006445, 0.99837259637748354546 },
	{ 0.99847932467863143025, 0.00057421100914430622461, 0.99837281967078783662 },
	{ 0.99847952853605315138, 0.00057414142906618136509, 0.99837305770789708248 },
	{ 0.99847971492216147649, 0.0005740604811902046958, 0.99837324470435695467 },
	{ 0.99847990008756670743, 0.00057398533165407188226, 0.99837345107947894629 },
	{ 0.99848011756345778078, 0.00057391052544069297552, 0.99837367847358293727 },
	{ 0.99848031707212470121, 0.00057383369743776329631, 0.99837388652717173887 },
	{ 0.99848053306028394793, 0.00057375976860475554498, 0.99837411167060408079 },
	{ 0.99848069865629240915, 0.00057368374168825146762, 0.99837430313025976591 },
	{ 0.99848092921659514776, 0.00057361095726442333335, 0.9983745416251327276 },
	{ 0.99848110059186978571, 0.0005735318595166208084, 0.99837473001395715677 },
	{ 0.99848131905958226184, 0.00057345568001222638286, 0.99837494855796349302 },
	{ 0.99848150451108985681, 0.00057338177025270491149, 0.99837515861426839869 },
	{ 0.99848170081541121057, 0.00057330814659547850703, 0.99837537704383372272 },
	{ 0.99848189635679318599, 0.00057322872459840824681, 0.99837557746802796377 },
	{ 0.99848212050840434717, 0.00057315685570192404473, 0.99837581230079142092 },
	{ 0.9984823214285092341, 0.00057308082878542029263, 0.99837602298652139421 },
	{ 0.99848251941129728682, 0.0005730062896008500644, 0.99837623805915309827 },
	{ 0.99848268115446137116, 0.00057292999565553763379, 0.9983764266577858093 },
	{ 0.9984829153387264622, 0.00057285717308473693959, 0.99837666961585458392 },
	{ 0.99848311225339925201, 0.00057278538048219785738, 0.99837688880835939731 },
	{ 0.99848330356046710587, 0.00057270546257448290851, 0.99837708331977292886 },
	{ 0.99848349522993118388, 0.00057263258278322315756, 0.99837729379569439825 },
	{ 0.99848371074125308322, 0.00057255619347047921868, 0.99837751548682573954 },
	{ 0.99848389682218574581, 0.00057248073875856516669, 0.99837772048865669472 },
	{ 0.99848411738798159565, 0.00057241047203493249356, 0.99837796256934496775 },
	{ 0.99848428786680243352, 0.00057232467949342846064, 0.99837812335883457937 },
	{ 0.99848449862882626693, 0.00057225719749879960189, 0.99837836677466695878 },
	{ 0.99848467982694644185, 0.00057217884361696362203, 0.99837855743323622448 },
	{ 0.99848490626737618214, 0.00057210621178102626962, 0.99837879241858762391 },
	{ 0.99848511376783377624, 0.00057203481972170025938, 0.99837902318869853335 },
	{ 0.99848529622480397538, 0.00057195665657472762131, 0.99837921495352999202 },
	{ 0.99848546834394458216, 0.00057187975227785260539, 0.99837940416251425013 },
	{ 0.99848570430204397486, 0.000571810572742940601, 0.99837965793524974245 },
	{ 0.99848589007780075288, 0.00057173099815797966735, 0.99837984844123106587 },
	{ 0.99848610162183770722, 0.00057165781319093867795, 0.99838007318412047564 },
	{ 0.99848630235120783283, 0.00057158510506105588041, 0.99838029252921312029 },
	{ 0.99848647263929368734, 0.00057150881111574334138, 0.99838048112784583132 },
	{ 0.99848665761396415697, 0.00057142919838380984779, 0.99838067289267717896 },
	{ 0.99848685735151299081, 0.00057135427772951315282, 0.99838088605796038166 },
	{ 0.99848706551954280464, 0.00057127878487062643247, 0.99838110170279659172 },
	{ 0.99848727038785944909, 0.00057120682060671050528, 0.99838132388983868992 },
	{ 0.99848748229429251655, 0.00057113575279665201347, 0.99838155654822469121 },
	{ 0.99848770312711720987, 0.00057106369316530436117, 0.99838178790961373821 },
	{ 0.99848784621641151205, 0.00057098118126344883129, 0.99838194053565121333 },
	{ 0.9984880501310537948, 0.0005709091407055876758, 0.9983821676055057992 },
	{ 0.99848825322553613759, 0.00057083788216066584219, 0.99838239358817171265 },
	{ 0.99848844825193383556, 0.00057075905144167167048, 0.99838258899603904428 },
	{ 0.99848863280698751943, 0.00057068527519655448416, 0.998382794303045773 },
	{ 0.99848885146543475688, 0.00057061188042116376459, 0.99838301875983281874 },
	{ 0.99848904742643329602, 0.00057053936302614420041, 0.99838323982153920344 },
	{ 0.99848922542020768223, 0.0005704625350232145212, 0.99838343078528424268 },
	{ 0.99848943927213640315, 0.00057038845360231609644, 0.998383655013189375 },
	{ 0.99848964736387224583, 0.00057031563103151540223, 0.99838387546454421262 },
	{ 0.99848982907697647615, 0.00057023844063234542783, 0.99838406816397651244 },
	{ 0.99849001038953744125, 0.00057016439735841967142, 0.99838427480612734755 },
	{ 0.99849023099348022114, 0.0005700897437329313297, 0.99838450075064633094 },
	{ 0.99849042624875972152, 0.00057001556694460128825, 0.9983847083273980072 },
	{ 0.99849061622068358002, 0.0005699391204113981842, 0.99838490745459518294 },
	{ 0.9984908076994128967, 0.00056986589729738441803, 0.99838511835013332707 },
	{ 0.99849100373670518493, 0.00056979116737795084801, 0.99838532903586318934 },
	{ 0.99849121222898429284, 0.00056971687614870280148, 0.99838554546271229828 },
	{ 0.99849139043256696091, 0.00056964048683595864576, 0.99838573953543563455 },
	{ 0.99849160695478367256, 0.00056956770241213061992, 0.998385965518101548 },
	{ 0.99849178773328706171, 0.0005694926673169160283, 0.99838616544638503214 },
	{ 0.99849200107023161621, 0.00056942184746217971818, 0.99838639675055362854 },
	{ 0.99849217561170500179, 0.00056934488594484575393, 0.99838658185873829787 },
	{ 0.99849237748548436144, 0.00056927301704836144342, 0.99838680173788862948 },
	{ 0.99849260682508389486, 0.00056919931709718959382, 0.99838703565512476601 },
	{ 0.99849278882429037818, 0.00056912687599611547478, 0.99838724588309102348 },
	{ 0.99849296002790355331, 0.00056904417335939671153, 0.99838740854178220641 },
	{ 0.99849317126676462308, 0.00056897548973512907054, 0.99838764972601679037 },
	{ 0.99849334952756785277, 0.00056889793693971880094, 0.99838783576880230086 },
	{ 0.99849353616163150082, 0.00056882261574220925084, 0.99838803647909890593 },
	{ 0.99849376141950507701, 0.000568751395344260194, 0.9983882722655368358 },
	{ 0.99849395726606282597, 0.00056867746651125244267, 0.99838847940359831679 },
	{ 0.998494151224345039, 0.00056860042869997325012, 0.99838868110571599157 },
	{ 0.9984943196432293222, 0.0005685275298352272192, 0.99838887874518122967 },
	{ 0.99849455232068906607, 0.00056845670998049090909, 0.99838912126455969798 },
	{ 0.99849474095746892921, 0.00056837686836672140535, 0.99838930585776020088 },
	{ 0.9984949036352337437, 0.00056830189049196554521, 0.99838949138556143392 },
	{ 0.99849514680311091119, 0.00056823431312990496135, 0.99838974885855324981 },
	{ 0.99849532235547888703, 0.00056815962135744405969, 0.99838994638357758671 },
	{ 0.99849554189130662607, 0.00056809023201418243354, 0.99839018232260323682 },
	{ 0.99849573556348680814, 0.0005680159598584207754, 0.99839039033804499734 },
	{ 0.99849590772077434497, 0.00056793695747804965029, 0.99839056905661172081 },
	{ 0.99849612344190485924, 0.00056786520302248323644, 0.99839079454336698838 },
	{ 0.99849631188794973902, 0.00056779455482912398814, 0.99839100984488049484 },
	{ 0.9984964927808941404, 0.00056771391212892866572, 0.99839118799124282333 },
	{ 0.99849670472547424893, 0.00056764448463869437121, 0.99839142190847895986 },
	{ 0.9984968926756083718, 0.00056757211983156548047, 0.99839163206015113516 },
	{ 0.99849711001798502341, 0.00056749805748415344409, 0.9983918538657235997 },
	{ 0.99849728484556077301, 0.00056742264091921206046, 0.9983920450964973714 },
	{ 0.9984974913541972974, 0.00056735105812502270844, 0.99839226697836369606 },
	{ 0.99849769942685950852, 0.00056727936088991524292, 0.99839248840246641592 },
	{ 0.99849786372587068239, 0.00056720005333376287936, 0.998392662390808594 },
	{ 0.99849806384488926092, 0.00056712597191286467143, 0.99839287441168245163 },
	{ 0.99849824191495761827, 0.00056704769432497413671, 0.99839305614386009147 },
	{ 0.99849843898221835037, 0.00056697925865602878583, 0.99839328174505626023 },
	{ 0.9984986362020668027, 0.00056690761864138026864, 0.99839349758062745366 },
	{ 0.99849882022306279961, 0.00056683040916872412269, 0.99839368953619378466 },
	{ 0.99849903682157359341, 0.00056676044762087257958, 0.99839392398748760815 },
	{ 0.99849922419950332131, 0.00056668293297243519518, 0.99839411136541722502 },
	{ 0.99849941279813614337, 0.00056660908043337278057, 0.99839431827459679258 },
	{ 0.99849961779996709854, 0.00056653744041872426337, 0.99839453899298036266 },
	{ 0.99849980685636363642, 0.00056646465599489623753, 0.99839474330816591063 },
	{ 0.99850000560209128952, 0.00056639469444704469443, 0.99839496601019217525 },
	{ 0.99850023339673854572, 0.00056632063209963276647, 0.9983951906004934207 },
	{ 0.99850038707181776321, 0.00056624252617311918515, 0.99839535938177392804 },
	{ 0.99850060101911397581, 0.00056617334663820728918, 0.99839559213552742101 },
	{ 0.99850078355237825711, 0.00056609548866701578113, 0.99839577955160396794 },
	{ 0.99850097648069224832, 0.00056602279961061937198, 0.99839599006567247841 },
	{ 0.99850114158078995263, 0.0005659480315442131336, 0.99839617774877786882 },
	{ 0.99850134093686915282, 0.00056587395012331481725, 0.998396382750608824 },
	{ 0.99850156516477450719, 0.00056580505669069766292, 0.99839662574682452867 },
	{ 0.99850174697324622919, 0.00056572975456667439279, 0.99839681716833317271 },
	{ 0.9985019505827127384, 0.00056565889656496552273, 0.99839703668508716916 },
	{ 0.99850214463636255413, 0.00056558637916994595855, 0.99839724813375652079 },
	{ 0.99850233775541163972, 0.00056551384270144022283, 0.99839745677862334894 },
	{ 0.99850253894254537013, 0.00056543976128054190648, 0.99839766864690937531 },
	{ 0.99850273208066797626, 0.00056536480247927243473, 0.99839787017736592034 },
	{ 0.99850290580198131085, 0.0005652872115368896052, 0.99839805183324958904 },
	{ 0.99850311568662497574, 0.00056521923363161616621, 0.99839828613195558127 },
	{ 0.9985033109800515172, 0.00056514665901613754528, 0.99839849218282827881 },
	{ 0.99850351998731468051, 0.00056507452309084477311, 0.99839871370229837932 },
	{ 0.9985037076513466614, 0.00056500080406618675196, 0.99839891483221165913 },
	{ 0.99850390508100372866, 0.00056492956459475130674, 0.99839913061056240196 },
	{ 0.99850406463071694763, 0.00056485142052126494864, 0.99839929740820021475 },
	{ 0.99850428077146380357, 0.00056478237450075712087, 0.9983995364371308634 },
	{ 0.9985044530431922416, 0.00056470653831911660214, 0.99839971755895695615 },
	{ 0.99850463185712645675, 0.00056463056862307168995, 0.99839990854177562696 },
	{ 0.99850485762998408834, 0.00056455917656374546287, 0.99840013935003357748 },
	{ 0.99850502820417241789, 0.00056448511421633353492, 0.99840033128652638794 },
	{ 0.99850521109983281232, 0.00056440857231569881419, 0.99840051914129313015 },
	{ 0.99850543916150880097, 0.00056434362709475147969, 0.99840077234182400545 },
	{ 0.99850561984464480947, 0.0005642684584851324946, 0.99840096164617564423 },
	{ 0.99850583220884159275, 0.00056420036613894105054, 0.99840119560155871081 },
	{ 0.99850599763318848012, 0.00056411993324709524145, 0.99840136094961162705 },
	{ 0.99850618203565422171, 0.00056404997169924369835, 0.99840157327566125822 },
	{ 0.99850638047620599025, 0.00056397451698732975478, 0.99840177339467972573 },
	{ 0.99850658051893059763, 0.0005639008170361580136, 0.99840197862539259432 },
	{ 0.99850677174970459138, 0.00056383013069582598852, 0.99840219221029247176 },
	{ 0.99850699292585209932, 0.00056376749336672438498, 0.99840244588766058342 },
	{ 0.99850717055723015037, 0.00056368736565065992276, 0.99840262386236133807 },
	{ 0.9985073817770176996, 0.00056362110435915612622, 0.99840286086950247313 },
	{ 0.99850753554746440876, 0.00056353905022097261664, 0.9984030157080644452 },
	{ 0.99850775725766949265, 0.00056346779167605078303, 0.99840323863897262324 },
	{ 0.99850792962476553338, 0.00056339781105471285153, 0.99840344533834379792 },
	{ 0.99850813598081411548, 0.00056332302391482022477, 0.99840365238103778722 },
	{ 0.99850833526059923351, 0.0005632494765515390486, 0.99840386142644765854 },
	{ 0.99850851127073092517, 0.00056317982017946874394, 0.99840406520757551956 },
	{ 0.99850870562955662546, 0.00056310486137819916377, 0.99840426483068334118 },
	{ 0.99850886300489227754, 0.00056302736580324795092, 0.99840443448934412807 },
	{ 0.99850907607480798855, 0.00056295757591677346963, 0.99840466014776074744 },
	{ 0.99850927062436845016, 0.00056288387596560172845, 0.99840485958013369672 },
	{ 0.99850949164792812685, 0.00056281803429079706701, 0.99840510639104662616 },
	{ 0.99850966563627041594, 0.0005627388793225354853, 0.998405284194086029 },
	{ 0.99850985494062227676, 0.00056266832649660785369, 0.99840548894796155022 },
	{ 0.99851005620404997831, 0.00056260195076418605207, 0.99840572072896727196 },
	{ 0.9985102419035127852, 0.0005625273352856703787, 0.99840591619405494317 },
	{ 0.99851042237684051184, 0.0005624513846631118549, 0.99840610452565892174 },
	{ 0.9985106208173923914, 0.00056237638771486960637, 0.99840630494985305177 },
	{ 0.99851081956311982246, 0.00056230764687014323389, 0.9984065259734125064 },
	{ 0.99851098985120578799, 0.00056223013222170574107, 0.99840670358571703691 },
	{ 0.9985111905805759136, 0.00056216123878908858674, 0.99840692171010669842 },
	{ 0.99851137414380841673, 0.00056208509743166682956, 0.99840711076650312528 },
	{ 0.99851160115644266302, 0.00056202410042238953175, 0.99840737295064607704 },
	{ 0.99851176885053449794, 0.00056194399177981145792, 0.99840753759297984349 },
	{ 0.99851194819852651108, 0.00056187122642946960363, 0.99840773742589594697 },
	{ 0.99851214862272086314, 0.00056179928123904006483, 0.99840794410619349009 },
	{ 0.99851236775800544798, 0.00056173258125735063637, 0.99840818529042807405 },
	{ 0.99851253400251238634, 0.00056165880501223345005, 0.99840836969289381564 },
	{ 0.99851273724958267142, 0.00056158739387942094301, 0.99840858880910465789 },
	{ 0.99851291135236586172, 0.00056151033699465547049, 0.99840876291188773717 },
	{ 0.99851310628339606801, 0.00056143701851321019605, 0.99840896913442167548 },
	{ 0.99851329371854613548, 0.0005613682585949975436, 0.99840917838963982867 },
	{ 0.99851349925443477762, 0.00056129669487429436313, 0.99840939521703231385 },
	{ 0.99851368131086182256, 0.00056122297584963623356, 0.99840958875569785214 },
	{ 0.99851386838361566589, 0.00056115309059573013559, 0.99840979902181092864 },
	{ 0.99851406011030019449, 0.00056107717812014428014, 0.99840999044331957268 },
	{ 0.99851424008771727525, 0.00056100492775393339447, 0.99841018720540442022 },
	{ 0.99851441777631588792, 0.0005609296256299099075, 0.99841037801656151718 },
	{ 0.99851463078901103732, 0.00056086309730959743244, 0.99841060567769424061 },
	{ 0.99851482736036123455, 0.00056079004585696083651, 0.99841081346425419873 },
	{ 0.99851502969190431003, 0.00056072077095461721544, 0.99841103349599236161 },
	{ 0.99851522424146477164, 0.00056065195381594539782, 0.99841125123891216742 },
	{ 0.99851539611265016649, 0.00056057670891238096759, 0.99841142921361292206 },
	{ 0.99851561026975466095, 0.0005605091887707795489, 0.9984116581717427108 },
	{ 0.99851579879209362289, 0.00056043327629519369346, 0.99841185081395433798 },
	{ 0.99851596373960338493, 0.0005603598815198030823, 0.99841203712376869195 },
	{ 0.99851613576337661105, 0.00056028265297366054796, 0.99841220960530541184 },
	{ 0.99851636023923728835, 0.00056021644890261559132, 0.99841245319279925408 },
	{ 0.99851654523298127852, 0.00056014173805666830127, 0.99841264654073014206 },
	{ 0.9985167175237832371, 0.00056007278740359219861, 0.99841284862431756153 },
	{ 0.9985169252340493351, 0.00055999988853884638453, 0.99841305663975932205 },
	{ 0.99851712008878568128, 0.00055992801964236207403, 0.99841326309117517379 },
	{ 0.99851730998441545761, 0.00055985821068240120436, 0.99841347297581861664 },
	{ 0.99851748889371716444, 0.00055978138267947163357, 0.9984136547842901166 },
	{ 0.99851768620893321948, 0.00055971483528567287855, 0.99841387777241863422 },
	{ 0.99851786092206795686, 0.00055963930427981370668, 0.99841405828389306887 },
	{ 0.9985180479948218002, 0.00055956575691653253051, 0.9984142526808655882 },
	{ 0.99851824225827989778, 0.00055949775993777270313, 0.99841447708043207232 },
	{ 0.99851844481870477566, 0.00055942352592898371335, 0.99841467628392310818 },
	{ 0.99851860270902448313, 0.00055935207664919842953, 0.99841486225041464753 },
	{ 0.99851882728025243008, 0.00055928489983035080922, 0.9984150967398555121 },
	{ 0.99851901278898036463, 0.00055921093285037038953, 0.99841529071721124566 },
	{ 0.99851921039029867266, 0.00055914120018435485657, 0.9984155044928457734 },
	{ 0.9985193828718356146, 0.00055906771004153262873, 0.99841568975361827398 },
	{ 0.99851959481641561212, 0.00055899889290286081112, 0.99841591451558098225 },
	{ 0.99851973439618857409, 0.00055892271339846638558, 0.99841607728871306637 },
	{ 0.99851996312543656042, 0.00055885603249026334551, 0.99841631608876169057 },
	{ 0.99852014668866895253, 0.00055878263771487284278, 0.99841650728138853221 },
	{ 0.99852033688947450241, 0.00055870870888186509144, 0.99841670144947924914 },
	{ 0.99852050855085139336, 0.00055863439857913087336, 0.99841688745411782957 },
	{ 0.99852072223111876248, 0.00055856678307009762115, 0.99841711662205590017 },
	{ 0.99852088981076980723, 0.00055849327385378911334, 0.99841729900273201714 },
	{ 0.99852110391065374007, 0.00055843004524661131287, 0.99841754346760613892 },
	{ 0.9985212855283904787, 0.00055835470497561526595, 0.99841772828968844422 },
	{ 0.99852145978376150026, 0.00055828054726077150447, 0.99841791170033300507 },
	{ 0.99852165440961593301, 0.00055820905983401376913, 0.99841811838063054818 },
	{ 0.99852184537336108328, 0.00055814077675295920011, 0.99841832872303770685 },
	{ 0.99852201692029718405, 0.00055806680977297878042, 0.99841851064595010801 },
	{ 0.99852221608564128985, 0.0005579912406201469402, 0.9984187072173000832 },
	{ 0.99852242844983796211, 0.00055792696297122113935, 0.99841894475849857216 },
	{ 0.99852258918210734517, 0.00055785492241335987544, 0.99841912898930285092 },
	{ 0.99852279132291543728, 0.00055778019249392630542, 0.99841932762058926976 },
	{ 0.99852298144742712704, 0.00055770908653689514525, 0.99841953056248367027 },
	{ 0.99852319167539327349, 0.00055764442741824276923, 0.99841976665409726266 },
	{ 0.99852335795804703089, 0.00055756656944705126119, 0.9984199332419267936 },
	{ 0.99852356505796158181, 0.00055750137627078174499, 0.99842016704472213995 },
	{ 0.998523703073708635, 0.00055741859734011764502, 0.99842030353459021441 },
	{ 0.99852390410825453415, 0.00055735473930789097927, 0.99842052898319855192 },
	{ 0.9985240900175256229, 0.0005572820502514944617, 0.9984207276335584913 },
	{ 0.99852428613111199329, 0.0005572117453808891202, 0.99842093427570921538 },
	{ 0.99852445138379763989, 0.00055713926613284244123, 0.99842111936482047518 },
	{ 0.99852469384595576862, 0.00055707105934573320893, 0.99842135999592396267 },
	{ 0.99852484910413452646, 0.00055700033485842851549, 0.99842154287251061451 },
	{ 0.99852505917951295267, 0.00055693224251223728827, 0.99842176752003253259 },
	{ 0.99852525746747688995, 0.00055686151802493281168, 0.9984219755736213342 },
	{ 0.9985254295866173857, 0.00055678705513430781174, 0.9984221574583868053 },
	{ 0.99852559741422364237, 0.00055671448051882940766, 0.99842233898075605225 },
	{ 0.99852580417081537867, 0.00055664322197390768247, 0.99842254970463284458 },
	{ 0.99852598832532579731, 0.00055657606422854645056, 0.9984227632323121604 },
	{ 0.99852616301938701415, 0.00055649898827029458965, 0.9984229376211976037 },
	{ 0.99852638137265858909, 0.00055643566429568506407, 0.9984231764212462279 },
	{ 0.99852656236097037112, 0.00055636450111819484715, 0.998423376597485146 },
	{ 0.99852673945829095725, 0.00055629043877078291919, 0.99842356048496672116 },
	{ 0.9985269168035667553, 0.00055621685326052896624, 0.99842374790104326809 },
	{ 0.9985271015493553115, 0.00055614891350222830403, 0.99842395568760311519 },
	{ 0.99852729461118394649, 0.0005560789901013495377, 0.99842416316898729978 },
	{ 0.99852747523709939337, 0.00055600403130007995754, 0.99842434631260290612 },
	{ 0.99852769107267047577, 0.00055593834221316596952, 0.99842457847507837254 },
	{ 0.99852788119718216553, 0.00055587028801394730224, 0.99842478874119144905 },
	{ 0.99852804809018747001, 0.00055579624474002165425, 0.99842496509464595533 },
	{ 0.99852822707578314798, 0.00055572132408572474244, 0.99842514926822978349 },
	{ 0.99852842276975295466, 0.00055565822899295144385, 0.99842537990482638222 },
	{ 0.99852861945554394207, 0.00055558513939334217956, 0.9984255793371993315 },
	{ 0.99852879546567563374, 0.00055551243126345938202, 0.998425763129313526 },
	{ 0.99852898780271182044, 0.00055544079124881108166, 0.99842596782596870764 },
	{ 0.9985291687528765614, 0.00055536958992434819638, 0.9984261589232280576 },
	{ 0.99852935109540585934, 0.00055529741585208264743, 0.99842634828480025799 },
	{ 0.9985295503942644979, 0.00055523128807498302751, 0.99842657119663480447 },
	{ 0.99852972236081705137, 0.00055515484154178003189, 0.9984267428580115844 },
	{ 0.99852993201657869182, 0.00055509105980349881127, 0.99842697692783566321 },
	{ 0.99853009866162878438, 0.00055501592934085216928, 0.99842715230854239827 },
	{ 0.99853027955457307474, 0.00055494779884768816527, 0.99842735700519757991 },
	{ 0.99853046571179959745, 0.00055487638771487576665, 0.99842755048664277862 },
	{ 0.99853066674634560762, 0.00055480688393069613543, 0.99842776372821995245 },
	{ 0.99853085431501009683, 0.00055473520576907516672, 0.99842795884998492006 },
	{ 0.99853101434156033012, 0.0005546603995556963684, 0.9984281312361542593 },
	{ 0.99853124675199134153, 0.00055459839165164363014, 0.99842838462742000694 },
	{ 0.99853139913007349371, 0.0005545202857251299404, 0.99842853956134924864 },
	{ 0.99853159892484277815, 0.00055445717155887025342, 0.9984287683096706445 },
	{ 0.99853179534360503311, 0.00055438587486697575146, 0.99842897205265157545 },
	{ 0.99853198504850004813, 0.00055431572258426097498, 0.99842917358310800946 },
	{ 0.99853214972898085566, 0.00055424343407107752937, 0.99842935436161128759 },
	{ 0.99853232583448003901, 0.0005541687613721030161, 0.99842953046711047094 },
	{ 0.99853252246305057582, 0.00055410049736453472705, 0.99842974616916735364 },
	{ 0.99853274524137092261, 0.00055403641045047215957, 0.99842998359592505242 },
	{ 0.99853292399808479818, 0.00055396553337527690113, 0.99843017883213103225 },
	{ 0.99853310058042121788, 0.00055389538109256212465, 0.99843037197025352736 },
	{ 0.99853327002927372291, 0.00055381992638064796424, 0.99843054340274861591 },
	{ 0.99853344779416630672, 0.00055374836265994489218, 0.99843073703678164588 },
	{ 0.99853365910932123661, 0.0005536804419751302931, 0.99843095819385552225 },
	{ 0.99853382550641578419, 0.00055360819160891951585, 0.99843113939197547513 },
	{ 0.99853400712415241181, 0.00055354139625979847071, 0.9984313440504837267 },
	{ 0.9985342046491767487, 0.00055347189247561894791, 0.99843155240924819083 },
	{ 0.99853439301892765734, 0.00055340269386722055513, 0.99843176046283688141 },
	{ 0.99853459733411309429, 0.00055333448708011132283, 0.99843196966083480604 },
	{ 0.99853477282926073055, 0.00055326252281619528722, 0.9984321563711923142 },
	{ 0.99853495257779567584, 0.00055319141685916401862, 0.99843234893711008127 },
	{ 0.9985351242391725668, 0.0005531213790173671388, 0.99843254104526424353 },
	{ 0.99853530969067993972, 0.00055305002510501379692, 0.99843273408801924695 },
	{ 0.99853549527570184541, 0.00055297750770999444959, 0.99843292447955955815 },
	{ 0.99853567984982893879, 0.00055291031181766044089, 0.99843313270480971156 },
	{ 0.99853587710782432119, 0.0005528400832410003277, 0.99843333927066646449 },
	{ 0.99853607943936717461, 0.00055277263939334402888, 0.99843355197818584035 },
	{ 0.99853623799725887977, 0.00055270029365970152653, 0.99843372827441989603 },
	{ 0.99853641965314254847, 0.00055262850105716255274, 0.9984339163389949201 },
	{ 0.99853660952969902631, 0.00055255947411014111337, 0.99843412238986772866 },
	{ 0.99853679864331579275, 0.00055248884499026814504, 0.99843431939990778812 },
	{ 0.99853699004575102727, 0.00055242195427371548321, 0.99843452960880041402 },
	{ 0.99853714240475954789, 0.00055234451591922321869, 0.99843468227298493023 },
	{ 0.99853735015317268697, 0.00055227714836551214817, 0.99843490528018685737 },
	{ 0.99853753257199573401, 0.00055220718681766060507, 0.99843510265262336301 },
	{ 0.99853771521970069447, 0.00055214081108523880344, 0.99843530910403921474 },
	{ 0.99853787917538916474, 0.00055207100212527782535, 0.99843549060733494116 },
	{ 0.99853808673306732047, 0.00055200146019412541735, 0.99843570342929510719 },
	{ 0.99853828952237400074, 0.0005519356948132659842, 0.99843592697055472129 },
	{ 0.99853846648618016513, 0.0005518647795910980574, 0.99843611568362822251 },
	{ 0.99853864741727138554, 0.00055179279625369595866, 0.9984363051596413241 },
	{ 0.99853882495328216695, 0.00055172436058475071621, 0.99843650237948999848 },
	{ 0.99853901055737748216, 0.00055164984047366676795, 0.99843668386371231538 },
	{ 0.99853920232220871878, 0.00055158411323978022, 0.99843689615161490547 },
	{ 0.99853937512799473275, 0.0005515135413403662, 0.99843708360583827144 },
	{ 0.99853955636426183773, 0.00055144316017581552179, 0.99843727743060617374 },
	{ 0.9985397370664710337, 0.00055137399971438979737, 0.99843747400195603792 },
	{ 0.99853992785855461012, 0.00055130348503543483412, 0.99843767070682043485 },
	{ 0.99854011516019025585, 0.00055123352348758329101, 0.99843787143619044944 },
	{ 0.99854030864163534353, 0.00055116455376102090839, 0.99843807468326062349 },
	{ 0.99854047357007147401, 0.0005510930091138041163, 0.99843825609118885822 },
	{ 0.99854064391537777912, 0.0005510230284924661848, 0.99843844230563572051 },
	{ 0.99854083793088055376, 0.0005509526091809426214, 0.99843864196689036117 },
	{ 0.99854102622433749126, 0.00055088394463016147722, 0.99843884796054260811 },
	{ 0.99854121568127718334, 0.00055081644356204633849, 0.99843904775531167051 },
	{ 0.99854138245984147559, 0.00055074671089603080554, 0.99843923314959870385 },
	{ 0.99854158166333262248, 0.00055067842781497623652, 0.99843944562823616629 },
	{ 0.99854176980420161769, 0.00055061083137942926427, 0.99843964719683953035 },
	{ 0.99854196450635002158, 0.00055054308235599194385, 0.99843985654742539726 },
	{ 0.99854213447018658201, 0.00055046932518436114592, 0.99844003242404266718 },
	{ 0.99854234197064406509, 0.00055040396034671478474, 0.99844026014239573019 },
	{ 0.99854250003262512436, 0.00055032867729617779458, 0.99844041858584664517 },
	{ 0.99854270129605282591, 0.00055026413261844342364, 0.9984406430426335799 },
	{ 0.99854287692471477289, 0.00055019409477664654382, 0.9984408281317448397 },
	{ 0.99854306216641386396, 0.00055012420952274044585, 0.99844102680117829962 },
	{ 0.99854323790951671214, 0.00055005062401248670974, 0.99844120605380271005 },
	{ 0.99854342555447506147, 0.00054998283684207650412, 0.99844141010195952557 },
	{ 0.99854361583157447146, 0.00054991798698856089473, 0.99844162082583620688 },
	{ 0.9985437908689583919, 0.00054984632790042609757, 0.99844180787951652967 },
	{ 0.9985439875547492683, 0.00054977812111331686527, 0.99844201219470207764 },
	{ 0.99854416669293266651, 0.00054971250832034810555, 0.9984422175780027775 },
	{ 0.99854433835430944644, 0.00054963514625980117775, 0.99844237733752405628 },
	{ 0.99854453893109151874, 0.00054957342445804328954, 0.99844261011035106979 },
	{ 0.99854470471783451924, 0.00054949491798831674467, 0.99844276826769962074 },
	{ 0.99854490336819445861, 0.00054943184196902961763, 0.99844299079806442254 },
	{ 0.99854510211392188967, 0.00054936767876102193028, 0.99844321243197531324 },
	{ 0.99854527247830149328, 0.0005492974120373890403, 0.99844339561373796066 },
	{ 0.99854544619961471685, 0.00054922531425906893649, 0.99844357223422131042 },
	{ 0.99854562121792500573, 0.00054915588676883464198, 0.99844376617343011393 },
	{ 0.99854581847592049915, 0.00054908787071658853463, 0.99844397548586893976 },
	{ 0.9985459665624681902, 0.00054901516258670573709, 0.99844414081484833545 },
	{ 0.99854617116375588015, 0.00054895048439456697268, 0.99844436048419027419 },
	{ 0.99854638596935874073, 0.00054888567268802403165, 0.9984445871153547758 },
	{ 0.99854655030651684466, 0.00054880983650638351292, 0.99844475541979804678 },
	{ 0.998546714872556751, 0.00054874185860111007393, 0.99844493783862131586 },
	{ 0.99854691335125533858, 0.00054867330849124693482, 0.99844514562518127399 },
	{ 0.99854706242962432139, 0.00054859869301273126146, 0.99844530080706594966 },
	{ 0.99854722171230858585, 0.00054852829277469419486, 0.99844548019320478183 },
	{ 0.99854743337078621934, 0.00054846552193118841469, 0.99844571233660683873 },
	{ 0.99854762845440425689, 0.00054839784920169610573, 0.99844591916949254617 },
	{ 0.99854779166622675834, 0.00054832355797244816762, 0.99844608199984519192 },
	{ 0.99854799739285027282, 0.00054826011955692074539, 0.99844631130129757324 },
	{ 0.99854818465633887747, 0.00054819156944705749786, 0.99844650710970805907 },
	{ 0.99854835235043060138, 0.00054811909019901071047, 0.99844668304354577959 },
	{ 0.99854855323238855824, 0.00054805752098514360412, 0.99844691108614813668 },
	{ 0.99854872306271058591, 0.00054798473656131546985, 0.99844708427340389534 },
	{ 0.99854890202923274334, 0.00054791429817630584332, 0.99844727304369795817 },
	{ 0.99854906161709278134, 0.00054784271538211638287, 0.99844745006472446214 },
	{ 0.99854927447719998845, 0.00054777817070438212035, 0.99844767238528098208 },
	{ 0.99854943709774424132, 0.00054770771324588610543, 0.99844784881502923746 },
	{ 0.99854964808864976611, 0.00054764320671512451127, 0.99844807529360590781 },
	{ 0.9985498126356161519, 0.00054757223427249763614, 0.99844825174242779475 },
	{ 0.99854997603817330365, 0.00054749851524783961498, 0.99844841953188678829 },
	{ 0.9985501785604509184, 0.00054743233025028104673, 0.99844863357455015951 },
	{ 0.99855035258694013756, 0.00054736374199344502243, 0.9984488234701797138 },
	{ 0.99855054591579739398, 0.00054729736626102311239, 0.99844903144747454427 },
	{ 0.99855070832653347601, 0.0005472272330517947243, 0.99844921026140875941 },
	{ 0.99855090073986341181, 0.00054715719520999784448, 0.99844940603167220416 },
	{ 0.9985510700742747936, 0.00054708589851810345093, 0.99844958497912073003 },
	{ 0.99855124692363983474, 0.00054701891243411895557, 0.99844977952868108062 },
	{ 0.99855145516796339766, 0.00054695463478519326314, 0.99845000104815118114 },
	{ 0.99855165723247740761, 0.00054688913643314261692, 0.99845022165209385001 },
	{ 0.99855179549617978374, 0.00054681446373416799523, 0.9984503702154786664 },
	{ 0.99855196879787655462, 0.00054674484550907025051, 0.99845055717379149751 },
	{ 0.99855215253277007648, 0.00054667673408939241805, 0.99845074911028419695 },
	{ 0.99855237439556299162, 0.00054661539375736121343, 0.99845099538713955045 },
	{ 0.99855254584713148969, 0.00054654754936649216791, 0.99845118194490911634 },
	{ 0.99855270474834589844, 0.00054647348701908013153, 0.99845134405046920278 },
	{ 0.99855289836330540787, 0.00054640655815555469292, 0.99845154819399328794 },
	{ 0.99855309375209932998, 0.00054634041130496890145, 0.99845176067263075037 },
	{ 0.99855326116008868986, 0.00054627100288822088691, 0.99845193841844959159 },
	{ 0.9985534270231256615, 0.00054620035469486163861, 0.99845211740404515854 },
	{ 0.9985536275617605817, 0.00054613371193363115848, 0.99845232946306594624 },
	{ 0.99855380074901634035, 0.0005460664206738655331, 0.99845251851946237309 },
	{ 0.99855399953289070147, 0.00054599977791263516139, 0.99845273034960146941 },
	{ 0.99855415444774653366, 0.00054593031227542809011, 0.99845290517717688594 },
	{ 0.99855433915538793777, 0.00054586096107913913231, 0.99845309400469139938 },
	{ 0.99855450059337624857, 0.00054578741371585795614, 0.998453261546195181 },
	{ 0.99855472085399621385, 0.00054572416603519398413, 0.99845349553972528867 },
	{ 0.99855486913127877724, 0.00054564852058841659035, 0.99845364404588976548 },
	{ 0.99855506772441837704, 0.00054558740913822139588, 0.99845386918932232945 },
	{ 0.9985552263395305328, 0.00054551988899661986877, 0.99845405359178807103 },
	{ 0.99855540194911907026, 0.00054544697105838744946, 0.99845422847658416021 },
	{ 0.99855561694545680318, 0.00054538486778690309451, 0.99845445781618380465 },
	{ 0.9985557842580787824, 0.00054531185448123905852, 0.99845463291078817569 },
	{ 0.99855595496578131165, 0.00054524483025028189481, 0.99845481719881290505 },
	{ 0.9985561262456883469, 0.00054517639458133665235, 0.99845500526338804015 },
	{ 0.99855635793132668798, 0.00054511499702884639099, 0.9984552498808501042 },
	{ 0.99855651967449055029, 0.00054504480659915905457, 0.9984554238310452412 },
	{ 0.99855668124599317181, 0.00054497364342166894607, 0.99845559825807750354 },
	{ 0.99855687316341257276, 0.00054490921318485236336, 0.99845580825716173656 },
	{ 0.99855705451412035689, 0.0005448395568127820587, 0.99845599769502779708 },
	{ 0.99855724265498946313, 0.00054477073967411013267, 0.99845618980318195934 },
	{ 0.99855737136287503475, 0.00054469940483524317918, 0.99845634139925110162 },
	{ 0.99855759162349511104, 0.0005446358519787978603, 0.99845657279878707868 },
	{ 0.9985577735273342137, 0.00054456644356204984576, 0.99845676221757961866 },
	{ 0.99855795747203623947, 0.00054450075447513585775, 0.9984569626417738597 },
	{ 0.9985581083814597525, 0.00054443010628177660945, 0.99845712758928351072 },
	{ 0.99855831315440879425, 0.00054436693489505786573, 0.99845735006242797294 },
	{ 0.99855845920009345118, 0.00054429111778690351855, 0.99845749927431137749 },
	{ 0.9985586638204547727, 0.00054422687828495038605, 0.99845771823793427746 },
	{ 0.99855885550899226022, 0.00054416099846317305625, 0.99845792167573943487 },
	{ 0.99855900670451813728, 0.00054408918678714769408, 0.99845808236986155482 },
	{ 0.99855920529765773708, 0.00054402227699710864386, 0.9984582910338019035 },
	{ 0.99855937367839475716, 0.00054395704567386635089, 0.99845848260789848982 },
	{ 0.99855956792277944523, 0.00054388883888675690174, 0.99845868509202928553 },
	{ 0.99855973973674416744, 0.00054382078468753823446, 0.99845886911302528244 },
	{ 0.99855991380138031666, 0.00054375200569583897678, 0.99845905370622578534 },
	{ 0.99856008126659023816, 0.00054368540108158127343, 0.99845924146562503587 },
	{ 0.99856026313228218871, 0.00054361496269657164689, 0.9984594295111265394 },
	{ 0.99856044577998703815, 0.00054354614555789982928, 0.99845961765199564564 },
	{ 0.9985606319753603799, 0.00054348171532108335499, 0.9984598242178525096 },
	{ 0.9985608159963563768, 0.00054341488182498964149, 0.99846002349763762762 },
	{ 0.99856095958156132486, 0.00054334240257694285409, 0.9984601759329402304 },
	{ 0.99856114795131201145, 0.00054327381432010682979, 0.99846037254243713566 },
	{ 0.99856134505671945156, 0.00054321098625614199287, 0.9984605896368583533 },
	{ 0.99856151269359061384, 0.0005431403952832416929, 0.99846076234727687559 },
	{ 0.99856169434947417152, 0.00054307470619632759647, 0.99846095926194966541 },
	{ 0.99856189458293354022, 0.0005430127173657612466, 0.99846118299394415185 },
	{ 0.99856205237788575602, 0.00054294254600956019016, 0.99846135402589586416 },
	{ 0.9985622522680223101, 0.00054287388145877904597, 0.99846155269532932408 },
	{ 0.99856243268412936409, 0.00054280954658939418837, 0.99846175580888518741 },
	{ 0.9985625858632979357, 0.00054273762047245103796, 0.99846191665559513861 },
	{ 0.99856277060908638088, 0.00054266907036258779044, 0.99846210819154468386 },
	{ 0.99856293908519100366, 0.00054260240852787092192, 0.99846229738145542143 },
	{ 0.99856313483638103889, 0.00054253887474491199142, 0.99846251102357574947 },
	{ 0.99856327678126621805, 0.00054246277153446279418, 0.99846265251069732383 },
	{ 0.99856347762507702281, 0.00054239956200077127368, 0.99846287120729138032 },
	{ 0.99856365920466672037, 0.0005423308974499901295, 0.99846306072145141197 },
	{ 0.99856384177607770969, 0.00054226749718143548405, 0.99846326221376069388 },
	{ 0.99856404761714190332, 0.00054220234215213874464, 0.99846347873597740552 },
	{ 0.99856418616694653245, 0.00054213459312870142422, 0.99846364414125066133 },
	{ 0.99856437999171443476, 0.00054206161797001005658, 0.99846382522492971301 },
	{ 0.99856455897731000171, 0.00054199646294071320875, 0.99846402282624791003 },
	{ 0.99856475718897985683, 0.00054193497002079133069, 0.99846424514680442996 },
	{ 0.99856492389125017795, 0.00054186409294559607225, 0.99846441612153558065 },
	{ 0.99856509044093277883, 0.00054179657280399465356, 0.99846459945588605933 },
	{ 0.99856528918666020989, 0.00054173347771122124655, 0.99846481162934785925 },
	{ 0.99856545453471290408, 0.00054166410744144600879, 0.99846498937516681149 },
	{ 0.99856563931864827932, 0.00054159651100589914496, 0.99846518148332086273 },
	{ 0.99856579852503846162, 0.00054152527153446369974, 0.99846535053162999152 },
	{ 0.99856597670954749812, 0.00054146061241581143215, 0.99846554809480125847 },
	{ 0.99856616908473050387, 0.00054139702141239344491, 0.99846575748353405544 },
	{ 0.99856633071345368702, 0.0005413261061902255181, 0.99846592544465440078 },
	{ 0.99856651385706918234, 0.00054125725090458092371, 0.99846611499696147352 },
	{ 0.99856669276637077814, 0.00054119339287235436638, 0.99846631191163415231 },
	{ 0.99856686650675763328, 0.0005411258536572665593, 0.99846649965195999332 },
	{ 0.99856704541605922909, 0.00054105772316410266371, 0.99846668832688656448 },
	{ 0.99856721463602970967, 0.00054099317848636829277, 0.9984668816557438209 },
	{ 0.99856739774149827493, 0.00054092237770511837104, 0.99846706476121238616 },
	{ 0.99856757626933012606, 0.00054085798561527456511, 0.99846726404099739316 },
	{ 0.99856774030131245645, 0.00054078825294925914058, 0.99846743173508900604 },
	{ 0.99856793300074453423, 0.00054072136223270647875, 0.9984676313391231961 },
	{ 0.99856812568110331352, 0.00054065914452030411873, 0.99846784828095658249 },
	{ 0.9985683017675288653, 0.00054058864891483554387, 0.99846802680878843361 },
	{ 0.99856844853800619255, 0.00054052175819828288204, 0.99846819772629924472 },
	{ 0.99856864694041080899, 0.00054045587837650555223, 0.99846839933304964987 },
	{ 0.99856881770533378884, 0.00054038486778690590032, 0.99846857204346817216 },
	{ 0.99856900201243192772, 0.0005403233557934977423, 0.99846878316788822971 },
	{ 0.9985691694776417382, 0.00054025522530033362988, 0.99846896451859612487 },
	{ 0.99856935059946771993, 0.00054018945991947430515, 0.99846915723710172319 },
	{ 0.99856954778116913118, 0.00054012167274906420795, 0.99846935686020943379 },
	{ 0.99856970971506786583, 0.00054005502998783372782, 0.99846953596024590194 },
	{ 0.99856986611765563566, 0.00053998560249759943331, 0.99846970456986494646 },
	{ 0.99857006854456586975, 0.00053992130577518735249, 0.99846991847901400696 },
	{ 0.99857021945398960483, 0.00053985157310917181953, 0.99847008129029313217 },
	{ 0.99857041543406144246, 0.00053978639900638858331, 0.99847028909592638879 },
	{ 0.99857060687464360704, 0.00053972595512821481406, 0.99847050407319071219 },
	{ 0.99857076182764636929, 0.00053965492546512909902, 0.99847066482453328273 },
	{ 0.99857091498774130933, 0.00053958484947635955084, 0.99847083225159627418 },
	{ 0.99857110289972850214, 0.00053951824486210184749, 0.9984710317602631946 },
	{ 0.99857129464548655129, 0.00053945577919437730577, 0.99847124071030568526 },
	{ 0.99857147210520313951, 0.00053938940346195539573, 0.9984714303770536592 },
	{ 0.99857163773935830875, 0.0005393198996777757645, 0.99847160898117948147 },
	{ 0.99857182164591351548, 0.00053925348579838140294, 0.9984717957869043703 },
	{ 0.9985720149747707719, 0.00053919016182377198579, 0.99847200437455063682 },
	{ 0.9985721729986047901, 0.00053912151634647712158, 0.9984721790304649236 },
	{ 0.99857234267633909752, 0.00053905193626835215363, 0.99847235114960541935 },
	{ 0.99857250794809815364, 0.00053898462593510024828, 0.99847253301529736991 },
	{ 0.99857269505899892703, 0.00053892072975590102259, 0.998472734011696339 },
	{ 0.99857289931696369134, 0.00053885757744266855884, 0.9984729512014849373 },
	{ 0.99857304988306494486, 0.00053879062950565694869, 0.99847312099366014593 },
	{ 0.9985732163564535746, 0.00053872211754276636952, 0.99847329845337684517 },
	{ 0.99857340350550105601, 0.00053865597069218046963, 0.99847349506287375043 },
	{ 0.99857359040659343652, 0.00053858618080570587992, 0.9984736757078624958 },
	{ 0.99857373948496253036, 0.00053852102577640903209, 0.99847385744004002461 },
	{ 0.99857393445413977773, 0.0005384552985425222673, 0.99847405584244464105 },
	{ 0.99857410767954257746, 0.00053838865578129189559, 0.9984742439451667062 },
	{ 0.99857429725092317074, 0.00053832851707889925637, 0.99847445609955476353 },
	{ 0.99857447074335459192, 0.00053825756370975876963, 0.99847462837128297952 },
	{ 0.99857464728754385952, 0.00053819301903202429026, 0.99847482292084344113 },
	{ 0.99857478131693222512, 0.00053812147438480749818, 0.99847496980576155856 },
	{ 0.99857498677652678509, 0.00053805837929203398275, 0.9984751854887448097 },
	{ 0.99857515517633743674, 0.00053799293816044206802, 0.99847537399201014008 },
	{ 0.99857532901209189458, 0.00053792621910526625117, 0.99847556133179260485 },
	{ 0.99857552792948078846, 0.00053786207497074495221, 0.99847576517014080544 },
	{ 0.99857569817941960189, 0.00053779421150638951829, 0.99847594655899563065 },
	{ 0.99857588296335508815, 0.00053772844612553019356, 0.99847613714127081419 },
	{ 0.99857602902811337664, 0.00053766073524906532466, 0.99847630449203972347 },
	{ 0.99857624776285436319, 0.00053760069191410441054, 0.99847654077438829923 },
	{ 0.99857638284128447115, 0.000537526953815960001, 0.99847667829422459551 },
	{ 0.99857655938547384977, 0.00053746088325931943783, 0.998476864909214612 },
	{ 0.99857672814768061453, 0.00053739404976322572433, 0.9984770489302106089 },
	{ 0.99857692372720940899, 0.00053733190834476870102, 0.99847725908188278421 },
	{ 0.99857709157388896415, 0.00053726415932133116376, 0.99847744035629670822 },
	{ 0.99857726895731180328, 0.00053719785988285459043, 0.99847762597946565499 },
	{ 0.9985774465696164448, 0.00053713255226566696075, 0.99847781701950455435 },
	{ 0.99857760564249231638, 0.00053706472694828408677, 0.9984779867735327219 },
	{ 0.99857777486246301901, 0.00053699590980961226915, 0.9984781617918431218 },
	{ 0.998577969927007425, 0.00053693599998905553166, 0.99847838222412443887 },
	{ 0.99857813464563527361, 0.00053686832725956333111, 0.99847855792908035699 },
	{ 0.9985783511297050552, 0.00053680618584110630781, 0.99847878150848701218 },
	{ 0.99857847407739797063, 0.00053673481285526657755, 0.9984789215460233569 },
	{ 0.99857867150705503789, 0.00053667192757084268388, 0.99847912927536286443 },
	{ 0.99857885674875423998, 0.00053660997688724900237, 0.99847933526901511136 },
	{ 0.99857902451914004605, 0.00053653986275150700267, 0.99847950639633431535 },
	{ 0.99857918090265440636, 0.00053646980583622373446, 0.998479668044130797 },
	{ 0.99857935220163518419, 0.00053640550911381165364, 0.99847986108688591145 },
	{ 0.99857955506723583561, 0.00053634363472416330884, 0.99848007783798442549 },
	{ 0.99857970315378352666, 0.00053627275764896815882, 0.99848022851852624715 },
	{ 0.9985798690549676504, 0.00053620741188480796919, 0.99848041570572088066 },
	{ 0.99858006366174856261, 0.0005361436873669856969, 0.99848061599640058894 },
	{ 0.99858023919504312893, 0.00053607717812015950182, 0.99848080236343528249 },
	{ 0.99858037568491131442, 0.0005360038596387143358, 0.9984809443464673917 },
	{ 0.99858058408182293064, 0.00053594324409916372157, 0.99848116769699213346 },
	{ 0.99858076993387356879, 0.00053588068306400756316, 0.99848137185958951711 },
	{ 0.99858094052713530786, 0.00053581629097416386565, 0.99848155954269479651 },
	{ 0.99858107938211559951, 0.00053573969185307019659, 0.99848168863205011281 },
	{ 0.99858127639215576998, 0.00053568332970097074907, 0.99848191852478074271 },
	{ 0.99858142634790514336, 0.00053561249077274805056, 0.99848207305816683022 },
	{ 0.99858161532800748805, 0.00053554909050419329669, 0.99848227744964612729 },
	{ 0.99858179431360316602, 0.00053548729240849028861, 0.99848247901824949135 },
	{ 0.99858198165338574182, 0.00053541950523808019141, 0.9984826665106198984 },
	{ 0.99858211747568192962, 0.00053534803688480873604, 0.9984828085890194993 },
	{ 0.99858230813425130634, 0.00053528631508305095626, 0.99848301786331139507 },
	{ 0.99858249780099916926, 0.00053522146522953534687, 0.9984832133283991773 },
	{ 0.99858267941873590789, 0.00053515718758060954602, 0.99848341112045224666 },
	{ 0.99858284463327440239, 0.0005350930625195744186, 0.99848359311965861895 },
	{ 0.99858304120462448861, 0.00053503267586185948926, 0.99848381006149189432 },
	{ 0.99858316640298872002, 0.00053495844185307049948, 0.99848394121078365426 },
	{ 0.99858336926858926041, 0.00053489946663334408256, 0.99848416238693105118 },
	{ 0.99858352536600136773, 0.00053482942879154731115, 0.99848432397750719325 },
	{ 0.99858370994012857214, 0.00053476494133427188854, 0.99848452312377788953 },
	{ 0.99858386603754067945, 0.00053469673454716265624, 0.99848468593505701474 },
	{ 0.99858405150812168394, 0.00053463333427860801079, 0.9984848877325421812 },
	{ 0.99858419410150522921, 0.00053456184685185016703, 0.9984850361242656458 },
	{ 0.9985843952123450995, 0.00053450172722294402462, 0.99848525371459750932 },
	{ 0.99858457435052871976, 0.00053444038689091271158, 0.99848545177367931114 },
	{ 0.99858474868219371245, 0.0005343705779309518419, 0.99848562534240470345 },
	{ 0.99858491250436776099, 0.00053430681526615690126, 0.99848581319717144567 },
	{ 0.99858505532663333071, 0.00053423479378178202574, 0.99848595601943690436 },
	{ 0.99858527207773173373, 0.00053417566597416493539, 0.99848618848708814433 },
	{ 0.99858541657846422446, 0.00053410623848393064088, 0.99848634550002735022 },
	{ 0.99858560891550030014, 0.00053404131233646969477, 0.99848654165176065067 },
	{ 0.99858578774850814685, 0.00053397844612553229792, 0.99848673635390905456 },
	{ 0.99858597024362527605, 0.00053391557991459479265, 0.99848693715957304029 },
	{ 0.99858613336008028583, 0.00053384859383061040571, 0.99848711065200457249 },
	{ 0.99858631730478242261, 0.00053378519356205554342, 0.99848730893996828772 },
	{ 0.99858645461481032601, 0.00053371403038456543492, 0.99848745353606815911 },
	{ 0.99858665839593829805, 0.0005336527663464794586, 0.99848766738799665799 },
	{ 0.99858683213632537523, 0.00053358640968754393694, 0.99848785043624488367 },
	{ 0.99858697633188198139, 0.00053351972877934068003, 0.99848801202682102574 },
	{ 0.99858716609399744701, 0.00053345691978886212309, 0.99848821292785239212 },
	{ 0.99858732322137777615, 0.00053339126884892069502, 0.99848838889983715372 },
	{ 0.99858752410333573302, 0.00053332893669560043834, 0.99848860000518380176 },
	{ 0.99858768517892770866, 0.00053326105415775872445, 0.99848876695540944581 },
	{ 0.99858787431161799564, 0.00053319811165287599088, 0.99848897195724040099 },
	{ 0.99858799838464640253, 0.00053312889397099131814, 0.99848911071685320096 },
	{ 0.99858820475976839415, 0.0005330693083997023159, 0.99848933189300048685 },
	{ 0.99858837804239164448, 0.00053300253212406755073, 0.99848951219466663964 },
	{ 0.99858852616708637662, 0.00053293390572025918332, 0.99848967466262306125 },
	{ 0.99858873094003552939, 0.0005328725653882279787, 0.99848988614943923192 },
	{ 0.99858886613290653855, 0.00053280145943119681853, 0.99849003049758366934 },
	{ 0.99858903884332517187, 0.00053273929893925351525, 0.99849022243407625776 },
	{ 0.99858925185602043229, 0.00053268131554081615039, 0.99849045375731837471 },
	{ 0.99858941802423328848, 0.00053261524498417547879, 0.9984906296911559842 },
	{ 0.99858958476465087273, 0.00053254616081669509109, 0.99849079864409773233 },
	{ 0.99858976521890507883, 0.00053248281776859950239, 0.99849099393752405174 },
	{ 0.99858991546075703827, 0.0005324164229626914208, 0.99849115955260570043 },
	{ 0.99859007651727549337, 0.0005323490554089804587, 0.9984913286962823209 },
	{ 0.99859025000970713659, 0.00053228512108280867307, 0.99849151866820606838 },
	{ 0.99859044593255874567, 0.00053222347557499623, 0.99849172923949502945 },
	{ 0.99859060124795784308, 0.0005321564704175255631, 0.99849189020064599287 },
	{ 0.99859076819818370918, 0.0005320911818738243218, 0.99849207015898933104 },
	{ 0.99859095832269528792, 0.0005320304518933557025, 0.99849228225615715981 },
	{ 0.99859113013666012115, 0.00053196178734257434147, 0.99849244918730939435 },
	{ 0.99859128404062125206, 0.00053189909279301368118, 0.99849263051894376897 },
	{ 0.99859145940225446658, 0.00053183252632572853777, 0.99849281282332591481 },
	{ 0.99859161233346771525, 0.00053176740944340435829, 0.99849298261550112343 },
	{ 0.99859181348245451559, 0.00053170458137943973822, 0.99849318742659731729 },
	{ 0.99859198552530115123, 0.00053164316475346308846, 0.99849338052657288234 },
	{ 0.99859215836923420628, 0.00053157530128910765455, 0.99849355909255177455 },
	{ 0.99859232766549876903, 0.00053151357948734987476, 0.99849374761489051444 },
	{ 0.99859248422067448114, 0.00053144491493656862216, 0.99849391088393324445 },
	{ 0.99859267785470762213, 0.00053138311684086561408, 0.99849411733534909619 },
	{ 0.99859283244531427126, 0.00053131511986210611196, 0.99849427715209093659 },
	{ 0.99859300805490280872, 0.00053125116646244793794, 0.99849446367171368344 },
	{ 0.99859316064279335379, 0.000531184027790572986, 0.99849463334944787984 },
	{ 0.99859334641855013182, 0.00053112108528569014401, 0.99849482721236271221 },
	{ 0.99859350228708032571, 0.00053105463325932289725, 0.99849499696639087976 },
	{ 0.99859369033258194026, 0.00053099300682499673415, 0.99849520019438742224 },
	{ 0.99859385215203999575, 0.00053092731773808274614, 0.99849537040617919459 },
	{ 0.99859402808587793832, 0.00053086490929081704433, 0.9984955664816185239 },
	{ 0.99859418418328993461, 0.00053079761803105141894, 0.99849572868254610203 },
	{ 0.9985943772451185696, 0.0005307382994885709868, 0.99849594379332473615 },
	{ 0.99859457328241085783, 0.00053067615807011385507, 0.99849614761259952722 },
	{ 0.99859471642892583265, 0.00053060488045170563307, 0.99849628843214888185 },
	{ 0.9985948683683180116, 0.00053053640663578761384, 0.998496451205281077 },
	{ 0.99859505011956906095, 0.00053047485649540689588, 0.99849665084746241916 },
	{ 0.99859522569101055733, 0.000530413420795944183, 0.99849684541609640132 },
	{ 0.99859539014260956247, 0.00053034532844975263051, 0.99849701139357438517 },
	{ 0.99859557729165737694, 0.0005302883368726043177, 0.9984972272291455786 },
	{ 0.99859573615472507768, 0.00053022041618779004388, 0.99849739143278926079 },
	{ 0.9985959019986886398, 0.00053015501320317101434, 0.99849756521132326803 },
	{ 0.99859608838479707593, 0.00053009161293461636889, 0.9984977596845897585 },
	{ 0.99859624818246550682, 0.00053002710640385466631, 0.99849793802168695933 },
	{ 0.99859640298288065985, 0.00052996019661381572451, 0.99849810335066635503 },
	{ 0.99859657699029635847, 0.00052989528953984105838, 0.99849828555968123123 },
	{ 0.99859677001397795237, 0.00052983288109257535656, 0.9984984907903939888 },
	{ 0.99859693133752525096, 0.000529768527149704219, 0.99849866493132410916 },
	{ 0.99859710196893392009, 0.00052970882713749721168, 0.99849885982420716335 },
	{ 0.99859727683465648873, 0.0005296383315320285284, 0.99849902675535939789 },
	{ 0.99859743243615795016, 0.00052957367241337626081, 0.99849919883635296358 },
	{ 0.99859760362069793782, 0.00052951185524418675592, 0.99849938672926674688 },
	{ 0.99859775876443590548, 0.00052944315254643283496, 0.99849954309370758665 },
	{ 0.99859795506875714821, 0.0005293840247388157446, 0.99849976213362434674 },
	{ 0.99859814687173564796, 0.00052932283699467521342, 0.9984999630918760527 },
	{ 0.99859828910272330216, 0.00052925369560673587738, 0.99850011253264125966 },
	{ 0.99859845298211769027, 0.00052919479668095458034, 0.99850030937101996731 },
	{ 0.99859859614770607461, 0.00052911892235234128483, 0.99850043674376165459 },
	{ 0.99859879985253996448, 0.00052906231224491954718, 0.9985006624212517945 },
	{ 0.99859896766107270061, 0.00052900062859013421892, 0.99850084808256744928 },
	{ 0.99859914260308924039, 0.00052893356621220460369, 0.99850102760222048115 },
	{ 0.99859933049600302368, 0.00052887331306889417623, 0.99850122785475337039 },
	{ 0.99859947221200651146, 0.00052880400001957777838, 0.99850137765791491251 },
	{ 0.99859963046472244308, 0.00052873985588505637099, 0.99850155445005950305 },
	{ 0.99859980910699541745, 0.00052867924034550553992, 0.99850174758818199816 },
	{ 0.99859997252862620076, 0.00052861164390995867609, 0.99850191528227361104 },
	{ 0.99860015822808911867, 0.0005285532027478491825, 0.99850212600615040337 },
	{ 0.9986003101674811866, 0.00052848503410771240172, 0.99850227947142122797 },
	{ 0.99860047954003983151, 0.0005284175902600561029, 0.99850245311644070245 },
	{ 0.99860065856378255056, 0.00052835666954472414181, 0.99850264892485118828 },
	{ 0.99860082618158030332, 0.0005282903701062476769, 0.99850282035734616581 },
	{ 0.99860098983209288903, 0.00052822620689823988113, 0.99850299636747785748 },
	{ 0.99860116015832578462, 0.00052816192924931397185, 0.99850317798521459611 },
	{ 0.9986013250295414645, 0.00052810188591435294932, 0.99850337154295376596 },
	{ 0.99860150725762986124, 0.000528039591908005361, 0.99850356193449407716 },
	{ 0.99860169515054353351, 0.00052797785103276140967, 0.99850376115705852254 },
	{ 0.99860183762948617758, 0.00052790907204106226041, 0.99850391286756856601 },
	{ 0.99860203257958990442, 0.0005278500777478494551, 0.99850412273313848832 },
	{ 0.99860220603387461757, 0.00052778763115361130177, 0.99850431251432725244 },
	{ 0.99860233756463623322, 0.00052771774589970509538, 0.99850445197965920219 },
	{ 0.99860250647943105129, 0.00052765320122197083286, 0.99850462577726650792 },
	{ 0.99860268195550516701, 0.00052759064018681467445, 0.99850481407072344542 },
	{ 0.99860287055413787805, 0.00052753143608525224738, 0.99850502097990301298 },
	{ 0.99860303557794138918, 0.00052746803581669760193, 0.99850520156767141877 },
	{ 0.9986031952802424394, 0.00052739855110600435909, 0.99850535867597833839 },
	{ 0.99860336282174622102, 0.00052733782112553563137, 0.99850554513838052362 },
	{ 0.99860351775567557375, 0.00052727302849247886189, 0.99850571506407004296 },
	{ 0.99860368152062917169, 0.0005272091323132796362, 0.99850589340116713277 },
	{ 0.99860388448159720376, 0.00052714777290776193477, 0.99850610025312613871 },
	{ 0.99860404633920207829, 0.00052708357155278147063, 0.99850627508070155525 },
	{ 0.9986042044202566581, 0.00052701704323246899558, 0.99850643682386552857 },
	{ 0.99860435952584736263, 0.00052695486366703919549, 0.99850661603834300895 },
	{ 0.99860453526895043286, 0.00052689073860600395965, 0.99850679819013732352 },
	{ 0.99860470679681279105, 0.00052682937920048647507, 0.9985069874944889623 },
	{ 0.99860486640374634959, 0.00052676315605595523846, 0.99850715808775047932 },
	{ 0.99860502463738898271, 0.00052669800102665839062, 0.99850732547666642969 },
	{ 0.99860521647851441251, 0.00052663807213261537316, 0.99850752731229863723 },
	{ 0.99860538985650504351, 0.00052657432854130671249, 0.99850771106626590168 },
	{ 0.99860555289666619316, 0.00052651199638798656423, 0.99850789165403430747 },
	{ 0.99860571692864863458, 0.00052644775688603354016, 0.99850806575681749777 },
	{ 0.99860589225213491904, 0.00052638473808720546987, 0.99850825084592864656 },
	{ 0.99860605626504372889, 0.00052631967842534045556, 0.99850842420484575701 },
	{ 0.99860620772759856045, 0.00052625641167119009516, 0.99850859203245190265 },
	{ 0.9986063839856857971, 0.0005261891013379381898, 0.99850876771833430023 },
	{ 0.99860655110757290398, 0.00052612795174077021856, 0.9985089534559441482 },
	{ 0.99860671018044888658, 0.00052606226265385612213, 0.99850912382032397385 },
	{ 0.99860687165658412745, 0.00052600027382328977225, 0.99850930047895414265 },
	{ 0.99860704659860077825, 0.00052593717873051636525, 0.99850948472883194196 },
	{ 0.99860721093575899321, 0.00052587660133793820254, 0.99850967195417361655 },
	{ 0.99860738519113012579, 0.00052581465065434452102, 0.99850986024763055404 },
	{ 0.99860756366174163734, 0.0005257486373181630146, 0.99851003673459948207 },
	{ 0.9986077389852279218, 0.00052568805992558496031, 0.99851022792722632371 },
	{ 0.99860790213982997265, 0.00052562591850712804542, 0.99851041114713590119 },
	{ 0.9986080720464461935, 0.00052556083977177664272, 0.99851058471586140453 },
	{ 0.99860824101846146217, 0.00052549852669194277444, 0.99851076341535471848 },
	{ 0.99860837649743472433, 0.00052543110191777297243, 0.99851091297056093765 },
	{ 0.99860855285088934163, 0.00052536918938115174244, 0.99851110084440108938 },
	{ 0.99860871009271057197, 0.00052530090630009717342, 0.99851125793363437744 },
	{ 0.99860892442147641823, 0.00052524729073002876349, 0.99851149446393816511 },
	{ 0.99860905610482597616, 0.00052518030464604448498, 0.99851164476301024209 },
	{ 0.99860920777718920061, 0.00052511469185307572526, 0.99851180070783440712 },
	{ 0.99860939277093307975, 0.00052505539238408146466, 0.99851200645353144214 },
	{ 0.99860956931512245838, 0.00052499328911259710972, 0.99851218940641217614 },
	{ 0.99860974419991843654, 0.00052493238747075142859, 0.99851238206769754591 },
	{ 0.99860990043084507661, 0.00052486679375126894884, 0.99851254856015958516 },
	{ 0.99861006369988802867, 0.00052479934990361265003, 0.99851271182920242619 },
	{ 0.99861022174279567842, 0.000524739573597460306, 0.99851289192106018611 },
	{ 0.99861038567941062816, 0.00052467104256108333844, 0.99851305189038985777 },
	{ 0.99861056413094861917, 0.00052461267769291928999, 0.99851325384046285549 },
	{ 0.99861072564523079009, 0.00052454653084233328168, 0.99851341977979379827 },
	{ 0.99861090073983516113, 0.00052448374092534122155, 0.99851360326673210821 },
	{ 0.99861105733315791433, 0.00052442236244633724015, 0.99851377771283778007 },
	{ 0.99861122554223380465, 0.00052436062157109296356, 0.99851396072293885364 },
	{ 0.99861142705361671812, 0.00052430353462651292564, 0.99851417997266400661 },
	{ 0.99861155133645340687, 0.00052423250496342688534, 0.99851431188489536694 },
	{ 0.99861174794595042314, 0.00052417291939213788311, 0.9985145190229567369 },
	{ 0.99861190532128607522, 0.00052410969078496008264, 0.99851468749906147071 },
	{ 0.99861205321709911598, 0.00052404541313603439021, 0.99851484752561159297 },
	{ 0.99861225551049526139, 0.0005239864760632804248, 0.99851506103421738825 },
	{ 0.99861240086953440009, 0.00052392153084233309031, 0.9985152177229075221 },
	{ 0.99861257260720504014, 0.00052385889351323159518, 0.99851540120984583204 },
	{ 0.99861275594155551882, 0.00052379671394780201194, 0.99851559308911819191 },
	{ 0.99861288869302022864, 0.00052372988045170819002, 0.99851573987866881765 },
	{ 0.99861305550973156198, 0.00052366636574223564791, 0.9985159127988956218 },
	{ 0.9986132227651330906, 0.0005236056166882805318, 0.99851609813596209353 },
	{ 0.99861340840737533586, 0.00052354368507817302184, 0.99851628972913208937 },
	{ 0.99861356175820537029, 0.00052348158180668866689, 0.99851646474744248927 },
	{ 0.99861372819344706997, 0.00052342027962163013063, 0.99851664735700040865 },
	{ 0.99861386462609480485, 0.00052335224449589774331, 0.99851678779508012962 },
	{ 0.99861406955163189991, 0.00052329075157597586525, 0.99851699729825360574 },
	{ 0.99861422919671249954, 0.00052322990715458924087, 0.99851717166806541748 },
	{ 0.99861438443581773683, 0.00052316515266850513975, 0.99851733743573511948 },
	{ 0.99861455205361560061, 0.0005231023627515129712, 0.99851751283551526406 },
	{ 0.99861471242348864852, 0.00052304025948002872467, 0.99851769060040762582 },
	{ 0.99861489039818951419, 0.00052298279106572211159, 0.99851789111996935855 },
	{ 0.99861508586327740744, 0.00052292038261845640978, 0.99851809055234219681 },
	{ 0.99861520862023556155, 0.00052285103142216734357, 0.99851822185422178801 },
	{ 0.99861541051308833072, 0.00052279463112309522768, 0.99851843870068768272 },
	{ 0.99861556006829466092, 0.00052273086845830050388, 0.99851860088254185133 },
	{ 0.99861572242181018133, 0.0005226661711926754595, 0.99851876811886985941 },
	{ 0.9986158760778159893, 0.00052260376274540997453, 0.9985189416113013916 },
	{ 0.99861606728951657352, 0.00052254370033696278044, 0.99851913740063846792 },
	{ 0.99861622716347897555, 0.00052247888863041983942, 0.99851930429364366137 },
	{ 0.99861637158791738411, 0.00052241487801030260865, 0.99851946687604098418 },
	{ 0.99861656548897959063, 0.00052235563576176762164, 0.99851967168713706702 },
	{ 0.99861671830575204911, 0.00052229299843266612652, 0.99851983732129212523 },
	{ 0.99861687882821281725, 0.00052222647011235365146, 0.99851999906445609856 },
	{ 0.99861704415719221295, 0.00052216718971684577925, 0.99852019063855268488 },
	{ 0.99861720240990825559, 0.00052210254967167990005, 0.99852035282040674247 },
	{ 0.99861734773080035321, 0.0005220355826611819015, 0.99852050096417488412 },
	{ 0.99861754336754959827, 0.00052197647392705109112, 0.99852070880795518182 },
	{ 0.9986177006665912792, 0.00052191503822758826981, 0.99852088670636207635 },
	{ 0.99861785752694276486, 0.00052185339271977571832, 0.99852105943585411918 },
	{ 0.99861803214470989953, 0.00052178989708378934777, 0.99852123580838203498 },
	{ 0.99861820525567157603, 0.00052172939598515663019, 0.99852142448330860613 },
	{ 0.99861834760109990938, 0.00052166555702641646125, 0.99852158269787760769 },
	{ 0.99861851811806756629, 0.00052160566627934622057, 0.99852177305127098883 },
	{ 0.9986186790410718217, 0.00052154114067509834644, 0.99852193511868414522 },
	{ 0.99861885007302364503, 0.00052147966682866285677, 0.99852212125683703636 },
	{ 0.99861900681893422949, 0.00052141317665532305008, 0.99852227952862648852 },
	{ 0.99861917510430420197, 0.000521354678272754825, 0.99852246971035851786 },
	{ 0.99861936257760131053, 0.00052129610359624104637, 0.9985226700391851562 },
	{ 0.99861954202096070432, 0.00052123140633061611042, 0.9985228445997319513 },
	{ 0.99861969260613525634, 0.00052117080986455177616, 0.99852301822567779421 },
	{ 0.99861984315316276728, 0.00052110758125737397569, 0.99852318059826683516 },
	{ 0.99862001887719220594, 0.00052104523003056733062, 0.99852336521054085861 },
	{ 0.9986201586095531102, 0.00052098110496953209479, 0.9985235220327454142 },
	{ 0.9986203405324657334, 0.00052092102348759851231, 0.9985237132635191859 },
	{ 0.99862049653451046005, 0.00052085649788335042134, 0.99852387693310529215 },
	{ 0.99862065064827998384, 0.00052079454719975652299, 0.9985240469160152621 },
	{ 0.99862083646218380295, 0.00052073393166020580033, 0.99852424058819522212 },
	{ 0.99862098428170265052, 0.00052066767036870211221, 0.99852439260388115017 },
	{ 0.9986211744062144513, 0.00052061121284917093958, 0.99852460286999433769 },
	{ 0.99862133790413920575, 0.00052055193245366306737, 0.99852478376293862805 },
	{ 0.99862149983803816244, 0.00052048826515629985183, 0.99852495416546538376 },
	{ 0.99862166762749726701, 0.00052042400658086043937, 0.99852512870693865832 },
	{ 0.99862178573052462482, 0.00052035717308476672587, 0.99852526084805171003 },
	{ 0.99862198642174770935, 0.00052029938042119270279, 0.99852547138119363002 },
	{ 0.99862214547555017141, 0.00052023695290044082943, 0.99852564123058928924 },
	{ 0.9986222918836311635, 0.00052017416298344855245, 0.99852580655956868494 },
	{ 0.99862247659127267863, 0.00052011396706059707332, 0.99852600026989579707 },
	{ 0.99862264707009362752, 0.00052004999458745251092, 0.99852616769695867749 },
	{ 0.9986227926389411591, 0.00051999048531010873698, 0.99852634439373577635 },
	{ 0.99862296206872014359, 0.00051992870628789190045, 0.99852652240658357208 },
	{ 0.9986231074086859838, 0.0005198616439099621768, 0.99852666805172496378 },
	{ 0.99862330493371020967, 0.00051980541527226701431, 0.99852688449764759326 },
	{ 0.9986234490529728447, 0.0005197415572400405654, 0.99852703792477148781 },
	{ 0.9986236258641910668, 0.00051968246757939603499, 0.99852723136806964543 },
	{ 0.99862380780617709952, 0.00051962011635258938992, 0.99852741891766072513 },
	{ 0.99862392796914112303, 0.00051955580055669102913, 0.99852755433941364771 },
	{ 0.99862411454598432048, 0.00051949228584721837861, 0.99852773977184761112 },
	{ 0.99862427110116014362, 0.0005194315558667497593, 0.99852791646862470998 },
	{ 0.99862443612496387679, 0.0005193716651196794102, 0.99852809385204732706 },
	{ 0.99862459594170560617, 0.00051930832207158382149, 0.99852826537990968525 },
	{ 0.99862478522698405747, 0.00051925026237920101149, 0.9985284653463403215 },
	{ 0.99862491538445463668, 0.00051918449699834168676, 0.9985286107625999108 },
	{ 0.99862509280602451689, 0.00051912449181035322417, 0.99852879840755826013 },
	{ 0.99862524886528980517, 0.00051906311333134924277, 0.99852896697903015255 },
	{ 0.99862542758385675068, 0.00051900013267949384084, 0.99852914859676700221 },
	{ 0.99862556754509945733, 0.00051893677055791186375, 0.99852930381679860794 },
	{ 0.99862574714104679341, 0.00051887832939580247858, 0.99852949561977710768 },
	{ 0.99862591124932320596, 0.00051881599724248222191, 0.99852966903591466874 },
	{ 0.99862604689995793095, 0.00051875389397099775854, 0.99852982879543605854 },
	{ 0.9986262277547550692, 0.00051869121849492359506, 0.99853000720882700847 },
	{ 0.99862638005654336126, 0.00051862722694829275268, 0.99853017042064950992 },
	{ 0.99862657258431442031, 0.00051856882393315603588, 0.99853037538433342402 },
	{ 0.99862673854271899465, 0.00051850891411259929838, 0.99853055438900262253 },
	{ 0.99862690225045203096, 0.00051844923317387857104, 0.99853073583507789834 },
	{ 0.99862706881920826341, 0.00051838573753789209207, 0.9985309028997444436 },
	{ 0.99862720956246409099, 0.00051832449257329239571, 0.99853106843853212116 },
	{ 0.99862735768715904516, 0.00051825662910893696179, 0.99853121145153245219 },
	{ 0.99862753579537444359, 0.0005182007437939955977, 0.99853141160869773874 },
	{ 0.99862772248665854224, 0.00051814131081059705206, 0.99853160623455217149 },
	{ 0.99862784200112386657, 0.00051807413399174943175, 0.99853173704052144988 },
	{ 0.99862803655068432818, 0.00051801813423589006258, 0.99853195051098031509 },
	{ 0.99862820678154995413, 0.00051795891106084135554, 0.99853213447475597242 },
	{ 0.99862833541314177666, 0.00051789345085576326926, 0.99853227470302718949 },
	{ 0.99862853843133014831, 0.00051783386528447426702, 0.99853247772121545012 },
	{ 0.99862869166771928153, 0.00051776966392949369446, 0.99853264026546584287 },
	{ 0.99862885198037198986, 0.00051771280586674944986, 0.99853282514476870979 },
	{ 0.99862900798241660549, 0.00051764744102910298026, 0.99853298141384194686 },
	{ 0.99862916428963721671, 0.00051758463203862442332, 0.9985331485166555332 },
	{ 0.99862931683938094274, 0.00051752332985356577864, 0.99853331724071547892 },
	{ 0.9986294910184582152, 0.00051746206581547980231, 0.99853349477672603829 },
	{ 0.99862966750542736527, 0.00051740486442998186774, 0.9985336922826766326 },
	{ 0.99862982266823874244, 0.00051734319984868303629, 0.99853385820293416586 },
	{ 0.99862996434609530017, 0.00051727827370122198176, 0.99853401086711857104 },
	{ 0.9986301223127090898, 0.00051721704781010878222, 0.99853418210887867623 },
	{ 0.99863028842370160643, 0.00051715530693486461405, 0.99853435588741235041 },
	{ 0.99863045676629191849, 0.0005170923262830091037, 0.99853452766323003154 },
	{ 0.99863060893456601086, 0.00051703445732548974391, 0.99853470569515123678 },
	{ 0.99863078048150222266, 0.00051697185814336080872, 0.99853487724208722653 },
	{ 0.99863095837990933923, 0.00051691438972905430407, 0.99853507242107264474 },
	{ 0.99863110642831032226, 0.00051684850990727697426, 0.9985352247419342353 },
	{ 0.99863125077645498173, 0.00051678961098149578564, 0.99853539350414100007 },
	{ 0.9986314361135216755, 0.00051672668755009954888, 0.99853557807826809345 },
	{ 0.99863159467141371373, 0.00051666769325688663515, 0.99853575254344728584 },
	{ 0.99863176911751982967, 0.00051660936653569514664, 0.99853593995952383278 },
	{ 0.99863192754189744615, 0.00051654806435063661037, 0.99853611104869599568 },
	{ 0.99863208789269697352, 0.00051648620903447454555, 0.99853628291988094645 },
	{ 0.99863224080483692369, 0.00051642473518803894746, 0.99853645028972326525 },
	{ 0.99863238286416311507, 0.000516358359455616929, 0.99853659387492810229 },
	{ 0.99863258160989076817, 0.00051630502998784358597, 0.9985368123044933153 },
	{ 0.99863272048394491343, 0.00051623924553349787286, 0.99853695693874000572 },
	{ 0.99863287669579803296, 0.00051617824852422057504, 0.99853712932490923393 },
	{ 0.99863304408471420537, 0.00051611797630742354236, 0.99853730922603223252 },
	{ 0.99863319549004869735, 0.00051605575859502139918, 0.99853747039699158883 },
	{ 0.99863337285439812696, 0.00051599329292729674903, 0.99853764821910440119 },
	{ 0.99863354493539180368, 0.00051593687355473835318, 0.99853783998393585986 },
	{ 0.99863368680398323374, 0.00051587312996342980093, 0.99853799299144307966 },
	{ 0.9986338276044594009, 0.00051580885231450410849, 0.99853814035319832243 },
	{ 0.99863399091164928301, 0.00051574930489018777462, 0.99853832151317123422 },
	{ 0.99863417706887591674, 0.00051569132149175040975, 0.99853851743602262125 },
	{ 0.99863433524529821028, 0.0005156267958875024272, 0.99853867313289135232 },
	{ 0.99863450889031768476, 0.00051557277977422116214, 0.99853888095759824051 },
	{ 0.99863466525475863556, 0.00051550659477666259389, 0.9985390307607596716 },
	{ 0.99863483031670940981, 0.00051544971764043228616, 0.99853921802424827625 },
	{ 0.99863496659676931344, 0.00051538362801030522618, 0.99853935937785531785 },
	{ 0.99863512589852709844, 0.00051532686531499270668, 0.99853954309367543019 },
	{ 0.99863529576699627821, 0.00051526106178716060517, 0.99853970609568953876 },
	{ 0.99863547067086588793, 0.0005152046424146021009, 0.99853989808940291084 },
	{ 0.99863560897271530514, 0.00051514133751347907213, 0.99854004970454557366 },
	{ 0.9986358039800395936, 0.00051508426964238531419, 0.99854025203608842709 },
	{ 0.99863594851891912541, 0.00051502052605107676193, 0.99854040649318065448 },
	{ 0.99863608397881897805, 0.00051496059715703396131, 0.99854056743525820838 },
	{ 0.99863625752847084982, 0.00051490045845464153893, 0.99854075075053527755 },
	{ 0.99863645114343069231, 0.0005148443251843777763, 0.99854095500850015288 },
	{ 0.99863659840981877647, 0.00051478143989995388263, 0.99854111108683862863 },
	{ 0.99863673222939897123, 0.0005147144538159694957, 0.99854124124430909681 },
	{ 0.99863693032662803617, 0.00051466131508305949446, 0.99854146528147924577 },
	{ 0.99863709008614953699, 0.00051460104286626267862, 0.9985416369428560257 },
	{ 0.99863724343697968244, 0.0005145392447705594537, 0.99854179914378360383 },
	{ 0.99863738168160864905, 0.00051447546303227823308, 0.99854195142649826433 },
	{ 0.99863755082528538054, 0.00051441404640630180017, 0.99854212240122952604 },
	{ 0.99863773513238385249, 0.00051435905754521776302, 0.99854232517146257475 },
	{ 0.99863786380212282712, 0.00051429325401738576994, 0.998542463225356558 },
	{ 0.99863802600305062729, 0.00051423267662480771564, 0.99854263427638179085 },
	{ 0.99863819081704607861, 0.00051417288124516909165, 0.99854281183146587075 },
	{ 0.99863834830682263188, 0.00051410919487431948772, 0.99854297485255338884 },
	{ 0.9986385186902760891, 0.00051405279457524715499, 0.99854316518687313842 },
	{ 0.9986386789457082358, 0.00051399286568120413753, 0.99854333711527887285 },
	{ 0.99863883237283235239, 0.00051393022835210264241, 0.99854349466227587673 },
	{ 0.99863900195519927916, 0.00051387054741338191507, 0.99854367542170563432 },
	{ 0.99863917462747109344, 0.00051381346046880187715, 0.99854386625193625182 },
	{ 0.99863932139794842069, 0.0005137498885388702783, 0.99854401798151981584 },
	{ 0.99863948359887622086, 0.00051369083702519852466, 0.99854419605158817319 },
	{ 0.99863962771813885588, 0.00051362560570195634011, 0.99854434047602647073 },
	{ 0.99863979300897143254, 0.00051356994926885087775, 0.99854452987574549017 },
	{ 0.9986399488393548074, 0.00051350788414433919116, 0.99854469447993232656 },
	{ 0.99864012301843207986, 0.00051345043480351885805, 0.9985448859014409706 },
	{ 0.99864025065820261062, 0.0005133850508923862169, 0.9985450222387212138 },
	{ 0.99864042109887662946, 0.00051332416832402681574, 0.99854519603632851954 },
	{ 0.99864061320703079172, 0.00051327122032597993946, 0.99854540767573263249 },
	{ 0.99864075059335277729, 0.0005132041007275913759, 0.99854554628275782324 },
	{ 0.99864093488137772869, 0.00051314806282475944679, 0.99854574590586564486 },
	{ 0.99864106358926363338, 0.000513083747028861086, 0.99854588071726690934 },
	{ 0.99864122662942489406, 0.00051302599251225951445, 0.99854606695078729217 },
	{ 0.99864138446252437298, 0.00051296490013555059995, 0.99854623123072505653 },
	{ 0.99864154206674193848, 0.00051290106117681053943, 0.9985463897504697206 },
	{ 0.99864172379891968934, 0.00051284658729985736249, 0.99854658979319421697 },
	{ 0.99864186995904546951, 0.00051278381645635158232, 0.99854674533747511678 },
	{ 0.99864201884667980202, 0.00051272045433476949681, 0.99854689788721862076 },
	{ 0.99864220605294817812, 0.00051266424477056050588, 0.99854710081003950073 },
	{ 0.99864234158914222395, 0.00051260256111577539445, 0.99854725351237094699 },
	{ 0.9986425067655338994, 0.00051254450142339280129, 0.99854743104838150636 },
	{ 0.99864266568582205075, 0.00051248583137944762281, 0.99854760614298576638 },
	{ 0.99864282809655813278, 0.00051242313682988717936, 0.99854777351282808517 },
	{ 0.99864297831933646066, 0.00051236294090703570023, 0.99854793350123116635 },
	{ 0.99864313104074153848, 0.00051230280220464295259, 0.99854810243509939394 },
	{ 0.99864329522531181116, 0.00051224115669683040111, 0.99854827028177883808 },
	{ 0.99864345239083918138, 0.00051217981636479919649, 0.99854843416117322619 },
	{ 0.99864363837640446331, 0.00051212742149785574035, 0.99854864643000251778 },
	{ 0.99864378295343092518, 0.00051206493675664481024, 0.99854879817865960234 },
	{ 0.99864398066919035646, 0.00051200722038701579862, 0.99854900085352515937 },
	{ 0.99864409320275970838, 0.00051194320976689867628, 0.99854912940882278871 },
	{ 0.99864425078790386436, 0.00051188099205449642468, 0.99854929294489425118 },
	{ 0.99864440900247297694, 0.00051182226479009229787, 0.99854946535013699993 },
	{ 0.99864458558480939665, 0.00051176286995366652901, 0.99854964681528579629 },
	{ 0.99864473645608631269, 0.00051170149147466254761, 0.99854980958841799143 },
	{ 0.99864491086404527653, 0.00051164243996099068555, 0.9985499958982323454 },
	{ 0.99864507295053206448, 0.00051158739387944791692, 0.99855017499826892458 },
	{ 0.99864519532602036289, 0.00051152056038335420342, 0.99855030164621805255 },
	{ 0.99864535867135728608, 0.00051146356880620578219, 0.99855048803232626664 },
	{ 0.99864553876321537906, 0.00051140562355474086884, 0.99855067506693306889 },
	{ 0.99864570571344135619, 0.00051134769737676245231, 0.99855085410974897542 },
	{ 0.99864584659021127244, 0.00051128387749150856333, 0.99855100093744664225 },
	{ 0.99864598227899303851, 0.00051121860802129371042, 0.99855114135645284268 },
	{ 0.99864619193475478998, 0.00051116886436895000046, 0.99855137237451907506 },
	{ 0.99864632934015040711, 0.00051110836327031728289, 0.99855152702234606377 },
	{ 0.99864649104516767242, 0.0005110475188489306585, 0.9985516978826365353 },
	{ 0.99864662080209509742, 0.00051097837746099121405, 0.99855181692026440121 },
	{ 0.99864681174676683817, 0.00051092621147588387649, 0.99855203300379091758 },
	{ 0.99864693980615426572, 0.00051086139976934093546, 0.99855216876886632171 },
	{ 0.99864712264459432056, 0.00051080665886357940527, 0.99855236785791634535 },
	{ 0.99864727366845906786, 0.00051074672996953638781, 0.99855253047846070924 },
	{ 0.99864743575494596683, 0.00051068962395146996151, 0.99855271316431259976 },
	{ 0.99864759316842877102, 0.00051062742531255398987, 0.99855287305734830028 },
	{ 0.99864776482980577299, 0.0005105714255566946207, 0.99855306180856884257 },
	{ 0.9986479120771203366, 0.00051050749123052261823, 0.9985532087507074106 },
	{ 0.99864808080118039335, 0.00051045122444585467898, 0.99855339448831703653 },
	{ 0.99864821454446661697, 0.00051038889229253431388, 0.9985535445585073111 },
	{ 0.99864837483804580476, 0.00051032808601812024944, 0.99855370790384412327 },
	{ 0.99864854638498179451, 0.00051027036964849134624, 0.99855389402292349388 },
	{ 0.99864868760507463641, 0.00051020834267095232801, 0.99855404439828954199 },
	{ 0.99864885268609882019, 0.00051014995872930189117, 0.99855422016046602174 },
	{ 0.99864901008050810383, 0.00051009113609746593084, 0.998554389761906247 },
	{ 0.99864915053766156738, 0.00051002590477422374629, 0.99855453403375671328 },
	{ 0.9986493133870878447, 0.00050997169792607935628, 0.99855472061059968869 },
	{ 0.99864947574060358715, 0.0005099094420667043279, 0.99855488540552150845 },
	{ 0.99864966390054632495, 0.000509854949116264871, 0.99855508584878915901 },
	{ 0.9986497787038605134, 0.00050978985130742707991, 0.99855521179101924822 },
	{ 0.99864996089380198008, 0.00050973095238164589128, 0.99855539398096049286 },
	{ 0.99865011876504827804, 0.00050967283546880413295, 0.99855557054422316998 },
	{ 0.99865023084085391414, 0.00050960760414556183998, 0.99855569513223563227 },
	{ 0.99865042523782654449, 0.00050955236732915562114, 0.99855589807413003278 },
	{ 0.99865058467309875123, 0.00050949692070439978053, 0.99855607776544463849 },
	{ 0.99865072322290349138, 0.00050943161308721236769, 0.99855621997735855011 },
	{ 0.99865089797418515882, 0.0005093763381238335889, 0.9985564121999537246 },
	{ 0.99865104314248986928, 0.00050931452095464419243, 0.99855656392953739964 },
	{ 0.99865121905725418028, 0.0005092591887708063569, 0.99855675353906481195 },
	{ 0.9986513778631013194, 0.00050919750511602124548, 0.99855691806695756618 },
	{ 0.99865152633111897718, 0.00050913723289922442963, 0.99855707385919367791 },
	{ 0.99865164412897056145, 0.00050906948387578700079, 0.99855719287774824533 },
	{ 0.99865183585565520108, 0.00050902012169316975757, 0.99855741481683502059 },
	{ 0.99865198291223489235, 0.00050895828545049397271, 0.99855756965539688164 },
	{ 0.99865214126031842667, 0.00050889835655645095525, 0.99855773685357784863 },
	{ 0.998652318758182167, 0.00050884216606572835271, 0.99855792488000594265 },
	{ 0.99865246220987291537, 0.00050878237068608972871, 0.99855808149240199434 },
	{ 0.99865262830179191145, 0.00050872309029058196492, 0.99855825521371521791 },
	{ 0.9986527742139624797, 0.00050866232216314056884, 0.99855841447732585081 },
	{ 0.99865293044488900875, 0.00050860210716680270132, 0.99855857601068154228 },
	{ 0.99865308938425068064, 0.00050854616463140260574, 0.99855875696084617221 },
	{ 0.9986532714025306845, 0.00050848953545049437128, 0.99855894966027824999 },
	{ 0.99865340537469871052, 0.00050842575371221315067, 0.99855908851525854164 },
	{ 0.99865357961099643358, 0.00050837057411626598857, 0.99855928224465906329 },
	{ 0.99865372868936563844, 0.00050830938637212545739, 0.99855943620584053377 },
	{ 0.99865386372964881634, 0.00050824667274907862555, 0.99855957826516650311 },
	{ 0.99865403348367720593, 0.00050818891823247716241, 0.99855975915811079346 },
	{ 0.99865417542856260713, 0.00050812822639898121146, 0.99855991567513957552 },
	{ 0.99865432599466363861, 0.00050806944191411802791, 0.99856008180520550166 },
	{ 0.9986545057241252854, 0.00050801208794072952833, 0.99856026649377338522 },
	{ 0.99865466109674494444, 0.00050795429527715539684, 0.99856044048211567432 },
	{ 0.9986548070470622207, 0.00050789211571172570518, 0.99856058582208129248 },
	{ 0.9986549798528483457, 0.00050783573448613997768, 0.99856077144525012823 },
	{ 0.99865511796396289057, 0.00050777426063970459644, 0.99856091997048801456 },
	{ 0.99865529504220984514, 0.00050771848976568123742, 0.99856111215493603694 },
	{ 0.9986554365674785716, 0.00050765569984868906886, 0.99856126024148361697 },
	{ 0.99865559026163142065, 0.0005075980597730056108, 0.99856143094918614622 },
	{ 0.99865573985498479193, 0.00050753448784307412037, 0.99856157600304951139 },
	{ 0.99865590552728711327, 0.00050748112022832810898, 0.99856176540276864184 },
	{ 0.99865607322137894819, 0.00050742206871465624692, 0.99856194591424307649 },
	{ 0.99865622786920615894, 0.00050736706078008614665, 0.99856211749932599631 },
	{ 0.99865637652795880008, 0.00050730606377080895725, 0.99856227744958214743 },
	{ 0.99865657794397433289, 0.00050725357353643410127, 0.99856248863122265558 },
	{ 0.99865668273370822305, 0.00050718479454473506043, 0.99856259578606876293 },
	{ 0.99865683028619856021, 0.00050712299644903205235, 0.9985627439489103141 },
	{ 0.99865700896661857566, 0.00050707187950567282359, 0.99856295406243555934 },
	{ 0.99865716168802365349, 0.0005070086890454677999, 0.99856310277840831802 },
	{ 0.9986572999898730707, 0.00050694649040655182827, 0.9985632510747641799 },
	{ 0.99865746661584964272, 0.00050689461052373944918, 0.99856344455620937861 },
	{ 0.99865761718195089625, 0.0005068327742810635559, 0.99856359680077722007 },
	{ 0.99865779097955842403, 0.00050677463829473562602, 0.99856377975365795407 },
	{ 0.99865793464105756527, 0.00050671398460821223501, 0.99856393348595773318 },
	{ 0.99865808806818157084, 0.00050665638267950144531, 0.99856410430810105261 },
	{ 0.99865826445978311821, 0.00050660084068731398802, 0.99856429168603055846 },
	{ 0.99865839230936204185, 0.00050654032051519488206, 0.99856443555733787054 },
	{ 0.99865854024332201266, 0.0005064793616528902526, 0.99856458639046763448 },
	{ 0.99865870763223807405, 0.0005064230567212497534, 0.99856476690194195811 },
	{ 0.99865886914652024497, 0.00050636240303472647081, 0.99856493238350907404 },
	{ 0.99865901364725284672, 0.00050630274116949213186, 0.99856509336373355801 },
	{ 0.99865919896524590893, 0.00050624819099859383505, 0.99856528814217571099 },
	{ 0.99865934110086618247, 0.00050618723213628920559, 0.99856543638131134433 },
	{ 0.99865948481958577432, 0.00050612919151739278398, 0.99856559982201553716 },
	{ 0.99865964568536957913, 0.00050607086479620140389, 0.99856577251336053891 },
	{ 0.99865979522150238878, 0.0005060128813977639306, 0.99856593425652440121 },
	{ 0.99865994933527191257, 0.00050595032036260766378, 0.9985660877599422669 },
	{ 0.99866010020654882862, 0.00050589298546270544416, 0.99856625739952953325 },
	{ 0.99866027869623386071, 0.00050583595573858457142, 0.99856644100090885541 },
	{ 0.9986604398862669596, 0.00050577932655767644538, 0.99856661580941108447 },
	{ 0.99866058812540270395, 0.00050572035133794992004, 0.99856677640816582375 },
	{ 0.99866072968881824945, 0.00050565721809820406152, 0.99856692033669347541 },
	{ 0.99866089394968249326, 0.00050560098946050889904, 0.9985670993985830135 },
	{ 0.99866104251306764272, 0.00050554500877813591826, 0.99856726940056650399 },
	{ 0.99866120252054457751, 0.00050548601448492311294, 0.99856743577858764205 },
	{ 0.99866135730188621, 0.00050542362511114401636, 0.99856758956810776073 },
	{ 0.99866152892511639294, 0.00050536979973272620151, 0.99856778385063948988 },
	{ 0.99866164584558769768, 0.00050530498802618336891, 0.99856790435692610597 },
	{ 0.99866183143060971439, 0.00050525200188116393268, 0.99856810199639134407 },
	{ 0.99866196860712330707, 0.00050519447624639837128, 0.99856826267144016551 },
	{ 0.99866212741297055722, 0.00050513332664923040003, 0.99856842155358116475 },
	{ 0.99866226558130566371, 0.00050507419884161320126, 0.99856857574364465968 },
	{ 0.99866243400019005794, 0.00050501686394171109006, 0.99856875614067808211 },
	{ 0.99866259696405723645, 0.00050495888054327361678, 0.99856892276665443209 },
	{ 0.99866274199884730312, 0.00050490005791143776487, 0.99856908199211824595 },
	{ 0.99866286673944804075, 0.00050483574211553940408, 0.99856921222588268527 },
	{ 0.99866303166788417123, 0.00050477957069830318992, 0.99856938890358637462 },
	{ 0.99866320365351035626, 0.00050472523033575462329, 0.99856958011528662578 },
	{ 0.9986633548681099759, 0.00050466678917364534655, 0.99856973895928058393 },
	{ 0.99866351499002770087, 0.00050460615456060834393, 0.99856989934822715238 },
	{ 0.99866366485040991563, 0.00050454941093878221282, 0.99857007133385322639 },
	{ 0.99866384923380213667, 0.00050449537575201477621, 0.9985702659024869865 },
	{ 0.99866399045389497857, 0.00050443228065924136921, 0.99857040605446445447 },
	{ 0.99866413712900492516, 0.00050437441170172200942, 0.99857057180306041388 },
	{ 0.99866429185312610706, 0.00050431612312750340611, 0.99857073385140016075 },
	{ 0.99866441468637801027, 0.00050425493538336287492, 0.99857087102791364241 },
	{ 0.9986645945112069267, 0.0005041991645093395159, 0.99857105771919774106 },
	{ 0.99866475913446750567, 0.00050414188682989624461, 0.99857123340508013865 },
	{ 0.99866491500299769957, 0.00050408413231329478148, 0.99857140025993862409 },
	{ 0.99866504544657086484, 0.00050402380287603912572, 0.99857154565712469285 },
	{ 0.99866522477548935743, 0.00050396974861578530073, 0.99857173910042285048 },
	{ 0.9986653601781688705, 0.00050390888512091217954, 0.99857188461205004248 },
	{ 0.99866551711481432729, 0.00050385235130743577861, 0.99857205177208407942 },
	{ 0.9986656478826365646, 0.00050378963768438894677, 0.99857219139000397146 },
	{ 0.99866581557672828851, 0.00050373394310431092447, 0.99857237251183017523 },
	{ 0.99866597499292686368, 0.00050367355644659621196, 0.99857253147026503459 },
	{ 0.99866612155359579805, 0.00050361656486944789916, 0.99857269985100227672 },
	{ 0.9986662990133124973, 0.00050356270134405730753, 0.99857288707634384028 },
	{ 0.99866641852777793265, 0.00050349811851935048507, 0.99857301269432474644 },
	{ 0.99866657920282675409, 0.00050344333946661628653, 0.99857318832298669342 },
	{ 0.99866676755350425321, 0.00050339235603766134281, 0.99857339795967470231 },
	{ 0.998666905626471757, 0.00050332851707892128229, 0.99857353435417528509 },
	{ 0.99866706103723834609, 0.00050327335655646040016, 0.99857370914360399361 },
	{ 0.99866720239084538768, 0.00050321043312506405498, 0.99857385175606117045 },
	{ 0.99866735757273006335, 0.00050315687477545481023, 0.99857403043648085283 },
	{ 0.99866751788538243861, 0.00050309543907599198892, 0.99857418651481932859 },
	{ 0.99866768069666167484, 0.00050303974449591407504, 0.99857436122795395494 },
	{ 0.99866782042902269012, 0.00050297905266241801567, 0.99857450981041251392 },
	{ 0.99866798159998215745, 0.00050292599022345324273, 0.99857469692131339833 },
	{ 0.9986681210653141072, 0.00050286526024298462342, 0.99857483882805153641 },
	{ 0.99866828685205721872, 0.00050280613243536753307, 0.99857501071831000772 },
	{ 0.99866843718927655882, 0.00050274978935675436551, 0.9985751779927851679 },
	{ 0.99866858735483421405, 0.00050269110023932290707, 0.99857533376594787011 },
	{ 0.99866875565927759606, 0.00050263510048346364632, 0.9985755170240045997 },
	{ 0.99866889165323513566, 0.00050257631599860046277, 0.9985756683530448985 },
	{ 0.99866904755991225962, 0.0005025154715772139468, 0.99857582433601599359 },
	{ 0.99866918679636251799, 0.00050245649635748742146, 0.99857597288032740046 },
	{ 0.99866935574930437713, 0.00050240160286383521784, 0.99857615426918222568 },
	{ 0.99866952556055321732, 0.00050234688103155996763, 0.99857633994957162304 },
	{ 0.99866964671533831055, 0.00050228004753546625413, 0.99857645805259886984 },
	{ 0.99866979411524070542, 0.00050222603142218520591, 0.99857662742515740373 },
	{ 0.99866997088831188645, 0.00050216919243292756653, 0.99857680801292592054 },
	{ 0.99867013371866486526, 0.00050211462318854288133, 0.99857698846718001562 },
	{ 0.99867029378336213963, 0.0005020567923779961899, 0.99857715219398668349 },
	{ 0.99867042243402748269, 0.00050199798881964672638, 0.99857730037590208827 },
	{ 0.99867056517999930332, 0.00050193916618781087447, 0.99857745899101435505 },
	{ 0.9986707300893621353, 0.00050188228905158045832, 0.99857763000389265784 },
	{ 0.99867087767999929149, 0.00050182358086066250306, 0.99857778591056967077 },
	{ 0.9986710412732914266, 0.00050176771461920752736, 0.99857796110054131145 },
	{ 0.99867118867319359943, 0.00050171247780280141693, 0.99857812742134177686 },
	{ 0.99867134084146735873, 0.00050165300667243052819, 0.9985782869138344342 },
	{ 0.99867150668543092085, 0.0005015962630506045055, 0.99857846000572270118 },
	{ 0.99867162866037595403, 0.0005015338736768253005, 0.99857859182258668085 },
	{ 0.9986717903081725467, 0.00050147796928839776485, 0.9985787648000339356 },
	{ 0.99867197040003041764, 0.00050142483055548776362, 0.99857895854850775574 },
	{ 0.99867210694711916474, 0.0005013651496167671447, 0.99857910688301088076 },
	{ 0.99867227004450065397, 0.0005013090163465035989, 0.99857927936454748963 },
	{ 0.99867239505213001305, 0.00050124595940070286026, 0.99857940811058010233 },
	{ 0.99867257995050628949, 0.00050119488060431629985, 0.99857961215873658478 },
	{ 0.99867270532053198373, 0.00050113043129401376244, 0.99857973558326651453 },
	{ 0.9986728820363829362, 0.00050107830345587909323, 0.99857992938896111834 },
	{ 0.99867298213403932206, 0.00050101238548712920349, 0.99858003436942988085 },
	{ 0.99867315062921746538, 0.00050095596611457069922, 0.99858021079917835827 },
	{ 0.99867333001535640857, 0.00050090246498542051121, 0.998580398386916257 },
	{ 0.99867347859781485653, 0.00050084513008551840001, 0.99858056337257306012 },
	{ 0.99867363931101083008, 0.0005007938987012412746, 0.99858075063606188682 },
	{ 0.99867377881448982091, 0.00050072939217047968043, 0.99858088434120084731 },
	{ 0.9986739329282593447, 0.00050067293465094861622, 0.99858105249305617601 },
	{ 0.99867409503381965319, 0.00050061947166877098815, 0.99858123218437089275 },
	{ 0.99867425097864392924, 0.00050055996239142732263, 0.99858138873954660486 },
	{ 0.99867436408441778717, 0.00050049644768195478053, 0.9985815096273028546 },
	{ 0.99867453193109756437, 0.00050044578850226746364, 0.99858170432945125849 },
	{ 0.99867467175882573827, 0.00050038519203620312938, 0.9985818488492569367 },
	{ 0.99867482963007203622, 0.0005003287154431857852, 0.99858201618095221441 },
	{ 0.99867499251764524359, 0.00050027157127814690738, 0.99858218791862296548 },
	{ 0.99867515172403553692, 0.00050021570503669193167, 0.99858235883613366557 },
	{ 0.99867528384607540115, 0.00050015743553595982517, 0.99858250415702576319 },
	{ 0.99867545964639881095, 0.00050010156929450484947, 0.99858268308540087954 },
	{ 0.99867559235971670173, 0.00050004385292487594627, 0.99858283639808387289 },
	{ 0.99867574050348484338, 0.00049998554527717095457, 0.99858299133201300357 },
	{ 0.99867589433115200315, 0.00049993089973884104107, 0.998583164690930003 },
	{ 0.99867606042307077718, 0.00049987100899177090881, 0.99858332513709691103 },
	{ 0.99867618607919883544, 0.00049981294929938820722, 0.99858346925635954605 },
	{ 0.99867636519830882413, 0.00049975818932014039707, 0.9985836565770686013 },
	{ 0.9986765088216609243, 0.00049970199882941768611, 0.99858381347556712804 },
	{ 0.99867664355676843968, 0.00049963898003058972424, 0.99858395126243215678 },
	{ 0.99867681003015706942, 0.00049958542168098047948, 0.99858413238425824954 },
	{ 0.99867697501581376152, 0.00049953266441779705341, 0.99858431537528602462 },
	{ 0.9986771111051387928, 0.00049947088539558043372, 0.99858445657630512393 },
	{ 0.99867728753488738125, 0.00049941721260505329231, 0.9985846413983877623 },
	{ 0.99867738927286353601, 0.00049935179054694787439, 0.99858474977393707483 },
	{ 0.99867755452554896056, 0.00049929701149421367584, 0.99858492387672004309 },
	{ 0.99867772057932080454, 0.00049924227058845225408, 0.99858510274787459782 },
	{ 0.99867786435526073596, 0.00049918394386726087399, 0.99858525712867285407 },
	{ 0.998678037161047083, 0.00049913076698737831281, 0.99858544458289644208 },
	{ 0.99867817765634747662, 0.00049907297432380428974, 0.99858559858222495365 },
	{ 0.99867832093637687318, 0.0004990139228101325361, 0.99858574766059404748 },
	{ 0.99867845620554185349, 0.00049895662605720287643, 0.99858589696784472167 },
	{ 0.99867860925119589233, 0.00049889818489509359968, 0.99858605977912384688 },
	{ 0.99867876107614694803, 0.0004988406592603281467, 0.99858621679206305277 },
	{ 0.99867892049234563423, 0.00049878538429694936791, 0.99858639017005368377 },
	{ 0.99867907464426208808, 0.00049873010933357069755, 0.99858656087775610199 },
	{ 0.99867923940103686675, 0.0004986745291944105719, 0.99858673227210403844 },
	{ 0.99867938149851009921, 0.00049861582100349261665, 0.99858688161750186474 },
	{ 0.99867952836435480712, 0.00049855699837165676474, 0.9985870344342742122 },
	{ 0.99867967645090272022, 0.00049850061714607103724, 0.99858719304938659 },
	{ 0.9986798334066219196, 0.00049844444572883493151, 0.99858736381430945883 },
	{ 0.99867997416895093465, 0.00049838730156379605369, 0.99858751678366974858 },
	{ 0.99868012536447703376, 0.00049833425819831766914, 0.99858769445319472968 },
	{ 0.99868028737466973954, 0.00049827577888923561562, 0.9985878517331630011 },
	{ 0.99868042867105655258, 0.00049821749031501712073, 0.99858800828833882424 },
	{ 0.99868060532968694343, 0.00049816221535163845036, 0.99858818662543580302 },
	{ 0.99868072394769846767, 0.00049810280144172661837, 0.99858832130332275678 },
	{ 0.99868089156549622043, 0.00049804794609504697469, 0.99858849807639382679 },
	{ 0.99868103187006174171, 0.00049798988640266427311, 0.99858865119834194779 },
	{ 0.9986811819402521273, 0.00049793213188606280997, 0.99858880615134471004 },
	{ 0.99868133603494824158, 0.00049787561714607268901, 0.99858897146125069622 },
	{ 0.99868147654932204471, 0.00049781879723030143803, 0.99858912685294365374 },
	{ 0.99868162984293162854, 0.0004977628546949011256, 0.99858929033179488766 },
	{ 0.99868176457803892188, 0.0004977053290601355642, 0.99858943879981243441 },
	{ 0.99868190768640663357, 0.00049764652550178599226, 0.99858958885092918845 },
	{ 0.99868208568018101978, 0.00049759456932502827645, 0.99858978103537732185 },
	{ 0.99868221820276403822, 0.00049753376305061432043, 0.99858991569419075507 },
	{ 0.99868237662714154368, 0.00049747864067512621508, 0.99859009120841180085 },
	{ 0.99868252623956810243, 0.00049742256462532161761, 0.99859025333304540784 },
	{ 0.99868270434778327882, 0.00049737011253791942999, 0.99859044044394618123 },
	{ 0.99868280139368170722, 0.00049730480492073201714, 0.9985905496968757733 },
	{ 0.99868294970911142272, 0.00049724926292854466827, 0.99859070655722725895 },
	{ 0.99868312837045769559, 0.00049719637215095684873, 0.99859089265723322004 },
	{ 0.9986832922498520837, 0.0004971417456861132152, 0.99859106935401054095 },
	{ 0.99868343848627183501, 0.00049708515465217775753, 0.99859122875113559559 },
	{ 0.9986835993520555288, 0.00049702850639778335153, 0.99859139495749538185 },
	{ 0.99868375621240712547, 0.00049697296440559600265, 0.99859156158347184284 },
	{ 0.99868386739175907252, 0.00049690954506355496881, 0.99859167722601915873 },
	{ 0.99868404439371216696, 0.00049686193764168014482, 0.99859188108344076884 },
	{ 0.99868416387003056123, 0.00049680074989753950521, 0.99859200818915361264 },
	{ 0.99868433438699832916, 0.00049674452125984434273, 0.99859218221564272078 },
	{ 0.99868446263712029598, 0.00049668722450691468306, 0.99859232786078411248 },
	{ 0.99868463567178811235, 0.00049663137733894609574, 0.99859250211615502302 },
	{ 0.99868480452936259084, 0.00049657745659309666421, 0.99859268596548966812 },
	{ 0.99868489821832762132, 0.00049651001274544058223, 0.99859277782339983531 },
	{ 0.99868506820123759127, 0.0004964596587415345038, 0.99859296733755975595 },
	{ 0.99868523860376434698, 0.00049640575706917135224, 0.99859314453024750069 },
	{ 0.99868534511011208821, 0.0004963462477918275783, 0.99859327239889983385 },
	{ 0.99868551659982751634, 0.00049629198372322423996, 0.99859345163245072374 },
	{ 0.99868570441644721747, 0.00049624042808967948771, 0.99859365215201245647 },
	{ 0.99868582457941112995, 0.00049617992699104666171, 0.99859377765555246143 },
	{ 0.99868597899835642728, 0.00049612194359260929685, 0.99859393573660704124 },
	{ 0.9986861304418377383, 0.00049606800377327347693, 0.99859410640616264043 },
	{ 0.99868627734582926525, 0.00049601265251594925301, 0.99859426528830363967 },
	{ 0.99868643001001389248, 0.00049595581352669161363, 0.99859442695517375288 },
	{ 0.99868657298486740448, 0.00049589859306770729067, 0.99859457786459737694 },
	{ 0.99868670697610895104, 0.00049583914101082257348, 0.99859472062964249606 },
	{ 0.99868687337320360964, 0.00049578840553718991988, 0.99859490930456906721 },
	{ 0.99868701772134804706, 0.00049572950661140873126, 0.99859505609411969296 },
	{ 0.99868718079965612677, 0.00049567400276619405074, 0.99859522558111901702 },
	{ 0.99868733191888847678, 0.00049561897575813756208, 0.99859538944144010664 },
	{ 0.9986874690572551394, 0.00049556293785530563297, 0.99859554443258990997 },
	{ 0.99868759915750526801, 0.00049550089180428033477, 0.99859567323584286225 },
	{ 0.99868774991434117183, 0.00049544657051521793969, 0.99859583986181921222 },
	{ 0.99868791085641861471, 0.00049538954079109695852, 0.99859600622076682974 },
	{ 0.99868807610910426131, 0.00049534086525398763733, 0.9985961958875149147 },
	{ 0.99868820119302748051, 0.00049527857124764004901, 0.9985963237943140669 },
	{ 0.99868834763925540265, 0.00049522230446297221818, 0.99859648183722149462 },
	{ 0.99868850234430273094, 0.00049516643822151724247, 0.99859664207357989874 },
	{ 0.99868866135995815192, 0.00049511366188484742801, 0.99859681970495783876 },
	{ 0.99868879786889974692, 0.00049505367577034578748, 0.99859696208853288013 },
	{ 0.99868894017618115022, 0.00049499559700447691435, 0.99859710702795534409 },
	{ 0.99868911729257503485, 0.00049494489967781692911, 0.99859729932684426768 },
	{ 0.99868924834649952516, 0.00049488884270149872003, 0.99859744838613984097 },
	{ 0.99868939103525078416, 0.00049483099281746564021, 0.99859759794134617117 },
	{ 0.99868956172388001491, 0.00049477817833382315739, 0.99859778125662324033 },
	{ 0.99868967650812090486, 0.00049471580803353034077, 0.99859790168661577425 },
	{ 0.99868983283441470356, 0.00049466293632942890963, 0.99859807311911075178 },
	{ 0.99868998465936587028, 0.0004946032744641946791, 0.99859822280783128168 },
	{ 0.99869012740533757988, 0.00049454719841439008163, 0.99859837730307055015 },
	{ 0.99869030463617258775, 0.00049449676811653866648, 0.99859857330221590832 },
	{ 0.99869043122690126513, 0.00049443796455818909454, 0.99859870752233914626 },
	{ 0.99869058114450370844, 0.00049438036262947830483, 0.99859886598486335973 },
	{ 0.99869072711389461627, 0.00049432594597298429306, 0.99859902511495968191 },
	{ 0.99869087008874801725, 0.00049426903068978120855, 0.99859917571920753243 },
	{ 0.99869100184839154632, 0.00049421158134896098386, 0.99859932441610699261 },
	{ 0.99869116843622096624, 0.00049415668785530878025, 0.9985994965733943074 },
	{ 0.99869133136194110367, 0.00049410400688607069089, 0.99859967109579395039 },
	{ 0.99869145633142353269, 0.00049404831230599266859, 0.99859981681722942426 },
	{ 0.99869159739892832128, 0.00049398689568001623567, 0.99859995208639429354 },
	{ 0.99869173934381350044, 0.00049392986595589536292, 0.99860010509390140232 },
	{ 0.99869190146844710743, 0.00049387638390023145488, 0.99860027820486307881 },
	{ 0.99869206817071742854, 0.00049382641136605195161, 0.99860046825308068641 },
	{ 0.99869220015924276002, 0.00049376461327034894353, 0.99860059657949662437 },
	{ 0.99869235230844299878, 0.00049371092140633541373, 0.99860076452154356019 },
	{ 0.99869251582544127377, 0.0004936570769544312105, 0.99860093532461335908 },
	{ 0.99869264213006780917, 0.0004935969191785522913, 0.99860107032674960692 },
	{ 0.99869279445092951075, 0.00049354179680306407754, 0.99860123218435448145 },
	{ 0.99869296037118693299, 0.00049348844826180445454, 0.99860140924352791547 },
	{ 0.99869310237329267377, 0.00049343433678109168122, 0.99860156726736204469 },
	{ 0.99869322665612958456, 0.00049337261497933400985, 0.99860169567007184277 },
	{ 0.99869338918130656779, 0.000493317931294031428, 0.99860186323064914493 },
	{ 0.9986935443250443134, 0.00049326593697030115225, 0.99860203584570028656 },
	{ 0.99869367322366486839, 0.00049320646583993015509, 0.99860217237371540211 },
	{ 0.99869384381692649644, 0.00049315733253914913886, 0.99860236493963305815 },
	{ 0.99869396665017828862, 0.0004930964499707897377, 0.99860248655218175617 },
	{ 0.99869414832513547786, 0.00049304539024788956569, 0.99860268428701426391 },
	{ 0.99869426934640626037, 0.00049298929512459857983, 0.99860282426733026906 },
	{ 0.99869444659631467776, 0.00049293445885140543296, 0.99860300384420386255 },
	{ 0.99869457019250607033, 0.00049287678062874930654, 0.99860314208883260712 },
	{ 0.99869469613473627057, 0.00049281908333260679173, 0.99860327810186333419 },
	{ 0.99869486485879621629, 0.00049276251137215772245, 0.99860344774145071156 },
	{ 0.998694989103486086, 0.00049270517647225550283, 0.99860358419317185596 },
	{ 0.99869513322274872102, 0.00049264650642831032436, 0.99860372938054953185 },
	{ 0.99869529569070514263, 0.00049259588539559556741, 0.99860391313451646322 },
	{ 0.99869545348565746945, 0.00049253898918587897971, 0.99860406772512300133 },
	{ 0.99869560285012892731, 0.00049248968422372101008, 0.99860424806493630623 },
	{ 0.99869574065606769864, 0.00049243194878060582691, 0.99860439262288891449 },
	{ 0.99869588155191113543, 0.00049237100899178758585, 0.99860453317540942564 },
	{ 0.99869603005807583429, 0.00049232076942879940407, 0.99860470373052401261 },
	{ 0.99869616448800746511, 0.00049226110756356517353, 0.99860484151738904135 },
	{ 0.99869632958810505841, 0.00049220953285653414131, 0.99860502187627564474 },
	{ 0.99869646943490675284, 0.0004921531516309483054, 0.99860517057317488288 },
	{ 0.99869662444513007671, 0.00049209682762582141781, 0.9986053303517696822 },
	{ 0.9986967842809456597, 0.00049203922569711062811, 0.99860549064534864794 },
	{ 0.99869689757745438996, 0.00049198330223519670407, 0.99860562515157402785 },
	{ 0.99869704158227601276, 0.00049192543327767734428, 0.99860576915639553963 },
	{ 0.99869722806375182955, 0.00049188043892342938126, 0.9986059883679735405 },
	{ 0.99869735951821947406, 0.00049181917488534340494, 0.99860611799138632172 },
	{ 0.998697483877350356, 0.00049176164925057795196, 0.99860625272649372608 },
	{ 0.99869764970224028655, 0.00049171087562997263, 0.99860643487828792964 },
	{ 0.99869779183786033805, 0.00049165312111337105844, 0.99860658372777511005 },
	{ 0.99869794427316305185, 0.00049160078346688676747, 0.99860675050633929128 },
	{ 0.99869807864587423207, 0.00049154461204965055332, 0.99860690025228027178 },
	{ 0.9986982242910157348, 0.00049148823082406471741, 0.998607055205282923 },
	{ 0.99869839604776011743, 0.00049143751442391834378, 0.99860723882573565469 },
	{ 0.9986985502759704314, 0.00049137872993905526865, 0.99860738962071837754 },
	{ 0.99869869019906631902, 0.0004913239508863210701, 0.99860754541295460029 },
	{ 0.99869880441110248093, 0.00049126207649667272531, 0.99860766038793036259 },
	{ 0.99869895696084609593, 0.00049121221840341111869, 0.99860783666509078671 },
	{ 0.99869910169046027804, 0.00049115278542001289831, 0.99860798063176536843 },
	{ 0.99869926015298460253, 0.00049110327064950509007, 0.99860815999883056904 },
	{ 0.99869941995065303342, 0.00049104967415292317696, 0.99860832933324195082 },
	{ 0.99869954797189319784, 0.00049099001228768894643, 0.99860846101659128671 },
	{ 0.99869971433084081536, 0.00049093817055184934411, 0.99860864164250662256 },
	{ 0.99869984412591517042, 0.00049088157951791399486, 0.99860878322499535553 },
	{ 0.99870000226419031186, 0.00049082632362802149605, 0.9986089469708753219 },
	{ 0.99870013589303552326, 0.00049076868355233803799, 0.99860908792393909827 },
	{ 0.99870026536386069527, 0.00049071138679940837831, 0.99860923143285029724 },
	{ 0.99870041337411441518, 0.00049065676033456474478, 0.99860938737767435125 },
	{ 0.99870057748239082773, 0.00049060739815194760998, 0.99860956903355801995 },
	{ 0.9987007305661921297, 0.00049054991066415482535, 0.99860972219365307101 },
	{ 0.99870087172906463202, 0.00049049282371957489586, 0.99860986785786809428 },
	{ 0.9987010141698606791, 0.00049044285118539539259, 0.99861004020589039243 },
	{ 0.99870116137902809061, 0.00049038727104623526694, 0.99861019939320716521 },
	{ 0.99870130496423303867, 0.00049032730400521979796, 0.99861033779042385206 },
	{ 0.99870146533410608658, 0.00049027496635873561541, 0.99861050884144897388 },
	{ 0.99870160159509235864, 0.00049022018730600141687, 0.99861065914052116188 },
	{ 0.99870173381249949252, 0.00049016350090463423408, 0.99861079852955902947 },
	{ 0.99870188447396801568, 0.0004901058036084918277, 0.99861095018284862235 },
	{ 0.99870202908914151863, 0.00049005495369394116902, 0.99861112028019960452 },
	{ 0.99870217254083215597, 0.00048999904930551352496, 0.99861127368824997852 },
	{ 0.99870232165734806884, 0.00048994568169076751357, 0.99861143882649439085 },
	{ 0.99870247914712462212, 0.00048988977730233997793, 0.99861159578221314614 },
	{ 0.99870264054696589184, 0.00048983816444833627735, 0.99861177053349481358 },
	{ 0.99870277085702441333, 0.00048977987587411767403, 0.99861191060917842144 },
	{ 0.99870290215890411556, 0.00048972547829111005065, 0.9986120554913804348 },
	{ 0.99870304734628201349, 0.00048966970741708669163, 0.99861220769780112416 },
	{ 0.99870319528024176226, 0.00048961744606454773738, 0.99861237211125319924 },
	{ 0.99870335099618412489, 0.00048956167519052448678, 0.9986125322522442227 },
	{ 0.99870348832528565985, 0.00048950735390146209169, 0.99861268300908001549 },
	{ 0.99870363868157829845, 0.00048945030510385483056, 0.99861283733265771012 },
	{ 0.99870377267281984501, 0.00048939432442148184978, 0.99861298066990733524 },
	{ 0.99870392980020028517, 0.00048934263527353281248, 0.99861315221684332499 },
	{ 0.99870407460610843842, 0.00048928694069345479017, 0.99861330831425543231 },
	{ 0.9987042340604541657, 0.00048923246681650183008, 0.9986134738721166304 },
	{ 0.99870435782830702109, 0.00048917347252328891635, 0.99861360053913938994 },
	{ 0.99870447932641492894, 0.00048911850273569137601, 0.99861373996632440964 },
	{ 0.99870464101235845167, 0.00048906656563242004859, 0.99861391633885221442 },
	{ 0.99870479234139897251, 0.0004890119010206037467, 0.99861407682316594148 },
	{ 0.99870493417184313945, 0.00048895704567392410302, 0.99861422552006506859 },
	{ 0.99870511861245581109, 0.00048890688240488114954, 0.99861442163365121694 },
	{ 0.99870520577828836295, 0.00048884359657724440074, 0.99861451429264769253 },
	{ 0.99870537728707731162, 0.00048879171669443191323, 0.99861469190495222303 },
	{ 0.99870553071420131719, 0.00048874128639658038966, 0.99861486974613877798 },
	{ 0.99870566613595423977, 0.00048868154823740071399, 0.99861500120060642249 },
	{ 0.99870581700723115581, 0.00048863161385019366224, 0.99861517595188808993 },
	{ 0.99870595178048560125, 0.00048857389748056465062, 0.99861531492130917176 },
	{ 0.99870609300057822111, 0.00048851827919443185661, 0.99861546316044469407 },
	{ 0.99870622395913533076, 0.0004884636145826154463, 0.9986156118954910843 },
	{ 0.99870639508645453475, 0.00048841089546640458017, 0.99861578546421647662 },
	{ 0.99870653859536551167, 0.0004883548194165999827, 0.99861593934910408699 },
	{ 0.99870666228692439592, 0.00048830250084360208012, 0.99861608432667359203 },
	{ 0.99870683698098561276, 0.00048824957191904164644, 0.99861626321690155628 },
	{ 0.9987069622937908564, 0.00048819139778574083136, 0.998616398142743944 },
	{ 0.9987071317426432504, 0.00048814157783945178468, 0.9986165833081489529 },
	{ 0.99870727336327913548, 0.00048808807671030137983, 0.99861673583881893634 },
	{ 0.99870739283959752974, 0.00048802902519662951777, 0.99861685958759816018 },
	{ 0.99870753920953159177, 0.00048797016441782088908, 0.99861700595753200016 },
	{ 0.9987076756612528472, 0.0004879188567395981559, 0.99861716499226083066 },
	{ 0.9987078358785378418, 0.00048786484062631689084, 0.99861732887165521877 },
	{ 0.99870799045007085937, 0.0004878128081556137299, 0.99861750144855931932 },
	{ 0.99870809831063600548, 0.00048775514900644382924, 0.99861762170689050144 },
	{ 0.99870826831261960699, 0.00048770214378793789621, 0.99861779487507262854 },
	{ 0.99870839854638415733, 0.00048764622032602375533, 0.99861793472187421195 },
	{ 0.99870854892175031647, 0.00048759441673715649612, 0.99861810310261134305 },
	{ 0.9987086949102145228, 0.00048753692924936349465, 0.99861824870960580469 },
	{ 0.99870883963982881593, 0.00048748390495737122744, 0.99861840991871198003 },
	{ 0.99870898372094452089, 0.00048742809593637509164, 0.99861855934040366645 },
	{ 0.99870914172570524059, 0.00048737705528696098276, 0.99861872711078925047 },
	{ 0.99870927081506088996, 0.00048732059776742975591, 0.99861886840717595248 },
	{ 0.99870942115228000802, 0.00048726799309213673222, 0.99861903148548392117 },
	{ 0.99870956117074305425, 0.00048721361458261517197, 0.99861918310062669502 },
	{ 0.99870969327370928692, 0.00048715513527353311845, 0.99861931482212318301 },
	{ 0.99870983228127752085, 0.00048709791481454868707, 0.9986194581021522465 },
	{ 0.99871000073830862309, 0.00048704664528329867645, 0.99861963632480832409 },
	{ 0.99871014068047792023, 0.00048699261009653113143, 0.99861979019062252494 },
	{ 0.99871026816766050871, 0.00048693653404672642554, 0.99861992866413318293 },
	{ 0.99871043275277393558, 0.00048688482582529078301, 0.99862010263340184046 },
	{ 0.9987105735913970328, 0.00048683370888193133741, 0.99862026208774745673 },
	{ 0.99871070872704759136, 0.0004867773848768043414, 0.99862040233509230536 },
	{ 0.99871085118691693694, 0.000486722968220310167, 0.99862056070224913817 },
	{ 0.99871099294106735478, 0.00048667032539804447495, 0.99862071527378215574 },
	{ 0.99871113072793238352, 0.00048661402046640381313, 0.99862086557285434374 },
	{ 0.99871128718774071498, 0.00048656071007211664165, 0.99862102363483529199 },
	{ 0.99871142728249784337, 0.0004865032798047825343, 0.99862116788761223773 },
	{ 0.99871156651894799072, 0.00048645345985849343341, 0.99862132879154286158 },
	{ 0.99871173062722429226, 0.00048640028297861054698, 0.99862149976627412329 },
	{ 0.99871186566750758118, 0.00048634580910165731583, 0.9986216488446431061 },
	{ 0.99871200681130634091, 0.00048628950417001670821, 0.99862179212467228062 },
	{ 0.99871213185708274107, 0.00048623419105966509844, 0.99862193227664974859 },
	{ 0.9987122876302455543, 0.00048618000328500682577, 0.99862209182636274551 },
	{ 0.99871243052880520619, 0.00048612713158090523199, 0.99862225166217799543 },
	{ 0.99871257167260396592, 0.00048607265770395205505, 0.99862240226642584595 },
	{ 0.9987127235357020627, 0.00048601913750131526181, 0.99862255687610601562 },
	{ 0.9987128642598841477, 0.0004859638625379363204, 0.99862270789997076292 },
	{ 0.99871302380959736666, 0.00048591245949228197053, 0.99862287763492540993 },
	{ 0.99871316979806179503, 0.0004858603125806607503, 0.99862303949253028446 },
	{ 0.9987132810537076022, 0.00048580173790414708009, 0.99862315757648389969 },
	{ 0.99871343863885142511, 0.00048574981987436187001, 0.99862332813159848666 },
	{ 0.99871358161370504813, 0.00048569626152475240842, 0.99862347782031901655 },
	{ 0.99871371581475476553, 0.00048563789665658825155, 0.9986236173619447154 },
	{ 0.99871384969155529987, 0.00048558485329110959595, 0.99862376691715093457 },
	{ 0.99871401359002320852, 0.0004855320388074669505, 0.99862393470661015016 },
	{ 0.9987141379110071604, 0.0004854788237806113415, 0.99862408214465936407 },
	{ 0.99871426768700799492, 0.00048542351067025973172, 0.99862421893970299003 },
	{ 0.99871442378441999121, 0.00048536964714486903168, 0.99862438480273985064 },
	{ 0.99871457435052102269, 0.00048531490623910723044, 0.99862453796283490171 },
	{ 0.99871472409646211421, 0.00048526041328866777354, 0.99862469083682769977 },
	{ 0.99871486710946255627, 0.00048520834267099189003, 0.99862485353366592378 },
	{ 0.99871498856942353406, 0.00048515035927255430832, 0.99862498231784546654 },
	{ 0.99871513547341517203, 0.0004850988227124956192, 0.99862513990298940048 },
	{ 0.99871529958169147356, 0.00048504762947519078266, 0.99862531515018160277 },
	{ 0.998715442251369101, 0.00048499590218026886017, 0.99862547552005453966 },
	{ 0.99871557660500676068, 0.00048494013130624539273, 0.99862561658755932825 },
	{ 0.99871570516030450104, 0.00048488298714120629807, 0.99862574788943903048 },
	{ 0.99871584975640415038, 0.00048483040153939960856, 0.99862590774432780094 },
	{ 0.9987160063688003131, 0.00048477796852548359248, 0.99862607313052764724 },
	{ 0.99871612416665189738, 0.00048472120583017107298, 0.99862620435611348935 },
	{ 0.99871629168908226948, 0.00048467258751352064591, 0.99862638389484015278 },
	{ 0.99871643397729026326, 0.00048461574852426278969, 0.9986265274037511297 },
	{ 0.99871656966607202932, 0.00048456230461557133317, 0.99862667789355819004 },
	{ 0.99871672925393217835, 0.00048451288521249514163, 0.99862685293094211048 },
	{ 0.99871685855309588753, 0.00048445572197396965857, 0.99862698879138500629 },
	{ 0.99871697820107552257, 0.00048439710915048332001, 0.99862710836307055917 },
	{ 0.99871715350548817547, 0.00048435020744760237275, 0.99862730087176787563 },
	{ 0.99871728351037092342, 0.00048429100334603978305, 0.99862743087665062358 },
	{ 0.99871742297570287317, 0.00048424125969369601888, 0.99862759292499025943 },
	{ 0.99871756783883158803, 0.00048418962776620571306, 0.99862775567904893403 },
	{ 0.99871769586007175246, 0.00048412966072519008146, 0.99862787790194906812 },
	{ 0.99871787438790382563, 0.00048408296883065881017, 0.99862807229892158745 },
	{ 0.99871798476616935325, 0.00048402588188607866384, 0.998628197859682043 },
	{ 0.99871812585274755136, 0.00048397138893563909851, 0.99862834268466349474 },
	{ 0.9987182771436409201, 0.00048391866981942806974, 0.9986285012997756505 },
	{ 0.99871841140191119912, 0.0004838627272840276489, 0.99862864562884656738 },
	{ 0.99871853454033887587, 0.00048380916893441824151, 0.99862878341571159613 },
	{ 0.99871870370308901688, 0.00048375692665536545881, 0.99862895898715309251 },
	{ 0.99871884892861395588, 0.0004837022620435490485, 0.99862910657779013768 },
	{ 0.99871898364464795073, 0.00048365009605844160251, 0.99862926109210281567 },
	{ 0.99871914031426456404, 0.00048359527885873457298, 0.99862941707507391076 },
	{ 0.99871926043908154647, 0.00048354038536508220673, 0.99862955261126773454 },
	{ 0.99871940444390328029, 0.00048348991692025796059, 0.99862971324816962593 },
	{ 0.99871954627434744722, 0.00048343612968881259726, 0.99862986423388733215 },
	{ 0.99871970380227081954, 0.0004833867102857363515, 0.99863003843203801413 },
	{ 0.99871986379067412276, 0.0004833329230542910966, 0.99863019857302914861 },
	{ 0.99871995908181188106, 0.00048327532112558014427, 0.99863030897036808575 },
	{ 0.99872012692849154725, 0.00048321977913339263276, 0.99863047193423515324 },
	{ 0.99872028706948279275, 0.00048317026436288477032, 0.99863064779177901364 },
	{ 0.9987204071561527341, 0.00048311365425546287005, 0.99863077337161298974 },
	{ 0.99872053937355997899, 0.00048306230843026752271, 0.99863092573062162138 },
	{ 0.99872068679253567236, 0.00048301006615121474001, 0.99863108615771500887 },
	{ 0.99872081841866489071, 0.00048295431435067766096, 0.99863122468844600643 },
	{ 0.99872094619194962117, 0.00048289814293344133838, 0.99863135818377657404 },
	{ 0.99872110038201289406, 0.00048284481346566788694, 0.99863151832476759751 },
	{ 0.99872123870293572079, 0.00048279133141000376206, 0.99863166427508476275 },
	{ 0.99872139874855947461, 0.0004827421790357361406, 0.99863184434786900212 },
	{ 0.9987215293256469506, 0.00048268408119638066224, 0.99863197255984392786 },
	{ 0.99872166406075435496, 0.00048263296425302127084, 0.99863212499514664167 },
	{ 0.99872180989663084105, 0.00048257669746835327737, 0.99863227044955327205 },
	{ 0.99872194020668947356, 0.0004825269538160095132, 0.99863242944613506147 },
	{ 0.99872210149208984209, 0.00048247431099374387536, 0.99863259256258996022 },
	{ 0.99872223527352299577, 0.00048242033302743527867, 0.99863273763552695694 },
	{ 0.99872238381783440264, 0.00048236776649911492333, 0.99863289441958447146 },
	{ 0.99872251418511337473, 0.00048231525719125357054, 0.99863304298296917683 },
	{ 0.998722652525109722, 0.00048225977241952500737, 0.9986331843747232595 },
	{ 0.99872279096047344993, 0.00048220541298348983551, 0.99863333043948143697 },
	{ 0.99872294137398665015, 0.0004821533423658140062, 0.99863349122897115961 },
	{ 0.99872308963219602607, 0.00048210426628549172146, 0.9986336593617530788 },
	{ 0.99872322375695188335, 0.00048204735100228852853, 0.9986337983693212017 },
	{ 0.99872337066094363234, 0.00048199718773324552084, 0.99863395892992901093 },
	{ 0.99872349254052117384, 0.0004819392424817806617, 0.99863408286944299608 },
	{ 0.99872361924569086344, 0.00048188688576180998234, 0.99863422521487144046 },
	{ 0.99872376611153534931, 0.00048183065712411471144, 0.99863437070742488988 },
	{ 0.99872391890923428726, 0.00048178428947885101278, 0.99863455108538501381 },
	{ 0.9987240797177973084, 0.00048173345863778657986, 0.9986347196759305378 },
	{ 0.9987241984121029148, 0.00048167248070199561623, 0.99863483192339741468 },
	{ 0.99872433986107744808, 0.00048162380516488618662, 0.99863499534502808697 },
	{ 0.99872448401848701316, 0.00048156753838021819315, 0.9986351425541956095 },
	{ 0.99872460585991773563, 0.00048151451408822592594, 0.9986352772130089317 },
	{ 0.99872478114525720105, 0.00048146663963754231502, 0.99863546737566732947 },
	{ 0.9987248941365902688, 0.00048140583336312819636, 0.99863557670489078166 },
	{ 0.99872505275170253558, 0.00048135937035043288102, 0.99863575790301073454 },
	{ 0.99872520608345916049, 0.00048130682289559891408, 0.99863591852083899436 },
	{ 0.99872531228463112818, 0.0004812445670362238857, 0.99863602228060455168 },
	{ 0.99872547410408907265, 0.00048119962990243487101, 0.99863620698824606681 },
	{ 0.9987255983106320123, 0.00048114012062509104286, 0.99863632875338270711 },
	{ 0.99872572627465183714, 0.00048108856499154612797, 0.99863647682085687762 },
	{ 0.9987259077398006335, 0.00048104191124398752505, 0.99863666904345205211 },
	{ 0.99872605040947826094, 0.00048098713219125310966, 0.99863681507006329952 },
	{ 0.99872618369500065771, 0.0004809356337781671431, 0.99863696498766563181 },
	{ 0.99872631617943674609, 0.00048088127434213197124, 0.99863710838213570753 },
	{ 0.99872647525231272869, 0.0004808311492200615777, 0.99863727676287294965 },
	{ 0.99872660222451126177, 0.00048077505409677059184, 0.99863740972414616337 },
	{ 0.99872673488060870195, 0.00048071960747201469702, 0.99863754733935006236 },
	{ 0.99872686969201018847, 0.00048066932976205373846, 0.99863770397081963459 },
	{ 0.99872702731530116349, 0.00048061607658822556952, 0.99863786495104400753 },
	{ 0.99872715806404999128, 0.00048056230843026659458, 0.99863800096407506768 },
	{ 0.99872732068459435517, 0.00048051397621591112599, 0.99863817876711469257 },
	{ 0.99872746579567839298, 0.00048046377479989550415, 0.99863834127321815526 },
	{ 0.99872757920662813547, 0.00048040598213632126423, 0.99863845956698016337 },
	{ 0.99872771327416343112, 0.00048035263359506147861, 0.99863860237017221255 },
	{ 0.99872785197655600253, 0.00048029632866342081678, 0.99863874503984995101 },
	{ 0.99872800162712960237, 0.00048024761497933871881, 0.99863891132250348637 },
	{ 0.99872814582268620853, 0.00048019466698129184253, 0.99863906284227887955 },
	{ 0.99872826102654377323, 0.00048013805687386988804, 0.99863918445482757758 },
	{ 0.99872841597954675752, 0.00048008747398812763683, 0.99863935024157057807 },
	{ 0.99872854079644135528, 0.00048003467857797137977, 0.99863949153795716907 },
	{ 0.99872868705193429406, 0.00047997967064340100844, 0.99863963733568650305 },
	{ 0.99872882144371877278, 0.00047992691338021736553, 0.99863978698626010289 },
	{ 0.99872894343773743753, 0.00047987114250619389809, 0.99863991310015165492 },
	{ 0.99872912013451475843, 0.0004798256713147876348, 0.99864011054888202068 },
	{ 0.99872926181237109411, 0.00047977585136849853391, 0.99864026702776365063 },
	{ 0.99872940078179239798, 0.000479718058704924294, 0.99864039989366926164 },
	{ 0.99872950606743693402, 0.00047966282188851802094, 0.99864052226915733801 },
	{ 0.99872967650811084184, 0.00047961292564828358334, 0.99864069545641298564 },
	{ 0.99872980597893601384, 0.00047955944359261951267, 0.9986408388127361313 },
	{ 0.99872993670861132109, 0.00047950439751107652719, 0.99864097556963293822 },
	{ 0.99873009412209412528, 0.00047945741951425029743, 0.99864115400209751972 },
	{ 0.99873022000710365287, 0.00047939989387948468182, 0.99864127714052508544 },
	{ 0.99873038449684969908, 0.00047935625374276590342, 0.99864147031679462163 },
	{ 0.99873050979058142218, 0.00047930027306039286843, 0.9986415995396644707 },
	{ 0.99873061189095357904, 0.000479237883686613555, 0.99864169950380632379 },
	{ 0.99873080651680801179, 0.00047919569313485574054, 0.99864191320314710243 },
	{ 0.99873092915932515368, 0.00047914118111092989525, 0.99864204584017080002 },
	{ 0.99873106683174950327, 0.00047908491432626190178, 0.9986421798504857561 },
	{ 0.99873118935982563293, 0.00047903166115243373284, 0.99864231916322976357 },
	{ 0.99873131955544325322, 0.00047898088753182819404, 0.99864246560945757469 },
	{ 0.99873147073189583178, 0.00047892813026864455113, 0.99864262266054382167 },
	{ 0.99873161279122191214, 0.00047887792885262887507, 0.99864277967348313858 },
	{ 0.99873174306313350357, 0.00047882234871346874942, 0.99864291170015540011 },
	{ 0.99873190926949328983, 0.00047877172768075388406, 0.99864308637514320743 },
	{ 0.99873199969689219202, 0.00047871422111947454841, 0.99864318923845496467 },
	{ 0.99873216035286760395, 0.00047866644203622255417, 0.99864336519136620574 },
	{ 0.99873228642861222593, 0.0004786101752515545607, 0.99864349431886856312 },
	{ 0.99873246814171634522, 0.00047856804192025574878, 0.9986436998356835737 },
	{ 0.9987325625364000814, 0.00047850191414315618307, 0.99864377996339936949 },
	{ 0.99873272820870240274, 0.00047845724403817568426, 0.99864397012605798931 },
	{ 0.99873287579933978098, 0.0004784041815992108029, 0.99864411947145570458 },
	{ 0.99873299512307023296, 0.00047835199654061702273, 0.99864425710573290207 },
	{ 0.99873316228310438092, 0.00047830232918221859528, 0.99864442853822799062 },
	{ 0.99873329858223747202, 0.00047824926674325371392, 0.99864457948579854474 },
	{ 0.99873342145363641631, 0.00047819429695565601095, 0.99864470640077629415 },
	{ 0.99873356553475212127, 0.0004781431418653239512, 0.9986448614682199576 },
	{ 0.99873371121804066508, 0.00047809488594491376511, 0.99864502836122515106 },
	{ 0.99873382626931017647, 0.00047803781807382000717, 0.99864514768495560304 },
	{ 0.99873398015419767582, 0.00047798647224862465983, 0.99864530706300713714 },
	{ 0.99873411252419275197, 0.00047793299019296058916, 0.99864544828309975699 },
	{ 0.99873426362435158143, 0.00047788328468758949335, 0.99864561082735003872 },
	{ 0.99873439561287702393, 0.00047782942116219884751, 0.99864575227632446097 },
	{ 0.99873453408638779294, 0.00047777563393075348419, 0.99864589456453234373 },
	{ 0.99873465897957613979, 0.00047772367775399571417, 0.99864603715791600003 },
	{ 0.99873481810967257299, 0.00047767280876595855869, 0.99864620208635224152 },
	{ 0.99873494491020975428, 0.00047761833488900538175, 0.99864633590593221424 },
	{ 0.99873510310570545734, 0.00047757122337777486694, 0.99864650989427439232 },
	{ 0.99873521220604732918, 0.00047751217186410300488, 0.99864661746873728543 },
	{ 0.9987353720227892806, 0.00047746305763680810599, 0.9986467885769830799 },
	{ 0.99873549977700071256, 0.00047740946114022603025, 0.99864692754640438377 },
	{ 0.99873565623680915504, 0.00047736114799935684162, 0.99864710021867608702 },
	{ 0.99873577979485350653, 0.00047730793297250134104, 0.9986472340764029898 },
	{ 0.99873592919747189445, 0.00047725405037362430682, 0.99864738092317406615 },
	{ 0.99873607047478518695, 0.00047720428764779415426, 0.99864753921403703885 },
	{ 0.99873620021263920243, 0.00047715137779671989212, 0.99864767894639772106 },
	{ 0.99873632342736096135, 0.00047709972679574330634, 0.99864782062425405673 },
	{ 0.99873647546212040993, 0.00047704904854256943844, 0.99864798463716297761 },
	{ 0.99873658906380502476, 0.000476993277668545971, 0.99864810617341770449 },
	{ 0.99873675851265764081, 0.000476944068073819347, 0.99864827745332485076 },
	{ 0.99873690095345357687, 0.000476891043781827134, 0.99864842813386678344 },
	{ 0.99873701371590473119, 0.00047683656990487401127, 0.99864855066194291311 },
	{ 0.9987371692029651804, 0.00047678636848885838943, 0.99864871652497999577 },
	{ 0.9987372712079699566, 0.00047672769844491310253, 0.99864882158174250737 },
	{ 0.99873744962136112857, 0.00047668371498544047154, 0.99864901861085619839 },
	{ 0.99873756913582645289, 0.00047662889778573344201, 0.9986491448391885406 },
	{ 0.99873771665016974897, 0.0004765779715772373382, 0.99864930288209619036 },
	{ 0.99873784987847180616, 0.0004765252715345125894, 0.99864944488420170909 },
	{ 0.9987379665319141564, 0.00047647087395150474918, 0.99864957404985099654 },
	{ 0.99873815276543465025, 0.00047642593681771573449, 0.99864976867570554031 },
	{ 0.9987382662145313228, 0.00047637260734994228304, 0.99864989631547596005 },
	{ 0.99873839789788099175, 0.00047631538689095790588, 0.99865002616777076572 },
	{ 0.99873852469841817303, 0.00047626610100228599937, 0.99865017097367891896 },
	{ 0.99873864543358659152, 0.00047620998680550862513, 0.99865030109300256811 },
	{ 0.99873880238930556885, 0.00047616201698739339752, 0.99865046720399486269 },
	{ 0.99873894036690569198, 0.00047610750496346760643, 0.99865061052217096726 },
	{ 0.99873908088127938409, 0.00047605614006478592492, 0.9986507584752043476 },
	{ 0.99873920771996349544, 0.0004760039931531647589, 0.99865089942826812397 },
	{ 0.99873936328331802681, 0.00047595493614632875413, 0.99865106658830227193 },
	{ 0.99873948628823139284, 0.00047590151131112368599, 0.99865120015992692171 },
	{ 0.99873962115685310792, 0.0004758477050061920427, 0.99865133937730354852 },
	{ 0.99873975802819114911, 0.0004757947570081451122, 0.99865148052110230825 },
	{ 0.99873990842263082879, 0.0004757440024610259618, 0.99865163793458477937 },
	{ 0.99874003922859999616, 0.00047569544136483448305, 0.99865179460420128166 },
	{ 0.99874016761223660676, 0.0004756426268811918376, 0.99865193221940518065 },
	{ 0.99874031814019070818, 0.00047559356987435583283, 0.99865209449662672991 },
	{ 0.9987404592076956078, 0.00047554054558236361983, 0.99865224166764721137 },
	{ 0.99874057858864651038, 0.00047548837959725617384, 0.99865237581147647816 },
	{ 0.99874072734276642116, 0.00047543529808480501251, 0.99865252204789600743 },
	{ 0.99874085591713779309, 0.00047537882149178739728, 0.99865264997376879119 },
	{ 0.99874100196282256103, 0.0004753325682874417037, 0.99865281928910676346 },
	{ 0.99874113946358566984, 0.00047527876198251000619, 0.99865295904054096621 },
	{ 0.99874127248207944518, 0.00047522905647713885617, 0.99865310899629033958 },
	{ 0.99874138711373239286, 0.00047517149269540051798, 0.9986532281292858082 },
	{ 0.9987415693990412402, 0.00047512840568978532236, 0.99865342815293689505 },
	{ 0.99874168799797913287, 0.00047507511436898448506, 0.99865355552567847131 },
	{ 0.99874181056420241465, 0.00047502304375130870997, 0.99865369418992411266 },
	{ 0.9987419598142329713, 0.00047497061073739263969, 0.99865384656800637586 },
	{ 0.99874207314888885367, 0.00047491564094979499093, 0.9986539663876473627 },
	{ 0.99874222508828103262, 0.00047486372292000978085, 0.99865411878480303542 },
	{ 0.99874235207955297522, 0.00047481279671151367704, 0.9986542616452155352 },
	{ 0.99874252351204817479, 0.00047476877510506832348, 0.99865445337190006381 },
	{ 0.99874263413826891433, 0.00047471063911874017676, 0.99865456491364790192 },
	{ 0.99874277402321776087, 0.00047465864479500968418, 0.99865471250428505812 },
	{ 0.9987429186956116034, 0.000474609416126796726, 0.99865487167252842138 },
	{ 0.99874305011193242887, 0.00047455742180306628763, 0.99865501171006498815 },
	{ 0.99874318238656023539, 0.00047450487434823226647, 0.99865515188111586564 },
	{ 0.99874332456032743899, 0.00047445326149422829484, 0.99865530160798343662 },
	{ 0.99874346528450952398, 0.00047440409004647428499, 0.99865545858277571245 },
	{ 0.99874358964364040592, 0.00047434717476327114627, 0.99865558294190648336 },
	{ 0.99874373349587430848, 0.00047429861366707972174, 0.9986557412136958245 },
	{ 0.99874387154976840275, 0.00047424951851327110282, 0.99865589437379087556 },
	{ 0.99874402245919224885, 0.00047419779121834918032, 0.99865604894532411517 },
	{ 0.9987441432134342989, 0.00047414688408333941069, 0.99865618675126266446 },
	{ 0.9987442790929509373, 0.0004740952330823627707, 0.99865632980241003658 },
	{ 0.99874442244927430501, 0.00047404068291146431125, 0.99865647056473905163 },
	{ 0.99874455356041924592, 0.00047399029076058540183, 0.99865661311997566685 },
	{ 0.9987446890393926191, 0.000473939536213466143, 0.9986567680157579785 },
	{ 0.99874482926766394719, 0.00047388994514901294384, 0.99865691831483016649 },
	{ 0.99874495976845734102, 0.00047383734047371997436, 0.9986570580471908487 },
	{ 0.99874509450356474538, 0.0004737807303662981283, 0.99865718393220059834 },
	{ 0.99874522725502956622, 0.00047373342812020432591, 0.99865733743561835301 },
	{ 0.99874537827889431352, 0.00047368067085702062879, 0.9986574931897076457 },
	{ 0.99874550885598178951, 0.00047363127052743077142, 0.99865764451874816654 },
	{ 0.99874563815514549869, 0.00047357693016488193374, 0.99865777454270432401 },
	{ 0.99874579921166417584, 0.00047353077232796791105, 0.99865794887436931671 },
	{ 0.99874591071526530595, 0.00047347770988900297548, 0.99865807464493816514 },
	{ 0.99874603385369309372, 0.00047342323601204979854, 0.99865820114029935084 },
	{ 0.99874618131081582817, 0.00047337454140145403475, 0.99865836538209007411 },
	{ 0.99874633313576699489, 0.00047332372963387588181, 0.99865852208985361749 },
	{ 0.99874645335595124696, 0.00047326912224251847404, 0.99865864913834601069 },
	{ 0.99874661853234281139, 0.0004732220488782606818, 0.99865882377518677693 },
	{ 0.99874672404686914984, 0.00047317009270150285757, 0.99865894195450799486 },
	{ 0.99874686904351217542, 0.00047311863243538950516, 0.9986591006077671917 },
	{ 0.99874700267235738682, 0.00047306839287240116075, 0.9986592446125888145 },
	{ 0.99874714358727434416, 0.00047301491081673709008, 0.99865938415421462437 },
	{ 0.99874725551049226002, 0.0004729626494641979732, 0.99865951255692442246 },
	{ 0.99874742038170816194, 0.00047291267693001825308, 0.99865968200577681646 },
	{ 0.99874751992623334029, 0.00047285665810067254973, 0.99865978837861013595 },
	{ 0.99874766099373812889, 0.00047280760109383654496, 0.99865994089020670987 },
	{ 0.99874780499855986271, 0.00047276148140389513642, 0.99866010663880278031 },
	{ 0.99874796237389551479, 0.00047270748436410020554, 0.9986602561558619584 },
	{ 0.99874810477654452079, 0.00047265922844369001946, 0.99866041694535168105 },
	{ 0.99874822627465253966, 0.00047260479271370951088, 0.99866054324997799441 },
	{ 0.99874836333672534217, 0.00047255455315072127489, 0.9986606895436180853 },
	{ 0.99874847396294597068, 0.0004724985533948618515, 0.99866080444229954338 },
	{ 0.99874860991875646921, 0.00047244926750618999921, 0.99866095535172327846 },
	{ 0.99874876059929840189, 0.0004724017363782603493, 0.9986611215962301058 },
	{ 0.998748876890344639, 0.00047234659492928574714, 0.99866124067200523484 },
	{ 0.99874902219216343813, 0.00047229696571785993384, 0.99866139840973700004 },
	{ 0.9987491540090274178, 0.00047224651634652196766, 0.99866154262436701572 },
	{ 0.99874929511467924748, 0.00047219444572884619257, 0.99866168395890053677 },
	{ 0.99874944894234640724, 0.00047214819252450049899, 0.99866185792816919431 },
	{ 0.99874957093636496097, 0.00047209364235360203954, 0.99866198572052744531 },
	{ 0.99874971326271999583, 0.00047204073250252777741, 0.99866212682617916396 },
	{ 0.99874984370629305008, 0.00047199306786019378825, 0.99866227943314322957 },
	{ 0.99874996150414463436, 0.00047194118797738124653, 0.99866241187943227686 },
	{ 0.99875009662072189442, 0.00047189029991585775686, 0.99866255691422212148 },
	{ 0.99875024611870777402, 0.00047183906853158036039, 0.99866271152390218013 },
	{ 0.99875034539620399787, 0.00047178224861580883836, 0.99866281141174995106 },
	{ 0.99875052306572920102, 0.0004717396956678107287, 0.9986630098713750181 },
	{ 0.9987506745473574421, 0.00047168869316536934239, 0.99866316646469754925 },
	{ 0.99875077701012593412, 0.00047163154900033024772, 0.99866326740158717357 },
	{ 0.99875091723839748425, 0.00047158470451790830301, 0.99866343021286629877 },
	{ 0.99875105630318616878, 0.00047153242409188285194, 0.99866357137573846803 },
	{ 0.99875118991295797066, 0.00047148342430550590392, 0.99866372356308574787 },
	{ 0.99875132543007816288, 0.00047143163979012503309, 0.99866386052979094767 },
	{ 0.99875145486275629381, 0.00047137934029061324785, 0.99866399820221507522 },
	{ 0.99875158811013187155, 0.00047133024513680462893, 0.99866414800537661733 },
	{ 0.99875174016396484067, 0.0004712782889600468047, 0.99866429899109432355 },
	{ 0.99875184756676638198, 0.00047122303307015419747, 0.99866441455734789034 },
	{ 0.9987520027486512797, 0.00047117801964241979185, 0.99866458835495519608 },
	{ 0.99875212886254294276, 0.00047112469017464634041, 0.99866472103012604578 },
	{ 0.99875226191918353713, 0.00047107464134652133779, 0.9986648638523916155 },
	{ 0.99875239177147845382, 0.00047102291405159941529, 0.99866499889267468237 },
	{ 0.99875253360192295382, 0.00047097233116585721828, 0.99866515537155642335 },
	{ 0.99875262736718151135, 0.00047091854393441190917, 0.99866526027573110369 },
	{ 0.99875280520836795528, 0.00047087147057015406272, 0.9986654413212632253 },
	{ 0.9987529313031860978, 0.00047082289040047624979, 0.9986655898083542926 },
	{ 0.99875307618538811116, 0.00047077383339364029923, 0.99866574399841767651 },
	{ 0.99875322806755972849, 0.0004707229262586305296, 0.99866589801681959759 },
	{ 0.99875331088463725759, 0.00047066307365853279465, 0.99866598319900945491 },
	{ 0.99875347846428796927, 0.00047061954796273202132, 0.9986661698521466235 },
	{ 0.99875360568444160325, 0.00047056648552376708575, 0.99866630134476142011 },
	{ 0.99875376172463314894, 0.00047052233040291750136, 0.99866647855652268539 },
	{ 0.99875388402382747621, 0.0004704670172925659458, 0.99866660390747474807 },
	{ 0.99875400929848567877, 0.00047041437447030030796, 0.99866673284424223311 },
	{ 0.9987541370145502917, 0.00047036600410897217101, 0.99866688009155646366 },
	{ 0.99875428496758356101, 0.00047031528770882558054, 0.99866703163040537738 },
	{ 0.99875441573540568729, 0.00047026539146859114293, 0.99866717124832526942 },
	{ 0.99875453570763483846, 0.00047021217644173564235, 0.99866729915512453264 },
	{ 0.99875466247002497866, 0.00047016231834847392731, 0.99866744064224588495 },
	{ 0.99875481231133345084, 0.00047010830223519260804, 0.9986675849903904334 },
	{ 0.99875496356408000054, 0.00047006462395150116129, 0.99866776241196020258 },
	{ 0.9987550759641348197, 0.00047001001656014375352, 0.9986678801907381553 },
	{ 0.99875522773186531378, 0.00046996174156624728746, 0.99866803565872508397 },
	{ 0.99875535260598025111, 0.00046991052925545622517, 0.99866817544830621678 },
	{ 0.99875547564904043618, 0.00046985534965950890044, 0.99866829742325124997 },
	{ 0.99875562507073223362, 0.00046981380760628623124, 0.99866847759140309204 },
	{ 0.99875577014366923034, 0.00046976204216439169459, 0.99866862785232834998 },
	{ 0.99875587054650105667, 0.00046970375359017292865, 0.99866872398269934674 },
	{ 0.99875602242867256297, 0.00046965750038582723506, 0.99866889013183879342 },
	{ 0.99875615636269354791, 0.0004696075659986201291, 0.99866903634918491317 },
	{ 0.99875626618782764599, 0.00046955335915047563067, 0.9986691515911892969 },
	{ 0.99875642051140534061, 0.00046950634300667678676, 0.99866932117355600163 },
	{ 0.99875657212654811445, 0.00046945860207039746088, 0.9986694783200098513 },
	{ 0.99875669536034328289, 0.00046940468132454781251, 0.99866960491073852868 },
	{ 0.99875681962410667314, 0.00046935293495613955583, 0.99866974153412113591 },
	{ 0.99875695741097192393, 0.00046930425941903012622, 0.99866989244354475996 },
	{ 0.99875708648125383071, 0.00046925167381722343671, 0.99867002353561606931 },
	{ 0.99875722281853418494, 0.00046920109093148123971, 0.99867016872299385621 },
	{ 0.99875735591332170937, 0.00046915329277474291129, 0.99867031921280091655 },
	{ 0.99875751101891252492, 0.00046910560905892258795, 0.99867048332107721809 },
	{ 0.99875763232628556043, 0.00046905449211556319656, 0.99867062110794235785 },
	{ 0.9987577483312293225, 0.00046899853050667644153, 0.99867073299301312161 },
	{ 0.99875789531151493161, 0.00046895263969857093472, 0.99867089599502723019 },
	{ 0.99875801299492539265, 0.00046889942467171548835, 0.99867102054489287344 },
	{ 0.99875814122597394995, 0.00046884832680184243114, 0.99867115728271627084 },
	{ 0.99875831565300632331, 0.00046880173027474283075, 0.99867133735550062124 },
	{ 0.99875840804497406644, 0.00046874748527962566396, 0.9986714411915601497 },
	{ 0.99875857770363485333, 0.00046870058357674482512, 0.99867161710632468274 },
	{ 0.99875868831078207233, 0.00046865085899788734092, 0.99867174861801288888 },
	{ 0.99875883300224921335, 0.00046860260307747715483, 0.99867190574539310699 },
	{ 0.99875896117607732005, 0.00046855011284310213622, 0.99867203880203370137 },
	{ 0.99875910342613838377, 0.00046849781334359040519, 0.99867217716110356918 },
	{ 0.99875923213402406642, 0.00046844616234261381941, 0.99867231456649896426 },
	{ 0.99875935822884220894, 0.00046840051948983060272, 0.99867246881378279877 },
	{ 0.99875948708931583386, 0.00046834856331307272428, 0.99867260209930519554 },
	{ 0.99875963090340258432, 0.00046829706489998675772, 0.99867274560821617246 },
	{ 0.99875975602547295562, 0.000468246405720299224, 0.99867288171661450225 },
	{ 0.99875987153450618283, 0.00046819254219490857817, 0.99867300210846010611 },
	{ 0.99876002133766761393, 0.00046814733803231093918, 0.99867316900146529957 },
	{ 0.99876014510552024728, 0.00046809410393196910442, 0.9986732952870182034 },
	{ 0.99876029931465715173, 0.0004680483084912952685, 0.99867346639526388685 },
	{ 0.99876040427605239369, 0.00046799499809700815123, 0.99867358341110246123 },
	{ 0.99876055909554084522, 0.00046794664680916629425, 0.99867374154937760267 },
	{ 0.99876069976250247962, 0.00046789779961067996545, 0.99867389133346562424 },
	{ 0.99876082147041878034, 0.00046784948646981083104, 0.9986740323818968923 },
	{ 0.99876092753807610425, 0.00046779384911019159443, 0.99867414447677604894 },
	{ 0.99876109454552219891, 0.00046774799644905881019, 0.99867431911361681518 },
	{ 0.9987612016622213762, 0.00046769336998421501403, 0.99867443416488632657 },
	{ 0.99876133658806354187, 0.00046764595329720326077, 0.9986745827473446635 },
	{ 0.99876146218697103851, 0.00046759271919686142601, 0.99867471063507029516 },
	{ 0.99876158875862619535, 0.00046754457771736919079, 0.99867485780609066559 },
	{ 0.99876172839561960792, 0.00046749321281868756349, 0.998674997938994502 },
	{ 0.99876188784996522418, 0.00046744545280892195764, 0.99867516044509796469 },
	{ 0.99876197911659736484, 0.00046738996803719344867, 0.99867526147735485864 },
	{ 0.99876212203423031522, 0.00046734321892220322906, 0.99867541976821772032 },
	{ 0.99876225730339518449, 0.00046729156792122664328, 0.99867555381667938441 },
	{ 0.9987624187413834953, 0.00046724670708138285689, 0.99867573234451134656 },
	{ 0.99876254981438150615, 0.00046719772636849218883, 0.99867587928664980357 },
	{ 0.99876266761223297941, 0.00046714340507942968533, 0.99867599586379818266 },
	{ 0.99876280951897122851, 0.00046709854423958595314, 0.99867615974319268179 },
	{ 0.9987629116956373565, 0.00046704244911629491308, 0.99867626397979547548 },
	{ 0.99876307206551029338, 0.00046699529945809178412, 0.99867643075835987876 },
	{ 0.99876318684975107232, 0.00046694254219490814121, 0.99867655530822552201 },
	{ 0.99876334287086920849, 0.00046689852058846284186, 0.99867672399413853768 },
	{ 0.99876345881859263098, 0.00046684498131233976865, 0.99867685012710338821 },
	{ 0.99876360579887824009, 0.000466796877979820256, 0.99867700443160778434 },
	{ 0.99876371459404422737, 0.00046674484550911709505, 0.99867712482345327718 },
	{ 0.99876385802666134417, 0.00046669784843880453111, 0.998677282904507857 },
	{ 0.99876399613777577802, 0.00046664392769295493695, 0.99867741628539752341 },
	{ 0.99876414994636952827, 0.0004666024237867049361, 0.998677594508053601 },
	{ 0.99876425467888307885, 0.0004665457564588240875, 0.99867769748580625944 },
	{ 0.99876438544670542719, 0.00046649708092171465789, 0.99867784290206607078 },
	{ 0.99876451592842530047, 0.00046644575417000564473, 0.99867797677886660512 },
	{ 0.99876467187324946551, 0.00046640211403328692055, 0.99867815408599536209 },
	{ 0.99876476556221416292, 0.00046634199440438066971, 0.99867823984038983642 },
	{ 0.99876492410103234754, 0.0004662957602735212561, 0.99867840845000888095 },
	{ 0.99876506112495810896, 0.00046625150978524000081, 0.99867856988799708073 },
	{ 0.99876517720619584217, 0.00046619585335213453844, 0.99867868039977669703 },
	{ 0.998765336965717343, 0.00046615053474861889438, 0.99867885236632936152 },
	{ 0.99876546136299504397, 0.0004661011344190289828, 0.99867898866546267467 },
	{ 0.99876556931892779279, 0.00046604887306648986591, 0.99867910730254760843 },
	{ 0.9987657088224066726, 0.00046599924385506405261, 0.99867925702941506838 },
	{ 0.99876586644569753659, 0.00046594995796639220031, 0.99867941465270593238 },
	{ 0.99876598096290958306, 0.00046590196907479058432, 0.99867954641234946145 },
	{ 0.99876609395424265081, 0.00046584848701912651365, 0.99867966382873130105 },
	{ 0.99876625131050478235, 0.00046580328285652882045, 0.99867983568084306434 },
	{ 0.99876636550346731269, 0.0004657510787244487061, 0.99867996063125197281 },
	{ 0.99876648135582313248, 0.0004656996184583354079, 0.99868008525741147619 },
	{ 0.99876663550773958633, 0.00046565349876839399936, 0.99868024909865893424 },
	{ 0.99876674510399177098, 0.00046559967338997596768, 0.99868036579024832555 },
	{ 0.99876687045494383366, 0.00046554863274056185879, 0.99868049465072183946 },
	{ 0.99876701861778549585, 0.00046550331413704616051, 0.99868065959823137945 },
	{ 0.99876716250816621745, 0.00046545494377571802356, 0.99868081142318243515 },
	{ 0.9987672675649289511, 0.00046539932548958522955, 0.99868092243087291937 },
	{ 0.99876739148536952673, 0.00046535169899422390875, 0.99868106367003905977 },
	{ 0.9987675387326838683, 0.00046530180275398947114, 0.99868121061217762779 },
	{ 0.99876767218986750585, 0.0004652527266736671864, 0.99868135440719096874 },
	{ 0.99876783500114674208, 0.00046521229088265157433, 0.99868153797042336084 },
	{ 0.99876795493522874114, 0.00046515705406624530127, 0.99868165790450524888 },
	{ 0.99876808415809859021, 0.00046510633766609876501, 0.99868179231536324814 },
	{ 0.99876819829384078098, 0.00046505811989266119307, 0.99868192720305848376 },
	{ 0.99876834222236854366, 0.00046500635445076665643, 0.99868207227599536946 },
	{ 0.99876844647804485788, 0.0004649510031934423783, 0.99868217737090492214 },
	{ 0.99876859439293130816, 0.0004649078017469091776, 0.99868234355819129888 },
	{ 0.99876873927513343254, 0.00046485920250374513892, 0.99868249210250281678 },
	{ 0.99876884524742348681, 0.00046480663597542478359, 0.99868261134993929762 },
	{ 0.99876897658745034114, 0.00046475693047005368777, 0.99868275222670921387 },
	{ 0.99876909781852929449, 0.00046470726311165520611, 0.99868288169753427486 },
	{ 0.9987692387334461408, 0.00046465896904427240587, 0.99868303481948250688 },
	{ 0.99876938416877925064, 0.00046460924446541503009, 0.99868317903411241154 },
	{ 0.99876953175941662888, 0.00046456320106941890406, 0.99868334340941755656 },
	{ 0.99876962968269544785, 0.00046450807869393063608, 0.99868344522368757143 },
	{ 0.99876975854316896175, 0.00046445871651131344707, 0.99868358735930751191 },
	{ 0.99876990411201649334, 0.00046441568672615719977, 0.99868375245940510521 },
	{ 0.99877002927223368367, 0.00046436308205086423029, 0.99868387945067704781 },
	{ 0.99877016751686253926, 0.00046431272804695793502, 0.99868401891600910858 },
	{ 0.99877029139915618483, 0.00046426243126351064228, 0.99868415317427927658 },
	{ 0.9987704387990585797, 0.0004642163497205419021, 0.99868431033980653577 },
	{ 0.99877055900016953327, 0.00046416542351204579829, 0.99868443878066337493 },
	{ 0.9987706885472885654, 0.00046411644279915513023, 0.99868458175551677591 },
	{ 0.99877079959312586865, 0.00046406437218147935514, 0.99868470416915189336 },
	{ 0.99877094821373124667, 0.00046401890099007314606, 0.9986848631657337938 },
	{ 0.99877107608238346881, 0.000463967326283041897, 0.99868499164473756302 },
	{ 0.99877121413627756308, 0.00046391876518685052667, 0.99868513831984728757 },
	{ 0.99877133529106276733, 0.0004638684111829442314, 0.9986852698506087922 },
	{ 0.99877150069633624518, 0.00046382751762825670744, 0.99868545966994459739 },
	{ 0.99877159030357498537, 0.00046376873314339346968, 0.99868554584395585749 },
	{ 0.99877174128929280261, 0.00046372669517952627444, 0.99868572063338445499 },
	{ 0.99877184718528877472, 0.0004636696273084325165, 0.99868582042586484526 },
	{ 0.99877197268882866865, 0.00046361934959847150373, 0.99868595157515682725 },
	{ 0.99877212794700731546, 0.00046357471764046372749, 0.99868612071883355874 },
	{ 0.99877227218071096271, 0.00046353012382942856539, 0.99868628333937781161 },
	{ 0.99877238185325722952, 0.00046347721397835430325, 0.99868639774214873484 },
	{ 0.99877252116600123699, 0.0004634282332654636352, 0.9986865404118264733 },
	{ 0.99877264468589876945, 0.00046337826073128391509, 0.9986866752232278488 },
	{ 0.99877278308311545629, 0.00046333050072151830924, 0.99868682491194848971 },
	{ 0.99877290913978666875, 0.00046327757179695776713, 0.9986869489849768966 },
	{ 0.99877304393211452371, 0.00046323162376839331199, 0.99868710109603031633 },
	{ 0.99877315795341581328, 0.00046318176567513154275, 0.99868722915541741081 },
	{ 0.99877330287376486773, 0.00046313366234261197588, 0.99868738155257308353 },
	{ 0.99877340548912141305, 0.000463082621693197867, 0.9986874974430759444 },
	{ 0.99877353907981969439, 0.00046303142845589313889, 0.99868763011824690512 },
	{ 0.99877369212547384425, 0.00046298733055550250282, 0.9986877984226901761 },
	{ 0.99877381137291021407, 0.00046293552696663524361, 0.99868792392623018106 },
	{ 0.99877394076744141493, 0.00046288425743538523299, 0.9986880582035738696 },
	{ 0.99877408423820546179, 0.00046284172356087351172, 0.99868822662245804178 },
	{ 0.99877421340385474924, 0.00046279312431770936462, 0.99868835960280466502 },
	{ 0.99877433925071734677, 0.00046274227440315859753, 0.99868849223982847363 },
	{ 0.99877444121757519291, 0.00046268760979134213301, 0.99868859779250174213 },
	{ 0.99877458392539975041, 0.00046264133751351005103, 0.998688754233236331 },
	{ 0.99877474574485769487, 0.00046259609520393974369, 0.99868892337691306249 },
	{ 0.9987748598615263651, 0.00046254556953865649501, 0.99868904851805684331 },
	{ 0.9987749611226652835, 0.0004624933272596037123, 0.99868916236769667005 },
	{ 0.99877512587944017319, 0.00046244644463020915344, 0.99868932781111696695 },
	{ 0.99877524251380900289, 0.00046239698708016034774, 0.99868945669066400139 },
	{ 0.99877537057319620839, 0.00046234918892342201932, 0.99868959718596428399 },
	{ 0.99877549548545796476, 0.00046229851067024815142, 0.99868972659956889437 },
	{ 0.99877563315788220333, 0.00046225033104378324784, 0.99868987487685156879 },
	{ 0.99877573172965938841, 0.00046220058739143942946, 0.99868999359023036266 },
	{ 0.99877589921394260841, 0.00046215132057625385714, 0.99869014833342484305 },
	{ 0.99877602607170012927, 0.00046210445702034563245, 0.9986902936543170517 },
	{ 0.99877613543907073357, 0.00046205055534798231825, 0.9986904065312089962 },
	{ 0.99877626738944913498, 0.00046200054466682992978, 0.99869054374586940792 },
	{ 0.99877639901557835334, 0.00046195425331551156784, 0.99869068952452522137 },
	{ 0.99877653729835425001, 0.00046190645515877329363, 0.99869083726775031984 },
	{ 0.99877665410438454252, 0.0004618563300367029543, 0.99869096322905404062 },
	{ 0.99877680182853612045, 0.0004618112212415369862, 0.99869112544905513928 },
	{ 0.99877691996971029731, 0.00046175869286018929923, 0.99869124740492665193 },
	{ 0.99877705417075990368, 0.00046171329796272831845, 0.99869140083205054648 },
	{ 0.99877718875327936576, 0.00046166172325569706939, 0.99869153297316370921 },
	{ 0.99877730445304746532, 0.00046161049187141972713, 0.99869165172468943314 },
	{ 0.9987774590245805939, 0.00046156791984993533751, 0.99869182826887870075 },
	{ 0.99877756614127977119, 0.00046151878654915405023, 0.99869195064436688813 },
	{ 0.99877770743766647321, 0.00046146904289681023184, 0.99869209255110513723 },
	{ 0.99877784375587341792, 0.00046142172157723004107, 0.99869224161040071053 },
	{ 0.99877793065467701528, 0.00046136335670906599262, 0.99869232011687036898 },
	{ 0.99877808530250400398, 0.00046132116615730817816, 0.99869249490629885546 },
	{ 0.99877822759071199776, 0.00046127195656258160837, 0.99869263963591303757 },
	{ 0.99877832738319249906, 0.0004612197715039878282, 0.99869275407683089085 },
	{ 0.99877846133628689351, 0.00046117325127083356453, 0.99869289718519860255 },
	{ 0.99877861926475353105, 0.0004611300688977866438, 0.99869306426893877937 },
	{ 0.99877872218528562787, 0.0004610794860120444468, 0.99869318626295722208 },
	{ 0.99877886264243886938, 0.00046103164970833350423, 0.99869333679091121247 },
	{ 0.99877897151389893882, 0.0004609790831800131489, 0.99869344520460734405 },
	{ 0.99877913251319705434, 0.00046093328773933931299, 0.99869361318480132095 },
	{ 0.99877922398963747685, 0.00046088056862312839265, 0.99869371625792136005 },
	{ 0.99877937341132916327, 0.00046083475410896822255, 0.99869387468229875449 },
	{ 0.99877949754157813178, 0.00046078264534431972489, 0.99869399850737183844 },
	{ 0.99877965064445295429, 0.00046074161827522791589, 0.99869417392622561458 },
	{ 0.99877975558677467571, 0.00046069046318489580193, 0.99869429099928475058 },
	{ 0.99877986020484699203, 0.00046063757240730792818, 0.99869439973723006521 },
	{ 0.99878001502433544356, 0.00046059032738167318254, 0.99869455871473866715 },
	{ 0.99878014012733207228, 0.00046054300606209304597, 0.99869469488035755855 },
	{ 0.99878027491965981621, 0.00046049679100471996654, 0.99869484619032455885 },
	{ 0.99878040362754549886, 0.00046044742882210277753, 0.99869497886549540855 },
	{ 0.99878052405753803278, 0.00046039505302864570978, 0.99869510211836387548 },
	{ 0.99878067206779186371, 0.00046035385429817694738, 0.99869527393232870871 },
	{ 0.99878080047050188384, 0.00046030342400032531539, 0.99869540462385697488 },
	{ 0.9987809194509095212, 0.00046025585472542294291, 0.99869554221998724231 },
	{ 0.9987810422841614244, 0.00046020016014534481218, 0.99869564674269217797 },
	{ 0.99878115462699601501, 0.00046015228569466125547, 0.99869578060041919176 },
	{ 0.99878129069724741473, 0.00046010425865608707953, 0.9986959223164224575 },
	{ 0.99878145528236095263, 0.00046006002724129210421, 0.99869609842192175186 },
	{ 0.99878157431998904059, 0.00046001228630501283254, 0.99869623401533591522 },
	{ 0.99878170495429674514, 0.00045996481239754213096, 0.99869637235533226249 },
	{ 0.99878182328620601638, 0.00045991392433601869551, 0.99869649541746585708 },
	{ 0.99878192740836779784, 0.00045986149132210257101, 0.99869660686384620352 },
	{ 0.9987820570890012517, 0.00045981317818123338239, 0.9986967437542575432 },
	{ 0.99878219090858122442, 0.00045976663887459278453, 0.99869689130674776933 },
	{ 0.99878232999244342949, 0.00045972063362556938107, 0.99869703985105928723 },
	{ 0.99878241876044870917, 0.00045966619789558887249, 0.9986971380032199086 },
	{ 0.99878259070792785312, 0.00045962574303108698045, 0.99869732601057470411 },
	{ 0.99878270955482106874, 0.00045957170784431938121, 0.99869743829618862208 },
	{ 0.99878283795753097785, 0.00045952692329842093153, 0.99869759065519736474 },
	{ 0.99878296515861109128, 0.00045947651207405568793, 0.99869771663557449504 },
	{ 0.99878310717979024158, 0.00045943184196907518911, 0.99869787490736405822 },
	{ 0.99878322816291387198, 0.00045937918007332310868, 0.99869799184690855043 },
	{ 0.99878336091437880384, 0.00045933370888191684539, 0.99869814229856856969 },
	{ 0.99878347396293221117, 0.00045928360283333289444, 0.99869826312910436883 },
	{ 0.99878360984244862752, 0.00045923759758430943677, 0.99869841197859154924 },
	{ 0.99878374381461654252, 0.00045919029533821568859, 0.99869855693708764477 },
	{ 0.99878387671866919462, 0.00045914131462532507474, 0.99869869472395289556 },
	{ 0.99878396953025383453, 0.00045908756554085237978, 0.99869879371534697743 },
	{ 0.99878412230887936296, 0.00045904503166634065851, 0.99869896259199497646 },
	{ 0.99878424168983015452, 0.00045898981392342071963, 0.99869907209287966943 },
	{ 0.99878437568107170108, 0.0004589466506238601873, 0.99869923000227300847 },
	{ 0.99878450053611311787, 0.00045889877617317657637, 0.99869936294447259062 },
	{ 0.99878463435569320161, 0.00045885071098762962366, 0.99869950408827135035 },
	{ 0.99878476382651837362, 0.00045880272209602806187, 0.99869964729200666476 },
	{ 0.99878488475242166444, 0.00045875519096809835775, 0.99869977905165008281 },
	{ 0.99878499740043169552, 0.00045870205223518813967, 0.9986998900211933039 },
	{ 0.99878514007010932296, 0.00045865612328011001872, 0.99870004154096858606 },
	{ 0.99878528273978706142, 0.00045861263573128191375, 0.99870020191084152295 },
	{ 0.9987854003659772939, 0.00045856111824470955881, 0.99870032327543489803 },
	{ 0.99878553548255444294, 0.00045851435005623300501, 0.9987004692257521743 },
	{ 0.99878567012229435562, 0.00045846832573372326737, 0.99870061687360978109 },
	{ 0.99878578385749328117, 0.00045841631233650644061, 0.998700731943952702 },
	{ 0.9987859147969769813, 0.00045837101280647713072, 0.99870087837110721463 },
	{ 0.99878603001990773347, 0.00045831762611824467674, 0.99870098993192857328 },
	{ 0.99878614838996382375, 0.00045826898872810791549, 0.99870112005125222243 },
	{ 0.99878631013312779707, 0.00045822565376717037553, 0.9987012915600411711 },
	{ 0.99878641068854767671, 0.00045817484199959222259, 0.99870140310178900922 },
	{ 0.99878653872886125065, 0.00045812698662239494584, 0.99870153968702468639 },
	{ 0.99878664573111952674, 0.00045807575523811754938, 0.9987016547001471567 },
	{ 0.99878678483405514132, 0.00045803064644295152707, 0.99870180677305364636 },
	{ 0.99878691651740469926, 0.00045798166573006085902, 0.99870194028745784554 },
	{ 0.99878705047049920474, 0.00045793522179085187785, 0.99870208927045955871 },
	{ 0.99878717025199326152, 0.00045788746178108621779, 0.9987022191227544754 },
	{ 0.99878729857840908846, 0.0004578375655408518344, 0.99870235080610392231 },
	{ 0.99878743411460302326, 0.00045779030144173075458, 0.99870249526868926093 },
	{ 0.99878754224219701285, 0.00045773718178230687068, 0.99870260290037260464 },
	{ 0.99878767575660143407, 0.00045769247353035370351, 0.99870275350462034414 },
	{ 0.99878778218665509314, 0.00045764448463875208751, 0.9987028751934630133 },
	{ 0.99878791753211404458, 0.00045759580910164271211, 0.99870301847349229885 },
	{ 0.99878805617728605437, 0.00045755016624885944121, 0.99870316596876185233 },
	{ 0.99878817586341261947, 0.00045750101387459181975, 0.99870329385648770604 },
	{ 0.99878830071845403626, 0.00045745550453621294231, 0.99870343412290607521 },
	{ 0.99878846242347096851, 0.00045740885078865433939, 0.99870360048185380375 },
	{ 0.99878858586707452982, 0.00045736353218513869532, 0.99870373796354316998 },
	{ 0.99878870942511899234, 0.00045731466591316608655, 0.9987038682354547614 },
	{ 0.99878881486335124862, 0.00045726202309090044872, 0.99870397886167538992 },
	{ 0.99878894441047016972, 0.00045721426308113484287, 0.99870411176572804202 },
	{ 0.99878907683768569647, 0.00045716770470100780242, 0.99870425582777011542 },
	{ 0.99878919360556894791, 0.00045711693108040226362, 0.99870437854658111743 },
	{ 0.99878934861579216076, 0.00045707243263679877242, 0.99870453981290807643 },
	{ 0.99878945100226679266, 0.00045702467262703311236, 0.99870466508756616797 },
	{ 0.99878960112967762885, 0.00045697902977424989567, 0.99870481853376369408 },
	{ 0.99878972274222632688, 0.0004569337111707342516, 0.99870495998273833838 },
	{ 0.99878982606330168892, 0.00045688322365242367128, 0.99870507276426290222 },
	{ 0.99878997193732510507, 0.00045683500587898615355, 0.99870521619688001902 },
	{ 0.99879007577338452251, 0.00045678366005379075201, 0.998705327662333886 },
	{ 0.99879021497168762878, 0.00045674112617927903075, 0.99870548868070530002 },
	{ 0.99879033967414110329, 0.000456688750385821963, 0.99870560933957963634 },
	{ 0.99879047944464882658, 0.00045664541542488447726, 0.99870576131711863432 },
	{ 0.99879058514990992634, 0.00045659494698006017691, 0.99870587907682317752 },
	{ 0.99879072507300548089, 0.00045654932320076329439, 0.99870602785001638679 },
	{ 0.99879083341040764132, 0.00045649652779060698312, 0.99870613801847329949 },
	{ 0.99879096585669668862, 0.00045645319282966949738, 0.99870628999601229747 },
	{ 0.99879108985343112437, 0.0004564010268445620514, 0.99870640724073256322 },
	{ 0.99879125482001429592, 0.00045636198341804834651, 0.99870659372220826899 },
	{ 0.99879137259879235966, 0.00045631305992561668099, 0.99870672046552488865 },
	{ 0.99879148456015698354, 0.00045626304924446429252, 0.99870683799634751843 },
	{ 0.9987915965596686485, 0.00045621025383430798125, 0.9987069487751559782 },
	{ 0.99879174796500302946, 0.0004561697036023743641, 0.99870712261091032502 },
	{ 0.99879185630240530092, 0.00045612179100471808482, 0.99870724803815624782 },
	{ 0.99879196288504690227, 0.00045606663048225709427, 0.99870734897504587213 },
	{ 0.99879211392798517011, 0.00045602262794929807489, 0.99870750718961487369 },
	{ 0.99879222272315093534, 0.00045597242653328239883, 0.99870762361417519948 },
	{ 0.99879235556998313683, 0.00045592727959114370817, 0.99870777240644192929 },
	{ 0.99879245444693620648, 0.00045587478935676868956, 0.99870787616620737559 },
	{ 0.9987926152364258181, 0.00045583362877327259551, 0.99870804786573130762 },
	{ 0.99879273654379885361, 0.00045578434288460068901, 0.99870817619214724559 },
	{ 0.99879287219443346757, 0.00045573536217171007516, 0.99870831184278185955 },
	{ 0.99879298674979222206, 0.00045568573296028431607, 0.99870843372235940105 },
	{ 0.99879310401358623039, 0.00045563957512337023917, 0.99870856899152427033 },
	{ 0.99879322036185269607, 0.00045559128105598743893, 0.99870869434247633301 },
	{ 0.99879336638846394347, 0.00045554718315559685708, 0.99870884952436089765 },
	{ 0.99879350140967360083, 0.00045549909889656362439, 0.9987089883221207387 },
	{ 0.99879363467612258809, 0.00045545540153938589767, 0.99870914310346214915 },
	{ 0.99879372611441596952, 0.0004554009658094054433, 0.99870923156629154427 },
	{ 0.99879386556067450975, 0.00045535440742927845706, 0.99870937646756696715 },
	{ 0.9987940117208001789, 0.00045531372368294050065, 0.9987095467747263422 },
	{ 0.99879412875571205177, 0.00045526504814583107104, 0.9987096732700875279 },
	{ 0.99879425446906022756, 0.00045521490395027434332, 0.99870979818234950631 },
	{ 0.99879437417426042423, 0.0004551679831739071703, 0.99870993177304767663 },
	{ 0.99879448409476190296, 0.00045512024223762789863, 0.99871005321393513388 },
	{ 0.99879462615408798332, 0.00045507156670051846902, 0.99871019252667914134 },
	{ 0.99879475280203711129, 0.00045502548515754967463, 0.99871033382306573234 },
	{ 0.9987948894826400581, 0.00045497852623420983326, 0.99871047920117839158 },
	{ 0.99879499972739094193, 0.00045492687523323324748, 0.99871058654675926025 },
	{ 0.99879512782492518852, 0.00045488056480842860557, 0.99871072898755519631 },
	{ 0.99879526532568829733, 0.00045483965218025474743, 0.99871088720212430889 },
	{ 0.99879536431708215716, 0.00045478575050789148745, 0.99871098779569100756 },
	{ 0.99879551827826362764, 0.00045474348366218833627, 0.99871115487943107336 },
	{ 0.9987956450406535458, 0.00045469332039314527437, 0.99871128095517558432 },
	{ 0.99879572371878455606, 0.00045464180290657291942, 0.99871137493024264575 },
	{ 0.99879584834494428147, 0.00045459598839241274933, 0.99871151458630946784 },
	{ 0.99879598334708030727, 0.00045455002129036196001, 0.99871165454755206348 },
	{ 0.99879612891592783885, 0.00045450332939583068873, 0.99871180499921208273 },
	{ 0.99879623259939931401, 0.00045444969475227594462, 0.99871190700421696995 },
	{ 0.99879637771048346284, 0.00045440712273079160921, 0.9987120692051446591 },
	{ 0.99879649657645031002, 0.0004543596678968071876, 0.99871219447980286166 },
	{ 0.99879664990820682391, 0.00045431936562019586056, 0.99871237069974305722 },
	{ 0.99879676274695194937, 0.00045426710426765679789, 0.99871247560391773757 },
	{ 0.9987968898526649042, 0.00045421934425789113783, 0.99871261552701351416 },
	{ 0.99879700063147358602, 0.00045417143166023491276, 0.99871274095425954798 },
	{ 0.99879715527930079677, 0.0004541280204053520903, 0.99871289880643232539 },
	{ 0.99879726920523459466, 0.00045407871544319384962, 0.99871301792035427347 },
	{ 0.99879739539542011784, 0.00045403309166389696711, 0.99871316120038344799 },
	{ 0.99879751822867224309, 0.00045398838341194379994, 0.99871329990277590838 },
	{ 0.99879762978949382379, 0.00045393522560554724768, 0.99871340577969847097 },
	{ 0.99879774690070000087, 0.00045388861000496131311, 0.99871353891263292546 },
	{ 0.99879787867941693946, 0.00045383938133674835494, 0.99871366855511922722 },
	{ 0.99879800261893114666, 0.00045379173576790069996, 0.99871380172620061177 },
	{ 0.99879812581457927401, 0.00045374689400154330195, 0.99871393766293758976 },
	{ 0.99879826997198883909, 0.00045370329201179719191, 0.9987140960873149842 },
	{ 0.99879837327399079161, 0.00045365339577156280852, 0.99871420762906293334 },
	{ 0.99879849580206681026, 0.00045360288917976589402, 0.99871432680020533201 },
	{ 0.99879864304938115183, 0.00045355909645515649639, 0.99871448350796898641 },
	{ 0.99879875079550528572, 0.00045351208031135765248, 0.99871461082349011207 },
	{ 0.99879888274588368713, 0.00045346657097297872084, 0.99871475276837529123 },
	{ 0.99879899634756819093, 0.0004534152251477833735, 0.99871486667523545755 },
	{ 0.99879914864935659402, 0.00045337385475593760349, 0.99871503419766571863 },
	{ 0.99879926093497073403, 0.00045332573234993170245, 0.99871515636334573518 },
	{ 0.99879936530508794945, 0.00045327629387336917672, 0.9987152753819003026 },
	{ 0.9987995037595250869, 0.00045323057472664062331, 0.99871541917691375456 },
	{ 0.99879964005865851107, 0.00045318338692146488021, 0.99871555242428911026 },
	{ 0.99879976758398814063, 0.00045314001381355472611, 0.99871570299039014174 },
	{ 0.99879987847723772365, 0.00045308893501716794886, 0.99871581380734564259 },
	{ 0.99879999082007220323, 0.00045304113686042962045, 0.99871593919644463533 },
	{ 0.99880012557425312814, 0.00045299507439094726866, 0.99871608119855026509 },
	{ 0.99880024428763203304, 0.00045294777214485352048, 0.99871620967755403431 },
	{ 0.99880038924612812856, 0.00045290230095344725719, 0.99871635951886261751 },
	{ 0.99880051211752707285, 0.00045285625755745118537, 0.99871649330029577118 },
	{ 0.99880058186926667929, 0.00045280088722664068148, 0.99871656930813879072 },
	{ 0.99880076299109288307, 0.00045276686012703129362, 0.99871677942166403597 },
	{ 0.99880088391699628492, 0.00045271475136238285017, 0.99871689058194224042 },
	{ 0.99880099919714770973, 0.00045266798317390624217, 0.99871702005276730141 },
	{ 0.99880111607947197339, 0.0004526176291700000011, 0.9987171381557945482 },
	{ 0.99880123872198911528, 0.00045256960213142577096, 0.99871726468930277498 },
	{ 0.99880136773505068248, 0.0004525261908765429485, 0.99871741445431727602 },
	{ 0.99880147923865170156, 0.00045247618019539056003, 0.99871753084073078277 },
	{ 0.99880163136877864183, 0.0004524360495801561864, 0.9987177015865803531 },
	{ 0.99880174302496749217, 0.0004523839789624803571, 0.99871780507931706694 },
	{ 0.99880186128058279227, 0.00045233866035896471303, 0.9987179398144244713 },
	{ 0.99880198085226867821, 0.00045228954613166981414, 0.99871806232342696941 },
	{ 0.99880213229575021128, 0.00045224460899788074524, 0.998718219717836031 },
	{ 0.9988022353688703614, 0.00045219662010627918345, 0.99871833438763568669 },
	{ 0.99880237548270101033, 0.00045215095818000968679, 0.99871848068127577758 },
	{ 0.99880244975485676928, 0.00045209621727424793977, 0.99871855838665901661 },
	{ 0.99880258571066737883, 0.00045205364525276355014, 0.9987187129581921452 },
	{ 0.99880274348654629613, 0.00045201488792854474952, 0.99871888843426626092 },
	{ 0.99880285800375823158, 0.00045196506798225564864, 0.99871900737652696822 },
	{ 0.99880299151816254177, 0.00045191944420295871191, 0.99871914852032583898 },
	{ 0.99880308947958840182, 0.00045186970055061494774, 0.99871925502667346919 },
	{ 0.99880323512472979353, 0.0004518270522351852214, 0.99871941287884624661 },
	{ 0.99880334475912901926, 0.00045177463829475548529, 0.99871952388653661981 },
	{ 0.99880347487845277943, 0.00045173408806282186814, 0.99871967719921961315 },
	{ 0.99880356822409488426, 0.00045167652428108358417, 0.99871975788006672747 },
	{ 0.9988037097493634997, 0.00045163418114143509628, 0.99871991634259094095 },
	{ 0.99880385859885090216, 0.00045159244835334913949, 0.99872007724652145377 },
	{ 0.99880395751395101289, 0.00045154205620247023006, 0.99872018607983426008 },
	{ 0.99880411162772053668, 0.00045150024712043893655, 0.9987203505695803063 },
	{ 0.99880421008505715363, 0.00045144794762092720552, 0.99872044864544706755 },
	{ 0.99880433387198341855, 0.00045140472710090767065, 0.9987205948627931873 },
	{ 0.99880445495047465165, 0.0004513507872815716881, 0.9987206985462648845 },
	{ 0.99880457358755969643, 0.00045130737602668886564, 0.99872083885083029475 },
	{ 0.99880472968497191477, 0.00045126571953254824556, 0.99872100623974624511 },
	{ 0.99880484206595332441, 0.00045121650993782167578, 0.99872112335095220015 },
	{ 0.99880497405447876691, 0.00045117210686164980126, 0.99872126754650880631 },
	{ 0.99880507621207159641, 0.00045112335503059514336, 0.99872138419995104552 },
	{ 0.99880522971548957312, 0.00045108032524543889607, 0.99872154441723604013 },
	{ 0.99880531348624146393, 0.00045103012382942322001, 0.99872163978466754752 },
	{ 0.99880547309317513349, 0.00045098892509895445761, 0.9987218048847650298 },
	{ 0.99880556373038198448, 0.00045093368828254818455, 0.99872189247021414538 },
	{ 0.99880568438925654284, 0.00045088405907112237125, 0.99872201221356105005 },
	{ 0.99880580771841920296, 0.00045084060966926688043, 0.99872215629467664399 },
	{ 0.99880593329825329008, 0.00045079529106575123637, 0.99872229713329963019 },
	{ 0.99880606206335942332, 0.00045074903786140554278, 0.99872243188748033305 },
	{ 0.99880617520728032233, 0.00045070211708503836977, 0.998722555712553417 },
	{ 0.99880631429114274944, 0.00045065809547859307042, 0.9987227063930954607 },
	{ 0.9988064255086414045, 0.00045060669243293872055, 0.99872281135449059164 },
	{ 0.99880656543173718109, 0.00045056473076301686203, 0.99872296775707836147 },
	{ 0.99880666385092675696, 0.00045051819145637620996, 0.99872308631786921307 },
	{ 0.99880681281485506062, 0.00045047222435432542065, 0.998723233755918538 },
	{ 0.99880690482535305907, 0.0004504195815320597286, 0.99872332790264695124 },
	{ 0.99880704394736252727, 0.00045037842094856358035, 0.99872348518261522266 },
	{ 0.9988071722928520968, 0.00045032938301521390975, 0.99872361245998941826 },
	{ 0.99880731112875908995, 0.00045028869926887600756, 0.99872377136120382701 },
	{ 0.99880743607916799842, 0.0004502438956494912237, 0.9987239100063758368 },
	{ 0.99880754697241769247, 0.00045019274055915910974, 0.99872401990780401704 },
	{ 0.99880764569678281983, 0.00045014345467048720324, 0.99872412778744257267 },
	{ 0.99880777762808770071, 0.00045009666740852426105, 0.99872426399120850515 },
	{ 0.99880792159476239345, 0.00045005371391731329627, 0.99872441467175043783 },
	{ 0.99880804152884439251, 0.00045000702202278207919, 0.99872454620251205348 },
	{ 0.99880813729681927615, 0.00044995962440925671433, 0.99872465711483504602 },
	{ 0.99880829202094034702, 0.00044991415321785045104, 0.99872481244930755295 },
	{ 0.99880840424933403643, 0.00044987135231453010548, 0.99872494741329675971 },
	{ 0.99880849839606256069, 0.00044981993019538942143, 0.99872504156002506193 },
	{ 0.99880865834631893385, 0.00044977625191169802888, 0.99872520746120907464 },
	{ 0.99880878331580136287, 0.00044973184883552615437, 0.99872534463772255631 },
	{ 0.99880887059607481593, 0.00044967996895271361265, 0.99872543680080838602 },
	{ 0.99880900449194887081, 0.00044963365852790891652, 0.99872557634243430691 },
	{ 0.99880912503638252797, 0.00044958879768806513013, 0.99872571153530531607 },
	{ 0.99880926034369466038, 0.00044954794228035032874, 0.99872586744198244002 },
	{ 0.99880936683096877005, 0.00044949432671028191882, 0.998725963972896702 },
	{ 0.99880949206748004254, 0.00044945308983284043385, 0.99872611240276720768 },
	{ 0.9988096186391353104, 0.00044940326988655138717, 0.99872623439678565038 },
	{ 0.99880973529257777166, 0.00044935695946174663683, 0.99872636203655607012 },
	{ 0.99880986804404259249, 0.00044931270897346538154, 0.99872650760540382375 },
	{ 0.99881002208151814514, 0.00044927036583381694786, 0.99872666820415845201 },
	{ 0.99881013841071131232, 0.00044922445595222510687, 0.99872679441341738471 },
	{ 0.99881023099341403881, 0.00044917345344978372055, 0.998726895922511404 },
	{ 0.99881037122168558895, 0.00044912874519783060759, 0.99872704164394687787 },
	{ 0.99881047173895853852, 0.00044907865822273282819, 0.99872714948543839242 },
	{ 0.99881060662665377414, 0.00044904020607429532023, 0.99872731000789927158 },
	{ 0.99881074502387057201, 0.00044899214088874842173, 0.99872744321712758619 },
	{ 0.998810889963293147, 0.00044895092308479332514, 0.99872760249981185066 },
	{ 0.99881099040427234748, 0.00044890129387336751184, 0.99872771194347631507 },
	{ 0.99881110362448721762, 0.00044885093986946121656, 0.99872782211193322777 },
	{ 0.9988112377492430749, 0.00044880775749641429583, 0.99872797180065386868 },
	{ 0.99881133164801627622, 0.00044875715553718571044, 0.99872807081112136007 },
	{ 0.99881144812979716363, 0.00044871071159797672927, 0.99872819484600294793 },
	{ 0.99881160266318336216, 0.00044866535484748841685, 0.99872834854015579698 },
	{ 0.99881169017233861762, 0.00044861767113166809351, 0.99872845542797306084 },
	{ 0.99881181106009486736, 0.00044857078850227353464, 0.9987285797489569017 },
	{ 0.99881194518485072464, 0.00044852791130500790657, 0.99872872791179867491 },
	{ 0.99881204337515838709, 0.00044847809135871885989, 0.99872883251079769273 },
	{ 0.99881217208304418076, 0.00044843056023078920998, 0.99872896564373214723 },
	{ 0.99881232072272319034, 0.00044839136421638488587, 0.99872913003811070176 },
	{ 0.99881243264594099518, 0.00044834261238533017375, 0.99872924653896510971 },
	{ 0.99881257941641821141, 0.00044830280601936331854, 0.99872941100963752437 },
	{ 0.99881265433707255852, 0.00044824985802131638805, 0.99872949325451043645 },
	{ 0.99881279935278910465, 0.00044820677101570119243, 0.99872964334377445361 },
	{ 0.99881290097632424718, 0.00044815580666023242026, 0.99872974618801269031 },
	{ 0.99881303784766217735, 0.00044811201393562302264, 0.99872989435085446353 },
	{ 0.99881317834296245994, 0.0004480671912427519046, 0.99873003827938211519 },
	{ 0.99881328111090683652, 0.00044801843941169724669, 0.99873014730342990486 },
	{ 0.99881340722479849958, 0.00044797579109626757456, 0.9987302923382198605 },
	{ 0.99881353677191764273, 0.00044793077766853316895, 0.998730431650963979 },
	{ 0.99881367371954943302, 0.0004478861457105253927, 0.99873057729610548172 },
	{ 0.9988137934438230392, 0.00044784103691535931619, 0.99873070632824034742 },
	{ 0.9988138883534909418, 0.0004477937346692655138, 0.99873081771740024326 },
	{ 0.99881398797431020231, 0.00044774298012214630918, 0.9987309147442250401 },
	{ 0.99881415536322615267, 0.00044770315468269311979, 0.99873109495052381224 },
	{ 0.99881427289404889347, 0.00044765672981697041859, 0.99873121965297728675 },
	{ 0.99881437428870212258, 0.0004476081305738063257, 0.99873132837184908084 },
	{ 0.99881451600470549934, 0.0004475652915235134202, 0.99873147992977129306 },
	{ 0.99881460618414885655, 0.00044751570045906027525, 0.99873158201107004039 },
	{ 0.99881475564398769507, 0.00044747244179206807201, 0.99873173665889714012 },
	{ 0.99881487725653650411, 0.00044742498695808370461, 0.9987318613232037956 },
	{ 0.99881498481192576566, 0.00044737938225227315628, 0.99873198177226985006 },
	{ 0.99881509658255573925, 0.00044733063042121844416, 0.99873209384807537514 },
	{ 0.99881521697440145413, 0.0004472865325208278081, 0.99873223194011628845 },
	{ 0.99881535977759361433, 0.00044724222481208755027, 0.99873238096126493168 },
	{ 0.99881545491614343035, 0.00044719469368415790036, 0.99873248571285178077 },
	{ 0.99881559632697103357, 0.00044714887916999773027, 0.99873262842067644929 },
	{ 0.99881572362341886073, 0.00044710428535896256817, 0.99873276609310068785 },
	{ 0.99881583905615800578, 0.00044705995857673597616, 0.99873289693721678528 },
	{ 0.99881593150534631054, 0.00044701134026008554909, 0.99873300411113641317 },
	{ 0.99881607114233983413, 0.00044696634590583747765, 0.99873314454921613414 },
	{ 0.9988161988965512661, 0.00044691969215827882051, 0.9987332757366550462 },
	{ 0.99881630126395237745, 0.00044687218010383550479, 0.99873338577159764817 },
	{ 0.99881643664755836998, 0.00044682567894416752108, 0.99873352138408533207 },
	{ 0.99881654174246825573, 0.0004467817717786401726, 0.9987336497486482001 },
	{ 0.99881667203345325667, 0.00044673696815925538874, 0.99873378663905942876 },
	{ 0.99881682790198367261, 0.00044669462501960690085, 0.99873394571193530034 },
	{ 0.99881695138373427501, 0.00044665170967536865863, 0.99873408727535073481 },
	{ 0.99881703723349613, 0.00044659767448860105939, 0.99873416911968027065 },
	{ 0.99881715480246591188, 0.00044655578911262448338, 0.99873430881389413383 },
	{ 0.99881731740393686625, 0.00044651228249030999002, 0.99873446946986932371 },
	{ 0.99881742032446907409, 0.00044646261513191156257, 0.99873457513698349342 },
	{ 0.99881754027762459369, 0.00044642040550666741393, 0.99873471576579819775 },
	{ 0.9988176712743286334, 0.00044637638390022211458, 0.99873485500224823408 },
	{ 0.99881775300421749009, 0.00044632372200447014256, 0.99873494031795240211 },
	{ 0.99881789231696160858, 0.00044628267586189194517, 0.99873509305843077843 },
	{ 0.99881801494040522993, 0.00044623482048469466843, 0.99873521720775315647 },
	{ 0.99881814242758781841, 0.00044619018852668689218, 0.99873535461314855155 },
	{ 0.99881826024451281221, 0.00044614530861335682582, 0.99873548040279080951 },
	{ 0.99881839169898067876, 0.00044609960854011460659, 0.99873561628230733689 },
	{ 0.99881849339880968142, 0.00044605345070320052969, 0.99873573400386472798 },
	{ 0.99881863103308710095, 0.0004460085898633567433, 0.99873587407954822481 },
	{ 0.99881873576560065153, 0.00044596134483772199766, 0.9987359889210092323 },
	{ 0.99881886382498785704, 0.00044591797172981178935, 0.99873612903483977021 },
	{ 0.99881897214331660795, 0.00044587145149665747147, 0.99873624685176476401 },
	{ 0.99881909715094596702, 0.00044582632362800511498, 0.99873637796290970492 },
	{ 0.99881922151007684896, 0.00044577795326667697803, 0.99873650232204047583 },
	{ 0.9988193421117308457, 0.00044573631584602263793, 0.99873664577373100215 },
	{ 0.99881946614661243355, 0.00044568872749763393127, 0.99873676908382014172 },
	{ 0.99881958947577509367, 0.00044564550697761439639, 0.99873690362819256272 },
	{ 0.99881969720282592906, 0.00044559820473152064822, 0.9987370223415713566 },
	{ 0.99881980317511609435, 0.00044555158913093471365, 0.99873714006312908076 },
	{ 0.99881995644965226866, 0.0004455107718701924722, 0.99873730096705959358 },
	{ 0.99882004430213022772, 0.00044546221077400104766, 0.99873740171321434556 },
	{ 0.99882019639411034895, 0.00044541883766609083935, 0.99873755601771874169 },
	{ 0.99882029612937039964, 0.00044536960899787788118, 0.99873765930064706264 },
	{ 0.99882041263022491862, 0.00044532512962776066995, 0.99873778953441161299 },
	{ 0.99882054400839881403, 0.0004452785903211200721, 0.9987379212177610599 },
	{ 0.99882066874899944064, 0.00044523685753303411531, 0.99873806701549039389 },
	{ 0.99882076829352473002, 0.00044518976509528993468, 0.99873817159541578015 },
	{ 0.99882089412131402906, 0.00044514381706672542533, 0.99873830310710387526 },
	{ 0.9988209986821660058, 0.00044509579002815114097, 0.99873841705211086062 },
	{ 0.99882113356986135244, 0.00044505123436408864724, 0.99873855560191548975 },
	{ 0.99882126140036686657, 0.0004450095397229753588, 0.99873870075114612455 },
	{ 0.99882136952796085616, 0.00044496279060798513919, 0.99873882020839099827 },
	{ 0.99882152768530951814, 0.00044492197334724289774, 0.99873898462184318436 },
	{ 0.99882163861670614224, 0.0004448729926343522839, 0.99873909677394279161 },
	{ 0.99882173325934531238, 0.00044482626259284834425, 0.99873920240290992023 },
	{ 0.99882185441413040561, 0.00044478201210456703475, 0.99873933881648402355 },
	{ 0.99882197732367627996, 0.00044473753273444982352, 0.99873946706660599038 },
	{ 0.99882209332862015305, 0.00044468881905036777976, 0.99873958314784339052 },
	{ 0.99882221345343713548, 0.00044464353859382480406, 0.9987397099102334197 },
	{ 0.99882235948004838288, 0.00044460310280280913777, 0.99873986997493058304 },
	{ 0.99882247149863345737, 0.0004445548278089126175, 0.99873998550303721977 },
	{ 0.9988225723783027421, 0.00044450949013191063926, 0.99874010145076053124 },
	{ 0.99882270772376169354, 0.0004444635611768325183, 0.99874023679621926064 },
	{ 0.99882280995764838316, 0.00044441992104011373991, 0.99874036222346529446 },
	{ 0.99882296988883123579, 0.00044438011467414688469, 0.99874053062327605712 },
	{ 0.99882306479849913838, 0.00044432915031867805831, 0.99874062248118611329 },
	{ 0.99882319899954907783, 0.00044428497612434208553, 0.99874076446421822251 },
	{ 0.99882330415167919213, 0.00044423898994880501624, 0.99874087980159009792 },
	{ 0.99882344125189881368, 0.00044419527351814095534, 0.99874102270014952776 },
	{ 0.99882354463019473734, 0.00044415186226325813288, 0.99874114622004694919 },
	{ 0.99882367537894345411, 0.00044410686790901006144, 0.99874128147013840895 },
	{ 0.99882378981986141842, 0.00044405712425666624306, 0.99874139346965007391 },
	{ 0.99882390397467712972, 0.00044401708900886354033, 0.99874153478511018545 },
	{ 0.99882401442923651746, 0.00044396812736945926066, 0.99874164840586809877 },
	{ 0.99882413667121028311, 0.00044392195045905879537, 0.99874177007563713637 },
	{ 0.99882425305762378986, 0.00044387529671150013823, 0.99874188943751451841 },
	{ 0.99882437829413506236, 0.00044383329689460555715, 0.9987420284832296824 },
	{ 0.99882448998847095378, 0.00044378507912116803942, 0.998742148722487455 },
	{ 0.99882462804236493703, 0.00044374323189216407755, 0.99874229371913036957 },
	{ 0.99882473699011886659, 0.00044370020210700783026, 0.99874242158778270273 },
	{ 0.99882486829199879086, 0.00044365648567634376935, 0.99874256540186945319 },
	{ 0.99882496545233823149, 0.00044360571205573823056, 0.99874265767939640615 },
	{ 0.99882510148444259013, 0.00044356306374030850422, 0.99874280515559255011 },
	{ 0.99882520512976735727, 0.00044351534187751556673, 0.99874291627772371349 },
	{ 0.9988253514234076702, 0.0004434737235303475608, 0.99874306737788243193 },
	{ 0.99882547669806598378, 0.00044342809975105062408, 0.99874319845088033176 },
	{ 0.99882556718268511453, 0.00044338400185065998801, 0.99874330816157352864 },
	{ 0.99882568049826736534, 0.000443333933949048597, 0.99874342117197989488 },
	{ 0.99882580426612010971, 0.00044328981697517162676, 0.99874355264552105993 },
	{ 0.99882592671790226824, 0.00044324762642341375809, 0.99874369142420738044 },
	{ 0.99882602467932812829, 0.0004431997138257574788, 0.99874379854090655773 },
	{ 0.99882615315833200853, 0.00044315668404060123151, 0.99874393556483209711 },
	{ 0.99882627416052938152, 0.00044311289131599183389, 0.99874406480677546671 },
	{ 0.99882640357413410293, 0.00044306835472541562012, 0.99874420127757013166 },
	{ 0.99882650626578450836, 0.00044301754295783746717, 0.99874430213816578483 },
	{ 0.99882663817801597972, 0.00044297764122443899527, 0.99874445266611977523 },
	{ 0.99882675458350300701, 0.00044293100655036678074, 0.99874457219965850907 },
	{ 0.99882685990729458414, 0.0004428874045606206707, 0.99874469804652121763 },
	{ 0.99882701295294884503, 0.00044284269630866755774, 0.99874484315760514441 },
	{ 0.99882712151923291888, 0.00044279486000495661517, 0.99874495965845966339 },
	{ 0.99882724343695783453, 0.00044275442421394094888, 0.99874509958155543998 },
	{ 0.99882735642829079126, 0.00044270704567390180978, 0.99874521180994901837 },
	{ 0.99882748652854103089, 0.00044266369163947788144, 0.99874535339243786236 },
	{ 0.99882759707846779929, 0.00044261631309943879654, 0.99874547019846815488 },
	{ 0.9988277216474070741, 0.00044257726967292514587, 0.99874561605341816151 },
	{ 0.99882781979956769547, 0.00044252733528571809411, 0.99874571557886959727 },
	{ 0.99882794925131934693, 0.0004424824935193606419, 0.99874584911234731699 },
	{ 0.99882807998099476521, 0.00044244293510871618522, 0.99874599983103629075 },
	{ 0.99882819335379768866, 0.00044239944755988802605, 0.99874612876780388682 },
	{ 0.99882831046500375471, 0.00044234794914680205949, 0.9987462344349179455 },
	{ 0.99882841670432287451, 0.00044230457603889190539, 0.99874635768778663447 },
	{ 0.99882855140128334881, 0.00044226249992805209601, 0.99874650016672927855 },
	{ 0.99882865806021881028, 0.00044221473991828649016, 0.99874661323435609539 },
	{ 0.99882879361548604358, 0.00044217359840827673029, 0.99874675920374700322 },
	{ 0.99882890008368674373, 0.00044212297737556186493, 0.998746863230541293 },
	{ 0.99882902013220986603, 0.00044207998573737823178, 0.99874699540980160783 },
	{ 0.99882913485923030539, 0.00044203514397102077957, 0.99874712036021062733 },
	{ 0.99882925509848818901, 0.00044198814690070826984, 0.99874723815806221161 },
	{ 0.99882933856406430628, 0.00044194099724250514088, 0.99874733718760322354 },
	{ 0.99882948703208185304, 0.00044190086662727076725, 0.99874749633677306626 },
	{ 0.99882960326590763955, 0.00044185581505256374749, 0.99874761989481741775 },
	{ 0.99882970839896434434, 0.00044181019127326686497, 0.99874773509867464938 },
	{ 0.9988298259679340152, 0.00044176281273322772587, 0.99874785465128690376 },
	{ 0.99882995776572447433, 0.00044172340691047378, 0.99874800918467310229 },
	{ 0.99883008960166197454, 0.00044167946159797376315, 0.99874814102061049148 },
	{ 0.99883020411887379897, 0.00044163528740363779037, 0.99874827094919926829 },
	{ 0.99883029796042654969, 0.00044158691704230965342, 0.99874837211497058398 },
	{ 0.99883043883719657696, 0.00044154545128303226672, 0.99874851962931376903 },
	{ 0.99883058850684380836, 0.00044150446236091312607, 0.99874867765314789825 },
	{ 0.99883067626395438676, 0.00044145527183967289047, 0.99874876872904516656 },
	{ 0.99883079648413874985, 0.0004414088279004639093, 0.99874889108545983341 },
	{ 0.99883088601508362991, 0.00044135881721931157504, 0.99874898496515940316 },
	{ 0.99883103520789384699, 0.00044132299721198742486, 0.99874915582544998571 },
	{ 0.99883114768424274832, 0.00044127754509406749575, 0.99874927753336617542 },
	{ 0.99883126918235076719, 0.00044123409569221205915, 0.99874940780527765583 },
	{ 0.99883137702384250378, 0.00044118591606574726399, 0.99874951732523609138 },
	{ 0.99883146563926017425, 0.00044113506615119644268, 0.99874960723765071613 },
	{ 0.99883161807456299908, 0.0004410976821179933235, 0.99874977950937937621 },
	{ 0.99883175464072526673, 0.00044105511009650893387, 0.99874992370493609339 },
	{ 0.99883187381186799847, 0.00044101314842658702114, 0.99875005172617647986 },
	{ 0.99883197591224037737, 0.00044096552193122570034, 0.99875016157038409848 },
	{ 0.99883208041587190351, 0.00044091560661750492855, 0.99875026248820031327 },
	{ 0.99883221309104286423, 0.00044087539970832527242, 0.99875041255839058785 },
	{ 0.99883230998435335035, 0.00044082825005012214346, 0.9987505125034589204 },
	{ 0.99883243281760536458, 0.00044078354179816897629, 0.99875064784891776082 },
	{ 0.99883254342475269461, 0.00044074041664558111231, 0.99875077249415100678 },
	{ 0.99883264642157887359, 0.00044069479286628417559, 0.99875088220484431467 },
	{ 0.99883279809394220905, 0.00044065420448737789008, 0.99875104608423870278 },
	{ 0.99883292138495782808, 0.00044061147987800288123, 0.99875118158228559651 },
	{ 0.99883302945533136707, 0.00044056413948493646469, 0.99875128835566218122 },
	{ 0.99883315514960624437, 0.00044052130043464345077, 0.99875142198450728159 },
	{ 0.9988332757321868316, 0.00044047876656013172951, 0.99875155729181919195 },
	{ 0.99883338773169860758, 0.00044043207466560045822, 0.99875167722590119102 },
	{ 0.99883348576941843877, 0.00044038637459235823899, 0.99875177984125762531 },
	{ 0.99883361644187329542, 0.00044034050285773912057, 0.99875191341288238611 },
	{ 0.99883373280921339266, 0.00044029463112312000215, 0.99875203180201199693 },
	{ 0.99883383061805142145, 0.00044024839699226058854, 0.99875213815577179588 },
	{ 0.99883398280539881231, 0.0004402112227674070369, 0.99875230789072644288 },
	{ 0.99883407145896330182, 0.00044016041099982888395, 0.99875239868052123615 },
	{ 0.99883420566001313023, 0.00044011822044807106949, 0.99875253883249870412 },
	{ 0.99883431790748022916, 0.00044007158577399880075, 0.9987526548183691677 },
	{ 0.99883445760169420335, 0.0004400313788648190904, 0.99875281221277822929 },
	{ 0.99883453103461672384, 0.00043998350441413547948, 0.99875289831049551825 },
	{ 0.99883467727103625311, 0.00043994148552375467263, 0.99875304534800146694 },
	{ 0.9988348150579015039, 0.00043989769279914527501, 0.99875318466074547441 },
	{ 0.99883491044440675388, 0.00043985357582526830476, 0.99875329862482631338 },
	{ 0.99883502364554821451, 0.00043980854332404761917, 0.99875342174418058061 },
	{ 0.99883512088218151526, 0.00043976234734016092813, 0.99875352828867502986 },
	{ 0.99883528514304587009, 0.00043972214043098127199, 0.99875369102366040597 },
	{ 0.99883536893287128144, 0.00043967718422370586891, 0.9987537978161104002 },
	{ 0.99883549931922366305, 0.00043963484108405743523, 0.9987539335430389853 },
	{ 0.99883561921515884308, 0.00043958971321540502453, 0.99875406389124454787 },
	{ 0.99883573674598180592, 0.00043954519569831519915, 0.99875418340570987219 },
	{ 0.99883584668555713826, 0.00043950254738288547281, 0.99875430814631049881 },
	{ 0.99883595584311934967, 0.00043945598900275854078, 0.99875442417032778142 },
	{ 0.99883607650199379702, 0.00043940712273078582359, 0.99875453498728317125 },
	{ 0.99883620755591850937, 0.00043936807930427217292, 0.99875468698389568978 },
	{ 0.99883630254188049413, 0.00043932039558845184957, 0.99875478898890046597 },
	{ 0.99883642209449297056, 0.00043927255928474090701, 0.9987549041164639485 },
	{ 0.99883654044547587336, 0.00043923332512336407717, 0.99875504642374546282 },
	{ 0.99883667500892203694, 0.00043919054329353006579, 0.99875518491632964135 },
	{ 0.99883677880683463535, 0.0004391441184278074188, 0.99875529664881257386 },
	{ 0.99883690181174800138, 0.0004390990096326413965, 0.99875542171366238353 },
	{ 0.99883700610557135668, 0.00043905803978400859003, 0.99875555011637229263 },
	{ 0.99883712146201675264, 0.00043901348411994604208, 0.99875567279703636459 },
	{ 0.99883722628989768388, 0.00043896755516486786692, 0.99875578555948740789 },
	{ 0.99883735701957310216, 0.00043892509758430142816, 0.99875592178232663887 },
	{ 0.99883747962394331399, 0.00043888244926887175603, 0.99875605506784892462 },
	{ 0.99883761170783613714, 0.00043883894264655726267, 0.99875619295008155607 },
	{ 0.9988377217809257802, 0.00043879474937873495571, 0.99875631320841284921 },
	{ 0.99883783294120409568, 0.00043875118553596151403, 0.99875643611795861254 },
	{ 0.99883796279349901237, 0.00043870800316291464751, 0.99875656749613228591 },
	{ 0.9988380624333916824, 0.00043865902245002403367, 0.99875666988260691781 },
	{ 0.9988381853047906267, 0.00043862007439094199968, 0.99875681373484082037 },
	{ 0.99883832187095289434, 0.00043857689201789507895, 0.99875695335276060138 },
	{ 0.9988384051267209518, 0.00043852979958015095253, 0.99875704873926585137 },
	{ 0.99883853597083716025, 0.00043848226845222124841, 0.99875717363245419822 },
	{ 0.99883861960807485136, 0.00043843632042365673906, 0.99875727146036563653 },
	{ 0.99883876723685904864, 0.00043839458763557083648, 0.99875742015726509671 },
	{ 0.99883887874046017874, 0.00043835235893684035367, 0.99875754836924024449 },
	{ 0.99883900964179705984, 0.00043830889046149858288, 0.99875768422968336235 },
	{ 0.99883912431159682654, 0.00043826547920661576042, 0.99875780759699306355 },
	{ 0.99883922723212903438, 0.00043821901619392044508, 0.99875791906244715257 },
	{ 0.99883934823432640737, 0.00043818010628181102524, 0.99875806081659757041 },
	{ 0.99883944337287633441, 0.00043812937080817820901, 0.99875815015680757813 },
	{ 0.99883959485450479754, 0.00043808889687018998278, 0.998758308810066886 },
	{ 0.99883971311012020866, 0.00043804815590339307805, 0.99875844171411953809 },
	{ 0.99883983519950636509, 0.00043800480186896920392, 0.9987585716236350164 },
	{ 0.99883992949882294266, 0.00043795872032600046374, 0.9987586750782249112 },
	{ 0.99884005221763394466, 0.00043791275322394967442, 0.99875879848368120939 },
	{ 0.99884016370216166525, 0.00043786951363044380537, 0.99875892053492021372 },
	{ 0.99884028367439081642, 0.00043782759010749450678, 0.99875905698664158017 },
	{ 0.99884039922157119573, 0.00043778497993903750301, 0.99875917970545258218 },
	{ 0.99884052937904188596, 0.0004377405768628656285, 0.99875931627161451676 },
	{ 0.99884064036765896066, 0.00043769611656623475145, 0.99875943340189410335 },
	{ 0.998840750307234293, 0.00043765285789924254821, 0.99875955448038522544 },
	{ 0.99884085147300594176, 0.00043760631859260184194, 0.99875965991861770377 },
	{ 0.99884098990836966969, 0.00043756454765754321679, 0.99875980804331232488 },
	{ 0.99884108664909232456, 0.0004375190764661369535, 0.99875991821176934859 },
	{ 0.99884119376579150185, 0.00043747421562629316711, 0.99876002776987471421 },
	{ 0.99884131816306931384, 0.00043742779076057052012, 0.99876014942057034229 },
	{ 0.99884146272102236619, 0.00043738775551276770897, 0.99876030336267840326 },
	{ 0.99884154599586383316, 0.00043734155952888096371, 0.99876040151483902463 },
	{ 0.99884169063011063461, 0.00043730018913703530212, 0.99876054954416626508 },
	{ 0.99884178821006674998, 0.000437252658009105598, 0.99876065292246218874 },
	{ 0.99884190392890848109, 0.00043720915138679110465, 0.99876077833063492406 },
	{ 0.99884200713554305295, 0.00043716308891730869864, 0.99876088527567274955 },
	{ 0.99884213729301396523, 0.00043712356865363685612, 0.99876103160745988152 },
	{ 0.99884224250236475218, 0.00043707847893195716799, 0.99876114795572645821 },
	{ 0.99884235545555088986, 0.00043703380882697666918, 0.9987612612140881474 },
	{ 0.99884248889366133994, 0.00043699009239631260828, 0.99876140121347789513 },
	{ 0.99884258824745164596, 0.00043694853126960360489, 0.99876151883966790557 },
	{ 0.99884271346488939791, 0.00043690777122932036598, 0.99876165702707631056 },
	{ 0.99884284526267996807, 0.00043686241447883205355, 0.99876178485758160264 },
	{ 0.99884293029228210514, 0.00043681461632209377935, 0.99876187873728128341 },
	{ 0.9988430725041962388, 0.0004367749434705313176, 0.99876203071482039242 },
	{ 0.9988431808415987323, 0.0004367313033338125392, 0.99876214881784775024 },
	{ 0.9988432997075656905, 0.00043668873131232814958, 0.99876227805979111984 },
	{ 0.99884317591755533705, 0.00043673291802489785929, 0.99876215234376419794 },
	{ 0.99884317591755533705, 0.00043673291802489785929, 0.99876215234376419794 },
	{ 0.99884317591755533705, 0.00043673291802489785929, 0.99876215234376419794 },
	{ 0.99884317591755533705, 0.00043673291802489785929, 0.99876215234376419794 },
	{ 0.99884317591755533705, 0.00043673291802489785929, 0.99876215234376419794 },
	{ 0.99884317591755533705, 0.00043673291802489785929, 0.99876215234376419794 },
	{ 0.99884411096542025099, 0.00043638050556098900712, 0.99876313656546111819 },
	{ 0.99884411096542025099, 0.00043638050556098900712, 0.99876313656546111819 },
	{ 0.99884411096542025099, 0.00043638050556098900712, 0.99876313656546111819 },
	{ 0.99884411096542025099, 0.00043638050556098900712, 0.99876313656546111819 },
	{ 0.99884411096542025099, 0.00043638050556098900712, 0.99876313656546111819 },
	{ 0.99884411096542025099, 0.00043638050556098900712, 0.99876313656546111819 },
	{ 0.99884411096542025099, 0.00043638050556098900712, 0.99876313656546111819 },
	{ 0.99884411096542025099, 0.00043638050556098900712, 0.99876313656546111819 },
	{ 0.99884501323073060508, 0.00043603405356491126144, 0.99876412078715792742 },
	{ 0.99884501323073060508, 0.00043603405356491126144, 0.99876412078715792742 },
	{ 0.99884501323073060508, 0.00043603405356491126144, 0.99876412078715792742 },
	{ 0.99884501323073060508, 0.00043603405356491126144, 0.99876412078715792742 },
	{ 0.99884501323073060508, 0.00043603405356491126144, 0.99876412078715792742 },
	{ 0.99884501323073060508, 0.00043603405356491126144, 0.99876412078715792742 },
	{ 0.99884501323073060508, 0.00043603405356491126144, 0.99876412078715792742 },
	{ 0.99884501323073060508, 0.00043603405356491126144, 0.99876412078715792742 },
	{ 0.9988459512588278022, 0.0004356890916815923942, 0.99876512438036424424 },
	{ 0.9988459512588278022, 0.0004356890916815923942, 0.99876512438036424424 },
	{ 0.9988459512588278022, 0.0004356890916815923942, 0.99876512438036424424 },
	{ 0.9988459512588278022, 0.0004356890916815923942, 0.99876512438036424424 },
	{ 0.9988459512588278022, 0.0004356890916815923942, 0.99876512438036424424 },
	{ 0.9988459512588278022, 0.0004356890916815923942, 0.99876512438036424424 },
	{ 0.9988459512588278022, 0.0004356890916815923942, 0.99876512438036424424 },
	{ 0.9988459512588278022, 0.0004356890916815923942, 0.99876512438036424424 },
	{ 0.99884684011309288199, 0.00043533369898880042159, 0.99876606538869350249 },
	{ 0.99884684011309288199, 0.00043533369898880042159, 0.99876606538869350249 },
	{ 0.99884684011309288199, 0.00043533369898880042159, 0.99876606538869350249 },
	{ 0.99884684011309288199, 0.00043533369898880042159, 0.99876606538869350249 },
	{ 0.99884684011309288199, 0.00043533369898880042159, 0.99876606538869350249 },
	{ 0.99884684011309288199, 0.00043533369898880042159, 0.99876606538869350249 },
	{ 0.99884684011309288199, 0.00043533369898880042159, 0.99876606538869350249 },
	{ 0.99884684011309288199, 0.00043533369898880042159, 0.99876606538869350249 },
	{ 0.99884777814118985706, 0.00043498873710548155436, 0.99876706898189981931 },
	{ 0.99884777814118985706, 0.00043498873710548155436, 0.99876706898189981931 },
	{ 0.99884777814118985706, 0.00043498873710548155436, 0.99876706898189981931 },
	{ 0.99884777814118985706, 0.00043498873710548155436, 0.99876706898189981931 },
	{ 0.99884777814118985706, 0.00043498873710548155436, 0.99876706898189981931 },
	{ 0.99884777814118985706, 0.00043498873710548155436, 0.99876706898189981931 },
	{ 0.99884777814118985706, 0.00043498873710548155436, 0.99876706898189981931 },
	{ 0.99884777814118985706, 0.00043498873710548155436, 0.99876706898189981931 },
	{ 0.99884870871870634623, 0.00043464377522552458122, 0.99876806214429336706 },
	{ 0.99884870871870634623, 0.00043464377522552458122, 0.99876806214429336706 },
	{ 0.99884870871870634623, 0.00043464377522552458122, 0.99876806214429336706 },
	{ 0.99884870871870634623, 0.00043464377522552458122, 0.99876806214429336706 },
	{ 0.99884870871870634623, 0.00043464377522552458122, 0.99876806214429336706 },
	{ 0.99884870871870634623, 0.00043464377522552458122, 0.99876806214429336706 },
	{ 0.99884870871870634623, 0.00043464377522552458122, 0.99876806214429336706 },
	{ 0.99884870871870634623, 0.00043464377522552458122, 0.99876806214429336706 },
	{ 0.99884960055320382022, 0.00043429881334220918343, 0.99876902997471295187 },
	{ 0.99884960055320382022, 0.00043429881334220918343, 0.99876902997471295187 },
	{ 0.99884960055320382022, 0.00043429881334220918343, 0.99876902997471295187 },
	{ 0.99884960055320382022, 0.00043429881334220918343, 0.99876902997471295187 },
	{ 0.99884960055320382022, 0.00043429881334220918343, 0.99876902997471295187 },
	{ 0.99884960055320382022, 0.00043429881334220918343, 0.99876902997471295187 },
	{ 0.99884960055320382022, 0.00043429881334220918343, 0.99876902997471295187 },
	{ 0.99884960055320382022, 0.00043429881334220918343, 0.99876902997471295187 },
	{ 0.99885050281851406329, 0.00043394789099776912011, 0.99876998439408748443 },
	{ 0.99885050281851406329, 0.00043394789099776912011, 0.99876998439408748443 },
	{ 0.99885050281851406329, 0.00043394789099776912011, 0.99876998439408748443 },
	{ 0.99885050281851406329, 0.00043394789099776912011, 0.99876998439408748443 },
	{ 0.99885050281851406329, 0.00043394789099776912011, 0.99876998439408748443 },
	{ 0.99885050281851406329, 0.00043394789099776912011, 0.99876998439408748443 },
	{ 0.99885050281851406329, 0.00043394789099776912011, 0.99876998439408748443 },
	{ 0.99885050281851406329, 0.00043394789099776912011, 0.99876998439408748443 },
	{ 0.99885146319835294015, 0.00043361335992729566069, 0.99877102076984847212 },
	{ 0.99885146319835294015, 0.00043361335992729566069, 0.99877102076984847212 },
	{ 0.99885146319835294015, 0.00043361335992729566069, 0.99877102076984847212 },
	{ 0.99885146319835294015, 0.00043361335992729566069, 0.99877102076984847212 },
	{ 0.99885146319835294015, 0.00043361335992729566069, 0.99877102076984847212 },
	{ 0.99885146319835294015, 0.00043361335992729566069, 0.99877102076984847212 },
	{ 0.99885146319835294015, 0.00043361335992729566069, 0.99877102076984847212 },
	{ 0.99885146319835294015, 0.00043361335992729566069, 0.99877102076984847212 },
	{ 0.99885238334505677127, 0.00043326988816344905175, 0.99877200052119685658 },
	{ 0.99885238334505677127, 0.00043326988816344905175, 0.99877200052119685658 },
	{ 0.99885238334505677127, 0.00043326988816344905175, 0.99877200052119685658 },
	{ 0.99885238334505677127, 0.00043326988816344905175, 0.99877200052119685658 },
	{ 0.99885238334505677127, 0.00043326988816344905175, 0.99877200052119685658 },
	{ 0.99885238334505677127, 0.00043326988816344905175, 0.99877200052119685658 },
	{ 0.99885238334505677127, 0.00043326988816344905175, 0.99877200052119685658 },
	{ 0.99885238334505677127, 0.00043326988816344905175, 0.99877200052119685658 },
	{ 0.99885326772897353731, 0.00043292045593178174467, 0.99877294301964236745 },
	{ 0.99885326772897353731, 0.00043292045593178174467, 0.99877294301964236745 },
	{ 0.99885326772897353731, 0.00043292045593178174467, 0.99877294301964236745 },
	{ 0.99885326772897353731, 0.00043292045593178174467, 0.99877294301964236745 },
	{ 0.99885326772897353731, 0.00043292045593178174467, 0.99877294301964236745 },
	{ 0.99885326772897353731, 0.00043292045593178174467, 0.99877294301964236745 },
	{ 0.99885326772897353731, 0.00043292045593178174467, 0.99877294301964236745 },
	{ 0.99885326772897353731, 0.00043292045593178174467, 0.99877294301964236745 },
	{ 0.99885417893498051889, 0.00043257847428405243884, 0.99877391830064254918 },
	{ 0.99885417893498051889, 0.00043257847428405243884, 0.99877391830064254918 },
	{ 0.99885417893498051889, 0.00043257847428405243884, 0.99877391830064254918 },
	{ 0.99885417893498051889, 0.00043257847428405243884, 0.99877391830064254918 },
	{ 0.99885417893498051889, 0.00043257847428405243884, 0.99877391830064254918 },
	{ 0.99885417893498051889, 0.00043257847428405243884, 0.99877391830064254918 },
	{ 0.99885417893498051889, 0.00043257847428405243884, 0.99877391830064254918 },
	{ 0.99885417893498051889, 0.00043257847428405243884, 0.99877391830064254918 },
	{ 0.99885504990785223267, 0.00043222904205238513176, 0.99877484589792697722 },
	{ 0.99885504990785223267, 0.00043222904205238513176, 0.99877484589792697722 },
	{ 0.99885504990785223267, 0.00043222904205238513176, 0.99877484589792697722 },
	{ 0.99885504990785223267, 0.00043222904205238513176, 0.99877484589792697722 },
	{ 0.99885504990785223267, 0.00043222904205238513176, 0.99877484589792697722 },
	{ 0.99885504990785223267, 0.00043222904205238513176, 0.99877484589792697722 },
	{ 0.99885504990785223267, 0.00043222904205238513176, 0.99877484589792697722 },
	{ 0.99885504990785223267, 0.00043222904205238513176, 0.99877484589792697722 },
	{ 0.99885600283711040159, 0.00043189600110138046118, 0.99877587184287508482 },
	{ 0.99885600283711040159, 0.00043189600110138046118, 0.99877587184287508482 },
	{ 0.99885600283711040159, 0.00043189600110138046118, 0.99877587184287508482 },
	{ 0.99885600283711040159, 0.00043189600110138046118, 0.99877587184287508482 },
	{ 0.99885600283711040159, 0.00043189600110138046118, 0.99877587184287508482 },
	{ 0.99885600283711040159, 0.00043189600110138046118, 0.99877587184287508482 },
	{ 0.99885600283711040159, 0.00043189600110138046118, 0.99877587184287508482 },
	{ 0.99885600283711040159, 0.00043189600110138046118, 0.99877587184287508482 },
	{ 0.99885687530009825696, 0.00043155103921805465506, 0.99877680689074010978 },
	{ 0.99885687530009825696, 0.00043155103921805465506, 0.99877680689074010978 },
	{ 0.99885687530009825696, 0.00043155103921805465506, 0.99877680689074010978 },
	{ 0.99885687530009825696, 0.00043155103921805465506, 0.99877680689074010978 },
	{ 0.99885687530009825696, 0.00043155103921805465506, 0.99877680689074010978 },
	{ 0.99885687530009825696, 0.00043155103921805465506, 0.99877680689074010978 },
	{ 0.99885687530009825696, 0.00043155103921805465506, 0.99877680689074010978 },
	{ 0.99885687530009825696, 0.00043155103921805465506, 0.99877680689074010978 },
	{ 0.99885780140726632137, 0.00043120905757035310479, 0.99877778366185643311 },
	{ 0.99885780140726632137, 0.00043120905757035310479, 0.99877778366185643311 },
	{ 0.99885780140726632137, 0.00043120905757035310479, 0.99877778366185643311 },
	{ 0.99885780140726632137, 0.00043120905757035310479, 0.99877778366185643311 },
	{ 0.99885780140726632137, 0.00043120905757035310479, 0.99877778366185643311 },
	{ 0.99885780140726632137, 0.00043120905757035310479, 0.99877778366185643311 },
	{ 0.99885780140726632137, 0.00043120905757035310479, 0.99877778366185643311 },
	{ 0.99885780140726632137, 0.00043120905757035310479, 0.99877778366185643311 },
	{ 0.99885871112315716136, 0.0004308715462676103447, 0.99877876341320492859 },
	{ 0.99885871112315716136, 0.0004308715462676103447, 0.99877876341320492859 },
	{ 0.99885871112315716136, 0.0004308715462676103447, 0.99877876341320492859 },
	{ 0.99885871112315716136, 0.0004308715462676103447, 0.99877876341320492859 },
	{ 0.99885871112315716136, 0.0004308715462676103447, 0.99877876341320492859 },
	{ 0.99885871112315716136, 0.0004308715462676103447, 0.99877876341320492859 },
	{ 0.99885871112315716136, 0.0004308715462676103447, 0.99877876341320492859 },
	{ 0.99885871112315716136, 0.0004308715462676103447, 0.99877876341320492859 },
	{ 0.99885959848730621058, 0.00043053105473603303643, 0.99877971187211489479 },
	{ 0.99885959848730621058, 0.00043053105473603303643, 0.99877971187211489479 },
	{ 0.99885959848730621058, 0.00043053105473603303643, 0.99877971187211489479 },
	{ 0.99885959848730621058, 0.00043053105473603303643, 0.99877971187211489479 },
	{ 0.99885959848730621058, 0.00043053105473603303643, 0.99877971187211489479 },
	{ 0.99885959848730621058, 0.00043053105473603303643, 0.99877971187211489479 },
	{ 0.99885959848730621058, 0.00043053105473603303643, 0.99877971187211489479 },
	{ 0.99885959848730621058, 0.00043053105473603303643, 0.99877971187211489479 },
	{ 0.99886050522296465637, 0.0004301905632010522007, 0.99878067523218616586 },
	{ 0.99886050522296465637, 0.0004301905632010522007, 0.99878067523218616586 },
	{ 0.99886050522296465637, 0.0004301905632010522007, 0.99878067523218616586 },
	{ 0.99886050522296465637, 0.0004301905632010522007, 0.99878067523218616586 },
	{ 0.99886050522296465637, 0.0004301905632010522007, 0.99878067523218616586 },
	{ 0.99886050522296465637, 0.0004301905632010522007, 0.99878067523218616586 },
	{ 0.99886050522296465637, 0.0004301905632010522007, 0.99878067523218616586 },
	{ 0.99886050522296465637, 0.0004301905632010522007, 0.99878067523218616586 },
	{ 0.99886138066618479492, 0.00042985007166947836188, 0.9987816207108639599 },
	{ 0.99886138066618479492, 0.00042985007166947836188, 0.9987816207108639599 },
	{ 0.99886138066618479492, 0.00042985007166947836188, 0.9987816207108639599 },
	{ 0.99886138066618479492, 0.00042985007166947836188, 0.9987816207108639599 },
	{ 0.99886138066618479492, 0.00042985007166947836188, 0.9987816207108639599 },
	{ 0.99886138066618479492, 0.00042985007166947836188, 0.9987816207108639599 },
	{ 0.99886138066618479492, 0.00042985007166947836188, 0.9987816207108639599 },
	{ 0.99886138066618479492, 0.00042985007166947836188, 0.9987816207108639599 },
	{ 0.9988622814413788964, 0.00042951107025060789035, 0.9987825796005868062 },
	{ 0.9988622814413788964, 0.00042951107025060789035, 0.9987825796005868062 },
	{ 0.9988622814413788964, 0.00042951107025060789035, 0.9987825796005868062 },
	{ 0.9988622814413788964, 0.00042951107025060789035, 0.9987825796005868062 },
	{ 0.9988622814413788964, 0.00042951107025060789035, 0.9987825796005868062 },
	{ 0.9988622814413788964, 0.00042951107025060789035, 0.9987825796005868062 },
	{ 0.9988622814413788964, 0.00042951107025060789035, 0.9987825796005868062 },
	{ 0.9988622814413788964, 0.00042951107025060789035, 0.9987825796005868062 },
	{ 0.99886317774622446208, 0.0004291765391835240806, 0.99878354743100627999 },
	{ 0.99886317774622446208, 0.0004291765391835240806, 0.99878354743100627999 },
	{ 0.99886317774622446208, 0.0004291765391835240806, 0.99878354743100627999 },
	{ 0.99886317774622446208, 0.0004291765391835240806, 0.99878354743100627999 },
	{ 0.99886317774622446208, 0.0004291765391835240806, 0.99878354743100627999 },
	{ 0.99886317774622446208, 0.0004291765391835240806, 0.99878354743100627999 },
	{ 0.99886317774622446208, 0.0004291765391835240806, 0.99878354743100627999 },
	{ 0.99886317774622446208, 0.0004291765391835240806, 0.99878354743100627999 },
	{ 0.99886407852141856356, 0.00042884051799688127637, 0.99878451079107755106 },
	{ 0.99886407852141856356, 0.00042884051799688127637, 0.99878451079107755106 },
	{ 0.99886407852141856356, 0.00042884051799688127637, 0.99878451079107755106 },
	{ 0.99886407852141856356, 0.00042884051799688127637, 0.99878451079107755106 },
	{ 0.99886407852141856356, 0.00042884051799688127637, 0.99878451079107755106 },
	{ 0.99886407852141856356, 0.00042884051799688127637, 0.99878451079107755106 },
	{ 0.99886407852141856356, 0.00042884051799688127637, 0.99878451079107755106 },
	{ 0.99886407852141856356, 0.00042884051799688127637, 0.99878451079107755106 },
	{ 0.9988649524745224495, 0.00042850151658144208788, 0.99878544285871040387 },
	{ 0.9988649524745224495, 0.00042850151658144208788, 0.99878544285871040387 },
	{ 0.9988649524745224495, 0.00042850151658144208788, 0.99878544285871040387 },
	{ 0.9988649524745224495, 0.00042850151658144208788, 0.99878544285871040387 },
	{ 0.9988649524745224495, 0.00042850151658144208788, 0.99878544285871040387 },
	{ 0.9988649524745224495, 0.00042850151658144208788, 0.99878544285871040387 },
	{ 0.9988649524745224495, 0.00042850151658144208788, 0.99878544285871040387 },
	{ 0.9988649524745224495, 0.00042850151658144208788, 0.99878544285871040387 },
	{ 0.99886586517064535062, 0.00042816698551091658675, 0.99878641217924613027 },
	{ 0.99886586517064535062, 0.00042816698551091658675, 0.99878641217924613027 },
	{ 0.99886586517064535062, 0.00042816698551091658675, 0.99878641217924613027 },
	{ 0.99886586517064535062, 0.00042816698551091658675, 0.99878641217924613027 },
	{ 0.99886586517064535062, 0.00042816698551091658675, 0.99878641217924613027 },
	{ 0.99886586517064535062, 0.00042816698551091658675, 0.99878641217924613027 },
	{ 0.99886586517064535062, 0.00042816698551091658675, 0.99878641217924613027 },
	{ 0.99886586517064535062, 0.00042816698551091658675, 0.99878641217924613027 },
	{ 0.99886673316328489225, 0.00042782947421160164025, 0.99878734722711093319 },
	{ 0.99886673316328489225, 0.00042782947421160164025, 0.99878734722711093319 },
	{ 0.99886673316328489225, 0.00042782947421160164025, 0.99878734722711093319 },
	{ 0.99886673316328489225, 0.00042782947421160164025, 0.99878734722711093319 },
	{ 0.99886673316328489225, 0.00042782947421160164025, 0.99878734722711093319 },
	{ 0.99886673316328489225, 0.00042782947421160164025, 0.99878734722711093319 },
	{ 0.99886673316328489225, 0.00042782947421160164025, 0.99878734722711093319 },
	{ 0.99886673316328489225, 0.00042782947421160164025, 0.99878734722711093319 },
	{ 0.99886760860650491978, 0.00042749345302494842769, 0.99878828972555655508 },
	{ 0.99886760860650491978, 0.00042749345302494842769, 0.99878828972555655508 },
	{ 0.99886760860650491978, 0.00042749345302494842769, 0.99878828972555655508 },
	{ 0.99886760860650491978, 0.00042749345302494842769, 0.99878828972555655508 },
	{ 0.99886760860650491978, 0.00042749345302494842769, 0.99878828972555655508 },
	{ 0.99886760860650491978, 0.00042749345302494842769, 0.99878828972555655508 },
	{ 0.99886760860650491978, 0.00042749345302494842769, 0.99878828972555655508 },
	{ 0.99886760860650491978, 0.00042749345302494842769, 0.99878828972555655508 },
	{ 0.9988685242828602151, 0.00042716190219012004081, 0.99878926351644059523 },
	{ 0.9988685242828602151, 0.00042716190219012004081, 0.99878926351644059523 },
	{ 0.9988685242828602151, 0.00042716190219012004081, 0.99878926351644059523 },
	{ 0.9988685242828602151, 0.00042716190219012004081, 0.99878926351644059523 },
	{ 0.9988685242828602151, 0.00042716190219012004081, 0.99878926351644059523 },
	{ 0.9988685242828602151, 0.00042716190219012004081, 0.99878926351644059523 },
	{ 0.9988685242828602151, 0.00042716190219012004081, 0.99878926351644059523 },
	{ 0.9988685242828602151, 0.00042716190219012004081, 0.99878926351644059523 },
	{ 0.99886937588422231027, 0.00042682439088734258625, 0.99879017770267985998 },
	{ 0.99886937588422231027, 0.00042682439088734258625, 0.99879017770267985998 },
	{ 0.99886937588422231027, 0.00042682439088734258625, 0.99879017770267985998 },
	{ 0.99886937588422231027, 0.00042682439088734258625, 0.99879017770267985998 },
	{ 0.99886937588422231027, 0.00042682439088734258625, 0.99879017770267985998 },
	{ 0.99886937588422231027, 0.00042682439088734258625, 0.99879017770267985998 },
	{ 0.99886937588422231027, 0.00042682439088734258625, 0.99879017770267985998 },
	{ 0.99886937588422231027, 0.00042682439088734258625, 0.99879017770267985998 },
	{ 0.998870290070461464, 0.00042649582028476268336, 0.99879116043426052762 },
	{ 0.998870290070461464, 0.00042649582028476268336, 0.99879116043426052762 },
	{ 0.998870290070461464, 0.00042649582028476268336, 0.99879116043426052762 },
	{ 0.998870290070461464, 0.00042649582028476268336, 0.99879116043426052762 },
	{ 0.998870290070461464, 0.00042649582028476268336, 0.99879116043426052762 },
	{ 0.998870290070461464, 0.00042649582028476268336, 0.99879116043426052762 },
	{ 0.998870290070461464, 0.00042649582028476268336, 0.99879116043426052762 },
	{ 0.998870290070461464, 0.00042649582028476268336, 0.99879116043426052762 },
	{ 0.99887114763228801451, 0.00042615830898197482046, 0.9987920746204999034 },
	{ 0.99887114763228801451, 0.00042615830898197482046, 0.9987920746204999034 },
	{ 0.99887114763228801451, 0.00042615830898197482046, 0.9987920746204999034 },
	{ 0.99887114763228801451, 0.00042615830898197482046, 0.9987920746204999034 },
	{ 0.99887114763228801451, 0.00042615830898197482046, 0.9987920746204999034 },
	{ 0.99887114763228801451, 0.00042615830898197482046, 0.9987920746204999034 },
	{ 0.99887114763228801451, 0.00042615830898197482046, 0.9987920746204999034 },
	{ 0.99887114763228801451, 0.00042615830898197482046, 0.9987920746204999034 },
	{ 0.99887202903597260839, 0.00042582973837939838702, 0.9987930260596422638 },
	{ 0.99887202903597260839, 0.00042582973837939838702, 0.9987930260596422638 },
	{ 0.99887202903597260839, 0.00042582973837939838702, 0.9987930260596422638 },
	{ 0.99887202903597260839, 0.00042582973837939838702, 0.9987930260596422638 },
	{ 0.99887202903597260839, 0.00042582973837939838702, 0.9987930260596422638 },
	{ 0.99887202903597260839, 0.00042582973837939838702, 0.9987930260596422638 },
	{ 0.99887202903597260839, 0.00042582973837939838702, 0.9987930260596422638 },
	{ 0.99887202903597260839, 0.00042582973837939838702, 0.9987930260596422638 },
	{ 0.99887292087046997136, 0.00042549669742496243341, 0.99879397153832005785 },
	{ 0.99887292087046997136, 0.00042549669742496243341, 0.99879397153832005785 },
	{ 0.99887292087046997136, 0.00042549669742496243341, 0.99879397153832005785 },
	{ 0.99887292087046997136, 0.00042549669742496243341, 0.99879397153832005785 },
	{ 0.99887292087046997136, 0.00042549669742496243341, 0.99879397153832005785 },
	{ 0.99887292087046997136, 0.00042549669742496243341, 0.99879397153832005785 },
	{ 0.99887292087046997136, 0.00042549669742496243341, 0.99879397153832005785 },
	{ 0.99887292087046997136, 0.00042549669742496243341, 0.99879397153832005785 },
	{ 0.99887378290264494662, 0.00042516365647404102956, 0.99879489913560459691 },
	{ 0.99887378290264494662, 0.00042516365647404102956, 0.99879489913560459691 },
	{ 0.99887378290264494662, 0.00042516365647404102956, 0.99879489913560459691 },
	{ 0.99887378290264494662, 0.00042516365647404102956, 0.99879489913560459691 },
	{ 0.99887378290264494662, 0.00042516365647404102956, 0.99879489913560459691 },
	{ 0.99887378290264494662, 0.00042516365647404102956, 0.99879489913560459691 },
	{ 0.99887378290264494662, 0.00042516365647404102956, 0.99879489913560459691 },
	{ 0.99887378290264494662, 0.00042516365647404102956, 0.99879489913560459691 },
	{ 0.99887378290264494662, 0.00042516365647404102956, 0.99879489913560459691 },
	{ 0.99887475967376126995, 0.00042478889226825120029, 0.99879593551136580665 },
	{ 0.99887475967376126995, 0.00042478889226825120029, 0.99879593551136580665 },
	{ 0.99887475967376126995, 0.00042478889226825120029, 0.99879593551136580665 },
	{ 0.99887475967376126995, 0.00042478889226825120029, 0.99879593551136580665 },
	{ 0.99887475967376126995, 0.00042478889226825120029, 0.99879593551136580665 },
	{ 0.99887475967376126995, 0.00042478889226825120029, 0.99879593551136580665 },
	{ 0.99887475967376126995, 0.00042478889226825120029, 0.99879593551136580665 },
	{ 0.99887475967376126995, 0.00042478889226825120029, 0.99879593551136580665 },
	{ 0.99887567386000042369, 0.00042446330189793018972, 0.99879691228248212997 },
	{ 0.99887567386000042369, 0.00042446330189793018972, 0.99879691228248212997 },
	{ 0.99887567386000042369, 0.00042446330189793018972, 0.99879691228248212997 },
	{ 0.99887567386000042369, 0.00042446330189793018972, 0.99879691228248212997 },
	{ 0.99887567386000042369, 0.00042446330189793018972, 0.99879691228248212997 },
	{ 0.99887567386000042369, 0.00042446330189793018972, 0.99879691228248212997 },
	{ 0.99887567386000042369, 0.00042446330189793018972, 0.99879691228248212997 },
	{ 0.99887567386000042369, 0.00042446330189793018972, 0.99879691228248212997 },
	{ 0.99887567386000042369, 0.00042446330189793018972, 0.99879691228248212997 },
	{ 0.99887664765088435281, 0.00042409449815661651173, 0.99879796355940431152 },
	{ 0.99887664765088435281, 0.00042409449815661651173, 0.99879796355940431152 },
	{ 0.99887664765088435281, 0.00042409449815661651173, 0.99879796355940431152 },
	{ 0.99887664765088435281, 0.00042409449815661651173, 0.99879796355940431152 },
	{ 0.99887664765088435281, 0.00042409449815661651173, 0.99879796355940431152 },
	{ 0.99887664765088435281, 0.00042409449815661651173, 0.99879796355940431152 },
	{ 0.99887664765088435281, 0.00042409449815661651173, 0.99879796355940431152 },
	{ 0.99887664765088435281, 0.00042409449815661651173, 0.99879796355940431152 },
	{ 0.99887664765088435281, 0.00042409449815661651173, 0.99879796355940431152 },
	{ 0.99887762144176839296, 0.0004237182438382447458, 0.99879899397470084388 },
	{ 0.99887762144176839296, 0.0004237182438382447458, 0.99879899397470084388 },
	{ 0.99887762144176839296, 0.0004237182438382447458, 0.99879899397470084388 },
	{ 0.99887762144176839296, 0.0004237182438382447458, 0.99879899397470084388 },
	{ 0.99887762144176839296, 0.0004237182438382447458, 0.99879899397470084388 },
	{ 0.99887762144176839296, 0.0004237182438382447458, 0.99879899397470084388 },
	{ 0.99887762144176839296, 0.0004237182438382447458, 0.99879899397470084388 },
	{ 0.99887762144176839296, 0.0004237182438382447458, 0.99879899397470084388 },
	{ 0.99887762144176839296, 0.0004237182438382447458, 0.99879899397470084388 },
	{ 0.99887856692044607598, 0.00042334645986467911438, 0.99880001395918460716 },
	{ 0.99887856692044607598, 0.00042334645986467911438, 0.99880001395918460716 },
	{ 0.99887856692044607598, 0.00042334645986467911438, 0.99880001395918460716 },
	{ 0.99887856692044607598, 0.00042334645986467911438, 0.99880001395918460716 },
	{ 0.99887856692044607598, 0.00042334645986467911438, 0.99880001395918460716 },
	{ 0.99887856692044607598, 0.00042334645986467911438, 0.99880001395918460716 },
	{ 0.99887856692044607598, 0.00042334645986467911438, 0.99880001395918460716 },
	{ 0.99887856692044607598, 0.00042334645986467911438, 0.99880001395918460716 },
	{ 0.99887856692044607598, 0.00042334645986467911438, 0.99880001395918460716 },
	{ 0.99887958690492972824, 0.00042298361659139083191, 0.99880109950877771219 },
	{ 0.99887958690492972824, 0.00042298361659139083191, 0.99880109950877771219 },
	{ 0.99887958690492972824, 0.00042298361659139083191, 0.99880109950877771219 },
	{ 0.99887958690492972824, 0.00042298361659139083191, 0.99880109950877771219 },
	{ 0.99887958690492972824, 0.00042298361659139083191, 0.99880109950877771219 },
	{ 0.99887958690492972824, 0.00042298361659139083191, 0.99880109950877771219 },
	{ 0.99887958690492972824, 0.00042298361659139083191, 0.99880109950877771219 },
	{ 0.99887958690492972824, 0.00042298361659139083191, 0.99880109950877771219 },
	{ 0.99887958690492972824, 0.00042298361659139083191, 0.99880109950877771219 },
	{ 0.99888053387372344183, 0.00042261183261781826159, 0.99880211502291327275 },
	{ 0.99888053387372344183, 0.00042261183261781826159, 0.99880211502291327275 },
	{ 0.99888053387372344183, 0.00042261183261781826159, 0.99880211502291327275 },
	{ 0.99888053387372344183, 0.00042261183261781826159, 0.99880211502291327275 },
	{ 0.99888053387372344183, 0.00042261183261781826159, 0.99880211502291327275 },
	{ 0.99888053387372344183, 0.00042261183261781826159, 0.99880211502291327275 },
	{ 0.99888053387372344183, 0.00042261183261781826159, 0.99880211502291327275 },
	{ 0.99888053387372344183, 0.00042261183261781826159, 0.99880211502291327275 },
	{ 0.99888053387372344183, 0.00042261183261781826159, 0.99880211502291327275 },
	{ 0.99888151064483976516, 0.00042224302888006076673, 0.99880315735913871578 },
	{ 0.99888151064483976516, 0.00042224302888006076673, 0.99880315735913871578 },
	{ 0.99888151064483976516, 0.00042224302888006076673, 0.99880315735913871578 },
	{ 0.99888151064483976516, 0.00042224302888006076673, 0.99880315735913871578 },
	{ 0.99888151064483976516, 0.00042224302888006076673, 0.99880315735913871578 },
	{ 0.99888151064483976516, 0.00042224302888006076673, 0.99880315735913871578 },
	{ 0.99888151064483976516, 0.00042224302888006076673, 0.99880315735913871578 },
	{ 0.99888151064483976516, 0.00042224302888006076673, 0.99880315735913871578 },
	{ 0.99888151064483976516, 0.00042224302888006076673, 0.99880315735913871578 },
	{ 0.99888250231711706029, 0.00042188018560319895389, 0.99880422800757051593 },
	{ 0.99888250231711706029, 0.00042188018560319895389, 0.99880422800757051593 },
	{ 0.99888250231711706029, 0.00042188018560319895389, 0.99880422800757051593 },
	{ 0.99888250231711706029, 0.00042188018560319895389, 0.99880422800757051593 },
	{ 0.99888250231711706029, 0.00042188018560319895389, 0.99880422800757051593 },
	{ 0.99888250231711706029, 0.00042188018560319895389, 0.99880422800757051593 },
	{ 0.99888250231711706029, 0.00042188018560319895389, 0.99880422800757051593 },
	{ 0.99888250231711706029, 0.00042188018560319895389, 0.99880422800757051593 },
	{ 0.99888250231711706029, 0.00042188018560319895389, 0.99880422800757051593 },
	{ 0.99888348057834941418, 0.00042151436209768300412, 0.99880527034379584794 },
	{ 0.99888348057834941418, 0.00042151436209768300412, 0.99880527034379584794 },
	{ 0.99888348057834941418, 0.00042151436209768300412, 0.99880527034379584794 },
	{ 0.99888348057834941418, 0.00042151436209768300412, 0.99880527034379584794 },
	{ 0.99888348057834941418, 0.00042151436209768300412, 0.99880527034379584794 },
	{ 0.99888348057834941418, 0.00042151436209768300412, 0.99880527034379584794 },
	{ 0.99888348057834941418, 0.00042151436209768300412, 0.99880527034379584794 },
	{ 0.99888348057834941418, 0.00042151436209768300412, 0.99880527034379584794 },
	{ 0.99888348057834941418, 0.00042151436209768300412, 0.99880527034379584794 },
	{ 0.99888443946807214946, 0.0004211455583563381011, 0.99880629181839564179 },
	{ 0.99888443946807214946, 0.0004211455583563381011, 0.99880629181839564179 },
	{ 0.99888443946807214946, 0.0004211455583563381011, 0.99880629181839564179 },
	{ 0.99888443946807214946, 0.0004211455583563381011, 0.99880629181839564179 },
	{ 0.99888443946807214946, 0.0004211455583563381011, 0.99880629181839564179 },
	{ 0.99888443946807214946, 0.0004211455583563381011, 0.99880629181839564179 },
	{ 0.99888443946807214946, 0.0004211455583563381011, 0.99880629181839564179 },
	{ 0.99888443946807214946, 0.0004211455583563381011, 0.99880629181839564179 },
	{ 0.99888443946807214946, 0.0004211455583563381011, 0.99880629181839564179 },
	{ 0.998885411768839937, 0.00042078122496694986276, 0.99880732819415662949 },
	{ 0.998885411768839937, 0.00042078122496694986276, 0.99880732819415662949 },
	{ 0.998885411768839937, 0.00042078122496694986276, 0.99880732819415662949 },
	{ 0.998885411768839937, 0.00042078122496694986276, 0.99880732819415662949 },
	{ 0.998885411768839937, 0.00042078122496694986276, 0.99880732819415662949 },
	{ 0.998885411768839937, 0.00042078122496694986276, 0.99880732819415662949 },
	{ 0.998885411768839937, 0.00042078122496694986276, 0.99880732819415662949 },
	{ 0.998885411768839937, 0.00042078122496694986276, 0.99880732819415662949 },
	{ 0.998885411768839937, 0.00042078122496694986276, 0.99880732819415662949 },
	{ 0.99888634979693713412, 0.00042041242122559802086, 0.9988083302972466937 },
	{ 0.99888634979693713412, 0.00042041242122559802086, 0.9988083302972466937 },
	{ 0.99888634979693713412, 0.00042041242122559802086, 0.9988083302972466937 },
	{ 0.99888634979693713412, 0.00042041242122559802086, 0.9988083302972466937 },
	{ 0.99888634979693713412, 0.00042041242122559802086, 0.9988083302972466937 },
	{ 0.99888634979693713412, 0.00042041242122559802086, 0.9988083302972466937 },
	{ 0.99888634979693713412, 0.00042041242122559802086, 0.9988083302972466937 },
	{ 0.99888634979693713412, 0.00042041242122559802086, 0.9988083302972466937 },
	{ 0.99888634979693713412, 0.00042041242122559802086, 0.9988083302972466937 },
	{ 0.9988873116668922636, 0.00042004808783621672141, 0.9988093651828915398 },
	{ 0.9988873116668922636, 0.00042004808783621672141, 0.9988093651828915398 },
	{ 0.9988873116668922636, 0.00042004808783621672141, 0.9988093651828915398 },
	{ 0.9988873116668922636, 0.00042004808783621672141, 0.9988093651828915398 },
	{ 0.9988873116668922636, 0.00042004808783621672141, 0.9988093651828915398 },
	{ 0.9988873116668922636, 0.00042004808783621672141, 0.9988093651828915398 },
	{ 0.9988873116668922636, 0.00042004808783621672141, 0.9988093651828915398 },
	{ 0.9988873116668922636, 0.00042004808783621672141, 0.9988093651828915398 },
	{ 0.9988873116668922636, 0.00042004808783621672141, 0.9988093651828915398 },
	{ 0.99888831227986629724, 0.00041969418525605178827, 0.9988104417917877953 },
	{ 0.99888831227986629724, 0.00041969418525605178827, 0.9988104417917877953 },
	{ 0.99888831227986629724, 0.00041969418525605178827, 0.9988104417917877953 },
	{ 0.99888831227986629724, 0.00041969418525605178827, 0.9988104417917877953 },
	{ 0.99888831227986629724, 0.00041969418525605178827, 0.9988104417917877953 },
	{ 0.99888831227986629724, 0.00041969418525605178827, 0.9988104417917877953 },
	{ 0.99888831227986629724, 0.00041969418525605178827, 0.9988104417917877953 },
	{ 0.99888831227986629724, 0.00041969418525605178827, 0.9988104417917877953 },
	{ 0.99888831227986629724, 0.00041969418525605178827, 0.9988104417917877953 },
	{ 0.99888923987715039221, 0.00041932687163443588263, 0.99881144091464579837 },
	{ 0.99888928756086636795, 0.00041927918791861555929, 0.99881148859836144105 },
	{ 0.99888954982130340188, 0.00041925534606070607524, 0.99881175085879825293 },
	{ 0.99888959750501937762, 0.00041920766234488439665, 0.99881179854251400663 },
	{ 0.9988897643980246821, 0.0004191838204869749126, 0.99881201311923495378 },
	{ 0.99888974055616686076, 0.00041911229491324304523, 0.9988119415936611567 },
	{ 0.99888990744917227627, 0.00041908845305533220594, 0.99881215617038210386 },
	{ 0.99888995513288825201, 0.00041904076933951052734, 0.99881220385409785756 },
	{ 0.99889012202589366751, 0.0004190169274816010433, 0.99881241843081880472 },
	{ 0.99889016970960953223, 0.0004189692437657793647, 0.99881246611453444739 },
	{ 0.99889021739332539696, 0.00041892156004995974609, 0.99881251379825009007 },
	{ 0.99889047965376243088, 0.00041889771819205026205, 0.99881277605868701297 },
	{ 0.99889052733747840662, 0.00041885003447622858345, 0.99881282374240276667 },
	{ 0.99889057502119427134, 0.00041880235076040896484, 0.99881287142611840935 },
	{ 0.99889083728163130527, 0.0004187785089024994808, 0.9988131336865551102 },
	{ 0.99889088496534728101, 0.0004187308251866778022, 0.99881318137027075288 },
	{ 0.99889105185835269651, 0.00041870698332876831816, 0.99881339594699170004 },
	{ 0.99889107570021062887, 0.00041863545775503645079, 0.99881337210513365665 },
	{ 0.99889119490950029068, 0.00041861161589712561149, 0.99881353899813885011 },
	{ 0.9988912425932161554, 0.00041856393218130393289, 0.99881358668185460381 },
	{ 0.9988914094862215709, 0.00041854009032339444885, 0.99881380125857555097 },
	{ 0.99889145716993743562, 0.00041849240660757277025, 0.99881384894229119364 },
	{ 0.99889148101179536798, 0.00041842088103384296287, 0.99881382510043315026 },
	{ 0.99889169558851675923, 0.00041839703917593212357, 0.99881403967715420844 },
	{ 0.99889186248152206371, 0.00041837319731802057954, 0.99881425425387526662 },
	{ 0.99889191016523803945, 0.00041832551360219890095, 0.99881430193759102032 },
	{ 0.99889195784895390418, 0.00041827782988637928234, 0.998814349621306663 },
	{ 0.9988922201093909381, 0.00041825398802846979829, 0.99881461188174347487 },
	{ 0.99889226779310691384, 0.0004182063043126481197, 0.99881465956545922857 },
	{ 0.99889231547682277856, 0.00041815862059682850109, 0.99881470724917487125 },
	{ 0.99889248236982819407, 0.00041813477873891901704, 0.99881492182589581841 },
	{ 0.99889253005354405879, 0.00041808709502309733845, 0.99881496950961157211 },
	{ 0.99889257773725992351, 0.00041803941130727771984, 0.99881501719332710376 },
	{ 0.99889283999769695743, 0.00041801556944936823579, 0.99881527945376391564 },
	{ 0.99889288768141293318, 0.0004179678857335465572, 0.99881532713747955832 },
	{ 0.99889305457441834868, 0.00041794404387563707315, 0.99881554171420050547 },
	{ 0.99889303073256041632, 0.00041787251830190520578, 0.99881547018862670839 },
	{ 0.99889319762556583182, 0.00041784867644399436648, 0.99881568476534765555 },
	{ 0.99889324530928180756, 0.00041780099272817268789, 0.99881573244906340925 },
	{ 0.99889350756971884149, 0.00041777715087026320384, 0.99881599470950022113 },
	{ 0.99889355525343481723, 0.00041772946715444152525, 0.99881604239321597483 },
	{ 0.99889360293715068195, 0.00041768178343862190664, 0.9988160900769316175 },
	{ 0.99889376983015598643, 0.00041765794158071242259, 0.99881630465365256466 },
	{ 0.99889381751387196218, 0.000417610257864890744, 0.99881635233736831836 },
	{ 0.9988938651975878269, 0.00041756257414907112539, 0.99881640002108385001 },
	{ 0.99889412745802486082, 0.00041753873229116164134, 0.99881666228152066189 },
	{ 0.99889417514174083657, 0.00041749104857533996275, 0.99881670996523630457 },
	{ 0.99889422282545670129, 0.00041744336485952034414, 0.99881675764895194725 },
	{ 0.99889438971846211679, 0.00041741952300161086009, 0.9988169722256728944 },
	{ 0.99889443740217798151, 0.0004173718392857891815, 0.9988170199093886481 },
	{ 0.99889446124403591387, 0.00041730031371205937411, 0.9988169960675304937 },
	{ 0.9988946758207571941, 0.00041727647185414853482, 0.99881721064425155188 },
	{ 0.9988948427137626096, 0.00041725262999623699079, 0.99881742522097261006 },
	{ 0.99889489039747858534, 0.00041720494628041531219, 0.99881747290468836376 },
	{ 0.99889493808119445006, 0.00041715726256459569358, 0.99881752058840400643 },
	{ 0.99889510497419975454, 0.00041713342070668620954, 0.99881773516512495359 },
	{ 0.99889515265791573029, 0.00041708573699086453094, 0.99881778284884059627 },
	{ 0.99889520034163159501, 0.00041703805327504491233, 0.99881783053255623894 },
	{ 0.99889546260206862893, 0.00041701421141713542829, 0.99881809279299305082 },
	{ 0.99889551028578460468, 0.00041696652770131374969, 0.9988181404767086935 },
	{ 0.9988955579695004694, 0.00041691884398549413108, 0.99881818816042433617 },
	{ 0.9988957248625058849, 0.00041689500212758464704, 0.99881840273714528333 },
	{ 0.99889577254622174962, 0.00041684731841176296844, 0.99881845042086092601 },
	{ 0.99889603480665878354, 0.0004168234765538534844, 0.99881871268129784891 },
	{ 0.99889608249037475929, 0.0004167757928380318058, 0.99881876036501360261 },
	{ 0.99889613017409062401, 0.00041672810912221218719, 0.99881880804872924529 },
	{ 0.99889629706709592849, 0.00041670426726430270315, 0.99881902262545019244 },
	{ 0.99889634475081190423, 0.00041665658354848102455, 0.99881907030916583512 },
	{ 0.99889639243452776896, 0.00041660889983266140594, 0.9988191179928814778 },
	{ 0.99889665469496480288, 0.0004165850579747519219, 0.9988193802533184007 },
	{ 0.99889670237868077862, 0.0004165373742589302433, 0.9988194279370341544 },
	{ 0.99889675006239664334, 0.00041648969054311062469, 0.99881947562074979707 },
	{ 0.99889691695540194782, 0.00041646584868520114065, 0.99881969019747074423 },
	{ 0.99889689311354423751, 0.00041639432311146927328, 0.99881961867189694715 },
	{ 0.99889706000654965301, 0.00041637048125355843398, 0.99881983324861789431 },
	{ 0.99889727458327093323, 0.00041634663939564688995, 0.99882004782533895249 },
	{ 0.99889732226698679796, 0.00041629895567982521136, 0.99882009550905470618 },
	{ 0.99889736995070266268, 0.00041625127196400559275, 0.99882014319277034886 },
	{ 0.99889753684370807818, 0.0004162274301060961087, 0.99882035776949129602 },
	{ 0.99889751300185025684, 0.00041615590453236424133, 0.99882028624391749894 },
	{ 0.99889772757857153707, 0.00041613206267445340203, 0.99882050082063844609 },
	{ 0.99889789447157684155, 0.000416108220816541858, 0.99882071539735950427 },
	{ 0.99889794215529281729, 0.00041606053710072017941, 0.99882076308107525797 },
	{ 0.99889798983900868201, 0.0004160128533849005608, 0.99882081076479090065 },
	{ 0.99889815673201409751, 0.00041598901152699107675, 0.99882102534151184781 },
	{ 0.99889813289015627618, 0.00041591748595325920938, 0.99882095381593805072 },
	{ 0.9988983474668775564, 0.00041589364409534837009, 0.99882116839265899788 },
	{ 0.99889851435988286088, 0.00041586980223743682606, 0.99882138296938005606 },
	{ 0.99889856204359883662, 0.00041582211852161514746, 0.99882143065309580976 },
	{ 0.99889860972731470135, 0.00041577443480579552885, 0.99882147833681134141 },
	{ 0.99889887198775173527, 0.00041575059294788604481, 0.99882174059724826432 },
	{ 0.99889891967146771101, 0.00041570290923206436621, 0.99882178828096401801 },
	{ 0.99889896735518357573, 0.0004156552255162447476, 0.99882183596467966069 },
	{ 0.99889913424818888021, 0.00041563138365833526356, 0.99882205054140060785 },
	{ 0.99889918193190485596, 0.00041558369994251358496, 0.99882209822511636155 },
	{ 0.99889922961562072068, 0.00041553601622669396635, 0.9988221459088318932 },
	{ 0.9988994918760577546, 0.00041551217436878448231, 0.9988224081692688161 },
	{ 0.99889953955977373035, 0.00041546449065296280371, 0.9988224558529845698 },
	{ 0.99889958724348959507, 0.0004154168069371431851, 0.99882250353670021248 },
	{ 0.99889963492720545979, 0.00041536912322132356649, 0.99882255122041585516 },
	{ 0.99889980182021087529, 0.00041534528136341408245, 0.99882276579713680231 },
	{ 0.99889984950392674001, 0.00041529759764759240385, 0.99882281348085244499 },
	{ 0.99890006408064802024, 0.00041527375578968291981, 0.99882302805757350317 },
	{ 0.99890011176436388496, 0.00041522607207386124121, 0.99882307574128925687 },
	{ 0.99890027865736930046, 0.00041520223021595175717, 0.99882329031801020403 },
	{ 0.99890025481551147912, 0.0004151307046422198898, 0.99882321879243640694 },
	{ 0.99890051707594851305, 0.0004151068627843090505, 0.99882348105287321882 },
	{ 0.99890056475966448879, 0.0004150591790684873719, 0.99882352873658897252 },
	{ 0.99890061244338035351, 0.00041501149535266775329, 0.9988235764203046152 },
	{ 0.99890073165266990429, 0.00041498765349475826925, 0.99882374331330969763 },
	{ 0.99890089854567520877, 0.00041496381163684672522, 0.99882395789003075581 },
	{ 0.99890087470381749846, 0.00041489228606311485785, 0.99882388636445695873 },
	{ 0.99890108928053877868, 0.00041486844420520401855, 0.99882410094117790589 },
	{ 0.9989011369642546434, 0.00041482076048938233996, 0.99882414862489365959 },
	{ 0.99890130385725994788, 0.00041479691863147285591, 0.99882436320161460674 },
	{ 0.99890135154097592363, 0.00041474923491565117732, 0.99882441088533036044 },
	{ 0.99890139922469178835, 0.00041470155119983155871, 0.9988244585690458921 },
	{ 0.99890166148512882227, 0.00041467770934192207466, 0.998824720829482815 },
	{ 0.99890170916884479801, 0.00041463002562610039607, 0.9988247685131985687 },
	{ 0.99890175685256066274, 0.00041458234191028077746, 0.99882481619691421137 },
	{ 0.99890192374556596722, 0.00041455850005237129341, 0.99882503077363515853 },
	{ 0.99890197142928194296, 0.00041451081633654961482, 0.99882507845735091223 },
	{ 0.99890201911299780768, 0.00041446313262072999621, 0.99882512614106644389 },
	{ 0.99890223368971908791, 0.00041443929076282051216, 0.99882534071778750207 },
	{ 0.99890228137343495263, 0.00041439160704699883357, 0.99882538840150325576 },
	{ 0.99890244826644025711, 0.00041436776518908934952, 0.99882560297822420292 },
	{ 0.99890249595015623285, 0.00041432008147326767093, 0.9988256506619398456 },
	{ 0.99890254363387209757, 0.00041427239775744805232, 0.99882569834565548827 },
	{ 0.9989028058943091315, 0.00041424855589953856827, 0.99882596060609241118 },
	{ 0.99890285357802510724, 0.00041420087218371688968, 0.99882600828980816488 },
	{ 0.99890290126174097196, 0.00041415318846789727107, 0.99882605597352380755 },
	{ 0.99890294894545683668, 0.00041410550475207765246, 0.99882610365723933921 },
	{ 0.99890321120589387061, 0.00041408166289416816841, 0.99882636591767626211 },
	{ 0.99890325888960984635, 0.00041403397917834648982, 0.99882641360139201581 },
	{ 0.99890337809889939713, 0.00041401013732043700577, 0.99882658049439709824 },
	{ 0.99890342578261526185, 0.00041396245360461532718, 0.99882662817811285194 },
	{ 0.99890347346633112657, 0.00041391476988879570857, 0.9988266758618283836 },
	{ 0.9989037357267681605, 0.00041389092803088622452, 0.9988269381222653065 },
	{ 0.99890378341048413624, 0.00041384324431506454593, 0.9988269858059810602 },
	{ 0.99890383109420000096, 0.00041379556059924492732, 0.99882703348969670287 },
	{ 0.99890399798720530544, 0.00041377171874133544327, 0.99882724806641765003 },
	{ 0.99890404567092128119, 0.00041372403502551376468, 0.99882729575013340373 },
	{ 0.99890426024764256141, 0.00041370019316760428063, 0.99882751032685435089 },
	{ 0.99890430793135842613, 0.00041365250945178260204, 0.99882755801057010459 },
	{ 0.99890435561507429085, 0.00041360482573596298343, 0.99882760569428574726 },
	{ 0.99890452250807959533, 0.00041358098387805349938, 0.99882782027100669442 },
	{ 0.99890457019179557108, 0.00041353330016223182079, 0.9988278679547223371 },
	{ 0.9989046178755114358, 0.00041348561644641220218, 0.99882791563843797977 },
	{ 0.99890483245223271602, 0.00041346177458850271813, 0.99882813021515903795 },
	{ 0.99890488013594858074, 0.00041341409087268103954, 0.99882817789887479165 },
	{ 0.99890504702895388522, 0.00041339024901477155549, 0.99882839247559573881 },
	{ 0.99890509471266986097, 0.0004133425652989498769, 0.99882844015931138149 },
	{ 0.99890514239638572569, 0.00041329488158313025829, 0.99882848784302702416 },
	{ 0.99890540465682275961, 0.00041327103972522077424, 0.99882875010346394706 },
	{ 0.99890545234053873536, 0.00041322335600939909565, 0.99882879778717970076 },
	{ 0.99890550002425460008, 0.00041317567229357947704, 0.99882884547089534344 },
	{ 0.9989057146009758803, 0.00041315183043566999299, 0.9988290600476162906 },
	{ 0.99890576228469174502, 0.0004131041467198483144, 0.9988291077313320443 },
	{ 0.99890580996840760974, 0.00041305646300402869579, 0.99882915541504768697 },
	{ 0.99890597686141291423, 0.00041303262114611921174, 0.99882936999176863413 },
	{ 0.99890602454512888997, 0.00041298493743029753315, 0.99882941767548427681 },
	{ 0.99890607222884475469, 0.00041293725371447791454, 0.99882946535919991948 },
	{ 0.99890628680556603491, 0.00041291341185656843049, 0.99882967993592097766 },
	{ 0.99890633448928189964, 0.0004128657281407467519, 0.99882972761963673136 },
	{ 0.99890650138228720412, 0.00041284188628283726786, 0.99882994219635767852 },
	{ 0.99890654906600317986, 0.00041279420256701558926, 0.9988299898800733212 },
	{ 0.99890659674971904458, 0.00041274651885119597065, 0.99883003756378896387 },
	{ 0.99890681132644032481, 0.00041272267699328648661, 0.99883025214051002205 },
	{ 0.99890685901015618953, 0.00041267499327746480801, 0.99883029982422577575 },
	{ 0.99890690669387205425, 0.0004126273095616451894, 0.99883034750794141843 },
	{ 0.99890716895430908817, 0.00041260346770373570536, 0.99883060976837811928 },
	{ 0.99890721663802506392, 0.00041255578398791402676, 0.99883065745209376196 },
	{ 0.99890726432174092864, 0.00041250810027209440815, 0.99883070513580940464 },
	{ 0.99890743121474623312, 0.00041248425841418492411, 0.9988309197125303518 },
	{ 0.99890747889846220886, 0.00041243657469836324551, 0.99883096739624610549 },
	{ 0.99890752658217807358, 0.0004123888909825436269, 0.99883101507996163715 },
	{ 0.99890774115889935381, 0.00041236504912463414286, 0.99883122965668269533 },
	{ 0.99890778884261521853, 0.00041231736540881246426, 0.99883127734039844903 },
	{ 0.99890783652633108325, 0.00041226968169299284565, 0.9988313250241140917 },
	{ 0.99890800341933649875, 0.00041224583983508336161, 0.99883153960083503886 },
	{ 0.99890805110305236347, 0.00041219815611926168301, 0.99883158728455079256 },
	{ 0.9989082656797736437, 0.00041217431426135219897, 0.99883180186127173972 },
	{ 0.99890831336348950842, 0.00041212663054553052037, 0.99883184954498749342 },
	{ 0.99890836104720537314, 0.00041207894682971090176, 0.99883189722870313609 },
	{ 0.99890857562392665336, 0.00041205510497180141772, 0.99883211180542408325 },
	{ 0.99890862330764251809, 0.00041200742125597973912, 0.99883215948913983695 },
	{ 0.99890879020064782257, 0.00041198357939807025508, 0.99883237406586078411 },
	{ 0.99890883788436379831, 0.00041193589568224857648, 0.99883242174957653781 },
	{ 0.99890888556807966303, 0.00041188821196642895787, 0.99883246943329206946 },
	{ 0.99890910014480094326, 0.00041186437010851947383, 0.99883268401001312764 },
	{ 0.99890914782851680798, 0.00041181668639269779523, 0.99883273169372888134 },
	{ 0.9989091955122326727, 0.00041176900267687817662, 0.99883277937744452402 },
	{ 0.99890936240523797718, 0.00041174516081896869258, 0.99883299395416547117 },
	{ 0.99890941008895395292, 0.00041169747710314701398, 0.99883304163788111385 },
	{ 0.99890962466567523315, 0.00041167363524523752994, 0.99883325621460217203 },
	{ 0.99890967234939109787, 0.00041162595152941585134, 0.99883330389831792573 },
	{ 0.99890972003310696259, 0.00041157826781359623273, 0.99883335158203356841 },
	{ 0.99890976771682282731, 0.00041153058409777661412, 0.99883339926574921108 },
	{ 0.99891002997725986123, 0.00041150674223986713008, 0.99883366152618602296 },
	{ 0.99891007766097583698, 0.00041145905852404545148, 0.99883370920990177666 },
	{ 0.99891019687026538776, 0.00041143521666613596744, 0.9988338761029068591 },
	{ 0.99891024455398125248, 0.00041138753295031428884, 0.99883392378662261279 },
	{ 0.9989102922376971172, 0.00041133984923449467023, 0.99883397147033814445 },
	{ 0.99891050681441839743, 0.00041131600737658518619, 0.99883418604705920263 },
	{ 0.99891055449813426215, 0.00041126832366076350759, 0.99883423373077495633 },
	{ 0.99891072139113956663, 0.00041124448180285402355, 0.99883444830749590349 },
	{ 0.99891076907485554237, 0.00041119679808703234495, 0.99883449599121165718 },
	{ 0.99891081675857140709, 0.00041114911437121272634, 0.99883454367492718884 },
	{ 0.99891103133529268732, 0.0004111252725133032423, 0.99883475825164824702 },
	{ 0.99891107901900855204, 0.0004110775887974815637, 0.99883480593536400072 },
	{ 0.99891112670272441676, 0.00041102990508166194509, 0.99883485361907964339 },
	{ 0.99891134127944569698, 0.00041100606322375246105, 0.99883506819580059055 },
	{ 0.9989113889631615617, 0.00041095837950793078245, 0.99883511587951634425 },
	{ 0.99891155585616686619, 0.00041093453765002129841, 0.99883533045623729141 },
	{ 0.99891160353988284193, 0.00041088685393419961981, 0.99883537813995304511 },
	{ 0.99891165122359870665, 0.0004108391702183800012, 0.99883542582366857676 },
	{ 0.99891186580031998687, 0.00041081532836047051716, 0.99883564040038963494 },
	{ 0.9989119134840358516, 0.00041076764464464883856, 0.99883568808410538864 },
	{ 0.99891196116775171632, 0.00041071996092882921995, 0.99883573576782103132 },
	{ 0.9989121280607570208, 0.00041069611907091973591, 0.99883595034454197847 },
	{ 0.99891217574447299654, 0.00041064843535509805731, 0.99883599802825773217 },
	{ 0.99891239032119427677, 0.00041062459349718857327, 0.99883621260497879035 },
	{ 0.99891243800491014149, 0.00041057690978136689467, 0.99883626028869443303 },
	{ 0.99891248568862600621, 0.00041052922606554727606, 0.99883630797241007571 },
	{ 0.99891270026534728643, 0.00041050538420763779202, 0.99883652254913102286 },
	{ 0.99891274794906315115, 0.00041045770049181611342, 0.99883657023284677656 },
	{ 0.99891279563277901588, 0.00041041001677599649481, 0.99883661791656241924 },
	{ 0.99891291484206856666, 0.00041038617491808701077, 0.99883678480956750168 },
	{ 0.99891296252578443138, 0.00041033849120226533217, 0.99883683249328314435 },
	{ 0.9989131771025057116, 0.00041031464934435584813, 0.99883704707000420253 },
	{ 0.99891322478622157632, 0.00041026696562853416953, 0.99883709475371995623 },
	{ 0.9989133916792268808, 0.00041024312377062468549, 0.99883730933044090339 },
	{ 0.99891343936294285655, 0.0004101954400548030069, 0.99883735701415665709 },
	{ 0.99891348704665872127, 0.00041014775633898338828, 0.99883740469787218874 },
	{ 0.99891370162338000149, 0.00041012391448107390424, 0.99883761927459324692 },
	{ 0.99891374930709586621, 0.00041007623076525222565, 0.99883766695830900062 },
	{ 0.99891379699081173094, 0.00041002854704943260703, 0.9988377146420246433 },
	{ 0.99891401156753301116, 0.00041000470519152312299, 0.99883792921874559045 },
	{ 0.99891405925124887588, 0.0004099570214757014444, 0.99883797690246134415 },
	{ 0.9989141069349647406, 0.00040990933775988182578, 0.99883802458617698683 },
	{ 0.99891427382797004508, 0.00040988549590197234174, 0.99883823916289793399 },
	{ 0.99891432151168602083, 0.00040983781218615066315, 0.99883828684661368769 },
	{ 0.99891448840469143633, 0.0004098139703282411791, 0.99883845373961888114 },
	{ 0.99891453608840730105, 0.00040976628661241950051, 0.99883850142333452382 },
	{ 0.99891470298141260553, 0.00040974244475451001646, 0.99883871600005547098 },
	{ 0.99891475066512858128, 0.00040969476103868833787, 0.99883876368377111366 },
	{ 0.9989149652418498615, 0.00040967091918077885382, 0.99883897826049217183 },
	{ 0.99891494139999192914, 0.00040959939360704698645, 0.99883890673491837475 },
	{ 0.99891506060928159094, 0.00040957555174913614715, 0.99883907362792345719 },
	{ 0.99891510829299745566, 0.00040952786803331446856, 0.99883912131163909986 },
	{ 0.99891532286971873589, 0.00040950402617540498451, 0.99883933588836015804 },
	{ 0.99891537055343460061, 0.00040945634245958330592, 0.99883938357207591174 },
	{ 0.99891541823715046533, 0.00040940865874376368731, 0.99883943125579155442 },
	{ 0.99891558513015576981, 0.00040938481688585420326, 0.99883964583251250158 },
	{ 0.99891563281387174555, 0.00040933713317003252467, 0.99883969351622825528 },
	{ 0.99891579970687716106, 0.00040931329131212304063, 0.99883986040923344873 },
	{ 0.99891584739059302578, 0.00040926560759630136203, 0.99883990809294909141 },
	{ 0.99891601428359833026, 0.00040924176573839187799, 0.99884012266967003857 },
	{ 0.998916061967314306, 0.00040919408202257019939, 0.99884017035338579227 },
	{ 0.99891627654403558623, 0.00040917024016466071535, 0.99884038493010685045 },
	{ 0.99891632422775145095, 0.00040912255644883903675, 0.99884043261382249312 },
	{ 0.99891637191146731567, 0.00040907487273301941814, 0.9988404802975381358 },
	{ 0.99891658648818859589, 0.0004090510308751099341, 0.99884069487425908296 },
	{ 0.99891663417190446062, 0.0004090033471592882555, 0.99884074255797483666 },
	{ 0.99891668185562032534, 0.00040895566344346863689, 0.99884079024169047933 },
	{ 0.99891680106490987612, 0.00040893182158555915285, 0.99884095713469556177 },
	{ 0.99891684874862574084, 0.00040888413786973747425, 0.99884100481841120445 },
	{ 0.99891706332534702106, 0.00040886029601182799021, 0.99884121939513226263 },
	{ 0.99891711100906288578, 0.00040881261229600631161, 0.99884126707884801633 },
	{ 0.99891715869277875051, 0.000408764928580186693, 0.998841314762563659 },
	{ 0.99891727790206830129, 0.00040874108672227720896, 0.99884148165556874144 },
	{ 0.99891732558578416601, 0.00040869340300645553036, 0.99884152933928438411 },
	{ 0.99891754016250544623, 0.00040866956114854604632, 0.99884174391600544229 },
	{ 0.99891758784622131095, 0.00040862187743272436772, 0.99884179159972119599 },
	{ 0.99891763552993717568, 0.00040857419371690474911, 0.99884183928343672765 },
	{ 0.9989178501066584559, 0.00040855035185899526507, 0.99884205386015778583 },
	{ 0.99891789779037432062, 0.00040850266814317358647, 0.99884210154387353953 },
	{ 0.99891794547409018534, 0.00040845498442735396786, 0.9988421492275891822 },
	{ 0.99891811236709560085, 0.00040843114256944448382, 0.99884236380431012936 },
	{ 0.99891816005081146557, 0.00040838345885362280522, 0.99884241148802588306 },
	{ 0.99891837462753274579, 0.00040835961699571332118, 0.99884262606474694124 },
	{ 0.99891842231124861051, 0.00040831193327989164258, 0.99884267374846258392 },
	{ 0.99891846999496447523, 0.00040826424956407202397, 0.99884272143217822659 },
	{ 0.99891868457168575546, 0.00040824040770616253993, 0.99884293600889928477 },
	{ 0.99891873225540162018, 0.00040819272399034086133, 0.99884298369261492745 },
	{ 0.9989187799391174849, 0.00040814504027452124272, 0.99884303137633057013 },
	{ 0.99891889914840703568, 0.00040812119841661175868, 0.99884319826933576358 },
	{ 0.99891911372512831591, 0.00040809735655870021465, 0.99884341284605682176 },
	{ 0.99891916140884418063, 0.00040804967284287853605, 0.99884346052977246444 },
	{ 0.99891920909256004535, 0.00040800198912705891744, 0.99884350821348810712 },
	{ 0.99891942366928132557, 0.0004079781472691494334, 0.9988437227902091653 },
	{ 0.99891947135299719029, 0.0004079304635533277548, 0.99884377047392480797 },
	{ 0.99891951903671305502, 0.00040788277983750813619, 0.99884381815764045065 },
	{ 0.9989196382460026058, 0.00040785893797959865215, 0.99884398505064564411 },
	{ 0.99891968592971847052, 0.00040781125426377697355, 0.99884403273436128678 },
	{ 0.99891990050643975074, 0.00040778741240586748951, 0.99884424731108234496 },
	{ 0.99891994819015561546, 0.00040773972869004581092, 0.99884429499479798764 },
	{ 0.99891999587387148019, 0.0004076920449742261923, 0.99884434267851363032 },
	{ 0.99892011508316103097, 0.00040766820311631670826, 0.99884450957151882378 },
	{ 0.99892032965988231119, 0.00040764436125840516423, 0.99884472414823988196 },
	{ 0.99892030581802437883, 0.00040757283568467329686, 0.99884465262266597385 },
	{ 0.99892042502731404063, 0.00040754899382676245756, 0.99884481951567116731 },
	{ 0.99892047271102990535, 0.00040750131011094077897, 0.99884486719938680999 },
	{ 0.99892068728775118558, 0.00040747746825303129492, 0.99884508177610786817 },
	{ 0.9989207349714670503, 0.00040742978453720961633, 0.99884512945982351084 },
	{ 0.99892085418075660108, 0.00040740594267930013228, 0.9988452963528287043 },
	{ 0.9989209018644724658, 0.00040735825896347845369, 0.99884534403654434698 },
	{ 0.99892111644119374603, 0.00040733441710556896964, 0.99884555861326540516 },
	{ 0.99892116412490961075, 0.00040728673338974729105, 0.99884560629698104783 },
	{ 0.99892121180862547547, 0.00040723904967392767244, 0.99884565398069669051 },
	{ 0.99892142638534675569, 0.00040721520781601818839, 0.99884586855741774869 },
	{ 0.99892147406906262042, 0.0004071675241001965098, 0.99884591624113339137 },
	{ 0.99892152175277848514, 0.00040711984038437689119, 0.99884596392484903404 },
	{ 0.99892164096206803592, 0.00040709599852646740714, 0.9988461308178542275 },
	{ 0.99892168864578390064, 0.00040704831481064572855, 0.99884617850156987018 },
	{ 0.99892185553878931614, 0.00040702447295273624451, 0.99884634539457506364 },
	{ 0.99892190322250518086, 0.00040697678923691456591, 0.99884639307829070631 },
	{ 0.99892195090622104559, 0.0004069291055210949473, 0.99884644076200623797 },
	{ 0.99892216548294232581, 0.00040690526366318546326, 0.99884665533872729615 },
	{ 0.99892221316665819053, 0.00040685757994736378466, 0.99884670302244304985 },
	{ 0.99892233237594774131, 0.00040683373808945430062, 0.99884686991544813228 },
	{ 0.99892238005966360603, 0.00040678605437363262202, 0.99884691759916377496 },
	{ 0.99892259463638488626, 0.00040676221251572313798, 0.99884713217588483314 },
	{ 0.99892264232010075098, 0.00040671452879990145938, 0.99884717985960058684 },
	{ 0.9989226900038166157, 0.00040666684508408184077, 0.99884722754331622951 },
	{ 0.99892290458053789592, 0.00040664300322617235673, 0.99884744212003717667 },
	{ 0.99892295226425376065, 0.00040659531951035067813, 0.99884748980375293037 },
	{ 0.99892299994796962537, 0.00040654763579453105952, 0.99884753748746857305 },
	{ 0.99892311915725917615, 0.00040652379393662157548, 0.99884770438047365548 },
	{ 0.99892333373398045637, 0.00040649995207871003145, 0.99884791895719471366 },
	{ 0.99892338141769632109, 0.00040645226836288835285, 0.99884796664091046736 },
	{ 0.99892342910141218582, 0.00040640458464706873424, 0.99884801432462611004 },
	{ 0.9989235483107017366, 0.0004063807427891592502, 0.9988481812176313035 },
	{ 0.99892359599441760132, 0.0004063330590733375716, 0.99884822890134694617 },
	{ 0.99892381057113888154, 0.00040630921721542808756, 0.99884844347806800435 },
	{ 0.99892385825485474626, 0.00040626153349960640896, 0.99884849116178364703 },
	{ 0.99892390593857061099, 0.00040621384978378679035, 0.99884853884549928971 },
	{ 0.99892407283157602649, 0.00040619000792587730631, 0.99884870573850448316 },
	{ 0.99892412051529189121, 0.00040614232421005562771, 0.99884875342222012584 },
	{ 0.99892416819900775593, 0.0004060946404942360091, 0.99884880110593576852 },
	{ 0.99892438277572903615, 0.00040607079863632652506, 0.99884901568265671568 },
	{ 0.99892443045944490088, 0.00040602311492050484646, 0.99884906336637246937 },
	{ 0.99892454966873445166, 0.00040599927306259536242, 0.99884923025937755181 },
	{ 0.99892459735245031638, 0.00040595158934677368382, 0.99884927794309319449 },
	{ 0.9989248119291715966, 0.00040592774748886419978, 0.99884949251981425267 },
	{ 0.99892485961288746132, 0.00040588006377304252119, 0.99884954020353000637 },
	{ 0.99892490729660332605, 0.00040583238005722290257, 0.99884958788724564904 },
	{ 0.99892502650589287683, 0.00040580853819931341853, 0.9988497547802508425 },
	{ 0.99892524108261415705, 0.0004057846963414018745, 0.99884996935697190068 },
	{ 0.99892528876633002177, 0.00040573701262558019591, 0.99885001704068754336 },
	{ 0.99892533645004588649, 0.0004056893289097605773, 0.99885006472440318603 },
	{ 0.998925503343051302, 0.00040566548705185109325, 0.99885023161740837949 },
	{ 0.99892555102676716672, 0.00040561780333602941466, 0.99885027930112402217 },
	{ 0.99892559871048303144, 0.00040557011962020979605, 0.99885032698483966485 },
	{ 0.99892571791977258222, 0.000405546277762300312, 0.99885049387784474728 },
	{ 0.99892576560348844694, 0.00040549859404647863341, 0.99885054156156038996 },
	{ 0.99892598018020972717, 0.00040547475218856914936, 0.99885075613828144814 },
	{ 0.99892602786392559189, 0.00040542706847274747077, 0.99885080382199720184 },
	{ 0.99892607554764145661, 0.00040537938475692785216, 0.99885085150571284451 },
	{ 0.99892629012436273683, 0.00040535554289901836811, 0.99885106608243390269 },
	{ 0.99892633780807860155, 0.00040530785918319668952, 0.99885111376614954537 },
	{ 0.99892645701736815234, 0.00040528401732528720547, 0.99885128065915473883 },
	{ 0.99892650470108401706, 0.00040523633360946552688, 0.9988513283428703815 },
	{ 0.99892667159408943256, 0.00040521249175155604283, 0.99885149523587557496 },
	{ 0.99892671927780529728, 0.00040516480803573436424, 0.99885154291959121764 },
	{ 0.998926766961521162, 0.00040511712431991474563, 0.99885159060330674929 },
	{ 0.99892698153824244223, 0.00040509328246200526158, 0.99885180518002780747 },
	{ 0.99892702922195830695, 0.00040504559874618358299, 0.99885185286374356117 },
	{ 0.99892714843124785773, 0.00040502175688827409894, 0.99885201975674875463 },
	{ 0.99892719611496372245, 0.00040497407317245242035, 0.99885206744046439731 },
	{ 0.99892741069168500267, 0.0004049502313145429363, 0.99885228201718545549 },
	{ 0.9989274583754008674, 0.00040490254759872125771, 0.99885232970090109816 },
	{ 0.99892750605911673212, 0.0004048548638829016391, 0.99885237738461674084 },
	{ 0.99892767295212214762, 0.00040483102202499215505, 0.9988525442776219343 },
	{ 0.99892772063583801234, 0.00040478333830917047646, 0.99885259196133757698 },
	{ 0.99892783984512756312, 0.00040475949645126099241, 0.99885275885434265941 },
	{ 0.99892788752884342784, 0.00040471181273543931382, 0.99885280653805830209 },
	{ 0.99892810210556470807, 0.00040468797087752982978, 0.99885302111477947129 },
	{ 0.99892814978928057279, 0.00040464028716170815118, 0.99885306879849511397 },
	{ 0.99892819747299643751, 0.00040459260344588853257, 0.99885311648221075664 },
	{ 0.99892836436600185301, 0.00040456876158797904853, 0.9988532833752159501 },
	{ 0.99892841204971771774, 0.00040452107787215736993, 0.99885333105893159278 },
	{ 0.99892853125900726852, 0.00040449723601424788589, 0.99885349795193667521 },
	{ 0.99892857894272313324, 0.00040444955229842620729, 0.99885354563565231789 },
	{ 0.99892879351944441346, 0.00040442571044051672325, 0.99885376021237337607 },
	{ 0.99892884120316027818, 0.00040437802672469504465, 0.99885380789608912977 },
	{ 0.99892888888687614291, 0.00040433034300887542604, 0.99885385557980477245 },
	{ 0.99892905577988155841, 0.000404306501150965942, 0.9988540224728099659 },
	{ 0.99892910346359742313, 0.0004042588174351442634, 0.99885407015652560858 },
	{ 0.99892922267288697391, 0.00040423497557723477936, 0.99885423704953069102 },
	{ 0.99892927035660283863, 0.00040418729186141310076, 0.99885428473324633369 },
	{ 0.99892948493332411886, 0.00040416345000350361672, 0.99885449930996739187 },
	{ 0.99892953261703998358, 0.00040411576628768193812, 0.99885454699368314557 },
	{ 0.9989295803007558483, 0.00040406808257186231951, 0.99885459467739878825 },
	{ 0.9989297471937612638, 0.00040404424071395283547, 0.99885476157040398171 },
	{ 0.99892979487747712852, 0.00040399655699813115687, 0.99885480925411962438 },
	{ 0.9989299140867666793, 0.00040397271514022167283, 0.99885497614712470682 },
	{ 0.99892996177048254403, 0.00040392503142439999423, 0.9988550238308403495 },
	{ 0.99893017634720382425, 0.00040390118956649051019, 0.99885523840756140768 },
	{ 0.99893022403091968897, 0.00040385350585066883159, 0.99885528609127716138 },
	{ 0.99893027171463555369, 0.00040380582213484921298, 0.99885533377499280405 },
	{ 0.99893048629135683392, 0.00040378198027693972894, 0.99885554835171386223 },
	{ 0.99893053397507269864, 0.00040373429656111805034, 0.99885559603542950491 },
	{ 0.9989306055006463847, 0.0004037104547032085663, 0.99885571524471883365 },
	{ 0.99893065318436224942, 0.0004036627709873868877, 0.9988557629284343653 },
	{ 0.99893086776108352964, 0.00040363892912947740366, 0.9988559775051555345 },
	{ 0.99893091544479939436, 0.00040359124541365572507, 0.99885602518887117718 },
	{ 0.99893096312851525909, 0.00040354356169783610645, 0.99885607287258681986 },
	{ 0.99893113002152067459, 0.00040351971983992662241, 0.99885623976559201331 },
	{ 0.99893117770523653931, 0.00040347203612410494382, 0.99885628744930765599 },
	{ 0.99893129691452609009, 0.00040344819426619545977, 0.99885645434231273843 },
	{ 0.99893134459824195481, 0.00040340051055037378118, 0.99885650202602849212 },
	{ 0.99893155917496323504, 0.00040337666869246429713, 0.9988567166027495503 },
	{ 0.99893160685867909976, 0.00040332898497664261854, 0.99885676428646519298 },
	{ 0.99893177375168440424, 0.00040330514311873313449, 0.99885693117947038644 },
	{ 0.99893182143540037998, 0.0004032574594029114559, 0.99885697886318602912 },
	{ 0.9989318691191162447, 0.00040320977568709183729, 0.99885702654690167179 },
	{ 0.99893198832840579549, 0.00040318593382918235324, 0.99885719343990686525 },
	{ 0.99893203601212166021, 0.00040313825011336067465, 0.99885724112362250793 },
	{ 0.99893220290512707571, 0.0004031144082554511906, 0.99885740801662770139 },
	{ 0.99893225058884294043, 0.00040306672453962951201, 0.99885745570034334406 },
	{ 0.99893246516556422065, 0.00040304288268172002796, 0.99885767027706429122 },
	{ 0.99893251284928008538, 0.00040299519896589834937, 0.99885771796078004492 },
	{ 0.99893263205856963616, 0.00040297135710798886532, 0.99885788485378523838 },
	{ 0.99893267974228550088, 0.00040292367339216718673, 0.99885793253750088105 },
	{ 0.99893284663529091638, 0.00040289983153425770268, 0.99885809943050607451 },
	{ 0.9989328943190067811, 0.00040285214781843602409, 0.99885814711422171719 },
	{ 0.99893294200272264582, 0.00040280446410261640548, 0.99885819479793735987 },
	{ 0.99893315657944392605, 0.00040278062224470692143, 0.99885840937465841805 },
	{ 0.99893320426315979077, 0.00040273293852888524284, 0.99885845705837406072 },
	{ 0.99893327578873347683, 0.0004027090966709757588, 0.99885857626766338946 },
	{ 0.99893332347244934155, 0.0004026614129551540802, 0.99885862395137892111 },
	{ 0.99893353804917062178, 0.00040263757109724459616, 0.99885883852809997929 },
	{ 0.9989335857328864865, 0.00040258988738142291756, 0.99885888621181573299 },
	{ 0.99893363341660235122, 0.00040254220366560329895, 0.99885893389553137567 },
	{ 0.99893380030960776672, 0.00040251836180769381491, 0.99885910078853656913 },
	{ 0.99893384799332363144, 0.00040247067809187213631, 0.9988591484722522118 },
	{ 0.99893396720261318222, 0.00040244683623396265227, 0.99885931536525740526 },
	{ 0.99893401488632904694, 0.00040239915251814097367, 0.99885936304897304794 },
	{ 0.99893418177933446245, 0.00040237531066023148963, 0.9988595299419782414 },
	{ 0.99893422946305032717, 0.00040232762694440981103, 0.99885957762569388407 },
	{ 0.99893427714676619189, 0.00040227994322859019242, 0.99885962530940941573 },
	{ 0.99893449172348747211, 0.00040225610137068070838, 0.99885983988613047391 },
	{ 0.99893453940720333684, 0.00040220841765485902978, 0.99885988756984622761 },
	{ 0.9989346109327770229, 0.00040218457579694954574, 0.99886000677913555634 },
	{ 0.99893465861649288762, 0.00040213689208112786714, 0.998860054462851088 },
	{ 0.99893487319321416784, 0.0004021130502232183831, 0.99886026903957214618 },
	{ 0.99893492087693003256, 0.0004020653665073967045, 0.99886031672328789988 },
	{ 0.99893513545365131279, 0.00040204152464948722046, 0.99886053130000895806 },
	{ 0.99893518313736717751, 0.00040199384093366554186, 0.99886057898372460073 },
	{ 0.99893525466294086357, 0.00040196999907575605782, 0.99886069819301392947 },
	{ 0.99893530234665672829, 0.00040192231535993437922, 0.99886074587672957215 },
	{ 0.99893551692337800851, 0.00040189847350202489518, 0.99886096045345063033 },
	{ 0.99893556460709387324, 0.00040185078978620321659, 0.998861008137166273 },
	{ 0.99893563613266755929, 0.00040182694792829373254, 0.99886112734645560174 },
	{ 0.99893568381638342402, 0.00040177926421247205395, 0.99886117503017113339 },
	{ 0.99893589839310470424, 0.0004017554223545625699, 0.9988613896068923026 },
	{ 0.99893587455124677188, 0.00040168389678083070253, 0.99886131808131839449 },
	{ 0.9989360414442522984, 0.00040166005492291986323, 0.99886148497432358795 },
	{ 0.99893608912796816313, 0.00040161237120709818464, 0.99886153265803923063 },
	{ 0.99893620833725771391, 0.00040158852934918870059, 0.99886169955104442408 },
	{ 0.99893625602097357863, 0.000401540845633367022, 0.99886174723476006676 },
	{ 0.99893642291397899413, 0.00040151700377545753795, 0.99886191412776526022 },
	{ 0.99893647059769485885, 0.00040146932005963585936, 0.9988619618114809029 },
	{ 0.99893658980698440963, 0.00040144547820172637531, 0.99886212870448609635 },
	{ 0.99893680438370568986, 0.00040142163634381483129, 0.99886234328120715453 },
	{ 0.9989367328581320038, 0.00040135011077008296392, 0.99886222407191738171 },
	{ 0.99893685206742155458, 0.00040132626891217212462, 0.99886239096492246414 },
	{ 0.9989370666441428348, 0.00040130242705426058059, 0.99886260554164363334 },
	{ 0.99893711432785869953, 0.00040125474333843890199, 0.99886265322535927602 },
	{ 0.99893718585343238558, 0.00040123090148052941795, 0.99886277243464860476 },
	{ 0.99893723353714825031, 0.00040118321776470773935, 0.99886282011836413641 },
	{ 0.99893744811386953053, 0.00040115937590679825531, 0.99886303469508530561 },
	{ 0.99893749579758539525, 0.00040111169219097657672, 0.99886308237880094829 },
	{ 0.99893766269059081075, 0.00040108785033306709267, 0.99886324927180614175 },
	{ 0.99893771037430667548, 0.00040104016661724541408, 0.99886329695552178443 },
	{ 0.9989377580580225402, 0.00040099248290142579547, 0.9988633446392374271 },
	{ 0.99893782958359622626, 0.00040096864104351631142, 0.99886346384852675584 },
	{ 0.99893804416031750648, 0.00040094479918560476739, 0.998863678425247703 },
	{ 0.9989380918440333712, 0.0004008971154697830888, 0.9988637261089634567 },
	{ 0.99893813952774923592, 0.00040084943175396347019, 0.99886377379267909937 },
	{ 0.99893830642075465143, 0.00040082558989605398614, 0.99886394068568429283 },
	{ 0.99893835410447051615, 0.00040077790618023230755, 0.99886398836939993551 },
	{ 0.99893840178818638087, 0.00040073022246441268894, 0.99886403605311557818 },
	{ 0.99893856868119179637, 0.00040070638060650320489, 0.99886420294612077164 },
	{ 0.99893861636490766109, 0.0004006586968906815263, 0.99886425062983641432 },
	{ 0.99893873557419721188, 0.00040063485503277204225, 0.99886441752284149675 },
	{ 0.9989387832579130766, 0.00040058717131695036366, 0.99886446520655725045 },
	{ 0.9989389501509184921, 0.00040056332945904087961, 0.99886463209956244391 },
	{ 0.99893899783463435682, 0.00040051564574321920102, 0.99886467978327808659 },
	{ 0.99893921241135563704, 0.00040049180388530971697, 0.99886489435999903375 },
	{ 0.99893926009507150177, 0.00040044412016948803838, 0.99886494204371478745 },
	{ 0.99893933162064518783, 0.00040042027831157855433, 0.99886506125300411618 },
	{ 0.99893937930436105255, 0.00040037259459575687574, 0.99886510893671964784 },
	{ 0.99893959388108233277, 0.0004003487527378473917, 0.99886532351344081704 },
	{ 0.99893964156479819749, 0.0004003010690220257131, 0.99886537119715645971 },
	{ 0.99893980845780350197, 0.00040027722716411622906, 0.99886553809016165317 },
	{ 0.99893985614151947772, 0.00040022954344829455046, 0.99886558577387729585 },
	{ 0.99893990382523534244, 0.00040018185973247493185, 0.99886563345759293853 },
	{ 0.9989399753508090285, 0.00040015801787456544781, 0.99886575266688226726 },
	{ 0.99894018992753030872, 0.00040013417601665390378, 0.99886596724360321442 },
	{ 0.99894023761124617344, 0.00040008649230083222518, 0.99886601492731896812 },
	{ 0.99894028529496203817, 0.00040003880858501260657, 0.9988660626110346108 },
	{ 0.99894045218796745367, 0.00040001496672710312253, 0.99886622950403980425 },
	{ 0.99894049987168331839, 0.00039996728301128144393, 0.99886627718775544693 },
	{ 0.99894057139725700445, 0.00039994344115337195989, 0.99886639639704477567 },
	{ 0.99894061908097286917, 0.00039989575743755028129, 0.99886644408076030732 },
	{ 0.99894083365769414939, 0.00039987191557964079725, 0.9988666586574813655 },
	{ 0.99894088134141001412, 0.00039982423186381911865, 0.9988667063411971192 },
	{ 0.99894104823441542962, 0.00039980039000590963461, 0.99886687323420231266 },
	{ 0.99894109591813129434, 0.00039975270629008795601, 0.99886692091791795534 },
	{ 0.99894114360184715906, 0.0003997050225742683374, 0.99886696860163359801 },
	{ 0.99894131049485257456, 0.00039968118071635885336, 0.99886713549463879147 },
	{ 0.99894135817856843929, 0.00039963349700053717476, 0.99886718317835443415 },
	{ 0.99894147738785799007, 0.00039960965514262769072, 0.99886735007135962761 },
	{ 0.99894164428086340557, 0.00039958581328471614669, 0.99886751696436482106 },
	{ 0.99894169196457927029, 0.0003995381295688944681, 0.99886756464808046374 },
	{ 0.99894173964829513501, 0.00039949044585307484949, 0.99886761233179610642 },
	{ 0.99894190654130055051, 0.00039946660399516536544, 0.99886777922480129988 },
	{ 0.99894195422501641524, 0.00039941892027934368685, 0.99886782690851694255 },
	{ 0.99894200190873227996, 0.00039937123656352406824, 0.99886787459223258523 },
	{ 0.99894216880173758444, 0.00039934739470561458419, 0.99886804148523777869 },
	{ 0.99894228801102724624, 0.00039932355284770304016, 0.99886820837824286112 },
	{ 0.99894233569474311096, 0.00039927586913188136157, 0.99886825606195861482 },
	{ 0.99894238337845897568, 0.00039922818541606174296, 0.9988683037456742575 },
	{ 0.99894255027146439119, 0.00039920434355815225891, 0.99886847063867945096 },
	{ 0.99894259795518025591, 0.00039915665984233058032, 0.99886851832239509363 },
	{ 0.99894276484818556039, 0.00039913281798442109627, 0.99886868521540028709 },
	{ 0.99894281253190153613, 0.00039908513426859941768, 0.99886873289911592977 },
	{ 0.99894293174119108691, 0.00039906129241068993363, 0.99886889979212112323 },
	{ 0.99894297942490695164, 0.00039901360869486825504, 0.9988689474758367659 },
	{ 0.99894314631791236714, 0.00039898976683695877099, 0.99886911436884195936 },
	{ 0.99894319400162823186, 0.0003989420831211370924, 0.99886916205255760204 },
	{ 0.99894336089463353634, 0.00039891824126322760835, 0.9988693289455627955 },
	{ 0.99894340857834951208, 0.00039887055754740592976, 0.99886937662927843817 },
	{ 0.99894345626206537681, 0.00039882287383158631115, 0.99886942431299408085 },
	{ 0.99894362315507068129, 0.0003987990319736768271, 0.99886959120599927431 },
	{ 0.99894374236436034309, 0.00039877519011576528308, 0.99886975809900435674 },
	{ 0.99894379004807620781, 0.00039872750639994360448, 0.99886980578272011044 },
	{ 0.99894395694108151229, 0.00039870366454203412044, 0.9988699726757253039 },
	{ 0.99894400462479748803, 0.00039865598082621244184, 0.99887002035944094658 },
	{ 0.99894405230851335276, 0.00039860829711039282323, 0.99887006804315658925 },
	{ 0.99894412383408703882, 0.00039858445525248333919, 0.99887018725244591799 },
	{ 0.99894433841080831904, 0.00039856061339457179516, 0.99887040182916686515 },
	{ 0.99894438609452418376, 0.00039851292967875011656, 0.99887044951288261885 },
	{ 0.99894445762009786982, 0.00039848908782084063252, 0.99887056872217194758 },
	{ 0.9989445291456716669, 0.00039841756224710876515, 0.9988705448803139042 },
	{ 0.99894460067124546399, 0.00039839372038919792585, 0.99887066408960323294 },
	{ 0.99894471988053501477, 0.00039836987853128638182, 0.99887083098260831537 },
	{ 0.99894493445725629499, 0.00039834603667337483779, 0.99887104555932948458 },
	{ 0.99894498214097215971, 0.0003982983529575531592, 0.99887109324304512725 },
	{ 0.99894514903397746419, 0.00039827451109964367515, 0.99887126013605032071 },
	{ 0.99894519671769343994, 0.00039822682738382199656, 0.99887130781976596339 },
	{ 0.99894524440140930466, 0.00039817914366800237795, 0.99887135550348160606 },
	{ 0.99894541129441472016, 0.0003981553018100928939, 0.99887152239648679952 },
	{ 0.99894541129441472016, 0.00039815530181009153865, 0.99887152239648679952 },
	{ 0.99894553050370438196, 0.00039808377623636102653, 0.99887168928949199298 },
	{ 0.99894553050370438196, 0.00039808377623636037601, 0.99887168928949199298 },
	{ 0.99894553050370438196, 0.00039808377623636037601, 0.99887168928949199298 },
	{ 0.99894553050370438196, 0.00039808377623636037601, 0.99887168928949199298 },
	{ 0.99894553050370438196, 0.00039808377623636037601, 0.99887168928949199298 },
	{ 0.99894553050370438196, 0.00039808377623636037601, 0.99887168928949199298 },
	{ 0.99894553050370438196, 0.00039808377623636037601, 0.99887168928949199298 },
	{ 0.99894553050370438196, 0.00039808377623636037601, 0.99887168928949199298 },
	{ 0.99894627884808995244, 0.00039778230081874638505, 0.99887246271575058643 },
	{ 0.99894637853070722411, 0.00039774765726405887818, 0.99887257148039887422 },
	{ 0.99894648535329333416, 0.00039771349779445431703, 0.99887269091437391744 },
	{ 0.99894657375661355392, 0.00039767592455226678013, 0.99887278561652226294 },
	{ 0.99894669829579818554, 0.00039764183946925887349, 0.99887290881903678663 },
	{ 0.99894675418874256945, 0.0003976000639565635303, 0.99887297145026232581 },
	{ 0.99894685585118758731, 0.00039756211763698344648, 0.9988730737398435755 },
	{ 0.99894695361405816403, 0.00039752974745113129782, 0.99887318624156007374 },
	{ 0.99894705199090449987, 0.00039749288488704438487, 0.99887328696215649249 },
	{ 0.99894716645928827159, 0.00039746172949153656248, 0.99887341692126296877 },
	{ 0.99894722559319959476, 0.00039741837927180999855, 0.99887347576220508749 },
	{ 0.99894735600606421322, 0.00039738725878078214439, 0.99887361731474877402 },
	{ 0.99894741469594472427, 0.00039734437090236421038, 0.99887367270873061997 },
	{ 0.99894752906362038747, 0.00039731013017970794477, 0.99887379498656259091 },
	{ 0.99894761999379610984, 0.0003972807966836142254, 0.99887391455443363952 },
	{ 0.99894771312123742391, 0.00039723835283595794075, 0.99887399603636717327 },
	{ 0.99894781260701626113, 0.00039720341173488370743, 0.9988741043844506784 },
	{ 0.99894791014729944489, 0.00039716922594386811244, 0.99887421624358152528 },
	{ 0.99894803037206147955, 0.00039713645235378027508, 0.99887433976881956355 },
	{ 0.99894809702474096635, 0.00039709414812404391758, 0.99887440807860361502 },
	{ 0.99894819718171579126, 0.00039706044126826994019, 0.99887451753619183048 },
	{ 0.99894827383882012217, 0.00039702091795284024951, 0.99887460074847223002 },
	{ 0.99894837100001754315, 0.00039698677421886192354, 0.99887470751126283819 },
	{ 0.99894850021068060109, 0.00039695576301891080055, 0.99887485022595401407 },
	{ 0.99894860847493616163, 0.00039691889101344814648, 0.9988749542896556699 },
	{ 0.99894867654439423177, 0.00039688105226833090937, 0.99887503437083247082 },
	{ 0.998948773846640381, 0.00039684454103786206492, 0.9988751364338207539 },
	{ 0.99894886747275812855, 0.00039681019531566364376, 0.99887524245961178959 },
	{ 0.99894894976035564227, 0.00039676936279613232413, 0.99887532298939696318 },
	{ 0.9989490500506541526, 0.00039673094383556100836, 0.99887542075283997089 },
	{ 0.9989491630267283151, 0.00039670007225352975832, 0.99887554647305476507 },
	{ 0.99894926749183132753, 0.00039666620117503865019, 0.9988756650029466666 },
	{ 0.99894933071128333424, 0.00039662601639110306798, 0.99887573026402454168 },
	{ 0.9989494501406808169, 0.00039659807106334418747, 0.99887587340786931911 },
	{ 0.99894951748687221826, 0.00039655408912975042635, 0.99887593628628734699 },
	{ 0.99894963031646222262, 0.00039651801735240667585, 0.99887604662564277724 },
	{ 0.99894972634612544393, 0.00039648596474010190183, 0.99887616440823556729 },
	{ 0.99894984207393144882, 0.00039645206104594904895, 0.9988762821513463841 },
	{ 0.9989499361901422736, 0.00039641302296001152414, 0.99887637363083869868 },
	{ 0.99895001628047419562, 0.0003963758525498552285, 0.9988764643412879618 },
	{ 0.99895011222773977266, 0.00039634054981548016202, 0.99887656907761601666 },
	{ 0.99895020963984915152, 0.00039630788379985517136, 0.99887668318894418107 },
	{ 0.99895028913566052964, 0.00039626435333568277384, 0.99887675254757912757 },
	{ 0.99895037727805569006, 0.00039622929321605381741, 0.99887684978116075829 },
	{ 0.99895046694823674827, 0.0003961937146790665029, 0.99887695001881626755 },
	{ 0.99895055916930619588, 0.00039615605903941804138, 0.99887704403431898381 },
	{ 0.99895069491969534781, 0.00039612678791362454424, 0.99887719285271647784 },
	{ 0.99895077178737112789, 0.00039609071613628079375, 0.99887728202507974906 },
	{ 0.99895086972075874954, 0.00039605004326183004945, 0.99887737181027425049 },
	{ 0.99895098100997370416, 0.0003960202909119765486, 0.9988775011491110023 },
	{ 0.9989510664286748165, 0.00039598211342174217692, 0.99887758737347631666 },
	{ 0.99895115827437797051, 0.00039594388099986713462, 0.9988776803910544011 },
	{ 0.99895125252791783232, 0.0003959108762391249552, 0.99887779189312952965 },
	{ 0.99895133869964014561, 0.00039587204185802141003, 0.99887788291256907058 },
	{ 0.99895144295503035536, 0.00039583598295528089851, 0.99887798720000275932 },
	{ 0.99895154519196871501, 0.00039580275846797619921, 0.99887810230925588861 },
	{ 0.99895161493512518724, 0.00039576129366237312651, 0.99887817129595790622 },
	{ 0.998951743055738417, 0.00039573011251765871773, 0.99887830593970361459 },
	{ 0.99895181508027441897, 0.00039569342733699464218, 0.99887839354651530854 },
	{ 0.99895191974450481265, 0.00039565240598994866296, 0.99887848156416969569 },
	{ 0.99895203135100740788, 0.0003956215884812511142, 0.99887860775960057858 },
	{ 0.99895212433654201334, 0.00039558534733134874221, 0.99887870898488129168 },
	{ 0.99895220581933408255, 0.00039555145021754863424, 0.99887880863974654044 },
	{ 0.99895230044824034898, 0.00039551424318629864853, 0.9988789061983404105 },
	{ 0.99895240898400683438, 0.00039548096376735338703, 0.99887902478659718053 },
	{ 0.99895249302941713232, 0.00039544474550563460521, 0.99887911857321820541 },
	{ 0.99895258592339897241, 0.00039540707613307593538, 0.99887921117423150719 },
	{ 0.9989526600290433711, 0.00039536971060115459449, 0.99887929857905466413 },
	{ 0.99895275929051796648, 0.00039533508535701390556, 0.99887940179560741338 },
	{ 0.99895285873280914579, 0.00039530152441341029519, 0.9988795172870931216 },
	{ 0.99895295637151160228, 0.00039526108785945522107, 0.99887960323908886462 },
	{ 0.99895304857198141679, 0.0003952280121453438308, 0.99887971176341139312 },
	{ 0.99895316314107307498, 0.00039519529119807816952, 0.99887983622019826946 },
	{ 0.9989532308534754268, 0.00039515445867854684988, 0.99887990598338183279 },
	{ 0.99895335413838748373, 0.00039512594915706243095, 0.9988800445759112856 },
	{ 0.99895342834187850212, 0.00039508298345882029035, 0.99888011046641411728 },
	{ 0.99895352231160505774, 0.00039504716802913274979, 0.99888021161387507973 },
	{ 0.99895361152058936849, 0.00039500864263850769906, 0.99888030287364071302 },
	{ 0.9989537026707777656, 0.00039497748409587462963, 0.99888041206486755108 },
	{ 0.9989538099339614341, 0.00039493994747478083701, 0.99888051859562909662 },
	{ 0.99895389581643434518, 0.00039490487104732114373, 0.99888061679022832617 },
	{ 0.99895402002831779065, 0.00039487307249385435615, 0.99888074716361097138 },
	{ 0.99895410709697085583, 0.00039483664509135801574, 0.99888084209778849054 },
	{ 0.99895419023829756799, 0.00039479693638164116334, 0.99888092129777006356 },
	{ 0.99895428633004468288, 0.00039476504198390554787, 0.99888104004424138616 },
	{ 0.99895435023385337203, 0.0003947216459878118036, 0.99888109801543267796 },
	{ 0.99895447381173430035, 0.00039469148851710867537, 0.99888123144438756285 },
	{ 0.99895456382638281312, 0.00039465713793117112272, 0.99888133727934846906 },
	{ 0.99895461238366423107, 0.00039461315370875897548, 0.99888138304884921403 },
	{ 0.9989547338192111825, 0.00039458429628688398592, 0.99888151971877114921 },
	{ 0.99895485585671728312, 0.00039455138079005772685, 0.9988816463751127861 },
	{ 0.99895492680779773842, 0.00039451273409205967532, 0.99888172285140053308 },
	{ 0.9989550356462606473, 0.00039447653814631987359, 0.99888183194621116279 },
	{ 0.99895511954518645403, 0.0003944407593377260773, 0.99888192565958999758 },
	{ 0.99895522146655391094, 0.00039440483433085955474, 0.99888203111832640779 },
	{ 0.99895531871930420831, 0.00039436831137019669148, 0.99888213191130648116 },
	{ 0.99895541327039061308, 0.00039433798452693499597, 0.99888224650328660825 },
	{ 0.99895549485303236636, 0.0003942967766411927975, 0.99888232079833050303 },
	{ 0.99895560726147947239, 0.00039426412893611473319, 0.99888244723265673386 },
	{ 0.99895569947339357686, 0.00039422963186580220344, 0.9988825433996489922 },
	{ 0.99895577521153744449, 0.00039419112135249652698, 0.99888262594931642724 },
	{ 0.99895586422711657448, 0.00039415230871516740603, 0.99888271477721246594 },
	{ 0.99895599908744137085, 0.00039412349277812512962, 0.99888285997612957789 },
	{ 0.99895606831561367667, 0.00039408073707896740853, 0.99888292633069042381 },
	{ 0.99895618239032080155, 0.00039405367409068615958, 0.99888306413586624988 },
	{ 0.99895624406024274844, 0.00039401075416881109091, 0.99888312316906946453 },
	{ 0.9989563466462261232, 0.00039398027283031009397, 0.99888324385731708244 },
	{ 0.99895644670878724902, 0.00039394342743236088721, 0.99888334692280789096 },
	{ 0.99895655759745916047, 0.00039391193329173587604, 0.99888346630757340883 },
	{ 0.99895661658259726767, 0.00039386966568309320861, 0.99888352903264054916 },
	{ 0.99895674856501903704, 0.00039383934341746817693, 0.99888366511662474156 },
	{ 0.99895681135102598613, 0.00039380069357234482414, 0.99888373799803720221 },
	{ 0.99895691959725718689, 0.00039376579710322860521, 0.99888385217917430303 },
	{ 0.9989570190967688168, 0.0003937303845055723059, 0.99888395541403762756 },
	{ 0.99895708687898043809, 0.00039369085546809667701, 0.99888402888167382443 },
	{ 0.99895721959267991252, 0.00039366147734004483484, 0.99888416832907667153 },
	{ 0.99895727966729541691, 0.00039361994215327726979, 0.99888423137915594019 },
	{ 0.99895739326592825069, 0.00039358969312983978087, 0.998884356403569873 },
	{ 0.99895750310288788931, 0.00039355699621516682151, 0.99888447645094824434 },
	{ 0.99895755738908165178, 0.0003935142548211238646, 0.99888453072798677468 },
	{ 0.99895767085267406227, 0.00039348573843318434152, 0.99888466360075900408 },
	{ 0.99895775918160778506, 0.00039344360700923415759, 0.99888474077856947986 },
	{ 0.99895787350350717659, 0.00039341554609614826869, 0.99888487798865244205 },
	{ 0.99895794322549169575, 0.00039337397657710523706, 0.99888494414923589826 },
	{ 0.99895804812661492811, 0.0003933390949853083924, 0.99888505355475343261 },
	{ 0.99895812065526323753, 0.00039330124422389483143, 0.99888513239596288251 },
	{ 0.99895826220723449307, 0.00039327148729640455833, 0.9988852755867283495 },
	{ 0.99895834003163619386, 0.00039323455950099437273, 0.99888536463549526534 },
	{ 0.9989584276847962574, 0.00039320018774348711437, 0.99888546763403784912 },
	{ 0.99895851053086548443, 0.00039316328283626051894, 0.99888555503943321501 },
	{ 0.99895856967049867503, 0.00039312426649409736414, 0.99888562371199485224 },
	{ 0.99895868142892130237, 0.00039308999830562073611, 0.9988857384001050832 },
	{ 0.9989588169784664462, 0.00039306079641658261958, 0.99888588562491276157 },
	{ 0.99895891175385709282, 0.00039302783743220756629, 0.99888599124014698649 },
	{ 0.99895898541260941261, 0.00039298752218562560141, 0.99888606538412894054 },
	{ 0.99895907802735561809, 0.00039295115743953184248, 0.99888616078207803639 },
	{ 0.99895917229005093407, 0.00039291739279109436089, 0.99888626573813266152 },
	{ 0.99895925457764866984, 0.0003928808083184380821, 0.99888635498373812283 },
	{ 0.99895936797028783705, 0.00039284590383845753884, 0.99888646731436547821 },
	{ 0.99895947065068468884, 0.00039281199442225874776, 0.99888658018915932324 },
	{ 0.9989595453505631939, 0.0003927700812943595585, 0.99888664536469273791 },
	{ 0.99895962831565099371, 0.00039274043651896890436, 0.99888675857880404596 },
	{ 0.99895973081809241734, 0.00039270414501506257978, 0.9988868602023391885 },
	{ 0.9989598404936904652, 0.00039266989055949616007, 0.99888697251465619065 },
	{ 0.99895993373900626722, 0.00039263617740947179702, 0.99888707963936629319 },
	{ 0.9989600162234423264, 0.00039260149265605382785, 0.99888717595742049227 },
	{ 0.99896009468585245106, 0.00039255922218638832685, 0.99888724266903694549 },
	{ 0.99896020637103288831, 0.00039252832313853682281, 0.9988873673913268858 },
	{ 0.99896031047135547265, 0.00039249552236873087386, 0.99888748034880447957 },
	{ 0.99896040984269340868, 0.00039246093374568398341, 0.99888758561613844034 },
	{ 0.99896046843415453598, 0.00039241882177668983758, 0.99888764371779248386 },
	{ 0.99896056691743084777, 0.00039238841711360393548, 0.99888776206801221935 },
	{ 0.99896067025471857459, 0.00039235014635402142708, 0.99888786322748945867 },
	{ 0.99896073443318511575, 0.00039231127306300575151, 0.99888793128779218566 },
	{ 0.99896084473591939545, 0.00039227714220363071873, 0.99888804832880784268 },
	{ 0.99896094108601707351, 0.00039224539171534944342, 0.9988881550060537684 },
	{ 0.9989610380718341176, 0.00039220962148982447312, 0.99888825650542045764 },
	{ 0.99896112618218568802, 0.00039217292715388696149, 0.99888834871733456211 },
	{ 0.99896121995049613762, 0.00039214101187068378272, 0.99888846021025456956 },
	{ 0.99896133178673884867, 0.0003921070870049610615, 0.9988885747747686672 },
	{ 0.99896140588952198058, 0.00039206718832332038355, 0.99888864741270833036 },
	{ 0.99896152603789467594, 0.00039203795238810905128, 0.99888878299115002601 },
	{ 0.99896159604140410959, 0.00039200248256999385785, 0.99888886796353171249 },
	{ 0.99896167850409611777, 0.00039196252094584829338, 0.998888943829849274 },
	{ 0.99896179451972100249, 0.00039193088032084825089, 0.99888906922047426828 },
	{ 0.99896188299628352336, 0.00039189279438334823991, 0.99888915886891171958 },
	{ 0.998961969609747924, 0.0003918580546982895459, 0.9988892542165068722 },
	{ 0.99896207191077335263, 0.00039181764332133633966, 0.99888934252827454863 },
	{ 0.99896216606360521695, 0.00039178699146586755528, 0.99888945726216116228 },
	{ 0.99896225402747240718, 0.00039175278736430508815, 0.99888955987446581553 },
	{ 0.99896233664465983182, 0.00039171704517680509035, 0.99888964835102833639 },
	{ 0.99896247403784821373, 0.0003916854320176254645, 0.9988897876302031964 },
	{ 0.99896253057623940474, 0.00039164936481791837782, 0.99888985816700748277 },
	{ 0.99896264263678635764, 0.00039161201130229336079, 0.99888996407521046805 },
	{ 0.99896270874701587061, 0.00039157792621928550836, 0.99889005389759810694 },
	{ 0.99896281970892997215, 0.00039154064594584797989, 0.99889015519154344958 },
	{ 0.99896293707839078913, 0.00039151113048869470509, 0.99889028641293320376 },
	{ 0.99896298993064014393, 0.0003914723659165510964, 0.99889034765370154911 },
	{ 0.99896307459174249477, 0.00039143453861552562727, 0.99889043645298747354 },
	{ 0.99896319002257438768, 0.00039140394054728834755, 0.998890566749694786 },
	{ 0.99896326440001570468, 0.00039136764904338207718, 0.99889064998944099294 },
	{ 0.99896335180312245683, 0.00039132604061442696937, 0.99889072538998413542 },
	{ 0.99896346935683333346, 0.00039129696346598945994, 0.99889085568783575475 },
	{ 0.99896357431746574118, 0.00039126113430339181948, 0.99889095954067996797 },
	{ 0.99896363605490767767, 0.00039122559009867986313, 0.99889104038975540245 },
	{ 0.99896371834250519139, 0.00039118995777446109816, 0.99889113102696236446 },
	{ 0.99896383878928252109, 0.00039115871998149235114, 0.99889125996983363365 },
	{ 0.9989639234938723078, 0.00039111913257914860797, 0.99889134269688439893 },
	{ 0.99896401390219746741, 0.00039108603626567195943, 0.99889143934910629152 },
	{ 0.99896412834311543172, 0.00039105509144145316662, 0.99889156477635243636 },
	{ 0.99896420781146122447, 0.00039101763550120663101, 0.99889165353501163658 },
	{ 0.99896429430819566608, 0.00039097892013865770053, 0.99889173916199536229 },
	{ 0.99896438130446507664, 0.00039094299885112114351, 0.99889182817128030489 },
	{ 0.99896449331923564685, 0.00039091286884623826928, 0.99889195426686139268 },
	{ 0.99896456267043198807, 0.00039087230182963659565, 0.99889202321522563288 },
	{ 0.9989646591870411374, 0.00039083899551707563602, 0.99889212943985794535 },
	{ 0.99896475454836930474, 0.00039080310684520066112, 0.99889222421524836992 },
	{ 0.99896485139285162713, 0.00039077247330027880309, 0.99889234094498458028 },
	{ 0.99896496187296957014, 0.00039073830238658247395, 0.99889245594094100422 },
	{ 0.99896502042952628475, 0.00039069829212504684135, 0.99889251763661213168 },
	{ 0.99896511118575181953, 0.00039066686207133588266, 0.99889262267506417903 },
	{ 0.9989652187647922732, 0.00039062959553080850829, 0.99889272745259116704 },
	{ 0.99896530857001386572, 0.00039059174877482705527, 0.99889281709530663989 },
	{ 0.99896537602606838568, 0.00039055783764201454237, 0.99889290154354881679 },
	{ 0.99896552199774801828, 0.00039053022533732696664, 0.99889305718319709726 },
	{ 0.99896556148902027061, 0.00039048776775676047367, 0.99889309938442993886 },
	{ 0.99896567503272137856, 0.00039045398479777601152, 0.9988932165536195118 },
	{ 0.99896576404028958329, 0.0003904228385575416794, 0.99889332306607059309 },
	{ 0.9989658584277254505, 0.00039038486591655039912, 0.99889341487629690342 },
	{ 0.99896598044920981163, 0.00039035688740092538062, 0.9988935506673125575 },
	{ 0.99896604139929834343, 0.00039031733547526616156, 0.99889361747906479927 },
	{ 0.99896615159216928248, 0.00039028404690104746399, 0.99889373184674057349 },
	{ 0.99896622444983518285, 0.00039024528347331307546, 0.99889380613262923614 },
	{ 0.99896633229895637207, 0.00039021221462565689776, 0.99889391749737521664 },
	{ 0.99896642224036247271, 0.00039017852321940690473, 0.99889402384503145349 },
	{ 0.99896654015112884561, 0.00039014824673014899918, 0.99889414873211634927 },
	{ 0.99896659013892175061, 0.000390103385890305267, 0.99889419139569068928 },
	{ 0.99896668924590104055, 0.00039007062259989997745, 0.9988943005231168959 },
	{ 0.99896681112776752887, 0.00039004164387065193287, 0.99889443476460249016 },
	{ 0.99896690330964088567, 0.00039000546881037964023, 0.99889452651560595164 },
	{ 0.99896698053437238407, 0.00038997074285823115454, 0.99889461712534721727 },
	{ 0.99896706462899231838, 0.00038993556486445669516, 0.99889471535570917293 },
	{ 0.99896713424569150153, 0.00038989326750117544182, 0.99889477801440074156 },
	{ 0.99896724324837693487, 0.00038986373258906607472, 0.99889490107958633924 },
	{ 0.99896732976799984538, 0.00038982651869136098486, 0.99889498568575685322 },
	{ 0.99896743999749204601, 0.00038979187513667347799, 0.99889510104220213815 },
	{ 0.99896754229851736362, 0.00038975941053706413507, 0.99889520821383293026 },
	{ 0.99896762874718669778, 0.00038972875410395857844, 0.99889531754153060294 },
	{ 0.99896769970112819781, 0.00038968772646266221357, 0.99889538230536278895 },
	{ 0.99896781296788228488, 0.00038965895830470325279, 0.99889551288931666129 },
	{ 0.99896790126133949705, 0.00038962083574610944332, 0.99889559876578148945 },
	{ 0.99896797851582552763, 0.00038958712374049413781, 0.99889569475195705284 },
	{ 0.99896809381733908673, 0.00038955246187525981302, 0.99889580532934962864 },
	{ 0.99896817668171877802, 0.00038951533724147069772, 0.99889589299109282639 },
	{ 0.99896826130219484874, 0.00038948064047175624206, 0.99889598331301521217 },
	{ 0.99896836453705817327, 0.00038944859701472495832, 0.99889609870608153663 },
	{ 0.99896845973359116311, 0.00038941107870417803784, 0.99889618994753648362 },
	{ 0.99896855034333242873, 0.00038937770773249836143, 0.9988962921112327642 },
	{ 0.99896863903962163089, 0.00038934775167781082673, 0.99889640248720923399 },
	{ 0.99896869957428968689, 0.00038930516134577956497, 0.99889645914004132621 },
	{ 0.99896881103058843276, 0.00038927104879695140433, 0.99889656865542209019 },
	{ 0.99896890371857671731, 0.00038923761373835767544, 0.99889667254946501451 },
	{ 0.99896899703827879424, 0.00038920435262995917765, 0.99889677579348357117 },
	{ 0.99896907331086171045, 0.00038916801534968572694, 0.99889685953676954355 },
	{ 0.99896916290207893319, 0.00038913312689143372391, 0.99889695508806963797 },
	{ 0.99896930158558883139, 0.00038910259462672421851, 0.99889709342367916101 },
	{ 0.99896934086400079877, 0.00038906325670558163533, 0.9988971494196203782 },
	{ 0.99896945947056803305, 0.00038902809130030821831, 0.9988972642908361399 },
	{ 0.9989695225984672744, 0.00038899296480494687748, 0.99889733828146742844 },
	{ 0.99896965950642613308, 0.0003889645651467437998, 0.99889748079245377355 },
	{ 0.99896973276692424548, 0.00038892796236354059466, 0.9988975668703345967 },
	{ 0.99896982956563018519, 0.00038889356600123597008, 0.99889766731283957668 },
	{ 0.99896990061970736274, 0.00038885462862330624203, 0.99889773911764900838 },
	{ 0.99897001683674824246, 0.0003888213217385405639, 0.99889785478537362895 },
	{ 0.99897008903180128936, 0.00038878567453700237045, 0.99889793899443413139 },
	{ 0.99897017488194483903, 0.0003887520002968900836, 0.99889804035818863248 },
	{ 0.99897027820979134027, 0.00038871767860728436437, 0.99889814597599801971 },
	{ 0.99897036430312147193, 0.00038868624225932291161, 0.99889824510300462279 },
	{ 0.99897043487196923728, 0.00038864160114604159087, 0.99889830014450842199 },
	{ 0.99897055879775054077, 0.00038861611286479156267, 0.99889844867966470776 },
	{ 0.99897065988512989687, 0.00038858239914256253534, 0.99889855556233209111 },
	{ 0.99897075334216123288, 0.00038854753586131245439, 0.99889865194905069767 },
	{ 0.99897085364733695378, 0.000388511610568343681, 0.99889875298664831949 },
	{ 0.99897089568835262252, 0.00038847103439646867972, 0.99889880176594503247 },
	{ 0.99897100379382142155, 0.00038844203049021865885, 0.99889892862141371754 },
	{ 0.99897112389269837607, 0.00038841205612498430622, 0.99889905509236087688 },
	{ 0.99897119660216326942, 0.0003883745750077357943, 0.99889913211052649977 },
	{ 0.99897126938658731277, 0.00038833526226359518741, 0.99889920346672766982 },
	{ 0.99897138161307341697, 0.00038830534168559217682, 0.99889932529480673917 },
	{ 0.99897147931815166721, 0.00038826769520121715137, 0.99889942182800983694 },
	{ 0.99897154762907991454, 0.0003882314117081750969, 0.99889950085976342287 },
	{ 0.99897164159880647016, 0.00038819925838786258033, 0.99889960977089631289 },
	{ 0.99897173287688256771, 0.00038816053158122188187, 0.99889969222328889309 },
	{ 0.99897184299078933822, 0.00038813326832133415115, 0.9988998212474131666 },
	{ 0.99897193535834316602, 0.00038809956775981061363, 0.9988999265239023595 },
	{ 0.99897199757758148309, 0.00038806056629496683309, 0.99889999123337502862 },
	{ 0.99897212026740078716, 0.00038803028980570903597, 0.9989001176585459163 },
	{ 0.99897220543089848555, 0.00038799170833903420287, 0.99890019968178522802 },
	{ 0.99897229539862619774, 0.00038796107136088484697, 0.99890030531647466816 },
	{ 0.99897239758320788283, 0.00038792782026606670038, 0.99890041806166418592 },
	{ 0.99897247012959455859, 0.00038788889204341046261, 0.99890049009535575308 },
	{ 0.99897259376240699069, 0.00038785432173091039009, 0.99890060786879331101 },
	{ 0.99897266865054090701, 0.0003878252477295981277, 0.99890071149590276001 },
	{ 0.99897274850283557246, 0.00038778805900889495991, 0.99890079530327580137 },
	{ 0.99897284773684447146, 0.0003877524724610434295, 0.99890089334709908364 },
	{ 0.99897293312579105162, 0.00038771657692271335044, 0.99890098151924877623 },
	{ 0.99897304753008808742, 0.00038768566871958835612, 0.99890109738838950282 },
	{ 0.99897310500689462387, 0.00038764972511607265638, 0.99890117478707107779 },
	{ 0.99897320787669141584, 0.0003876145883210286051, 0.99890127892945057564 },
	{ 0.9989732908234687514, 0.00038758093353587230213, 0.99890137469361084399 },
	{ 0.9989733919663521533, 0.00038754844604807926062, 0.99890148124726063639 },
	{ 0.99897347541666947635, 0.00038750689026194643731, 0.99890155382111300852 },
	{ 0.99897359057112677938, 0.00038748137623148987694, 0.99890169721043342577 },
	{ 0.99897368195906621757, 0.00038744466358500549317, 0.99890178200657597785 },
	{ 0.99897374048644038691, 0.00038740667148905817479, 0.99890185129597419689 },
	{ 0.99897383623228996896, 0.00038737226597148000573, 0.99890194949543709146 },
	{ 0.99897390489455206719, 0.00038733863178568896102, 0.99890203709996006065 },
	{ 0.99897400912276257401, 0.00038730310474711471085, 0.99890213893864443495 },
	{ 0.99897413506270393846, 0.00038726930347758343077, 0.99890225916569519438 },
	{ 0.99897419647828100686, 0.00038723654619532638446, 0.99890234148676682047 },
	{ 0.99897431168824202263, 0.00038720219560938888602, 0.99890245406000888195 },
	{ 0.99897439001618393295, 0.00038716795030909590238, 0.99890254407923495528 },
	{ 0.99897448123932863773, 0.00038713663927393961259, 0.99890265185511384338 },
	{ 0.9989745782577611477, 0.00038709566942530680613, 0.99890273277857577483 },
	{ 0.99897466702729231791, 0.00038706314989405673837, 0.9989028315090444643 },
	{ 0.99897474352875725856, 0.00038702846971827543302, 0.99890291833765787466 },
	{ 0.99897483406640086301, 0.00038699324365931546139, 0.99890301419909266478 },
	{ 0.99897492233124773886, 0.00038695757128077540006, 0.99890310508005886181 },
	{ 0.99897502552948991283, 0.00038692864061671286774, 0.99890322893259797521 },
	{ 0.99897512252961195856, 0.00038689230333643936282, 0.99890332131846226726 },
	{ 0.99897519070893325832, 0.00038685852953272833674, 0.99890340378001019062 },
	{ 0.99897529698334730508, 0.00038682696214991583701, 0.99890352353098676996 },
	{ 0.99897537337494890508, 0.00038678836351710335194, 0.99890359479563517464 },
	{ 0.99897545767041262543, 0.00038675024381953253868, 0.99890367841246419101 },
	{ 0.99897557651444479632, 0.00038672224642115598375, 0.99890381242335135603 },
	{ 0.99897565527669007768, 0.00038668672224360467558, 0.99890389625761810688 },
	{ 0.99897574147473378048, 0.00038664915243464463655, 0.99890397949850873172 },
	{ 0.9989758618682961222, 0.00038662422205286976111, 0.99890412331583822159 },
	{ 0.99897594067517325733, 0.00038658635069209088767, 0.99890420264342150158 },
	{ 0.9989760323927023844, 0.00038655242124873150263, 0.99890430172179056623 },
	{ 0.99897612028332749556, 0.00038651843687373144695, 0.998904396643665482 },
	{ 0.99897622642727867959, 0.00038648737531977637137, 0.99890451343062225398 },
	{ 0.99897628424626361276, 0.0003864463448174570645, 0.99890457262289811258 },
	{ 0.99897640537053122856, 0.00038641406332331644296, 0.99890469048788821382 },
	{ 0.99897649501610774614, 0.00038638248735743506304, 0.99890479230540074607 },
	{ 0.99897657724877364505, 0.00038634687334376317022, 0.99890487981150422048 },
	{ 0.99897664807396890918, 0.00038631032549220068991, 0.99890496323435584713 },
	{ 0.99897674601708408293, 0.0003862746748574350528, 0.99890505616038116621 },
	{ 0.99897685144921288813, 0.00038624643999415382437, 0.99890518371165071265 },
	{ 0.99897692264061921374, 0.00038620630327540380862, 0.99890524611399433841 },
	{ 0.99897700676842671186, 0.00038617437883692724799, 0.99890534853403811777 },
	{ 0.99897712480507827593, 0.0003861420767434214224, 0.99890546723902451376 },
	{ 0.99897718083535180789, 0.00038610230623560890363, 0.99890552532007925723 },
	{ 0.99897727731419561081, 0.0003860728302605722609, 0.99890563900625928273 },
	{ 0.99897739728489864941, 0.00038603987127619720761, 0.99890575751211874156 },
	{ 0.99897747428990346652, 0.00038600336920100190765, 0.99890584228079537521 },
	{ 0.99897755121823272884, 0.00038596882978754969542, 0.9989059258512755779 },
	{ 0.99897765046139674894, 0.00038593374677973720302, 0.99890602436201780812 },
	{ 0.99897775226803742221, 0.00038590225263911219185, 0.99890613378584591775 },
	{ 0.99897782326260531338, 0.00038586693617182702548, 0.99890621803724966021 },
	{ 0.99897792487698511277, 0.00038583416944819423806, 0.99890632560255743222 },
	{ 0.99897800767727806814, 0.00038579904981928794718, 0.99890641821730341565 },
	{ 0.99897811142769765702, 0.000385767431510266939, 0.99890652655337064392 },
	{ 0.99897819089547112981, 0.00038573264147120445502, 0.99890661993715978983 },
	{ 0.99897830895329420287, 0.00038570174185114828669, 0.99890673749945357862 },
	{ 0.99897835700016923699, 0.00038566072622614824567, 0.9989067902338285565 },
	{ 0.99897848942805222983, 0.00038563105484324414424, 0.99890692469589870139 },
	{ 0.99897854655695850212, 0.00038559384781199415853, 0.9989069906138674515 },
	{ 0.9989786574822514531, 0.00038556187759715041755, 0.99890710410263694463 },
	{ 0.99897875402232105824, 0.0003855277490265937709, 0.99890720582459124888 },
	{ 0.99897881170054392275, 0.00038549116455393743789, 0.99890727492859521242 },
	{ 0.99897889757014213252, 0.00038545789200144717213, 0.99890737220566439003 },
	{ 0.99897900210505430341, 0.00038542407242136907412, 0.99890747567856486011 },
	{ 0.99897910030165626427, 0.00038539248157816837414, 0.99890758679554636501 },
	{ 0.99897918049384060168, 0.0003853548957474798491, 0.9989076613412156691 },
	{ 0.99897926053610752728, 0.00038532320705729424014, 0.9989077637727036274 },
	{ 0.99897935033789586612, 0.00038528669353800711799, 0.99890785184414510045 },
	{ 0.99897946161108908125, 0.00038525726848917898372, 0.99890797241909623505 },
	{ 0.9989795475607960995, 0.00038521943889933518267, 0.99890805661099069113 },
	{ 0.99897963767157471615, 0.00038518935009318277076, 0.99890816306393248603 },
	{ 0.99897972896796161102, 0.00038515342480021399737, 0.998908250405241116 },
	{ 0.99897982416592545629, 0.00038512251802760052825, 0.99890836378901104453 },
	{ 0.998979917870149281, 0.00038509075838404576266, 0.99890847140925020931 },
	{ 0.9989799949426745318, 0.00038505210825282010483, 0.99890854542620266532 },
	{ 0.99898008835106832937, 0.00038501764494257837736, 0.99890863829100218219 },
	{ 0.99898015295296671567, 0.00038498152510004906039, 0.99890871621382326673 },
	{ 0.99898026038552312222, 0.000384947655165967064, 0.9989088200849779442 },
	{ 0.99898034973412552784, 0.00038491511045771512837, 0.99890892155058463864 },
	{ 0.99898046826058417569, 0.0003848884159691896541, 0.99890905841047827884 },
	{ 0.99898054124928514774, 0.00038484751192408467617, 0.99890912144396371009 },
	{ 0.99898061855412545462, 0.00038481380449610619711, 0.99890921189577652761 },
	{ 0.99898071384221143187, 0.00038477960039454367578, 0.9989093068908937445 },
	{ 0.99898081246281700274, 0.00038474521318751243306, 0.99890940917360859785 },
	{ 0.99898089365178177612, 0.00038471690508204366187, 0.99890951746218292762 },
	{ 0.99898095978776058068, 0.00038467631918269066865, 0.9989095773897419539 },
	{ 0.99898109204484053514, 0.00038464846884089375512, 0.99890971726400945574 },
	{ 0.99898114316788744205, 0.0003846099434502687044, 0.99890977864096242023 },
	{ 0.9989812572425944559, 0.00038457606893854993577, 0.99890988824789617162 },
	{ 0.99898133971329750036, 0.00038454369589167489932, 0.99890998126547436708 },
	{ 0.99898144413834644162, 0.00038451027914362798836, 0.99891008902304279093 },
	{ 0.99898153122473787313, 0.00038447461792307744419, 0.99891017725098241176 },
	{ 0.99898161072913227443, 0.00038444338013010864296, 0.99891027960693934418 },
	{ 0.99898169411536263951, 0.00038440840698557732918, 0.99891036357910722998 },
	{ 0.9989817752493959091, 0.00038437114502268667285, 0.9989104474231014219 },
	{ 0.99898187280798955712, 0.00038433628174143664611, 0.99891054380982002847 },
	{ 0.99898195338383721786, 0.00038430316053706043474, 0.99891063456575945878 },
	{ 0.99898204991160433064, 0.00038426979729014272341, 0.99891073786842898841 },
	{ 0.99898215362254183525, 0.00038424108635264271096, 0.99891085915749144863 },
	{ 0.99898222996836683052, 0.00038420255180674422416, 0.99891093361733029887 },
	{ 0.9989823243180372403, 0.00038416746422129495952, 0.99891102470772330513 },
	{ 0.99898240565806406543, 0.00038413571831065040224, 0.99891112101662216105 },
	{ 0.99898249703570385361, 0.00038410092941599708423, 0.99891121531708282344 },
	{ 0.99898256140671759518, 0.00038406539751368386519, 0.99891129069960149511 },
	{ 0.99898267287446063101, 0.00038403288027125223776, 0.99891140652067678118 },
	{ 0.99898281152192158761, 0.00038400863710718973181, 0.99891155835173139899 },
	{ 0.99898285439549483478, 0.00038396380544978002966, 0.99891159272234453237 },
	{ 0.99898294940892262694, 0.00038393368460017059151, 0.99891170304338949837 },
	{ 0.99898303728123705181, 0.00038390015798884244771, 0.99891179831316490034 },
	{ 0.99898313180256870236, 0.00038386695410090295247, 0.99891189733889118596 },
	{ 0.9989832313060857949, 0.00038383660494166222266, 0.99891200884840503083 },
	{ 0.99898329995347046051, 0.00038379830957728234804, 0.99891207956945926583 },
	{ 0.99898340638009108794, 0.00038376723085718951207, 0.99891219266111885844 },
	{ 0.99898350368233712615, 0.00038373247743922077237, 0.99891228937742759797 },
	{ 0.99898356624032047524, 0.00038369551760035350632, 0.99891235801451261356 },
	{ 0.99898366547432926321, 0.00038366434389429881179, 0.99891246949827727786 },
	{ 0.99898375113335635689, 0.00038362700182276556274, 0.99891255119764865711 },
	{ 0.9989838433269599971, 0.0003835975401528437384, 0.99891265858900601948 },
	{ 0.99898392182856576849, 0.00038355731960612127283, 0.9989127297028785879 },
	{ 0.9989840335389233994, 0.000383532131160076303, 0.99891286651699584542 },
	{ 0.99898413470469471509, 0.00038350102154093571516, 0.99891297504360720971 },
	{ 0.998984213709840696, 0.00038346636797266791131, 0.99891306150801228991 },
	{ 0.99898428967715258153, 0.0003834301871903498431, 0.99891314471657333129 },
	{ 0.99898437654238692041, 0.00038339605633097481032, 0.99891323685524513465 },
	{ 0.9989844653851602807, 0.0003833619987137872661, 0.99891332716286229676 },
	{ 0.99898457234621984568, 0.00038333033062296691541, 0.99891344130165626858 },
	{ 0.99898462754336336822, 0.00038329271160441214395, 0.99891350629494246594 },
	{ 0.99898473694544775991, 0.0003832594997056084328, 0.99891361087219776582 },
	{ 0.99898482685481038157, 0.00038322751575785453772, 0.99891371483490520866 },
	{ 0.99898492433558427894, 0.00038319547687845997202, 0.99891381903564990807 },
	{ 0.99898500780306775937, 0.00038315819546061322337, 0.99891389888451143086 },
	{ 0.99898508053255985484, 0.00038312443081217568757, 0.9989139874343160308 },
	{ 0.99898518811160019748, 0.00038309338070231232576, 0.99891409823601284845 },
	{ 0.99898528364687855241, 0.00038305812374430449384, 0.9989141939727073094 },
	{ 0.99898537796107234055, 0.00038302762867289339701, 0.9989143008868460738 },
	{ 0.99898546456995895859, 0.00038299353443461210851, 0.99891439049866259658 },
	{ 0.99898553776636989099, 0.00038295847889261992432, 0.99891447612793493604 },
	{ 0.99898561789332285255, 0.00038291966053324491938, 0.9989145489306692216 },
	{ 0.99898569922877200611, 0.00038288856922465114947, 0.99891465084717301348 },
	{ 0.99898579975138557252, 0.00038286010319071557897, 0.99891476339066043177 },
	{ 0.9989858538115584663, 0.00038281819664316908041, 0.99891481324741870917 },
	{ 0.99898596885672463763, 0.00038278756309824716816, 0.99891493352940130546 },
	{ 0.99898605447684185599, 0.0003827567281373096624, 0.99891503145420601495 },
	{ 0.99898614454184431199, 0.00038272129265146982713, 0.99891512584965280741 },
	{ 0.99898623186484225567, 0.00038268571525889162437, 0.99891521251347104027 },
	{ 0.99898633697539207521, 0.00038265465027170905091, 0.99891532396175886088 },
	{ 0.99898641912709118529, 0.00038262065244990109197, 0.99891541567957420344 },
	{ 0.99898651181507946983, 0.00038259095274286982142, 0.9989155230892421411 },
	{ 0.99898657630482556868, 0.00038254850889521359097, 0.99891557754480864162 },
	{ 0.99898670555439816887, 0.0003825244351037096523, 0.9989157247387172589 },
	{ 0.99898678452778677528, 0.00038248816191035025407, 0.99891580448114891677 },
	{ 0.99898688142720093452, 0.00038246011015253774702, 0.99891592159540665286 },
	{ 0.99898695338421683587, 0.00038242135931330434664, 0.99891598917162438553 },
	{ 0.99898705030823564677, 0.00038238601824122181406, 0.99891608351271166111 },
	{ 0.99898713251601078955, 0.00038235313450175033041, 0.99891617780659203163 },
	{ 0.99898721966734760347, 0.00038232142292338113128, 0.99891627757389545028 },
	{ 0.99898731815062380424, 0.00038228631244974833068, 0.9989163707104921075 },
	{ 0.9989874135119520826, 0.00038225716205912333269, 0.99891648423588264016 },
	{ 0.99898748734007714045, 0.00038221849018412330486, 0.99891655572025761511 },
	{ 0.99898756226683482762, 0.00038218296772318571851, 0.99891663518803119892 },
	{ 0.99898764576292853334, 0.00038214927631693567127, 0.99891672571537482028 },
	{ 0.99898775734740130616, 0.00038211950336771691216, 0.99891684586918327859 },
	{ 0.99898784425383457819, 0.00038208328968363484838, 0.99891692730991821225 },
	{ 0.99898792884856102425, 0.00038205084339457232338, 0.99891702479526967018 },
	{ 0.99898802114687790255, 0.00038201919075327584862, 0.99891712689773992651 },
	{ 0.9989881002301298496, 0.00038198548103647892923, 0.99891721597855054338 },
	{ 0.99898819551821582685, 0.00038195186287241637054, 0.998917315661167593 },
	{ 0.9989882618756377175, 0.00038191714607554137512, 0.99891739373733945406 },
	{ 0.99898834912081591053, 0.00038188215004282647118, 0.99891748131210744699 },
	{ 0.99898848441744669824, 0.00038185525184946712569, 0.99891762404282036236 },
	{ 0.99898856166964400405, 0.00038182172523813892769, 0.9989177075938456829 },
	{ 0.99898867436018812249, 0.00038179263492899592845, 0.99891783151447699485 },
	{ 0.99898877567244381837, 0.00038175800968485529372, 0.99891793029987741015 },
	{ 0.99898880006552548405, 0.00038171632686930358561, 0.99891796344540051411 },
	{ 0.99898888487997861141, 0.00038168219600992855283, 0.99891805089657237371 },
	{ 0.99898899082480296929, 0.00038165125118570981423, 0.99891816497127949859 },
	{ 0.99898907831259586843, 0.0003816142272599285499, 0.99891824887020530532 },
	{ 0.99898917945605136826, 0.00038158619552927658261, 0.99891836675865597339 },
	{ 0.99898926371775498279, 0.00038155308662729905435, 0.99891846057159849881 },
	{ 0.99898936611033317678, 0.000381524522174174019, 0.99891857233917669134 },
	{ 0.99898944248362420151, 0.00038148235298472092485, 0.99891863563873717347 },
	{ 0.99898951900683286009, 0.00038145136581736250377, 0.99891872827522709688 },
	{ 0.99898961729784863106, 0.00038142162948923748894, 0.99891884297249278202 },
	{ 0.99898969968500972438, 0.00038138312355356853052, 0.99891891425659617987 },
	{ 0.99898975054999206158, 0.00038134556576090497797, 0.99891897434437249004 },
	{ 0.99898983302069510604, 0.00038131348568277994996, 0.99891907175648197992 },
	{ 0.99898996460028488542, 0.00038128459163981116191, 0.99891920216419682887 },
	{ 0.99899008623724783185, 0.00038125692440348302398, 0.99891933537342547655 },
	{ 0.9989901231146891547, 0.00038121675106363926396, 0.99891938184559336822 },
	{ 0.99899021724005532263, 0.00038118413082438145365, 0.99891947778370349109 },
	{ 0.99899033825703453804, 0.00038115751959162381913, 0.99891961284429975354 },
	{ 0.99899040470600897201, 0.00038111699835138938006, 0.99891967372686818472 },
	{ 0.99899050603657535419, 0.00038108598028498315291, 0.99891978113653623339 },
	{ 0.99899057239514166273, 0.00038105383039789813421, 0.99891986461775272854 },
	{ 0.99899065816174326127, 0.00038102050520258558394, 0.99891995873396355332 },
	{ 0.99899075522366342916, 0.00038098432127314221449, 0.998920049501633045 },
	{ 0.99899083505678965, 0.00038095235763865121842, 0.99892014108383586635 },
	{ 0.99899093083010503946, 0.00038092056137400276275, 0.99892024690964142941 },
	{ 0.99899102258225258577, 0.0003808887968667090825, 0.99892034557173170484 },
	{ 0.99899112107239551595, 0.00038085466371851571781, 0.99892044047300720955 },
	{ 0.99899121452942685195, 0.00038082273012476572111, 0.99892054682066333537 },
	{ 0.99899128499813871773, 0.00038078761564570075835, 0.99892062336275466716 },
	{ 0.9989913654180606617, 0.0003807526058800757545, 0.99892070583345782264 },
	{ 0.99899146209402889252, 0.00038072270733194941896, 0.99892081516201391977 },
	{ 0.99899154280691948582, 0.00038068564678507441036, 0.99892089353115465222 },
	{ 0.99899163758231002141, 0.00038065620342569934974, 0.99892100031826414064 },
	{ 0.99899174283161940036, 0.00038062263418512938106, 0.99892110818483736967 },
	{ 0.99899179369831858644, 0.00038058604971247315648, 0.99892116952516940565 },
	{ 0.99899189793110654279, 0.00038055469290094974056, 0.99892127980043776692 },
	{ 0.99899199146137984684, 0.00038052210012751229266, 0.99892137318422680181 },
	{ 0.9989920792055204668, 0.0003804867973931372804, 0.99892146063539877243 },
	{ 0.99899215775090022262, 0.00038045510412531506183, 0.99892155588457498538 },
	{ 0.99899225248966971868, 0.00038042013098078380226, 0.99892165355303186303 },
	{ 0.99899237255564465876, 0.00038039671379404673204, 0.9989217933823812956 },
	{ 0.9989924342164112625, 0.00038035676933603881954, 0.99892185063030614067 },
	{ 0.99899247652292999522, 0.00038031678825693721697, 0.99892189775249851103 },
	{ 0.9989925943238331385, 0.00038028781181650745009, 0.99892202262127294254 },
	{ 0.99899271062784922304, 0.00038025946251230821659, 0.99892214654247657446 },
	{ 0.99899277834997901593, 0.00038022343021708104394, 0.9989222193972814301 },
	{ 0.99899285641585133799, 0.00038019018398600186621, 0.99892230569145545882 },
	{ 0.99899294672346861113, 0.00038015788418131431833, 0.99892240303032264759 },
	{ 0.99899304067488459147, 0.00038012377163248615769, 0.99892249474785177465 },
	{ 0.99899312941466134053, 0.00038008799511271074752, 0.99892258118049936932 },
	{ 0.99899321461478018946, 0.00038005860325174885966, 0.99892268916580517768 },
	{ 0.9989933021163059923, 0.00038002506290751045335, 0.9989227813639861564 },
	{ 0.99899338445883523185, 0.0003799940997727447884, 0.9989228788676481896 },
	{ 0.99899346877432593228, 0.00037995746494608455702, 0.99892295742447212437 },
	{ 0.99899354847098109644, 0.00037992180515604542963, 0.99892303706619567372 },
	{ 0.99899363870535606846, 0.00037989016453104544136, 0.99892313433182067239 },
	{ 0.99899372567587585436, 0.00037985981022196343765, 0.99892323938400584549 },
	{ 0.99899382583456730611, 0.00037982674137430709731, 0.9989233388835174754 },
	{ 0.99899392090292682411, 0.00037979319645243208138, 0.99892343600265820491 },
	{ 0.99899399114962339485, 0.00037975974022226842994, 0.99892351990787842109 },
	{ 0.99899408622713803396, 0.00037972907921152620949, 0.99892362575199455943 },
	{ 0.99899417785311450668, 0.0003796967794068386616, 0.99892372748539304261 },
	{ 0.99899423478060478399, 0.00037965790611582304025, 0.99892378433964112983 },
	{ 0.99899434833746680873, 0.00037962838550882838312, 0.99892389985687590759 },
	{ 0.99899445144730325552, 0.00037959814363794819499, 0.99892401373960826305 },
	{ 0.99899453779183167157, 0.00037956581751184950485, 0.99892410882513382742 },
	{ 0.99899462714730047352, 0.0003795321261055994576, 0.99892420228216516342 },
	{ 0.99899470716439031648, 0.00037949759241419318357, 0.99892428369085650708 },
	{ 0.99899478940392272275, 0.00037946619669275763725, 0.99892438040029873925 },
	{ 0.99899489828329823826, 0.00037943015724497316382, 0.99892447389480942821 },
	{ 0.99899498264628183719, 0.00037940001064615730192, 0.99892457419712399336 },
	{ 0.99899503720942262053, 0.00037936625286417492448, 0.99892464795887314644 },
	{ 0.99899514783659693062, 0.00037933525024729262748, 0.9989247579543334421 },
	{ 0.9989952053697658263, 0.00037929442716913710316, 0.9989248123918753608 },
	{ 0.99899531447201506129, 0.00037926656881647597373, 0.99892493511488245073 },
	{ 0.99899539406510129425, 0.00037923253122644907769, 0.99892502285501771908 },
	{ 0.99899548008805050259, 0.00037919799753504280365, 0.99892511107523263014 },
	{ 0.99899556853485826924, 0.00037916598841028698649, 0.99892520398523632075 },
	{ 0.99899568788300274758, 0.00037913921839075574597, 0.99892533629724800104 },
	{ 0.99899571704254863658, 0.00037909804712610729177, 0.99892536629907913159 },
	{ 0.99899581877594723078, 0.00037906472193079468729, 0.99892547052271196684 },
	{ 0.99899590758982437233, 0.00037903346496897220722, 0.99892556776058494261 },
	{ 0.99899600426951173926, 0.00037900709778147220795, 0.99892569139339748574 },
	{ 0.9989960847752642481, 0.00037896755958872308878, 0.9989257589123946568 },
	{ 0.9989961679051471144, 0.0003789352597840355409, 0.99892585200321493133 },
	{ 0.99899623741083876105, 0.000378897415316872474, 0.99892591554882348426 },
	{ 0.99899636132746461037, 0.00037887319961863033047, 0.99892606055919930252 },
	{ 0.99899643711252916756, 0.00037883756042795651555, 0.99892613830807019948 },
	{ 0.99899650785990457003, 0.00037880092560129628417, 0.99892621004421511266 },
	{ 0.99899663961230023013, 0.00037877422996836169816, 0.99892634733097351862 },
	{ 0.99899670708952648113, 0.00037873627392130351397, 0.99892641252739222679 },
	{ 0.99899679993086554219, 0.00037870962063150861044, 0.99892653184120450138 },
	{ 0.998996902579791346, 0.00037867984768228985133, 0.99892663881141929849 },
	{ 0.99899694745951395092, 0.00037863493820505605102, 0.99892666797840379278 },
	{ 0.9989970372178149649, 0.00037860860763864979603, 0.99892678754627484139 },
	{ 0.99899711803141366673, 0.00037857413803415757448, 0.99892686927540086383 },
	{ 0.99899721213675274356, 0.0003785412231095359255, 0.99892696525985968936 },
	{ 0.99899730475607650959, 0.0003785085799820944708, 0.99892706415054599578 },
	{ 0.99899738971358098549, 0.00037847625385599572645, 0.99892715746223725848 },
	{ 0.99899747951994710693, 0.00037844126011209926284, 0.99892724579460434597 },
	{ 0.99899757110930265114, 0.00037841221958475544348, 0.99892735100700669193 },
	{ 0.99899764778700650414, 0.00037837691913919876312, 0.99892743304512332525 },
	{ 0.99899775223036602068, 0.00037834659687357373144, 0.99892754364082647633 },
	{ 0.99899781397353004664, 0.00037831239277201126432, 0.99892761915352168423 },
	{ 0.99899791749821464926, 0.00037828394705133859283, 0.99892773176481541864 },
	{ 0.99899801604557791901, 0.00037824860769586983629, 0.99892782518522549307 },
	{ 0.99899808930664779627, 0.00037821319338159981515, 0.99892790430338196384 },
	{ 0.99899820591736565589, 0.00037818619448023256448, 0.99892803017923637032 },
	{ 0.99899827316227696183, 0.00037814986234980044189, 0.99892809975416452239 },
	{ 0.99899835351811194784, 0.00037811334196405821557, 0.99892817569715752768 },
	{ 0.99899843308516300677, 0.00037808498607950618295, 0.99892827897636682355 },
	{ 0.99899848818617631441, 0.00037804692303018970793, 0.99892833516685763939 },
	{ 0.99899863412581257904, 0.00037802165905313886343, 0.99892848904411590816 },
	{ 0.99899869879866409761, 0.00037798628307657636261, 0.99892855825798287928 },
	{ 0.99899879275008007795, 0.00037795517345743572055, 0.9989286599730708982 },
	{ 0.9989988863535955721, 0.00037792250744181062148, 0.9989287570922115167 },
	{ 0.99899897077894961317, 0.00037788991924600972899, 0.99892884888756072748 },
	{ 0.99899906615858846681, 0.00037785529400186904005, 0.99892894353477745817 },
	{ 0.99899912341109076142, 0.00037782183605509161257, 0.99892901586601523523 },
	{ 0.99899921695967475177, 0.00037778896862345091997, 0.99892911018364216602 },
	{ 0.99899929165755074756, 0.00037775259472208372498, 0.99892918539421338142 },
	{ 0.99899938056441117684, 0.00037772072521524778076, 0.99892927745048787358 },
	{ 0.99899946510763926177, 0.00037768899647074092966, 0.99892937697632111504 },
	{ 0.99899958031187807705, 0.00037765837093668328753, 0.99892948970634731776 },
	{ 0.99899963465758123693, 0.00037762218929605824999, 0.99892955752861301022 },
	{ 0.99899973681669962389, 0.00037759123989420268494, 0.99892965825950907899 },
	{ 0.99899983450346729885, 0.00037756470791178072801, 0.99892977729637422168 },
	{ 0.99899992204619192382, 0.000377528727687171284, 0.99892986216575885283 },
	{ 0.99899999936705374814, 0.00037749533382730801742, 0.99892994486076602811 },
	{ 0.99900008366881154487, 0.00037746376644449546349, 0.99893004014885189434 },
	{ 0.99900018212004437768, 0.00037742993313150721138, 0.99893013613731629352 },
	{ 0.99900023486128564087, 0.00037739382702188810272, 0.9989301983634208959 },
	{ 0.99900034001875637202, 0.00037736443859415371273, 0.99893031058876280426 },
	{ 0.99900044164229151455, 0.00037733334728555994282, 0.99893041514198555042 },
	{ 0.99900052187739118992, 0.0003773007356293710127, 0.99893050570652253128 },
	{ 0.99900059801264518011, 0.00037726744705515226092, 0.99893058967869041709 },
	{ 0.99900068124323593288, 0.00037723435074167577501, 0.99893067664463275346 },
	{ 0.99900077086878513732, 0.00037720106674509374127, 0.99893077343876113261 },
	{ 0.99900086337710114481, 0.00037716728950815532574, 0.99893086053173285599 },
	{ 0.99900097511177754495, 0.00037714408747034400314, 0.99893100350935215559 },
	{ 0.99900104322243421517, 0.00037710602442102758233, 0.99893106535780196165 },
	{ 0.99900113403473600471, 0.00037707557283716522552, 0.9989311664491868914 },
	{ 0.99900120462761632378, 0.00037704001718836155539, 0.99893123973829500706 },
	{ 0.99900129310417884465, 0.00037700661875086151657, 0.99893133055860738878 },
	{ 0.99900137823563339712, 0.00037697205644922576837, 0.99893141489126424659 },
	{ 0.99900146528511768462, 0.00037694070307092995874, 0.99893151520673972854 },
	{ 0.99900152568531752628, 0.00037690746885614715908, 0.99893158832819206605 },
	{ 0.99900163041020162424, 0.00037687360121088349461, 0.99893168767435291944 },
	{ 0.99900171397953752006, 0.00037684159437494595514, 0.99893178545267313773 },
	{ 0.99900179128781074755, 0.00037680867544489230663, 0.99893186320726568006 },
	{ 0.99900190441036951228, 0.0003767775841362984825, 0.99893197852708981443 },
	{ 0.99900197604122897843, 0.00037674667593317348819, 0.99893206451341798324 },
	{ 0.99900206470089691901, 0.00037671529165582976406, 0.99893216423265629444 },
	{ 0.99900215931807279102, 0.00037668037773447342548, 0.99893225174591249171 },
	{ 0.99900221907454234138, 0.0003766445714600593752, 0.9989323193026751202 },
	{ 0.99900234402571430614, 0.00037662157341318433729, 0.99893246329681550932 },
	{ 0.99900240759993286233, 0.00037658612419443429371, 0.99893253155853423131 },
	{ 0.99900249582014755134, 0.000376550052417090489, 0.99893261450531145584 },
	{ 0.99900258116245932438, 0.0003765184412606268358, 0.99893270625173702371 },
	{ 0.99900267868099890123, 0.00037648740145044618443, 0.99893281232816832915 },
	{ 0.99900277000027370988, 0.0003764554907448797237, 0.99893290709898141522 },
	{ 0.99900284851132103991, 0.00037642606111841487139, 0.99893300752775349149 },
	{ 0.9990029247015065339, 0.00037638748079614920425, 0.9989330712301459636 },
	{ 0.99900300754414284032, 0.00037635417047815608246, 0.99893316180669911031 },
	{ 0.99900308302021700868, 0.00037632073541956235357, 0.99893324482671852493 },
	{ 0.99900319072399801357, 0.00037629478823023124754, 0.99893336748563876792 },
	{ 0.99900324897900305565, 0.00037625755373316095362, 0.99893343011686441812 },
	{ 0.99900336191387850704, 0.00037622881075220391493, 0.99893354839841963511 },
	{ 0.99900346048699084633, 0.00037619763532953544435, 0.99893364921571858872 },
	{ 0.9990035334362096231, 0.00037616335798578543446, 0.99893373036806221155 },
	{ 0.99900361902886103405, 0.00037612870527582454574, 0.99893381385500057412 },
	{ 0.99900370254212089716, 0.0003761001076348333182, 0.99893391573145007278 },
	{ 0.99900377724915212507, 0.00037606231466608326143, 0.99893398457910631549 },
	{ 0.9990038874603336394, 0.00037603537985163006324, 0.99893410746118638244 },
	{ 0.99900393498535799974, 0.00037599393392877852697, 0.99893414910852529331 },
	{ 0.99900403732300446791, 0.00037596615682916921042, 0.99893426627771464421 },
	{ 0.99900413067017246327, 0.00037593330770807538996, 0.9989343631405076529 },
	{ 0.99900420887251539792, 0.00037590188480692178627, 0.99893444965469446739 },
	{ 0.9990042666102474378, 0.00037586520420389442874, 0.99893451035873515043 },
	{ 0.99900436275892923188, 0.00037583460728006631499, 0.99893461558944807166 },
	{ 0.99900445958052341844, 0.00037580157963114049118, 0.99893470976516818283 },
	{ 0.99900457413130472339, 0.0003757790210373904388, 0.99893485244094926134 },
	{ 0.99900464359236440526, 0.00037574041324930446345, 0.99893491225235087061 },
	{ 0.99900473221541119528, 0.00037570921207742946071, 0.99893501376602278352 },
	{ 0.99900481170149513233, 0.00037567718693094510332, 0.99893509570572014411 },
	{ 0.99900491622496323529, 0.00037564437214212674943, 0.99893519967987165487 },
	{ 0.99900501162634569585, 0.00037561484066324493441, 0.99893530697624288717 },
	{ 0.99900508376074514949, 0.00037558416134195595024, 0.99893539304496847819 },
	{ 0.9990051267355986031, 0.00037554440914469030361, 0.99893543477470481129 },
	{ 0.99900524135962187611, 0.00037551489254312770023, 0.99893555393974364787 },
	{ 0.99900532503195471623, 0.00037548107525186787993, 0.99893563670570451052 },
	{ 0.99900541107092577509, 0.00037544736324625262863, 0.99893572782127471044 },
	{ 0.99900550409308164213, 0.00037541925197916278713, 0.99893583833000276773 },
	{ 0.99900559538946831495, 0.00037538698879556903773, 0.99893593306877237481 },
	{ 0.99900564079504672321, 0.00037534852291422137567, 0.99893598223716817408 },
	{ 0.99900576721106215672, 0.00037532406002359640406, 0.9989361221297462512 },
	{ 0.99900584428015382077, 0.00037529035030679948467, 0.99893619835655278472 },
	{ 0.99900592147741951177, 0.00037525680538492441453, 0.99893628434288106455 },
	{ 0.99900601911039965675, 0.00037522705417948007964, 0.99893639255477983951 },
	{ 0.99900609956694275127, 0.00037519449802713626761, 0.99893648004257284967 },
	{ 0.99900618943510699488, 0.00037516161228494875708, 0.99893657166854932239 },
	{ 0.99900626909514100848, 0.0003751285892136596513, 0.99893665614425719568 },
	{ 0.99900633774939218146, 0.00037509185940103761557, 0.99893672441856462552 },
	{ 0.9990064313712183619, 0.00037506294704752195538, 0.99893682858726584595 },
	{ 0.99900653044415177462, 0.00037503051935510860757, 0.99893692724535076977 },
	{ 0.99900660280342756803, 0.00037499856344537957657, 0.99893701408369151018 },
	{ 0.99900670343819308883, 0.00037496882711725456174, 0.99893711940595708576 },
	{ 0.99900677940865201254, 0.00037493533712702016222, 0.99893720343305658638 },
	{ 0.99900685177078885069, 0.00037489972883539415338, 0.99893727175542901264 },
	{ 0.99900695720291765589, 0.00037487200666742539904, 0.99893739198247966105 },
	{ 0.99900706030960684245, 0.00037483965193109718052, 0.99893749325811431738 },
	{ 0.99900712780228251297, 0.00037481068464594090393, 0.9989375833826261708 },
	{ 0.99900718725948911558, 0.00037477309938745698896, 0.99893764304353793726 },
	{ 0.99900728251896464549, 0.00037474189478235448835, 0.99893774567300863687 },
	{ 0.99900735966101239516, 0.00037470872436838354455, 0.99893782607261727424 },
	{ 0.99900746310072485734, 0.0003746771718628904191, 0.99893792825805738378 },
	{ 0.99900752595453812255, 0.00037463946415262428316, 0.99893799227115698258 },
	{ 0.99900764261560992541, 0.00037461531711893285594, 0.99893812803928427879 },
	{ 0.99900774402657099849, 0.00037458389993982524465, 0.99893823034402906558 },
	{ 0.99900778426914749186, 0.00037454831167535977557, 0.9989382829038815359 },
	{ 0.99900789101505815815, 0.00037451616293268403125, 0.99893838433057846604 },
	{ 0.99900797702885202334, 0.0003744836708672543259, 0.99893847543470415395 },
	{ 0.99900804988651814575, 0.00037444897238092609421, 0.99893855078260462843 },
	{ 0.99900814396610804202, 0.00037441883322076983812, 0.99893865474988974285 },
	{ 0.99900820863895944957, 0.00037438711935358225287, 0.99893873231336627327 },
	{ 0.99900833680191580832, 0.00037435924898462463696, 0.99893886401826892385 },
	{ 0.99900840899124665473, 0.00037432408357935116573, 0.99893893820344970003 },
	{ 0.99900848313980628035, 0.0003742941366799370671, 0.99893903247530047018 },
	{ 0.99900855747604866419, 0.00037426208864526911953, 0.99893911354982445339 },
	{ 0.99900866345749395059, 0.00037422759157495658977, 0.99893921220705117481 },
	{ 0.99900873267136114375, 0.00037419836794214410324, 0.99893930573732458988 },
	{ 0.99900881825943499415, 0.00037416212679224162283, 0.99893937863618942341 },
	{ 0.99900891477890529924, 0.00037413213869409706188, 0.99893947854311093693 },
	{ 0.99900898644495517154, 0.00037409952617960116244, 0.99893956625492175139 },
	{ 0.99900908008509192726, 0.00037406755596475736725, 0.99893966084720675624 },
	{ 0.99900915312014137992, 0.00037403568760233058899, 0.99893974405376517733 },
	{ 0.99900923987837353391, 0.00037400291572885636503, 0.99893983470756597676 },
	{ 0.99900932282515064742, 0.00037397328926401258303, 0.99893993442680417694 },
	{ 0.99900944321070217491, 0.00037394400211649059989, 0.99894004845974038176 },
	{ 0.99900952748041649265, 0.0003739123477585804033, 0.99894014264461583608 },
	{ 0.99900958504877568345, 0.00037387352939920534415, 0.99894019435360026371 },
	{ 0.99900966518030631658, 0.00037384203068094361494, 0.99894028397914946815 },
	{ 0.99900974970179068357, 0.00037381053654031865799, 0.99894037816860259404 },
	{ 0.99900983089991091113, 0.00037377714725809205523, 0.99894046068508202119 },
	{ 0.99900990168848513573, 0.00037374561649637324558, 0.99894054670803122953 },
	{ 0.9990100123574304769, 0.00037371595341043577351, 0.99894066045314855451 },
	{ 0.99901010323725225604, 0.00037368440891580680975, 0.99894075599300446999 },
	{ 0.99901020764399062202, 0.00037365551487283802171, 0.9989408643548207678 },
	{ 0.99901026695185202176, 0.000373618545878697428, 0.99894092501766251768 },
	{ 0.99901032902002839808, 0.0003735839618332873098, 0.99894100010463759975 },
	{ 0.99901045469675553434, 0.00037355788990335565087, 0.99894113114635529893 },
	{ 0.99901053557329655419, 0.00037352587047891717747, 0.9989412183835225667 },
	{ 0.99901059933519842371, 0.0003734893272049914152, 0.99894127881290495363 },
	{ 0.99901068163424011637, 0.00037345811916666125409, 0.99894137373706881622 },
	{ 0.99901074433870784564, 0.00037342308193521599625, 0.99894144035999343778 },
	{ 0.99901084458895206275, 0.00037339687954263784623, 0.9989415590672688916 },
	{ 0.99901094090242870127, 0.00037336604458170039467, 0.99894166065418288358 },
	{ 0.99901100109148510686, 0.00037332898174600699995, 0.99894171938755083051 },
	{ 0.99901108330584054151, 0.00037329503399210074276, 0.99894180064975768296 },
	{ 0.9990112038258600613, 0.00037326914287881947331, 0.99894193369419126416 },
	{ 0.9990112914761590801, 0.00037323873134927846706, 0.99894202440692947409 },
	{ 0.99901136459703909765, 0.00037320560070352646036, 0.99894211005680144666 },
	{ 0.99901145907888888598, 0.00037317542663889029025, 0.99894221109153791271 },
	{ 0.99901153372612472303, 0.00037314149175958727205, 0.9989422892011836641 },
	{ 0.99901160162163238354, 0.00037310743414239972782, 0.9989423625166132803 },
	{ 0.99901167902260301634, 0.0003730723763115891033, 0.99894243868162180267 },
	{ 0.99901178266144263773, 0.00037304472624139867155, 0.99894255197469739027 },
	{ 0.99901186830959798346, 0.00037301696001367645869, 0.99894266097223316514 },
	{ 0.99901193834114543346, 0.00037297690626459197765, 0.99894271537115131299 },
	{ 0.99901202724800575172, 0.00037294586073236533387, 0.99894280940496482657 },
	{ 0.99901209905510413023, 0.00037291634184198445279, 0.99894289725667984037 },
	{ 0.99901218848381512228, 0.00037288330961542191094, 0.99894298595296893151 },
	{ 0.99901230237541682744, 0.00037285100981073436305, 0.99894309281332038797 },
	{ 0.99901236702995788175, 0.00037281931425409375836, 0.99894317196981463614 },
	{ 0.9990124585826922754, 0.00037278899198846872668, 0.99894327201864274723 },
	{ 0.99901253363934050533, 0.00037275822283105904944, 0.99894336205446288002 },
	{ 0.99901261318035616821, 0.0003727232130654340456, 0.99894343602907220703 },
	{ 0.9990126957675029562, 0.00037269657780008370917, 0.99894354342357660759 },
	{ 0.9990128013003397589, 0.00037266754642801332587, 0.99894365593273182213 },
	{ 0.99901289512358204536, 0.00037263729740457583696, 0.99894375371105204042 },
	{ 0.99901295803890721725, 0.00037259996649103215927, 0.99894381646558771948 },
	{ 0.99901303213224901256, 0.00037256459251718579374, 0.99894389148132334277 },
	{ 0.99901308615751760467, 0.00037253246666269358538, 0.99894396028320342484 },
	{ 0.99901317954130663956, 0.00037250045982675604591, 0.99894405776855488277 },
	{ 0.99901328171415815227, 0.00037247094322519349674, 0.99894415906250000337 },
	{ 0.99901335482016084821, 0.00037243640381174133872, 0.99894423897315975935 },
	{ 0.99901345909872518725, 0.00037240609985666317918, 0.99894434511940000121 },
	{ 0.99901352611532667769, 0.00037237365356760065418, 0.99894442473365785418 },
	{ 0.99901364923544389018, 0.00037234706665353813505, 0.99894455180885322054 },
	{ 0.99901372720175252162, 0.00037231560913400692236, 0.99894463739234928834 },
	{ 0.99901380953627105796, 0.00037228421684579892812, 0.99894472499801634235 },
	{ 0.99901387257948393028, 0.00037224809013681456121, 0.99894479195968621799 },
	{ 0.99901396314344892424, 0.00037221787773447076236, 0.99894488882247922668 },
	{ 0.99901405149183752918, 0.00037218698784189258597, 0.9989449828105164686 },
	{ 0.99901412593336580414, 0.0003721527928956034465, 0.99894506131698623808 },
	{ 0.99901424463148580379, 0.00037212735039072059864, 0.99894519297897366172 },
	{ 0.99901431377439964265, 0.00037209566170053498969, 0.99894527288391132824 },
	{ 0.99901439625654675503, 0.00037205968834238070404, 0.99894534619247443707 },
	{ 0.99901444269209371818, 0.00037202233482675568701, 0.9989453970225524726 },
	{ 0.99901454877310247316, 0.00037199652496652617622, 0.99894551781379692379 },
	{ 0.99901463234243847999, 0.0003719624673493386862, 0.99894560167610146895 },
	{ 0.99901470443249207332, 0.00037193019644098297173, 0.99894568565027208606 },
	{ 0.99901479523449387976, 0.00037189791494684235019, 0.99894577322961786159 },
	{ 0.99901488464832755021, 0.00037186917539911286358, 0.99894587681123725442 },
	{ 0.99901500461645575957, 0.00037183790184335723319, 0.99894598722125993451 },
	{ 0.99901507666903011096, 0.00037180726200418477267, 0.99894607441551197535 },
	{ 0.99901514042635419788, 0.00037177455936746592931, 0.99894614981834406464 },
	{ 0.99901524807405917006, 0.00037174711185770025704, 0.99894626526634222596 },
	{ 0.9990153234431310425, 0.00037171238762216554739, 0.99894634058162701251 },
	{ 0.99901540363417107304, 0.00037167919975595464658, 0.99894642434322378222 },
	{ 0.99901549386854604506, 0.00037164990288095461728, 0.99894652160884878089 },
	{ 0.99901557119284101205, 0.00037162155243234627202, 0.99894662214176210835 },
	{ 0.9990156570464178154, 0.00037158500000314701947, 0.9989467005246357445 },
	{ 0.9990157288409277081, 0.00037155209938364024309, 0.99894677533580811257 },
	{ 0.99901580703611814194, 0.00037152295814828868118, 0.99894686823436762424 },
	{ 0.99901589613523933409, 0.00037149113441781991731, 0.99894695806591060627 },
	{ 0.99901596447020002412, 0.00037145649086313230203, 0.99894702698680903907 },
	{ 0.99901606455564928577, 0.00037142715736703852845, 0.99894714025585196193 },
	{ 0.99901617680473753236, 0.00037139680506067255161, 0.99894724755594266341 },
	{ 0.99901624562206692293, 0.0003713623760827062365, 0.99894731834165573225 },
	{ 0.99901631813183255915, 0.0003713317608483312506, 0.99894740462095277245 },
	{ 0.99901641131220286773, 0.00037130271087961174434, 0.9989475095389559467 },
	{ 0.99901650683832576849, 0.00037127222381906486342, 0.99894760997230558353 },
	{ 0.9990165475609820156, 0.00037123677460031481983, 0.99894766124183675959 },
	{ 0.99901663559809150694, 0.00037120381561593976654, 0.99894775074378994173 },
	{ 0.99901671217279841564, 0.00037117155243234596293, 0.99894783413002041783 },
	{ 0.99901681895761906826, 0.00037114356705026589449, 0.99894794657279994965 },
	{ 0.99901691638975576026, 0.00037111373173074680473, 0.99894805097095518143 },
	{ 0.99901698202476918453, 0.00037107600313501310548, 0.99894810882684725861 },
	{ 0.99901703906670036304, 0.0003710447699196810765, 0.99894818059961343337 },
	{ 0.99901712246666374284, 0.00037101255709009122548, 0.99894827111322415103 },
	{ 0.99901725013466291525, 0.00037099227587060869347, 0.99894842262613325889 },
	{ 0.99901729660683080692, 0.00037095034471826493711, 0.998948454010410547 },
	{ 0.99901740758705548373, 0.00037092663256006177738, 0.99894858535196329186 },
	{ 0.99901745712967326973, 0.00037088761392908029067, 0.99894863165132563587 },
	{ 0.99901756711883948903, 0.00037086085535364076392, 0.99894875197221799645 },
	{ 0.99901767401924534973, 0.00037083217073755194793, 0.99894885964853330496 },
	{ 0.99901775326500341645, 0.00037079650865869443442, 0.99894893264581741121 },
	{ 0.99901782145348005937, 0.000370763476432132001, 0.99894901343195030563 },
	{ 0.99901790304584925373, 0.00037073471227960503975, 0.99894910721914342844 },
	{ 0.99901797775288048165, 0.00037070043493585502986, 0.99894918426992462823 },
	{ 0.99901806141376892079, 0.00037066628576593312495, 0.99894926547720019894 },
	{ 0.99901816977558510757, 0.00037063944250421434166, 0.99894938138296174301 },
	{ 0.99901824279804618545, 0.00037060816809015185037, 0.9989494630480008075 },
	{ 0.9990183019136467113, 0.00037056972509698777847, 0.9989495183550077817 },
	{ 0.99901842844868093962, 0.00037054765173272994619, 0.99894966266958307166 },
	{ 0.99901849610042958716, 0.00037051398664789104119, 0.99894973163282452244 },
	{ 0.9990185700017968351, 0.00037048197981195350173, 0.99894982311231661498 },
	{ 0.99901863097591803164, 0.00037044378401117225791, 0.99894987353956277154 },
	{ 0.99901874563656267725, 0.00037041921125726594505, 0.99895000424024638086 },
	{ 0.99901882395534924441, 0.00037038881117181670678, 0.99895009086286590261 },
	{ 0.99901891552181643075, 0.00037035668073968772617, 0.99895018108350797092 },
	{ 0.99901897325954813756, 0.00037032253614740248508, 0.99895024679548316549 },
	{ 0.99901906503200899046, 0.00037029389845208996119, 0.99895035248395969152 },
	{ 0.99901918009548551503, 0.00037026467481927742044, 0.99895046681501431518 },
	{ 0.99901923410244342083, 0.00037022885023431644381, 0.99895052364179659499 },
	{ 0.99901931966877322022, 0.00037019814459161620897, 0.99895061429388087859 },
	{ 0.99901939404621464824, 0.00037016763922052240169, 0.99895070405218144849 },
	{ 0.99901948935032225396, 0.00037013495718316892502, 0.99895079515859630526 },
	{ 0.99901955728245117605, 0.00037010547720270017434, 0.99895088264638909337 },
	{ 0.99901961524849269836, 0.00037007011209802488563, 0.99895094128191008753 },
	{ 0.99901971412544587903, 0.000370035395301149836, 0.99895103019792574894 },
	{ 0.99901980069771145754, 0.00037000653787927479223, 0.99895112468034752418 },
	{ 0.99901987617378584794, 0.00036997617899255601627, 0.99895121963884347949 },
	{ 0.99901997177114854054, 0.00036994674335794292073, 0.99895132027961730525 },
	{ 0.99902003338613865058, 0.00036991160541848975771, 0.99895138200447075594 },
	{ 0.99902012807197915212, 0.00036988353506402801927, 0.99895148697168334451 },
	{ 0.99902021764717441332, 0.00036985357900934048457, 0.99895158328515976098 },
	{ 0.9990203276586565595, 0.00036982506090478723965, 0.99895169745199174915 },
	{ 0.99902039475479464947, 0.00036978934561090299419, 0.99895176487771930596 },
	{ 0.99902047466202137382, 0.00036976026846246543055, 0.99895185870096137037 },
	{ 0.99902056991348620052, 0.00036973137441949669672, 0.99895196384012163726 },
	{ 0.99902064375076637948, 0.00036969912039117638338, 0.9989520430790130856 },
	{ 0.99902072654877038804, 0.00036966101385431111414, 0.99895211175500797651 },
	{ 0.99902079638405172357, 0.00036963276869134728368, 0.99895220335695189551 },
	{ 0.99902091643257462383, 0.00036960981184320270809, 0.99895233626863400023 },
	{ 0.99902097452822047341, 0.00036957414604501550009, 0.99895240041076582838 },
	{ 0.9990210584637674307, 0.00036954265190439048892, 0.99895248669006275755 },
	{ 0.99902113563814487485, 0.00036951234337167561134, 0.99895257432891781946 },
	{ 0.99902123438692402857, 0.00036948515220956620322, 0.99895268750640797695 },
	{ 0.99902129374113390892, 0.0003694451476700764004, 0.99895273251659333358 },
	{ 0.99902138461637801647, 0.00036941480709390449658, 0.99895283005687640632 },
	{ 0.99902146007871939215, 0.0003693835738785725218, 0.99895291083843151814 },
	{ 0.99902156015501319963, 0.0003693513381607990264, 0.99895300955974486445 },
	{ 0.99902164456434539019, 0.00036932435985879703399, 0.9989531140694799527 },
	{ 0.9990217284644155038, 0.00036929522663430968798, 0.99895320625049477403 },
	{ 0.99902179488592446344, 0.00036925491596536433271, 0.99895325665027501216 },
	{ 0.99902189537420560406, 0.00036923235737161433454, 0.99895338291980617651 },
	{ 0.99902196405935594914, 0.00036919743229226864144, 0.99895345271274449406 },
	{ 0.99902205145101841133, 0.00036916343418435843167, 0.99895353386966578846 },
	{ 0.99902214452352811058, 0.00036913715854959273889, 0.99895364503299599601 },
	{ 0.99902220670614527709, 0.00036910295444803021755, 0.99895371307498825875 },
	{ 0.99902228524008063193, 0.00036906840244607707138, 0.99895378732425588186 },
	{ 0.99902236831503188341, 0.00036903894077615513863, 0.9989538816052616621 },
	{ 0.9990224534705189896, 0.0003690089549668289096, 0.99895397596179846822 },
	{ 0.99902254304571425081, 0.00036898090320901634834, 0.99895407828113436111 },
	{ 0.99902263641920352466, 0.00036894872585611107564, 0.99895416877986797921 },
	{ 0.99902270343580512613, 0.00036891569362954853379, 0.99895424063045390461 },
	{ 0.99902277305250430928, 0.00036887881618814219236, 0.99895430519344219356 },
	{ 0.99902288514280590537, 0.00036885368725137461119, 0.99895443058635602362 },
	{ 0.99902297390632877061, 0.00036882630525903451662, 0.99895453300897496529 },
	{ 0.99902306376734040239, 0.00036879351822213872177, 0.99895461767093551853 },
	{ 0.999023151886275107, 0.00036876678654031500157, 0.99895472385780248459 },
	{ 0.99902322428617740258, 0.00036873166691140876489, 0.99895479471961889928 },
	{ 0.99902330748930245896, 0.00036870002628640872241, 0.99895488026649381652 },
	{ 0.9990233634097127613, 0.00036866739689187747603, 0.99895494988319311069 },
	{ 0.99902344822731292684, 0.00036863370405511601199, 0.99895503293210896611 },
	{ 0.99902352359352375455, 0.00036860550581292847363, 0.99895512133542940791 },
	{ 0.99902361103325154623, 0.0003685718807824109192, 0.99895521053754743335 },
	{ 0.99902370286064412497, 0.00036854000212030153891, 0.99895529712812369816 },
	{ 0.99902379390068307696, 0.000368518981612488963, 0.99895542508222523459 },
	{ 0.99902386520509989243, 0.00036848300167398176982, 0.9989554907567210762 },
	{ 0.99902393416261947579, 0.0003684494201310129554, 0.99895556293689691252 },
	{ 0.99902401612062730063, 0.00036841477657632539433, 0.99895564079334209229 },
	{ 0.999024129321005816, 0.00036838798366861056363, 0.99895575831500971198 },
	{ 0.99902419869051262147, 0.00036835311123208715504, 0.99895582880145972204 },
	{ 0.99902428663835796119, 0.00036832888408975313511, 0.99895594057132675037 },
	{ 0.9990243798939733022, 0.00036829682232217497923, 0.99895603184940262587 },
	{ 0.999024427245047697, 0.00036826155620889371124, 0.99895608286258608111 },
	{ 0.99902451553850479815, 0.00036822921978311241907, 0.99895617357303545525 },
	{ 0.9990246125615149797, 0.00036820311352090534778, 0.99895628419162674216 },
	{ 0.99902468270178135246, 0.0003681645452149360587, 0.9989563413542932313 },
	{ 0.9990247321688682236, 0.00036813336120919870793, 0.99895640969497645489 },
	{ 0.99902483941345487928, 0.00036810725809411682947, 0.99895652817880598029 },
	{ 0.99902491529236125967, 0.00036807766825036684595, 0.99895661870614971267 },
	{ 0.99902500848617847851, 0.00036804687219934147059, 0.99895671468774749346 },
	{ 0.9990251018041639286, 0.00036801650930719047826, 0.99895681070196107321 },
	{ 0.9990252036348371556, 0.00036798591123895314434, 0.99895691024839361472 },
	{ 0.99902528478718088945, 0.00036795690733270312346, 0.99895700546323740188 },
	{ 0.99902533990192687874, 0.00036792017637567186756, 0.99895705801450684902 },
	{ 0.99902543257847120639, 0.00036789069868402144879, 0.99895715380842164954 },
	{ 0.99902552589559823204, 0.00036786262317971849065, 0.99895726046363786388 },
	{ 0.99902559188223172271, 0.0003678304195054020757, 0.99895733289558363843 },
	{ 0.99902564165029805743, 0.00036779420124368334809, 0.99895739050056397978 },
	{ 0.99902578584356571678, 0.00036777473026590012505, 0.99895754712211537463 },
	{ 0.9990258261633899739, 0.00036773279911355631448, 0.99895758033744730398 },
	{ 0.99902592962484637606, 0.00036770362354592934021, 0.99895768127204820352 },
	{ 0.99902602493124281757, 0.00036767983814553863772, 0.99895780045539761538 },
	{ 0.99902606204099908549, 0.00036763797451333643171, 0.99895782931167520502 },
	{ 0.99902618252439745472, 0.000367611680568023921, 0.99895795550796417928 },
	{ 0.99902625591306948305, 0.00036758428798989891935, 0.9989580464747610522 },
	{ 0.9990263253495241802, 0.00036754624954537986475, 0.99895810318767441771 },
	{ 0.9990263793610598686, 0.00036751148239450097096, 0.99895816567699324828 },
	{ 0.99902650643282198129, 0.00036749313408212299498, 0.99895831985523131369 },
	{ 0.99902659076662325699, 0.00036746107689218155713, 0.99895840612079511711 },
	{ 0.99902666264925243933, 0.00036742911125497442577, 0.99895848414661281289 },
	{ 0.99902673736658331727, 0.00036739370666818234237, 0.99895855081416951027 },
	{ 0.99902682310228607676, 0.00036736313606576520823, 0.9989586441487489088 },
	{ 0.99902689835863378587, 0.00036733446174935894006, 0.9989587336140810514 },
	{ 0.9990270058873202963, 0.00036730715156869486303, 0.998958848009222522 },
	{ 0.99902707158556247613, 0.0003672742658265072983, 0.99895892015277731879 },
	{ 0.99902714791765467872, 0.00036724473549203464923, 0.99895900565845352492 },
	{ 0.99902721892595536257, 0.00036720661293344089397, 0.99895906802417622217 },
	{ 0.99902731091814267472, 0.00036717555824594086834, 0.99895916001636375636 },
	{ 0.99902738520345912843, 0.00036714568516091886834, 0.99895924599410867994 },
	{ 0.99902748323984369438, 0.00036712104088143884296, 0.99895936556140740858 },
	{ 0.99902755426645495351, 0.00036708623253182937844, 0.99895942915393676209 },
	{ 0.99902764516000963635, 0.00036705539757089192688, 0.99895952077991323481 },
	{ 0.99902768125009755451, 0.00036701850181893876752, 0.99895956562244248023 },
	{ 0.99902778632974842399, 0.00036699191032723958456, 0.99895967768756699368 },
	{ 0.99902788101759165684, 0.0003669653182633356831, 0.99895978949233832367 },
	{ 0.99902797542677124198, 0.00036693565517739815682, 0.99895988390151813086 },
	{ 0.99902803540296736262, 0.0003669018996842341113, 0.99895995171462836915 },
	{ 0.99902812390241801932, 0.00036687179256753493567, 0.99896004435226259943 },
	{ 0.99902821102600269931, 0.00036683993364648395273, 0.99896012816221035902 },
	{ 0.99902829496326628345, 0.00036680808416680860248, 0.99896022191736011386 },
	{ 0.99902836806583594775, 0.00036677698141412301037, 0.99896029754220738717 },
	{ 0.9990284649560945418, 0.00036675282064752142905, 0.99896041461068862954 },
	{ 0.99902852787113360922, 0.00036671510092095891504, 0.99896047020150879892 },
	{ 0.99902861114435370649, 0.00036668884102181956586, 0.99896057412673666676 },
	{ 0.99902870752020056511, 0.00036665549351052803551, 0.99896065874377915073 },
	{ 0.99902877239446807867, 0.00036662559238748122564, 0.99896074079333962992 },
	{ 0.99902885298376253864, 0.00036659204288796949167, 0.99896081772052458536 },
	{ 0.99902895534200841787, 0.00036656620899514727897, 0.99896093149997400307 },
	{ 0.99902902349500810608, 0.00036653283001260327824, 0.99896100639125506859 },
	{ 0.9990291120951668713, 0.00036650563427285709787, 0.99896110790034930993 },
	{ 0.99902921649274967208, 0.00036647522960977119578, 0.99896121163875273297 },
	{ 0.99902926472959641124, 0.00036643859707192935051, 0.99896125669414215231 },
	{ 0.99902935628233080489, 0.00036640973965005430675, 0.99896135879375158595 },
	{ 0.99902945404348497682, 0.00036637830387429746407, 0.99896145522281365459 },
	{ 0.99902951866140476955, 0.00036634880558328184125, 0.99896153265811638011 },
	{ 0.99902959822874171092, 0.00036631516796426329867, 0.9989616107011003443 },
	{ 0.99902966341428856012, 0.00036628455272988836699, 0.99896168643352223349 },
	{ 0.99902973471326927957, 0.00036625474544839419552, 0.99896176872798625457 },
	{ 0.99902984225111113314, 0.00036622634579019106363, 0.99896188410274200375 },
	{ 0.99902993548841567684, 0.00036619155575112857966, 0.998961961519734154 },
	{ 0.9990300008204467952, 0.00036616255184487855878, 0.99896204501582797075 },
	{ 0.99903010805616454526, 0.00036613668819741759753, 0.99896216221248312905 },
	{ 0.99903014331770034762, 0.00036610016323403859898, 0.99896220500880894555 },
	{ 0.9990302673625003349, 0.00036607162624673387184, 0.9989623235787551403 },
	{ 0.99903035547285201634, 0.00036604459987954636718, 0.99896242545863789264 },
	{ 0.99903041365461464629, 0.00036600930630044484519, 0.99896248563625011929 },
	{ 0.99903046082029456354, 0.00036597542492227102661, 0.99896254313823373838 },
	{ 0.99903057865324129683, 0.00036595003277139202293, 0.99896266618053097819 },
	{ 0.99903066944151031059, 0.0003659220496781302864, 0.99896276595927835373 },
	{ 0.99903074276151759836, 0.00036589220806436081098, 0.99896285170299181644 },
	{ 0.99903079306745623533, 0.0003658539779313041548, 0.99896289571468022128 },
	{ 0.99903089199018568767, 0.00036582772976235877023, 0.99896300696040785105 },
	{ 0.99903098764448261537, 0.00036579271999673376638, 0.99896309089595469732 },
	{ 0.99903104336376269412, 0.00036576161981896891965, 0.99896315769998222933 },
	{ 0.99903115167522504869, 0.0003657368227608634231, 0.99896328354379315684 },
	{ 0.99903122788372111795, 0.00036570272852258218881, 0.9989633568226017335 },
	{ 0.99903130544948637315, 0.00036567292124108801733, 0.998963442971436133 },
	{ 0.99903140495014253197, 0.00036564250627831940479, 0.99896353937532089695 },
	{ 0.99903145620479649747, 0.0003656099993355704336, 0.99896360113336224451 },
	{ 0.99903156028194495253, 0.00036558502374963282528, 0.9989637178081670621 },
	{ 0.99903163309955667071, 0.00036555150972680566963, 0.9989637955581821549 },
	{ 0.99903171100864485155, 0.00036552057634667875323, 0.99896387759629856617 },
	{ 0.99903177694492417693, 0.00036548913713769435848, 0.99896395202867149798 },
	{ 0.99903186742878058446, 0.00036545887667016499316, 0.99896404468232735674 },
	{ 0.99903192199649926142, 0.00036542096239404198979, 0.99896409513017292436 },
	{ 0.99903204099474052224, 0.00036539896084146022926, 0.99896423048316584925 },
	{ 0.9990321334630021255, 0.00036537057949380396952, 0.99896433196021661161 },
	{ 0.99903219092149830871, 0.00036533736416177270629, 0.9989643967429313598 },
	{ 0.99903228540620880871, 0.00036530905834512232121, 0.99896449642783746725 },
	{ 0.99903237182798476645, 0.00036527824112252713171, 0.99896458468181259516 },
	{ 0.99903243098249516763, 0.0003652449868805837923, 0.99896465127956046715 },
	{ 0.99903252895822625135, 0.00036521724811868194185, 0.99896475610114709998 },
	{ 0.99903258748960599434, 0.00036518303085641382229, 0.99896481907855660953 },
	{ 0.99903269161253072106, 0.0003651560685761403701, 0.99896493107501671549 },
	{ 0.99903274387197582573, 0.00036512230964974882672, 0.99896499034053498622 },
	{ 0.99903285582265954901, 0.00036509165779428004233, 0.99896509533321076191 },
	{ 0.99903291132650484663, 0.00036505997597054959175, 0.9989651607339065098 },
	{ 0.99903299811163037702, 0.00036503089653329375041, 0.99896525775462796659 },
	{ 0.99903307516241168784, 0.00036500189262704372953, 0.99896534769603406723 },
	{ 0.99903314137334919831, 0.0003649696660645436702, 0.99896541859447152145 },
	{ 0.99903326392126168276, 0.00036494204918221937644, 0.9989655402268567963 },
	{ 0.99903333288564777348, 0.00036491186195687760809, 0.99896562002650901579 },
	{ 0.99903340234441873058, 0.0003648755269654225435, 0.99896567987682038936 },
	{ 0.99903350067205543006, 0.00036484919639901628851, 0.99896579058238677007 },
	{ 0.99903355483408096127, 0.00036481397663430681095, 0.99896584001228028171 },
	{ 0.99903364371347547213, 0.00036478984333352553783, 0.99896595474616700638 },
	{ 0.99903371219492076438, 0.00036475402790383799727, 0.99896601868659662404 },
	{ 0.99903381191530338246, 0.00036472652431802254263, 0.99896612578384080816 },
	{ 0.99903389732713820948, 0.00036469976116494635205, 0.99896622329436945975 },
	{ 0.99903398545065047465, 0.00036466885467843507956, 0.99896631675769476111 },
	{ 0.99903406253805271398, 0.00036463607879952885608, 0.99896639289294852926 },
	{ 0.99903412886486153699, 0.00036460526186303591741, 0.99896646955777745891 },
	{ 0.99903420877208792827, 0.000364573840964598449, 0.9989665526876603252 },
	{ 0.9990343034075745976, 0.00036454541698770025595, 0.99896664880000685116 },
	{ 0.99903435606069646013, 0.00036450781284646491297, 0.99896670171634283086 },
	{ 0.99903443603973485221, 0.00036447870737390023442, 0.99896679259931153716 },
	{ 0.99903457390213101785, 0.00036445725885705449517, 0.99896693882962783739 },
	{ 0.99903461828003015111, 0.00036442594095544315544, 0.99896700323926512777 },
	{ 0.99903469349975682068, 0.00036438939310388056671, 0.99896706586133543482 },
	{ 0.9990347570899973384, 0.0003643576677926013219, 0.9989671342672497012 },
	{ 0.99903483216323951677, 0.00036432653986291380771, 0.99896721505338259561 },
	{ 0.99903494801406966808, 0.00036430224176721068535, 0.99896734049893942675 },
	{ 0.9990350262733471709, 0.00036427378717736693704, 0.99896743582364666558 },
	{ 0.99903509641647469941, 0.0003642395693428942074, 0.99896750159055336393 },
	{ 0.99903517108173489625, 0.00036420910803155396706, 0.99896758654977424463 },
	{ 0.99903523653278447636, 0.00036417526098565550664, 0.99896764586679076547 },
	{ 0.99903533482380002528, 0.00036414845434503046763, 0.9989677561695251562 },
	{ 0.99903543081684209604, 0.00036412112585381951847, 0.99896786336862186673 },
	{ 0.9990354868928921217, 0.0003640891831047960857, 0.99896792751962293355 },
	{ 0.99903556409130223059, 0.00036405424772576779058, 0.99896800002137775554 },
	{ 0.99903563645458348663, 0.00036402348600701782758, 0.99896807882997140648 },
	{ 0.99903572272930285525, 0.00036399462400750611998, 0.99896817334443677172 },
	{ 0.9990358137395873861, 0.00036396295362786743738, 0.99896826153031947904 },
	{ 0.99903590558529054011, 0.00036393731886224243207, 0.99896836802446009607 },
	{ 0.99903598355503253625, 0.00036390540472344852767, 0.99896845236627229703 },
	{ 0.99903607336826483198, 0.00036387627264337040183, 0.99896854364434828355 },
	{ 0.99903614691372089052, 0.0003638446835167835321, 0.99896862095948801841 },
	{ 0.99903621983547363783, 0.00036381431547479137429, 0.99896870422669992173 },
	{ 0.99903630484218763907, 0.0003637858517296741357, 0.99896879767457602561 },
	{ 0.9990363687459962172, 0.00036375300260858036945, 0.99896886414186103487 },
	{ 0.99903645571193866459, 0.00036372356840447879912, 0.99896895903627025426 },
	{ 0.99903652193660896774, 0.00036368987242059203384, 0.99896902527925113269 },
	{ 0.99903663170261525206, 0.00036366335302667101084, 0.99896913980828871971 },
	{ 0.99903671169166685662, 0.00036363633638696155233, 0.9989692339159165213 },
	{ 0.99903680593834043311, 0.00036360676256494005483, 0.99896933191625225668 },
	{ 0.99903684819908256109, 0.00036356904283837754082, 0.99896937285863507405 },
	{ 0.99903692678794986382, 0.00036353806139306505795, 0.99896945086156474503 },
	{ 0.99903705394497044345, 0.00036351520010308700521, 0.99896959395791640191 },
	{ 0.9990370859560977479, 0.00036347893463448957205, 0.99896963205157873755 },
	{ 0.99903718921384920826, 0.00036345147339181379988, 0.99896973882495521124 },
	{ 0.99903725520506014846, 0.00036341756225900123277, 0.99896980598804108187 },
	{ 0.9990373609667789756, 0.00036339500366525118039, 0.99896993108569720476 },
	{ 0.99903740857420086918, 0.00036336057983712608498, 0.99896998162280647993 },
	{ 0.99903749280271647581, 0.00036332791382150104011, 0.99897006145679079214 },
	{ 0.99903758263425945785, 0.00036330238891915726763, 0.9989701674748572291 },
	{ 0.99903767234106177764, 0.00036326890007333203407, 0.99897025217143609055 },
	{ 0.99903776680746181338, 0.00036324215980843943367, 0.9989703542321353158 },
	{ 0.99903783223104580813, 0.00036320980507211132358, 0.9989704279687077193 },
	{ 0.99903791542329889452, 0.00036318031879739207882, 0.99897051722976271115 },
	{ 0.99903798606910798608, 0.00036314834429101392485, 0.99897059043790392696 },
	{ 0.99903804577980126478, 0.00036311602617577950483, 0.99897065831510134526 },
	{ 0.99903814610786534356, 0.00036308464647607239031, 0.99897074983579203789 },
	{ 0.99903821610450838087, 0.00036305771623925591016, 0.99897084057828489101 },
	{ 0.99903831410255516943, 0.00036302710100488092427, 0.99897093476773790588 },
	{ 0.99903838990821935973, 0.00036299348284081841979, 0.99897100442105823959 },
	{ 0.9990384734958657198, 0.00036297094255761523955, 0.99897112052823588968 },
	{ 0.9990385490818032288, 0.00036293520037011524175, 0.99897118556729846972 },
	{ 0.99903862345466687422, 0.00036290750109033007758, 0.99897127413083586234 },
	{ 0.99903869921455457082, 0.00036288011766747840358, 0.99897137034360428132 },
	{ 0.99903879431953512835, 0.00036285232225732210647, 0.99897146889096744005 },
	{ 0.99903888447151267815, 0.0003628199583657205061, 0.9989715504186774675 },
	{ 0.99903891563606350701, 0.00036278286119775175322, 0.99897158912717354262 },
	{ 0.99903901859455201961, 0.00036275527006463410004, 0.9989716948265218166 },
	{ 0.99903912280588247352, 0.00036272839104012848761, 0.99897180589629663849 },
	{ 0.99903919274988284283, 0.00036269750343636869734, 0.99897188345748433314 },
	{ 0.99903924093008156238, 0.00036266107860879299388, 0.99897192979861737516 },
	{ 0.99903936357755773745, 0.00036263691898660063272, 0.99897205728694438154 },
	{ 0.99903942652921773337, 0.00036261117435769439458, 0.99897214785090926448 },
	{ 0.99903949698820204706, 0.00036257352787331936913, 0.99897220161067490363 },
	{ 0.99903958147249327659, 0.00036254395462350242751, 0.99897229401542186888 },
	{ 0.99903963861055478102, 0.00036251376968697899108, 0.9989723629088546053 },
	{ 0.99903973014154534571, 0.00036248591591195457968, 0.99897246475097190022 },
	{ 0.99903980374994372227, 0.00036245566688851703656, 0.99897254685546399422 },
	{ 0.999039889260197711, 0.00036242384315804821848, 0.99897262665282715588 },
	{ 0.99903998497972590354, 0.00036239556595162730757, 0.99897273106757633609 },
	{ 0.99904004608202079396, 0.00036236240555123666075, 0.99897279246283998688 },
	{ 0.99904013596649277051, 0.00036233731409386973898, 0.99897290034314611962 },
	{ 0.99904021710052604011, 0.00036230378748254159519, 0.99897297488538239207 },
	{ 0.99904029181671261117, 0.00036227330957726809613, 0.99897305910474276658 },
	{ 0.99904035978088501224, 0.00036224464899377192785, 0.99897313940106824415 },
	{ 0.99904045129699814431, 0.00036221216608361565857, 0.99897322644940800274 },
	{ 0.99904053464574915644, 0.00036218404880837762804, 0.99897331531764466117 },
	{ 0.99904061701860535916, 0.00036215523773507437471, 0.99897340696250402914 },
	{ 0.99904071315641529427, 0.00036212646557168319756, 0.99897350680705510051 },
	{ 0.99904076534261820886, 0.00036209250751809433835, 0.99897356128665415476 },
	{ 0.99904085949115872811, 0.00036206552378014876699, 0.99897366498242812227 },
	{ 0.99904091219377610944, 0.00036203070656136822564, 0.99897372214709712068 },
	{ 0.99904103275041677978, 0.0003620074155457431251, 0.99897385002795646702 },
	{ 0.99904110586185557175, 0.00036197660089806857255, 0.99897392772618709422 },
	{ 0.99904118331289426536, 0.00036194570442513765126, 0.99897400890742704682 },
	{ 0.99904124542226935279, 0.00036191406380013766298, 0.99897408273555210467 },
	{ 0.99904134429922253346, 0.00036188725715951267818, 0.99897418747188004851 },
	{ 0.99904141724844131023, 0.000361854151690762702, 0.99897425456172372904 },
	{ 0.99904148922720104053, 0.00036182527595834078609, 0.99897434034663579183 },
	{ 0.99904157813406124777, 0.00036179780098275480561, 0.99897444278499047954 },
	{ 0.99904166917410019977, 0.00036176667305306729142, 0.99897453060237317857 },
	{ 0.99904170939321645939, 0.0003617314160950594595, 0.99897457371455600228 },
	{ 0.99904180564260613995, 0.00036170549751595788184, 0.99897468239680675683 },
	{ 0.99904189849195623729, 0.00036167888656930255236, 0.99897478249942195383 },
	{ 0.9990419615077033022, 0.00036164447189645094723, 0.99897485062381152776 },
	{ 0.99904204834718823847, 0.00036161641842202466414, 0.99897494281455423426 },
	{ 0.99904213687868237415, 0.00036158955684975895451, 0.99897504412680981911 },
	{ 0.9990422173346531487, 0.00036155419632272027541, 0.99897510827380531229 },
	{ 0.99904229310827363797, 0.00036152627731637264558, 0.99897519903460862967 },
	{ 0.99904235382604711369, 0.00036149617477731013377, 0.99897527235003835688 },
	{ 0.99904243064794640006, 0.00036146447006539609301, 0.99897535006915461064 },
	{ 0.99904256557836623731, 0.000361443541110317932, 0.99897549463092238931 },
	{ 0.99904257094335657818, 0.00036140162826852099357, 0.99897549724933054627 },
	{ 0.99904267543249247741, 0.0003613777787812162386, 0.99897561834613235465 },
	{ 0.99904275999517555551, 0.00036134521805123576274, 0.9989756983311786076 },
	{ 0.99904283847875718916, 0.00036131640182809118128, 0.99897578911944784341 },
	{ 0.99904291493444552508, 0.00036128678451852083535, 0.99897586896258749878 },
	{ 0.99904299853582489988, 0.00036125753799752470443, 0.99897595677539252623 },
	{ 0.99904306822118860154, 0.00036122501388863797285, 0.9989760290516987995 },
	{ 0.99904318460302465876, 0.00036120326095895040298, 0.9989761653554096732 },
	{ 0.99904324331579319463, 0.00036116820541695821879, 0.99897621883136178411 },
	{ 0.99904329598035901405, 0.000361133920062343993, 0.99897627139750866387 },
	{ 0.99904341049909684003, 0.00036110831734017595973, 0.99897638970652968826 },
	{ 0.99904346048688985604, 0.00036107795845345712956, 0.99897645976268201196 },
	{ 0.99904356445417508148, 0.00036104847847298837888, 0.99897655889598269141 },
	{ 0.99904364133100609369, 0.00036102105842904301481, 0.99897664928599738676 },
	{ 0.99904368800487608482, 0.00036098561064080438802, 0.99897669583856041342 },
	{ 0.99904376751442047766, 0.00036095585314110961326, 0.99897678500920716882 },
	{ 0.99904389916496372237, 0.00036093287111596311558, 0.99897692079335631554 },
	{ 0.99904396016311725059, 0.00036089929300622185324, 0.99897698132916867841 },
	{ 0.99904403013715814552, 0.00036086841656045152591, 0.99897705890037002963 },
	{ 0.99904408363599861431, 0.00036083459240273670987, 0.99897711269217914776 },
	{ 0.99904420771541690982, 0.00036081623007134627475, 0.99897726212483817232 },
	{ 0.99904423759851557207, 0.00036077759739236073657, 0.99897729099170140543 },
	{ 0.99904435393571944246, 0.0003607493270523948756, 0.99897739748240865776 },
	{ 0.99904438938493822508, 0.00036071563564614488257, 0.99897744933787735455 },
	{ 0.99904450545549483564, 0.00036068972622231674097, 0.99897756614085597704 },
	{ 0.9990445638295184505, 0.00036065727993325421598, 0.99897763037425457711 },
	{ 0.99904465188951585564, 0.00036062889400796123819, 0.99897772240764082241 },
	{ 0.99904471005296802133, 0.0003605981231339377307, 0.99897779289409105452 },
	{ 0.99904482178049180963, 0.00036057035404519263005, 0.99897790394870211728 },
	{ 0.99904488835249050105, 0.00036054237839059055356, 0.99897798564177919811 },
	{ 0.9990449607566842527, 0.00036050899339989841801, 0.99897805709039155797 },
	{ 0.99904503019943324826, 0.00036047974230126551484, 0.99897813473626551062 },
	{ 0.99904514722213821898, 0.00036045196520165614408, 0.99897824780389243848 },
	{ 0.99904520371589733418, 0.00036042036463097739795, 0.99897831472093012728 },
	{ 0.99904525413341593865, 0.00036038757444695635607, 0.99897837036267655986 },
	{ 0.99904536664028242843, 0.00036036289869622391453, 0.99897849123746296218 },
	{ 0.99904542637386384296, 0.00036033483320550119917, 0.99897857009641066739 },
	{ 0.99904554195003569816, 0.00036030333906487613379, 0.99897867219601999 },
	{ 0.99904556926937171379, 0.00036026796308831363297, 0.99897871020871531478 },
	{ 0.9990456611837392753, 0.00036024065748528627398, 0.99897880577603703767 },
	{ 0.99904574994297079549, 0.0003602130280144611005, 0.99897890284367929503 },
	{ 0.9990458330270772791, 0.00036018344732598449884, 0.99897899301396753113 },
	{ 0.99904592220115717716, 0.00036015667558983948228, 0.99897909041177201939 },
	{ 0.9990459930995947424, 0.00036012444902733947716, 0.99897916013833454318 },
	{ 0.99904604603538560426, 0.00036008766313866760484, 0.99897920725137168141 },
	{ 0.99904614068718011755, 0.00036006098924950744305, 0.99897931028024122835 },
	{ 0.99904622900238082561, 0.0003600334467537798038, 0.99897940832978648906 },
	{ 0.99904631146850630952, 0.00036000599466637741349, 0.9989795003906386528 },
	{ 0.99904636786956824146, 0.00035997412058190475124, 0.99897956667939602493 },
	{ 0.99904645471420305824, 0.0003599433153756058856, 0.99897965025559853913 },
	{ 0.99904657332305923934, 0.00035991682230309605907, 0.99897976995851001103 },
	{ 0.99904660221710217538, 0.00035988338724450222176, 0.99897981313477957066 },
	{ 0.99904670928401961838, 0.00035985720716790305183, 0.99897992068349328321 },
	{ 0.99904676228389766024, 0.00035982711378411397609, 0.9989799897050997135 },
	{ 0.99904686882267013104, 0.000359801091063777158, 0.99898010237332779404 },
	{ 0.99904694773483304626, 0.00035977055765465854086, 0.99898018283616507595 },
	{ 0.99904702529830946567, 0.00035974001566247109773, 0.99898026420823515803 },
	{ 0.99904708723773993917, 0.00035970705496148232261, 0.99898032881986098541 },
	{ 0.99904718486156518509, 0.00035968429380730751075, 0.99898044479543168794 },
	{ 0.99904724615840956314, 0.0003596488468773759075, 0.99898050215093092685 },
	{ 0.99904731689662995553, 0.00035962116590813756126, 0.99898058539525480537 },
	{ 0.99904740838184424856, 0.00035958878942803497274, 0.99898066830655551929 },
	{ 0.99904750662393626559, 0.00035956318126992346893, 0.99898077682372543595 },
	{ 0.99904754243936599867, 0.00035952927013711090181, 0.99898082538329568969 },
	{ 0.99904763574991284347, 0.00035949924084023593277, 0.9989809113696238585 },
	{ 0.99904771828470284589, 0.00035947299267129049398, 0.99898101225158197902 },
	{ 0.99904780691690520111, 0.00035944308239297013963, 0.99898109797240697283 },
	{ 0.99904788121538234957, 0.00035941394687966440749, 0.99898118242408229239 },
	{ 0.99904795118055433889, 0.0003593815309174451327, 0.9989812507046837986 },
	{ 0.99904805421400189047, 0.00035935690323189825764, 0.99898136325961550686 },
	{ 0.99904808990926841084, 0.00035932327934578986916, 0.99898141105128734907 },
	{ 0.99904819266805733324, 0.00035929566704110234765, 0.99898151805812329673 },
	{ 0.99904826925191947407, 0.0003592626073487195518, 0.99898159151088206098 },
	{ 0.99904834824361865575, 0.00035923678947762582511, 0.99898168104945617163 },
	{ 0.99904839961385794034, 0.00035920131279305541911, 0.9989817358437678152 },
	{ 0.99904848640585008912, 0.00035917282158211787232, 0.99898182483302555568 },
	{ 0.99904858815755903656, 0.00035914903618172716983, 0.9989819408669611267 },
	{ 0.99904864891195344079, 0.00035911508842782085844, 0.99898200169459794306 },
	{ 0.99904872015829138121, 0.00035908753105477395334, 0.99898208535548671527 },
	{ 0.99904882021169694184, 0.00035905703941659040859, 0.99898218040095798642 },
	{ 0.99904892465505645838, 0.00035903316246346539961, 0.99898229597712984162 },
	{ 0.99904898286428500676, 0.00035900172325448105907, 0.99898236363460046761 },
	{ 0.99904903603811312518, 0.00035896612755135598417, 0.99898241505061602385 },
	{ 0.999049154946804574, 0.00035894214073494968816, 0.99898253520442459319 },
	{ 0.9990492094023709635, 0.00035891295372323100011, 0.99898260657893633852 },
	{ 0.99904927795705844584, 0.00035887721153573100231, 0.99898266927424872463 },
	{ 0.99904936122684506739, 0.0003588517464287667609, 0.99898276401730989882 },
	{ 0.99904945107669851367, 0.00035882125936821982577, 0.99898285038815959336 },
	{ 0.99904952417240167062, 0.00035879181600884481936, 0.99898293139401894702 },
	{ 0.99904960044956214738, 0.00035876413503960652733, 0.99898301998502225807 },
	{ 0.99904967442417158541, 0.00035873615652398150883, 0.99898310919400656882 },
	{ 0.99904974921817812916, 0.00035870141683892292324, 0.99898317117978518986 },
	{ 0.99904982395153074659, 0.00035867261320427927572, 0.99898325835744350432 },
	{ 0.99904990403041871172, 0.0003586452091820625061, 0.99898334836064783815 },
	{ 0.99905000461940784984, 0.00035861733137444523015, 0.9989834482904574875 },
	{ 0.9990500610891343003, 0.00035858884016350779178, 0.99898352277776214514 },
	{ 0.99905015810070041393, 0.0003585609829552557741, 0.99898362077809765847 },
	{ 0.99905021273937233417, 0.00035852743803338075817, 0.99898368420583205651 },
	{ 0.99905028594493883176, 0.00035849495512322454311, 0.99898375140553907769 },
	{ 0.99905037647228256414, 0.00035847239652947449073, 0.99898386302663277903 },
	{ 0.99905044984951030251, 0.00035844030500725774895, 0.99898393557530829057 },
	{ 0.99905052926235216049, 0.00035841139265374208876, 0.9989840175882476192 },
	{ 0.9990506438131332434, 0.00035838707624749204005, 0.99898413975621647154 },
	{ 0.99905068860130308295, 0.00035835126825646415952, 0.99898418922387544061 },
	{ 0.99905076464500397471, 0.00035831993891076099759, 0.99898426336327972308 },
	{ 0.99905085538520788102, 0.00035829660898522382086, 0.99898437115975802225 },
	{ 0.9990508879322047564, 0.00035825613352135656214, 0.9989843905231615695 },
	{ 0.99905101868495904682, 0.00035823642507866861138, 0.99898454136373016077 },
	{ 0.99905107189540820478, 0.00035820430837944983908, 0.99898459918843718341 },
	{ 0.99905115421962686906, 0.00035817589041069983506, 0.99898468620015579145 },
	{ 0.99905121495799953379, 0.00035814486090020173151, 0.99898475587865309677 },
	{ 0.99905128063192305543, 0.00035811229645089139853, 0.99898482216998529815 },
	{ 0.99905140944662051972, 0.00035809279571846953536, 0.99898496486407706296 },
	{ 0.99905148735799753634, 0.00035805934234932888013, 0.99898503270465321968 },
	{ 0.99905154582357369453, 0.00035802742706612575557, 0.99898509768878407389 },
	{ 0.99905163175382571961, 0.00035800256248787865445, 0.99898520414973679404 },
	{ 0.99905170550413091579, 0.00035797085319832789565, 0.99898527571193163066 },
	{ 0.99905176076536139629, 0.00035793793083504664085, 0.99898533529445110446 },
	{ 0.99905186031579940042, 0.00035791250835732438696, 0.99898544021216828526 },
	{ 0.9990519173348424431, 0.00035787643657998052804, 0.99898549188453167336 },
	{ 0.99905197702722525754, 0.00035784882427529295231, 0.99898556578589881028 },
	{ 0.99905209662713989616, 0.00035782427440957022963, 0.99898569022895289393 },
	{ 0.99905217571382498587, 0.00035779427143410634862, 0.99898577296401458447 },
	{ 0.9990522345570560514, 0.00035776610752419422262, 0.99898584982482385719 },
	{ 0.99905231085710488603, 0.00035773305698708480864, 0.99898592099791960752 },
	{ 0.99905237161836579762, 0.00035770203205422353154, 0.99898598479415368079 },
	{ 0.99905247743959402218, 0.00035768021045998524537, 0.998986111489405193 },
	{ 0.99905255048723184963, 0.0003576455554612058621, 0.99898617235595177366 },
	{ 0.99905261406145062786, 0.00035761069217995578116, 0.99898623065673297639 },
	{ 0.99905269481096214967, 0.00035758509403542452013, 0.99898632854491653532 },
	{ 0.99905275772600121709, 0.0003575536731369869433, 0.99898639424315860413 },
	{ 0.99905285494728046647, 0.00035753133570031088179, 0.99898651283513484334 },
	{ 0.99905292782325705314, 0.00035750137964562334709, 0.998986587322439612 },
	{ 0.99905303135223355593, 0.00035747219835595054303, 0.99898669041425192106 },
	{ 0.99905311727676349154, 0.00035744550386742506877, 0.99898678397427997933 },
	{ 0.99905315611801093212, 0.00035740977541283522508, 0.99898682534238303354 },
	{ 0.9990532503086084759, 0.00035738510309533044404, 0.99898692870198679827 },
	{ 0.99905331174249600856, 0.00035735153099373737073, 0.99898699069949603579 },
	{ 0.99905342612848246908, 0.00035732668358162786738, 0.99898710933352929953 },
	{ 0.9990534947564120305, 0.00035730229393319022169, 0.99898720052005274272 },
	{ 0.99905358129434529424, 0.00035726992317513346295, 0.99898728243457290965 },
	{ 0.99905364675455032852, 0.00035723778816536781852, 0.99898734672290312453 },
	{ 0.99905372082643439935, 0.00035721256653145660228, 0.99898744260493732572 },
	{ 0.99905379366578994649, 0.0003571786187775503451, 0.99898750775386313538 },
	{ 0.99905388735170297387, 0.00035715138183907375663, 0.99898760466243241574 },
	{ 0.99905397436942966483, 0.00035712345110253199956, 0.99898769846936674721 },
	{ 0.99905402641029272814, 0.0003570939871437917891, 0.99898776406461220478 },
	{ 0.99905410069618127977, 0.0003570611197121510965, 0.99898783194180951206 },
	{ 0.99905413936805620434, 0.00035702713533715109504, 0.99898787998868454618 },
	{ 0.99905425615272414053, 0.00035700432039574483273, 0.99898800548917288111 },
	{ 0.99905434624061484339, 0.0003569745840676198179, 0.99898809352628215041 },
	{ 0.99905440842780957045, 0.00035694594179467057597, 0.99898816604978069034 },
	{ 0.99905448445320010897, 0.00035691561952904554429, 0.998988247055640044 },
	{ 0.99905458404426439323, 0.00035688960024193606144, 0.99898835653439999049 },
	{ 0.99905465684699867879, 0.0003568583990700610587, 0.99898842787229069629 },
	{ 0.99905475550422528919, 0.00035683430239037352985, 0.99898853883420479782 },
	{ 0.99905481179427968463, 0.00035680221887902100397, 0.99898859983464716183 },
	{ 0.99905485310287345246, 0.00035676501184777101826, 0.99898863762761602736 },
	{ 0.99905495215949879917, 0.00035674303346947515295, 0.99898874998914266587 },
	{ 0.99905502188606132297, 0.00035671315065697516101, 0.99898882557508006386 },
	{ 0.99905511938829316687, 0.00035668325496987187588, 0.99898892240439918222 },
	{ 0.99905519016771215934, 0.00035665345455483275436, 0.9989889979811814591 },
	{ 0.99905526450853254783, 0.00035662481685952023046, 0.99898908096457972317 },
	{ 0.99905532204027092114, 0.00035659270016030145817, 0.99898913996116167624 },
	{ 0.99905541530733021904, 0.00035657005230263537701, 0.9989892515662337491 },
	{ 0.99905548547334588338, 0.00035653533550576032738, 0.99898931499396825817 },
	{ 0.99905554826478870645, 0.00035650495373085801546, 0.99898938357154398737 },
	{ 0.99905566653833299817, 0.00035648168674782577947, 0.99898951141692649003 },
	{ 0.99905571044702456973, 0.00035644393040016946698, 0.99898954243499304972 },
	{ 0.99905577484521790321, 0.00035641655613259128326, 0.99898962730437790292 },
	{ 0.99905588931360167493, 0.00035639688144997402636, 0.99898975750152141373 },
	{ 0.99905595942983560498, 0.00035636473671273033578, 0.9989898305977966686 },
	{ 0.99905604413213666692, 0.00035633315788582595966, 0.99898990713817137355 },
	{ 0.99905611477422662237, 0.00035630506950691965412, 0.99898998722850351761 },
	{ 0.99905618179082822383, 0.00035627423454598214836, 0.99899005907908955404 },
	{ 0.99905625104389150781, 0.00035624481378868842708, 0.99899013635274447331 },
	{ 0.99905633854999498222, 0.00035621670709923524941, 0.99899022766744161039 },
	{ 0.99905643287849388301, 0.00035619060827568783814, 0.99899033131944192654 },
	{ 0.99905650392570444218, 0.00035615958334282650684, 0.99899040355226054189 },
	{ 0.99905657925300550559, 0.00035613254553154712577, 0.99899049144059670624 },
	{ 0.99905663618049567187, 0.00035609682165459400011, 0.99899053840714946428 },
	{ 0.99905672450599602996, 0.00035607435919121502646, 0.9989906507927085455 },
	{ 0.99905679168739247586, 0.00035603907476738688633, 0.99899070676805035163 },
	{ 0.99905689014320309127, 0.00035601298223808996914, 0.99899081177903670259 },
	{ 0.99905693323593058874, 0.00035597928968743081015, 0.99899085641671669933 },
	{ 0.99905702225723191923, 0.00035595656172112213628, 0.99899096754800331688 },
	{ 0.99905711152114795581, 0.00035592589155510642555, 0.99899105263711462932 },
	{ 0.9990571969404212771, 0.00035589985109642718279, 0.99899115080853961857 },
	{ 0.99905726494121482872, 0.00035587160250023574604, 0.99899122990552446932 },
	{ 0.99905731953525489519, 0.00035583577677086554924, 0.99899127041875379618 },
	{ 0.99905740771884854468, 0.00035581087442711553789, 0.99899137559453499158 },
	{ 0.99905750498447354335, 0.00035578157755211550859, 0.99899147051640990735 },
	{ 0.99905759053134846059, 0.00035575696817711545145, 0.99899157012578476689 },
	{ 0.99905767337741790968, 0.00035572665506676385584, 0.99899165353948105039 },
	{ 0.99905772056369712697, 0.00035569514261559202675, 0.99899171079656123862 },
	{ 0.99905780546283640131, 0.0003556670107491369812, 0.99899179950429428665 },
	{ 0.99905786552143016621, 0.00035563566309288689293, 0.99899186307851284283 },
	{ 0.99905794351520460506, 0.00035560573450401966643, 0.99899194497243382074 },
	{ 0.99905802100143348277, 0.00035557744757012070937, 0.9989920285560748292 },
	{ 0.99905805611877362971, 0.00035554264150932963096, 0.99899206789857364353 },
	{ 0.9990581802568430092, 0.00035552031465843847652, 0.99899219789945103987 },
	{ 0.99905823963794648801, 0.0003554884726174227863, 0.998992262810339815 },
	{ 0.99905834799575721217, 0.00035546547514275241269, 0.99899238162576187161 },
	{ 0.99905841143264673132, 0.00035543527189568204991, 0.99899245072061038098 },
	{ 0.99905848787002471401, 0.00035540567289665857612, 0.99899253147927724594 },
	{ 0.99905855486202133076, 0.00035537607561424893257, 0.99899260447255566753 },
	{ 0.99905864906978514295, 0.00035534628435448330133, 0.99899269534779988611 },
	{ 0.99905869257564450248, 0.0003553127394326082854, 0.99899274588490916127 },
	{ 0.99905878969478512097, 0.00035528886247948327642, 0.99899285325795594837 },
	{ 0.99905886286430245491, 0.00035526231962517410739, 0.99899293671571209874 },
	{ 0.99905893697166336942, 0.00035523081175163894211, 0.99899301344148105919 },
	{ 0.9990590131618488634, 0.00035520307127312331563, 0.99899309999543617344 },
	{ 0.99905909357948186056, 0.00035517498976067216846, 0.99899318059159702976 },
	{ 0.99905915950431689598, 0.00035514088865593593843, 0.99899324615022122575 },
	{ 0.99905923509025429397, 0.00035511452146843593917, 0.99899333228303366372 },
	{ 0.99905931910819867348, 0.00035508364073113130727, 0.99899341128388807753 },
	{ 0.99905941125030384153, 0.00035505980612114592656, 0.9989935210842265656 },
	{ 0.99905948048248138793, 0.00035502836691216153181, 0.99899358822900197197 },
	{ 0.99905954669341878738, 0.00035500082784966149885, 0.99899366967431446618 },
	{ 0.99905961251296837577, 0.00035496883245781583579, 0.99899373501778976348 },
	{ 0.99905970094375440294, 0.00035494201666191736071, 0.99899383084603687877 },
	{ 0.99905980066528166095, 0.00035491655355766925459, 0.99899393547479042876 },
	{ 0.99905989887847745923, 0.00035488901907280599388, 0.99899403540917774968 },
	{ 0.99905992820854050418, 0.00035485545240715660794, 0.99899407381211646761 },
	{ 0.99905999179992543979, 0.00035482157903984700527, 0.99899413365899436545 },
	{ 0.99906006185607787451, 0.00035479393011406573947, 0.99899421821709977198 },
	{ 0.99906019093627806971, 0.00035477194830254232209, 0.99899434828606947789 },
	{ 0.99906023593444703845, 0.00035474163519219072647, 0.99899440633965852498 },
	{ 0.99906031833190811486, 0.00035471387640312822785, 0.99899449254571315304 },
	{ 0.9990604138946522772, 0.00035468741766289381369, 0.99899459810601587417 },
	{ 0.99906045826167966251, 0.00035464993997887279964, 0.9989946300722253314 },
	{ 0.99906058004512698911, 0.00035462864481285719586, 0.99899476317159041638 },
	{ 0.99906064631872071313, 0.0003545984487183443507, 0.99899483396045074546 },
	{ 0.99906069144964093631, 0.00035456424003914511133, 0.99899488170977923662 },
	{ 0.99906076489438866428, 0.00035454049927071242324, 0.9989949754151473682 },
	{ 0.9990608439364417892, 0.00035450786529854445882, 0.99899504655619975058 },
	{ 0.9990609664935096168, 0.0003544865655548920828, 0.9989951806306015536 },
	{ 0.99906100353116822355, 0.00035445109344795850325, 0.99899521931620927084 },
	{ 0.99906109387540653621, 0.00035442681366280225303, 0.99899531976786937193 },
	{ 0.99906115810422735368, 0.00035439285217598578753, 0.99899537965709062082 },
	{ 0.99906123646993483245, 0.00035436582008675229045, 0.99899546658984517133 },
	{ 0.99906129573659752108, 0.0003543364637024749267, 0.99899553828936893396 },
	{ 0.99906138219899998099, 0.00035430844856575616393, 0.99899562504474004321 },
	{ 0.99906146444997667722, 0.00035427629524544370157, 0.99899570319415409436 },
	{ 0.99906154975423688835, 0.00035425291725472095837, 0.9989958023778089391 },
	{ 0.99906163776616929706, 0.00035422612663582445959, 0.99899590201236077025 },
	{ 0.99906168057622790624, 0.00035419108024910571147, 0.99899594240542710644 },
	{ 0.99906177254638561802, 0.00035416550527886023723, 0.99899604289799981416 },
	{ 0.99906182832031142915, 0.00035413646475151647208, 0.99899611031743340561 },
	{ 0.99906189680175683243, 0.00035410255361870390496, 0.99899617103520688133 },
	{ 0.99906200811157142017, 0.00035408462759331320834, 0.99899630450078302779 },
	{ 0.99906207097167876174, 0.00035405047842339124921, 0.99899636487065590629 },
	{ 0.9990621376140584875, 0.00035401940428093513127, 0.99899643091336542966 },
	{ 0.99906220805473244795, 0.00035398935667351323587, 0.9989965066640977831 },
	{ 0.99906230153007447026, 0.00035396289793327887592, 0.99899660211697860479 },
	{ 0.99906237799491814933, 0.00035393682371452883087, 0.99899669440213489935 },
	{ 0.99906245047492914235, 0.00035390923200920656761, 0.99899677968121791682 },
	{ 0.99906251873207019276, 0.00035387821852043700429, 0.99899684911023400868 },
	{ 0.99906258125686586702, 0.00035384610525444578407, 0.99899690746938019092 },
	{ 0.99906269394683777652, 0.00035382516485527580087, 0.99899703542577056314 },
	{ 0.99906274842071485232, 0.00035379079595879137608, 0.99899708806859288668 },
	{ 0.99906285719680743007, 0.00035376434408501201186, 0.99899719538899711679 },
	{ 0.99906290151290833013, 0.00035373588491753154553, 0.99899725916920945057 },
	{ 0.99906298226242018501, 0.00035370625845268776353, 0.99899733947926816491 },
	{ 0.99906306010684919894, 0.00035367689577415979728, 0.9989974196170933185 },
	{ 0.99906310927410058031, 0.0003536436678536274917, 0.99899747064973187793 },
	{ 0.99906323393945606348, 0.00035362729736641433697, 0.99899761776953999171 },
	{ 0.9990633021279327064, 0.00035359397217110184091, 0.99899767995215726923 },
	{ 0.99906337519845889172, 0.00035356528641060369633, 0.99899775970603299502 },
	{ 0.99906345269327090364, 0.00035353582931831853582, 0.99899783639518080491 },
	{ 0.99906350645017549805, 0.00035350602947548397017, 0.99899790601016358327 },
	{ 0.99906359024839319627, 0.000353477620662007348, 0.99899799054080329341 },
	{ 0.99906363663816377674, 0.00035344296795204640507, 0.99899803398257558396 },
	{ 0.99906374269285125322, 0.00035342246013954641166, 0.99899815527163793316 },
	{ 0.99906382022600115356, 0.00035339191986397269036, 0.99899823574820811878 },
	{ 0.99906389883317880951, 0.00035336084686592579259, 0.99899831223136215108 },
	{ 0.99906396073427117255, 0.00035333035751656052554, 0.99899837801886837152 },
	{ 0.99906404056825548476, 0.00035331116806343554294, 0.99899848832160276224 },
	{ 0.99906415845155627231, 0.00035328329941109175728, 0.99899859682990344023 },
	{ 0.99906420428142461709, 0.00035324921118095871202, 0.99899864313927910775 },
	{ 0.99906428974590211212, 0.00035322283483818516826, 0.99899873277856110487 },
	{ 0.99906438571376698921, 0.00035319806753471836604, 0.99899884128915061865 },
	{ 0.99906441459865480414, 0.00035316509939506987668, 0.99899888592110852592 },
	{ 0.99906450687465553351, 0.00035313604971245267546, 0.99899897275887705739 },
	{ 0.99906457169856910383, 0.00035310818563774555362, 0.99899904767190206289 },
	{ 0.99906465630817276047, 0.00035307589842155904809, 0.9989991209221006363 },
	{ 0.99906472047519534474, 0.00035304674574211571819, 0.99899919336091258515 },
	{ 0.99906479703388051394, 0.00035302380949333645507, 0.99899929543534493614 },
	{ 0.99906487034473268061, 0.00035298575559929341611, 0.99899934339524476545 },
	{ 0.99906494846095894591, 0.00035296404043510881069, 0.99899944640237070548 },
	{ 0.99906501104211686837, 0.00035293266846016376967, 0.99899951052390301154 },
	{ 0.99906510863160946645, 0.00035290672584846949009, 0.99899961324263764073 },
	{ 0.99906516068849426926, 0.00035287235695198511951, 0.99899966218672953122 },
	{ 0.99906524769792415253, 0.00035284834953621367366, 0.99899976194945516728 },
	{ 0.99906532167024453273, 0.00035282137581184845349, 0.99899984554854570629 },
	{ 0.99906541116361469168, 0.00035279258304909201808, 0.99899993446284485188 },
	{ 0.99906546834287479619, 0.0003527611117966506513, 0.99899999518519599917 },
	{ 0.99906554118223023231, 0.00035273316990211943129, 0.99900008018275454624 },
	{ 0.99906564618348903117, 0.00035270773941353301571, 0.99900018250495148386 },
	{ 0.9990657056744557396, 0.00035267912002876741816, 0.99900025825568394833 },
	{ 0.99906581286439699596, 0.00035265183731392364935, 0.99900036002570358207 },
	{ 0.9990658606183031587, 0.00035262166153267359477, 0.99900042067023475667 },
	{ 0.99906589452943606044, 0.00035258584610298605421, 0.99900045121222702527 },
	{ 0.99906601626252933279, 0.00035256783310249776913, 0.99900059088050074951 },
	{ 0.99906608683137698712, 0.00035253417831734141195, 0.99900065478430943866 },
	{ 0.99906615926790032223, 0.00035250715195015390729, 0.99900073791419219393 },
	{ 0.99906621771917125674, 0.00035248014217689949872, 0.99900080968180848817 },
	{ 0.99906631133241419196, 0.00035245216080025153823, 0.99900090605765512475 },
	{ 0.99906635585536718303, 0.00035241964613274043934, 0.99900095439377956108 },
	{ 0.99906645856637721348, 0.00035239236599281736169, 0.9990010561715240156 },
	{ 0.99906651179513705774, 0.00035236242824867675333, 0.99900111551600645488 },
	{ 0.9990666045197462708, 0.00035233562160805176854, 0.99900121263514718439 },
	{ 0.99906667594518427933, 0.00035230628525093499875, 0.99900128595687121003 },
	{ 0.99906675222463359187, 0.00035227790161446040709, 0.9990013717990036124 },
	{ 0.99906683379783389753, 0.00035225468126610226657, 0.99900147392808169577 },
	{ 0.99906689825095895685, 0.00035221835314110225192, 0.9990015243187068128 },
	{ 0.99906699853782399146, 0.00035219694811180541532, 0.99900163665391183976 },
	{ 0.99906709797553772123, 0.00035217328401878787627, 0.99900174927521923074 },
	{ 0.99906713775520095133, 0.00035213863130882687913, 0.99900178742524370357 },
	{ 0.99906720912971258564, 0.00035211061617210817056, 0.99900186634370080618 },
	{ 0.99906729368781799216, 0.00035208208834007693371, 0.99900195412446235466 },
	{ 0.99906736118964900584, 0.00035205604158714725108, 0.99900203676911569772 },
	{ 0.99906742490119693212, 0.00035202234102562376776, 0.99900209330292910614 },
	{ 0.99906752407798538052, 0.00035199665361717636953, 0.99900219482346730437 },
	{ 0.99906757981328719875, 0.00035196234909370841069, 0.99900224865962206078 },
	{ 0.99906765206670511414, 0.00035194092575386459352, 0.99900234559565714854 },
	{ 0.999067743161675903, 0.0003519104386933177126, 0.99900242815791295836 },
	{ 0.99906779992894900744, 0.0003518793885834544592, 0.999002491526137959 },
	{ 0.99906790056371452824, 0.00035185668350532948393, 0.9990026041726223216 },
	{ 0.99906796095189820406, 0.00035182588516548566823, 0.99900266917506352904 },
	{ 0.9990680330954527788, 0.00035179695450142313591, 0.99900274249049314523 },
	{ 0.99906811727018107749, 0.00035177184730842992475, 0.99900283940707301777 },
	{ 0.99906818509244665893, 0.00035173947426155488831, 0.99900290605746344674 },
	{ 0.99906829327115764805, 0.00035171816078499241239, 0.99900302302523691367 },
	{ 0.99906835565290208478, 0.00035168607841804899825, 0.99900308743487453711 },
	{ 0.99906839292402005448, 0.00035165338493660369939, 0.99900313040057286962 },
	{ 0.99906848123578773091, 0.00035162377678230673532, 0.99900321398821922969 },
	{ 0.9990685558329557292, 0.00035159898430183795679, 0.99900330418597316218 },
	{ 0.99906863753261343497, 0.00035156904798820865681, 0.99900338391038034924 },
	{ 0.99906870177345041828, 0.00035154203592613586212, 0.99900346143780816011 },
	{ 0.99906877506599189864, 0.00035151324716881148045, 0.99900353784314255279 },
	{ 0.99906886671485672924, 0.00035148301187828414564, 0.99900362570172396293 },
	{ 0.99906893765907067717, 0.00035145907083824508418, 0.99900371424237355278 },
	{ 0.99906899435767893003, 0.00035142685343101856934, 0.99900377416363816963 },
	{ 0.99906907858619453666, 0.00035139858194664354242, 0.99900385370465394352 },
	{ 0.99906915929908524099, 0.00035136943155601854443, 0.999003943499575775 },
	{ 0.99906921906471024553, 0.00035134247843101852832, 0.99900401498395086097 },
	{ 0.99906928769263991796, 0.00035130900675133094673, 0.99900407306500560445 },
	{ 0.99906938367652642352, 0.00035128736368492466391, 0.99900418618756425815 },
	{ 0.99906946158790332913, 0.00035125691324547147305, 0.99900426475812098559 },
	{ 0.99906955150928256071, 0.00035123603292778348859, 0.9990043723377336482 },
	{ 0.99906960086822294009, 0.00035120323816612572868, 0.99900442776776421372 },
	{ 0.99906969393071898278, 0.00035117526737526256683, 0.99900451560374370352 },
	{ 0.99906978621587516631, 0.00035115212284401255182, 0.99900462429514991225 },
	{ 0.99906983186864606328, 0.00035112075229957887337, 0.99900467869120679332 },
	{ 0.99906991920995458223, 0.00035109002720192265465, 0.99900475387431231233 },
	{ 0.99906997932233554405, 0.00035105969692543329864, 0.99900482347613417389 },
	{ 0.99907006391334263196, 0.00035103604170158683642, 0.99900492293645004604 },
	{ 0.99907014211625777556, 0.00035100714050606069338, 0.99900499945994458706 },
	{ 0.99907022571992587512, 0.00035098069320991815562, 0.99900509166499196212 },
	{ 0.99907029212312403743, 0.00035094829269722286518, 0.99900515341731144225 },
	{ 0.99907036567973794838, 0.0003509220739968139241, 0.99900524359875741975 },
	{ 0.99907044976234138378, 0.00035089333044365227533, 0.99900532279130060953 },
	{ 0.99907049008216541885, 0.00035086231237724599397, 0.99900537204667161362 },
	{ 0.9990706060977904146, 0.0003508423905022459632, 0.99900550212479666268 },
	{ 0.99907066373939212856, 0.0003508074539788083937, 0.99900555097733567678 },
	{ 0.99907071889075937943, 0.00035077661901787088794, 0.9990056175544841377 },
	{ 0.9990708336246461041, 0.00035075365759208964852, 0.99900572877274584904 },
	{ 0.99907087476100608914, 0.00035072023683861057539, 0.99900577503262577572 },
	{ 0.99907093784084000099, 0.00035069253298118869318, 0.99900585023404175899 },
	{ 0.99907104006290115006, 0.00035067013803795143252, 0.99900596556416576544 },
	{ 0.99907108916263265286, 0.00035064068552330299004, 0.999006028488360176 },
	{ 0.99907116568240805776, 0.00035060697580650607066, 0.99900609021321362668 },
	{ 0.99907128291167890399, 0.00035058843237236299523, 0.99900622518197101929 },
	{ 0.99907133536224046466, 0.00035055458532646458902, 0.99900627417183907042 },
	{ 0.99907137859000838542, 0.00035052362104728981233, 0.99900632544938128277 },
	{ 0.99907146737785024193, 0.00035049807783439916771, 0.99900642196427380526 },
	{ 0.99907155271415404307, 0.00035046723371818817167, 0.99900650241166155663 },
	{ 0.99907163088187855848, 0.00035044462019279755708, 0.99900659764481569702 },
	{ 0.99907168095664677931, 0.00035041037489250457344, 0.99900664048691767416 },
	{ 0.99907175116843882634, 0.0003503825886376217124, 0.99900672296677595074 },
	{ 0.99907184915332514219, 0.00035035683428123748232, 0.99900682173443799972 },
	{ 0.99907193248576842137, 0.00035032962595299047643, 0.99900691155110366015 },
	{ 0.99907200213165014979, 0.00035030340582207001015, 0.99900699270974169242 },
	{ 0.99907208504180644582, 0.00035027733160332001931, 0.99900708206521038335 },
	{ 0.99907215872344712349, 0.00035024525152519493708, 0.99900714871560103436 },
	{ 0.99907222643584936428, 0.000350215112365038681, 0.99900722301980016127 },
	{ 0.9990723198013278239, 0.00035019385382011676729, 0.99900733235207550553 },
	{ 0.99907235505828573263, 0.00035016335760429645029, 0.99900738183632842304 },
	{ 0.99907242598533341216, 0.00035012982984855914054, 0.9990074425209141129 },
	{ 0.99907252467231433268, 0.00035010695310905715766, 0.99900755375061989216 },
	{ 0.99907258553771649545, 0.00035007347341850541438, 0.99900760768776886156 },
	{ 0.99907266365050939605, 0.00035004780203178661058, 0.99900769510231968162 },
	{ 0.99907276589202531625, 0.00035002599874809514234, 0.99900781168099384022 },
	{ 0.999072829566379772, 0.00034999474665001168534, 0.99900787524548506635 },
	{ 0.99907290756930944298, 0.00034996742731407411804, 0.99900795734997727138 },
	{ 0.99907298513278586238, 0.00034993820368126157729, 0.99900803139782878848 },
	{ 0.99907299216403577802, 0.00034990304743126154213, 0.99900805249157886845 },
	{ 0.9990730869271240433, 0.00034987947689369439065, 0.99900816164103500849 },
	{ 0.9990731739479981055, 0.00034985216671303031363, 0.99900824921122566291 },
	{ 0.99907324850854506426, 0.00034982330929115532407, 0.99900832523661620144 },
	{ 0.9990733592507324845, 0.00034980280147865527645, 0.99900845355692868832 },
	{ 0.99907341881494149405, 0.00034977041012123342208, 0.99900850579691879982 },
	{ 0.99907346913919092835, 0.00034973882671669243635, 0.99900856292353623633 },
	{ 0.99907356310891759499, 0.00034971399761512991355, 0.99900866333857529789 },
	{ 0.99907365440530426781, 0.00034969023052528619162, 0.99900876833125118459 },
	{ 0.99907371533364908167, 0.00034965913006141898563, 0.9990088265496349651 },
	{ 0.99907375390453001529, 0.00034962620054558026742, 0.99900887011128414184 },
	{ 0.99907384377269392584, 0.00034959770933464277484, 0.99900895792866695189 },
	{ 0.99907393400706900888, 0.0003495754437096427851, 0.9990090645692919491 },
	{ 0.99907399595164902983, 0.00034954312559440841928, 0.99900912417012199818 },
	{ 0.99907408107738127079, 0.00034951641050651779518, 0.99900921475239734537 },
	{ 0.9990741447019542143, 0.00034948935209587321006, 0.99900929118519765648 },
	{ 0.99907420183314910034, 0.00034945781904533606849, 0.99900934768467863911 },
	{ 0.99907430165309529801, 0.00034943398786857823987, 0.99900945347386316264 },
	{ 0.99907438781795132599, 0.00034940898023918376793, 0.99900955127507184983 },
	{ 0.99907445371760938979, 0.00034937490431144940578, 0.99900960175724973222 },
	{ 0.99907453406428903264, 0.00034934992872551190587, 0.99900969572697639887 },
	{ 0.99907459519404973047, 0.0003493235340721915984, 0.99900977527714729387 },
	{ 0.99907465750026303031, 0.00034928742109611733138, 0.99900982021580708725 },
	{ 0.99907471613349518869, 0.00034925951753929357748, 0.99900988976326954294 },
	{ 0.99907481154517707722, 0.00034923713747337558266, 0.99900999783669475196 },
	{ 0.99907488425521417952, 0.00034920828806236480901, 0.99901007330246938132 },
	{ 0.9990749520471527978, 0.0003491781517632314407, 0.99901014364987383853 },
	{ 0.99907503277606501957, 0.0003491514893181631011, 0.9990102311994646378 },
	{ 0.9990750991334867992, 0.00034912292486503806576, 0.9990103045881365551 },
	{ 0.99907517772235410192, 0.00034909414068535056476, 0.99901038669262887115 },
	{ 0.99907526969508664294, 0.00034907107969597069453, 0.99901048621388433002 },
	{ 0.99907534564609090655, 0.00034904412542656145825, 0.99901057049847608038 },
	{ 0.99907539294080294212, 0.00034900952564552505065, 0.99901061222105980164 },
	{ 0.99907548449353722475, 0.00034898711353615002959, 0.99901071930113782837 },
	{ 0.99907553081922073623, 0.00034895148121193121041, 0.99901075551939944042 },
	{ 0.99907563290051948357, 0.0003489317241318530831, 0.99901088169737783939 },
	{ 0.99907570090589059575, 0.00034890033985450930477, 0.99901094076720187154 },
	{ 0.99907578526258022933, 0.00034887699390724364202, 0.99901104021178188663 },
	{ 0.99907584778165370309, 0.00034884938846901117045, 0.99901111903639727707 },
	{ 0.99907592185754323655, 0.00034882111755684064519, 0.99901119556475559413 },
	{ 0.99907601070174711921, 0.0003487892740853135924, 0.99901126889763758321 },
	{ 0.99907604003867656051, 0.00034875567079857035377, 0.99901130185547748486 },
	{ 0.99907617191123521128, 0.00034874025331810146536, 0.99901145518799705503 },
	{ 0.99907621054648920733, 0.0003487041082985702263, 0.99901149221192286909 },
	{ 0.99907630311774775489, 0.000348681725943834008, 0.99901159591141630578 },
	{ 0.99907637058696319166, 0.0003486495068199936629, 0.99901165751439013896 },
	{ 0.99907644031352571545, 0.00034862313963249366364, 0.99901174013157767462 },
	{ 0.99907652973479799119, 0.0003485977102883163598, 0.99901183264504367365 },
	{ 0.999076589720149566, 0.00034856731478050383957, 0.99901189145852020701 },
	{ 0.99907665324000882734, 0.00034853821417167812988, 0.99901196387616064687 },
	{ 0.9990767389699891643, 0.00034851342169120935136, 0.99901206249676621773 },
	{ 0.99907682866305846936, 0.00034848820234611641283, 0.9990121550943461548 },
	{ 0.99907687463740857403, 0.0003484564713127911756, 0.99901220919171240809 },
	{ 0.99907693147334597494, 0.00034842307287529119099, 0.99901226016827493481 },
	{ 0.99907704284266962702, 0.0003484002075798810303, 0.99901237176648038929 },
	{ 0.99907708374156500852, 0.00034837246939018373573, 0.99901243705960174335 },
	{ 0.99907717057933365101, 0.00034834418875053521853, 0.99901251968594440012 },
	{ 0.99907725508193523378, 0.00034831552301719777634, 0.99901260215836418244 },
	{ 0.99907732601012755325, 0.00034829065500572317735, 0.99901268925934683107 },
	{ 0.99907739212894031144, 0.00034826094442680469469, 0.99901275679722678635 },
	{ 0.99907745664615210668, 0.00034823075949028131247, 0.99901282186375528482 },
	{ 0.999077533330722245, 0.000348202414763718797, 0.99901290089207561707 },
	{ 0.99907757890452864036, 0.00034817018934562790362, 0.99901295049420257843 },
	{ 0.99907767449788587033, 0.0003481487245209513191, 0.99901305945826446298 },
	{ 0.99907773509664077327, 0.00034811921707466231442, 0.99901312725306412599 },
	{ 0.99907783997945331933, 0.00034809636551216225362, 0.99901324151087655956 },
	{ 0.9990779210139228983, 0.00034807002235725506469, 0.99901332912798779251 },
	{ 0.99907799661902918498, 0.0003480437739022074835, 0.99901340805645821863 },
	{ 0.99907806939086440945, 0.00034801476198509319251, 0.99901348505345222151 },
	{ 0.9990781245227764451, 0.00034798380457237351997, 0.99901354013729914971 },
	{ 0.99907821242942318474, 0.0003479623148567972642, 0.99901364690838678762 },
	{ 0.99907826477927663689, 0.0003479281290657815608, 0.99901369486370894535 },
	{ 0.99907835849036674691, 0.0003479002810128030334, 0.99901378843747001834 },
	{ 0.99907839716224167148, 0.0003478709841378030041, 0.99901384117184510725 },
	{ 0.99907849303626516946, 0.00034784981714561539687, 0.99901395052243102679 },
	{ 0.9990785515384624782, 0.00034781251856163099626, 0.99901398906613214645 },
	{ 0.99907864016837588661, 0.00034779050699546888454, 0.9990140943906864468 },
	{ 0.99907871479959020622, 0.00034776369091346810442, 0.99901417908469059004 },
	{ 0.99907878022317420097, 0.00034773543773963994964, 0.99901425223532547282 },
	{ 0.99907886683206093004, 0.00034770991283729612295, 0.99901434104147779358 },
	{ 0.99907895713967798113, 0.00034768420482948362909, 0.99901443471823558884 },
	{ 0.9990790049061727407, 0.00034764939075782833478, 0.99901447747450689008 },
	{ 0.99907906694230552702, 0.00034762089954689078799, 0.99901454434462411136 },
	{ 0.99907915757951260005, 0.0003475950816757970613, 0.99901464113417492996 },
	{ 0.99907925718488244105, 0.00034756983772590697339, 0.99901474276629309568 },
	{ 0.99907930015058055151, 0.00034753983589485225834, 0.99901479572954987596 },
	{ 0.99907938143109809026, 0.00034751674629524291395, 0.99901489110918839653 },
	{ 0.99907944775132673243, 0.00034748718105629029665, 0.99901496510268072981 },
	{ 0.999079547562117809, 0.00034746218715980592461, 0.99901506491347180638 },
	{ 0.99907958454656131675, 0.00034742793670967166706, 0.99901509757891515662 },
	{ 0.99907966143054471875, 0.0003474017780907446163, 0.99901518633099428701 },
	{ 0.99907973956164819462, 0.00034737583204582278464, 0.99901527339764462088 },
	{ 0.99907983435992708809, 0.00034734996382072505115, 0.99901536872692919822 },
	{ 0.99907989388780116258, 0.00034732054821327265799, 0.99901543550062976706 },
	{ 0.99907995700425611396, 0.00034729375988319454533, 0.99901550909071767936 },
	{ 0.99908004627932989195, 0.00034726699243858399598, 0.99901560050469262464 },
	{ 0.99908012790774769485, 0.00034723773218467771096, 0.99901567715264172342 },
	{ 0.99908017214602895528, 0.00034720697046592769374, 0.99901572607842303864 },
	{ 0.99908025176028669723, 0.00034718023706749008908, 0.99901581580010268002 },
	{ 0.99908034653338861908, 0.00034715824838951151333, 0.99901592535439331932 },
	{ 0.99908043021029890873, 0.00034712869287803688797, 0.99901600200920892547 },
	{ 0.99908047961215440402, 0.00034710111719444311073, 0.99901606789055663604 },
	{ 0.99908056426181257592, 0.00034707487818077116222, 0.99901615265007803757 },
	{ 0.99908059842128216221, 0.00034704332109764137295, 0.99901619390259577269 },
	{ 0.99908070451259067823, 0.00034702079912498506485, 0.99901631032105275843 },
	{ 0.99908077948512485911, 0.00034699002825096161157, 0.99901637745667293267 },
	{ 0.99908085103587562781, 0.00034696263796165499604, 0.99901645620346868348 },
	{ 0.99908091703767221148, 0.00034693895927742033356, 0.99901654421454288979 },
	{ 0.99908100653962517157, 0.00034690863701179530188, 0.99901662404852720201 },
	{ 0.99908108340730106267, 0.00034688413750007653178, 0.99901671124335134078 },
	{ 0.99908112737121024249, 0.00034684992166831982901, 0.99901675359822106337 },
	{ 0.9990812295440617552, 0.00034682553201988229174, 0.9990168592866975894 },
	{ 0.99908128799189965807, 0.00034679843298271185439, 0.99901693164139593328 },
	{ 0.9990813451162282588, 0.00034676437078788764634, 0.99901697604904970973 },
	{ 0.99908144434108170362, 0.0003467435150749970281, 0.99901709189987975002 },
	{ 0.99908149059638406975, 0.00034671014238670341302, 0.99901713177967854662 },
	{ 0.99908155801467313228, 0.00034668465753868088269, 0.99901721484433003706 },
	{ 0.99908161884745971815, 0.00034665541158988936185, 0.99901728304711157058 },
	{ 0.99908171609477425257, 0.00034663294454887372438, 0.99901739226952368522 },
	{ 0.99908181841411025648, 0.00034660782247856119316, 0.99901749356346891684 },
	{ 0.99908183213958168256, 0.00034657117105796781146, 0.99901750854435733551 },
	{ 0.99908192095946679601, 0.00034654764658287009116, 0.99901760546665951956 },
	{ 0.99908199330672631255, 0.00034652106195762590393, 0.99901768572865301543 },
	{ 0.99908208271254905775, 0.00034649186121299700757, 0.99901776741658021574 },
	{ 0.99908211992072482044, 0.00034646197038963279973, 0.99901782093945312724 },
	{ 0.99908222330207241413, 0.00034644274431541407285, 0.99901794314404301911 },
	{ 0.99908228233527551776, 0.0003464077345497890148, 0.99901799075146502371 },
	{ 0.99908239863471415276, 0.00034638765703514062507, 0.99901811393566908315 },