from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


ask_yes_no = _Mock()

os = _Mock()

print_function = _Mock()

sqlite3 = _Mock()

clear_hist_help = 'Clear the IPython history database, deleting all entries.\n\nBecause this is a destructive operation, IPython will prompt the user if they\nreally want to do this. Passing a `-f` flag will force clearing without a\nprompt.\n\nThis is an handy alias to `ipython history trim --keep=0`\n'

trim_hist_help = 'Trim the IPython history database to the last 1000 entries.\n\nThis actually copies the last 1000 entries to a new database, and then replaces\nthe old file with the new. Use the `--keep=` argument to specify a number\nother than 1000.\n'

class Application(_Mock):
  pass


class BaseIPythonApplication(_Mock):
  pass
  _in_init_profile_dir = False

class Bool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class Dict(_Mock):
  pass
  info_text = 'any value'

class HistoryApp(_Mock):
  pass
  description = 'Manage the IPython history database.'
  name = u'ipython-history'

class HistoryClear(_Mock):
  pass
  _in_init_profile_dir = False
  description = 'Clear the IPython history database, deleting all entries.\n\nBecause this is a destructive operation, IPython will prompt the user if they\nreally want to do this. Passing a `-f` flag will force clearing without a\nprompt.\n\nThis is an handy alias to `ipython history trim --keep=0`\n'

class HistoryTrim(_Mock):
  pass
  _in_init_profile_dir = False
  description = 'Trim the IPython history database to the last 1000 entries.\n\nThis actually copies the last 1000 entries to a new database, and then replaces\nthe old file with the new. Use the `--keep=` argument to specify a number\nother than 1000.\n'

class Int(_Mock):
  pass
  default_value = 0
  info_text = 'an int'

