from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


CONF = _Mock()

SIGNAL = _Mock()

_ = _Mock()

add_actions = _Mock()

codeeditor = _Mock()

create_action = _Mock()

create_toolbutton = _Mock()

encoding = _Mock()

get_color_scheme = _Mock()

get_icon = _Mock()

is_text_string = _Mock()

osp = _Mock()

to_text_string = _Mock()



class FindReplace(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class HistoryConfigPage(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class HistoryLog(_Mock):
  pass
  ALLOWED_AREAS = 15
  CONF_SECTION = 'historylog'
  DISABLE_ACTIONS_WHEN_HIDDEN = True
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  LOCATION = 1
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class PluginConfigPage(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QFontComboBox(_Mock):
  pass
  AdjustToContents = 0
  AdjustToContentsOnFirstShow = 1
  AdjustToMinimumContentsLength = 2
  AdjustToMinimumContentsLengthWithIcon = 3
  AllFonts = 0
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  InsertAfterCurrent = 4
  InsertAlphabetically = 6
  InsertAtBottom = 3
  InsertAtCurrent = 2
  InsertAtTop = 1
  InsertBeforeCurrent = 5
  MonospacedFonts = 4
  NoInsert = 0
  NonScalableFonts = 2
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  ProportionalFonts = 8
  ScalableFonts = 1

class QFontDialog(_Mock):
  pass
  Accepted = 1
  DontUseNativeDialog = 2
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  NoButtons = 1
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Rejected = 0

class QGroupBox(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QInputDialog(_Mock):
  pass
  Accepted = 1
  DoubleInput = 2
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  IntInput = 1
  NoButtons = 1
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Rejected = 0
  TextInput = 0
  UseListViewForComboBoxItems = 2

class QMenu(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QToolButton(_Mock):
  pass
  DelayedPopup = 0
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  InstantPopup = 2
  MenuButtonPopup = 1
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class QVBoxLayout(_Mock):
  pass
  BottomToTop = 3
  Down = 2
  LeftToRight = 0
  RightToLeft = 1
  SetDefaultConstraint = 0
  SetFixedSize = 3
  SetMaximumSize = 4
  SetMinAndMaxSize = 5
  SetMinimumSize = 2
  SetNoConstraint = 1
  TopToBottom = 2
  Up = 3

class SpyderPluginWidget(_Mock):
  pass
  ALLOWED_AREAS = 15
  DISABLE_ACTIONS_WHEN_HIDDEN = True
  DrawChildren = 2
  DrawWindowBackground = 1
  IgnoreMask = 4
  LOCATION = 1
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3

class Tabs(_Mock):
  pass
  DrawChildren = 2
  DrawWindowBackground = 1
  East = 3
  IgnoreMask = 4
  North = 0
  PdmDepth = 6
  PdmDpiX = 7
  PdmDpiY = 8
  PdmHeight = 2
  PdmHeightMM = 4
  PdmNumColors = 5
  PdmPhysicalDpiX = 9
  PdmPhysicalDpiY = 10
  PdmWidth = 1
  PdmWidthMM = 3
  Rounded = 0
  South = 1
  Triangular = 1
  West = 2

