[comment {-*- text -*- doctools manpage}]
[vset VERSION 1]
[manpage_begin struct::map n [vset VERSION]]
[titledesc {Manage key/value maps}]
[require struct::map [opt [vset VERSION]]]
[description]

Provides a snit class whose instances manage a key/value map.
In other words, an object wrapper around Tcl arrays.

[section API]

The main command provides construction of maps:

[list_begin definitions]

[call [cmd ::struct::map] [arg mapName]]

Creates a new, empty map with an associated global Tcl command whose
name is [arg mapName].

It may be used to invoke various operations on the map.

It has the following general form:

[list_begin definitions]
[call [cmd mapName] [method method] [opt [arg "arg arg ..."]]]
[method method] and [arg arg]uments determine the exact behavior of
the command.
[list_end][comment --instance-command--]

If [arg mapName] is specified as [const %AUTO%] a unique name will be
generated by the package itself.

The result of the command is the fully-qualified name of the instance
command. 

[list_end][comment --class-command--]

[para]

The following commands are possible for map objects:

[list_begin definitions]

[call [arg mapName] [method get]]

Returns the entire map as a Tcl dictionary.

[call [arg mapName] [method names]]

Returns the list of all keys known to the map, in arbitrary order.

[call [arg mapName] [method set] [arg name] [opt [arg value]]]

Sets key [arg name] to the specified [arg value], if the value specified.

Returns the value for the key.

Throws an error if the key is not known.

[call [arg mapName] [method unset] [opt [arg pattern]...]]

Removes all keys matching at least one of the glob [arg pattern]s from
the map.

If no pattern is specified all keys are removed.
In other words, the default pattern is [const *].

The result of the command is the empty string.

[list_end]

[include ../common-text/feedback.inc]
[manpage_end]
