/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.event;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.piccolo2d.PCamera;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventFilter;

public final class PMouseWheelZoomEventHandler
extends PBasicInputEventHandler {
    static final double DEFAULT_SCALE_FACTOR = 0.1;
    private double scaleFactor = 0.1;
    private ZoomMode zoomMode = ZoomMode.ZOOM_ABOUT_CANVAS_CENTER;

    public PMouseWheelZoomEventHandler() {
        PInputEventFilter eventFilter = new PInputEventFilter();
        eventFilter.rejectAllEventTypes();
        eventFilter.setAcceptsMouseWheelRotated(true);
        this.setEventFilter(eventFilter);
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public void zoomAboutMouse() {
        this.zoomMode = ZoomMode.ZOOM_ABOUT_MOUSE;
    }

    public void zoomAboutCanvasCenter() {
        this.zoomMode = ZoomMode.ZOOM_ABOUT_CANVAS_CENTER;
    }

    public void zoomAboutViewCenter() {
        this.zoomMode = ZoomMode.ZOOM_ABOUT_VIEW_CENTER;
    }

    ZoomMode getZoomMode() {
        return this.zoomMode;
    }

    public void mouseWheelRotated(PInputEvent event) {
        PCamera camera = event.getCamera();
        double scale = 1.0 + (double)event.getWheelRotation() * this.scaleFactor;
        Point2D viewAboutPoint = this.getViewAboutPoint(event);
        camera.scaleViewAboutPoint(scale, viewAboutPoint.getX(), viewAboutPoint.getY());
    }

    private Point2D getViewAboutPoint(PInputEvent event) {
        switch (this.zoomMode) {
            case ZOOM_ABOUT_MOUSE: {
                return event.getPosition();
            }
            case ZOOM_ABOUT_CANVAS_CENTER: {
                Rectangle canvasBounds = ((PCanvas)event.getComponent()).getBounds();
                Point2D.Double canvasCenter = new Point2D.Double(canvasBounds.getCenterX(), canvasBounds.getCenterY());
                event.getPath().canvasToLocal(canvasCenter, (PNode)event.getCamera());
                return event.getCamera().localToView(canvasCenter);
            }
            case ZOOM_ABOUT_VIEW_CENTER: {
                return event.getCamera().getBoundsReference().getCenter2D();
            }
        }
        throw new IllegalArgumentException("illegal zoom mode " + (Object)((Object)this.zoomMode));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ZoomMode {
        ZOOM_ABOUT_MOUSE,
        ZOOM_ABOUT_CANVAS_CENTER,
        ZOOM_ABOUT_VIEW_CENTER;

    }
}

