/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.nodes;

import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.piccolo2d.nodes.PShape;

public abstract class PPath
extends PShape {
    private final Path2D path;

    private PPath(Path2D path) {
        this.path = (Path2D)path.clone();
        this.updateBoundsFromShape();
    }

    private PPath(Path2D path, Stroke stroke) {
        this.path = (Path2D)path.clone();
        this.setStroke(stroke);
    }

    public static final PPath createArc(float x, float y, float width, float height, float start, float extent, int type) {
        return new Float(new Arc2D.Float(x, y, width, height, start, extent, type));
    }

    public static final PPath createCubicCurve(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
        return new Float(new CubicCurve2D.Float(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2));
    }

    public static final PPath createEllipse(float x, float y, float width, float height) {
        return new Float(new Ellipse2D.Float(x, y, width, height));
    }

    public static final PPath createLine(float x1, float y1, float x2, float y2) {
        return new Float(new Line2D.Float(x1, y1, x2, y2));
    }

    public static final PPath createQuadCurve(float x1, float y1, float ctrlx, float ctrly, float x2, float y2) {
        return new Float(new QuadCurve2D.Float(x1, y1, ctrlx, ctrly, x2, y2));
    }

    public static final PPath createRectangle(float x, float y, float width, float height) {
        return new Float(new Rectangle2D.Float(x, y, width, height));
    }

    public static final PPath createRoundRectangle(float x, float y, float width, float height, float arcWidth, float arcHeight) {
        return new Float(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    public static final PPath createArc(double x, double y, double width, double height, double start, double extent, int type) {
        return new Double(new Arc2D.Double(x, y, width, height, start, extent, type));
    }

    public static final PPath createCubicCurve(double x1, double y1, double ctrlx1, double ctrly1, double ctrlx2, double ctrly2, double x2, double y2) {
        return new Double(new CubicCurve2D.Double(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2));
    }

    public static final PPath createEllipse(double x, double y, double width, double height) {
        return new Double(new Ellipse2D.Double(x, y, width, height));
    }

    public static final PPath createLine(double x1, double y1, double x2, double y2) {
        return new Double(new Line2D.Double(x1, y1, x2, y2));
    }

    public static final PPath createQuadCurve(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        return new Double(new QuadCurve2D.Double(x1, y1, ctrlx, ctrly, x2, y2));
    }

    public static final PPath createRectangle(double x, double y, double width, double height) {
        return new Double(new Rectangle2D.Double(x, y, width, height));
    }

    public static final PPath createRoundRectangle(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        return new Double(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    public final Path2D getPath() {
        return (Path2D)this.path.clone();
    }

    public final Path2D getPathReference() {
        return this.path;
    }

    public final void append(Shape shape, boolean connect) {
        Path2D oldPath = (Path2D)this.path.clone();
        this.path.append(shape, connect);
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "path", oldPath, this.getPath());
    }

    public final void append(PathIterator pathIterator, boolean connect) {
        Path2D oldPath = (Path2D)this.path.clone();
        this.path.append(pathIterator, connect);
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "path", oldPath, this.getPath());
    }

    public final void curveTo(double x1, double y1, double x2, double y2, double x3, double y3) {
        Path2D oldPath = (Path2D)this.path.clone();
        this.path.curveTo(x1, y1, x2, y2, x3, y3);
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "path", oldPath, this.getPath());
    }

    public final void lineTo(double x, double y) {
        Path2D oldPath = (Path2D)this.path.clone();
        this.path.lineTo(x, y);
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "path", oldPath, this.getPath());
    }

    public final void moveTo(double x, double y) {
        Path2D oldPath = (Path2D)this.path.clone();
        this.path.moveTo(x, y);
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "path", oldPath, this.getPath());
    }

    public final void quadTo(double x1, double y1, double x2, double y2) {
        Path2D oldPath = (Path2D)this.path.clone();
        this.path.quadTo(x1, y1, x2, y2);
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "path", oldPath, this.getPath());
    }

    public final void reset() {
        Path2D oldPath = (Path2D)this.path.clone();
        this.path.reset();
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "path", oldPath, this.getPath());
    }

    public final void closePath() {
        Path2D oldPath = (Path2D)this.path.clone();
        this.path.closePath();
        this.updateBoundsFromShape();
        this.firePropertyChange(-1, "path", oldPath, this.getPath());
    }

    protected final Shape getShape() {
        return this.path;
    }

    protected final void transform(AffineTransform transform) {
        this.path.transform(transform);
    }

    public static class Double
    extends PPath {
        public Double() {
            super((Path2D)new Path2D.Double());
        }

        public Double(Stroke stroke) {
            super(new Path2D.Double(), stroke);
        }

        public Double(Shape shape) {
            super((Path2D)new Path2D.Double(shape));
        }

        public Double(Shape shape, Stroke stroke) {
            super(new Path2D.Double(shape), stroke);
        }

        public Double(Path2D.Double path) {
            super((Path2D)path);
        }

        public Double(Path2D.Double path, Stroke stroke) {
            super(path, stroke);
        }
    }

    public static class Float
    extends PPath {
        public Float() {
            super((Path2D)new Path2D.Float());
        }

        public Float(Stroke stroke) {
            super(new Path2D.Float(), stroke);
        }

        public Float(Shape shape) {
            super((Path2D)new Path2D.Float(shape));
        }

        public Float(Shape shape, Stroke stroke) {
            super(new Path2D.Float(shape), stroke);
        }

        public Float(Path2D.Float path) {
            super((Path2D)path);
        }

        public Float(Path2D.Float path, Stroke stroke) {
            super(path, stroke);
        }
    }
}

