/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.event;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.piccolo2d.PCamera;
import org.piccolo2d.PCanvas;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventFilter;
import org.piccolo2d.extras.nodes.PStyledText;

public class PStyledTextEventHandler
extends PBasicInputEventHandler {
    private static final int TEXT_EDIT_PADDING = 3;
    protected PCanvas canvas;
    protected JTextComponent editor;
    protected DocumentListener docListener;
    protected PStyledText editedText;

    public PStyledTextEventHandler(PCanvas canvas) {
        PInputEventFilter filter = new PInputEventFilter();
        filter.setOrMask(20);
        this.setEventFilter(filter);
        this.canvas = canvas;
        this.initEditor(this.createDefaultEditor());
    }

    public PStyledTextEventHandler(PCanvas canvas, JTextComponent editor) {
        this.canvas = canvas;
        this.initEditor(editor);
    }

    protected void initEditor(JTextComponent newEditor) {
        this.editor = newEditor;
        this.canvas.setLayout(null);
        this.canvas.add((Component)this.editor);
        this.editor.setVisible(false);
        this.docListener = this.createDocumentListener();
    }

    protected JTextComponent createDefaultEditor() {
        return new DefaultTextEditor();
    }

    protected DocumentListener createDocumentListener() {
        return new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                PStyledTextEventHandler.this.reshapeEditorLater();
            }

            public void insertUpdate(DocumentEvent e) {
                PStyledTextEventHandler.this.reshapeEditorLater();
            }

            public void changedUpdate(DocumentEvent e) {
                PStyledTextEventHandler.this.reshapeEditorLater();
            }
        };
    }

    public PStyledText createText() {
        PStyledText newText = new PStyledText();
        Document doc = this.editor.getUI().getEditorKit(this.editor).createDefaultDocument();
        if (doc instanceof StyledDocument && this.missingFontFamilyOrSize(doc)) {
            Font eFont = this.editor.getFont();
            SimpleAttributeSet sas = new SimpleAttributeSet();
            sas.addAttribute(StyleConstants.FontFamily, eFont.getFamily());
            sas.addAttribute(StyleConstants.FontSize, new Integer(eFont.getSize()));
            ((StyledDocument)doc).setParagraphAttributes(0, doc.getLength(), sas, false);
        }
        newText.setDocument(doc);
        return newText;
    }

    private boolean missingFontFamilyOrSize(Document doc) {
        return !doc.getDefaultRootElement().getAttributes().isDefined(StyleConstants.FontFamily) || !doc.getDefaultRootElement().getAttributes().isDefined(StyleConstants.FontSize);
    }

    public void mousePressed(PInputEvent event) {
        PNode pickedNode = event.getPickedNode();
        this.stopEditing(event);
        if (event.getButton() != 1) {
            return;
        }
        if (pickedNode instanceof PStyledText) {
            this.startEditing(event, (PStyledText)pickedNode);
        } else if (pickedNode instanceof PCamera) {
            PStyledText newText = this.createText();
            Insets pInsets = newText.getInsets();
            newText.translate(event.getPosition().getX() - (double)pInsets.left, event.getPosition().getY() - (double)pInsets.top);
            this.startEditing(event, newText);
        }
    }

    public void startEditing(PInputEvent event, PStyledText text) {
        Insets pInsets = text.getInsets();
        Point2D.Double nodePt = new Point2D.Double(text.getX() + (double)pInsets.left, text.getY() + (double)pInsets.top);
        text.localToGlobal(nodePt);
        event.getTopCamera().viewToLocal((Point2D)nodePt);
        this.editor.setDocument(text.getDocument());
        this.editor.setVisible(true);
        Insets bInsets = this.editor.getBorder().getBorderInsets(this.editor);
        this.editor.setLocation((int)((Point2D)nodePt).getX() - bInsets.left, (int)((Point2D)nodePt).getY() - bInsets.top);
        this.reshapeEditorLater();
        this.dispatchEventToEditor(event);
        this.canvas.repaint();
        text.setEditing(true);
        text.getDocument().addDocumentListener(this.docListener);
        this.editedText = text;
    }

    public void stopEditing(PInputEvent event) {
        if (this.editedText == null) {
            return;
        }
        this.editedText.getDocument().removeDocumentListener(this.docListener);
        this.editedText.setEditing(false);
        if (this.editedText.getDocument().getLength() == 0) {
            this.editedText.removeFromParent();
        } else {
            this.editedText.syncWithDocument();
        }
        if (this.editedText.getParent() == null) {
            this.editedText.setScale(1.0 / event.getCamera().getViewScale());
            this.canvas.getLayer().addChild((PNode)this.editedText);
        }
        this.editor.setVisible(false);
        this.canvas.repaint();
        this.editedText = null;
    }

    public void dispatchEventToEditor(final PInputEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MouseEvent me = new MouseEvent(PStyledTextEventHandler.this.editor, 501, event.getWhen(), event.getModifiers() | 0x10, (int)(event.getCanvasPosition().getX() - (double)PStyledTextEventHandler.this.editor.getX()), (int)(event.getCanvasPosition().getY() - (double)PStyledTextEventHandler.this.editor.getY()), 1, false);
                        PStyledTextEventHandler.this.editor.dispatchEvent(me);
                    }
                });
            }
        });
    }

    public void reshapeEditor() {
        if (this.editedText != null) {
            Dimension prefSize = this.editor.getPreferredSize();
            Insets textInsets = this.editedText.getInsets();
            Insets editorInsets = this.editor.getInsets();
            int width = this.editedText.getConstrainWidthToTextWidth() ? (int)prefSize.getWidth() : (int)(this.editedText.getWidth() - (double)textInsets.left - (double)textInsets.right + (double)editorInsets.left + (double)editorInsets.right + 3.0);
            prefSize.setSize((double)width, prefSize.getHeight());
            this.editor.setSize(prefSize);
            prefSize = this.editor.getPreferredSize();
            int height = this.editedText.getConstrainHeightToTextHeight() ? (int)prefSize.getHeight() : (int)(this.editedText.getHeight() - (double)textInsets.top - (double)textInsets.bottom + (double)editorInsets.top + (double)editorInsets.bottom + 3.0);
            prefSize.setSize(width, height);
            this.editor.setSize(prefSize);
        }
    }

    protected void reshapeEditorLater() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PStyledTextEventHandler.this.reshapeEditor();
            }
        });
    }

    private static final class DefaultTextEditor
    extends JTextPane {
        private static final long serialVersionUID = 1L;

        public DefaultTextEditor() {
            EmptyBorder padding = new EmptyBorder(3, 3, 3, 3);
            this.setBorder(new CompoundBorder(new LineBorder(Color.black), padding));
        }

        public void paint(Graphics graphics) {
            if (!(graphics instanceof Graphics2D)) {
                throw new IllegalArgumentException("Provided graphics context is not a Graphics2D object");
            }
            Graphics2D g2 = (Graphics2D)graphics;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            super.paint(graphics);
        }
    }
}

