# - Try to find JBig2Dec
# Once done this will define
#
#  JBIG2DEC_FOUND - system has JBig2Dec
#  JBIG2DEC_INCLUDE_DIR - The include directory for JBig2Dec headers
#  JBIG2DEC_LIBRARIES - Link these to use JBig2Dec
#
# Redistribution and use is allowed according to the terms of the BSD license.
#

if ( JBIG2DEC_LIBRARIES )
   # in cache already
   SET(JBig2Dec_FIND_QUIETLY TRUE)
endif ( JBIG2DEC_LIBRARIES )

# use pkg-config to get the directories and then use these values
# in the FIND_PATH() and FIND_LIBRARY() calls
if( NOT WIN32 )
  find_package(PkgConfig)

  pkg_check_modules(JBIG2DEC_PKG QUIET jbig2dec)
endif( NOT WIN32 )


# Find libjbig2dec and associated header files (Required)
FIND_LIBRARY(JBIG2DEC_LIBRARIES NAMES jbig2dec
  PATHS
    /usr/local
    /usr
  HINTS
    ${JBIG2DEC_PKG_LIBRARY_DIRS} # Generated by pkg-config
  PATH_SUFFIXES
    lib64
    lib
)
IF ( NOT(JBIG2DEC_LIBRARIES) )
  MESSAGE(STATUS "Could not find JBig2Dec library." )
ENDIF()


FIND_PATH(JBIG2DEC_INCLUDE_DIR NAMES jbig2.h
  PATHS
    /usr/local/include
    /usr/include
  HINTS
    ${JBIG2DEC_PKG_INCLUDE_DIRS} # Generated by pkg-config
  PATH_SUFFIXES
    openjpeg-1.4
)
IF ( NOT(JBIG2DEC_INCLUDE_DIR) )
  MESSAGE(STATUS "Could not find JBig2Dec headers." )
ENDIF ()

include(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(JBig2Dec DEFAULT_MSG JBIG2DEC_LIBRARIES JBIG2DEC_INCLUDE_DIR )


# show the JBIG2DEC_(XPDF/QT4)_INCLUDE_DIR and JBIG2DEC_LIBRARIES variables only in the advanced view
MARK_AS_ADVANCED(JBIG2DEC_INCLUDE_DIR JBIG2DEC_LIBRARIES)

