/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2011 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/


#include <math.h>
#include <float.h>
#include <stdio.h>
#include <gsl/gsl_sf_gamma.h>
#include <gsl/gsl_math.h>


double
MultivarLnGamma(const int k, const double a)
{
    int            i;
    double         mvlng;
    
    mvlng = 0.0;
    for (i = 0; i < k; ++i)
        mvlng += gsl_sf_lngamma(a - 0.5 * i);
    
    mvlng += 0.25 * k * (k - 1.0) * log(M_PI);
    
    return(mvlng);
}
