;;;; -*- Mode: lisp; indent-tabs-mode: nil -*-
;;;
;;; tf-openmcl.lisp --- OpenMCL trivial-features implementation.
;;;
;;; Copyright (C) 2007, Luis Oliveira  <loliveira@common-lisp.net>
;;;
;;; Permission is hereby granted, free of charge, to any person
;;; obtaining a copy of this software and associated documentation
;;; files (the "Software"), to deal in the Software without
;;; restriction, including without limitation the rights to use, copy,
;;; modify, merge, publish, distribute, sublicense, and/or sell copies
;;; of the Software, and to permit persons to whom the Software is
;;; furnished to do so, subject to the following conditions:
;;;
;;; The above copyright notice and this permission notice shall be
;;; included in all copies or substantial portions of the Software.
;;;
;;; THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
;;; EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;;; MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
;;; NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
;;; HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
;;; WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
;;; OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
;;; DEALINGS IN THE SOFTWARE.

(in-package :cl-user)

;;;; Endianness

(pushnew #+big-endian-target :big-endian
         #+little-endian-target :little-endian
         *features*)

;;;; OS

;;; OpenMCL already pushes :UNIX and :DARWIN.

#+linux-target (pushnew :linux *features*)

#+darwin (pushnew :bsd *features*)

#+solaris (pushnew :sunos *features*)

;;;; CPU

;;; what about ppc64?
#+ppc-target (pushnew :ppc *features*)
#+x8664-target (pushnew :x86-64 *features*)

#+64-bit-host (pushnew :64-bit *features*)
#+32-bit-host (pushnew :32-bit *features*)
