from _typeshed import SupportsRichComparison
from collections.abc import Callable, Generator, Iterable, Reversible

from networkx.classes.digraph import DiGraph
from networkx.classes.graph import Graph, _Node
from networkx.utils.backends import _dispatchable

@_dispatchable
def descendants(G: Graph[_Node], source: _Node) -> set[_Node]: ...
@_dispatchable
def ancestors(G: Graph[_Node], source: _Node) -> set[_Node]: ...
@_dispatchable
def is_directed_acyclic_graph(G: Graph[_Node]) -> bool: ...
@_dispatchable
def topological_generations(G: DiGraph[_Node]) -> Generator[list[_Node], None, None]: ...
@_dispatchable
def topological_sort(G: DiGraph[_Node]) -> Generator[_Node, None, None]: ...
@_dispatchable
def lexicographical_topological_sort(
    G: DiGraph[_Node], key: Callable[[_Node], SupportsRichComparison] | None = None
) -> Generator[_Node, None, None]: ...
@_dispatchable
def all_topological_sorts(G: DiGraph[_Node]) -> Generator[list[_Node], None, None]: ...
@_dispatchable
def is_aperiodic(G: DiGraph[_Node]) -> bool: ...
@_dispatchable
def transitive_closure(G: Graph[_Node], reflexive: bool = False) -> Graph[_Node]: ...
@_dispatchable
def transitive_closure_dag(G: DiGraph[_Node], reflexive: bool = False) -> DiGraph[_Node]: ...
@_dispatchable
def transitive_reduction(G: DiGraph[_Node]) -> DiGraph[_Node]: ...
@_dispatchable
def antichains(G: DiGraph[_Node], topo_order: Reversible[_Node] | None = None) -> Generator[list[_Node], None, None]: ...
@_dispatchable
def dag_longest_path(
    G: DiGraph[_Node], weight: str = "weight", default_weight: int = 1, topo_order: Iterable[_Node] | None = None
) -> list[_Node]: ...
@_dispatchable
def dag_longest_path_length(G: DiGraph[_Node], weight: str = "weight", default_weight: int = 1) -> int: ...
@_dispatchable
def dag_to_branching(G: Graph[_Node]) -> Graph[_Node]: ...
