# -*- coding: utf-8 -*-
#
# Copyright 2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Darwin specific tests for the main module."""

import os

from dirspec import basedir
from twisted.internet import defer

from ubuntu_kylin_sso.main import darwin
from ubuntu_kylin_sso.tests import TestCase

# because we are using twisted we have java like names C0103
# pylint: disable=C0103


class DarwinTestCase(TestCase):
    """Tests for module level misc functions"""

    def test_get_sso_pb_port(self):
        """Test the get_sso_pb_port function, by patching os.getuid"""
        expected = os.path.join(basedir.xdg_cache_home, 'sso', 'ipc')
        self.assertEqual(darwin.get_sso_domain_socket(), expected)


class DescriptionFactoryTestcase(TestCase):
    """Test the factory."""

    @defer.inlineCallbacks
    def setUp(self):
        """Set the tests."""
        yield super(DescriptionFactoryTestcase, self).setUp()
        self.domain = '/path/to/domain'
        self.patch(darwin, 'get_sso_domain_socket', lambda: self.domain)

    def test_server_description(self):
        """Test getting the description info."""
        expected = darwin.DescriptionFactory.server_description_pattern % \
                       self.domain
        factory = darwin.DescriptionFactory()
        self.assertEqual(expected, factory.server)

    def test_client_description(self):
        """Test getting the description info."""
        expected = darwin.DescriptionFactory.client_description_pattern % \
                       self.domain
        factory = darwin.DescriptionFactory()
        self.assertEqual(expected, factory.client)
