#! /usr/bin/python3
# -*- coding: utf-8 -*-
from gi.repository import Unity
from unittest import TestCase
import imp

class ResultSet(Unity.ResultSet):
    def __init__(self):
        Unity.ResultSet.__init__(self)
        self.results = []

    def do_add_result(self, result):
        self.results.append({'uri':result.uri,
                             'title':result.title,
                             'comment':result.comment,
                             'icon':result.icon_hint})


class ScopeTestCase(TestCase):
    def init_scope(self, scope_path):
        self.scope_module = imp.load_source('scope', scope_path)
        self.scope = self.scope_module.load_scope()

    def perform_query(self, query, filter_set = Unity.FilterSet.new()):
        result_set = ResultSet()
        ctx = Unity.SearchContext.create(query, 0, filter_set,
                                         None, result_set, None)
        s = self.scope.create_search_for_query(ctx)
        s.run()
        return result_set


class TestYahoostock(ScopeTestCase):
    def setUp(self):
        self.init_scope('src/unity_yahoostock_daemon.py')

    def tearDown(self):
        self.scope = None
        self.scope_module = None

    def test_valid_searches(self):
        self.scope_module.QUOTE_URL = 'file:tests/data/mock_yahoostock_%s_pass'
        self.scope_module.NEWS_URL = 'file:tests/data/mock_yahoostocknews_%s_pass'
        self.scope_module.FAKE_CALL = True
        expected_results = ['Google Inc.\n720.11@4:00pm\nVol: 1200\n']
        results = []
        for s in ['GOOG']:
            result_set = self.perform_query(s)
            results.append(result_set.results[0]['comment'])
        self.assertEqual(results, expected_results)

    def test_invalid_symbol(self):
        self.scope_module.QUOTE_URL = 'file:tests/data/mock_yahoostock_%s'
        self.scope_module.NEWS_URL = 'file:tests/data/mock_yahoostocknews_GOOG_fail#%s'
        self.scope_module.FAKE_CALL = True
        results = []
        for s in ['INVALIDSYMBOL']:
            result_set = self.perform_query(s)
            print (result_set.results)
            self.assertEqual(len(result_set.results), 0)


    def test_failing_search(self):
        self.scope_module.QUOTE_URL = 'file:tests/data/mock_yahoostock_%s_fail'
        self.scope_module.NEWS_URL = 'file:tests/data/mock_yahoostock_%s_fail'
        self.scope_module.FAKE_CALL = True
        for s in ['GOOG']:
            result_set = self.perform_query(s)
            self.assertEqual(len(result_set.results), 0)

if __name__ == '__main__':
    unittest.main()
