/*
 * Copyright (C) 2015 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of version 3 of the GNU Lesser General Public License as published
 * by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Pawel Stolowski <pawel.stolowski@canonical.com>
 */

#include <boost/python.hpp>
#include <unity/UnityExceptions.h>
#include <stdexcept>

using namespace boost::python;

static void translate_out_of_range(const std::out_of_range &e)
{
    PyErr_SetString(PyExc_IndexError, e.what());
}

static void translate_domain_error(const std::domain_error &e)
{
    PyErr_SetString(PyExc_ValueError, e.what());
}

void export_exceptions()
{
    register_exception_translator<std::out_of_range>(&translate_out_of_range);
    register_exception_translator<std::domain_error>(&translate_domain_error);
}
