/*****************************************************************************

	unsort - reorder files semi-randomly
	Copyright (C) 2008  Wessel Dankers <wsl@fruit.je>

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.

*****************************************************************************/

#ifndef MERGE_H
#define MERGE_H

#include <stdint.h>
#include <stdbool.h>

#include "filebuf.h"

typedef struct merge {
	uint32_t start;
	uint32_t count;
	uint32_t cursor;
	uint32_t ratio;
} merge_t;

extern const merge_t merge_0;

extern void merge_seed(uint32_t);
extern void merge_sort(merge_t *, uint32_t);
extern void merge(merge_t *, uint32_t, uint32_t *, uint32_t *, int);

#endif
