#!/bin/sh
# script pour mettre le readme dans le fichier readme.cpp
# a chaque compilation
# Auteur: Achraf cherti
# Email:  achrafcherti@gmail.com

# $1  LISEZMOI
# $2  cpp
# $3  func
function add_readme()
{
	# debut du fichier
	echo "#define ADD(s) textviewer->browser->add(s);" >> $2;
	echo "void $3(TextViewer *textviewer)" >> $2
	echo "{" >> $2

	echo -e "textviewer->browser->clear();" >> $2

	# il ecrit toutes les lignes!
	cat $1 | iconv -f utf8 -t iso8859-1 | sed -e 's/"/\\"/g' | awk '

	BEGIN {
		ignore=0
		titre=0
	}

	{ 
		c=substr($0,1,1)
		if(c=="=") {
			if(ignore) 
				titre=0
			else 
				titre=1

			ignore=0
		}
		else {
			if(titre) {
				print "\tADD(\"@C4@b" $0 "\");"
				ignore=1
			}
			else {
				if($1=="VBA" && $2=="Express" && $3=="") {
					print "\tADD(\"@C4@c@l@b" $0 "\");"
				}
				else
					print "\tADD(\"" $0 "\");"
			}
		}
	}

	' >> $2

	# fin du fichier
	echo -e "\ttextviewer->show();" >> $2
	echo "}" >> $2
	echo "" >> $2
}

function tester()
{
	if ! [ -e "$1" ]; then
		echo Assurez vous de lancer ce fichier depuis le repertoire principal
		echo de la source...
	fi
}

tester src
tester misc

> src/readme.cpp

echo "#include \"interface.h\"" >> src/readme.cpp
echo "" >> src/readme.cpp

add_readme LISEZMOI.txt src/readme.cpp show_readme_fr
add_readme README.txt src/readme.cpp show_readme_en

