/*
 *   This file is part of VBA Express.
 *
 *   Copyright (c) 2005-2006 Achraf cherti <achrafcherti@gmail.com>
 * 
 *   VBA Express is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   VBA Express is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with VBA Express; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/********************************************
 * Fonctions pour prendre une touche
 * clavier SDL
 *******************************************/

#include <stdio.h>
#include <stdlib.h>
#include <SDL/SDL.h>
#include <FL/Fl.H>
#include <FL/fl_ask.H>
#include "interface.h"

static bool stop = false;
extern Interface *I;

#define GETHATCODE(event) ((event.jhat.which+1)<<12)|(event.jhat.hat<<2)|\
  (event.jhat.value & SDL_HAT_UP ? 0 : event.jhat.value & SDL_HAT_DOWN ? 1 : event.jhat.value & SDL_HAT_RIGHT ? 2 : event.jhat.value & SDL_HAT_LEFT ? 3 : 0)

#define GETBUTTONCODE(event) ((event.jbutton.which+1)<<12)|(event.jbutton.button+0x80)

#define GETAXISCODE(event) ((event.jaxis.which+1)<<12)|(event.jaxis.axis<<1)|(event.jaxis.value > 16384 ? 1 : event.jaxis.value < -16384 ? 0 : 0)

/**********************************************************************
 * fonction interne pour lire une touche
 *********************************************************************/
static bool poll(int *key)
{
  SDL_Event event;
  while(SDL_PollEvent(&event)) {
    switch(event.type) {
    case SDL_JOYHATMOTION:
	*key=GETHATCODE(event);
	return true;
    case SDL_JOYBUTTONDOWN:
	*key=GETBUTTONCODE(event);
	return true;
    case SDL_JOYAXISMOTION:
	*key=GETAXISCODE(event);
	return true;
    case SDL_KEYDOWN:
	*key=event.key.keysym.sym;
	return true;
    case SDL_KEYUP:
        *key=SDLK_ESCAPE;
	return true;
    case SDL_QUIT:
        stop=1;
        return false;
    }
  }
  return false;
}

/**********************************************************************
 * Configuration du getkey
 **********************************************************************/
int w=100,h=100;
void vba_getkey_wh(int _w, int _h)
{
	w=_w;
	h=_h;
}

/**********************************************************************
 * Prendre une touche clavier
 * -1s si erreur...
 *********************************************************************/
int vba_getkey(int actual)
{
  bool ok=false;
  int var=actual;

  if(SDL_Init(SDL_INIT_TIMER|SDL_INIT_VIDEO|SDL_INIT_NOPARACHUTE)) {
    fl_alert("Failed to init SDL: %s\n", SDL_GetError());
    return actual;
  }

  if(SDL_InitSubSystem(SDL_INIT_JOYSTICK)) {
    fl_alert("Failed to init joystick: %s\n", SDL_GetError());
    return actual;
  }

  SDL_Surface *surface = SDL_SetVideoMode(w,h, 16,
                                          SDL_ANYFORMAT);
  if(!surface) {
  	fl_alert("Failed du init screen %ix%i...",w,h);
	return -1;
  }

  SDL_WM_SetCaption("Press a key...",0);
  
  int numJoy = SDL_NumJoysticks();
  
  for(int i = 0; i < numJoy; i++) {
    SDL_JoystickOpen(i);
  }
  SDL_JoystickEventState(SDL_ENABLE);

  I->MainWindow->deactivate();
  while(!stop) {
    if(poll(&var)) { ok=true; break; }
    SDL_Delay(100);
    Fl::wait();
  }
  SDL_Quit();
  I->MainWindow->activate();

  stop=0;

  if(ok) return var; else return actual;
}


