README for vmdb2 or vmdebootstrap 2nd generation     ; -*- mode: markdown;-*-
=============================================================================

[vmdb2][] is a program for producing a disk image with Debian
installed.

[vmdb2]: https://vmdb2.liw.fi/

Introduction
-----------------------------------------------------------------------------

[vmdebootstrap][] installs Debian onto a disk image. It is like the
[debootstrap][] tool, except the end result is a bootable disk image,
not a directory. vmdebootstrap takes care of creating partitions, and
filesystems, and allows some more customization than the older
vmdebootstrap does.

vmdebootstrap is also a messy pile of kludge, and rather inflexible.
vmdb2 is a re-implementation from scratch, without a need for
backwards compatibility. It aims to provide more flexibility than
vmdebootstrap, without becoming anywhere near as complicated. Think of
vmdb2 as "vmdebootstrap the second generation". The name has changed
to allow the two tools to installable in parallel, which is important
for a transition period.

The main user-visible difference between vmdebootstrap and vmdb2 is
that the older program provides extensibility via a legion of command
line options and the newer program by providing a domain specific
language to express what kind of Debian system is to be created.

(Lars Wirzenius wrote both vmdebootstrap and vmdb2 and is entitled to
sneer at his younger self. It's his way of dealing with the mountain
of guilt of making something as awful as vmdebootstrap.)

[vmdebootstrap]: http://liw.fi/vmdebootstrap/
[debootstrap]: https://packages.debian.org/unstable/debootstrap


Getting vmdb2
-----------------------------------------------------------------------------

vmdb2 source code is available via git:

* <http://git.liw.fi/vmdb2>
* <https://gitlab.com/larswirzenius/vmdb2>

It used to be on GitHub as well, but was withdrawn from there due to
GitHub being a proprietary service.

Requirements:

The following tools are used by vmdb2 (Debian package names in brackets).

* `kpartx` [kpartx, mkpart command]
* `parted` [`parted`, mklabel command]
* `qemu-img` [`qemu-utils`, mkimg command]
* `qemu-user-static` [`qemu-user-static`, qemu-debootstrap command]

The following Python modules are used by vmdb2 (Debian package names in brackets).

* cliapp [`python3-cliapp`]
* jinja2 [`python3-jinja2`]
* yaml [`python3-yaml`]


Dependencies for smoke.sh
-----------------------------------------------------------------------------

You probably need the following installed to run the smoke test:

- git
- python3-coverage-test-runner
- python3-cliapp
- python3-jinja2
- cmdtest 0.31 or later
- qemu-utils
- parted
- kpartx
- debootstrap
- expect
- qemu-system


Tutorial
-----------------------------------------------------------------------------

To use vmdb2, git clone the source and at the root of the source tree
run the following command:

    sudo ./vmdb2 --output simple.img simple.vmdb --log simple.log

`--output simple.img` specifies that the output image is called
`simple.img`, the specification is `simple.vmdb` and the log file goes
to `simple.log`.


Plugins and steps
-----------------------------------------------------------------------------

The `vmdb2` architecture consists of a main program that reads the
input file, finds a matching "step runner" for each step used in the
input file, and then runs the steps in order. If there's a problem, it
runs corresponding "teardown" steps in reverse order of the steps.

A step might be "mount this filesystem", and the corresponding
teardown is "unmount".

Steps (and teardowns) are provided by plugins; see the `vmdb/plugins`
directory in the source tree. Steps are intended to be very cohesive
and lowly coupled. They may share some state (such as mounted
filesystems) via the `State` object, but not in any other way. A
plugin may provide multiple steps.

See the plugin directory for which steps currently exist. A list of
steps that will become incomplete as soon as development continues:

* chroot (run shell snippet in chroot)
* shell (run shell snippet without chroot)
* debootstrap (run deboostrap)
* apt (install packagers in chroot with apt)
* mkimg (create disk image)
* mklabel (create partition table on a disk image)
* mkpart (create partition)
* mkfs (create filesystem in a partition)
* mount (mount filesystem, teardown unmounts it automatically)

See `simple.vmdb` for examples. Note how the file uses Jinja2
templating for value fields to get value of `--output` in the right
places. Also note how creating a partition or mounting a filesystem
assigns a "tag" that can be referenced in steps where the
partition/filesystem is needed, without having to know the actual path
to the device node or mount point.


Writing plugins
-----------------------------------------------------------------------------

More step runners would be good, and will be added based on
actual reported needs by users ("I need to have this to..."), not
speculatively ("This seems like a good idea").

To write a plugin, see the existing ones for examples, and put it in
`vmdb/plugins/foo_plugin.py` for some value of `foo`.

Plugins are meant to be very easy to write. If not, there's probably
something wrong with `vmdb2`. Please raise the issue.


Hacking
-----------------------------------------------------------------------------

To run automated tests:

    ./check

This only runs the unit tests and build tests. To run a smoke test
that actually builds and boots images:

    sudo ./smoke.sh cache.tar.gz

where `cache.tar.gz` caches the debootstrap output for a future run.

You'll need the yarn program (part of the [cmdtest][] package), and
also [CoverageTestRunner][] for running the unit tests.

[cmdtest]: http://liw.fi/cmdtest/
[CoverageTestRunner]: http://liw.fi/coverage-test-runner/


Contact
-----------------------------------------------------------------------------

To contact Lars, email is best: `liw@liw.fi`.

There is an IRC channel for vmdb2: irc.oftc.net network, `#vmdb2`.


Legalese
-----------------------------------------------------------------------------

Copyright 2017-2019  Lars Wirzenius

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

=*= License: GPL-3+ =*=
