# Экземпляр Router

### Свойства

#### router.app

- тип: `Vue instance`

  Корневой экземпляр Vue, в который был интегрирован `router`.

#### router.mode

- тип: `string`

  [Режим](options.md#mode), используемый роутером.

#### router.currentRoute

- тип: `Route`

  Текущий путь в виде [объекта Route](route-object.md).

### Методы

- **router.beforeEach(guard)**
- **router.beforeResolve(guard)** (добавлено в версии 2.5.0+)
- **router.afterEach(hook)**

  См. [сторожевые хуки](../advanced/navigation-guards.md).

  С версии 2.5.0+ все три метода возвращают функцию, которая удаляет зарегистрированный хук.

- **router.push(location, onComplete?, onAbort?)**
- **router.replace(location, onComplete?, onAbort?)**
- **router.go(n)**
- **router.back()**
- **router.forward()**

  Методы для императивного перехода к новому URL. См. [Императивная навигация](../essentials/navigation.md).

- **router.getMatchedComponents(location?)**

  Возвращает массив компонентов (определение/конструктор, не экземпляры), совпадающих с текущим путём. В основном используется во время рендеринга на сервере для получения необходимых данных.

- **router.resolve(location, current?, append?)**

  > 2.1.0+

  Служит для обратного разрешения URL. Получая на вход путь в том же формате, что используется `<router-link/>`, возвращает объект со следующими свойствами:

  ``` js
  {
    location: Location;
    route: Route;
    href: string;
  }
  ```

  - `current` — текущий маршрут по умолчанию (в большинстве случаем вам не нужно это изменять)
  - `append` — позволяет вам добавить путь к маршруту `current` (например, с помощью [`router-link`](router-link.md#props))

- **router.addRoutes(routes)**

  > 2.2.0+

  Динамически добавить дополнительные маршруты в маршрутизатор. Аргументом должен быть массив маршрутов в таком же формате как и в опции `routes` конструктора.

- **router.onReady(callback[, errorCallback])**

  > 2.2.0+

  Этот метод добавляет в очередь коллбек, который будет вызван когда маршрутизатор завершит начальную навигацию, что означает что будут завершены все асинхронные хуки и будут готовы асинхронные компоненты связанные с начальным маршрутом.

  Это будет полезно при рендеринге на стороне сервера для обеспечения одинакового результата как на сервере, так и на клиенте.

  Второй аргумент `errorCallback` поддерживается только в версиях 2.4+. Он вызывается, когда исходное разрешение маршрута заканчивается ошибкой (например, не удалось разрешить асинхронный компонент).

- **router.onError(callback)**

  > Добавлено в версии 2.4.0+

  Регистрация коллбека, который будет вызываться при ошибках во время навигации по маршруту. Обратите внимание, что для вызова ошибки должен быть использован один из следующих сценариев:

  - Ошибка произошла синхронно внутри функции маршрута;

  - Ошибка фиксируется и асинхронно обрабатывается с помощью `next(err)` внутри функции сторожевого хука;

  - Произошла ошибка при попытке разрешить асинхронный компонент, необходимый для отображения маршрута.
