# WasmEdge Roadmap

## About this document

This document should serve as a reference point for WasmEdge users and contributors to understand where the project is heading, and help determine if a contribution could be conflicting with a longer term plan.

## How to help?

Discussion on the roadmap can take place in threads under [Issues](https://github.com/WasmEdge/WasmEdge/issues). Please open and comment on an issue if you want to give suggestions and feedback to items in the roadmap. Please review the roadmap to avoid potential duplicated efforts.

## How to add an item to the roadmap?

Please open an issue to track any initiative on the roadmap of WasmEdge (Usually driven by new feature requests). We will work with and rely on our community to focus our efforts to improve WasmEdge.

## Current Roadmap

The following table includes the current roadmap for WasmEdge. If you have any questions or would like to contribute to WasmEdge, please create an issue to discuss with our team. If you don't know where to start, we are always looking for contributors that will help us reduce technical, automation, and documentation debt. Please take the timelines & dates as proposals and goals. Priorities and requirements change based on community feedback, roadblocks encountered, community contributions, etc.

Last Updated: Mar 2023

| Theme                     | Description | Timeline |
| ---                       | --- | --- |
| Proposal                  | Function reference proposal | Q2 / 2023 |
| Proposal                  | Exception handling proposal | Q2 / 2023 |
| Proposal                  | Typed continuation proposal | Q2 / 2023 |
| Proposal                  | Stack-switch proposal       | Q2 / 2023 |
| Proposal                  | GC proposal                 | Q2 / 2023 |
| Feature                   | WasmEdge unified tool       | Q2 / 2023 |
| Feature                   | WASM serialization/deserialization | Q2 / 2023 |
| Proposal                  | WASI signature proposal     | Q3 / 2023 |
| Feature                   | Enhance info/debug logging, provide verbose mode (wasmedge a.wasm –verbose=3) | Q3 / 2023 |
| Feature                   | Wasm coredump | Q3 / 2023 |
| Proposal                  | WASM C API proposal | Q4 / 2023 |
| Proposal                  | WASM memory64 proposal | Q4 / 2023 |
| Feature                   | WASI-NN training extension | Q4 / 2023 |
| Feature                   | DWARF symbol | Q4 / 2023 |
| Proposal                  | Component model proposal    | ?? / 2023 |
| Languages Bindings        | [Python SDK](https://github.com/WasmEdge/WasmEdge/pull/633) | ?? / 2023 |
| Feature                   | Enable PaddlePaddle backend for WASI-NN | ?? / 2023 |
| Open Source Collaboration | Eventmesh, Krustlet, APISIX, Dapr, MOSN, KubeEdge, OpenYurt, Fedora, SuperEdge, UDF for SaaS and Databases, Substrate, ParaState, Filecoin | long term work |
