# -*- coding: utf-8 -*-
"""
w2lapp.login.py: bind with a specific bind DN and password

web2ldap - a web-based LDAP Client,
see http://www.web2ldap.de for details

(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)
"""

import w2lapp.core,w2lapp.gui,w2lapp.cnf

##############################################################################
# Login form
##############################################################################

def w2l_Login(
  sid,outf,command,form,ls,dn,connLDAPUrl,login_search_root,
  title_msg=u'Bind',
  login_msg='',
  who='',relogin=0,nomenu=0,
  login_default_mech=None
):
  """
  Provide a input form for doing a (re-)login
  """
  if 'login_who' in form.inputFieldNames:
    who = form.field['login_who'].value[0]

  login_search_root_field = w2lapp.gui.SearchRootField(form,ls,dn,name='login_search_root')
  login_search_root_field.setDefault(login_search_root or u'')

  login_template_str = w2lapp.gui.ReadTemplate(form,ls,'login_template',u'login form')

  if nomenu:
    w2lapp.gui.PrintHeader(sid,outf,form,login_msg,w2lapp.cnf.GetParam(ls,'link_css',''))
    w2lapp.gui.StatusLine(sid,outf,form,ls,dn)
  else:
    w2lapp.gui.TopSection(
      sid,outf,form,ls,dn,
      login_msg,
      w2lapp.gui.MainMenu(sid,form,ls,dn),
      context_menu_list=[]
    )

  if ls.rootDSE:
    form.field['login_mech'].setOptions(ls.rootDSE.get('supportedSASLMechanisms',None))

  # Determine the bind mech to be used from the form data or the key-word argument login_default_mech
  login_mech = form.getInputValue('login_mech',[w2lapp.cnf.GetParam(ls,'login_default_mech','')])[0] or login_default_mech or ''

  login_fields = login_template_str.format(
    field_login_mech=form.field['login_mech'].inputHTML(default=login_mech),
    value_ldap_who=form.utf2display(who),
    value_ldap_filter=form.utf2display(unicode(w2lapp.cnf.GetParam(ls,'binddnsearch',r'(uid=%s)'))),
    field_login_search_root=login_search_root_field.inputHTML(),
    field_login_authzid_prefix=form.field['login_authzid_prefix'].inputHTML(),
    value_submit={0:'Login',1:'Retry w/login'}[relogin],
  )

  scope_str = form.getInputValue('scope',[None])[0]
  if not scope_str and connLDAPUrl.scope!=None:
    scope_str = unicode(connLDAPUrl.scope)
  if scope_str:
    scope_hidden_field = form.hiddenFieldHTML('scope',scope_str,u'')
  else:
    scope_hidden_field = ''

  filterstr = form.getInputValue('filterstr',[(connLDAPUrl.filterstr or '').decode(ls.charset)])[0]
  if filterstr:
    filterstr_hidden_field = form.hiddenFieldHTML('filterstr',filterstr,u'')
  else:
    filterstr_hidden_field = ''

  search_attrs_hidden_field = ''
  if command in ('search','searchform'):
    search_attrs = form.getInputValue('search_attrs',[u','.join(connLDAPUrl.attrs or [])])[0]
    if search_attrs:
      search_attrs_hidden_field = form.hiddenFieldHTML('search_attrs',search_attrs,u'')

  if login_msg:
    login_msg_html = '<p class="ErrorMessage">%s</p>' % (login_msg)
  else:
    login_msg_html = ''

  outf.write("""
<div class="Main">
  <h1>%s</h1>

  %s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s
"""  % (
      form.utf2display(title_msg),
      login_msg_html,
      form.beginFormHTML(command,None,'POST',None),
      form.hiddenFieldHTML('ldapurl',ls.uri.decode('ascii'),u''),
      form.hiddenFieldHTML('dn',dn,u''),
      form.hiddenFieldHTML('delsid',sid.decode('ascii'),u''),
      scope_hidden_field,
      filterstr_hidden_field,
      login_fields,
      search_attrs_hidden_field,
    )
  )
  if relogin:
    form.hiddenInputFields(
      outf=outf,
      ignoreFieldNames=[
        'sid','delsid',
        'ldapurl','host','who','cred','dn','scope','filterstr','search_attrs',
        'login_mech','login_authzid','login_authzid_prefix','login_realm',
        'login_search_root','login_filterstr'
      ]
    )
  outf.write('</form>\n</div>\n')
  w2lapp.gui.PrintFooter(outf,form)

