# -*- coding: utf-8 -*-
#
# Copyright (c) 2016 Wil Clouser <clouserw@micropipes.com>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# Intercepts emoji characters and converts them back to their alias.  Useful if
# you're on a terminal or something that doesn't support emoji.
#
# History:
#
#   2016-03-15, Wil Clouser <clouserw@micropipes.com>:
#       v0.1: Initial release, based on Mike Reinhardt's BSD
#             licensed emoji_aliases.py

SCRIPT_NAME    = "emoji2alias"
SCRIPT_AUTHOR  = "Wil Clouser <clouserw@micropipes.com>"
SCRIPT_VERSION = "0.1"
SCRIPT_LICENSE = "MIT"
SCRIPT_DESC    = "Replaces emoji characters with their aliases"

import_ok = True

try:
   import weechat as w
except:
   print "Script must be run under weechat. http://www.weechat.org"
   import_ok = False

import re

EMOJI_ALIASES = {
    u'\U0001F44D': u':+1:',
    u'\U0001F44E': u':-1:',
    u'\U0001F4AF': u':100:',
    u'\U0001F522': u':1234:',
    u'\U0001F3B1': u':8ball:',
    u'\U0001F170': u':a:',
    u'\U0001F18E': u':ab:',
    u'\U0001F524': u':abc:',
    u'\U0001F521': u':abcd:',
    u'\U0001F251': u':accept:',
    u'\U0001F39F': u':admission_tickets:',
    u'\U0001F6A1': u':aerial_tramway:',
    u'\U00002708': u':airplane:',
    u'\U0001F6EC': u':airplane_arriving:',
    u'\U0001F6EB': u':airplane_departure:',
    u'\U000023F0': u':alarm_clock:',
    u'\U00002697': u':alembic:',
    u'\U0001F47D': u':alien:',
    u'\U0001F47E': u':alien_monster:',
    u'\U0001F691': u':ambulance:',
    u'\U0001F3C8': u':american_football:',
    u'\U0001F3FA': u':amphora:',
    u'\U00002693': u':anchor:',
    u'\U0001F47C': u':angel:',
    u'\U0001F4A2': u':anger:',
    u'\U0001F4A2': u':anger_symbol:',
    u'\U0001F620': u':angry:',
    u'\U0001F620': u':angry_face:',
    u'\U0001F627': u':anguished:',
    u'\U0001F627': u':anguished_face:',
    u'\U0001F41C': u':ant:',
    u'\U0001F4F6': u':antenna_with_bars:',
    u'\U0001F34E': u':apple:',
    u'\U00002652': u':aquarius:',
    u'\U00002648': u':aries:',
    u'\U000025C0': u':arrow_backward:',
    u'\U000023EC': u':arrow_double_down:',
    u'\U000023EB': u':arrow_double_up:',
    u'\U00002B07': u':arrow_down:',
    u'\U0001F53D': u':arrow_down_small:',
    u'\U000025B6': u':arrow_forward:',
    u'\U00002935': u':arrow_heading_down:',
    u'\U00002934': u':arrow_heading_up:',
    u'\U00002B05': u':arrow_left:',
    u'\U00002199': u':arrow_lower_left:',
    u'\U00002198': u':arrow_lower_right:',
    u'\U000027A1': u':arrow_right:',
    u'\U000021AA': u':arrow_right_hook:',
    u'\U00002B06': u':arrow_up:',
    u'\U00002195': u':arrow_up_down:',
    u'\U0001F53C': u':arrow_up_small:',
    u'\U00002196': u':arrow_upper_left:',
    u'\U00002197': u':arrow_upper_right:',
    u'\U0001F503': u':arrows_clockwise:',
    u'\U0001F504': u':arrows_counterclockwise:',
    u'\U0001F3A8': u':art:',
    u'\U0001F69B': u':articulated_lorry:',
    u'\U0001F3A8': u':artist_palette:',
    u'\U0001F632': u':astonished:',
    u'\U0001F632': u':astonished_face:',
    u'\U0001F45F': u':athletic_shoe:',
    u'\U0001F3E7': u':atm:',
    u'\U0000269B': u':atom_symbol:',
    u'\U0001F346': u':aubergine:',
    u'\U0001F3E7': u':automated_teller_machine:',
    u'\U0001F697': u':automobile:',
    u'\U0001F171': u':b:',
    u'\U0001F476': u':baby:',
    u'\U0001F47C': u':baby_angel:',
    u'\U0001F37C': u':baby_bottle:',
    u'\U0001F424': u':baby_chick:',
    u'\U0001F6BC': u':baby_symbol:',
    u'\U0001F519': u':back:',
    u'\U0001F519': u':back_with_leftwards_arrow_above:',
    u'\U0001F42B': u':bactrian_camel:',
    u'\U0001F3F8': u':badminton_racquet_and_shuttlecock:',
    u'\U0001F6C4': u':baggage_claim:',
    u'\U0001F388': u':balloon:',
    u'\U0001F5F3': u':ballot_box_with_ballot:',
    u'\U00002611': u':ballot_box_with_check:',
    u'\U0001F38D': u':bamboo:',
    u'\U0001F34C': u':banana:',
    u'\U0000203C': u':bangbang:',
    u'\U0001F3E6': u':bank:',
    u'\U0001F4B5': u':banknote_with_dollar_sign:',
    u'\U0001F4B6': u':banknote_with_euro_sign:',
    u'\U0001F4B7': u':banknote_with_pound_sign:',
    u'\U0001F4B4': u':banknote_with_yen_sign:',
    u'\U0001F4CA': u':bar_chart:',
    u'\U0001F488': u':barber:',
    u'\U0001F488': u':barber_pole:',
    u'\U0001F325': u':barely_sunny:',
    u'\U000026BE': u':baseball:',
    u'\U0001F3C0': u':basketball:',
    u'\U0001F3C0': u':basketball_and_hoop:',
    u'\U0001F6C0': u':bath:',
    u'\U0001F6C1': u':bathtub:',
    u'\U0001F50B': u':battery:',
    u'\U0001F3D6': u':beach_with_umbrella:',
    u'\U0001F43B': u':bear:',
    u'\U0001F43B': u':bear_face:',
    u'\U0001F493': u':beating_heart:',
    u'\U0001F6CF': u':bed:',
    u'\U0001F41D': u':bee:',
    u'\U0001F37A': u':beer:',
    u'\U0001F37A': u':beer_mug:',
    u'\U0001F37B': u':beers:',
    u'\U0001F41E': u':beetle:',
    u'\U0001F530': u':beginner:',
    u'\U0001F514': u':bell:',
    u'\U0001F515': u':bell_with_cancellation_stroke:',
    u'\U0001F6CE': u':bellhop_bell:',
    u'\U0001F371': u':bento:',
    u'\U0001F371': u':bento_box:',
    u'\U0001F6B2': u':bicycle:',
    u'\U0001F6B4': u':bicyclist:',
    u'\U0001F6B2': u':bike:',
    u'\U0001F459': u':bikini:',
    u'\U0001F3B1': u':billiards:',
    u'\U00002623': u':biohazard_sign:',
    u'\U0001F426': u':bird:',
    u'\U0001F382': u':birthday:',
    u'\U0001F382': u':birthday_cake:',
    u'\U000026AB': u':black_circle:',
    u'\U000023FA': u':black_circle_for_record:',
    u'\U00002663': u':black_club_suit:',
    u'\U00002666': u':black_diamond_suit:',
    u'\U000023EC': u':black_down-pointing_double_triangle:',
    u'\U00002665': u':black_heart_suit:',
    u'\U0001F0CF': u':black_joker:',
    u'\U00002B1B': u':black_large_square:',
    u'\U000023EA': u':black_left-pointing_double_triangle:',
    u'\U000025C0': u':black_left-pointing_triangle:',
    u'\U000025FE': u':black_medium_small_square:',
    u'\U000025FC': u':black_medium_square:',
    u'\U00002712': u':black_nib:',
    u'\U00002753': u':black_question_mark_ornament:',
    u'\U000023E9': u':black_right-pointing_double_triangle:',
    u'\U000025B6': u':black_right-pointing_triangle:',
    u'\U000027A1': u':black_rightwards_arrow:',
    u'\U00002702': u':black_scissors:',
    u'\U000025AA': u':black_small_square:',
    u'\U00002660': u':black_spade_suit:',
    u'\U0001F532': u':black_square_button:',
    u'\U000023F9': u':black_square_for_stop:',
    u'\U00002600': u':black_sun_with_rays:',
    u'\U0000260E': u':black_telephone:',
    u'\U0000267B': u':black_universal_recycling_symbol:',
    u'\U000023EB': u':black_up-pointing_double_triangle:',
    u'\U0001F33C': u':blossom:',
    u'\U0001F421': u':blowfish:',
    u'\U0001F4D8': u':blue_book:',
    u'\U0001F699': u':blue_car:',
    u'\U0001F499': u':blue_heart:',
    u'\U0001F60A': u':blush:',
    u'\U0001F417': u':boar:',
    u'\U000026F5': u':boat:',
    u'\U0001F4A3': u':bomb:',
    u'\U0001F4D6': u':book:',
    u'\U0001F516': u':bookmark:',
    u'\U0001F4D1': u':bookmark_tabs:',
    u'\U0001F4DA': u':books:',
    u'\U0001F4A5': u':boom:',
    u'\U0001F462': u':boot:',
    u'\U0001F37E': u':bottle_with_popping_cork:',
    u'\U0001F490': u':bouquet:',
    u'\U0001F647': u':bow:',
    u'\U0001F3F9': u':bow_and_arrow:',
    u'\U0001F3B3': u':bowling:',
    u'\U0001F466': u':boy:',
    u'\U0001F35E': u':bread:',
    u'\U0001F470': u':bride_with_veil:',
    u'\U0001F309': u':bridge_at_night:',
    u'\U0001F4BC': u':briefcase:',
    u'\U0001F494': u':broken_heart:',
    u'\U0001F41B': u':bug:',
    u'\U0001F3D7': u':building_construction:',
    u'\U0001F4A1': u':bulb:',
    u'\U0001F685': u':bullettrain_front:',
    u'\U0001F684': u':bullettrain_side:',
    u'\U0001F32F': u':burrito:',
    u'\U0001F68C': u':bus:',
    u'\U0001F68F': u':bus_stop:',
    u'\U0001F68F': u':busstop:',
    u'\U0001F464': u':bust_in_silhouette:',
    u'\U0001F465': u':busts_in_silhouette:',
    u'\U0001F335': u':cactus:',
    u'\U0001F370': u':cake:',
    u'\U0001F4C5': u':calendar:',
    u'\U0001F4C6': u':calendar:',
    u'\U0001F4F2': u':calling:',
    u'\U0001F42B': u':camel:',
    u'\U0001F4F7': u':camera:',
    u'\U0001F4F8': u':camera_with_flash:',
    u'\U0001F3D5': u':camping:',
    u'\U0000264B': u':cancer:',
    u'\U0001F56F': u':candle:',
    u'\U0001F36C': u':candy:',
    u'\U0001F520': u':capital_abcd:',
    u'\U00002651': u':capricorn:',
    u'\U0001F697': u':car:',
    u'\U0001F5C3': u':card_file_box:',
    u'\U0001F4C7': u':card_index:',
    u'\U0001F5C2': u':card_index_dividers:',
    u'\U0001F3A0': u':carousel_horse:',
    u'\U0001F38F': u':carp_streamer:',
    u'\U0001F408': u':cat2:',
    u'\U0001F408': u':cat:',
    u'\U0001F431': u':cat:',
    u'\U0001F431': u':cat_face:',
    u'\U0001F639': u':cat_face_with_tears_of_joy:',
    u'\U0001F63C': u':cat_face_with_wry_smile:',
    u'\U0001F4BF': u':cd:',
    u'\U000026D3': u':chains:',
    u'\U0001F37E': u':champagne:',
    u'\U0001F4B9': u':chart:',
    u'\U0001F4C9': u':chart_with_downwards_trend:',
    u'\U0001F4C8': u':chart_with_upwards_trend:',
    u'\U0001F4B9': u':chart_with_upwards_trend_and_yen_sign:',
    u'\U0001F3C1': u':checkered_flag:',
    u'\U0001F4E3': u':cheering_megaphone:',
    u'\U0001F9C0': u':cheese_wedge:',
    u'\U0001F3C1': u':chequered_flag:',
    u'\U0001F352': u':cherries:',
    u'\U0001F338': u':cherry_blossom:',
    u'\U0001F330': u':chestnut:',
    u'\U0001F414': u':chicken:',
    u'\U0001F6B8': u':children_crossing:',
    u'\U0001F43F': u':chipmunk:',
    u'\U0001F36B': u':chocolate_bar:',
    u'\U0001F384': u':christmas_tree:',
    u'\U000026EA': u':church:',
    u'\U0001F3A6': u':cinema:',
    u'\U0001F251': u':circled_ideograph_accept:',
    u'\U0001F250': u':circled_ideograph_advantage:',
    u'\U00003297': u':circled_ideograph_congratulation:',
    u'\U00003299': u':circled_ideograph_secret:',
    u'\U000024C2': u':circled_latin_capital_letter_m:',
    u'\U0001F3AA': u':circus_tent:',
    u'\U0001F307': u':city_sunrise:',
    u'\U0001F306': u':city_sunset:',
    u'\U0001F3D9': u':cityscape:',
    u'\U0001F306': u':cityscape_at_dusk:',
    u'\U0001F191': u':cl:',
    u'\U0001F44F': u':clap:',
    u'\U0001F3AC': u':clapper:',
    u'\U0001F3AC': u':clapper_board:',
    u'\U0001F44F': u':clapping_hands_sign:',
    u'\U0001F3DB': u':classical_building:',
    u'\U0001F37B': u':clinking_beer_mugs:',
    u'\U0001F4CB': u':clipboard:',
    u'\U0001F565': u':clock1030:',
    u'\U0001F559': u':clock10:',
    u'\U0001F566': u':clock1130:',
    u'\U0001F55A': u':clock11:',
    u'\U0001F567': u':clock1230:',
    u'\U0001F55B': u':clock12:',
    u'\U0001F55C': u':clock130:',
    u'\U0001F550': u':clock1:',
    u'\U0001F55D': u':clock230:',
    u'\U0001F551': u':clock2:',
    u'\U0001F55E': u':clock330:',
    u'\U0001F552': u':clock3:',
    u'\U0001F55F': u':clock430:',
    u'\U0001F553': u':clock4:',
    u'\U0001F560': u':clock530:',
    u'\U0001F554': u':clock5:',
    u'\U0001F561': u':clock630:',
    u'\U0001F555': u':clock6:',
    u'\U0001F562': u':clock730:',
    u'\U0001F556': u':clock7:',
    u'\U0001F563': u':clock830:',
    u'\U0001F557': u':clock8:',
    u'\U0001F564': u':clock930:',
    u'\U0001F558': u':clock9:',
    u'\U0001F563': u':clock_face_eight-thirty:',
    u'\U0001F557': u':clock_face_eight_oclock:',
    u'\U0001F566': u':clock_face_eleven-thirty:',
    u'\U0001F55A': u':clock_face_eleven_oclock:',
    u'\U0001F560': u':clock_face_five-thirty:',
    u'\U0001F554': u':clock_face_five_oclock:',
    u'\U0001F55F': u':clock_face_four-thirty:',
    u'\U0001F553': u':clock_face_four_oclock:',
    u'\U0001F564': u':clock_face_nine-thirty:',
    u'\U0001F558': u':clock_face_nine_oclock:',
    u'\U0001F55C': u':clock_face_one-thirty:',
    u'\U0001F550': u':clock_face_one_oclock:',
    u'\U0001F562': u':clock_face_seven-thirty:',
    u'\U0001F556': u':clock_face_seven_oclock:',
    u'\U0001F561': u':clock_face_six-thirty:',
    u'\U0001F555': u':clock_face_six_oclock:',
    u'\U0001F565': u':clock_face_ten-thirty:',
    u'\U0001F559': u':clock_face_ten_oclock:',
    u'\U0001F55E': u':clock_face_three-thirty:',
    u'\U0001F552': u':clock_face_three_oclock:',
    u'\U0001F567': u':clock_face_twelve-thirty:',
    u'\U0001F55B': u':clock_face_twelve_oclock:',
    u'\U0001F55D': u':clock_face_two-thirty:',
    u'\U0001F551': u':clock_face_two_oclock:',
    u'\U0001F4D5': u':closed_book:',
    u'\U0001F510': u':closed_lock_with_key:',
    u'\U0001F4EA': u':closed_mailbox_with_lowered_flag:',
    u'\U0001F4EB': u':closed_mailbox_with_raised_flag:',
    u'\U0001F302': u':closed_umbrella:',
    u'\U00002601': u':cloud:',
    u'\U0001F329': u':cloud_with_lightning:',
    u'\U0001F327': u':cloud_with_rain:',
    u'\U0001F328': u':cloud_with_snow:',
    u'\U0001F32A': u':cloud_with_tornado:',
    u'\U00002663': u':clubs:',
    u'\U0001F378': u':cocktail:',
    u'\U0001F378': u':cocktail_glass:',
    u'\U00002615': u':coffee:',
    u'\U000026B0': u':coffin:',
    u'\U0001F630': u':cold_sweat:',
    u'\U0001F4A5': u':collision:',
    u'\U0001F4A5': u':collision_symbol:',
    u'\U00002604': u':comet:',
    u'\U0001F5DC': u':compression:',
    u'\U0001F4BB': u':computer:',
    u'\U0001F38A': u':confetti_ball:',
    u'\U0001F616': u':confounded:',
    u'\U0001F616': u':confounded_face:',
    u'\U0001F615': u':confused:',
    u'\U0001F615': u':confused_face:',
    u'\U00003297': u':congratulations:',
    u'\U0001F6A7': u':construction:',
    u'\U0001F6A7': u':construction_sign:',
    u'\U0001F477': u':construction_worker:',
    u'\U0001F39B': u':control_knobs:',
    u'\U0001F3EA': u':convenience_store:',
    u'\U0001F35A': u':cooked_rice:',
    u'\U0001F36A': u':cookie:',
    u'\U0001F373': u':cooking:',
    u'\U0001F192': u':cool:',
    u'\U0001F46E': u':cop:',
    u'\U000000A9': u':copyright:',
    u'\U000000A9': u':copyright_sign:',
    u'\U0001F33D': u':corn:',
    u'\U0001F6CB': u':couch_and_lamp:',
    u'\U0001F46B': u':couple:',
    u'\U0001F491': u':couple_with_heart:',
    u'\U0001F48F': u':couplekiss:',
    u'\U0001F404': u':cow2:',
    u'\U0001F404': u':cow:',
    u'\U0001F42E': u':cow:',
    u'\U0001F42E': u':cow_face:',
    u'\U0001F980': u':crab:',
    u'\U0001F4B3': u':credit_card:',
    u'\U0001F319': u':crescent_moon:',
    u'\U0001F3CF': u':cricket_bat_and_ball:',
    u'\U0001F40A': u':crocodile:',
    u'\U0000274C': u':cross_mark:',
    u'\U0001F38C': u':crossed_flags:',
    u'\U00002694': u':crossed_swords:',
    u'\U0001F451': u':crown:',
    u'\U0001F622': u':cry:',
    u'\U0001F63F': u':crying_cat_face:',
    u'\U0001F622': u':crying_face:',
    u'\U0001F52E': u':crystal_ball:',
    u'\U0001F498': u':cupid:',
    u'\U000027B0': u':curly_loop:',
    u'\U0001F4B1': u':currency_exchange:',
    u'\U0001F35B': u':curry:',
    u'\U0001F35B': u':curry_and_rice:',
    u'\U0001F36E': u':custard:',
    u'\U0001F6C3': u':customs:',
    u'\U0001F300': u':cyclone:',
    u'\U0001F5E1': u':dagger_knife:',
    u'\U0001F483': u':dancer:',
    u'\U0001F46F': u':dancers:',
    u'\U0001F361': u':dango:',
    u'\U0001F576': u':dark_sunglasses:',
    u'\U0001F3AF': u':dart:',
    u'\U0001F4A8': u':dash:',
    u'\U0001F4A8': u':dash_symbol:',
    u'\U0001F4C5': u':date:',
    u'\U0001F333': u':deciduous_tree:',
    u'\U0001F69A': u':delivery_truck:',
    u'\U0001F3EC': u':department_store:',
    u'\U0001F3DA': u':derelict_house_building:',
    u'\U0001F3DC': u':desert:',
    u'\U0001F3DD': u':desert_island:',
    u'\U0001F5A5': u':desktop_computer:',
    u'\U0001F4A0': u':diamond_shape_with_a_dot_inside:',
    u'\U00002666': u':diamonds:',
    u'\U0001F3AF': u':direct_hit:',
    u'\U0001F61E': u':disappointed:',
    u'\U0001F625': u':disappointed_but_relieved_face:',
    u'\U0001F61E': u':disappointed_face:',
    u'\U0001F625': u':disappointed_relieved:',
    u'\U0001F4AB': u':dizzy:',
    u'\U0001F635': u':dizzy_face:',
    u'\U0001F4AB': u':dizzy_symbol:',
    u'\U0001F6AF': u':do_not_litter:',
    u'\U0001F6AF': u':do_not_litter_symbol:',
    u'\U0001F415': u':dog2:',
    u'\U0001F415': u':dog:',
    u'\U0001F436': u':dog:',
    u'\U0001F436': u':dog_face:',
    u'\U0001F4B5': u':dollar:',
    u'\U0001F38E': u':dolls:',
    u'\U0001F42C': u':dolphin:',
    u'\U0001F6AA': u':door:',
    u'\U000027BF': u':double_curly_loop:',
    u'\U0000203C': u':double_exclamation_mark:',
    u'\U000023F8': u':double_vertical_bar:',
    u'\U0001F369': u':doughnut:',
    u'\U0001F54A': u':dove_of_peace:',
    u'\U0001F53B': u':down-pointing_red_triangle:',
    u'\U0001F53D': u':down-pointing_small_red_triangle:',
    u'\U00002B07': u':downwards_black_arrow:',
    u'\U0001F409': u':dragon:',
    u'\U0001F432': u':dragon_face:',
    u'\U0001F457': u':dress:',
    u'\U0001F42A': u':dromedary_camel:',
    u'\U0001F4A7': u':droplet:',
    u'\U0001F4C0': u':dvd:',
    u'\U0001F4E7': u':e-mail:',
    u'\U0001F4E7': u':e-mail_symbol:',
    u'\U0001F442': u':ear:',
    u'\U0001F33D': u':ear_of_maize:',
    u'\U0001F33E': u':ear_of_rice:',
    u'\U0001F30D': u':earth_africa:',
    u'\U0001F30E': u':earth_americas:',
    u'\U0001F30F': u':earth_asia:',
    u'\U0001F30E': u':earth_globe_americas:',
    u'\U0001F30F': u':earth_globe_asia-australia:',
    u'\U0001F30D': u':earth_globe_europe-africa:',
    u'\U0001F373': u':egg:',
    u'\U0001F346': u':eggplant:',
    u'\U00002734': u':eight_pointed_black_star:',
    u'\U00002733': u':eight_spoked_asterisk:',
    u'\U000023CF': u':eject_symbol:',
    u'\U0001F4A1': u':electric_light_bulb:',
    u'\U0001F50C': u':electric_plug:',
    u'\U0001F526': u':electric_torch:',
    u'\U0001F418': u':elephant:',
    u'\U00002709': u':email:',
    u'\U0001F3FB': u':emoji_modifier_fitzpatrick_type-1-2:',
    u'\U0001F3FC': u':emoji_modifier_fitzpatrick_type-3:',
    u'\U0001F3FD': u':emoji_modifier_fitzpatrick_type-4:',
    u'\U0001F3FE': u':emoji_modifier_fitzpatrick_type-5:',
    u'\U0001F3FF': u':emoji_modifier_fitzpatrick_type-6:',
    u'\U0001F51A': u':end:',
    u'\U0001F51A': u':end_with_leftwards_arrow_above:',
    u'\U00002709': u':envelope:',
    u'\U0001F4E9': u':envelope_with_arrow:',
    u'\U0001F4E9': u':envelope_with_downwards_arrow_above:',
    u'\U0001F4B6': u':euro:',
    u'\U0001F3F0': u':european_castle:',
    u'\U0001F3E4': u':european_post_office:',
    u'\U0001F332': u':evergreen_tree:',
    u'\U00002757': u':exclamation:',
    u'\U00002049': u':exclamation_question_mark:',
    u'\U0001F611': u':expressionless:',
    u'\U0001F611': u':expressionless_face:',
    u'\U0001F47D': u':extraterrestrial_alien:',
    u'\U0001F441': u':eye:',
    u'\U0001F453': u':eyeglasses:',
    u'\U0001F440': u':eyes:',
    u'\U0001F486': u':face_massage:',
    u'\U0001F60B': u':face_savouring_delicious_food:',
    u'\U0001F631': u':face_screaming_in_fear:',
    u'\U0001F618': u':face_throwing_a_kiss:',
    u'\U0001F613': u':face_with_cold_sweat:',
    u'\U0001F915': u':face_with_head-bandage:',
    u'\U0001F915': u':face_with_head_bandage:',
    u'\U0001F624': u':face_with_look_of_triumph:',
    u'\U0001F637': u':face_with_medical_mask:',
    u'\U0001F645': u':face_with_no_good_gesture:',
    u'\U0001F646': u':face_with_ok_gesture:',
    u'\U0001F62E': u':face_with_open_mouth:',
    u'\U0001F630': u':face_with_open_mouth_and_cold_sweat:',
    u'\U0001F644': u':face_with_rolling_eyes:',
    u'\U0001F61B': u':face_with_stuck-out_tongue:',
    u'\U0001F602': u':face_with_tears_of_joy:',
    u'\U0001F912': u':face_with_thermometer:',
    u'\U0001F636': u':face_without_mouth:',
    u'\U0001F44A': u':facepunch:',
    u'\U0001F3ED': u':factory:',
    u'\U0001F342': u':fallen_leaf:',
    u'\U0001F46A': u':family:',
    u'\U000023E9': u':fast_forward:',
    u'\U0001F385': u':father_christmas:',
    u'\U0001F4E0': u':fax:',
    u'\U0001F4E0': u':fax_machine:',
    u'\U0001F628': u':fearful:',
    u'\U0001F628': u':fearful_face:',
    u'\U0001F43E': u':feet:',
    u'\U0001F3A1': u':ferris_wheel:',
    u'\U000026F4': u':ferry:',
    u'\U0001F3D1': u':field_hockey_stick_and_ball:',
    u'\U0001F5C4': u':file_cabinet:',
    u'\U0001F4C1': u':file_folder:',
    u'\U0001F39E': u':film_frames:',
    u'\U0001F4FD': u':film_projector:',
    u'\U0001F525': u':fire:',
    u'\U0001F692': u':fire_engine:',
    u'\U0001F387': u':firework_sparkler:',
    u'\U0001F386': u':fireworks:',
    u'\U0001F313': u':first_quarter_moon:',
    u'\U0001F313': u':first_quarter_moon_symbol:',
    u'\U0001F31B': u':first_quarter_moon_with_face:',
    u'\U0001F41F': u':fish:',
    u'\U0001F365': u':fish_cake:',
    u'\U0001F365': u':fish_cake_with_swirl_design:',
    u'\U0001F3A3': u':fishing_pole_and_fish:',
    u'\U0000270A': u':fist:',
    u'\U0001F44A': u':fisted_hand_sign:',
    u'\U000026F3': u':flag_in_hole:',
    u'\U0001F38F': u':flags:',
    u'\U0001F526': u':flashlight:',
    u'\U0000269C': u':fleur-de-lis:',
    u'\U0000269C': u':fleur_de_lis:',
    u'\U0001F4AA': u':flexed_biceps:',
    u'\U0001F42C': u':flipper:',
    u'\U0001F4BE': u':floppy_disk:',
    u'\U0001F3B4': u':flower_playing_cards:',
    u'\U0001F633': u':flushed:',
    u'\U0001F633': u':flushed_face:',
    u'\U0001F32B': u':fog:',
    u'\U0001F301': u':foggy:',
    u'\U0001F3C8': u':football:',
    u'\U0001F463': u':footprints:',
    u'\U0001F374': u':fork_and_knife:',
    u'\U0001F37D': u':fork_and_knife_with_plate:',
    u'\U000026F2': u':fountain:',
    u'\U0001F340': u':four_leaf_clover:',
    u'\U0001F5BC': u':frame_with_picture:',
    u'\U0001F193': u':free:',
    u'\U0001F35F': u':french_fries:',
    u'\U0001F364': u':fried_shrimp:',
    u'\U0001F35F': u':fries:',
    u'\U0001F438': u':frog:',
    u'\U0001F438': u':frog_face:',
    u'\U0001F425': u':front-facing_baby_chick:',
    u'\U0001F626': u':frowning:',
    u'\U0001F626': u':frowning_face_with_open_mouth:',
    u'\U000026FD': u':fuel_pump:',
    u'\U000026FD': u':fuelpump:',
    u'\U0001F315': u':full_moon:',
    u'\U0001F315': u':full_moon_symbol:',
    u'\U0001F31D': u':full_moon_with_face:',
    u'\U000026B1': u':funeral_urn:',
    u'\U0001F3B2': u':game_die:',
    u'\U00002699': u':gear:',
    u'\U0001F48E': u':gem:',
    u'\U0001F48E': u':gem_stone:',
    u'\U0000264A': u':gemini:',
    u'\U0001F47B': u':ghost:',
    u'\U0001F381': u':gift:',
    u'\U0001F49D': u':gift_heart:',
    u'\U0001F467': u':girl:',
    u'\U0001F310': u':globe_with_meridians:',
    u'\U0001F31F': u':glowing_star:',
    u'\U0001F410': u':goat:',
    u'\U000026F3': u':golf:',
    u'\U0001F3CC': u':golfer:',
    u'\U0001F393': u':graduation_cap:',
    u'\U0001F347': u':grapes:',
    u'\U0001F34F': u':green_apple:',
    u'\U0001F4D7': u':green_book:',
    u'\U0001F49A': u':green_heart:',
    u'\U00002755': u':grey_exclamation:',
    u'\U00002754': u':grey_question:',
    u'\U0001F62C': u':grimacing:',
    u'\U0001F62C': u':grimacing_face:',
    u'\U0001F601': u':grin:',
    u'\U0001F600': u':grinning:',
    u'\U0001F638': u':grinning_cat_face_with_smiling_eyes:',
    u'\U0001F600': u':grinning_face:',
    u'\U0001F601': u':grinning_face_with_smiling_eyes:',
    u'\U0001F497': u':growing_heart:',
    u'\U0001F482': u':guardsman:',
    u'\U0001F3B8': u':guitar:',
    u'\U0001F52B': u':gun:',
    u'\U0001F487': u':haircut:',
    u'\U0001F354': u':hamburger:',
    u'\U0001F528': u':hammer:',
    u'\U00002692': u':hammer_and_pick:',
    u'\U0001F6E0': u':hammer_and_wrench:',
    u'\U0001F439': u':hamster:',
    u'\U0001F439': u':hamster_face:',
    u'\U0000270B': u':hand:',
    u'\U0001F45C': u':handbag:',
    u'\U0001F4A9': u':hankey:',
    u'\U0001F64B': u':happy_person_raising_one_hand:',
    u'\U0001F425': u':hatched_chick:',
    u'\U0001F423': u':hatching_chick:',
    u'\U0001F3A7': u':headphone:',
    u'\U0001F3A7': u':headphones:',
    u'\U0001F649': u':hear-no-evil_monkey:',
    u'\U0001F649': u':hear_no_evil:',
    u'\U00002764': u':heart:',
    u'\U0001F49F': u':heart_decoration:',
    u'\U0001F60D': u':heart_eyes:',
    u'\U0001F63B': u':heart_eyes_cat:',
    u'\U0001F498': u':heart_with_arrow:',
    u'\U0001F49D': u':heart_with_ribbon:',
    u'\U0001F493': u':heartbeat:',
    u'\U0001F497': u':heartpulse:',
    u'\U00002665': u':hearts:',
    u'\U00002764': u':heavy_black_heart:',
    u'\U00002714': u':heavy_check_mark:',
    u'\U00002797': u':heavy_division_sign:',
    u'\U0001F4B2': u':heavy_dollar_sign:',
    u'\U00002757': u':heavy_exclamation_mark:',
    u'\U00002757': u':heavy_exclamation_mark_symbol:',
    u'\U00002763': u':heavy_heart_exclamation_mark_ornament:',
    u'\U00002B55': u':heavy_large_circle:',
    u'\U00002796': u':heavy_minus_sign:',
    u'\U00002716': u':heavy_multiplication_x:',
    u'\U00002795': u':heavy_plus_sign:',
    u'\U0001F681': u':helicopter:',
    u'\U00002388': u':helm_symbol:',
    u'\U000026D1': u':helmet_with_white_cross:',
    u'\U0001F33F': u':herb:',
    u'\U0001F33A': u':hibiscus:',
    u'\U0001F460': u':high-heeled_shoe:',
    u'\U0001F684': u':high-speed_train:',
    u'\U0001F685': u':high-speed_train_with_bullet_nose:',
    u'\U0001F506': u':high_brightness:',
    u'\U0001F506': u':high_brightness_symbol:',
    u'\U0001F460': u':high_heel:',
    u'\U000026A1': u':high_voltage_sign:',
    u'\U0001F52A': u':hocho:',
    u'\U0001F573': u':hole:',
    u'\U0001F36F': u':honey_pot:',
    u'\U0001F41D': u':honeybee:',
    u'\U0001F6A5': u':horizontal_traffic_light:',
    u'\U0001F40E': u':horse:',
    u'\U0001F434': u':horse:',
    u'\U0001F434': u':horse_face:',
    u'\U0001F3C7': u':horse_racing:',
    u'\U0001F3E5': u':hospital:',
    u'\U00002615': u':hot_beverage:',
    u'\U0001F32D': u':hot_dog:',
    u'\U0001F336': u':hot_pepper:',
    u'\U00002668': u':hot_springs:',
    u'\U0001F32D': u':hotdog:',
    u'\U0001F3E8': u':hotel:',
    u'\U00002668': u':hotsprings:',
    u'\U0000231B': u':hourglass:',
    u'\U000023F3': u':hourglass_flowing_sand:',
    u'\U000023F3': u':hourglass_with_flowing_sand:',
    u'\U0001F3E0': u':house:',
    u'\U0001F3E0': u':house_building:',
    u'\U0001F3D8': u':house_buildings:',
    u'\U0001F3E1': u':house_with_garden:',
    u'\U0001F917': u':hugging_face:',
    u'\U0001F4AF': u':hundred_points_symbol:',
    u'\U0001F62F': u':hushed:',
    u'\U0001F62F': u':hushed_face:',
    u'\U0001F368': u':ice_cream:',
    u'\U0001F3D2': u':ice_hockey_stick_and_puck:',
    u'\U000026F8': u':ice_skate:',
    u'\U0001F366': u':icecream:',
    u'\U0001F194': u':id:',
    u'\U0001F250': u':ideograph_advantage:',
    u'\U0001F47F': u':imp:',
    u'\U0001F4E5': u':inbox_tray:',
    u'\U0001F4E8': u':incoming_envelope:',
    u'\U0001F481': u':information_desk_person:',
    u'\U00002139': u':information_source:',
    u'\U0001F607': u':innocent:',
    u'\U0001F520': u':input_symbol_for_latin_capital_letters:',
    u'\U0001F524': u':input_symbol_for_latin_letters:',
    u'\U0001F521': u':input_symbol_for_latin_small_letters:',
    u'\U0001F522': u':input_symbol_for_numbers:',
    u'\U0001F523': u':input_symbol_for_symbols:',
    u'\U00002049': u':interrobang:',
    u'\U0001F4F1': u':iphone:',
    u'\U0001F3EE': u':izakaya_lantern:',
    u'\U0001F383': u':jack-o-lantern:',
    u'\U0001F383': u':jack_o_lantern:',
    u'\U0001F5FE': u':japan:',
    u'\U0001F3EF': u':japanese_castle:',
    u'\U0001F38E': u':japanese_dolls:',
    u'\U0001F47A': u':japanese_goblin:',
    u'\U0001F479': u':japanese_ogre:',
    u'\U0001F3E3': u':japanese_post_office:',
    u'\U0001F530': u':japanese_symbol_for_beginner:',
    u'\U0001F456': u':jeans:',
    u'\U0001F602': u':joy:',
    u'\U0001F639': u':joy_cat:',
    u'\U0001F579': u':joystick:',
    u'\U0001F54B': u':kaaba:',
    u'\U0001F511': u':key:',
    u'\U00002328': u':keyboard:',
    u'\U0001F51F': u':keycap_ten:',
    u'\U0001F458': u':kimono:',
    u'\U0001F48B': u':kiss:',
    u'\U0001F48F': u':kiss:',
    u'\U0001F48B': u':kiss_mark:',
    u'\U0001F617': u':kissing:',
    u'\U0001F63D': u':kissing_cat:',
    u'\U0001F63D': u':kissing_cat_face_with_closed_eyes:',
    u'\U0001F61A': u':kissing_closed_eyes:',
    u'\U0001F617': u':kissing_face:',
    u'\U0001F61A': u':kissing_face_with_closed_eyes:',
    u'\U0001F619': u':kissing_face_with_smiling_eyes:',
    u'\U0001F618': u':kissing_heart:',
    u'\U0001F619': u':kissing_smiling_eyes:',
    u'\U0001F52A': u':knife:',
    u'\U0001F37D': u':knife_fork_plate:',
    u'\U0001F428': u':koala:',
    u'\U0001F201': u':koko:',
    u'\U0001F3F7': u':label:',
    u'\U0001F41E': u':lady_beetle:',
    u'\U0001F3EE': u':lantern:',
    u'\U0001F535': u':large_blue_circle:',
    u'\U0001F537': u':large_blue_diamond:',
    u'\U0001F536': u':large_orange_diamond:',
    u'\U0001F534': u':large_red_circle:',
    u'\U0001F317': u':last_quarter_moon:',
    u'\U0001F317': u':last_quarter_moon_symbol:',
    u'\U0001F31C': u':last_quarter_moon_with_face:',
    u'\U0000271D': u':latin_cross:',
    u'\U0001F606': u':laughing:',
    u'\U0001F343': u':leaf_fluttering_in_wind:',
    u'\U0001F343': u':leaves:',
    u'\U0001F4D2': u':ledger:',
    u'\U0001F50D': u':left-pointing_magnifying_glass:',
    u'\U0001F6C5': u':left_luggage:',
    u'\U00002194': u':left_right_arrow:',
    u'\U0001F4AC': u':left_speech_bubble:',
    u'\U000021A9': u':leftwards_arrow_with_hook:',
    u'\U00002B05': u':leftwards_black_arrow:',
    u'\U0001F34B': u':lemon:',
    u'\U0000264C': u':leo:',
    u'\U0001F406': u':leopard:',
    u'\U0001F39A': u':level_slider:',
    u'\U0000264E': u':libra:',
    u'\U0001F688': u':light_rail:',
    u'\U0001F329': u':lightning:',
    u'\U0001F517': u':link:',
    u'\U0001F517': u':link_symbol:',
    u'\U0001F587': u':linked_paperclips:',
    u'\U0001F981': u':lion_face:',
    u'\U0001F444': u':lips:',
    u'\U0001F484': u':lipstick:',
    u'\U0001F512': u':lock:',
    u'\U0001F50F': u':lock_with_ink_pen:',
    u'\U0001F36D': u':lollipop:',
    u'\U000027BF': u':loop:',
    u'\U0001F50A': u':loud_sound:',
    u'\U0001F62D': u':loudly_crying_face:',
    u'\U0001F4E2': u':loudspeaker:',
    u'\U0001F3E9': u':love_hotel:',
    u'\U0001F48C': u':love_letter:',
    u'\U0001F505': u':low_brightness:',
    u'\U0001F505': u':low_brightness_symbol:',
    u'\U0001F58A': u':lower_left_ballpoint_pen:',
    u'\U0001F58D': u':lower_left_crayon:',
    u'\U0001F58B': u':lower_left_fountain_pen:',
    u'\U0001F58C': u':lower_left_paintbrush:',
    u'\U000024C2': u':m:',
    u'\U0001F50D': u':mag:',
    u'\U0001F50E': u':mag_right:',
    u'\U0001F004': u':mahjong:',
    u'\U0001F004': u':mahjong_tile_red_dragon:',
    u'\U0001F4EB': u':mailbox:',
    u'\U0001F4EA': u':mailbox_closed:',
    u'\U0001F4EC': u':mailbox_with_mail:',
    u'\U0001F4ED': u':mailbox_with_no_mail:',
    u'\U0001F468': u':man:',
    u'\U0001F46B': u':man_and_woman_holding_hands:',
    u'\U0001F574': u':man_in_business_suit_levitating:',
    u'\U0001F472': u':man_with_gua_pi_mao:',
    u'\U0001F473': u':man_with_turban:',
    u'\U0001F45E': u':mans_shoe:',
    u'\U0001F570': u':mantelpiece_clock:',
    u'\U0001F341': u':maple_leaf:',
    u'\U0001F637': u':mask:',
    u'\U0001F486': u':massage:',
    u'\U0001F356': u':meat_on_bone:',
    u'\U0001F3C5': u':medal:',
    u'\U000026AB': u':medium_black_circle:',
    u'\U000026AA': u':medium_white_circle:',
    u'\U0001F4E3': u':mega:',
    u'\U0001F348': u':melon:',
    u'\U0001F4DD': u':memo:',
    u'\U0001F54E': u':menorah_with_nine_branches:',
    u'\U0001F6B9': u':mens:',
    u'\U0001F6B9': u':mens_symbol:',
    u'\U0001F687': u':metro:',
    u'\U0001F3A4': u':microphone:',
    u'\U0001F52C': u':microscope:',
    u'\U0001F595': u':middle_finger:',
    u'\U0001F396': u':military_medal:',
    u'\U0001F30C': u':milky_way:',
    u'\U0001F690': u':minibus:',
    u'\U0001F4BD': u':minidisc:',
    u'\U0001F4F1': u':mobile_phone:',
    u'\U0001F4F4': u':mobile_phone_off:',
    u'\U0001F911': u':money-mouth_face:',
    u'\U0001F4B0': u':money_bag:',
    u'\U0001F911': u':money_mouth_face:',
    u'\U0001F4B8': u':money_with_wings:',
    u'\U0001F4B0': u':moneybag:',
    u'\U0001F412': u':monkey:',
    u'\U0001F435': u':monkey_face:',
    u'\U0001F69D': u':monorail:',
    u'\U0001F314': u':moon:',
    u'\U0001F391': u':moon_viewing_ceremony:',
    u'\U0001F393': u':mortar_board:',
    u'\U0001F54C': u':mosque:',
    u'\U0001F324': u':mostly_sunny:',
    u'\U0001F6E5': u':motor_boat:',
    u'\U0001F6E3': u':motorway:',
    u'\U0001F5FB': u':mount_fuji:',
    u'\U000026F0': u':mountain:',
    u'\U0001F6B5': u':mountain_bicyclist:',
    u'\U0001F6A0': u':mountain_cableway:',
    u'\U0001F69E': u':mountain_railway:',
    u'\U0001F401': u':mouse2:',
    u'\U0001F401': u':mouse:',
    u'\U0001F42D': u':mouse:',
    u'\U0001F42D': u':mouse_face:',
    u'\U0001F444': u':mouth:',
    u'\U0001F3A5': u':movie_camera:',
    u'\U0001F5FF': u':moyai:',
    u'\U0001F3B6': u':multiple_musical_notes:',
    u'\U0001F4AA': u':muscle:',
    u'\U0001F344': u':mushroom:',
    u'\U0001F3B9': u':musical_keyboard:',
    u'\U0001F3B5': u':musical_note:',
    u'\U0001F3BC': u':musical_score:',
    u'\U0001F507': u':mute:',
    u'\U0001F485': u':nail_care:',
    u'\U0001F485': u':nail_polish:',
    u'\U0001F4DB': u':name_badge:',
    u'\U0001F3DE': u':national_park:',
    u'\U0001F454': u':necktie:',
    u'\U0001F18E': u':negative_squared_ab:',
    u'\U0000274E': u':negative_squared_cross_mark:',
    u'\U0001F913': u':nerd_face:',
    u'\U0001F610': u':neutral_face:',
    u'\U0001F195': u':new:',
    u'\U0001F311': u':new_moon:',
    u'\U0001F311': u':new_moon_symbol:',
    u'\U0001F31A': u':new_moon_with_face:',
    u'\U0001F4F0': u':newspaper:',
    u'\U0001F196': u':ng:',
    u'\U0001F303': u':night_with_stars:',
    u'\U0001F515': u':no_bell:',
    u'\U0001F6B3': u':no_bicycles:',
    u'\U000026D4': u':no_entry:',
    u'\U0001F6AB': u':no_entry_sign:',
    u'\U0001F645': u':no_good:',
    u'\U0001F4F5': u':no_mobile_phones:',
    u'\U0001F636': u':no_mouth:',
    u'\U0001F51E': u':no_one_under_eighteen_symbol:',
    u'\U0001F6B7': u':no_pedestrians:',
    u'\U0001F6AD': u':no_smoking:',
    u'\U0001F6AD': u':no_smoking_symbol:',
    u'\U0001F6B1': u':non-potable_water:',
    u'\U0001F6B1': u':non-potable_water_symbol:',
    u'\U00002197': u':north_east_arrow:',
    u'\U00002196': u':north_west_arrow:',
    u'\U0001F443': u':nose:',
    u'\U0001F4D3': u':notebook:',
    u'\U0001F4D4': u':notebook_with_decorative_cover:',
    u'\U0001F3B6': u':notes:',
    u'\U0001F529': u':nut_and_bolt:',
    u'\U0001F17E': u':o2:',
    u'\U00002B55': u':o:',
    u'\U0001F30A': u':ocean:',
    u'\U0001F419': u':octopus:',
    u'\U0001F362': u':oden:',
    u'\U0001F3E2': u':office:',
    u'\U0001F3E2': u':office_building:',
    u'\U0001F6E2': u':oil_drum:',
    u'\U0001F197': u':ok:',
    u'\U0001F44C': u':ok_hand:',
    u'\U0001F44C': u':ok_hand_sign:',
    u'\U0001F646': u':ok_woman:',
    u'\U0001F5DD': u':old_key:',
    u'\U0001F474': u':older_man:',
    u'\U0001F475': u':older_woman:',
    u'\U0001F549': u':om_symbol:',
    u'\U0001F51B': u':on:',
    u'\U0001F698': u':oncoming_automobile:',
    u'\U0001F68D': u':oncoming_bus:',
    u'\U0001F694': u':oncoming_police_car:',
    u'\U0001F696': u':oncoming_taxi:',
    u'\U0001F4D6': u':open_book:',
    u'\U0001F4C2': u':open_file_folder:',
    u'\U0001F450': u':open_hands:',
    u'\U0001F450': u':open_hands_sign:',
    u'\U0001F513': u':open_lock:',
    u'\U0001F4ED': u':open_mailbox_with_lowered_flag:',
    u'\U0001F4EC': u':open_mailbox_with_raised_flag:',
    u'\U0001F62E': u':open_mouth:',
    u'\U000026CE': u':ophiuchus:',
    u'\U0001F4BF': u':optical_disc:',
    u'\U0001F4D9': u':orange_book:',
    u'\U00002626': u':orthodox_cross:',
    u'\U0001F4E4': u':outbox_tray:',
    u'\U0001F402': u':ox:',
    u'\U0001F4E6': u':package:',
    u'\U0001F4C4': u':page_facing_up:',
    u'\U0001F4C3': u':page_with_curl:',
    u'\U0001F4DF': u':pager:',
    u'\U0001F334': u':palm_tree:',
    u'\U0001F43C': u':panda_face:',
    u'\U0001F4CE': u':paperclip:',
    u'\U0001F17F': u':parking:',
    u'\U0000303D': u':part_alternation_mark:',
    u'\U000026C5': u':partly_sunny:',
    u'\U0001F326': u':partly_sunny_rain:',
    u'\U0001F389': u':party_popper:',
    u'\U0001F6F3': u':passenger_ship:',
    u'\U0001F6C2': u':passport_control:',
    u'\U0001F43E': u':paw_prints:',
    u'\U0000262E': u':peace_symbol:',
    u'\U0001F351': u':peach:',
    u'\U0001F350': u':pear:',
    u'\U0001F6B6': u':pedestrian:',
    u'\U0000270F': u':pencil2:',
    u'\U0000270F': u':pencil:',
    u'\U0001F4DD': u':pencil:',
    u'\U0001F427': u':penguin:',
    u'\U0001F614': u':pensive:',
    u'\U0001F614': u':pensive_face:',
    u'\U0001F3AD': u':performing_arts:',
    u'\U0001F623': u':persevere:',
    u'\U0001F623': u':persevering_face:',
    u'\U0001F647': u':person_bowing_deeply:',
    u'\U0001F64D': u':person_frowning:',
    u'\U000026F9': u':person_with_ball:',
    u'\U0001F471': u':person_with_blond_hair:',
    u'\U0001F64F': u':person_with_folded_hands:',
    u'\U0001F64E': u':person_with_pouting_face:',
    u'\U0001F4BB': u':personal_computer:',
    u'\U0000260E': u':phone:',
    u'\U000026CF': u':pick:',
    u'\U0001F416': u':pig2:',
    u'\U0001F416': u':pig:',
    u'\U0001F437': u':pig:',
    u'\U0001F437': u':pig_face:',
    u'\U0001F43D': u':pig_nose:',
    u'\U0001F4A9': u':pile_of_poo:',
    u'\U0001F48A': u':pill:',
    u'\U0001F38D': u':pine_decoration:',
    u'\U0001F34D': u':pineapple:',
    u'\U00002653': u':pisces:',
    u'\U0001F52B': u':pistol:',
    u'\U0001F355': u':pizza:',
    u'\U0001F6D0': u':place_of_worship:',
    u'\U0001F0CF': u':playing_card_black_joker:',
    u'\U0001F447': u':point_down:',
    u'\U0001F448': u':point_left:',
    u'\U0001F449': u':point_right:',
    u'\U0000261D': u':point_up:',
    u'\U0001F446': u':point_up_2:',
    u'\U0001F693': u':police_car:',
    u'\U0001F6A8': u':police_cars_revolving_light:',
    u'\U0001F46E': u':police_officer:',
    u'\U0001F429': u':poodle:',
    u'\U0001F4A9': u':poop:',
    u'\U0001F37F': u':popcorn:',
    u'\U0001F3E3': u':post_office:',
    u'\U0001F4EF': u':postal_horn:',
    u'\U0001F4EE': u':postbox:',
    u'\U0001F372': u':pot_of_food:',
    u'\U0001F6B0': u':potable_water:',
    u'\U0001F6B0': u':potable_water_symbol:',
    u'\U0001F45D': u':pouch:',
    u'\U0001F357': u':poultry_leg:',
    u'\U0001F4B7': u':pound:',
    u'\U0001F63E': u':pouting_cat:',
    u'\U0001F63E': u':pouting_cat_face:',
    u'\U0001F621': u':pouting_face:',
    u'\U0001F64F': u':pray:',
    u'\U0001F4FF': u':prayer_beads:',
    u'\U0001F478': u':princess:',
    u'\U0001F5A8': u':printer:',
    u'\U0001F4E2': u':public_address_loudspeaker:',
    u'\U0001F44A': u':punch:',
    u'\U0001F49C': u':purple_heart:',
    u'\U0001F45B': u':purse:',
    u'\U0001F4CC': u':pushpin:',
    u'\U0001F6AE': u':put_litter_in_its_place:',
    u'\U0001F6AE': u':put_litter_in_its_place_symbol:',
    u'\U00002753': u':question:',
    u'\U0001F407': u':rabbit2:',
    u'\U0001F407': u':rabbit:',
    u'\U0001F430': u':rabbit:',
    u'\U0001F430': u':rabbit_face:',
    u'\U0001F40E': u':racehorse:',
    u'\U0001F3CE': u':racing_car:',
    u'\U0001F3CD': u':racing_motorcycle:',
    u'\U0001F4FB': u':radio:',
    u'\U0001F518': u':radio_button:',
    u'\U00002622': u':radioactive_sign:',
    u'\U0001F621': u':rage:',
    u'\U0001F683': u':railway_car:',
    u'\U0001F6E4': u':railway_track:',
    u'\U0001F327': u':rain_cloud:',
    u'\U0001F308': u':rainbow:',
    u'\U0000270A': u':raised_fist:',
    u'\U0000270B': u':raised_hand:',
    u'\U0001F590': u':raised_hand_with_fingers_splayed:',
    u'\U0001F64C': u':raised_hands:',
    u'\U0001F64B': u':raising_hand:',
    u'\U0001F40F': u':ram:',
    u'\U0001F35C': u':ramen:',
    u'\U0001F400': u':rat:',
    u'\U0001F699': u':recreational_vehicle:',
    u'\U0000267B': u':recycle:',
    u'\U0001F34E': u':red_apple:',
    u'\U0001F697': u':red_car:',
    u'\U0001F534': u':red_circle:',
    u'\U000000AE': u':registered:',
    u'\U000000AE': u':registered_sign:',
    u'\U0000263A': u':relaxed:',
    u'\U0001F60C': u':relieved:',
    u'\U0001F60C': u':relieved_face:',
    u'\U0001F397': u':reminder_ribbon:',
    u'\U0001F501': u':repeat:',
    u'\U0001F502': u':repeat_one:',
    u'\U0001F6BB': u':restroom:',
    u'\U0001F49E': u':revolving_hearts:',
    u'\U000023EA': u':rewind:',
    u'\U0001F380': u':ribbon:',
    u'\U0001F35A': u':rice:',
    u'\U0001F359': u':rice_ball:',
    u'\U0001F358': u':rice_cracker:',
    u'\U0001F391': u':rice_scene:',
    u'\U0001F50E': u':right-pointing_magnifying_glass:',
    u'\U0001F5EF': u':right_anger_bubble:',
    u'\U000021AA': u':rightwards_arrow_with_hook:',
    u'\U0001F48D': u':ring:',
    u'\U0001F360': u':roasted_sweet_potato:',
    u'\U0001F916': u':robot_face:',
    u'\U0001F680': u':rocket:',
    u'\U0001F5DE': u':rolled-up_newspaper:',
    u'\U0001F5DE': u':rolled_up_newspaper:',
    u'\U0001F3A2': u':roller_coaster:',
    u'\U0001F413': u':rooster:',
    u'\U0001F339': u':rose:',
    u'\U0001F3F5': u':rosette:',
    u'\U0001F6A8': u':rotating_light:',
    u'\U0001F4CD': u':round_pushpin:',
    u'\U0001F6A3': u':rowboat:',
    u'\U0001F3C9': u':rugby_football:',
    u'\U0001F3C3': u':runner:',
    u'\U0001F3C3': u':running:',
    u'\U0001F3BD': u':running_shirt_with_sash:',
    u'\U0001F202': u':sa:',
    u'\U00002650': u':sagittarius:',
    u'\U000026F5': u':sailboat:',
    u'\U0001F376': u':sake:',
    u'\U0001F376': u':sake_bottle_and_cup:',
    u'\U0001F461': u':sandal:',
    u'\U0001F385': u':santa:',
    u'\U0001F4E1': u':satellite:',
    u'\U0001F6F0': u':satellite:',
    u'\U0001F4E1': u':satellite_antenna:',
    u'\U0001F606': u':satisfied:',
    u'\U0001F3B7': u':saxophone:',
    u'\U00002696': u':scales:',
    u'\U0001F3EB': u':school:',
    u'\U0001F392': u':school_satchel:',
    u'\U00002702': u':scissors:',
    u'\U0001F982': u':scorpion:',
    u'\U0000264F': u':scorpius:',
    u'\U0001F631': u':scream:',
    u'\U0001F640': u':scream_cat:',
    u'\U0001F4DC': u':scroll:',
    u'\U0001F4BA': u':seat:',
    u'\U00003299': u':secret:',
    u'\U0001F648': u':see-no-evil_monkey:',
    u'\U0001F648': u':see_no_evil:',
    u'\U0001F331': u':seedling:',
    u'\U00002618': u':shamrock:',
    u'\U0001F367': u':shaved_ice:',
    u'\U0001F411': u':sheep:',
    u'\U0001F41A': u':shell:',
    u'\U0001F6E1': u':shield:',
    u'\U000026E9': u':shinto_shrine:',
    u'\U0001F6A2': u':ship:',
    u'\U0001F455': u':shirt:',
    u'\U0001F4A9': u':shit:',
    u'\U0001F45E': u':shoe:',
    u'\U0001F320': u':shooting_star:',
    u'\U0001F6CD': u':shopping_bags:',
    u'\U0001F370': u':shortcake:',
    u'\U0001F6BF': u':shower:',
    u'\U0001F918': u':sign_of_the_horns:',
    u'\U0001F4F6': u':signal_strength:',
    u'\U0001F5FE': u':silhouette_of_japan:',
    u'\U0001F642': u':simple_smile:',
    u'\U0001F52F': u':six_pointed_star:',
    u'\U0001F3BF': u':ski:',
    u'\U0001F3BF': u':ski_and_ski_boot:',
    u'\U000026F7': u':skier:',
    u'\U0001F480': u':skull:',
    u'\U00002620': u':skull_and_crossbones:',
    u'\U0001F634': u':sleeping:',
    u'\U0001F6CC': u':sleeping_accommodation:',
    u'\U0001F634': u':sleeping_face:',
    u'\U0001F4A4': u':sleeping_symbol:',
    u'\U0001F62A': u':sleepy:',
    u'\U0001F62A': u':sleepy_face:',
    u'\U0001F575': u':sleuth_or_spy:',
    u'\U0001F355': u':slice_of_pizza:',
    u'\U0001F641': u':slightly_frowning_face:',
    u'\U0001F642': u':slightly_smiling_face:',
    u'\U0001F3B0': u':slot_machine:',
    u'\U0001F6E9': u':small_airplane:',
    u'\U0001F539': u':small_blue_diamond:',
    u'\U0001F538': u':small_orange_diamond:',
    u'\U0001F53A': u':small_red_triangle:',
    u'\U0001F53B': u':small_red_triangle_down:',
    u'\U0001F604': u':smile:',
    u'\U0001F638': u':smile_cat:',
    u'\U0001F603': u':smiley:',
    u'\U0001F63A': u':smiley_cat:',
    u'\U0001F63B': u':smiling_cat_face_with_heart-shaped_eyes:',
    u'\U0001F63A': u':smiling_cat_face_with_open_mouth:',
    u'\U0001F607': u':smiling_face_with_halo:',
    u'\U0001F60D': u':smiling_face_with_heart-shaped_eyes:',
    u'\U0001F608': u':smiling_face_with_horns:',
    u'\U0001F603': u':smiling_face_with_open_mouth:',
    u'\U0001F605': u':smiling_face_with_open_mouth_and_cold_sweat:',
    u'\U0001F604': u':smiling_face_with_open_mouth_and_smiling_eyes:',
    u'\U0001F606': u':smiling_face_with_open_mouth_and_tightly-closed_eyes:',
    u'\U0001F60A': u':smiling_face_with_smiling_eyes:',
    u'\U0001F60E': u':smiling_face_with_sunglasses:',
    u'\U0001F608': u':smiling_imp:',
    u'\U0001F60F': u':smirk:',
    u'\U0001F63C': u':smirk_cat:',
    u'\U0001F60F': u':smirking_face:',
    u'\U0001F6AC': u':smoking:',
    u'\U0001F6AC': u':smoking_symbol:',
    u'\U0001F40C': u':snail:',
    u'\U0001F40D': u':snake:',
    u'\U0001F3D4': u':snow_capped_mountain:',
    u'\U0001F328': u':snow_cloud:',
    u'\U0001F3C2': u':snowboarder:',
    u'\U00002744': u':snowflake:',
    u'\U00002603': u':snowman:',
    u'\U000026C4': u':snowman_without_snow:',
    u'\U0001F62D': u':sob:',
    u'\U000026BD': u':soccer:',
    u'\U000026BD': u':soccer_ball:',
    u'\U0001F366': u':soft_ice_cream:',
    u'\U0001F51C': u':soon:',
    u'\U0001F51C': u':soon_with_rightwards_arrow_above:',
    u'\U0001F198': u':sos:',
    u'\U0001F509': u':sound:',
    u'\U00002198': u':south_east_arrow:',
    u'\U00002199': u':south_west_arrow:',
    u'\U0001F47E': u':space_invader:',
    u'\U00002660': u':spades:',
    u'\U0001F35D': u':spaghetti:',
    u'\U00002747': u':sparkle:',
    u'\U0001F387': u':sparkler:',
    u'\U00002728': u':sparkles:',
    u'\U0001F496': u':sparkling_heart:',
    u'\U0001F64A': u':speak-no-evil_monkey:',
    u'\U0001F64A': u':speak_no_evil:',
    u'\U0001F508': u':speaker:',
    u'\U0001F507': u':speaker_with_cancellation_stroke:',
    u'\U0001F509': u':speaker_with_one_sound_wave:',
    u'\U0001F50A': u':speaker_with_three_sound_waves:',
    u'\U0001F5E3': u':speaking_head_in_silhouette:',
    u'\U0001F4AC': u':speech_balloon:',
    u'\U0001F6A4': u':speedboat:',
    u'\U0001F577': u':spider:',
    u'\U0001F578': u':spider_web:',
    u'\U0001F5D3': u':spiral_calendar_pad:',
    u'\U0001F5D2': u':spiral_note_pad:',
    u'\U0001F41A': u':spiral_shell:',
    u'\U0001F4A6': u':splashing_sweat_symbol:',
    u'\U0001F596': u':spock-hand:',
    u'\U0001F596': u':spock_hand:',
    u'\U0001F3C5': u':sports_medal:',
    u'\U0001F433': u':spouting_whale:',
    u'\U0001F191': u':squared_cl:',
    u'\U0001F192': u':squared_cool:',
    u'\U0001F193': u':squared_free:',
    u'\U0001F194': u':squared_id:',
    u'\U0001F201': u':squared_katakana_koko:',
    u'\U0001F202': u':squared_katakana_sa:',
    u'\U0001F195': u':squared_new:',
    u'\U0001F196': u':squared_ng:',
    u'\U0001F197': u':squared_ok:',
    u'\U0001F198': u':squared_sos:',
    u'\U0001F199': u':squared_up_with_exclamation_mark:',
    u'\U0001F19A': u':squared_vs:',
    u'\U0001F3DF': u':stadium:',
    u'\U0001F31F': u':star2:',
    u'\U00002B50': u':star:',
    u'\U0000262A': u':star_and_crescent:',
    u'\U00002721': u':star_of_david:',
    u'\U0001F320': u':stars:',
    u'\U0001F689': u':station:',
    u'\U0001F5FD': u':statue_of_liberty:',
    u'\U0001F682': u':steam_locomotive:',
    u'\U0001F35C': u':steaming_bowl:',
    u'\U0001F372': u':stew:',
    u'\U000023F1': u':stopwatch:',
    u'\U0001F4CF': u':straight_ruler:',
    u'\U0001F353': u':strawberry:',
    u'\U0001F61B': u':stuck_out_tongue:',
    u'\U0001F61D': u':stuck_out_tongue_closed_eyes:',
    u'\U0001F61C': u':stuck_out_tongue_winking_eye:',
    u'\U0001F399': u':studio_microphone:',
    u'\U000026C5': u':sun_behind_cloud:',
    u'\U0001F31E': u':sun_with_face:',
    u'\U0001F33B': u':sunflower:',
    u'\U0001F60E': u':sunglasses:',
    u'\U00002600': u':sunny:',
    u'\U0001F305': u':sunrise:',
    u'\U0001F304': u':sunrise_over_mountains:',
    u'\U0001F307': u':sunset_over_buildings:',
    u'\U0001F3C4': u':surfer:',
    u'\U0001F363': u':sushi:',
    u'\U0001F69F': u':suspension_railway:',
    u'\U0001F613': u':sweat:',
    u'\U0001F4A6': u':sweat_drops:',
    u'\U0001F605': u':sweat_smile:',
    u'\U0001F360': u':sweet_potato:',
    u'\U0001F3CA': u':swimmer:',
    u'\U0001F523': u':symbols:',
    u'\U0001F54D': u':synagogue:',
    u'\U0001F489': u':syringe:',
    u'\U0001F455': u':t-shirt:',
    u'\U0001F3D3': u':table_tennis_paddle_and_ball:',
    u'\U0001F32E': u':taco:',
    u'\U0001F389': u':tada:',
    u'\U0001F38B': u':tanabata_tree:',
    u'\U0001F34A': u':tangerine:',
    u'\U00002649': u':taurus:',
    u'\U0001F695': u':taxi:',
    u'\U0001F375': u':tea:',
    u'\U0001F375': u':teacup_without_handle:',
    u'\U0001F4C6': u':tear-off_calendar:',
    u'\U0000260E': u':telephone:',
    u'\U0001F4DE': u':telephone_receiver:',
    u'\U0001F52D': u':telescope:',
    u'\U0001F4FA': u':television:',
    u'\U0001F51F': u':ten:',
    u'\U0001F3BE': u':tennis:',
    u'\U0001F3BE': u':tennis_racquet_and_ball:',
    u'\U000026FA': u':tent:',
    u'\U0001F918': u':the_horns:',
    u'\U0001F321': u':thermometer:',
    u'\U0001F914': u':thinking_face:',
    u'\U0001F4AD': u':thought_balloon:',
    u'\U0001F5B1': u':three_button_mouse:',
    u'\U0001F44E': u':thumbs_down_sign:',
    u'\U0001F44D': u':thumbs_up_sign:',
    u'\U0001F44E': u':thumbsdown:',
    u'\U0001F44D': u':thumbsup:',
    u'\U000026C8': u':thunder_cloud_and_rain:',
    u'\U0001F3AB': u':ticket:',
    u'\U0001F405': u':tiger2:',
    u'\U0001F405': u':tiger:',
    u'\U0001F42F': u':tiger:',
    u'\U0001F42F': u':tiger_face:',
    u'\U000023F2': u':timer_clock:',
    u'\U0001F62B': u':tired_face:',
    u'\U00002122': u':tm:',
    u'\U0001F6BD': u':toilet:',
    u'\U0001F5FC': u':tokyo_tower:',
    u'\U0001F345': u':tomato:',
    u'\U0001F445': u':tongue:',
    u'\U0001F51D': u':top:',
    u'\U0001F3A9': u':top_hat:',
    u'\U0001F51D': u':top_with_upwards_arrow_above:',
    u'\U0001F3A9': u':tophat:',
    u'\U0001F32A': u':tornado:',
    u'\U0001F5B2': u':trackball:',
    u'\U0001F69C': u':tractor:',
    u'\U00002122': u':trade_mark_sign:',
    u'\U0001F6A5': u':traffic_light:',
    u'\U0001F686': u':train2:',
    u'\U0001F686': u':train:',
    u'\U0001F68B': u':train:',
    u'\U0001F68A': u':tram:',
    u'\U0001F68B': u':tram_car:',
    u'\U0001F6A9': u':triangular_flag_on_post:',
    u'\U0001F4D0': u':triangular_ruler:',
    u'\U0001F531': u':trident:',
    u'\U0001F531': u':trident_emblem:',
    u'\U0001F624': u':triumph:',
    u'\U0001F68E': u':trolleybus:',
    u'\U0001F3C6': u':trophy:',
    u'\U0001F379': u':tropical_drink:',
    u'\U0001F420': u':tropical_fish:',
    u'\U0001F69A': u':truck:',
    u'\U0001F3BA': u':trumpet:',
    u'\U0001F455': u':tshirt:',
    u'\U0001F337': u':tulip:',
    u'\U0001F983': u':turkey:',
    u'\U0001F422': u':turtle:',
    u'\U0001F4FA': u':tv:',
    u'\U0001F500': u':twisted_rightwards_arrows:',
    u'\U0001F495': u':two_hearts:',
    u'\U0001F46C': u':two_men_holding_hands:',
    u'\U0001F46D': u':two_women_holding_hands:',
    u'\U00002602': u':umbrella:',
    u'\U000026F1': u':umbrella_on_ground:',
    u'\U00002614': u':umbrella_with_rain_drops:',
    u'\U0001F612': u':unamused:',
    u'\U0001F612': u':unamused_face:',
    u'\U0001F51E': u':underage:',
    u'\U0001F984': u':unicorn_face:',
    u'\U0001F513': u':unlock:',
    u'\U0001F53A': u':up-pointing_red_triangle:',
    u'\U0001F53C': u':up-pointing_small_red_triangle:',
    u'\U0001F199': u':up:',
    u'\U00002195': u':up_down_arrow:',
    u'\U0001F643': u':upside-down_face:',
    u'\U0001F643': u':upside_down_face:',
    u'\U00002B06': u':upwards_black_arrow:',
    u'\U0000270C': u':v:',
    u'\U0001F6A6': u':vertical_traffic_light:',
    u'\U0001F4FC': u':vhs:',
    u'\U0001F4F3': u':vibration_mode:',
    u'\U0000270C': u':victory_hand:',
    u'\U0001F4F9': u':video_camera:',
    u'\U0001F3AE': u':video_game:',
    u'\U0001F4FC': u':videocassette:',
    u'\U0001F3BB': u':violin:',
    u'\U0000264D': u':virgo:',
    u'\U0001F30B': u':volcano:',
    u'\U0001F3D0': u':volleyball:',
    u'\U0001F19A': u':vs:',
    u'\U0001F6B6': u':walking:',
    u'\U0001F318': u':waning_crescent_moon:',
    u'\U0001F318': u':waning_crescent_moon_symbol:',
    u'\U0001F316': u':waning_gibbous_moon:',
    u'\U0001F316': u':waning_gibbous_moon_symbol:',
    u'\U000026A0': u':warning:',
    u'\U000026A0': u':warning_sign:',
    u'\U0001F5D1': u':wastebasket:',
    u'\U0000231A': u':watch:',
    u'\U0001F403': u':water_buffalo:',
    u'\U0001F6BE': u':water_closet:',
    u'\U0001F30A': u':water_wave:',
    u'\U0001F349': u':watermelon:',
    u'\U0001F44B': u':wave:',
    u'\U0001F3F4': u':waving_black_flag:',
    u'\U0001F44B': u':waving_hand_sign:',
    u'\U0001F3F3': u':waving_white_flag:',
    u'\U00003030': u':wavy_dash:',
    u'\U0001F312': u':waxing_crescent_moon:',
    u'\U0001F312': u':waxing_crescent_moon_symbol:',
    u'\U0001F314': u':waxing_gibbous_moon:',
    u'\U0001F314': u':waxing_gibbous_moon_symbol:',
    u'\U0001F6BE': u':wc:',
    u'\U0001F629': u':weary:',
    u'\U0001F640': u':weary_cat_face:',
    u'\U0001F629': u':weary_face:',
    u'\U0001F492': u':wedding:',
    u'\U0001F3CB': u':weight_lifter:',
    u'\U0001F40B': u':whale2:',
    u'\U0001F40B': u':whale:',
    u'\U0001F433': u':whale:',
    u'\U00002638': u':wheel_of_dharma:',
    u'\U0000267F': u':wheelchair:',
    u'\U0000267F': u':wheelchair_symbol:',
    u'\U00002705': u':white_check_mark:',
    u'\U000026AA': u':white_circle:',
    u'\U0001F447': u':white_down_pointing_backhand_index:',
    u'\U00002755': u':white_exclamation_mark_ornament:',
    u'\U0001F4AE': u':white_flower:',
    u'\U00002639': u':white_frowning_face:',
    u'\U00002705': u':white_heavy_check_mark:',
    u'\U00002B1C': u':white_large_square:',
    u'\U0001F448': u':white_left_pointing_backhand_index:',
    u'\U000025FD': u':white_medium_small_square:',
    u'\U000025FB': u':white_medium_square:',
    u'\U00002B50': u':white_medium_star:',
    u'\U00002754': u':white_question_mark_ornament:',
    u'\U0001F449': u':white_right_pointing_backhand_index:',
    u'\U000025AB': u':white_small_square:',
    u'\U0000263A': u':white_smiling_face:',
    u'\U0001F533': u':white_square_button:',
    u'\U0001F325': u':white_sun_behind_cloud:',
    u'\U0001F326': u':white_sun_behind_cloud_with_rain:',
    u'\U0001F324': u':white_sun_with_small_cloud:',
    u'\U0001F446': u':white_up_pointing_backhand_index:',
    u'\U0000261D': u':white_up_pointing_index:',
    u'\U0001F32C': u':wind_blowing_face:',
    u'\U0001F390': u':wind_chime:',
    u'\U0001F377': u':wine_glass:',
    u'\U0001F609': u':wink:',
    u'\U0001F609': u':winking_face:',
    u'\U0001F43A': u':wolf:',
    u'\U0001F43A': u':wolf_face:',
    u'\U0001F469': u':woman:',
    u'\U0001F46F': u':woman_with_bunny_ears:',
    u'\U0001F462': u':womans_boots:',
    u'\U0001F45A': u':womans_clothes:',
    u'\U0001F452': u':womans_hat:',
    u'\U0001F461': u':womans_sandal:',
    u'\U0001F6BA': u':womens:',
    u'\U0001F6BA': u':womens_symbol:',
    u'\U0001F5FA': u':world_map:',
    u'\U0001F61F': u':worried:',
    u'\U0001F61F': u':worried_face:',
    u'\U0001F381': u':wrapped_present:',
    u'\U0001F527': u':wrench:',
    u'\U0000270D': u':writing_hand:',
    u'\U0000274C': u':x:',
    u'\U0001F49B': u':yellow_heart:',
    u'\U0001F4B4': u':yen:',
    u'\U0000262F': u':yin_yang:',
    u'\U0001F60B': u':yum:',
    u'\U000026A1': u':zap:',
    u'\U0001F910': u':zipper-mouth_face:',
    u'\U0001F910': u':zipper_mouth_face:',
    u'\U0001F4A4': u':zzz:'
}

# Expressions taken from Martijn Pieters code at
# http://stackoverflow.com/questions/26568722/remove-unicode-emoji-using-re-in-python
try:
    # Wide UCS-4 build
    ALIAS_RE = re.compile(u'['u'\U0001F300-\U0001F64F'
                          u'\U0001F680-\U0001F6FF'
                          u'\u2600-\u26FF\u2700-\u27BF]+',
                          re.DOTALL | re.UNICODE)
except re.error:
    # Narrow UCS-2 build
    ALIAS_RE = re.compile(u'('u'\ud83c[\udf00-\udfff]|'
                          u'\ud83d[\udc00-\ude4f\ude80-\udeff]|'
                          u'[\u2600-\u26FF\u2700-\u27BF])+',
                          re.DOTALL | re.UNICODE)

def convert_emoji_to_aliases(data, modifier, modifier_data, string):
    string = unicode(string, "utf-8")
    emoji_found = ALIAS_RE.findall(string)
    for emoji in emoji_found:
        if emoji in EMOJI_ALIASES:
            string = string.replace(emoji, EMOJI_ALIASES[emoji])
    return string

if __name__ == "__main__" and import_ok:

    if w.register(SCRIPT_NAME, SCRIPT_AUTHOR, SCRIPT_VERSION, SCRIPT_LICENSE,
                  SCRIPT_DESC, "", "utf-8"):

        w.hook_modifier("irc_in_away", "convert_emoji_to_aliases", "")
        w.hook_modifier("irc_in_cnotice", "convert_emoji_to_aliases", "")
        w.hook_modifier("irc_in_cprivmsg", "convert_emoji_to_aliases", "")
        w.hook_modifier("irc_in_kick", "convert_emoji_to_aliases", "")
        w.hook_modifier("irc_in_knock", "convert_emoji_to_aliases", "")
        w.hook_modifier("irc_in_notice", "convert_emoji_to_aliases", "")
        w.hook_modifier("irc_in_part", "convert_emoji_to_aliases", "")
        w.hook_modifier("irc_in_privmsg", "convert_emoji_to_aliases", "")
        w.hook_modifier("irc_in_quit", "convert_emoji_to_aliases", "")
        w.hook_modifier("irc_in_wallops", "convert_emoji_to_aliases", "")

        # This intercepts outgoing emoji also
        #w.hook_modifier("input_text_for_buffer", "convert_emoji_to_aliases", "")
