/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.weirdx;

import com.jcraft.weirdx.Atom;
import com.jcraft.weirdx.Font;
import com.jcraft.weirdx.Font_CharSet;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;

class DDXFont {
    static Hashtable table = new Hashtable();
    byte[] lfname;
    java.awt.Font font;
    FontMetrics metric;
    int[] prop;
    int min_char_or_byte2 = 32;
    int max_char_or_byte2 = 255;
    int min_byte1 = 0;
    int max_byte1 = 0;
    int default_char = 32;
    int min_width;
    int max_width;
    String encoding = null;
    Font_CharSet charset = null;

    private static synchronized java.awt.Font getFont(String string, int n, int n2) {
        String string2 = string + n + n2;
        RefCount refCount = (RefCount)table.get(string2);
        if (refCount != null) {
            ++refCount.count;
            return refCount.font;
        }
        java.awt.Font font = new java.awt.Font(string, n, n2);
        refCount = new RefCount(string2, font);
        table.put(string2, refCount);
        return font;
    }

    private static synchronized void delFont(java.awt.Font font) {
        RefCount refCount = null;
        Enumeration enumeration = table.elements();
        while (enumeration.hasMoreElements()) {
            refCount = (RefCount)enumeration.nextElement();
            if (refCount.font != font) continue;
            --refCount.count;
            if (refCount.count == 0) {
                table.remove(refCount.key);
                refCount.font = null;
            }
            return;
        }
    }

    void delete() {
        DDXFont.delFont(this.font);
        this.font = null;
    }

    DDXFont() {
    }

    void init(byte[] byArray) throws UnsupportedEncodingException {
        if (this.encoding != null) {
            if (this.charset == null) {
                return;
            }
            int n = this.default_char;
            int n2 = 0;
            while (n != 0) {
                ++n2;
                n >>= 8;
                n &= 0xFFFFFF;
            }
            byte[] byArray2 = new byte[n2];
            n = this.default_char;
            --n2;
            while (n != 0) {
                byArray2[n2] = (byte)(n & 0xFF);
                n >>= 8;
                n &= 0xFFFFFF;
                --n2;
            }
            char[] cArray = new char[1];
            if (this.charset.encode(byArray2, 0, byArray2.length, cArray) == 0) {
                return;
            }
        }
        this.lfname = byArray;
    }

    java.awt.Font getFont() {
        Object object;
        int n;
        if (this.font != null) {
            return this.font;
        }
        int n2 = 12;
        try {
            n = Integer.parseInt(this.getFontSize());
            if (n != 0) {
                n2 = n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n = 0;
        if (this.getWeight().equals("bold")) {
            n |= 1;
        }
        if (this.getStyle().equals("i")) {
            n |= 2;
        }
        this.font = this.getFamily().equals("times") || this.getFamily().equals("times new roman") || this.getFamily().equals("new century schoolbook") ? DDXFont.getFont("Serif", n, n2) : (this.getFamily().equals("helvetica") || this.getFamily().equals("helvetic") || this.getFamily().equals("courier") ? DDXFont.getFont("SansSerif", n, n2) : DDXFont.getFont("Monospaced", n, n2));
        this.metric = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        String string = this.getCharsetRegistry();
        String string2 = this.getCharsetEncoding();
        Enumeration enumeration = Font.charSets.elements();
        while (enumeration.hasMoreElements()) {
            object = (Font_CharSet)enumeration.nextElement();
            if (!string.equals(object.getCharset()) && !string2.equals(object.getCharset())) continue;
            this.min_byte1 = object.getMinByte1();
            this.max_byte1 = object.getMaxByte1();
            this.min_char_or_byte2 = object.getMinCharOrByte2();
            this.max_char_or_byte2 = object.getMaxCharOrByte2();
            this.default_char = object.getDefaultChar();
            this.encoding = object.getEncoding();
            this.charset = object;
            break;
        }
        this.min_width = this.getMaxAdvance();
        this.max_width = this.getMaxAdvance();
        if (this.encoding != null) {
            int n3 = this.default_char;
            int n4 = 0;
            while (n3 != 0) {
                ++n4;
                n3 >>= 8;
                n3 &= 0xFFFFFF;
            }
            byte[] byArray = new byte[n4];
            n3 = this.default_char;
            --n4;
            while (n3 != 0) {
                byArray[n4] = (byte)(n3 & 0xFF);
                n3 >>= 8;
                n3 &= 0xFFFFFF;
                --n4;
            }
            char[] cArray = new char[1];
            if (this.charset != null) {
                this.charset.encode(byArray, 0, byArray.length, cArray);
            }
            this.max_width = this.min_width = this.metric.charWidth(cArray[0]);
            if (this.getSpace().equals("p")) {
                this.min_width = 0;
            }
        } else {
            object = new char[1];
            object[0] = 64;
            this.max_width = this.metric.charsWidth((char[])object, 0, 1);
            object[0] = 32;
            this.min_width = this.metric.charsWidth((char[])object, 0, 1);
        }
        return this.font;
    }

    int[] getProp() {
        if (this.prop == null) {
            this.initprop();
        }
        return this.prop;
    }

    void initprop() {
        this.prop = new int[2];
        this.prop[0] = Atom.make("FONT", true);
        this.prop[1] = Atom.make(new String(this.lfname), true);
    }

    int getAscent() {
        return this.metric.getAscent();
    }

    int getDescent() {
        return this.metric.getDescent();
    }

    int getLeading() {
        return this.metric.getLeading();
    }

    int getHeight() {
        return this.metric.getHeight();
    }

    int getMaxAdvance() {
        return this.metric.charWidth('@');
    }

    int getMaxAscent() {
        return this.metric.getAscent();
    }

    int getMaxDescent() {
        return this.metric.getDescent();
    }

    int[] getWidths() {
        return this.metric.getWidths();
    }

    int charWidth(char c) {
        return this.metric.charWidth(c);
    }

    String getFamily() {
        return this.chop(1);
    }

    String getWeight() {
        return this.chop(2);
    }

    String getStyle() {
        return this.chop(3);
    }

    String getFontSize() {
        return this.chop(6);
    }

    String getSpace() {
        return this.chop(10);
    }

    String getCharsetRegistry() {
        return this.chop(12);
    }

    String getCharsetEncoding() {
        return this.chop(13);
    }

    private String chop(int n) {
        int n2 = 1;
        while (n != 0) {
            n2 = this.skip(n2);
            ++n2;
            --n;
        }
        int n3 = this.skip(n2);
        return new String(this.lfname, n2, n3 - n2);
    }

    private int skip(int n) {
        while (n < this.lfname.length && this.lfname[n] != 45) {
            ++n;
        }
        return n;
    }

    boolean getScalable() {
        int n = 0;
        try {
            n = Integer.parseInt(this.getFontSize());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n == 0;
    }

    DDXFont getScalableFont(byte[] byArray) {
        DDXFont dDXFont = null;
        try {
            dDXFont = new DDXFont();
            dDXFont.init(Font.genScaleName(this.lfname, byArray));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dDXFont;
    }

    static class RefCount {
        int count = 1;
        String key = null;
        java.awt.Font font = null;

        RefCount(String string, java.awt.Font font) {
            this.key = string;
            this.font = font;
        }
    }
}

