/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.weirdx;

import com.jcraft.weirdx.Client;
import com.jcraft.weirdx.Clip;
import com.jcraft.weirdx.ClipPixmap;
import com.jcraft.weirdx.ClipRectangles;
import com.jcraft.weirdx.Drawable;
import com.jcraft.weirdx.Font;
import com.jcraft.weirdx.IO;
import com.jcraft.weirdx.Pix;
import com.jcraft.weirdx.Pixmap;
import com.jcraft.weirdx.Resource;
import java.io.IOException;

final class GC
extends Resource {
    static final byte GXclear = 0;
    static final byte GXand = 1;
    static final byte GXandReverse = 2;
    static final byte GXcopy = 3;
    static final byte GXandInverted = 4;
    static final byte GXnoop = 5;
    static final byte GXxor = 6;
    static final byte GXor = 7;
    static final byte GXnor = 8;
    static final byte GXequiv = 9;
    static final byte GXinvert = 10;
    static final byte GXorReverse = 11;
    static final byte GXcopyInverted = 12;
    static final byte GXorInverted = 13;
    static final byte GXnand = 14;
    static final byte GXset = 15;
    static final int lineStyleOffset = 0;
    static final int lineStyle = 3;
    static final int LineSolid = 0;
    static final int LineOnOffDash = 1;
    static final int LineDoubleDash = 2;
    static final int capStyleOffset = 2;
    static final int capStyle = 12;
    static final int CapNotLast = 0;
    static final int CapButt = 4;
    static final int CapRound = 8;
    static final int CapProjecting = 12;
    static final int joinStyleOffset = 4;
    static final int joinStyle = 48;
    static final int JoinMiter = 0;
    static final int JoinRound = 16;
    static final int JoinBevel = 32;
    static final int fillStyleOffset = 6;
    static final int fillStyle = 192;
    static final int FillSolid = 0;
    static final int FillTiled = 64;
    static final int FillStippled = 128;
    static final int FillOpaqueStippled = 192;
    static final int fillRuleOffset = 8;
    static final int fillRule = 256;
    static final int EvenOddRule = 0;
    static final int WindingRule = 256;
    static final int arcModeOffset = 9;
    static final int arcMode = 512;
    static final int ArcChord = 0;
    static final int ArcPieSlice = 512;
    static final int subWindowModeOffset = 10;
    static final int subWindowMode = 1024;
    static final int ClipByChildren = 0;
    static final int IncludeInferiors = 1024;
    static final int graphicsExposuresOffset = 11;
    static final int graphicsExposures = 2048;
    static final int tileIsPixelOffset = 15;
    static final int tileIsPixel = 32768;
    static final int GCFunction = 1;
    static final int GCPlaneMask = 2;
    static final int GCForeground = 4;
    static final int GCBackground = 8;
    static final int GCLineWidth = 16;
    static final int GCLineStyle = 32;
    static final int GCCapStyle = 64;
    static final int GCJoinStyle = 128;
    static final int GCFillStyle = 256;
    static final int GCFillRule = 512;
    static final int GCTile = 1024;
    static final int GCStipple = 2048;
    static final int GCTileStipXOrigin = 4096;
    static final int GCTileStipYOrigin = 8192;
    static final int GCFont = 16384;
    static final int GCSubwindowMode = 32768;
    static final int GCGraphicsExposures = 65536;
    static final int GCClipXOrigin = 131072;
    static final int GCClipYOrigin = 262144;
    static final int GCClipMask = 524288;
    static final int GCDashOffset = 0x100000;
    static final int GCDashList = 0x200000;
    static final int GCArcMode = 0x400000;
    static final int CT_NONE = 0;
    static final int CT_PIXMAP = 1;
    static final int CT_REGION = 2;
    static final int CT_UNSORTED = 6;
    static final int CT_YSORTED = 10;
    static final int CT_YXSORTED = 14;
    static final int CT_YXBANDED = 18;
    Drawable drawable;
    Font font;
    short lineWidth;
    byte function;
    float[] dash;
    float dash_phase;
    int attr;
    int time;
    Pix tile;
    Pixmap stipple;
    short tile_stipple_x_origin;
    short tile_stipple_y_origin;
    int clip_x_origin;
    int clip_y_origin;
    Clip clip_mask;
    int fgPixel;
    int bgPixel;
    private static GC[] pool = new GC[32];
    private static boolean full = false;

    GC(int n, Drawable drawable) {
        super(n, -2147483645);
        this.drawable = drawable;
        this.init();
    }

    private void init() {
        this.font = Font.dflt;
        this.lineWidth = 1;
        this.function = (byte)3;
        this.dash = null;
        this.dash_phase = 0.0f;
        this.attr = 2564;
        this.time = 0;
        this.tile = new Pix();
        this.stipple = null;
        this.tile_stipple_x_origin = 0;
        this.tile_stipple_y_origin = 0;
        this.clip_x_origin = 0;
        this.clip_y_origin = 0;
        this.clip_mask = null;
        this.fgPixel = 0;
        this.bgPixel = 1;
    }

    static void reqSetDashes(Client client) throws IOException {
        IO iO = client.client;
        int n = client.length;
        int n2 = iO.readInt();
        client.length -= 2;
        GC gC = client.lookupGC(n2);
        if (gC == null) {
            client.errorValue = n2;
            client.errorReason = 13;
            return;
        }
        n2 = iO.readShort();
        gC.dash_phase = n2;
        n2 = iO.readShort();
        if (n2 == 0) {
            gC.dash = null;
            return;
        }
        gC.dash = new float[n2];
        n -= 3;
        n *= 4;
        int n3 = 0;
        while (n3 < n2) {
            gC.dash[n3] = iO.readByte();
            --n;
            ++n3;
        }
        if (n > 0) {
            iO.readPad(n);
        }
        gC.time = 0;
    }

    static void reqSetClipRectangles(Client client) throws IOException {
        IO iO = client.client;
        int n = client.data;
        int n2 = client.length;
        int n3 = iO.readInt();
        client.length -= 2;
        GC gC = client.lookupGC(n3);
        if (gC == null) {
            client.errorValue = n3;
            client.errorReason = 13;
            return;
        }
        gC.clip_x_origin = iO.readShort();
        gC.clip_y_origin = iO.readShort();
        --client.length;
        n2 -= 3;
        ClipRectangles clipRectangles = null;
        if (gC.clip_mask != null && gC.clip_mask instanceof ClipPixmap) {
            try {
                ((Pixmap)gC.clip_mask.getMask()).delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            gC.clip_mask = null;
        }
        if (clipRectangles == null) {
            clipRectangles = new ClipRectangles(n, n2 / 2);
            gC.clip_mask = clipRectangles;
        }
        while (n2 != 0) {
            short s = (short)iO.readShort();
            short s2 = (short)iO.readShort();
            int n4 = iO.readShort();
            int n5 = iO.readShort();
            n2 -= 2;
            clipRectangles.add(s, s2, n4, n5);
        }
        clipRectangles.validate();
        client.length = 0;
    }

    static void reqFreeGC(Client client) throws IOException {
        IO iO = client.client;
        int n = iO.readInt();
        client.length -= 2;
        GC gC = client.lookupGC(n);
        if (gC == null) {
            client.errorValue = n;
            client.errorReason = 13;
            return;
        }
        Resource.freeResource(n, 0);
    }

    void delete() throws IOException {
        this.dash = null;
        if (this.stipple != null) {
            try {
                this.stipple.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.stipple = null;
        }
        if (this.clip_mask != null) {
            try {
                if (this.clip_mask instanceof ClipPixmap) {
                    ((Pixmap)this.clip_mask.getMask()).delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clip_mask = null;
        }
        if (this.tile.pixmap != null) {
            try {
                this.tile.pixmap.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tile.pixmap = null;
            this.tile = null;
        }
        GC.put(this);
    }

    static void reqCopyGC(Client client) throws IOException {
        IO iO = client.client;
        int n = iO.readInt();
        client.length -= 2;
        GC gC = client.lookupGC(n);
        if (gC == null) {
            client.errorValue = n;
            client.errorReason = 13;
            return;
        }
        n = iO.readInt();
        --client.length;
        GC gC2 = client.lookupGC(n);
        if (gC2 == null) {
            client.errorValue = n;
            client.errorReason = 13;
            return;
        }
        int n2 = iO.readInt();
        --client.length;
        gC2.copyAttr(client, n2 &= 0x7FFFFF, gC);
    }

    static void reqChangeGC(Client client) throws IOException {
        IO iO = client.client;
        int n = client.length;
        int n2 = iO.readInt();
        client.length -= 2;
        GC gC = client.lookupGC(n2);
        if (gC == null) {
            client.errorValue = n2;
            client.errorReason = 13;
            return;
        }
        n2 = iO.readInt();
        --client.length;
        if ((n2 &= 0x7FFFFF) != 0) {
            gC.changeAttr(client, n2);
        }
    }

    static void reqCreateGC(Client client) throws IOException {
        IO iO = client.client;
        int n = iO.readInt();
        int n2 = iO.readInt();
        client.length -= 3;
        Drawable drawable = client.lookupDrawable(n2);
        if (drawable == null) {
            client.errorValue = n2;
            client.errorReason = 9;
            return;
        }
        int n3 = iO.readInt();
        --client.length;
        GC gC = GC.getGC(n, drawable);
        if ((n3 &= 0x7FFFFF) != 0) {
            gC.changeAttr(client, n3);
        }
        Resource.add(gC);
    }

    private void copyAttr(Client client, int n, GC gC) throws IOException {
        int n2 = 0;
        int n3 = n;
        while (n3 != 0) {
            n2 = GC.lowbit(n3);
            n3 &= ~n2;
            switch (n2) {
                case 1: {
                    this.function = gC.function;
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    this.fgPixel = gC.fgPixel;
                    if ((this.attr & 0x8000) != 0 || this.tile.pixmap != null) break;
                    this.attr |= 0x8000;
                    this.tile.pixel = this.fgPixel;
                    break;
                }
                case 8: {
                    this.bgPixel = gC.bgPixel;
                    break;
                }
                case 16: {
                    this.lineWidth = gC.lineWidth;
                    break;
                }
                case 32: {
                    this.attr &= 0xFFFFFFFC;
                    this.attr |= gC.attr & 3;
                    break;
                }
                case 64: {
                    this.attr &= 0xFFFFFFF3;
                    this.attr |= gC.attr & 0xC;
                    break;
                }
                case 128: {
                    this.attr &= 0xFFFFFFCF;
                    this.attr |= gC.attr & 0x30;
                    break;
                }
                case 256: {
                    this.attr &= 0xFFFFFF3F;
                    this.attr |= gC.attr & 0xC0;
                    break;
                }
                case 512: {
                    this.attr &= 0xFFFFFEFF;
                    this.attr |= gC.attr & 0x100;
                    break;
                }
                case 1024: {
                    if ((gC.attr & 0x8000) != 0) {
                        this.tile.pixel = gC.tile.pixel;
                        break;
                    }
                    this.tile.pixmap = gC.tile.pixmap;
                    break;
                }
                case 2048: {
                    if (this.stipple != null) {
                        try {
                            this.stipple.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.stipple = null;
                    }
                    this.stipple = gC.stipple;
                    if (this.stipple == null) break;
                    this.stipple.ref();
                    break;
                }
                case 4096: {
                    this.tile_stipple_x_origin = gC.tile_stipple_x_origin;
                    break;
                }
                case 8192: {
                    this.tile_stipple_y_origin = gC.tile_stipple_y_origin;
                    break;
                }
                case 16384: {
                    this.font = gC.font;
                    break;
                }
                case 32768: {
                    this.attr &= 0xFFFFFBFF;
                    this.attr |= gC.attr & 0x400;
                    break;
                }
                case 65536: {
                    this.attr &= 0xFFFFF7FF;
                    this.attr |= gC.attr & 0x800;
                    break;
                }
                case 131072: {
                    this.clip_x_origin = gC.clip_x_origin;
                    break;
                }
                case 262144: {
                    this.clip_y_origin = gC.clip_y_origin;
                    break;
                }
                case 524288: {
                    if (this.clip_mask != null) {
                        try {
                            if (this.clip_mask instanceof ClipPixmap) {
                                ((Pixmap)this.clip_mask.getMask()).delete();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.clip_mask = null;
                    }
                    this.clip_mask = gC.clip_mask;
                    if (this.clip_mask == null || !(this.clip_mask instanceof ClipPixmap)) break;
                    ((Pixmap)this.clip_mask.getMask()).ref();
                    break;
                }
                case 0x100000: {
                    this.dash_phase = gC.dash_phase;
                    break;
                }
                case 0x200000: {
                    this.dash = gC.dash;
                    if (this.dash == null) break;
                    float[] fArray = new float[this.dash.length];
                    System.arraycopy(this.dash, 0, fArray, 0, fArray.length);
                    this.dash = fArray;
                    break;
                }
                case 0x400000: {
                    break;
                }
                default: {
                    client.errorValue = n;
                    client.errorReason = 2;
                }
            }
            if (client.errorReason == 0) continue;
            return;
        }
        if (client.length != 0) {
            client.errorValue = n;
            client.errorReason = 2;
        } else {
            this.time = client.seq;
        }
    }

    private void changeAttr(Client client, int n) throws IOException {
        int n2 = 0;
        int n3 = n;
        IO iO = client.client;
        while (n3 != 0) {
            n2 = GC.lowbit(n3);
            n3 &= ~n2;
            --client.length;
            switch (n2) {
                case 1: {
                    int n4 = iO.readInt();
                    this.function = (byte)(n4 &= 0xFF);
                    break;
                }
                case 2: {
                    int n4 = iO.readInt();
                    break;
                }
                case 4: {
                    int n4;
                    this.fgPixel = n4 = iO.readInt();
                    if ((this.attr & 0x8000) != 0 || this.tile.pixmap != null) break;
                    this.attr |= 0x8000;
                    this.tile.pixel = this.fgPixel;
                    break;
                }
                case 8: {
                    this.bgPixel = iO.readInt();
                    break;
                }
                case 16: {
                    int n4 = iO.readInt();
                    if ((n4 &= 0xFFFF) == 0) {
                        n4 = 1;
                    }
                    this.lineWidth = (short)n4;
                    break;
                }
                case 32: {
                    int n4 = iO.readInt();
                    n4 &= 0xFF;
                    n4 = n4 << 0 & 3;
                    if (n4 != 0 && n4 != 1 && n4 != 2) {
                        client.errorValue = n4 >> 0;
                        client.errorReason = 2;
                        break;
                    }
                    this.attr &= 0xFFFFFFFC;
                    this.attr |= n4;
                    break;
                }
                case 64: {
                    int n4 = iO.readInt();
                    n4 &= 0xFF;
                    n4 = n4 << 2 & 0xC;
                    if (n4 != 0 && n4 != 4 && n4 != 8 && n4 != 12) {
                        client.errorValue = n4 >> 2;
                        client.errorReason = 2;
                        break;
                    }
                    this.attr |= n4;
                    break;
                }
                case 128: {
                    int n4 = iO.readInt();
                    n4 &= 0xFF;
                    n4 = n4 << 4 & 0x30;
                    if (n4 != 0 && n4 != 16 && n4 != 32) {
                        client.errorValue = n4 >> 4;
                        client.errorReason = 2;
                        break;
                    }
                    this.attr |= n4;
                    break;
                }
                case 256: {
                    int n4 = iO.readInt();
                    this.attr = this.attr & 0xFFFFFF3F | (n4 &= 0xFF) << 6;
                    break;
                }
                case 512: {
                    int n4 = iO.readInt();
                    n4 &= 0xFF;
                    break;
                }
                case 1024: {
                    Pixmap pixmap;
                    int n4 = iO.readInt();
                    Resource resource = Resource.lookupIDByType(n4, -1073741822);
                    if (resource != null && resource instanceof Pixmap) {
                        pixmap = (Pixmap)resource;
                        if (pixmap.depth != this.drawable.depth || pixmap.screen != this.drawable.screen) {
                            client.errorValue = n4;
                            client.errorReason = 8;
                            break;
                        }
                        if (this.tile.pixmap != null) {
                            try {
                                this.tile.pixmap.delete();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.tile.pixmap = pixmap;
                        this.tile.pixmap.ref();
                        this.attr &= 0xFFFF7FFF;
                        break;
                    }
                    client.errorValue = n4;
                    client.errorReason = 2;
                    break;
                }
                case 2048: {
                    Pixmap pixmap;
                    int n4 = iO.readInt();
                    Resource resource = Resource.lookupIDByType(n4, -1073741822);
                    if (resource != null && resource instanceof Pixmap) {
                        pixmap = (Pixmap)resource;
                        if (pixmap.depth != 1 || pixmap.screen != this.drawable.screen) {
                            client.errorValue = n4;
                            client.errorReason = 8;
                            break;
                        }
                        if (this.stipple != null) {
                            try {
                                this.stipple.delete();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.stipple = pixmap;
                        this.stipple.ref();
                        break;
                    }
                    client.errorValue = n4;
                    client.errorReason = 2;
                    break;
                }
                case 4096: {
                    int n4 = iO.readInt();
                    this.tile_stipple_x_origin = (short)(n4 & 0xFFFF);
                    break;
                }
                case 8192: {
                    int n4 = iO.readInt();
                    this.tile_stipple_y_origin = (short)(n4 & 0xFFFF);
                    break;
                }
                case 16384: {
                    int n4 = iO.readInt();
                    this.font = (Font)Resource.lookupIDByType(n4, 4);
                    if (this.font != null) break;
                    break;
                }
                case 32768: {
                    int n4 = iO.readInt();
                    if ((n4 &= 0xFF) == 0 || n4 != 1) {
                        // empty if block
                    }
                    this.attr &= 0xFFFFFBFF;
                    if (n4 != 1) break;
                    this.attr |= 0x400;
                    break;
                }
                case 65536: {
                    int n4 = iO.readInt();
                    if ((n4 &= 0xFF) == 1) {
                        this.attr |= 0x800;
                    }
                    if (n4 != 0) break;
                    this.attr &= 0xFFFFF7FF;
                    break;
                }
                case 131072: {
                    int n4 = iO.readInt();
                    this.clip_x_origin = (short)(n4 & 0xFFFF);
                    break;
                }
                case 262144: {
                    int n4 = iO.readInt();
                    this.clip_y_origin = (short)(n4 & 0xFFFF);
                    break;
                }
                case 524288: {
                    int n4 = iO.readInt();
                    if (n4 == 0) {
                        if (this.clip_mask != null) {
                            try {
                                if (this.clip_mask instanceof ClipPixmap) {
                                    ((Pixmap)this.clip_mask.getMask()).delete();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.clip_mask = null;
                        break;
                    }
                    Resource resource = client.lookupDrawable(n4);
                    if (resource == null || !(resource instanceof Pixmap) || ((Drawable)resource).depth != 1) {
                        client.errorValue = n4;
                        client.errorReason = 8;
                        break;
                    }
                    if (this.clip_mask != null) {
                        try {
                            if (this.clip_mask instanceof ClipPixmap) {
                                ((Pixmap)this.clip_mask.getMask()).delete();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ((Pixmap)resource).ref();
                    this.clip_mask = new ClipPixmap((Pixmap)resource);
                    break;
                }
                case 0x100000: {
                    int n4 = iO.readInt();
                    n4 &= 0xFFFF;
                    break;
                }
                case 0x200000: {
                    int n4 = iO.readInt();
                    n4 &= 0xFF;
                    break;
                }
                case 0x400000: {
                    int n4 = iO.readInt();
                    n4 &= 0xFF;
                    break;
                }
                default: {
                    ++client.length;
                    client.errorValue = n;
                    client.errorReason = 2;
                }
            }
            if (client.errorReason == 0) continue;
            return;
        }
        if (client.length != 0) {
            client.errorValue = n;
            client.errorReason = 2;
        } else {
            this.time = client.seq;
        }
    }

    private static int lowbit(int n) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < 32) {
            if ((n & 1) == 1) {
                n2 <<= n3;
                break;
            }
            n >>= 1;
            ++n3;
        }
        return n2;
    }

    private static GC getGC(int n, Drawable drawable) {
        GC gC = GC.get();
        if (gC == null) {
            return new GC(n, drawable);
        }
        gC.id = n;
        gC.drawable = drawable;
        gC.init();
        return gC;
    }

    private static synchronized GC get() {
        GC gC = null;
        if (full) {
            full = false;
        }
        int n = 0;
        while (n < 32) {
            if (pool[n] != null) {
                gC = pool[n];
                GC.pool[n] = null;
                break;
            }
            ++n;
        }
        return gC;
    }

    private static synchronized void put(GC gC) {
        if (full) {
            return;
        }
        int n = 0;
        while (n < 32) {
            if (pool[n] == null) {
                GC.pool[n] = gC;
                return;
            }
            ++n;
        }
        full = true;
    }
}

