/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.mockito.internal.util.reflection.AccessibilityChanger;
import org.mockito.internal.util.reflection.FieldCopier;

public class LenientCopyTool {
    FieldCopier fieldCopier = new FieldCopier();

    public <T> void copyToMock(T from, T mock) {
        this.copy(from, mock, from.getClass());
    }

    public <T> void copyToRealObject(T from, T to) {
        this.copy(from, to, from.getClass());
    }

    private <T> void copy(T from, T to, Class<?> fromClazz) {
        while (fromClazz != Object.class) {
            this.copyValues(from, to, fromClazz);
            fromClazz = fromClazz.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void copyValues(T from, T mock, Class<?> classFrom) {
        Field[] fields;
        for (Field field : fields = classFrom.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            AccessibilityChanger accessibilityChanger = new AccessibilityChanger();
            try {
                accessibilityChanger.enableAccess(field);
                this.fieldCopier.copyValue(from, mock, field);
            }
            catch (Throwable throwable) {
            }
            finally {
                accessibilityChanger.safelyDisableAccess(field);
            }
        }
    }
}

