
#include <fli.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h> 

int fli_parse_geometry (char const *geom, int *xp, int *yp, int *wp, int *hp)
{
    int
	x, y, w, h;		/* parsed width/height/x/y */ 
    char
	xsign [1],
	ysign [1];

    /* match 30x100+123+456 or - instead of + */ 
    if (sscanf (geom, "%dx%d%1[-+]%d%1[-+]%d",
		&w, &h, xsign, &x, ysign, &y) == 6)
    {
	if (xsign [0] == '-')
	    x = -x;
	if (ysign [0] == '-')
	    y = -y;
	*wp = w;
	*hp = h;
	*xp = x;
	*yp = y;
	return (FLI_WHXY_PARSED);
    }

    /* match 30x100 */ 
    if (sscanf (geom, "%dx%d", &w, &h) == 2)
    {
	*wp = w;
	*hp = h;
	return (FLI_WH_PARSED);
    }

    /* match +400+600 or - instead of + */ 
    if (sscanf (geom, "%1[-+]%d%1[-+]%d", xsign, &x, ysign, &y) == 4)
    {
	if (xsign [0] == '-')
	    x = -x;
	if (ysign [0] == '-')
	    y = -y;
	*xp = x;
	*yp = y;
	return (FLI_XY_PARSED);
    }

    /* all failed */
    return (0);
}
    
