#!/usr/bin/python

import regex, socket, sys
from Tkinter import *

error = "fingerError"

def finger(user, host):
    fingerPort = socket.getservbyname('finger', 'tcp')
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.connect((host, fingerPort))
    fp = sock.makefile("r+")
    fp.write(user + "\r\n")
    fp.flush()
    return fp.read()

def parseQuery(query):
    rx = regex.compile("^\([^ \t@]+\)?\(@\([^ \t]+\)\)?$")
    if rx.match(query) > 0:
	user, host = rx.group(1, 3)
	if not user: user = ""
	if not host: host = "localhost"
	return (user, host)
    else:
	raise error, "Bad address format."

class Finger(Frame):
    def __init__ 
    
if __name__ == '__main__':
    if len(sys.argv) > 1:
	for query in sys.argv[1:]:
	    user, host = parseQuery(query)
	    print "[%s]" % host
	    print finger(user, host)
    else:
	print "[localhost]"
	print finger("", "localhost")

