/*
** Zabbix
** Copyright (C) 2001-2020 Zabbix SIA
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#ifndef ZABBIX_SYSINFO_COMMON_DIR_H
#define ZABBIX_SYSINFO_COMMON_DIR_H

#include "sysinfo.h"

#define DISK_BLOCK_SIZE			512	/* 512-byte blocks */

#define SIZE_MODE_APPARENT		0	/* bytes in file */
#define SIZE_MODE_DISK			1	/* size on disk */

#define TRAVERSAL_DEPTH_UNLIMITED	-1	/* directory traversal depth is not limited */

typedef struct
{
	int depth;
	char *path;
} zbx_directory_item_t;

typedef struct
{
	zbx_uint64_t st_dev;			/* device */
	zbx_uint64_t st_ino;			/* file serial number */
} zbx_file_descriptor_t;

int	VFS_DIR_SIZE(AGENT_REQUEST *request, AGENT_RESULT *result);
int	VFS_DIR_COUNT(AGENT_REQUEST *request, AGENT_RESULT *result);

#endif /* ZABBIX_SYSINFO_COMMON_DIR_H */
